/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.model;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.model.Point;
import org.maplibre.geojson.serializer.BoundingBoxSerializer;
import org.maplibre.geojson.utils.JsonKt;

@Serializable(with=BoundingBoxSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006BA\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/maplibre/geojson/model/BoundingBox;", "", "southwest", "Lorg/maplibre/geojson/model/Point;", "northeast", "<init>", "(Lorg/maplibre/geojson/model/Point;Lorg/maplibre/geojson/model/Point;)V", "west", "", "south", "east", "north", "southwestAltitude", "northEastAltitude", "(DDDDLjava/lang/Double;Ljava/lang/Double;)V", "getSouthwest", "()Lorg/maplibre/geojson/model/Point;", "getNortheast", "getWest", "()D", "getSouth", "getEast", "getNorth", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "services-geojson"})
public class BoundingBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Point southwest;
    @NotNull
    private final Point northeast;

    public BoundingBox(@NotNull Point southwest, @NotNull Point northeast) {
        Intrinsics.checkNotNullParameter((Object)southwest, (String)"southwest");
        Intrinsics.checkNotNullParameter((Object)northeast, (String)"northeast");
        this.southwest = southwest;
        this.northeast = northeast;
    }

    @NotNull
    public final Point getSouthwest() {
        return this.southwest;
    }

    @NotNull
    public final Point getNortheast() {
        return this.northeast;
    }

    @JvmOverloads
    public BoundingBox(double west, double south, double east, double north, @Nullable Double southwestAltitude, @Nullable Double northEastAltitude) {
        this(new Point(west, south, southwestAltitude, null, 8, null), new Point(east, north, northEastAltitude, null, 8, null));
    }

    public /* synthetic */ BoundingBox(double d, double d2, double d3, double d4, Double d5, Double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d5 = null;
        }
        if ((n & 0x20) != 0) {
            d6 = null;
        }
        this(d, d2, d3, d4, d5, d6);
    }

    public final double getWest() {
        return this.southwest.getLongitude();
    }

    public final double getSouth() {
        return this.southwest.getLatitude();
    }

    public final double getEast() {
        return this.northeast.getLongitude();
    }

    public final double getNorth() {
        return this.northeast.getLatitude();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BoundingBox cfr_ignored_0 = (BoundingBox)other;
        if (!Intrinsics.areEqual((Object)this.southwest, (Object)((BoundingBox)other).southwest)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.northeast, (Object)((BoundingBox)other).northeast);
    }

    public int hashCode() {
        int result = this.southwest.hashCode();
        result = 31 * result + this.northeast.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "BoundingBox(southwest=" + this.southwest + ", northeast=" + this.northeast + ")";
    }

    @JvmOverloads
    public BoundingBox(double west, double south, double east, double north, @Nullable Double southwestAltitude) {
        this(west, south, east, north, southwestAltitude, null, 32, null);
    }

    @JvmOverloads
    public BoundingBox(double west, double south, double east, double north) {
        this(west, south, east, north, null, null, 48, null);
    }

    @JvmStatic
    @NotNull
    public static final BoundingBox fromJson(@NotNull String jsonString) {
        return Companion.fromJson(jsonString);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/maplibre/geojson/model/BoundingBox$Companion;", "", "<init>", "()V", "fromJson", "Lorg/maplibre/geojson/model/BoundingBox;", "jsonString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "services-geojson"})
    @SourceDebugExtension(value={"SMAP\nBoundingBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundingBox.kt\norg/maplibre/geojson/model/BoundingBox$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,136:1\n147#2:137\n*S KotlinDebug\n*F\n+ 1 BoundingBox.kt\norg/maplibre/geojson/model/BoundingBox$Companion\n*L\n133#1:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BoundingBox fromJson(@NotNull String jsonString) {
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            Json this_$iv = JsonKt.getJson();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            return (BoundingBox)this_$iv.decodeFromString((DeserializationStrategy)Companion.serializer(), jsonString);
        }

        @NotNull
        public final KSerializer<BoundingBox> serializer() {
            return new BoundingBoxSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

