/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.BoundingBox;
import org.maplibre.geojson.CoordinateContainer;
import org.maplibre.geojson.common.CommonExtKt;

@Deprecated(message="Use new common models instead.", replaceWith=@ReplaceWith(expression="Point", imports={"org.maplibre.geojson.model.Point"}))
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002:\u0001\u0013B+\b\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/maplibre/geojson/Point;", "Lorg/maplibre/geojson/model/Point;", "Lorg/maplibre/geojson/CoordinateContainer;", "", "", "type", "", "bbox", "Lorg/maplibre/geojson/BoundingBox;", "coordinates", "<init>", "(Ljava/lang/String;Lorg/maplibre/geojson/BoundingBox;Ljava/util/List;)V", "getType", "()Ljava/lang/String;", "longitude", "latitude", "altitude", "hasAltitude", "", "Companion", "services-geojson"})
public final class Point
extends org.maplibre.geojson.model.Point
implements CoordinateContainer<List<? extends Double>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String type;
    @NotNull
    private static final String TYPE = "Point";

    public Point(@Nullable String type, @Nullable BoundingBox bbox, @NotNull List<Double> coordinates) {
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        super(coordinates, bbox);
        this.type = type;
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    public final double longitude() {
        return this.getLongitude();
    }

    public final double latitude() {
        return this.getLatitude();
    }

    public final double altitude() {
        Double d = this.getAltitude();
        return d != null ? d : Double.NaN;
    }

    public final boolean hasAltitude() {
        return this.getAltitude() != null;
    }

    @Override
    @NotNull
    public String type() {
        String string = this.type;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        org.maplibre.geojson.model.BoundingBox boundingBox = this.getBbox();
        return boundingBox != null ? CommonExtKt.toJvm(boundingBox) : null;
    }

    @Override
    @NotNull
    public List<Double> coordinates() {
        return this.getCoordinates();
    }

    @JvmStatic
    @NotNull
    public static final Point fromJson(@NotNull String json) {
        return Companion.fromJson(json);
    }

    @JvmStatic
    @NotNull
    public static final Point fromLngLat(double longitude, double latitude) {
        return Companion.fromLngLat(longitude, latitude);
    }

    @JvmStatic
    @NotNull
    public static final Point fromLngLat(double longitude, double latitude, @Nullable BoundingBox bbox) {
        return Companion.fromLngLat(longitude, latitude, bbox);
    }

    @JvmStatic
    @NotNull
    public static final Point fromLngLat(double longitude, double latitude, double altitude) {
        return Companion.fromLngLat(longitude, latitude, altitude);
    }

    @JvmStatic
    @NotNull
    public static final Point fromLngLat(double longitude, double latitude, double altitude, @Nullable BoundingBox bbox) {
        return Companion.fromLngLat(longitude, latitude, altitude, bbox);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\"\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J \u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J*\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/maplibre/geojson/Point$Companion;", "", "<init>", "()V", "TYPE", "", "fromJson", "Lorg/maplibre/geojson/Point;", "json", "fromLngLat", "longitude", "", "latitude", "bbox", "Lorg/maplibre/geojson/BoundingBox;", "altitude", "coords", "", "services-geojson"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Point fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return CommonExtKt.toJvm(org.maplibre.geojson.model.Point.Companion.fromJson(json));
        }

        @JvmStatic
        @NotNull
        public final Point fromLngLat(double longitude, double latitude) {
            Object[] objectArray = new Double[]{longitude, latitude};
            return new Point(Point.TYPE, null, CollectionsKt.listOf((Object[])objectArray));
        }

        @JvmStatic
        @NotNull
        public final Point fromLngLat(double longitude, double latitude, @Nullable BoundingBox bbox) {
            Object[] objectArray = new Double[]{longitude, latitude};
            return new Point(Point.TYPE, bbox, CollectionsKt.listOf((Object[])objectArray));
        }

        @JvmStatic
        @NotNull
        public final Point fromLngLat(double longitude, double latitude, double altitude) {
            Object[] objectArray = new Double[]{longitude, latitude, altitude};
            return new Point(Point.TYPE, null, CollectionsKt.listOf((Object[])objectArray));
        }

        @JvmStatic
        @NotNull
        public final Point fromLngLat(double longitude, double latitude, double altitude, @Nullable BoundingBox bbox) {
            Object[] objectArray = new Double[]{longitude, latitude, altitude};
            return new Point(Point.TYPE, bbox, CollectionsKt.listOf((Object[])objectArray));
        }

        @Nullable
        public final Point fromLngLat(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (coords.length == 2) {
                return this.fromLngLat(coords[0], coords[1]);
            }
            if (coords.length > 2) {
                return this.fromLngLat(coords[0], coords[1], coords[2]);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

