/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.BoundingBox;
import org.maplibre.geojson.CoordinateContainer;
import org.maplibre.geojson.LineString;
import org.maplibre.geojson.common.CommonExtKt;
import org.maplibre.geojson.exception.GeoJsonException;
import org.maplibre.geojson.model.Point;

@Deprecated(message="Use new common models instead.", replaceWith=@ReplaceWith(expression="Polygon", imports={"org.maplibre.geojson.model.Polygon"}))
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u00012\u001a\u0012\u0016\u0012\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u0018\u00010\u00030\u0002:\u0001\u000fB/\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0003J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/maplibre/geojson/Polygon;", "Lorg/maplibre/geojson/model/Polygon;", "Lorg/maplibre/geojson/CoordinateContainer;", "", "Lorg/maplibre/geojson/Point;", "type", "", "bbox", "Lorg/maplibre/geojson/BoundingBox;", "coordinates", "<init>", "(Ljava/lang/String;Lorg/maplibre/geojson/BoundingBox;Ljava/util/List;)V", "outer", "Lorg/maplibre/geojson/LineString;", "inner", "Companion", "services-geojson"})
@SourceDebugExtension(value={"SMAP\nPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polygon.kt\norg/maplibre/geojson/Polygon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1557#2:346\n1628#2,3:347\n1557#2:350\n1628#2,3:351\n*S KotlinDebug\n*F\n+ 1 Polygon.kt\norg/maplibre/geojson/Polygon\n*L\n78#1:346\n78#1:347,3\n110#1:350\n110#1:351,3\n*E\n"})
public final class Polygon
extends org.maplibre.geojson.model.Polygon
implements CoordinateContainer<List<? extends List<? extends org.maplibre.geojson.Point>>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TYPE = "Polygon";

    public Polygon(@NotNull String type, @Nullable BoundingBox bbox, @NotNull List<? extends List<org.maplibre.geojson.Point>> coordinates) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        super(coordinates, bbox);
    }

    @NotNull
    public final LineString outer() {
        return CommonExtKt.toJvm(this.getOuterLine());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineString> inner() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getInnerLines();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            org.maplibre.geojson.model.LineString lineString = (org.maplibre.geojson.model.LineString)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CommonExtKt.toJvm((org.maplibre.geojson.model.LineString)line));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String type() {
        return TYPE;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        org.maplibre.geojson.model.BoundingBox boundingBox = this.getBbox();
        return boundingBox != null ? CommonExtKt.toJvm(boundingBox) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<List<org.maplibre.geojson.Point>> coordinates() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.getCoordinates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void line;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)line;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void point;
                Point point2 = (Point)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(CommonExtKt.toJvm((Point)point));
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromJson(@NotNull String json) {
        return Companion.fromJson(json);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromLngLats(@NotNull List<? extends List<org.maplibre.geojson.Point>> coordinates) {
        return Companion.fromLngLats(coordinates);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromLngLats(@NotNull List<? extends List<org.maplibre.geojson.Point>> coordinates, @Nullable BoundingBox bbox) {
        return Companion.fromLngLats(coordinates, bbox);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromLngLats(@NotNull double[][][] coordinates) {
        return Companion.fromLngLats(coordinates);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromOuterInner(@NotNull LineString outer, LineString ... inner) {
        return Companion.fromOuterInner(outer, inner);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromOuterInner(@NotNull LineString outer, @Nullable BoundingBox bbox, LineString ... inner) {
        return Companion.fromOuterInner(outer, bbox, inner);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromOuterInner(@NotNull LineString outer, @Nullable List<LineString> inner) {
        return Companion.fromOuterInner(outer, inner);
    }

    @JvmStatic
    @NotNull
    public static final Polygon fromOuterInner(@NotNull LineString outer, @Nullable BoundingBox bbox, @Nullable List<LineString> inner) {
        return Companion.fromOuterInner(outer, bbox, inner);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u001c\u0010\t\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000bH\u0007J&\u0010\t\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J!\u0010\t\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u000f\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u0016J3\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u000f\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u0017J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u000bH\u0007J*\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u000bH\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/maplibre/geojson/Polygon$Companion;", "", "<init>", "()V", "TYPE", "", "fromJson", "Lorg/maplibre/geojson/Polygon;", "json", "fromLngLats", "coordinates", "", "Lorg/maplibre/geojson/Point;", "bbox", "Lorg/maplibre/geojson/BoundingBox;", "", "", "([[[D)Lorg/maplibre/geojson/Polygon;", "fromOuterInner", "outer", "Lorg/maplibre/geojson/LineString;", "inner", "(Lorg/maplibre/geojson/LineString;[Lorg/maplibre/geojson/LineString;)Lorg/maplibre/geojson/Polygon;", "(Lorg/maplibre/geojson/LineString;Lorg/maplibre/geojson/BoundingBox;[Lorg/maplibre/geojson/LineString;)Lorg/maplibre/geojson/Polygon;", "ensureIsLinearRing", "", "lineString", "services-geojson"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Polygon fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return CommonExtKt.toJvm(org.maplibre.geojson.model.Polygon.Companion.fromJson(json));
        }

        @JvmStatic
        @NotNull
        public final Polygon fromLngLats(@NotNull List<? extends List<org.maplibre.geojson.Point>> coordinates) {
            Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
            return new Polygon(Polygon.TYPE, null, coordinates);
        }

        @JvmStatic
        @NotNull
        public final Polygon fromLngLats(@NotNull List<? extends List<org.maplibre.geojson.Point>> coordinates, @Nullable BoundingBox bbox) {
            Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
            return new Polygon(Polygon.TYPE, bbox, coordinates);
        }

        @JvmStatic
        @NotNull
        public final Polygon fromLngLats(@NotNull double[][][] coordinates) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            List converted = new ArrayList(((Object[])coordinates).length);
            int n = ((Object[])coordinates).length;
            for (int i = 0; i < n; ++i) {
                double[][] coordinate = coordinates[i];
                List innerList = new ArrayList(((Object[])coordinate).length);
                int n2 = ((Object[])coordinate).length;
                for (int j = 0; j < n2; ++j) {
                    double[] pointCoordinate = coordinate[j];
                    org.maplibre.geojson.Point point = org.maplibre.geojson.Point.Companion.fromLngLat(pointCoordinate);
                    Intrinsics.checkNotNull((Object)point);
                    innerList.add(point);
                }
                converted.add(innerList);
            }
            return new Polygon(Polygon.TYPE, null, converted);
        }

        @JvmStatic
        @NotNull
        public final Polygon fromOuterInner(@NotNull LineString outer, LineString ... inner) {
            Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            this.ensureIsLinearRing(outer);
            List coordinates = new ArrayList();
            coordinates.add(outer.coordinates());
            for (LineString lineString : inner) {
                this.ensureIsLinearRing(lineString);
                coordinates.add(lineString.coordinates());
            }
            return new Polygon(Polygon.TYPE, null, coordinates);
        }

        @JvmStatic
        @NotNull
        public final Polygon fromOuterInner(@NotNull LineString outer, @Nullable BoundingBox bbox, LineString ... inner) {
            Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            this.ensureIsLinearRing(outer);
            List coordinates = new ArrayList();
            coordinates.add(outer.coordinates());
            for (LineString lineString : inner) {
                this.ensureIsLinearRing(lineString);
                coordinates.add(lineString.coordinates());
            }
            return new Polygon(Polygon.TYPE, bbox, coordinates);
        }

        @JvmStatic
        @NotNull
        public final Polygon fromOuterInner(@NotNull LineString outer, @Nullable List<LineString> inner) {
            Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
            this.ensureIsLinearRing(outer);
            List coordinates = new ArrayList();
            coordinates.add(outer.coordinates());
            if (inner == null || inner.isEmpty()) {
                return new Polygon(Polygon.TYPE, null, coordinates);
            }
            for (LineString lineString : inner) {
                this.ensureIsLinearRing(lineString);
                coordinates.add(lineString.coordinates());
            }
            return new Polygon(Polygon.TYPE, null, coordinates);
        }

        @JvmStatic
        @NotNull
        public final Polygon fromOuterInner(@NotNull LineString outer, @Nullable BoundingBox bbox, @Nullable List<LineString> inner) {
            Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
            this.ensureIsLinearRing(outer);
            List coordinates = new ArrayList();
            coordinates.add(outer.coordinates());
            if (inner == null) {
                return new Polygon(Polygon.TYPE, bbox, coordinates);
            }
            for (LineString lineString : inner) {
                this.ensureIsLinearRing(lineString);
                coordinates.add(lineString.coordinates());
            }
            return new Polygon(Polygon.TYPE, bbox, coordinates);
        }

        private final void ensureIsLinearRing(LineString lineString) {
            if (lineString.coordinates().size() < 4) {
                throw new GeoJsonException("LinearRings need to be made up of 4 or more coordinates.");
            }
            if (!((org.maplibre.geojson.Point)lineString.coordinates().get(0)).equals(lineString.coordinates().get(lineString.coordinates().size() - 1))) {
                throw new GeoJsonException("LinearRings require first and last coordinate to be identical.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

