/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.maplibre.geojson.model.Point;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001c\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0007H\u0007J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010!\u001a\u00020\u0005H\u0002JB\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010!\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/maplibre/geojson/utils/PolylineUtils;", "", "<init>", "()V", "SIMPLIFY_DEFAULT_TOLERANCE", "", "SIMPLIFY_DEFAULT_HIGHEST_QUALITY", "", "encode", "", "path", "", "Lorg/maplibre/geojson/model/Point;", "precision", "", "", "variable", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "decode", "encodedPath", "simplify", "points", "tolerance", "highestQuality", "getSqDist", "p1", "p2", "getSqSegDist", "point", "simplifyRadialDist", "sqTolerance", "simplifyDpStep", "first", "last", "simplified", "simplifyDouglasPeucker", "services-geojson"})
public final class PolylineUtils {
    @NotNull
    public static final PolylineUtils INSTANCE = new PolylineUtils();
    private static final double SIMPLIFY_DEFAULT_TOLERANCE = 1.0;
    private static final boolean SIMPLIFY_DEFAULT_HIGHEST_QUALITY = false;

    private PolylineUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull List<? extends Point> path, int precision) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuilder result = new StringBuilder();
        double factor = Math.pow(10.0, precision);
        for (Point point : path) {
            long lat = MathKt.roundToLong((double)(point.getLatitude() * factor));
            long lng = MathKt.roundToLong((double)(point.getLongitude() * factor));
            long varLat = lat - lastLat;
            long varLng = lng - lastLng;
            INSTANCE.encode(varLat, result);
            INSTANCE.encode(varLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void encode(long variable, StringBuilder result) {
        long encoded = variable;
        long l = encoded = encoded < 0L ? encoded << 1 ^ 0xFFFFFFFFFFFFFFFFL : encoded << 1;
        while (encoded >= 32L) {
            result.append((char)((0x20L | encoded & 0x1FL) + (long)63));
            encoded >>= 5;
        }
        result.append((char)(encoded + (long)63));
    }

    @JvmStatic
    @NotNull
    public static final List<Point> decode(@NotNull String encodedPath, int precision) {
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        int len = encodedPath.length();
        double factor = Math.pow(10.0, precision);
        List path = new ArrayList();
        int index = 0;
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int result = 1;
            int shift = 0;
            int temp = 0;
            do {
                temp = encodedPath.charAt(index++) - 63 - 1;
                result += temp << shift;
                shift += 5;
            } while (temp >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                temp = encodedPath.charAt(index++) - 63 - 1;
                result += temp << shift;
                shift += 5;
            } while (temp >= 31);
            path.add(new Point((double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) / factor, (double)lat / factor, null, null, 12, null));
        }
        return path;
    }

    @JvmOverloads
    @NotNull
    public final List<Point> simplify(@NotNull List<? extends Point> points, double tolerance, boolean highestQuality) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.size() <= 2) {
            return points;
        }
        double sqTolerance = tolerance * tolerance;
        List<Point> radialSimplifiedPoints = highestQuality ? points : this.simplifyRadialDist(points, sqTolerance);
        return this.simplifyDouglasPeucker(radialSimplifiedPoints, sqTolerance);
    }

    public static /* synthetic */ List simplify$default(PolylineUtils polylineUtils, List list, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return polylineUtils.simplify(list, d, bl);
    }

    private final double getSqDist(Point p1, Point p2) {
        double dx = p1.getLongitude() - p2.getLongitude();
        double dy = p1.getLatitude() - p2.getLatitude();
        return dx * dx + dy * dy;
    }

    private final double getSqSegDist(Point point, Point p1, Point p2) {
        double horizontal = p1.getLongitude();
        double vertical = p1.getLatitude();
        double diffHorizontal = p2.getLongitude() - horizontal;
        double diffVertical = p2.getLatitude() - vertical;
        if (!(diffHorizontal == 0.0) || !(diffVertical == 0.0)) {
            double total = ((point.getLongitude() - horizontal) * diffHorizontal + (point.getLatitude() - vertical) * diffVertical) / (diffHorizontal * diffHorizontal + diffVertical * diffVertical);
            if (total > 1.0) {
                horizontal = p2.getLongitude();
                vertical = p2.getLatitude();
            } else if (total > 0.0) {
                horizontal += diffHorizontal * total;
                vertical += diffVertical * total;
            }
        }
        diffHorizontal = point.getLongitude() - horizontal;
        diffVertical = point.getLatitude() - vertical;
        return diffHorizontal * diffHorizontal + diffVertical * diffVertical;
    }

    private final List<Point> simplifyRadialDist(List<? extends Point> points, double sqTolerance) {
        Point prevPoint = points.get(0);
        ArrayList<Point> newPoints = new ArrayList<Point>();
        Point point = prevPoint;
        Intrinsics.checkNotNull((Object)point);
        newPoints.add(point);
        Point point2 = null;
        int len = points.size();
        for (int i = 1; i < len; ++i) {
            point2 = points.get(i);
            Point point3 = prevPoint;
            Intrinsics.checkNotNull((Object)point3);
            if (!(this.getSqDist(point2, point3) > sqTolerance)) continue;
            newPoints.add(point2);
            prevPoint = point2;
        }
        if (!Intrinsics.areEqual((Object)prevPoint, point2)) {
            Point point4 = point2;
            Intrinsics.checkNotNull((Object)point4);
            newPoints.add(point4);
        }
        return newPoints;
    }

    private final List<Point> simplifyDpStep(List<? extends Point> points, int first, int last, double sqTolerance, List<? extends Point> simplified) {
        double maxSqDist = sqTolerance;
        int index = 0;
        ArrayList<Point> stepList = new ArrayList<Point>();
        for (int i = first + 1; i < last; ++i) {
            double sqDist = this.getSqSegDist(points.get(i), points.get(first), points.get(last));
            if (!(sqDist > maxSqDist)) continue;
            index = i;
            maxSqDist = sqDist;
        }
        if (maxSqDist > sqTolerance) {
            if (index - first > 1) {
                stepList.addAll((Collection)this.simplifyDpStep(points, first, index, sqTolerance, simplified));
            }
            stepList.add(points.get(index));
            if (last - index > 1) {
                stepList.addAll((Collection)this.simplifyDpStep(points, index, last, sqTolerance, simplified));
            }
        }
        return stepList;
    }

    private final List<Point> simplifyDouglasPeucker(List<? extends Point> points, double sqTolerance) {
        int last = points.size() - 1;
        ArrayList<Point> simplified = new ArrayList<Point>();
        simplified.add(points.get(0));
        simplified.addAll((Collection)this.simplifyDpStep(points, 0, last, sqTolerance, (List<? extends Point>)simplified));
        simplified.add(points.get(last));
        return simplified;
    }

    @JvmOverloads
    @NotNull
    public final List<Point> simplify(@NotNull List<? extends Point> points, double tolerance) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        return PolylineUtils.simplify$default(this, points, tolerance, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Point> simplify(@NotNull List<? extends Point> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        return PolylineUtils.simplify$default(this, points, 0.0, false, 6, null);
    }
}

