/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.turf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.maplibre.geojson.model.Feature;
import org.maplibre.geojson.model.FeatureCollection;
import org.maplibre.geojson.model.Geometry;
import org.maplibre.geojson.model.MultiPolygon;
import org.maplibre.geojson.model.Point;
import org.maplibre.geojson.model.Polygon;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/maplibre/geojson/turf/TurfJoins;", "", "<init>", "()V", "inside", "", "point", "Lorg/maplibre/geojson/model/Point;", "polygon", "Lorg/maplibre/geojson/model/Polygon;", "multiPolygon", "Lorg/maplibre/geojson/model/MultiPolygon;", "pointsWithinPolygon", "Lorg/maplibre/geojson/model/FeatureCollection;", "points", "polygons", "inRing", "pt", "ring", "", "services-turf"})
@SourceDebugExtension(value={"SMAP\nTurfJoins.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurfJoins.kt\norg/maplibre/geojson/turf/TurfJoins\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1755#2,2:114\n2632#2,3:116\n1757#2:119\n1368#2:120\n1454#2,2:121\n1611#2,9:123\n1863#2:132\n1864#2:134\n1620#2:135\n1456#2,3:136\n1#3:133\n*S KotlinDebug\n*F\n+ 1 TurfJoins.kt\norg/maplibre/geojson/turf/TurfJoins\n*L\n50#1:114,2\n54#1:116,3\n50#1:119\n77#1:120\n77#1:121,2\n79#1:123,9\n79#1:132\n79#1:134\n79#1:135\n77#1:136,3\n79#1:133\n*E\n"})
public final class TurfJoins {
    @NotNull
    public static final TurfJoins INSTANCE = new TurfJoins();

    private TurfJoins() {
    }

    @JvmStatic
    public static final boolean inside(@NotNull Point point, @NotNull Polygon polygon) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        List coordinates = polygon.getCoordinates();
        return TurfJoins.inside(point, new MultiPolygon(CollectionsKt.listOf((Object)coordinates), null, 2, null));
    }

    @JvmStatic
    public static final boolean inside(@NotNull Point point, @NotNull MultiPolygon multiPolygon) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter((Object)multiPolygon, (String)"multiPolygon");
            Iterable $this$any$iv = multiPolygon.getCoordinates();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        List poly = (List)element$iv;
                        boolean bl3 = false;
                        if (INSTANCE.inRing(point, (List)CollectionsKt.first((List)poly))) {
                            Iterable $this$none$iv = CollectionsKt.drop((Iterable)poly, (int)1);
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv2 : $this$none$iv) {
                                    List ring = (List)element$iv2;
                                    boolean bl4 = false;
                                    if (!INSTANCE.inRing(point, ring)) continue;
                                    bl2 = false;
                                    break block8;
                                }
                                bl2 = true;
                            }
                        } else {
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final FeatureCollection pointsWithinPolygon(@NotNull FeatureCollection points, @NotNull FeatureCollection polygons) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)polygons, (String)"polygons");
        Iterable $this$flatMap$iv = polygons.getFeatures();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            Feature polygonFeature = (Feature)element$iv$iv;
            boolean bl = false;
            Geometry geometry = polygonFeature.getGeometry();
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.maplibre.geojson.model.Polygon");
            Polygon polygon = (Polygon)geometry;
            Iterable $this$mapNotNull$iv = points.getFeatures();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Feature it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Feature pointFeature = (Feature)element$iv$iv2;
                boolean bl3 = false;
                Geometry geometry2 = pointFeature.getGeometry();
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.maplibre.geojson.model.Point");
                Point point = (Point)geometry2;
                if ((TurfJoins.inside(point, polygon) ? new Feature((Geometry)point, null, null, null, 14, null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inPolygonFeatures = (List)destination$iv$iv;
        return new FeatureCollection(inPolygonFeatures, null, 2, null);
    }

    private final boolean inRing(Point pt, List<? extends Point> ring) {
        boolean isInside = false;
        int i = 0;
        int j = ring.size() - 1;
        while (i < ring.size()) {
            boolean intersect;
            double xi = ring.get(i).getLongitude();
            double yi = ring.get(i).getLatitude();
            double xj = ring.get(j).getLongitude();
            double yj = ring.get(j).getLatitude();
            boolean bl = intersect = yi > pt.getLatitude() != yj > pt.getLatitude() && pt.getLongitude() < (xj - xi) * (pt.getLatitude() - yi) / (yj - yi) + xi;
            if (intersect) {
                isInside = !isInside;
            }
            j = i++;
        }
        return isInside;
    }
}

