/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.turf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.maplibre.geojson.model.Feature;
import org.maplibre.geojson.model.FeatureCollection;
import org.maplibre.geojson.model.Geometry;
import org.maplibre.geojson.model.GeometryCollection;
import org.maplibre.geojson.model.LineString;
import org.maplibre.geojson.model.MultiLineString;
import org.maplibre.geojson.model.MultiPoint;
import org.maplibre.geojson.model.MultiPolygon;
import org.maplibre.geojson.model.Point;
import org.maplibre.geojson.model.Polygon;
import org.maplibre.geojson.turf.TurfException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u001c"}, d2={"Lorg/maplibre/geojson/turf/TurfMeta;", "", "<init>", "()V", "coordAll", "", "Lorg/maplibre/geojson/model/Point;", "point", "multiPoint", "Lorg/maplibre/geojson/model/MultiPoint;", "lineString", "Lorg/maplibre/geojson/model/LineString;", "polygon", "Lorg/maplibre/geojson/model/Polygon;", "excludeWrapCoord", "", "multiLineString", "Lorg/maplibre/geojson/model/MultiLineString;", "multiPolygon", "Lorg/maplibre/geojson/model/MultiPolygon;", "feature", "Lorg/maplibre/geojson/model/Feature;", "featureCollection", "Lorg/maplibre/geojson/model/FeatureCollection;", "coordAllFromSingleGeometry", "geometry", "Lorg/maplibre/geojson/model/Geometry;", "getCoord", "services-turf"})
@SourceDebugExtension(value={"SMAP\nTurfMeta.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurfMeta.kt\norg/maplibre/geojson/turf/TurfMeta\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1557#2:237\n1628#2,3:238\n1557#2:241\n1628#2,3:242\n1611#2,9:245\n1863#2:254\n1864#2:256\n1620#2:257\n1557#2:258\n1628#2,3:259\n1#3:255\n*S KotlinDebug\n*F\n+ 1 TurfMeta.kt\norg/maplibre/geojson/turf/TurfMeta\n*L\n81#1:237\n81#1:238,3\n119#1:241\n119#1:242,3\n164#1:245,9\n164#1:254\n164#1:256\n164#1:257\n209#1:258\n209#1:259,3\n164#1:255\n*E\n"})
public final class TurfMeta {
    @NotNull
    public static final TurfMeta INSTANCE = new TurfMeta();

    private TurfMeta() {
    }

    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return CollectionsKt.listOf((Object)point);
    }

    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull MultiPoint multiPoint) {
        Intrinsics.checkNotNullParameter((Object)multiPoint, (String)"multiPoint");
        return multiPoint.getCoordinates();
    }

    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull LineString lineString) {
        Intrinsics.checkNotNullParameter((Object)lineString, (String)"lineString");
        return lineString.getCoordinates();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull Polygon polygon, boolean excludeWrapCoord) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        Iterable $this$map$iv = polygon.getCoordinates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void coords;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.dropLast((List)coords, (int)(excludeWrapCoord ? 1 : 0)));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull MultiLineString multiLineString) {
        Intrinsics.checkNotNullParameter((Object)multiLineString, (String)"multiLineString");
        return CollectionsKt.flatten((Iterable)multiLineString.getCoordinates());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull MultiPolygon multiPolygon, boolean excludeWrapCoord) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)multiPolygon, (String)"multiPolygon");
        Iterable $this$map$iv = CollectionsKt.flatten((Iterable)multiPolygon.getCoordinates());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void coords;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.dropLast((List)coords, (int)(excludeWrapCoord ? 1 : 0)));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull Feature feature, boolean excludeWrapCoord) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                object = feature.getGeometry();
                if (object == null) break block2;
                Geometry geometry = object;
                boolean bl = false;
                List<Point> list = INSTANCE.coordAllFromSingleGeometry(geometry, excludeWrapCoord);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Point> coordAll(@NotNull FeatureCollection featureCollection, boolean excludeWrapCoord) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        Iterable $this$mapNotNull$iv = featureCollection.getFeatures();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List<Point> list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Feature feature = (Feature)element$iv$iv;
            boolean bl2 = false;
            if (feature.getGeometry() != null) {
                Geometry geometry;
                boolean bl3 = false;
                list = INSTANCE.coordAllFromSingleGeometry(geometry, excludeWrapCoord);
            } else {
                list = null;
            }
            if (list == null) continue;
            List<Point> it$iv$iv = list;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Point> coordAllFromSingleGeometry(Geometry geometry, boolean excludeWrapCoord) {
        List list;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Point) {
            list = CollectionsKt.listOf((Object)geometry);
        } else if (geometry2 instanceof MultiPoint) {
            list = ((MultiPoint)geometry).getCoordinates();
        } else if (geometry2 instanceof LineString) {
            list = ((LineString)geometry).getCoordinates();
        } else if (geometry2 instanceof MultiLineString) {
            list = TurfMeta.coordAll((MultiLineString)geometry);
        } else if (geometry2 instanceof Polygon) {
            list = TurfMeta.coordAll((Polygon)geometry, excludeWrapCoord);
        } else if (geometry2 instanceof MultiPolygon) {
            list = TurfMeta.coordAll((MultiPolygon)geometry, excludeWrapCoord);
        } else if (geometry2 instanceof GeometryCollection) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((GeometryCollection)geometry).getGeometries();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void geometryItem;
                Geometry geometry3 = (Geometry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.coordAllFromSingleGeometry((Geometry)geometryItem, excludeWrapCoord));
            }
            list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        } else {
            throw new TurfException("Unsupported geometry type: " + geometry);
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final Point getCoord(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Geometry geometry = feature.getGeometry();
        Point point = geometry instanceof Point ? (Point)geometry : null;
        if (point == null) {
            throw new TurfException("A Feature with a Point geometry is required.");
        }
        return point;
    }
}

