/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.turf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.model.Feature;
import org.maplibre.geojson.model.FeatureCollection;
import org.maplibre.geojson.model.Geometry;
import org.maplibre.geojson.model.LineString;
import org.maplibre.geojson.model.MultiLineString;
import org.maplibre.geojson.model.MultiPoint;
import org.maplibre.geojson.model.MultiPolygon;
import org.maplibre.geojson.model.Point;
import org.maplibre.geojson.model.Polygon;
import org.maplibre.geojson.turf.TurfException;
import org.maplibre.geojson.turf.TurfMeta;
import org.maplibre.geojson.turf.TurfUnit;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0007J\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\bH\u0007J\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\bH\u0007J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001aH\u0007J*\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001aH\u0007J(\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001aH\u0007J(\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001aH\u0007J4\u0010\"\u001a\u0004\u0018\u00010\u00172\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0$2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001aH\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014H\u0007\u00a8\u0006("}, d2={"Lorg/maplibre/geojson/turf/TurfConversion;", "", "<init>", "()V", "lengthToDegrees", "", "distance", "units", "Lorg/maplibre/geojson/turf/TurfUnit;", "degreesToRadians", "degrees", "radiansToDegrees", "radians", "radiansToLength", "unit", "lengthToRadians", "convertLength", "originalUnit", "finalUnit", "explode", "Lorg/maplibre/geojson/model/FeatureCollection;", "featureCollection", "feature", "Lorg/maplibre/geojson/model/Feature;", "polygonToLine", "properties", "", "", "Lkotlinx/serialization/json/JsonElement;", "polygon", "Lorg/maplibre/geojson/model/Polygon;", "multiPolygon", "Lorg/maplibre/geojson/model/MultiPolygon;", "multiPolygonToLine", "coordsToLine", "coordinates", "", "Lorg/maplibre/geojson/model/Point;", "combine", "originalFeatureCollection", "services-turf"})
@SourceDebugExtension(value={"SMAP\nTurfConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurfConversion.kt\norg/maplibre/geojson/turf/TurfConversion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1557#2:319\n1628#2,3:320\n1557#2:323\n1628#2,3:324\n1611#2,9:327\n1863#2:336\n1864#2:338\n1620#2:339\n1863#2,2:340\n1#3:337\n*S KotlinDebug\n*F\n+ 1 TurfConversion.kt\norg/maplibre/geojson/turf/TurfConversion\n*L\n128#1:319\n128#1:320,3\n144#1:323\n144#1:324,3\n202#1:327,9\n202#1:336\n202#1:338\n202#1:339\n288#1:340,2\n202#1:337\n*E\n"})
public final class TurfConversion {
    @NotNull
    public static final TurfConversion INSTANCE = new TurfConversion();

    private TurfConversion() {
    }

    @JvmStatic
    public static final double lengthToDegrees(double distance, @NotNull TurfUnit units) {
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        return TurfConversion.radiansToDegrees(TurfConversion.lengthToRadians(distance, units));
    }

    @JvmStatic
    public static final double degreesToRadians(double degrees) {
        double radians = degrees % (double)360;
        return radians * Math.PI / (double)180;
    }

    @JvmStatic
    public static final double radiansToDegrees(double radians) {
        double degrees = radians % (Math.PI * 2);
        return degrees * (double)180 / Math.PI;
    }

    @JvmStatic
    @JvmOverloads
    public static final double radiansToLength(double radians, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return radians * unit.getFactor();
    }

    public static /* synthetic */ double radiansToLength$default(double d, TurfUnit turfUnit, int n, Object object) {
        if ((n & 2) != 0) {
            turfUnit = TurfUnit.Companion.getDEFAULT();
        }
        return TurfConversion.radiansToLength(d, turfUnit);
    }

    @JvmStatic
    @JvmOverloads
    public static final double lengthToRadians(double distance, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return distance / unit.getFactor();
    }

    public static /* synthetic */ double lengthToRadians$default(double d, TurfUnit turfUnit, int n, Object object) {
        if ((n & 2) != 0) {
            turfUnit = TurfUnit.Companion.getDEFAULT();
        }
        return TurfConversion.lengthToRadians(d, turfUnit);
    }

    @JvmStatic
    @JvmOverloads
    public static final double convertLength(double distance, @NotNull TurfUnit originalUnit, @NotNull TurfUnit finalUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)originalUnit), (String)"originalUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)finalUnit), (String)"finalUnit");
        return TurfConversion.radiansToLength(TurfConversion.lengthToRadians(distance, originalUnit), finalUnit);
    }

    public static /* synthetic */ double convertLength$default(double d, TurfUnit turfUnit, TurfUnit turfUnit2, int n, Object object) {
        if ((n & 4) != 0) {
            turfUnit2 = TurfUnit.Companion.getDEFAULT();
        }
        return TurfConversion.convertLength(d, turfUnit, turfUnit2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final FeatureCollection explode(@NotNull FeatureCollection featureCollection) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        Iterable $this$map$iv = TurfMeta.coordAll(featureCollection, true);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void point;
            Point point2 = (Point)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Feature((Geometry)point, null, null, null, 14, null));
        }
        List points = (List)destination$iv$iv;
        return new FeatureCollection(points, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final FeatureCollection explode(@NotNull Feature feature) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Iterable $this$map$iv = TurfMeta.coordAll(feature, true);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void point;
            Point point2 = (Point)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Feature((Geometry)point, null, null, null, 14, null));
        }
        List points = (List)destination$iv$iv;
        return new FeatureCollection(points, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature polygonToLine(@NotNull Feature feature, @Nullable Map<String, JsonElement> properties) {
        Polygon polygon;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                Geometry geometry = feature.getGeometry();
                polygon = geometry instanceof Polygon ? (Polygon)geometry : null;
                if (polygon == null) break block4;
                Polygon polygon2 = polygon;
                boolean bl = false;
                Map map = properties;
                if (map == null) {
                    map = feature.getProperties();
                }
                Feature feature2 = TurfConversion.polygonToLine(polygon2, map);
                polygon = feature2;
                if (feature2 != null) break block5;
            }
            throw new TurfException("Feature's geometry must be Polygon");
        }
        return polygon;
    }

    public static /* synthetic */ Feature polygonToLine$default(Feature feature, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return TurfConversion.polygonToLine(feature, (Map<String, JsonElement>)map);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Feature polygonToLine(@NotNull Polygon polygon, @Nullable Map<String, JsonElement> properties) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        return INSTANCE.coordsToLine(polygon.getCoordinates(), properties);
    }

    public static /* synthetic */ Feature polygonToLine$default(Polygon polygon, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return TurfConversion.polygonToLine(polygon, (Map<String, JsonElement>)map);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FeatureCollection polygonToLine(@NotNull MultiPolygon multiPolygon, @Nullable Map<String, JsonElement> properties) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)multiPolygon, (String)"multiPolygon");
        Iterable $this$mapNotNull$iv = multiPolygon.getCoordinates();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Feature it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            List polygonCoordinates = (List)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.coordsToLine(polygonCoordinates, properties) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List features = (List)destination$iv$iv;
        return new FeatureCollection(features, null, 2, null);
    }

    public static /* synthetic */ FeatureCollection polygonToLine$default(MultiPolygon multiPolygon, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return TurfConversion.polygonToLine(multiPolygon, (Map<String, JsonElement>)map);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FeatureCollection multiPolygonToLine(@NotNull Feature feature, @Nullable Map<String, JsonElement> properties) {
        MultiPolygon multiPolygon;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                Geometry geometry = feature.getGeometry();
                multiPolygon = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : null;
                if (multiPolygon == null) break block4;
                MultiPolygon multiPolygon2 = multiPolygon;
                boolean bl = false;
                Map map = properties;
                if (map == null) {
                    map = feature.getProperties();
                }
                FeatureCollection featureCollection = TurfConversion.polygonToLine(multiPolygon2, map);
                multiPolygon = featureCollection;
                if (featureCollection != null) break block5;
            }
            throw new TurfException("Feature's geometry must be MultiPolygon");
        }
        return multiPolygon;
    }

    public static /* synthetic */ FeatureCollection multiPolygonToLine$default(Feature feature, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return TurfConversion.multiPolygonToLine(feature, map);
    }

    private final Feature coordsToLine(List<? extends List<? extends Point>> coordinates, Map<String, JsonElement> properties) {
        if (!coordinates.isEmpty()) {
            if (coordinates.size() == 1) {
                LineString lineString = new LineString(coordinates.get(0), null, 2, null);
                return new Feature((Geometry)lineString, properties, null, null, 12, null);
            }
            MultiLineString multiLineString = new MultiLineString(coordinates, null, 2, null);
            return new Feature((Geometry)multiLineString, properties, null, null, 12, null);
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final FeatureCollection combine(@NotNull FeatureCollection originalFeatureCollection) {
        Intrinsics.checkNotNullParameter((Object)originalFeatureCollection, (String)"originalFeatureCollection");
        List features = originalFeatureCollection.getFeatures();
        if (features.isEmpty()) {
            throw new TurfException("Your FeatureCollection doesn't have any Feature objects in it.");
        }
        List pointList = new ArrayList();
        List lineStringList = new ArrayList();
        List polygonList = new ArrayList();
        Iterable $this$forEach$iv = features;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Feature feature = (Feature)element$iv;
            boolean bl = false;
            Geometry geometry = feature.getGeometry();
            if (geometry instanceof Point) {
                pointList.add(geometry);
                continue;
            }
            if (geometry instanceof MultiPoint) {
                pointList.addAll(((MultiPoint)geometry).getCoordinates());
                continue;
            }
            if (geometry instanceof LineString) {
                lineStringList.add(geometry);
                continue;
            }
            if (geometry instanceof MultiLineString) {
                lineStringList.addAll(((MultiLineString)geometry).getLineStrings());
                continue;
            }
            if (geometry instanceof Polygon) {
                polygonList.add(geometry);
                continue;
            }
            if (!(geometry instanceof MultiPolygon)) continue;
            polygonList.addAll(((MultiPolygon)geometry).getPolygons());
        }
        List combinedFeatures = new ArrayList();
        if (!((Collection)pointList).isEmpty()) {
            combinedFeatures.add(new Feature((Geometry)new MultiPoint(pointList, null, 2, null), null, null, null, 14, null));
        }
        if (!((Collection)lineStringList).isEmpty()) {
            combinedFeatures.add(new Feature((Geometry)MultiLineString.Companion.fromLineStrings$default((MultiLineString.Companion)MultiLineString.Companion, (List)lineStringList, null, (int)2, null), null, null, null, 14, null));
        }
        if (!((Collection)polygonList).isEmpty()) {
            combinedFeatures.add(new Feature((Geometry)MultiPolygon.Companion.fromPolygons$default((MultiPolygon.Companion)MultiPolygon.Companion, (List)polygonList, null, (int)2, null), null, null, null, 14, null));
        }
        return combinedFeatures.isEmpty() ? originalFeatureCollection : new FeatureCollection(combinedFeatures, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final double radiansToLength(double radians) {
        return TurfConversion.radiansToLength$default(radians, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final double lengthToRadians(double distance) {
        return TurfConversion.lengthToRadians$default(distance, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final double convertLength(double distance, @NotNull TurfUnit originalUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)originalUnit), (String)"originalUnit");
        return TurfConversion.convertLength$default(distance, originalUnit, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature polygonToLine(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return TurfConversion.polygonToLine$default(feature, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Feature polygonToLine(@NotNull Polygon polygon) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        return TurfConversion.polygonToLine$default(polygon, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FeatureCollection polygonToLine(@NotNull MultiPolygon multiPolygon) {
        Intrinsics.checkNotNullParameter((Object)multiPolygon, (String)"multiPolygon");
        return TurfConversion.polygonToLine$default(multiPolygon, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FeatureCollection multiPolygonToLine(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return TurfConversion.multiPolygonToLine$default(feature, null, 2, null);
    }
}

