/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.turf;

import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.Feature;
import org.maplibre.geojson.FeatureCollection;
import org.maplibre.geojson.GeoJson;
import org.maplibre.geojson.Geometry;
import org.maplibre.geojson.Point;
import org.maplibre.turf.TurfException;
import org.maplibre.turf.TurfMeta;

@Deprecated(message="The assertions are not needed anymore. Use new Turf utils instead.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J\"\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J&\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/maplibre/turf/TurfAssertions;", "", "<init>", "()V", "getCoord", "Lorg/maplibre/geojson/Point;", "obj", "Lorg/maplibre/geojson/Feature;", "geojsonType", "", "value", "Lorg/maplibre/geojson/GeoJson;", "type", "", "name", "featureOf", "feature", "collectionOf", "featureCollection", "Lorg/maplibre/geojson/FeatureCollection;", "services-turf"})
public final class TurfAssertions {
    @NotNull
    public static final TurfAssertions INSTANCE = new TurfAssertions();

    private TurfAssertions() {
    }

    @JvmStatic
    @Deprecated(message="use {@link TurfMeta#getCoord(Feature)}")
    @NotNull
    public static final Point getCoord(@NotNull Feature obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return TurfMeta.getCoord(obj);
    }

    @JvmStatic
    public static final void geojsonType(@Nullable GeoJson value, @Nullable String type, @Nullable String name) {
        if (type == null || type.length() == 0 || name == null || name.length() == 0) {
            throw new TurfException("Type and name required");
        }
        if (value == null || !Intrinsics.areEqual((Object)value.type(), (Object)type)) {
            Object object = value;
            if (object == null || (object = object.type()) == null) {
                object = " null";
            }
            throw new TurfException("Invalid input to " + name + ": must be a " + type + ", given " + (String)object);
        }
    }

    @JvmStatic
    public static final void featureOf(@NotNull Feature feature, @NotNull String type, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (name == null || name.length() == 0) {
            throw new TurfException(".featureOf() requires a name");
        }
        if (!Intrinsics.areEqual((Object)feature.type(), (Object)"Feature") || feature.geometry() == null) {
            String string = "Invalid input to %s, Feature with geometry required";
            Object[] objectArray = new Object[]{name};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new TurfException(string2);
        }
        Geometry geometry = feature.geometry();
        Intrinsics.checkNotNull((Object)geometry);
        if (!Intrinsics.areEqual((Object)geometry.type(), (Object)type)) {
            String string = "Invalid input to %s: must be a %s, given %s";
            Object[] objectArray = new Object[3];
            objectArray[0] = name;
            objectArray[1] = type;
            Geometry geometry2 = feature.geometry();
            Intrinsics.checkNotNull((Object)geometry2);
            objectArray[2] = geometry2.type();
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new TurfException(string3);
        }
    }

    @JvmStatic
    public static final void collectionOf(@Nullable FeatureCollection featureCollection, @Nullable String type, @Nullable String name) {
        if (name == null || name.length() == 0) {
            throw new TurfException("collectionOf() requires a name");
        }
        if (featureCollection == null || !Intrinsics.areEqual((Object)featureCollection.type(), (Object)"FeatureCollection") || featureCollection.features() == null) {
            String string = "Invalid input to %s, FeatureCollection required";
            Object[] objectArray = new Object[]{name};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new TurfException(string2);
        }
        for (Feature feature : featureCollection.features()) {
            if (feature == null || !Intrinsics.areEqual((Object)feature.type(), (Object)"Feature") || feature.geometry() == null) {
                String string = "Invalid input to %s, Feature with geometry required";
                Object[] objectArray = new Object[]{name};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                throw new TurfException(string3);
            }
            Geometry geometry = feature.geometry();
            Intrinsics.checkNotNull((Object)geometry);
            if (Intrinsics.areEqual((Object)geometry.type(), (Object)type)) continue;
            String string = "Invalid input to %s: must be a %s, given %s";
            Object[] objectArray = new Object[3];
            objectArray[0] = name;
            objectArray[1] = type;
            Geometry geometry2 = feature.geometry();
            Intrinsics.checkNotNull((Object)geometry2);
            objectArray[2] = geometry2.type();
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            throw new TurfException(string4);
        }
    }
}

