/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.turf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.model.BoundingBox;
import org.maplibre.geojson.model.Feature;
import org.maplibre.geojson.model.FeatureCollection;
import org.maplibre.geojson.model.GeoJson;
import org.maplibre.geojson.model.Geometry;
import org.maplibre.geojson.model.GeometryCollection;
import org.maplibre.geojson.model.LineString;
import org.maplibre.geojson.model.MultiLineString;
import org.maplibre.geojson.model.MultiPoint;
import org.maplibre.geojson.model.MultiPolygon;
import org.maplibre.geojson.model.Point;
import org.maplibre.geojson.model.Polygon;
import org.maplibre.geojson.turf.TurfConversion;
import org.maplibre.geojson.turf.TurfMeta;
import org.maplibre.geojson.turf.TurfUnit;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J(\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0007J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007J$\u0010\u001d\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0007J\u0016\u0010+\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0002J4\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0016\b\u0002\u00100\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203\u0018\u0001012\n\b\u0002\u00104\u001a\u0004\u0018\u000102H\u0007J4\u0010-\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 2\u0016\b\u0002\u00100\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203\u0018\u0001012\n\b\u0002\u00104\u001a\u0004\u0018\u000102H\u0007J\u0012\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u00106\u001a\u00020/2\u0006\u0010.\u001a\u00020/H\u0007J\u0010\u00107\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u00107\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u00107\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u00108\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u00109\u001a\u00020\u00052\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00190\u0019H\u0002J\u0016\u0010;\u001a\u00020\u00052\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0002J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J4\u0010>\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0016\b\u0002\u00100\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203\u0018\u0001012\n\b\u0002\u00104\u001a\u0004\u0018\u000102H\u0007J4\u0010>\u001a\u00020(2\u0006\u0010%\u001a\u00020&2\u0016\b\u0002\u00100\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203\u0018\u0001012\n\b\u0002\u00104\u001a\u0004\u0018\u000102H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/maplibre/geojson/turf/TurfMeasurement;", "", "<init>", "()V", "EARTH_RADIUS", "", "bearing", "point1", "Lorg/maplibre/geojson/model/Point;", "point2", "destination", "point", "distance", "unit", "Lorg/maplibre/geojson/turf/TurfUnit;", "length", "lineString", "Lorg/maplibre/geojson/model/LineString;", "multiLineString", "Lorg/maplibre/geojson/model/MultiLineString;", "polygon", "Lorg/maplibre/geojson/model/Polygon;", "multiPolygon", "Lorg/maplibre/geojson/model/MultiPolygon;", "coords", "", "midpoint", "from", "to", "along", "line", "bbox", "", "multiPoint", "Lorg/maplibre/geojson/model/MultiPoint;", "geoJson", "Lorg/maplibre/geojson/model/GeoJson;", "featureCollection", "Lorg/maplibre/geojson/model/FeatureCollection;", "feature", "Lorg/maplibre/geojson/model/Feature;", "geometry", "Lorg/maplibre/geojson/model/Geometry;", "bboxCalculator", "resultCoords", "bboxPolygon", "boundingBox", "Lorg/maplibre/geojson/model/BoundingBox;", "properties", "", "", "Lkotlinx/serialization/json/JsonElement;", "id", "envelope", "square", "area", "calculateArea", "polygonArea", "coordinates", "ringArea", "rad", "num", "center", "services-turf"})
@SourceDebugExtension(value={"SMAP\nTurfMeasurement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurfMeasurement.kt\norg/maplibre/geojson/turf/TurfMeasurement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,754:1\n1#2:755\n1567#3:756\n1598#3,4:757\n1368#3:761\n1454#3,5:762\n*S KotlinDebug\n*F\n+ 1 TurfMeasurement.kt\norg/maplibre/geojson/turf/TurfMeasurement\n*L\n226#1:756\n226#1:757,4\n448#1:761\n448#1:762,5\n*E\n"})
public final class TurfMeasurement {
    @NotNull
    public static final TurfMeasurement INSTANCE = new TurfMeasurement();
    private static double EARTH_RADIUS = 6378137.0;

    private TurfMeasurement() {
    }

    @JvmStatic
    public static final double bearing(@NotNull Point point1, @NotNull Point point2) {
        Intrinsics.checkNotNullParameter((Object)point1, (String)"point1");
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point2");
        double lon1 = TurfConversion.degreesToRadians(point1.getLongitude());
        double lon2 = TurfConversion.degreesToRadians(point2.getLongitude());
        double lat1 = TurfConversion.degreesToRadians(point1.getLatitude());
        double lat2 = TurfConversion.degreesToRadians(point2.getLatitude());
        double value1 = Math.sin(lon2 - lon1) * Math.cos(lat2);
        double value2 = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1);
        return TurfConversion.radiansToDegrees(Math.atan2(value1, value2));
    }

    @JvmStatic
    @NotNull
    public static final Point destination(@NotNull Point point, double distance, double bearing, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double longitude1 = TurfConversion.degreesToRadians(point.getLongitude());
        double latitude1 = TurfConversion.degreesToRadians(point.getLatitude());
        double bearingRad = TurfConversion.degreesToRadians(bearing);
        double radians = TurfConversion.lengthToRadians(distance, unit);
        double latitude2 = Math.asin(Math.sin(latitude1) * Math.cos(radians) + Math.cos(latitude1) * Math.sin(radians) * Math.cos(bearingRad));
        double longitude2 = longitude1 + Math.atan2(Math.sin(bearingRad) * Math.sin(radians) * Math.cos(latitude1), Math.cos(radians) - Math.sin(latitude1) * Math.sin(latitude2));
        return new Point(TurfConversion.radiansToDegrees(longitude2), TurfConversion.radiansToDegrees(latitude2), null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final double distance(@NotNull Point point1, @NotNull Point point2, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)point1, (String)"point1");
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point2");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double difLat = TurfConversion.degreesToRadians(point2.getLatitude() - point1.getLatitude());
        double difLon = TurfConversion.degreesToRadians(point2.getLongitude() - point1.getLongitude());
        double lat1 = TurfConversion.degreesToRadians(point1.getLatitude());
        double lat2 = TurfConversion.degreesToRadians(point2.getLatitude());
        double value = Math.pow(Math.sin(difLat / (double)2), 2.0) + Math.pow(Math.sin(difLon / (double)2), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        return TurfConversion.radiansToLength((double)2 * Math.atan2(Math.sqrt(value), Math.sqrt(1.0 - value)), unit);
    }

    public static /* synthetic */ double distance$default(Point point, Point point2, TurfUnit turfUnit, int n, Object object) {
        if ((n & 4) != 0) {
            turfUnit = TurfUnit.Companion.getDEFAULT();
        }
        return TurfMeasurement.distance(point, point2, turfUnit);
    }

    @JvmStatic
    public static final double length(@NotNull LineString lineString, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)lineString, (String)"lineString");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return INSTANCE.length(lineString.getCoordinates(), unit);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final double length(@NotNull MultiLineString multiLineString, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)multiLineString, (String)"multiLineString");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Iterable iterable = multiLineString.getCoordinates();
        double d = 0.0;
        for (Object t : iterable) {
            void points;
            List list = (List)t;
            double d2 = d;
            boolean bl = false;
            double d3 = INSTANCE.length((List<? extends Point>)points, unit);
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final double length(@NotNull Polygon polygon, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Iterable iterable = polygon.getCoordinates();
        double d = 0.0;
        for (Object t : iterable) {
            void points;
            List list = (List)t;
            double d2 = d;
            boolean bl = false;
            double d3 = INSTANCE.length((List<? extends Point>)points, unit);
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public final double length(@NotNull MultiPolygon multiPolygon, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)multiPolygon, (String)"multiPolygon");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Iterable iterable = CollectionsKt.flatten((Iterable)multiPolygon.getCoordinates());
        double d = 0.0;
        for (Object t : iterable) {
            void points;
            List list = (List)t;
            double d2 = d;
            boolean bl = false;
            double d3 = INSTANCE.length((List<? extends Point>)points, unit);
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public final double length(@NotNull List<? extends Point> coords, @NotNull TurfUnit unit) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Iterable $this$mapIndexed$iv = CollectionsKt.drop((Iterable)coords, (int)1);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void point;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Point point2 = (Point)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TurfMeasurement.distance(coords.get((int)index), (Point)point, unit));
        }
        return CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @NotNull
    public static final Point midpoint(@NotNull Point from, @NotNull Point to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double dist = TurfMeasurement.distance(from, to, TurfUnit.MILES);
        double heading = TurfMeasurement.bearing(from, to);
        return TurfMeasurement.destination(from, dist / (double)2, heading, TurfUnit.MILES);
    }

    @JvmStatic
    @NotNull
    public static final Point along(@NotNull LineString line, double distance, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return INSTANCE.along(line.getCoordinates(), distance, unit);
    }

    @NotNull
    public final Point along(@NotNull List<? extends Point> coords, double distance, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter(coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double travelled = 0.0;
        Iterator iterator = ((Iterable)coords).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Point point = (Point)iterator.next();
            if (travelled >= distance) {
                double overshot = distance - travelled;
                if (overshot == 0.0 || index == 0) {
                    return point;
                }
                double direction = TurfMeasurement.bearing(point, coords.get(index - 1)) - (double)180;
                return TurfMeasurement.destination(point, overshot, direction, unit);
            }
            if (index >= coords.size() - 1) continue;
            travelled += TurfMeasurement.distance(point, coords.get(index + 1), unit);
        }
        return (Point)CollectionsKt.last(coords);
    }

    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        List<Point> resultCoords = TurfMeta.coordAll(point);
        return INSTANCE.bboxCalculator(resultCoords);
    }

    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull LineString lineString) {
        Intrinsics.checkNotNullParameter((Object)lineString, (String)"lineString");
        List<Point> resultCoords = TurfMeta.coordAll(lineString);
        return INSTANCE.bboxCalculator(resultCoords);
    }

    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull MultiPoint multiPoint) {
        Intrinsics.checkNotNullParameter((Object)multiPoint, (String)"multiPoint");
        List<Point> resultCoords = TurfMeta.coordAll(multiPoint);
        return INSTANCE.bboxCalculator(resultCoords);
    }

    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull Polygon polygon) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        List<Point> resultCoords = TurfMeta.coordAll(polygon, false);
        return INSTANCE.bboxCalculator(resultCoords);
    }

    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull MultiLineString multiLineString) {
        Intrinsics.checkNotNullParameter((Object)multiLineString, (String)"multiLineString");
        List<Point> resultCoords = TurfMeta.coordAll(multiLineString);
        return INSTANCE.bboxCalculator(resultCoords);
    }

    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull MultiPolygon multiPolygon) {
        Intrinsics.checkNotNullParameter((Object)multiPolygon, (String)"multiPolygon");
        List<Point> resultCoords = TurfMeta.coordAll(multiPolygon, false);
        return INSTANCE.bboxCalculator(resultCoords);
    }

    @NotNull
    public final double[] bbox(@NotNull GeoJson geoJson) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)geoJson, (String)"geoJson");
        BoundingBox boundingBox = geoJson.getBbox();
        if (boundingBox != null) {
            double[] dArray2 = new double[]{boundingBox.getWest(), boundingBox.getSouth(), boundingBox.getEast(), boundingBox.getNorth()};
            return dArray2;
        }
        GeoJson geoJson2 = geoJson;
        if (geoJson2 instanceof Geometry) {
            dArray = TurfMeasurement.bbox((Geometry)geoJson);
        } else if (geoJson2 instanceof FeatureCollection) {
            dArray = this.bbox((FeatureCollection)geoJson);
        } else if (geoJson2 instanceof Feature) {
            dArray = this.bbox((Feature)geoJson);
        } else {
            throw new UnsupportedOperationException("bbox type not supported for GeoJson instance");
        }
        return dArray;
    }

    @NotNull
    public final double[] bbox(@NotNull FeatureCollection featureCollection) {
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        return this.bboxCalculator(TurfMeta.coordAll(featureCollection, false));
    }

    @NotNull
    public final double[] bbox(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.bboxCalculator(TurfMeta.coordAll(feature, false));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final double[] bbox(@NotNull Geometry geometry) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Point) {
            dArray = TurfMeasurement.bbox((Point)geometry);
        } else if (geometry2 instanceof MultiPoint) {
            dArray = TurfMeasurement.bbox((MultiPoint)geometry);
        } else if (geometry2 instanceof LineString) {
            dArray = TurfMeasurement.bbox((LineString)geometry);
        } else if (geometry2 instanceof MultiLineString) {
            dArray = TurfMeasurement.bbox((MultiLineString)geometry);
        } else if (geometry2 instanceof Polygon) {
            dArray = TurfMeasurement.bbox((Polygon)geometry);
        } else if (geometry2 instanceof MultiPolygon) {
            dArray = TurfMeasurement.bbox((MultiPolygon)geometry);
        } else if (geometry2 instanceof GeometryCollection) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((GeometryCollection)geometry).getGeometries();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Geometry geo = (Geometry)element$iv$iv;
                boolean bl = false;
                double[] bbox = TurfMeasurement.bbox(geo);
                Object[] objectArray = new Point[]{new Point(bbox[0], bbox[1], null, null, 12, null), new Point(bbox[2], bbox[1], null, null, 12, null), new Point(bbox[2], bbox[3], null, null, 12, null), new Point(bbox[0], bbox[3], null, null, 12, null)};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List points = (List)destination$iv$iv;
            dArray = TurfMeasurement.bbox(new MultiPoint(points, null, 2, null));
        } else {
            throw new RuntimeException("Unknown geometry class: " + Reflection.getOrCreateKotlinClass(geometry.getClass()));
        }
        return dArray;
    }

    private final double[] bboxCalculator(List<? extends Point> resultCoords) {
        double d;
        double d2;
        Point c;
        double[] dArray = new double[4];
        Iterable iterable = resultCoords;
        int n = 0;
        double[] dArray2 = dArray;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Point c2 = (Point)iterator.next();
        boolean bl = false;
        double d3 = c2.getLongitude();
        while (iterator.hasNext()) {
            c = (Point)iterator.next();
            $i$a$-minOf-TurfMeasurement$bboxCalculator$1 = false;
            d2 = c.getLongitude();
            d3 = Math.min(d3, d2);
        }
        dArray2[n] = d = d3;
        iterable = resultCoords;
        n = 1;
        dArray2 = dArray;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        c2 = (Point)iterator.next();
        boolean bl2 = false;
        d3 = c2.getLatitude();
        while (iterator.hasNext()) {
            c = (Point)iterator.next();
            $i$a$-minOf-TurfMeasurement$bboxCalculator$2 = false;
            d2 = c.getLatitude();
            d3 = Math.min(d3, d2);
        }
        dArray2[n] = d = d3;
        iterable = resultCoords;
        n = 2;
        dArray2 = dArray;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        c2 = (Point)iterator.next();
        boolean bl3 = false;
        d3 = c2.getLongitude();
        while (iterator.hasNext()) {
            c = (Point)iterator.next();
            $i$a$-maxOf-TurfMeasurement$bboxCalculator$3 = false;
            d2 = c.getLongitude();
            d3 = Math.max(d3, d2);
        }
        dArray2[n] = d = d3;
        iterable = resultCoords;
        n = 3;
        dArray2 = dArray;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        c2 = (Point)iterator.next();
        boolean bl4 = false;
        d3 = c2.getLatitude();
        while (iterator.hasNext()) {
            c = (Point)iterator.next();
            $i$a$-maxOf-TurfMeasurement$bboxCalculator$4 = false;
            d2 = c.getLatitude();
            d3 = Math.max(d3, d2);
        }
        dArray2[n] = d = d3;
        return dArray;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature bboxPolygon(@NotNull BoundingBox boundingBox, @Nullable Map<String, ? extends JsonElement> properties, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        Object[] objectArray = new Point[]{new Point(boundingBox.getWest(), boundingBox.getSouth(), null, null, 12, null), new Point(boundingBox.getEast(), boundingBox.getSouth(), null, null, 12, null), new Point(boundingBox.getEast(), boundingBox.getNorth(), null, null, 12, null), new Point(boundingBox.getWest(), boundingBox.getNorth(), null, null, 12, null), new Point(boundingBox.getWest(), boundingBox.getSouth(), null, null, 12, null)};
        Map<String, ? extends JsonElement> map = properties;
        return new Feature((Geometry)new Polygon(CollectionsKt.listOf((Object)CollectionsKt.listOf((Object[])objectArray)), null, 2, null), map != null ? MapsKt.toMutableMap(map) : null, id, null, 8, null);
    }

    public static /* synthetic */ Feature bboxPolygon$default(BoundingBox boundingBox, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return TurfMeasurement.bboxPolygon(boundingBox, map, string);
    }

    @JvmOverloads
    @NotNull
    public final Feature bboxPolygon(@NotNull double[] bbox, @Nullable Map<String, ? extends JsonElement> properties, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
        Object[] objectArray = new Point[]{new Point(bbox[0], bbox[1], null, null, 12, null), new Point(bbox[2], bbox[1], null, null, 12, null), new Point(bbox[2], bbox[3], null, null, 12, null), new Point(bbox[0], bbox[3], null, null, 12, null), new Point(bbox[0], bbox[1], null, null, 12, null)};
        Map<String, ? extends JsonElement> map = properties;
        return new Feature((Geometry)new Polygon(CollectionsKt.listOf((Object)CollectionsKt.listOf((Object[])objectArray)), null, 2, null), map != null ? MapsKt.toMutableMap(map) : null, id, null, 8, null);
    }

    public static /* synthetic */ Feature bboxPolygon$default(TurfMeasurement turfMeasurement, double[] dArray, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return turfMeasurement.bboxPolygon(dArray, map, string);
    }

    @JvmStatic
    @Nullable
    public static final Polygon envelope(@NotNull GeoJson geoJson) {
        Intrinsics.checkNotNullParameter((Object)geoJson, (String)"geoJson");
        return (Polygon)TurfMeasurement.bboxPolygon$default(INSTANCE, INSTANCE.bbox(geoJson), null, null, 6, null).getGeometry();
    }

    @JvmStatic
    @NotNull
    public static final BoundingBox square(@NotNull BoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        double horizontalDistance = TurfMeasurement.distance$default(boundingBox.getSouthwest(), new Point(boundingBox.getEast(), boundingBox.getSouth(), null, null, 12, null), null, 4, null);
        double verticalDistance = TurfMeasurement.distance$default(new Point(boundingBox.getWest(), boundingBox.getSouth(), null, null, 12, null), new Point(boundingBox.getWest(), boundingBox.getNorth(), null, null, 12, null), null, 4, null);
        if (horizontalDistance >= verticalDistance) {
            double verticalMidpoint = (boundingBox.getSouth() + boundingBox.getNorth()) / (double)2;
            return new BoundingBox(boundingBox.getWest(), verticalMidpoint - (boundingBox.getEast() - boundingBox.getWest()) / (double)2, boundingBox.getEast(), verticalMidpoint + (boundingBox.getEast() - boundingBox.getWest()) / (double)2, null, null, 48, null);
        }
        double horizontalMidpoint = (boundingBox.getWest() + boundingBox.getEast()) / (double)2;
        return new BoundingBox(horizontalMidpoint - (boundingBox.getNorth() - boundingBox.getSouth()) / (double)2, boundingBox.getSouth(), horizontalMidpoint + (boundingBox.getNorth() - boundingBox.getSouth()) / (double)2, boundingBox.getNorth(), null, null, 48, null);
    }

    @JvmStatic
    public static final double area(@NotNull Feature feature) {
        double d;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Geometry geometry = feature.getGeometry();
        if (geometry != null) {
            Geometry geometry2 = geometry;
            boolean bl = false;
            d = TurfMeasurement.area(geometry2);
        } else {
            d = 0.0;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final double area(@NotNull FeatureCollection featureCollection) {
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        Iterable iterable = featureCollection.getFeatures();
        double d = 0.0;
        for (Object t : iterable) {
            void feature;
            Feature feature2 = (Feature)t;
            double d2 = d;
            boolean bl = false;
            double d3 = TurfMeasurement.area((Feature)feature);
            d = d2 + d3;
        }
        return d;
    }

    @JvmStatic
    public static final double area(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        return INSTANCE.calculateArea(geometry);
    }

    /*
     * WARNING - void declaration
     */
    private final double calculateArea(Geometry geometry) {
        double d;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Polygon) {
            d = this.polygonArea(((Polygon)geometry).getCoordinates());
        } else if (geometry2 instanceof MultiPolygon) {
            Iterable iterable = ((MultiPolygon)geometry).getCoordinates();
            double d2 = 0.0;
            for (Object t : iterable) {
                void coordinates;
                List list = (List)t;
                double d3 = d2;
                boolean bl = false;
                double d4 = INSTANCE.polygonArea((List<? extends List<? extends Point>>)coordinates);
                d2 = d3 + d4;
            }
            d = d2;
        } else {
            d = 0.0;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private final double polygonArea(List<? extends List<? extends Point>> coordinates) {
        double d;
        if (coordinates.isEmpty()) {
            return 0.0;
        }
        Iterable iterable = CollectionsKt.drop((Iterable)coordinates, (int)1);
        double d2 = Math.abs(this.ringArea((List)CollectionsKt.first(coordinates)));
        double d3 = 0.0;
        for (Object t : iterable) {
            void c;
            List list = (List)t;
            d = d3;
            boolean bl = false;
            double d4 = Math.abs(INSTANCE.ringArea((List<? extends Point>)c));
            d3 = d + d4;
        }
        d = d3;
        return d2 - d;
    }

    private final double ringArea(List<? extends Point> coordinates) {
        Point p1 = null;
        Point p2 = null;
        Point p3 = null;
        int lowerIndex = 0;
        int middleIndex = 0;
        int upperIndex = 0;
        double total = 0.0;
        int coordsLength = coordinates.size();
        if (coordsLength > 2) {
            for (int i = 0; i < coordsLength; ++i) {
                int n = i;
                if (n == coordsLength - 2) {
                    lowerIndex = coordsLength - 2;
                    middleIndex = coordsLength - 1;
                    upperIndex = 0;
                } else if (n == coordsLength - 1) {
                    lowerIndex = coordsLength - 1;
                    middleIndex = 0;
                    upperIndex = 1;
                } else {
                    lowerIndex = i;
                    middleIndex = i + 1;
                    upperIndex = i + 2;
                }
                p1 = coordinates.get(lowerIndex);
                p2 = coordinates.get(middleIndex);
                p3 = coordinates.get(upperIndex);
                total += (this.rad(p3.getLongitude()) - this.rad(p1.getLongitude())) * Math.sin(this.rad(p2.getLatitude()));
            }
            total = total * EARTH_RADIUS * EARTH_RADIUS / (double)2;
        }
        return total;
    }

    private final double rad(double num) {
        return num * Math.PI / (double)180;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature center(@NotNull Feature feature, @Nullable Map<String, ? extends JsonElement> properties, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return TurfMeasurement.center(new FeatureCollection(feature, null, 2, null), properties, id);
    }

    public static /* synthetic */ Feature center$default(Feature feature, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return TurfMeasurement.center(feature, (Map<String, ? extends JsonElement>)map, string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature center(@NotNull FeatureCollection featureCollection, @Nullable Map<String, ? extends JsonElement> properties, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        double[] ext = INSTANCE.bbox(featureCollection);
        double finalCenterLongitude = (ext[0] + ext[2]) / (double)2;
        double finalCenterLatitude = (ext[1] + ext[3]) / (double)2;
        Map<String, ? extends JsonElement> map = properties;
        return new Feature((Geometry)new Point(finalCenterLongitude, finalCenterLatitude, null, null, 12, null), map != null ? MapsKt.toMutableMap(map) : null, id, null, 8, null);
    }

    public static /* synthetic */ Feature center$default(FeatureCollection featureCollection, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return TurfMeasurement.center(featureCollection, (Map<String, ? extends JsonElement>)map, string);
    }

    @JvmStatic
    @JvmOverloads
    public static final double distance(@NotNull Point point1, @NotNull Point point2) {
        Intrinsics.checkNotNullParameter((Object)point1, (String)"point1");
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point2");
        return TurfMeasurement.distance$default(point1, point2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature bboxPolygon(@NotNull BoundingBox boundingBox, @Nullable Map<String, ? extends JsonElement> properties) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        return TurfMeasurement.bboxPolygon$default(boundingBox, properties, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature bboxPolygon(@NotNull BoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        return TurfMeasurement.bboxPolygon$default(boundingBox, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Feature bboxPolygon(@NotNull double[] bbox, @Nullable Map<String, ? extends JsonElement> properties) {
        Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
        return TurfMeasurement.bboxPolygon$default(this, bbox, properties, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Feature bboxPolygon(@NotNull double[] bbox) {
        Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
        return TurfMeasurement.bboxPolygon$default(this, bbox, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature center(@NotNull Feature feature, @Nullable Map<String, ? extends JsonElement> properties) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return TurfMeasurement.center$default(feature, properties, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature center(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return TurfMeasurement.center$default(feature, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature center(@NotNull FeatureCollection featureCollection, @Nullable Map<String, ? extends JsonElement> properties) {
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        return TurfMeasurement.center$default(featureCollection, properties, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature center(@NotNull FeatureCollection featureCollection) {
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        return TurfMeasurement.center$default(featureCollection, null, null, 6, null);
    }
}

