/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.geojson.turf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.model.Feature;
import org.maplibre.geojson.model.Geometry;
import org.maplibre.geojson.model.LineString;
import org.maplibre.geojson.model.Point;
import org.maplibre.geojson.turf.TurfException;
import org.maplibre.geojson.turf.TurfMeasurement;
import org.maplibre.geojson.turf.TurfUnit;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002%&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0007J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J(\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0013H\u0002JJ\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/maplibre/geojson/turf/TurfMisc;", "", "<init>", "()V", "INDEX_KEY", "", "DISTANCE_KEY", "lineSlice", "Lorg/maplibre/geojson/model/LineString;", "startPt", "Lorg/maplibre/geojson/model/Point;", "stopPt", "line", "Lorg/maplibre/geojson/model/Feature;", "lineSliceAlong", "startDist", "", "stopDist", "unit", "Lorg/maplibre/geojson/turf/TurfUnit;", "nearestPointOnLine", "point", "coordinates", "", "nearestPointOnLineInternal", "Lorg/maplibre/geojson/turf/TurfMisc$DistancePoint;", "units", "lineIntersects", "Lorg/maplibre/geojson/turf/TurfMisc$LineIntersects;", "line1StartX", "line1StartY", "line1EndX", "line1EndY", "line2StartX", "line2StartY", "line2EndX", "line2EndY", "LineIntersects", "DistancePoint", "services-turf"})
@SourceDebugExtension(value={"SMAP\nTurfMisc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurfMisc.kt\norg/maplibre/geojson/turf/TurfMisc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1#2:389\n*E\n"})
public final class TurfMisc {
    @NotNull
    public static final TurfMisc INSTANCE = new TurfMisc();
    @NotNull
    private static final String INDEX_KEY = "index";
    @NotNull
    private static final String DISTANCE_KEY = "dist";

    private TurfMisc() {
    }

    @JvmStatic
    @NotNull
    public static final LineString lineSlice(@NotNull Point startPt, @NotNull Point stopPt, @NotNull Feature line) {
        LineString lineString;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)startPt, (String)"startPt");
                Intrinsics.checkNotNullParameter((Object)stopPt, (String)"stopPt");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Geometry geometry = line.getGeometry();
                lineString = geometry instanceof LineString ? (LineString)geometry : null;
                if (lineString == null) break block2;
                LineString lineString2 = lineString;
                boolean bl = false;
                LineString lineString3 = TurfMisc.lineSlice(startPt, stopPt, lineString2);
                lineString = lineString3;
                if (lineString3 != null) break block3;
            }
            throw new TurfException("line must be a LineString");
        }
        return lineString;
    }

    @JvmStatic
    @NotNull
    public static final LineString lineSlice(@NotNull Point startPt, @NotNull Point stopPt, @NotNull LineString line) {
        Intrinsics.checkNotNullParameter((Object)startPt, (String)"startPt");
        Intrinsics.checkNotNullParameter((Object)stopPt, (String)"stopPt");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        List coordinates = line.getCoordinates();
        if (coordinates.size() < 2) {
            throw new TurfException("Turf lineSlice requires a LineString made up of at least 2 coordinates.");
        }
        if (Intrinsics.areEqual((Object)startPt, (Object)stopPt)) {
            throw new TurfException("Start and stop points in Turf lineSlice cannot equal each other.");
        }
        DistancePoint startVertex = TurfMisc.nearestPointOnLineInternal$default(INSTANCE, startPt, coordinates, null, 4, null);
        DistancePoint stopVertex = TurfMisc.nearestPointOnLineInternal$default(INSTANCE, stopPt, coordinates, null, 4, null);
        List ends = new ArrayList();
        if (startVertex.getIndex() <= stopVertex.getIndex()) {
            ends.add(startVertex);
            v0 = ends.add(stopVertex);
        } else {
            ends.add(stopVertex);
            v0 = ends.add(startVertex);
        }
        List points = new ArrayList();
        points.add(((DistancePoint)ends.get(0)).getPoint());
        int n = ((DistancePoint)ends.get(1)).getIndex() + 1;
        for (int i = ((DistancePoint)ends.get(0)).getIndex() + 1; i < n; ++i) {
            points.add(coordinates.get(i));
        }
        points.add(((DistancePoint)ends.get(1)).getPoint());
        return new LineString(points, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final LineString lineSliceAlong(@NotNull Feature line, double startDist, double stopDist, @NotNull TurfUnit unit) {
        LineString lineString;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
                Geometry geometry = line.getGeometry();
                lineString = geometry instanceof LineString ? (LineString)geometry : null;
                if (lineString == null) break block2;
                LineString lineString2 = lineString;
                boolean bl = false;
                LineString lineString3 = TurfMisc.lineSliceAlong(lineString2, startDist, stopDist, unit);
                lineString = lineString3;
                if (lineString3 != null) break block3;
            }
            throw new TurfException("line must be a LineString");
        }
        return lineString;
    }

    @JvmStatic
    @NotNull
    public static final LineString lineSliceAlong(@NotNull LineString line, double startDist, double stopDist, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(startDist >= 0.0)) {
            boolean $i$a$-require-TurfMisc$lineSliceAlong$42 = false;
            String $i$a$-require-TurfMisc$lineSliceAlong$42 = "startDist must be greater than or equal 0";
            throw new IllegalArgumentException($i$a$-require-TurfMisc$lineSliceAlong$42.toString());
        }
        if (!(stopDist > 0.0)) {
            boolean bl = false;
            String string = "stopDist must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        List coordinates = line.getCoordinates();
        if (coordinates.size() < 2) {
            throw new TurfException("Turf lineSlice requires a LineString made up of at least 2 coordinates.");
        }
        if (startDist == stopDist) {
            throw new TurfException("Start and stop distance in Turf lineSliceAlong cannot equal each other.");
        }
        double travelled = 0.0;
        List slicedLinePoints = new ArrayList();
        Iterator iterator = ((Iterable)coordinates).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Point upcomingPoint;
            int index = n++;
            Point point = (Point)iterator.next();
            if (travelled >= startDist) {
                Point interpolated;
                double direction;
                double overshot;
                if (slicedLinePoints.size() == 0) {
                    overshot = startDist - travelled;
                    if (overshot == 0.0 || index == 0) {
                        v0 = slicedLinePoints.add(point);
                    } else {
                        direction = TurfMeasurement.bearing(point, (Point)coordinates.get(index - 1)) - (double)180;
                        interpolated = TurfMeasurement.destination(point, overshot, direction, unit);
                        v0 = slicedLinePoints.add(interpolated);
                    }
                }
                if (travelled >= stopDist) {
                    boolean bl;
                    overshot = stopDist - travelled;
                    if (overshot == 0.0 || index == 0) {
                        bl = slicedLinePoints.add(point);
                        break;
                    }
                    direction = TurfMeasurement.bearing(point, (Point)coordinates.get(index - 1)) - (double)180;
                    interpolated = TurfMeasurement.destination(point, overshot, direction, unit);
                    bl = slicedLinePoints.add(interpolated);
                    break;
                }
                slicedLinePoints.add(point);
            }
            if ((Point)CollectionsKt.getOrNull((List)coordinates, (int)(index + 1)) == null) continue;
            boolean bl = false;
            travelled += TurfMeasurement.distance(point, upcomingPoint, unit);
        }
        if (travelled < startDist) {
            throw new TurfException("Start position is beyond line");
        }
        return new LineString(slicedLinePoints, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature nearestPointOnLine(@NotNull Point point, @NotNull List<? extends Point> coordinates, @NotNull TurfUnit unit) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        DistancePoint distancePoint = INSTANCE.nearestPointOnLineInternal(point, coordinates, unit);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)INDEX_KEY, (Object)JsonElementKt.JsonPrimitive((Number)distancePoint.getIndex())), TuplesKt.to((Object)DISTANCE_KEY, (Object)JsonElementKt.JsonPrimitive((Number)distancePoint.getDistance()))};
        return new Feature((Geometry)distancePoint.getPoint(), MapsKt.mutableMapOf((Pair[])pairArray), null, null, 12, null);
    }

    public static /* synthetic */ Feature nearestPointOnLine$default(Point point, List list, TurfUnit turfUnit, int n, Object object) {
        if ((n & 4) != 0) {
            turfUnit = TurfUnit.Companion.getDEFAULT();
        }
        return TurfMisc.nearestPointOnLine(point, list, turfUnit);
    }

    private final DistancePoint nearestPointOnLineInternal(Point point, List<? extends Point> coordinates, TurfUnit units) {
        if (coordinates.size() < 2) {
            throw new TurfException("Turf nearestPointOnLine requires a List of Points made up of at least 2 coordinates.");
        }
        DistancePoint closestPt = new DistancePoint(new Point(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, null, null, 12, null), Double.POSITIVE_INFINITY, 0);
        int n = coordinates.size() - 1;
        for (int i = 0; i < n; ++i) {
            DistancePoint start = new DistancePoint(coordinates.get(i), TurfMeasurement.distance(point, coordinates.get(i), units), -1);
            DistancePoint stop = new DistancePoint(coordinates.get(i + 1), TurfMeasurement.distance(point, coordinates.get(i + 1), units), -1);
            double heightDistance = Math.max(start.getDistance(), stop.getDistance());
            double direction = TurfMeasurement.bearing(start.getPoint(), stop.getPoint());
            Point perpendicularPt1 = TurfMeasurement.destination(point, heightDistance, direction + (double)90, units);
            Point perpendicularPt2 = TurfMeasurement.destination(point, heightDistance, direction - (double)90, units);
            LineIntersects intersect = this.lineIntersects(perpendicularPt1.getLongitude(), perpendicularPt1.getLatitude(), perpendicularPt2.getLongitude(), perpendicularPt2.getLatitude(), start.getPoint().getLongitude(), start.getPoint().getLatitude(), stop.getPoint().getLongitude(), stop.getPoint().getLatitude());
            DistancePoint intersectDistancePoint = null;
            if (intersect != null) {
                Double d = intersect.getHorizontalIntersection();
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = intersect.getVerticalIntersection();
                Intrinsics.checkNotNull((Object)d3);
                Point intersectPoint = new Point(d2, d3.doubleValue(), null, null, 12, null);
                intersectDistancePoint = new DistancePoint(intersectPoint, TurfMeasurement.distance(point, intersectPoint, units), -1);
            }
            if (start.getDistance() < closestPt.getDistance()) {
                closestPt = DistancePoint.copy$default(start, null, 0.0, i, 3, null);
            }
            if (stop.getDistance() < closestPt.getDistance()) {
                closestPt = DistancePoint.copy$default(stop, null, 0.0, i, 3, null);
            }
            if (intersectDistancePoint == null || !(intersectDistancePoint.getDistance() < closestPt.getDistance())) continue;
            closestPt = DistancePoint.copy$default(intersectDistancePoint, null, 0.0, i, 3, null);
        }
        return closestPt;
    }

    static /* synthetic */ DistancePoint nearestPointOnLineInternal$default(TurfMisc turfMisc, Point point, List list, TurfUnit turfUnit, int n, Object object) {
        if ((n & 4) != 0) {
            turfUnit = TurfUnit.KILOMETERS;
        }
        return turfMisc.nearestPointOnLineInternal(point, list, turfUnit);
    }

    private final LineIntersects lineIntersects(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
        LineIntersects result = new LineIntersects(null, null, false, false, 3, null);
        double denominator = (line2EndY - line2StartY) * (line1EndX - line1StartX) - (line2EndX - line2StartX) * (line1EndY - line1StartY);
        if (denominator == 0.0) {
            return result.getHorizontalIntersection() != null && result.getVerticalIntersection() != null ? result : null;
        }
        double varA = line1StartY - line2StartY;
        double varB = line1StartX - line2StartX;
        double numerator1 = (line2EndX - line2StartX) * varA - (line2EndY - line2StartY) * varB;
        double numerator2 = (line1EndX - line1StartX) * varA - (line1EndY - line1StartY) * varB;
        varA = numerator1 / denominator;
        varB = numerator2 / denominator;
        result = LineIntersects.copy$default(result, line1StartX + varA * (line1EndX - line1StartX), line1StartY + varA * (line1EndY - line1StartY), false, false, 12, null);
        if (varA > 0.0 && varA < 1.0) {
            result = LineIntersects.copy$default(result, null, null, true, false, 11, null);
        }
        if (varB > 0.0 && varB < 1.0) {
            result = LineIntersects.copy$default(result, null, null, false, true, 7, null);
        }
        return result.getOnLine1() && result.getOnLine2() ? result : null;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Feature nearestPointOnLine(@NotNull Point point, @NotNull List<? extends Point> coordinates) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return TurfMisc.nearestPointOnLine$default(point, coordinates, null, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/maplibre/geojson/turf/TurfMisc$DistancePoint;", "", "point", "Lorg/maplibre/geojson/model/Point;", "distance", "", "index", "", "<init>", "(Lorg/maplibre/geojson/model/Point;DI)V", "getPoint", "()Lorg/maplibre/geojson/model/Point;", "getDistance", "()D", "getIndex", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "services-turf"})
    private static final class DistancePoint {
        @NotNull
        private final Point point;
        private final double distance;
        private final int index;

        public DistancePoint(@NotNull Point point, double distance, int index) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            this.point = point;
            this.distance = distance;
            this.index = index;
        }

        @NotNull
        public final Point getPoint() {
            return this.point;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final Point component1() {
            return this.point;
        }

        public final double component2() {
            return this.distance;
        }

        public final int component3() {
            return this.index;
        }

        @NotNull
        public final DistancePoint copy(@NotNull Point point, double distance, int index) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return new DistancePoint(point, distance, index);
        }

        public static /* synthetic */ DistancePoint copy$default(DistancePoint distancePoint, Point point, double d, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                point = distancePoint.point;
            }
            if ((n2 & 2) != 0) {
                d = distancePoint.distance;
            }
            if ((n2 & 4) != 0) {
                n = distancePoint.index;
            }
            return distancePoint.copy(point, d, n);
        }

        @NotNull
        public String toString() {
            return "DistancePoint(point=" + this.point + ", distance=" + this.distance + ", index=" + this.index + ")";
        }

        public int hashCode() {
            int result = this.point.hashCode();
            result = result * 31 + Double.hashCode(this.distance);
            result = result * 31 + Integer.hashCode(this.index);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DistancePoint)) {
                return false;
            }
            DistancePoint distancePoint = (DistancePoint)other;
            if (!Intrinsics.areEqual((Object)this.point, (Object)distancePoint.point)) {
                return false;
            }
            if (Double.compare(this.distance, distancePoint.distance) != 0) {
                return false;
            }
            return this.index == distancePoint.index;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J:\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/maplibre/geojson/turf/TurfMisc$LineIntersects;", "", "horizontalIntersection", "", "verticalIntersection", "onLine1", "", "onLine2", "<init>", "(Ljava/lang/Double;Ljava/lang/Double;ZZ)V", "getHorizontalIntersection", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getVerticalIntersection", "getOnLine1", "()Z", "getOnLine2", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Double;Ljava/lang/Double;ZZ)Lorg/maplibre/geojson/turf/TurfMisc$LineIntersects;", "equals", "other", "hashCode", "", "toString", "", "services-turf"})
    private static final class LineIntersects {
        @Nullable
        private final Double horizontalIntersection;
        @Nullable
        private final Double verticalIntersection;
        private final boolean onLine1;
        private final boolean onLine2;

        public LineIntersects(@Nullable Double horizontalIntersection, @Nullable Double verticalIntersection, boolean onLine1, boolean onLine2) {
            this.horizontalIntersection = horizontalIntersection;
            this.verticalIntersection = verticalIntersection;
            this.onLine1 = onLine1;
            this.onLine2 = onLine2;
        }

        public /* synthetic */ LineIntersects(Double d, Double d2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = null;
            }
            if ((n & 2) != 0) {
                d2 = null;
            }
            this(d, d2, bl, bl2);
        }

        @Nullable
        public final Double getHorizontalIntersection() {
            return this.horizontalIntersection;
        }

        @Nullable
        public final Double getVerticalIntersection() {
            return this.verticalIntersection;
        }

        public final boolean getOnLine1() {
            return this.onLine1;
        }

        public final boolean getOnLine2() {
            return this.onLine2;
        }

        @Nullable
        public final Double component1() {
            return this.horizontalIntersection;
        }

        @Nullable
        public final Double component2() {
            return this.verticalIntersection;
        }

        public final boolean component3() {
            return this.onLine1;
        }

        public final boolean component4() {
            return this.onLine2;
        }

        @NotNull
        public final LineIntersects copy(@Nullable Double horizontalIntersection, @Nullable Double verticalIntersection, boolean onLine1, boolean onLine2) {
            return new LineIntersects(horizontalIntersection, verticalIntersection, onLine1, onLine2);
        }

        public static /* synthetic */ LineIntersects copy$default(LineIntersects lineIntersects, Double d, Double d2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                d = lineIntersects.horizontalIntersection;
            }
            if ((n & 2) != 0) {
                d2 = lineIntersects.verticalIntersection;
            }
            if ((n & 4) != 0) {
                bl = lineIntersects.onLine1;
            }
            if ((n & 8) != 0) {
                bl2 = lineIntersects.onLine2;
            }
            return lineIntersects.copy(d, d2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "LineIntersects(horizontalIntersection=" + this.horizontalIntersection + ", verticalIntersection=" + this.verticalIntersection + ", onLine1=" + this.onLine1 + ", onLine2=" + this.onLine2 + ")";
        }

        public int hashCode() {
            int result = this.horizontalIntersection == null ? 0 : ((Object)this.horizontalIntersection).hashCode();
            result = result * 31 + (this.verticalIntersection == null ? 0 : ((Object)this.verticalIntersection).hashCode());
            result = result * 31 + Boolean.hashCode(this.onLine1);
            result = result * 31 + Boolean.hashCode(this.onLine2);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineIntersects)) {
                return false;
            }
            LineIntersects lineIntersects = (LineIntersects)other;
            if (!Intrinsics.areEqual((Object)this.horizontalIntersection, (Object)lineIntersects.horizontalIntersection)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.verticalIntersection, (Object)lineIntersects.verticalIntersection)) {
                return false;
            }
            if (this.onLine1 != lineIntersects.onLine1) {
                return false;
            }
            return this.onLine2 == lineIntersects.onLine2;
        }
    }
}

