/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.os.HandlerCaller;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AccessibilityService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int GESTURE_SWIPE_UP = 1;
    public static int GESTURE_SWIPE_DOWN = 2;
    public static int GESTURE_SWIPE_LEFT = 3;
    public static int GESTURE_SWIPE_RIGHT = 4;
    public static int GESTURE_SWIPE_LEFT_AND_RIGHT = 5;
    public static int GESTURE_SWIPE_RIGHT_AND_LEFT = 6;
    public static int GESTURE_SWIPE_UP_AND_DOWN = 7;
    public static int GESTURE_SWIPE_DOWN_AND_UP = 8;
    public static int GESTURE_SWIPE_LEFT_AND_UP = 9;
    public static int GESTURE_SWIPE_LEFT_AND_DOWN = 10;
    public static int GESTURE_SWIPE_RIGHT_AND_UP = 11;
    public static int GESTURE_SWIPE_RIGHT_AND_DOWN = 12;
    public static int GESTURE_SWIPE_UP_AND_LEFT = 13;
    public static int GESTURE_SWIPE_UP_AND_RIGHT = 14;
    public static int GESTURE_SWIPE_DOWN_AND_LEFT = 15;
    public static int GESTURE_SWIPE_DOWN_AND_RIGHT = 16;
    public static String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";
    public static String SERVICE_META_DATA = "android.accessibilityservice";
    public static int GLOBAL_ACTION_BACK = 1;
    public static int GLOBAL_ACTION_HOME = 2;
    public static int GLOBAL_ACTION_RECENTS = 3;
    public static int GLOBAL_ACTION_NOTIFICATIONS = 4;
    public static int GLOBAL_ACTION_QUICK_SETTINGS = 5;
    public static int GLOBAL_ACTION_POWER_DIALOG = 6;
    private static String LOG_TAG = "AccessibilityService";
    private int mConnectionId;
    private AccessibilityServiceInfo mInfo;

    private void $$robo$$android_accessibilityservice_AccessibilityService$__constructor__() {
    }

    public abstract void onAccessibilityEvent(AccessibilityEvent var1);

    public abstract void onInterrupt();

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onServiceConnected() {
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$onGesture(int gestureId) {
        return false;
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$onKeyEvent(KeyEvent event) {
        return false;
    }

    private final List<AccessibilityWindowInfo> $$robo$$android_accessibilityservice_AccessibilityService$getWindows() {
        return AccessibilityInteractionClient.getInstance().getWindows(this.mConnectionId);
    }

    private final AccessibilityNodeInfo $$robo$$android_accessibilityservice_AccessibilityService$getRootInActiveWindow() {
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(this.mConnectionId);
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$performGlobalAction(int action) {
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w("AccessibilityService", "Error while calling performGlobalAction", re);
            }
        }
        return false;
    }

    private final AccessibilityNodeInfo $$robo$$android_accessibilityservice_AccessibilityService$findFocus(int focus) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    private final AccessibilityServiceInfo $$robo$$android_accessibilityservice_AccessibilityService$getServiceInfo() {
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w("AccessibilityService", "Error while getting AccessibilityServiceInfo", re);
            }
        }
        return null;
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$setServiceInfo(AccessibilityServiceInfo info) {
        this.mInfo = info;
        this.sendServiceInfo();
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$sendServiceInfo() {
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        if (this.mInfo != null && connection != null) {
            try {
                connection.setServiceInfo(this.mInfo);
                this.mInfo = null;
                AccessibilityInteractionClient.getInstance().clearCache();
            }
            catch (RemoteException re) {
                Log.w("AccessibilityService", "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    private final IBinder $$robo$$android_accessibilityservice_AccessibilityService$onBind(Intent intent) {
        return new IAccessibilityServiceClientWrapper(this, this.getMainLooper(), new Callbacks(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccessibilityService this$0;

            private void $$robo$$android_accessibilityservice_AccessibilityService_1$__constructor__(AccessibilityService accessibilityService) {
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_1$onServiceConnected() {
                this.this$0.onServiceConnected();
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_1$onInterrupt() {
                this.this$0.onInterrupt();
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_1$onAccessibilityEvent(AccessibilityEvent event) {
                this.this$0.onAccessibilityEvent(event);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_1$onSetConnectionId(int connectionId) {
                this.this$0.mConnectionId = connectionId;
            }

            private final boolean $$robo$$android_accessibilityservice_AccessibilityService_1$onGesture(int gestureId) {
                return this.this$0.onGesture(gestureId);
            }

            private final boolean $$robo$$android_accessibilityservice_AccessibilityService_1$onKeyEvent(KeyEvent event) {
                return this.this$0.onKeyEvent(event);
            }

            private void __constructor__(AccessibilityService accessibilityService) {
                this.$$robo$$android_accessibilityservice_AccessibilityService_1$__constructor__(accessibilityService);
            }
            {
                this.this$0 = accessibilityService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_1$__constructor__(android.accessibilityservice.AccessibilityService ), 0, this, accessibilityService);
            }

            @Override
            public void onServiceConnected() {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService_1$onServiceConnected(), 0, this);
            }

            @Override
            public void onInterrupt() {
                InvokeDynamicSupport.bootstrap("onInterrupt", $$robo$$android_accessibilityservice_AccessibilityService_1$onInterrupt(), 0, this);
            }

            @Override
            public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
                InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_accessibilityservice_AccessibilityService_1$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
            }

            @Override
            public void onSetConnectionId(int n) {
                InvokeDynamicSupport.bootstrap("onSetConnectionId", $$robo$$android_accessibilityservice_AccessibilityService_1$onSetConnectionId(int ), 0, this, n);
            }

            @Override
            public boolean onGesture(int n) {
                return (boolean)InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_AccessibilityService_1$onGesture(int ), 0, this, n);
            }

            @Override
            public boolean onKeyEvent(KeyEvent keyEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_accessibilityservice_AccessibilityService_1$onKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private void __constructor__() {
        this.$$robo$$android_accessibilityservice_AccessibilityService$__constructor__();
    }

    public AccessibilityService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService$__constructor__(), 0, this);
    }

    protected void onServiceConnected() {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService$onServiceConnected(), 0, this);
    }

    protected boolean onGesture(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_AccessibilityService$onGesture(int ), 0, this, n);
    }

    protected boolean onKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_accessibilityservice_AccessibilityService$onKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public List<AccessibilityWindowInfo> getWindows() {
        return InvokeDynamicSupport.bootstrap("getWindows", $$robo$$android_accessibilityservice_AccessibilityService$getWindows(), 0, this);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return InvokeDynamicSupport.bootstrap("getRootInActiveWindow", $$robo$$android_accessibilityservice_AccessibilityService$getRootInActiveWindow(), 0, this);
    }

    public boolean performGlobalAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performGlobalAction", $$robo$$android_accessibilityservice_AccessibilityService$performGlobalAction(int ), 0, this, n);
    }

    public AccessibilityNodeInfo findFocus(int n) {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_accessibilityservice_AccessibilityService$findFocus(int ), 0, this, n);
    }

    public AccessibilityServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_accessibilityservice_AccessibilityService$getServiceInfo(), 0, this);
    }

    public void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) {
        InvokeDynamicSupport.bootstrap("setServiceInfo", $$robo$$android_accessibilityservice_AccessibilityService$setServiceInfo(android.accessibilityservice.AccessibilityServiceInfo ), 0, this, accessibilityServiceInfo);
    }

    private void sendServiceInfo() {
        InvokeDynamicSupport.bootstrap("sendServiceInfo", $$robo$$android_accessibilityservice_AccessibilityService$sendServiceInfo(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_accessibilityservice_AccessibilityService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class IAccessibilityServiceClientWrapper
    extends IAccessibilityServiceClient.Stub
    implements HandlerCaller.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DO_SET_SET_CONNECTION = 1;
        private static int DO_ON_INTERRUPT = 2;
        private static int DO_ON_ACCESSIBILITY_EVENT = 3;
        private static int DO_ON_GESTURE = 4;
        private static int DO_CLEAR_ACCESSIBILITY_CACHE = 5;
        private static int DO_ON_KEY_EVENT = 6;
        private HandlerCaller mCaller;
        private Callbacks mCallback;
        private int mConnectionId;

        private void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$__constructor__(Context context, Looper looper, Callbacks callback) {
            this.mCallback = callback;
            this.mCaller = new HandlerCaller(context, looper, this, true);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$setConnection(IAccessibilityServiceConnection connection, int connectionId) {
            Message message = this.mCaller.obtainMessageIO(1, connectionId, connection);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onInterrupt() {
            Message message = this.mCaller.obtainMessage(2);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityEvent(AccessibilityEvent event) {
            Message message = this.mCaller.obtainMessageO(3, event);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onGesture(int gestureId) {
            Message message = this.mCaller.obtainMessageI(4, gestureId);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$clearAccessibilityCache() {
            Message message = this.mCaller.obtainMessage(5);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onKeyEvent(KeyEvent event, int sequence) {
            Message message = this.mCaller.obtainMessageIO(6, sequence, event);
            this.mCaller.sendMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$executeMessage(Message message) {
            switch (message.what) {
                case 3: {
                    AccessibilityEvent event = (AccessibilityEvent)message.obj;
                    if (event != null) {
                        AccessibilityInteractionClient.getInstance().onAccessibilityEvent(event);
                        this.mCallback.onAccessibilityEvent(event);
                        try {
                            event.recycle();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                case 2: {
                    this.mCallback.onInterrupt();
                    return;
                }
                case 1: {
                    this.mConnectionId = message.arg1;
                    IAccessibilityServiceConnection connection = (IAccessibilityServiceConnection)message.obj;
                    if (connection != null) {
                        AccessibilityInteractionClient.getInstance().addConnection(this.mConnectionId, connection);
                        this.mCallback.onSetConnectionId(this.mConnectionId);
                        this.mCallback.onServiceConnected();
                    } else {
                        AccessibilityInteractionClient.getInstance().removeConnection(this.mConnectionId);
                        AccessibilityInteractionClient.getInstance().clearCache();
                        this.mCallback.onSetConnectionId(-1);
                    }
                    return;
                }
                case 4: {
                    int gestureId = message.arg1;
                    this.mCallback.onGesture(gestureId);
                    return;
                }
                case 5: {
                    AccessibilityInteractionClient.getInstance().clearCache();
                    return;
                }
                case 6: {
                    KeyEvent event = (KeyEvent)message.obj;
                    try {
                        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
                        if (connection != null) {
                            boolean result = this.mCallback.onKeyEvent(event);
                            int sequence = message.arg1;
                            try {
                                connection.setOnKeyEventResult(result, sequence);
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        try {
                            event.recycle();
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    return;
                }
            }
            Log.w("AccessibilityService", "Unknown message type " + message.what);
        }

        private void __constructor__(Context context, Looper looper, Callbacks callbacks) {
            this.$$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$__constructor__(context, looper, callbacks);
        }

        public IAccessibilityServiceClientWrapper(Context context, Looper looper, Callbacks callbacks) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$__constructor__(android.content.Context android.os.Looper android.accessibilityservice.AccessibilityService$Callbacks ), 0, this, context, looper, callbacks);
        }

        @Override
        public void setConnection(IAccessibilityServiceConnection iAccessibilityServiceConnection, int n) {
            InvokeDynamicSupport.bootstrap("setConnection", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$setConnection(android.accessibilityservice.IAccessibilityServiceConnection int ), 0, this, iAccessibilityServiceConnection, n);
        }

        @Override
        public void onInterrupt() {
            InvokeDynamicSupport.bootstrap("onInterrupt", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onInterrupt(), 0, this);
        }

        @Override
        public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
        }

        @Override
        public void onGesture(int n) {
            InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onGesture(int ), 0, this, n);
        }

        @Override
        public void clearAccessibilityCache() {
            InvokeDynamicSupport.bootstrap("clearAccessibilityCache", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$clearAccessibilityCache(), 0, this);
        }

        @Override
        public void onKeyEvent(KeyEvent keyEvent, int n) {
            InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onKeyEvent(android.view.KeyEvent int ), 0, this, keyEvent, n);
        }

        @Override
        public void executeMessage(Message message) {
            InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$executeMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ IAccessibilityServiceClientWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IAccessibilityServiceClientWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callbacks
    extends InstrumentedInterface {
        public void onAccessibilityEvent(AccessibilityEvent var1);

        public void onInterrupt();

        public void onServiceConnected();

        public void onSetConnectionId(int var1);

        public boolean onGesture(int var1);

        public boolean onKeyEvent(KeyEvent var1);
    }
}

