/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractAccountAuthenticator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AccountAuthenticator";
    private Context mContext;
    private Transport mTransport;

    private void $$robo$$android_accounts_AbstractAccountAuthenticator$__constructor__(Context context) {
        this.mTransport = new Transport(this);
        this.mContext = context;
    }

    private final void $$robo$$android_accounts_AbstractAccountAuthenticator$handleException(IAccountAuthenticatorResponse response, String method, String data, Exception e) throws RemoteException {
        if (e instanceof NetworkErrorException) {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", method + "(" + data + ")", e);
            }
            response.onError(3, e.getMessage());
        } else if (e instanceof UnsupportedOperationException) {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", method + "(" + data + ")", e);
            }
            response.onError(6, method + " not supported");
        } else if (e instanceof IllegalArgumentException) {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", method + "(" + data + ")", e);
            }
            response.onError(7, method + " not supported");
        } else {
            Log.w("AccountAuthenticator", method + "(" + data + ")", e);
            response.onError(1, method + " failed");
        }
    }

    private final void $$robo$$android_accounts_AbstractAccountAuthenticator$checkBinderPermission() {
        int uid = Binder.getCallingUid();
        String perm = "android.permission.ACCOUNT_MANAGER";
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCOUNT_MANAGER") != 0) {
            throw new SecurityException("caller uid " + uid + " lacks " + "android.permission.ACCOUNT_MANAGER");
        }
    }

    private final IBinder $$robo$$android_accounts_AbstractAccountAuthenticator$getIBinder() {
        return this.mTransport.asBinder();
    }

    public abstract Bundle editProperties(AccountAuthenticatorResponse var1, String var2);

    public abstract Bundle addAccount(AccountAuthenticatorResponse var1, String var2, String var3, String[] var4, Bundle var5) throws NetworkErrorException;

    public abstract Bundle confirmCredentials(AccountAuthenticatorResponse var1, Account var2, Bundle var3) throws NetworkErrorException;

    public abstract Bundle getAuthToken(AccountAuthenticatorResponse var1, Account var2, String var3, Bundle var4) throws NetworkErrorException;

    public abstract String getAuthTokenLabel(String var1);

    public abstract Bundle updateCredentials(AccountAuthenticatorResponse var1, Account var2, String var3, Bundle var4) throws NetworkErrorException;

    public abstract Bundle hasFeatures(AccountAuthenticatorResponse var1, Account var2, String[] var3) throws NetworkErrorException;

    private final Bundle $$robo$$android_accounts_AbstractAccountAuthenticator$getAccountRemovalAllowed(AccountAuthenticatorResponse response, Account account) throws NetworkErrorException {
        Bundle result = new Bundle();
        result.putBoolean("booleanResult", true);
        return result;
    }

    private final Bundle $$robo$$android_accounts_AbstractAccountAuthenticator$getAccountCredentialsForCloning(AccountAuthenticatorResponse response, Account account) throws NetworkErrorException {
        new Thread(new Runnable(this, response){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccountAuthenticatorResponse val$response;
            /* synthetic */ AbstractAccountAuthenticator this$0;

            private void $$robo$$android_accounts_AbstractAccountAuthenticator_1$__constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator, AccountAuthenticatorResponse accountAuthenticatorResponse) {
            }

            private final void $$robo$$android_accounts_AbstractAccountAuthenticator_1$run() {
                Bundle result = new Bundle();
                result.putBoolean("booleanResult", false);
                this.val$response.onResult(result);
            }

            private void __constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator, AccountAuthenticatorResponse accountAuthenticatorResponse) {
                this.$$robo$$android_accounts_AbstractAccountAuthenticator_1$__constructor__(abstractAccountAuthenticator, accountAuthenticatorResponse);
            }
            {
                this.this$0 = abstractAccountAuthenticator;
                this.val$response = accountAuthenticatorResponse;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AbstractAccountAuthenticator_1$__constructor__(android.accounts.AbstractAccountAuthenticator android.accounts.AccountAuthenticatorResponse ), 0, this, abstractAccountAuthenticator, accountAuthenticatorResponse);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AbstractAccountAuthenticator_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }).start();
        return null;
    }

    private final Bundle $$robo$$android_accounts_AbstractAccountAuthenticator$addAccountFromCredentials(AccountAuthenticatorResponse response, Account account, Bundle accountCredentials) throws NetworkErrorException {
        new Thread(new Runnable(this, response){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccountAuthenticatorResponse val$response;
            /* synthetic */ AbstractAccountAuthenticator this$0;

            private void $$robo$$android_accounts_AbstractAccountAuthenticator_2$__constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator, AccountAuthenticatorResponse accountAuthenticatorResponse) {
            }

            private final void $$robo$$android_accounts_AbstractAccountAuthenticator_2$run() {
                Bundle result = new Bundle();
                result.putBoolean("booleanResult", false);
                this.val$response.onResult(result);
            }

            private void __constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator, AccountAuthenticatorResponse accountAuthenticatorResponse) {
                this.$$robo$$android_accounts_AbstractAccountAuthenticator_2$__constructor__(abstractAccountAuthenticator, accountAuthenticatorResponse);
            }
            {
                this.this$0 = abstractAccountAuthenticator;
                this.val$response = accountAuthenticatorResponse;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AbstractAccountAuthenticator_2$__constructor__(android.accounts.AbstractAccountAuthenticator android.accounts.AccountAuthenticatorResponse ), 0, this, abstractAccountAuthenticator, accountAuthenticatorResponse);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AbstractAccountAuthenticator_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }).start();
        return null;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_accounts_AbstractAccountAuthenticator$__constructor__(context);
    }

    public AbstractAccountAuthenticator(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AbstractAccountAuthenticator$__constructor__(android.content.Context ), 0, this, context);
    }

    private void handleException(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2, String string3, Exception exception) throws RemoteException {
        InvokeDynamicSupport.bootstrap("handleException", $$robo$$android_accounts_AbstractAccountAuthenticator$handleException(android.accounts.IAccountAuthenticatorResponse java.lang.String java.lang.String java.lang.Exception ), 0, this, iAccountAuthenticatorResponse, string2, string3, exception);
    }

    private void checkBinderPermission() {
        InvokeDynamicSupport.bootstrap("checkBinderPermission", $$robo$$android_accounts_AbstractAccountAuthenticator$checkBinderPermission(), 0, this);
    }

    public IBinder getIBinder() {
        return InvokeDynamicSupport.bootstrap("getIBinder", $$robo$$android_accounts_AbstractAccountAuthenticator$getIBinder(), 0, this);
    }

    public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        return InvokeDynamicSupport.bootstrap("getAccountRemovalAllowed", $$robo$$android_accounts_AbstractAccountAuthenticator$getAccountRemovalAllowed(android.accounts.AccountAuthenticatorResponse android.accounts.Account ), 0, this, accountAuthenticatorResponse, account);
    }

    public Bundle getAccountCredentialsForCloning(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        return InvokeDynamicSupport.bootstrap("getAccountCredentialsForCloning", $$robo$$android_accounts_AbstractAccountAuthenticator$getAccountCredentialsForCloning(android.accounts.AccountAuthenticatorResponse android.accounts.Account ), 0, this, accountAuthenticatorResponse, account);
    }

    public Bundle addAccountFromCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
        return InvokeDynamicSupport.bootstrap("addAccountFromCredentials", $$robo$$android_accounts_AbstractAccountAuthenticator$addAccountFromCredentials(android.accounts.AccountAuthenticatorResponse android.accounts.Account android.os.Bundle ), 0, this, accountAuthenticatorResponse, account, bundle);
    }

    public /* synthetic */ AbstractAccountAuthenticator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractAccountAuthenticator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Transport
    extends IAccountAuthenticator.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AbstractAccountAuthenticator this$0;

        private void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$__constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator) {
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$addAccount(IAccountAuthenticatorResponse response, String accountType, String authTokenType, String[] features, Bundle options) throws RemoteException {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", "addAccount: accountType " + accountType + ", authTokenType " + authTokenType + ", features " + (features == null ? "[]" : Arrays.toString(features)));
            }
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.addAccount(new AccountAuthenticatorResponse(response), accountType, authTokenType, features, options);
                if (Log.isLoggable("AccountAuthenticator", 2)) {
                    result.keySet();
                    Log.v("AccountAuthenticator", "addAccount: result " + AccountManager.sanitizeResult(result));
                }
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "addAccount", accountType, e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$confirmCredentials(IAccountAuthenticatorResponse response, Account account, Bundle options) throws RemoteException {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", "confirmCredentials: " + account);
            }
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.confirmCredentials(new AccountAuthenticatorResponse(response), account, options);
                if (Log.isLoggable("AccountAuthenticator", 2)) {
                    result.keySet();
                    Log.v("AccountAuthenticator", "confirmCredentials: result " + AccountManager.sanitizeResult(result));
                }
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "confirmCredentials", account.toString(), e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAuthTokenLabel(IAccountAuthenticatorResponse response, String authTokenType) throws RemoteException {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", "getAuthTokenLabel: authTokenType " + authTokenType);
            }
            this.this$0.checkBinderPermission();
            try {
                Bundle result = new Bundle();
                result.putString("authTokenLabelKey", this.this$0.getAuthTokenLabel(authTokenType));
                if (Log.isLoggable("AccountAuthenticator", 2)) {
                    result.keySet();
                    Log.v("AccountAuthenticator", "getAuthTokenLabel: result " + AccountManager.sanitizeResult(result));
                }
                response.onResult(result);
            }
            catch (Exception e) {
                this.this$0.handleException(response, "getAuthTokenLabel", authTokenType, e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAuthToken(IAccountAuthenticatorResponse response, Account account, String authTokenType, Bundle loginOptions) throws RemoteException {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", "getAuthToken: " + account + ", authTokenType " + authTokenType);
            }
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.getAuthToken(new AccountAuthenticatorResponse(response), account, authTokenType, loginOptions);
                if (Log.isLoggable("AccountAuthenticator", 2)) {
                    result.keySet();
                    Log.v("AccountAuthenticator", "getAuthToken: result " + AccountManager.sanitizeResult(result));
                }
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "getAuthToken", account.toString() + "," + authTokenType, e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$updateCredentials(IAccountAuthenticatorResponse response, Account account, String authTokenType, Bundle loginOptions) throws RemoteException {
            if (Log.isLoggable("AccountAuthenticator", 2)) {
                Log.v("AccountAuthenticator", "updateCredentials: " + account + ", authTokenType " + authTokenType);
            }
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.updateCredentials(new AccountAuthenticatorResponse(response), account, authTokenType, loginOptions);
                if (Log.isLoggable("AccountAuthenticator", 2)) {
                    result.keySet();
                    Log.v("AccountAuthenticator", "updateCredentials: result " + AccountManager.sanitizeResult(result));
                }
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "updateCredentials", account.toString() + "," + authTokenType, e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$editProperties(IAccountAuthenticatorResponse response, String accountType) throws RemoteException {
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.editProperties(new AccountAuthenticatorResponse(response), accountType);
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "editProperties", accountType, e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$hasFeatures(IAccountAuthenticatorResponse response, Account account, String[] features) throws RemoteException {
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.hasFeatures(new AccountAuthenticatorResponse(response), account, features);
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "hasFeatures", account.toString(), e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAccountRemovalAllowed(IAccountAuthenticatorResponse response, Account account) throws RemoteException {
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.getAccountRemovalAllowed(new AccountAuthenticatorResponse(response), account);
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "getAccountRemovalAllowed", account.toString(), e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAccountCredentialsForCloning(IAccountAuthenticatorResponse response, Account account) throws RemoteException {
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.getAccountCredentialsForCloning(new AccountAuthenticatorResponse(response), account);
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "getAccountCredentialsForCloning", account.toString(), e);
            }
        }

        private final void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$addAccountFromCredentials(IAccountAuthenticatorResponse response, Account account, Bundle accountCredentials) throws RemoteException {
            this.this$0.checkBinderPermission();
            try {
                Bundle result = this.this$0.addAccountFromCredentials(new AccountAuthenticatorResponse(response), account, accountCredentials);
                if (result != null) {
                    response.onResult(result);
                }
            }
            catch (Exception e) {
                this.this$0.handleException(response, "addAccountFromCredentials", account.toString(), e);
            }
        }

        private /* synthetic */ void $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$__constructor__(AbstractAccountAuthenticator x0, 1 x1) {
        }

        private void __constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator) {
            this.$$robo$$android_accounts_AbstractAccountAuthenticator_Transport$__constructor__(abstractAccountAuthenticator);
        }

        private Transport(AbstractAccountAuthenticator abstractAccountAuthenticator) {
            this.this$0 = abstractAccountAuthenticator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$__constructor__(android.accounts.AbstractAccountAuthenticator ), 0, this, abstractAccountAuthenticator);
        }

        @Override
        public void addAccount(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("addAccount", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$addAccount(android.accounts.IAccountAuthenticatorResponse java.lang.String java.lang.String java.lang.String[] android.os.Bundle ), 0, this, iAccountAuthenticatorResponse, string2, string3, stringArray, bundle);
        }

        @Override
        public void confirmCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("confirmCredentials", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$confirmCredentials(android.accounts.IAccountAuthenticatorResponse android.accounts.Account android.os.Bundle ), 0, this, iAccountAuthenticatorResponse, account, bundle);
        }

        @Override
        public void getAuthTokenLabel(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("getAuthTokenLabel", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAuthTokenLabel(android.accounts.IAccountAuthenticatorResponse java.lang.String ), 0, this, iAccountAuthenticatorResponse, string2);
        }

        @Override
        public void getAuthToken(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("getAuthToken", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAuthToken(android.accounts.IAccountAuthenticatorResponse android.accounts.Account java.lang.String android.os.Bundle ), 0, this, iAccountAuthenticatorResponse, account, string2, bundle);
        }

        @Override
        public void updateCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("updateCredentials", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$updateCredentials(android.accounts.IAccountAuthenticatorResponse android.accounts.Account java.lang.String android.os.Bundle ), 0, this, iAccountAuthenticatorResponse, account, string2, bundle);
        }

        @Override
        public void editProperties(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("editProperties", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$editProperties(android.accounts.IAccountAuthenticatorResponse java.lang.String ), 0, this, iAccountAuthenticatorResponse, string2);
        }

        @Override
        public void hasFeatures(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String[] stringArray) throws RemoteException {
            InvokeDynamicSupport.bootstrap("hasFeatures", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$hasFeatures(android.accounts.IAccountAuthenticatorResponse android.accounts.Account java.lang.String[] ), 0, this, iAccountAuthenticatorResponse, account, stringArray);
        }

        @Override
        public void getAccountRemovalAllowed(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account) throws RemoteException {
            InvokeDynamicSupport.bootstrap("getAccountRemovalAllowed", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAccountRemovalAllowed(android.accounts.IAccountAuthenticatorResponse android.accounts.Account ), 0, this, iAccountAuthenticatorResponse, account);
        }

        @Override
        public void getAccountCredentialsForCloning(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account) throws RemoteException {
            InvokeDynamicSupport.bootstrap("getAccountCredentialsForCloning", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$getAccountCredentialsForCloning(android.accounts.IAccountAuthenticatorResponse android.accounts.Account ), 0, this, iAccountAuthenticatorResponse, account);
        }

        @Override
        public void addAccountFromCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("addAccountFromCredentials", $$robo$$android_accounts_AbstractAccountAuthenticator_Transport$addAccountFromCredentials(android.accounts.IAccountAuthenticatorResponse android.accounts.Account android.os.Bundle ), 0, this, iAccountAuthenticatorResponse, account, bundle);
        }

        private /* synthetic */ void __constructor__(AbstractAccountAuthenticator abstractAccountAuthenticator, 1 var2_2) {
            this.$$robo$$android_accounts_AbstractAccountAuthenticator_Transport$__constructor__(abstractAccountAuthenticator, var2_2);
        }

        public /* synthetic */ Transport() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transport)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

