/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.SQLException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AccountManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AccountManager";
    public static int ERROR_CODE_REMOTE_EXCEPTION = 1;
    public static int ERROR_CODE_NETWORK_ERROR = 3;
    public static int ERROR_CODE_CANCELED = 4;
    public static int ERROR_CODE_INVALID_RESPONSE = 5;
    public static int ERROR_CODE_UNSUPPORTED_OPERATION = 6;
    public static int ERROR_CODE_BAD_ARGUMENTS = 7;
    public static int ERROR_CODE_BAD_REQUEST = 8;
    public static int ERROR_CODE_BAD_AUTHENTICATION = 9;
    public static int ERROR_CODE_USER_RESTRICTED = 100;
    public static int ERROR_CODE_MANAGEMENT_DISABLED_FOR_ACCOUNT_TYPE = 101;
    public static String KEY_ACCOUNT_NAME = "authAccount";
    public static String KEY_ACCOUNT_TYPE = "accountType";
    public static String KEY_AUTHTOKEN = "authtoken";
    public static String KEY_INTENT = "intent";
    public static String KEY_PASSWORD = "password";
    public static String KEY_ACCOUNTS = "accounts";
    public static String KEY_ACCOUNT_AUTHENTICATOR_RESPONSE = "accountAuthenticatorResponse";
    public static String KEY_ACCOUNT_MANAGER_RESPONSE = "accountManagerResponse";
    public static String KEY_AUTHENTICATOR_TYPES = "authenticator_types";
    public static String KEY_AUTH_FAILED_MESSAGE = "authFailedMessage";
    public static String KEY_AUTH_TOKEN_LABEL = "authTokenLabelKey";
    public static String KEY_BOOLEAN_RESULT = "booleanResult";
    public static String KEY_ERROR_CODE = "errorCode";
    public static String KEY_ERROR_MESSAGE = "errorMessage";
    public static String KEY_USERDATA = "userdata";
    public static String KEY_CALLER_UID = "callerUid";
    public static String KEY_CALLER_PID = "callerPid";
    public static String KEY_ANDROID_PACKAGE_NAME = "androidPackageName";
    public static String KEY_NOTIFY_ON_FAILURE = "notifyOnAuthFailure";
    public static String ACTION_AUTHENTICATOR_INTENT = "android.accounts.AccountAuthenticator";
    public static String AUTHENTICATOR_META_DATA_NAME = "android.accounts.AccountAuthenticator";
    public static String AUTHENTICATOR_ATTRIBUTES_NAME = "account-authenticator";
    private Context mContext;
    private IAccountManager mService;
    private Handler mMainHandler;
    public static String LOGIN_ACCOUNTS_CHANGED_ACTION = "android.accounts.LOGIN_ACCOUNTS_CHANGED";
    private HashMap<OnAccountsUpdateListener, Handler> mAccountsUpdatedListeners;
    private BroadcastReceiver mAccountsChangedBroadcastReceiver;

    private void $$robo$$android_accounts_AccountManager$__constructor__(Context context, IAccountManager service) {
        this.mAccountsUpdatedListeners = Maps.newHashMap();
        this.mAccountsChangedBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_16$__constructor__(AccountManager accountManager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_accounts_AccountManager_16$onReceive(Context context, Intent intent) {
                Account[] accounts = this.this$0.getAccounts();
                HashMap hashMap = this.this$0.mAccountsUpdatedListeners;
                synchronized (hashMap) {
                    for (Map.Entry entry : this.this$0.mAccountsUpdatedListeners.entrySet()) {
                        this.this$0.postToHandler((Handler)entry.getValue(), (OnAccountsUpdateListener)entry.getKey(), accounts);
                    }
                }
            }

            private void __constructor__(AccountManager accountManager) {
                this.$$robo$$android_accounts_AccountManager_16$__constructor__(accountManager);
            }
            {
                this.this$0 = accountManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_16$__constructor__(android.accounts.AccountManager ), 0, this, accountManager);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_accounts_AccountManager_16$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mService = service;
        this.mMainHandler = new Handler(this.mContext.getMainLooper());
    }

    private void $$robo$$android_accounts_AccountManager$__constructor__(Context context, IAccountManager service, Handler handler) {
        this.mAccountsUpdatedListeners = Maps.newHashMap();
        this.mAccountsChangedBroadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mService = service;
        this.mMainHandler = handler;
    }

    private static final Bundle $$robo$$android_accounts_AccountManager$sanitizeResult(Bundle result) {
        if (result != null && result.containsKey("authtoken") && !TextUtils.isEmpty(result.getString("authtoken"))) {
            Bundle newResult = new Bundle(result);
            newResult.putString("authtoken", "<omitted for logging purposes>");
            return newResult;
        }
        return result;
    }

    private static final AccountManager $$robo$$android_accounts_AccountManager$get(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        return (AccountManager)context.getSystemService("account");
    }

    private final String $$robo$$android_accounts_AccountManager$getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            return this.mService.getPassword(account);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final String $$robo$$android_accounts_AccountManager$getUserData(Account account, String key) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            return this.mService.getUserData(account, key);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final AuthenticatorDescription[] $$robo$$android_accounts_AccountManager$getAuthenticatorTypes() {
        try {
            return this.mService.getAuthenticatorTypes(UserHandle.getCallingUserId());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final AuthenticatorDescription[] $$robo$$android_accounts_AccountManager$getAuthenticatorTypesAsUser(int userId) {
        try {
            return this.mService.getAuthenticatorTypes(userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getAccounts() {
        try {
            return this.mService.getAccounts(null);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getAccountsAsUser(int userId) {
        try {
            return this.mService.getAccountsAsUser(null, userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getAccountsForPackage(String packageName, int uid) {
        try {
            return this.mService.getAccountsForPackage(packageName, uid);
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getAccountsByTypeForPackage(String type, String packageName) {
        try {
            return this.mService.getAccountsByTypeForPackage(type, packageName);
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getAccountsByType(String type) {
        return this.getAccountsByTypeAsUser(type, Process.myUserHandle());
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getAccountsByTypeAsUser(String type, UserHandle userHandle) {
        try {
            return this.mService.getAccountsAsUser(type, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final void $$robo$$android_accounts_AccountManager$updateAppPermission(Account account, String authTokenType, int uid, boolean value) {
        try {
            this.mService.updateAppPermission(account, authTokenType, uid, value);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final AccountManagerFuture<String> $$robo$$android_accounts_AccountManager$getAuthTokenLabel(String accountType, String authTokenType, AccountManagerCallback<String> callback, Handler handler) {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        return new Future2Task<String>(this, handler, callback, accountType, authTokenType){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$accountType;
            /* synthetic */ String val$authTokenType;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_1$__constructor__(AccountManager accountManager, Handler x0, AccountManagerCallback x1, String string2, String string3) {
            }

            private final void $$robo$$android_accounts_AccountManager_1$doWork() throws RemoteException {
                this.this$0.mService.getAuthTokenLabel(this.mResponse, this.val$accountType, this.val$authTokenType);
            }

            private final String $$robo$$android_accounts_AccountManager_1$bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey("authTokenLabelKey")) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getString("authTokenLabelKey");
            }

            private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback accountManagerCallback, String string2, String string3) {
                this.$$robo$$android_accounts_AccountManager_1$__constructor__(accountManager, handler, accountManagerCallback, string2, string3);
            }
            {
                this.this$0 = accountManager;
                this.val$accountType = string2;
                this.val$authTokenType = string3;
                super(accountManager, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_1$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback java.lang.String java.lang.String ), 0, this, accountManager, handler, accountManagerCallback, string2, string3);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_1$doWork(), 0, this);
            }

            @Override
            public String bundleToResult(Bundle bundle) throws AuthenticatorException {
                return InvokeDynamicSupport.bootstrap("bundleToResult", $$robo$$android_accounts_AccountManager_1$bundleToResult(android.os.Bundle ), 0, this, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Boolean> $$robo$$android_accounts_AccountManager$hasFeatures(Account account, String[] features, AccountManagerCallback<Boolean> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (features == null) {
            throw new IllegalArgumentException("features is null");
        }
        return new Future2Task<Boolean>(this, handler, callback, account, features){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ String[] val$features;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_2$__constructor__(AccountManager accountManager, Handler x0, AccountManagerCallback x1, Account account, String[] stringArray) {
            }

            private final void $$robo$$android_accounts_AccountManager_2$doWork() throws RemoteException {
                this.this$0.mService.hasFeatures(this.mResponse, this.val$account, this.val$features);
            }

            private final Boolean $$robo$$android_accounts_AccountManager_2$bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey("booleanResult")) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean("booleanResult");
            }

            private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback accountManagerCallback, Account account, String[] stringArray) {
                this.$$robo$$android_accounts_AccountManager_2$__constructor__(accountManager, handler, accountManagerCallback, account, stringArray);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$features = stringArray;
                super(accountManager, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_2$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account java.lang.String[] ), 0, this, accountManager, handler, accountManagerCallback, account, stringArray);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_2$doWork(), 0, this);
            }

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                return InvokeDynamicSupport.bootstrap("bundleToResult", $$robo$$android_accounts_AccountManager_2$bundleToResult(android.os.Bundle ), 0, this, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Account[]> $$robo$$android_accounts_AccountManager$getAccountsByTypeAndFeatures(String type, String[] features, AccountManagerCallback<Account[]> callback, Handler handler) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        return new Future2Task<Account[]>(this, handler, callback, type, features){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$type;
            /* synthetic */ String[] val$features;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_3$__constructor__(AccountManager accountManager, Handler x0, AccountManagerCallback x1, String string2, String[] stringArray) {
            }

            private final void $$robo$$android_accounts_AccountManager_3$doWork() throws RemoteException {
                this.this$0.mService.getAccountsByFeatures(this.mResponse, this.val$type, this.val$features);
            }

            private final Account[] $$robo$$android_accounts_AccountManager_3$bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey("accounts")) {
                    throw new AuthenticatorException("no result in response");
                }
                Parcelable[] parcelables = bundle.getParcelableArray("accounts");
                Account[] descs = new Account[parcelables.length];
                for (int i = 0; i < parcelables.length; ++i) {
                    descs[i] = (Account)parcelables[i];
                }
                return descs;
            }

            private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback accountManagerCallback, String string2, String[] stringArray) {
                this.$$robo$$android_accounts_AccountManager_3$__constructor__(accountManager, handler, accountManagerCallback, string2, stringArray);
            }
            {
                this.this$0 = accountManager;
                this.val$type = string2;
                this.val$features = stringArray;
                super(accountManager, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_3$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback java.lang.String java.lang.String[] ), 0, this, accountManager, handler, accountManagerCallback, string2, stringArray);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_3$doWork(), 0, this);
            }

            @Override
            public Account[] bundleToResult(Bundle bundle) throws AuthenticatorException {
                return InvokeDynamicSupport.bootstrap("bundleToResult", $$robo$$android_accounts_AccountManager_3$bundleToResult(android.os.Bundle ), 0, this, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final boolean $$robo$$android_accounts_AccountManager$addAccountExplicitly(Account account, String password, Bundle userdata) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            return this.mService.addAccountExplicitly(account, password, userdata);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final AccountManagerFuture<Account> $$robo$$android_accounts_AccountManager$renameAccount(Account account, String newName, AccountManagerCallback<Account> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null.");
        }
        if (TextUtils.isEmpty(newName)) {
            throw new IllegalArgumentException("newName is empty or null.");
        }
        return new Future2Task<Account>(this, handler, callback, account, newName){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ String val$newName;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_4$__constructor__(AccountManager accountManager, Handler x0, AccountManagerCallback x1, Account account, String string2) {
            }

            private final void $$robo$$android_accounts_AccountManager_4$doWork() throws RemoteException {
                this.this$0.mService.renameAccount(this.mResponse, this.val$account, this.val$newName);
            }

            private final Account $$robo$$android_accounts_AccountManager_4$bundleToResult(Bundle bundle) throws AuthenticatorException {
                String name = bundle.getString("authAccount");
                String type = bundle.getString("accountType");
                return new Account(name, type);
            }

            private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback accountManagerCallback, Account account, String string2) {
                this.$$robo$$android_accounts_AccountManager_4$__constructor__(accountManager, handler, accountManagerCallback, account, string2);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$newName = string2;
                super(accountManager, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_4$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account java.lang.String ), 0, this, accountManager, handler, accountManagerCallback, account, string2);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_4$doWork(), 0, this);
            }

            @Override
            public Account bundleToResult(Bundle bundle) throws AuthenticatorException {
                return InvokeDynamicSupport.bootstrap("bundleToResult", $$robo$$android_accounts_AccountManager_4$bundleToResult(android.os.Bundle ), 0, this, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final String $$robo$$android_accounts_AccountManager$getPreviousName(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            return this.mService.getPreviousName(account);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final AccountManagerFuture<Boolean> $$robo$$android_accounts_AccountManager$removeAccount(Account account, AccountManagerCallback<Boolean> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return new Future2Task<Boolean>(this, handler, callback, account){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_5$__constructor__(AccountManager accountManager, Handler x0, AccountManagerCallback x1, Account account) {
            }

            private final void $$robo$$android_accounts_AccountManager_5$doWork() throws RemoteException {
                this.this$0.mService.removeAccount(this.mResponse, this.val$account);
            }

            private final Boolean $$robo$$android_accounts_AccountManager_5$bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey("booleanResult")) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean("booleanResult");
            }

            private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback accountManagerCallback, Account account) {
                this.$$robo$$android_accounts_AccountManager_5$__constructor__(accountManager, handler, accountManagerCallback, account);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                super(accountManager, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_5$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account ), 0, this, accountManager, handler, accountManagerCallback, account);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_5$doWork(), 0, this);
            }

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                return InvokeDynamicSupport.bootstrap("bundleToResult", $$robo$$android_accounts_AccountManager_5$bundleToResult(android.os.Bundle ), 0, this, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Boolean> $$robo$$android_accounts_AccountManager$removeAccountAsUser(Account account, AccountManagerCallback<Boolean> callback, Handler handler, UserHandle userHandle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (userHandle == null) {
            throw new IllegalArgumentException("userHandle is null");
        }
        return new Future2Task<Boolean>(this, handler, callback, account, userHandle){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ UserHandle val$userHandle;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_6$__constructor__(AccountManager accountManager, Handler x0, AccountManagerCallback x1, Account account, UserHandle userHandle) {
            }

            private final void $$robo$$android_accounts_AccountManager_6$doWork() throws RemoteException {
                this.this$0.mService.removeAccountAsUser(this.mResponse, this.val$account, this.val$userHandle.getIdentifier());
            }

            private final Boolean $$robo$$android_accounts_AccountManager_6$bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey("booleanResult")) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean("booleanResult");
            }

            private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback accountManagerCallback, Account account, UserHandle userHandle) {
                this.$$robo$$android_accounts_AccountManager_6$__constructor__(accountManager, handler, accountManagerCallback, account, userHandle);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$userHandle = userHandle;
                super(accountManager, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_6$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account android.os.UserHandle ), 0, this, accountManager, handler, accountManagerCallback, account, userHandle);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_6$doWork(), 0, this);
            }

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                return InvokeDynamicSupport.bootstrap("bundleToResult", $$robo$$android_accounts_AccountManager_6$bundleToResult(android.os.Bundle ), 0, this, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final void $$robo$$android_accounts_AccountManager$invalidateAuthToken(String accountType, String authToken) {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        try {
            if (authToken != null) {
                this.mService.invalidateAuthToken(accountType, authToken);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final String $$robo$$android_accounts_AccountManager$peekAuthToken(Account account, String authTokenType) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        try {
            return this.mService.peekAuthToken(account, authTokenType);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final void $$robo$$android_accounts_AccountManager$setPassword(Account account, String password) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            this.mService.setPassword(account, password);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final void $$robo$$android_accounts_AccountManager$clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            this.mService.clearPassword(account);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final void $$robo$$android_accounts_AccountManager$setUserData(Account account, String key, String value) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            this.mService.setUserData(account, key, value);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final void $$robo$$android_accounts_AccountManager$setAuthToken(Account account, String authTokenType, String authToken) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        try {
            this.mService.setAuthToken(account, authTokenType, authToken);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final String $$robo$$android_accounts_AccountManager$blockingGetAuthToken(Account account, String authTokenType, boolean notifyAuthFailure) throws OperationCanceledException, IOException, AuthenticatorException {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Bundle bundle = this.getAuthToken(account, authTokenType, notifyAuthFailure, null, null).getResult();
        if (bundle == null) {
            Log.e("AccountManager", "blockingGetAuthToken: null was returned from getResult() for " + account + ", authTokenType " + authTokenType);
            return null;
        }
        return bundle.getString("authtoken");
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$getAuthToken(Account account, String authTokenType, Bundle options, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Bundle optionsIn = new Bundle();
        if (options != null) {
            optionsIn.putAll(options);
        }
        optionsIn.putString("androidPackageName", this.mContext.getPackageName());
        return new ShadowedObject(this, activity, handler, callback, account, authTokenType, optionsIn){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ String val$authTokenType;
            /* synthetic */ Bundle val$optionsIn;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_7$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, Account account, String string2, Bundle bundle) {
            }

            private final void $$robo$$android_accounts_AccountManager_7$doWork() throws RemoteException {
                this.this$0.mService.getAuthToken(this.mResponse, this.val$account, this.val$authTokenType, false, true, this.val$optionsIn);
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, Account account, String string2, Bundle bundle) {
                this.$$robo$$android_accounts_AccountManager_7$__constructor__(accountManager, activity, handler, accountManagerCallback, account, string2, bundle);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$authTokenType = string2;
                this.val$optionsIn = bundle;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_7$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account java.lang.String android.os.Bundle ), 0, this, accountManager, activity, handler, accountManagerCallback, account, string2, bundle);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_7$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    @Deprecated
    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$getAuthToken(Account account, String authTokenType, boolean notifyAuthFailure, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.getAuthToken(account, authTokenType, null, notifyAuthFailure, callback, handler);
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$getAuthToken(Account account, String authTokenType, Bundle options, boolean notifyAuthFailure, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Bundle optionsIn = new Bundle();
        if (options != null) {
            optionsIn.putAll(options);
        }
        optionsIn.putString("androidPackageName", this.mContext.getPackageName());
        return new ShadowedObject(this, null, handler, callback, account, authTokenType, notifyAuthFailure, optionsIn){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ String val$authTokenType;
            /* synthetic */ boolean val$notifyAuthFailure;
            /* synthetic */ Bundle val$optionsIn;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_8$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, Account account, String string2, boolean bl, Bundle bundle) {
            }

            private final void $$robo$$android_accounts_AccountManager_8$doWork() throws RemoteException {
                this.this$0.mService.getAuthToken(this.mResponse, this.val$account, this.val$authTokenType, this.val$notifyAuthFailure, false, this.val$optionsIn);
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, Account account, String string2, boolean bl, Bundle bundle) {
                this.$$robo$$android_accounts_AccountManager_8$__constructor__(accountManager, activity, handler, accountManagerCallback, account, string2, bl, bundle);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$authTokenType = string2;
                this.val$notifyAuthFailure = bl;
                this.val$optionsIn = bundle;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_8$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account java.lang.String boolean android.os.Bundle ), 0, this, accountManager, activity, handler, accountManagerCallback, account, string2, bl, bundle);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_8$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$addAccount(String accountType, String authTokenType, String[] requiredFeatures, Bundle addAccountOptions, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        Bundle optionsIn = new Bundle();
        if (addAccountOptions != null) {
            optionsIn.putAll(addAccountOptions);
        }
        optionsIn.putString("androidPackageName", this.mContext.getPackageName());
        return new ShadowedObject(this, activity, handler, callback, accountType, authTokenType, requiredFeatures, activity, optionsIn){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$accountType;
            /* synthetic */ String val$authTokenType;
            /* synthetic */ String[] val$requiredFeatures;
            /* synthetic */ Activity val$activity;
            /* synthetic */ Bundle val$optionsIn;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_9$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, String string2, String string3, String[] stringArray, Activity activity, Bundle bundle) {
            }

            private final void $$robo$$android_accounts_AccountManager_9$doWork() throws RemoteException {
                this.this$0.mService.addAccount(this.mResponse, this.val$accountType, this.val$authTokenType, this.val$requiredFeatures, this.val$activity != null, this.val$optionsIn);
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, String string2, String string3, String[] stringArray, Activity activity2, Bundle bundle) {
                this.$$robo$$android_accounts_AccountManager_9$__constructor__(accountManager, activity, handler, accountManagerCallback, string2, string3, stringArray, activity2, bundle);
            }
            {
                this.this$0 = accountManager;
                this.val$accountType = string2;
                this.val$authTokenType = string3;
                this.val$requiredFeatures = stringArray;
                this.val$activity = activity2;
                this.val$optionsIn = bundle;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_9$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback java.lang.String java.lang.String java.lang.String[] android.app.Activity android.os.Bundle ), 0, this, accountManager, activity, handler, accountManagerCallback, string2, string3, stringArray, activity2, bundle);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_9$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$addAccountAsUser(String accountType, String authTokenType, String[] requiredFeatures, Bundle addAccountOptions, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler, UserHandle userHandle) {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (userHandle == null) {
            throw new IllegalArgumentException("userHandle is null");
        }
        Bundle optionsIn = new Bundle();
        if (addAccountOptions != null) {
            optionsIn.putAll(addAccountOptions);
        }
        optionsIn.putString("androidPackageName", this.mContext.getPackageName());
        return new ShadowedObject(this, activity, handler, callback, accountType, authTokenType, requiredFeatures, activity, optionsIn, userHandle){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$accountType;
            /* synthetic */ String val$authTokenType;
            /* synthetic */ String[] val$requiredFeatures;
            /* synthetic */ Activity val$activity;
            /* synthetic */ Bundle val$optionsIn;
            /* synthetic */ UserHandle val$userHandle;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_10$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, UserHandle userHandle) {
            }

            private final void $$robo$$android_accounts_AccountManager_10$doWork() throws RemoteException {
                this.this$0.mService.addAccountAsUser(this.mResponse, this.val$accountType, this.val$authTokenType, this.val$requiredFeatures, this.val$activity != null, this.val$optionsIn, this.val$userHandle.getIdentifier());
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, String string2, String string3, String[] stringArray, Activity activity2, Bundle bundle, UserHandle userHandle) {
                this.$$robo$$android_accounts_AccountManager_10$__constructor__(accountManager, activity, handler, accountManagerCallback, string2, string3, stringArray, activity2, bundle, userHandle);
            }
            {
                this.this$0 = accountManager;
                this.val$accountType = string2;
                this.val$authTokenType = string3;
                this.val$requiredFeatures = stringArray;
                this.val$activity = activity2;
                this.val$optionsIn = bundle;
                this.val$userHandle = userHandle;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_10$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback java.lang.String java.lang.String java.lang.String[] android.app.Activity android.os.Bundle android.os.UserHandle ), 0, this, accountManager, activity, handler, accountManagerCallback, string2, string3, stringArray, activity2, bundle, userHandle);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_10$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final boolean $$robo$$android_accounts_AccountManager$addSharedAccount(Account account, UserHandle user) {
        try {
            boolean val = this.mService.addSharedAccountAsUser(account, user.getIdentifier());
            return val;
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    private final boolean $$robo$$android_accounts_AccountManager$removeSharedAccount(Account account, UserHandle user) {
        try {
            boolean val = this.mService.removeSharedAccountAsUser(account, user.getIdentifier());
            return val;
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    private final Account[] $$robo$$android_accounts_AccountManager$getSharedAccounts(UserHandle user) {
        try {
            return this.mService.getSharedAccountsAsUser(user.getIdentifier());
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$confirmCredentials(Account account, Bundle options, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.confirmCredentialsAsUser(account, options, activity, callback, handler, Process.myUserHandle());
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$confirmCredentialsAsUser(Account account, Bundle options, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler, UserHandle userHandle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = userHandle.getIdentifier();
        return new ShadowedObject(this, activity, handler, callback, account, options, activity, userId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ Bundle val$options;
            /* synthetic */ Activity val$activity;
            /* synthetic */ int val$userId;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_11$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, Account account, Bundle bundle, Activity activity, int n) {
            }

            private final void $$robo$$android_accounts_AccountManager_11$doWork() throws RemoteException {
                this.this$0.mService.confirmCredentialsAsUser(this.mResponse, this.val$account, this.val$options, this.val$activity != null, this.val$userId);
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, Account account, Bundle bundle, Activity activity2, int n) {
                this.$$robo$$android_accounts_AccountManager_11$__constructor__(accountManager, activity, handler, accountManagerCallback, account, bundle, activity2, n);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$options = bundle;
                this.val$activity = activity2;
                this.val$userId = n;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_11$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account android.os.Bundle android.app.Activity int ), 0, this, accountManager, activity, handler, accountManagerCallback, account, bundle, activity2, n);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_11$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$updateCredentials(Account account, String authTokenType, Bundle options, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return new ShadowedObject(this, activity, handler, callback, account, authTokenType, activity, options){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Account val$account;
            /* synthetic */ String val$authTokenType;
            /* synthetic */ Activity val$activity;
            /* synthetic */ Bundle val$options;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_12$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, Account account, String string2, Activity activity, Bundle bundle) {
            }

            private final void $$robo$$android_accounts_AccountManager_12$doWork() throws RemoteException {
                this.this$0.mService.updateCredentials(this.mResponse, this.val$account, this.val$authTokenType, this.val$activity != null, this.val$options);
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, Account account, String string2, Activity activity2, Bundle bundle) {
                this.$$robo$$android_accounts_AccountManager_12$__constructor__(accountManager, activity, handler, accountManagerCallback, account, string2, activity2, bundle);
            }
            {
                this.this$0 = accountManager;
                this.val$account = account;
                this.val$authTokenType = string2;
                this.val$activity = activity2;
                this.val$options = bundle;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_12$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback android.accounts.Account java.lang.String android.app.Activity android.os.Bundle ), 0, this, accountManager, activity, handler, accountManagerCallback, account, string2, activity2, bundle);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_12$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$editProperties(String accountType, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        return new ShadowedObject(this, activity, handler, callback, accountType, activity){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$accountType;
            /* synthetic */ Activity val$activity;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_13$__constructor__(AccountManager accountManager, Activity x0, Handler x1, AccountManagerCallback x2, String string2, Activity activity) {
            }

            private final void $$robo$$android_accounts_AccountManager_13$doWork() throws RemoteException {
                this.this$0.mService.editProperties(this.mResponse, this.val$accountType, this.val$activity != null);
            }

            private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback accountManagerCallback, String string2, Activity activity2) {
                this.$$robo$$android_accounts_AccountManager_13$__constructor__(accountManager, activity, handler, accountManagerCallback, string2, activity2);
            }
            {
                this.this$0 = accountManager;
                this.val$accountType = string2;
                this.val$activity = activity2;
                super(accountManager, activity, handler, accountManagerCallback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_13$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback java.lang.String android.app.Activity ), 0, this, accountManager, activity, handler, accountManagerCallback, string2, activity2);
            }

            @Override
            public void doWork() throws RemoteException {
                InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_13$doWork(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final void $$robo$$android_accounts_AccountManager$ensureNotOnMainThread() {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == this.mContext.getMainLooper()) {
            IllegalStateException exception = new IllegalStateException("calling this from your main thread can lead to deadlock");
            Log.e("AccountManager", "calling this from your main thread can lead to deadlock and/or ANRs", exception);
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 8) {
                throw exception;
            }
        }
    }

    private final void $$robo$$android_accounts_AccountManager$postToHandler(Handler handler, AccountManagerCallback<Bundle> callback, AccountManagerFuture<Bundle> future) {
        handler = handler == null ? this.mMainHandler : handler;
        handler.post(new Runnable(this, callback, future){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccountManagerCallback val$callback;
            /* synthetic */ AccountManagerFuture val$future;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_14$__constructor__(AccountManager accountManager, AccountManagerCallback accountManagerCallback, AccountManagerFuture accountManagerFuture) {
            }

            private final void $$robo$$android_accounts_AccountManager_14$run() {
                this.val$callback.run(this.val$future);
            }

            private void __constructor__(AccountManager accountManager, AccountManagerCallback accountManagerCallback, AccountManagerFuture accountManagerFuture) {
                this.$$robo$$android_accounts_AccountManager_14$__constructor__(accountManager, accountManagerCallback, accountManagerFuture);
            }
            {
                this.this$0 = accountManager;
                this.val$callback = accountManagerCallback;
                this.val$future = accountManagerFuture;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_14$__constructor__(android.accounts.AccountManager android.accounts.AccountManagerCallback android.accounts.AccountManagerFuture ), 0, this, accountManager, accountManagerCallback, accountManagerFuture);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AccountManager_14$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_accounts_AccountManager$postToHandler(Handler handler, OnAccountsUpdateListener listener, Account[] accounts) {
        Account[] accountsCopy = new Account[accounts.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)accounts, (int)0, (Object)accountsCopy, (int)0, (int)accountsCopy.length);
        handler = handler == null ? this.mMainHandler : handler;
        handler.post(new Runnable(this, listener, accountsCopy){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ OnAccountsUpdateListener val$listener;
            /* synthetic */ Account[] val$accountsCopy;
            /* synthetic */ AccountManager this$0;

            private void $$robo$$android_accounts_AccountManager_15$__constructor__(AccountManager accountManager, OnAccountsUpdateListener onAccountsUpdateListener, Account[] accountArray) {
            }

            private final void $$robo$$android_accounts_AccountManager_15$run() {
                try {
                    this.val$listener.onAccountsUpdated(this.val$accountsCopy);
                }
                catch (SQLException e) {
                    Log.e("AccountManager", "Can't update accounts", e);
                }
            }

            private void __constructor__(AccountManager accountManager, OnAccountsUpdateListener onAccountsUpdateListener, Account[] accountArray) {
                this.$$robo$$android_accounts_AccountManager_15$__constructor__(accountManager, onAccountsUpdateListener, accountArray);
            }
            {
                this.this$0 = accountManager;
                this.val$listener = onAccountsUpdateListener;
                this.val$accountsCopy = accountArray;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_15$__constructor__(android.accounts.AccountManager android.accounts.OnAccountsUpdateListener android.accounts.Account[] ), 0, this, accountManager, onAccountsUpdateListener, accountArray);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AccountManager_15$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final Exception $$robo$$android_accounts_AccountManager$convertErrorToException(int code, String message) {
        if (code == 3) {
            return new IOException(message);
        }
        if (code == 6) {
            return new UnsupportedOperationException(message);
        }
        if (code == 5) {
            return new AuthenticatorException(message);
        }
        if (code == 7) {
            return new IllegalArgumentException(message);
        }
        return new AuthenticatorException(message);
    }

    private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager$getAuthTokenByFeatures(String accountType, String authTokenType, String[] features, Activity activity, Bundle addAccountOptions, Bundle getAuthTokenOptions, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (accountType == null) {
            throw new IllegalArgumentException("account type is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        GetAuthTokenByTypeAndFeaturesTask task = new GetAuthTokenByTypeAndFeaturesTask(this, accountType, authTokenType, features, activity, addAccountOptions, getAuthTokenOptions, callback, handler);
        task.start();
        return task;
    }

    private static final Intent $$robo$$android_accounts_AccountManager$newChooseAccountIntent(Account selectedAccount, ArrayList<Account> allowableAccounts, String[] allowableAccountTypes, boolean alwaysPromptForAccount, String descriptionOverrideText, String addAccountAuthTokenType, String[] addAccountRequiredFeatures, Bundle addAccountOptions) {
        Intent intent = new Intent();
        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039423));
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        intent.putExtra("allowableAccounts", allowableAccounts);
        intent.putExtra("allowableAccountTypes", allowableAccountTypes);
        intent.putExtra("addAccountOptions", addAccountOptions);
        intent.putExtra("selectedAccount", selectedAccount);
        intent.putExtra("alwaysPromptForAccount", alwaysPromptForAccount);
        intent.putExtra("descriptionTextOverride", descriptionOverrideText);
        intent.putExtra("authTokenType", addAccountAuthTokenType);
        intent.putExtra("addAccountRequiredFeatures", addAccountRequiredFeatures);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accounts_AccountManager$addOnAccountsUpdatedListener(OnAccountsUpdateListener listener, Handler handler, boolean updateImmediately) {
        if (listener == null) {
            throw new IllegalArgumentException("the listener is null");
        }
        HashMap<OnAccountsUpdateListener, Handler> hashMap = this.mAccountsUpdatedListeners;
        synchronized (hashMap) {
            if (this.mAccountsUpdatedListeners.containsKey(listener)) {
                throw new IllegalStateException("this listener is already added");
            }
            boolean wasEmpty = this.mAccountsUpdatedListeners.isEmpty();
            this.mAccountsUpdatedListeners.put(listener, handler);
            if (wasEmpty) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.accounts.LOGIN_ACCOUNTS_CHANGED");
                intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
                this.mContext.registerReceiver(this.mAccountsChangedBroadcastReceiver, intentFilter);
            }
        }
        if (updateImmediately) {
            this.postToHandler(handler, listener, this.getAccounts());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accounts_AccountManager$removeOnAccountsUpdatedListener(OnAccountsUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        HashMap<OnAccountsUpdateListener, Handler> hashMap = this.mAccountsUpdatedListeners;
        synchronized (hashMap) {
            if (!this.mAccountsUpdatedListeners.containsKey(listener)) {
                Log.e("AccountManager", "Listener was not previously added");
                return;
            }
            this.mAccountsUpdatedListeners.remove(listener);
            if (this.mAccountsUpdatedListeners.isEmpty()) {
                this.mContext.unregisterReceiver(this.mAccountsChangedBroadcastReceiver);
            }
        }
    }

    private void __constructor__(Context context, IAccountManager iAccountManager) {
        this.$$robo$$android_accounts_AccountManager$__constructor__(context, iAccountManager);
    }

    public AccountManager(Context context, IAccountManager iAccountManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager$__constructor__(android.content.Context android.accounts.IAccountManager ), 0, this, context, iAccountManager);
    }

    private void __constructor__(Context context, IAccountManager iAccountManager, Handler handler) {
        this.$$robo$$android_accounts_AccountManager$__constructor__(context, iAccountManager, handler);
    }

    public AccountManager(Context context, IAccountManager iAccountManager, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager$__constructor__(android.content.Context android.accounts.IAccountManager android.os.Handler ), 0, this, context, iAccountManager, handler);
    }

    public static Bundle sanitizeResult(Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("sanitizeResult", $$robo$$android_accounts_AccountManager$sanitizeResult(android.os.Bundle ), 0, (Bundle)bundle);
    }

    public static AccountManager get(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_accounts_AccountManager$get(android.content.Context ), 0, (Context)context);
    }

    public String getPassword(Account account) {
        return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_accounts_AccountManager$getPassword(android.accounts.Account ), 0, this, account);
    }

    public String getUserData(Account account, String string2) {
        return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$android_accounts_AccountManager$getUserData(android.accounts.Account java.lang.String ), 0, this, account, string2);
    }

    public AuthenticatorDescription[] getAuthenticatorTypes() {
        return InvokeDynamicSupport.bootstrap("getAuthenticatorTypes", $$robo$$android_accounts_AccountManager$getAuthenticatorTypes(), 0, this);
    }

    public AuthenticatorDescription[] getAuthenticatorTypesAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getAuthenticatorTypesAsUser", $$robo$$android_accounts_AccountManager$getAuthenticatorTypesAsUser(int ), 0, this, n);
    }

    public Account[] getAccounts() {
        return InvokeDynamicSupport.bootstrap("getAccounts", $$robo$$android_accounts_AccountManager$getAccounts(), 0, this);
    }

    public Account[] getAccountsAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getAccountsAsUser", $$robo$$android_accounts_AccountManager$getAccountsAsUser(int ), 0, this, n);
    }

    public Account[] getAccountsForPackage(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getAccountsForPackage", $$robo$$android_accounts_AccountManager$getAccountsForPackage(java.lang.String int ), 0, this, string2, n);
    }

    public Account[] getAccountsByTypeForPackage(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getAccountsByTypeForPackage", $$robo$$android_accounts_AccountManager$getAccountsByTypeForPackage(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public Account[] getAccountsByType(String string2) {
        return InvokeDynamicSupport.bootstrap("getAccountsByType", $$robo$$android_accounts_AccountManager$getAccountsByType(java.lang.String ), 0, this, string2);
    }

    public Account[] getAccountsByTypeAsUser(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getAccountsByTypeAsUser", $$robo$$android_accounts_AccountManager$getAccountsByTypeAsUser(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public void updateAppPermission(Account account, String string2, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateAppPermission", $$robo$$android_accounts_AccountManager$updateAppPermission(android.accounts.Account java.lang.String int boolean ), 0, this, account, string2, n, bl);
    }

    public AccountManagerFuture<String> getAuthTokenLabel(String string2, String string3, AccountManagerCallback<String> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("getAuthTokenLabel", $$robo$$android_accounts_AccountManager$getAuthTokenLabel(java.lang.String java.lang.String android.accounts.AccountManagerCallback<java.lang.String> android.os.Handler ), 0, this, string2, string3, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Boolean> hasFeatures(Account account, String[] stringArray, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("hasFeatures", $$robo$$android_accounts_AccountManager$hasFeatures(android.accounts.Account java.lang.String[] android.accounts.AccountManagerCallback<java.lang.Boolean> android.os.Handler ), 0, this, account, stringArray, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(String string2, String[] stringArray, AccountManagerCallback<Account[]> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("getAccountsByTypeAndFeatures", $$robo$$android_accounts_AccountManager$getAccountsByTypeAndFeatures(java.lang.String java.lang.String[] android.accounts.AccountManagerCallback<android.accounts.Account[]> android.os.Handler ), 0, this, string2, stringArray, accountManagerCallback, handler);
    }

    public boolean addAccountExplicitly(Account account, String string2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAccountExplicitly", $$robo$$android_accounts_AccountManager$addAccountExplicitly(android.accounts.Account java.lang.String android.os.Bundle ), 0, this, account, string2, bundle);
    }

    public AccountManagerFuture<Account> renameAccount(Account account, String string2, AccountManagerCallback<Account> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("renameAccount", $$robo$$android_accounts_AccountManager$renameAccount(android.accounts.Account java.lang.String android.accounts.AccountManagerCallback<android.accounts.Account> android.os.Handler ), 0, this, account, string2, accountManagerCallback, handler);
    }

    public String getPreviousName(Account account) {
        return InvokeDynamicSupport.bootstrap("getPreviousName", $$robo$$android_accounts_AccountManager$getPreviousName(android.accounts.Account ), 0, this, account);
    }

    public AccountManagerFuture<Boolean> removeAccount(Account account, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("removeAccount", $$robo$$android_accounts_AccountManager$removeAccount(android.accounts.Account android.accounts.AccountManagerCallback<java.lang.Boolean> android.os.Handler ), 0, this, account, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Boolean> removeAccountAsUser(Account account, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("removeAccountAsUser", $$robo$$android_accounts_AccountManager$removeAccountAsUser(android.accounts.Account android.accounts.AccountManagerCallback<java.lang.Boolean> android.os.Handler android.os.UserHandle ), 0, this, account, accountManagerCallback, handler, userHandle);
    }

    public void invalidateAuthToken(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("invalidateAuthToken", $$robo$$android_accounts_AccountManager$invalidateAuthToken(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String peekAuthToken(Account account, String string2) {
        return InvokeDynamicSupport.bootstrap("peekAuthToken", $$robo$$android_accounts_AccountManager$peekAuthToken(android.accounts.Account java.lang.String ), 0, this, account, string2);
    }

    public void setPassword(Account account, String string2) {
        InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_accounts_AccountManager$setPassword(android.accounts.Account java.lang.String ), 0, this, account, string2);
    }

    public void clearPassword(Account account) {
        InvokeDynamicSupport.bootstrap("clearPassword", $$robo$$android_accounts_AccountManager$clearPassword(android.accounts.Account ), 0, this, account);
    }

    public void setUserData(Account account, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setUserData", $$robo$$android_accounts_AccountManager$setUserData(android.accounts.Account java.lang.String java.lang.String ), 0, this, account, string2, string3);
    }

    public void setAuthToken(Account account, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setAuthToken", $$robo$$android_accounts_AccountManager$setAuthToken(android.accounts.Account java.lang.String java.lang.String ), 0, this, account, string2, string3);
    }

    public String blockingGetAuthToken(Account account, String string2, boolean bl) throws OperationCanceledException, IOException, AuthenticatorException {
        return InvokeDynamicSupport.bootstrap("blockingGetAuthToken", $$robo$$android_accounts_AccountManager$blockingGetAuthToken(android.accounts.Account java.lang.String boolean ), 0, this, account, string2, bl);
    }

    public AccountManagerFuture<Bundle> getAuthToken(Account account, String string2, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("getAuthToken", $$robo$$android_accounts_AccountManager$getAuthToken(android.accounts.Account java.lang.String android.os.Bundle android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, account, string2, bundle, activity, accountManagerCallback, handler);
    }

    @Deprecated
    public AccountManagerFuture<Bundle> getAuthToken(Account account, String string2, boolean bl, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("getAuthToken", $$robo$$android_accounts_AccountManager$getAuthToken(android.accounts.Account java.lang.String boolean android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, account, string2, bl, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Bundle> getAuthToken(Account account, String string2, Bundle bundle, boolean bl, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("getAuthToken", $$robo$$android_accounts_AccountManager$getAuthToken(android.accounts.Account java.lang.String android.os.Bundle boolean android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, account, string2, bundle, bl, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Bundle> addAccount(String string2, String string3, String[] stringArray, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("addAccount", $$robo$$android_accounts_AccountManager$addAccount(java.lang.String java.lang.String java.lang.String[] android.os.Bundle android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, string2, string3, stringArray, bundle, activity, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Bundle> addAccountAsUser(String string2, String string3, String[] stringArray, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("addAccountAsUser", $$robo$$android_accounts_AccountManager$addAccountAsUser(java.lang.String java.lang.String java.lang.String[] android.os.Bundle android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler android.os.UserHandle ), 0, this, string2, string3, stringArray, bundle, activity, accountManagerCallback, handler, userHandle);
    }

    public boolean addSharedAccount(Account account, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("addSharedAccount", $$robo$$android_accounts_AccountManager$addSharedAccount(android.accounts.Account android.os.UserHandle ), 0, this, account, userHandle);
    }

    public boolean removeSharedAccount(Account account, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeSharedAccount", $$robo$$android_accounts_AccountManager$removeSharedAccount(android.accounts.Account android.os.UserHandle ), 0, this, account, userHandle);
    }

    public Account[] getSharedAccounts(UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getSharedAccounts", $$robo$$android_accounts_AccountManager$getSharedAccounts(android.os.UserHandle ), 0, this, userHandle);
    }

    public AccountManagerFuture<Bundle> confirmCredentials(Account account, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("confirmCredentials", $$robo$$android_accounts_AccountManager$confirmCredentials(android.accounts.Account android.os.Bundle android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, account, bundle, activity, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Bundle> confirmCredentialsAsUser(Account account, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("confirmCredentialsAsUser", $$robo$$android_accounts_AccountManager$confirmCredentialsAsUser(android.accounts.Account android.os.Bundle android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler android.os.UserHandle ), 0, this, account, bundle, activity, accountManagerCallback, handler, userHandle);
    }

    public AccountManagerFuture<Bundle> updateCredentials(Account account, String string2, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("updateCredentials", $$robo$$android_accounts_AccountManager$updateCredentials(android.accounts.Account java.lang.String android.os.Bundle android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, account, string2, bundle, activity, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Bundle> editProperties(String string2, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("editProperties", $$robo$$android_accounts_AccountManager$editProperties(java.lang.String android.app.Activity android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, string2, activity, accountManagerCallback, handler);
    }

    private void ensureNotOnMainThread() {
        InvokeDynamicSupport.bootstrap("ensureNotOnMainThread", $$robo$$android_accounts_AccountManager$ensureNotOnMainThread(), 0, this);
    }

    private void postToHandler(Handler handler, AccountManagerCallback<Bundle> accountManagerCallback, AccountManagerFuture<Bundle> accountManagerFuture) {
        InvokeDynamicSupport.bootstrap("postToHandler", $$robo$$android_accounts_AccountManager$postToHandler(android.os.Handler android.accounts.AccountManagerCallback<android.os.Bundle> android.accounts.AccountManagerFuture<android.os.Bundle> ), 0, this, handler, accountManagerCallback, accountManagerFuture);
    }

    private void postToHandler(Handler handler, OnAccountsUpdateListener onAccountsUpdateListener, Account[] accountArray) {
        InvokeDynamicSupport.bootstrap("postToHandler", $$robo$$android_accounts_AccountManager$postToHandler(android.os.Handler android.accounts.OnAccountsUpdateListener android.accounts.Account[] ), 0, this, handler, onAccountsUpdateListener, accountArray);
    }

    private Exception convertErrorToException(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("convertErrorToException", $$robo$$android_accounts_AccountManager$convertErrorToException(int java.lang.String ), 0, this, n, string2);
    }

    public AccountManagerFuture<Bundle> getAuthTokenByFeatures(String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("getAuthTokenByFeatures", $$robo$$android_accounts_AccountManager$getAuthTokenByFeatures(java.lang.String java.lang.String java.lang.String[] android.app.Activity android.os.Bundle android.os.Bundle android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, string2, string3, stringArray, activity, bundle, bundle2, accountManagerCallback, handler);
    }

    public static Intent newChooseAccountIntent(Account account, ArrayList<Account> arrayList, String[] stringArray, boolean bl, String string2, String string3, String[] stringArray2, Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("newChooseAccountIntent", $$robo$$android_accounts_AccountManager$newChooseAccountIntent(android.accounts.Account java.util.ArrayList<android.accounts.Account> java.lang.String[] boolean java.lang.String java.lang.String java.lang.String[] android.os.Bundle ), 0, (Account)account, arrayList, (String[])stringArray, (boolean)bl, (String)string2, (String)string3, (String[])stringArray2, (Bundle)bundle);
    }

    public void addOnAccountsUpdatedListener(OnAccountsUpdateListener onAccountsUpdateListener, Handler handler, boolean bl) {
        InvokeDynamicSupport.bootstrap("addOnAccountsUpdatedListener", $$robo$$android_accounts_AccountManager$addOnAccountsUpdatedListener(android.accounts.OnAccountsUpdateListener android.os.Handler boolean ), 0, this, onAccountsUpdateListener, handler, bl);
    }

    public void removeOnAccountsUpdatedListener(OnAccountsUpdateListener onAccountsUpdateListener) {
        InvokeDynamicSupport.bootstrap("removeOnAccountsUpdatedListener", $$robo$$android_accounts_AccountManager$removeOnAccountsUpdatedListener(android.accounts.OnAccountsUpdateListener ), 0, this, onAccountsUpdateListener);
    }

    public /* synthetic */ AccountManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccountManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class GetAuthTokenByTypeAndFeaturesTask
    extends AmsTask
    implements AccountManagerCallback<Bundle> {
        public transient /* synthetic */ Object __robo_data__;
        volatile AccountManagerFuture<Bundle> mFuture;
        String mAccountType;
        String mAuthTokenType;
        String[] mFeatures;
        Bundle mAddAccountOptions;
        Bundle mLoginOptions;
        AccountManagerCallback<Bundle> mMyCallback;
        private volatile int mNumAccounts;
        /* synthetic */ AccountManager this$0;

        private void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$__constructor__(AccountManager accountManager, String accountType, String authTokenType, String[] features, Activity activityForPrompting, Bundle addAccountOptions, Bundle loginOptions, AccountManagerCallback<Bundle> callback, Handler handler) {
            this.mFuture = null;
            this.mNumAccounts = 0;
            if (accountType == null) {
                throw new IllegalArgumentException("account type is null");
            }
            this.mAccountType = accountType;
            this.mAuthTokenType = authTokenType;
            this.mFeatures = features;
            this.mAddAccountOptions = addAccountOptions;
            this.mLoginOptions = loginOptions;
            this.mMyCallback = this;
        }

        private final void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$doWork() throws RemoteException {
            this.this$0.getAccountsByTypeAndFeatures(this.mAccountType, this.mFeatures, new AccountManagerCallback<Account[]>(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ GetAuthTokenByTypeAndFeaturesTask this$1;

                private void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1$__constructor__(GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask) {
                }

                private final void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1$run(AccountManagerFuture<Account[]> future) {
                    Parcelable[] accounts;
                    try {
                        accounts = future.getResult();
                    }
                    catch (OperationCanceledException e) {
                        this.this$1.setException(e);
                        return;
                    }
                    catch (IOException e) {
                        this.this$1.setException(e);
                        return;
                    }
                    catch (AuthenticatorException e) {
                        this.this$1.setException(e);
                        return;
                    }
                    this.this$1.mNumAccounts = accounts.length;
                    if (accounts.length == 0) {
                        if (this.this$1.mActivity != null) {
                            this.this$1.mFuture = this.this$1.this$0.addAccount(this.this$1.mAccountType, this.this$1.mAuthTokenType, this.this$1.mFeatures, this.this$1.mAddAccountOptions, this.this$1.mActivity, this.this$1.mMyCallback, this.this$1.mHandler);
                        } else {
                            Bundle result = new Bundle();
                            result.putString("authAccount", null);
                            result.putString("accountType", null);
                            result.putString("authtoken", null);
                            try {
                                this.this$1.mResponse.onResult(result);
                            }
                            catch (RemoteException remoteException) {}
                        }
                    } else if (accounts.length == 1) {
                        this.this$1.mFuture = this.this$1.mActivity == null ? this.this$1.this$0.getAuthToken(accounts[0], this.this$1.mAuthTokenType, false, this.this$1.mMyCallback, this.this$1.mHandler) : this.this$1.this$0.getAuthToken(accounts[0], this.this$1.mAuthTokenType, this.this$1.mLoginOptions, this.this$1.mActivity, this.this$1.mMyCallback, this.this$1.mHandler);
                    } else if (this.this$1.mActivity != null) {
                        ShadowedObject chooseResponse = new ShadowedObject(this){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ 1 this$2;

                            private void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$__constructor__(1 var1_1) {
                            }

                            private final void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$onResult(Bundle value) throws RemoteException {
                                Account account = new Account(value.getString("authAccount"), value.getString("accountType"));
                                this.this$2.this$1.mFuture = this.this$2.this$1.this$0.getAuthToken(account, this.this$2.this$1.mAuthTokenType, this.this$2.this$1.mLoginOptions, this.this$2.this$1.mActivity, this.this$2.this$1.mMyCallback, this.this$2.this$1.mHandler);
                            }

                            private final void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$onError(int errorCode, String errorMessage) throws RemoteException {
                                this.this$2.this$1.mResponse.onError(errorCode, errorMessage);
                            }

                            private void __constructor__(1 var1_1) {
                                this.$$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$__constructor__(var1_1);
                            }
                            {
                                this.this$2 = var1_1;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$__constructor__(android.accounts.AccountManager$GetAuthTokenByTypeAndFeaturesTask$1 ), 0, this, var1_1);
                            }

                            @Override
                            public void onResult(Bundle bundle) throws RemoteException {
                                InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$onResult(android.os.Bundle ), 0, this, bundle);
                            }

                            @Override
                            public void onError(int n, String string2) throws RemoteException {
                                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1_1$onError(int java.lang.String ), 0, this, n, string2);
                            }
                            {
                                this.$$robo$init();
                            }

                            @Override
                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            @Override
                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        };
                        Intent intent = new Intent();
                        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039422));
                        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
                        intent.putExtra("accounts", accounts);
                        intent.putExtra("accountManagerResponse", new AccountManagerResponse((IAccountManagerResponse)chooseResponse));
                        this.this$1.mActivity.startActivity(intent);
                    } else {
                        Bundle result = new Bundle();
                        result.putString("accounts", null);
                        try {
                            this.this$1.mResponse.onResult(result);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                private void __constructor__(GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask) {
                    this.$$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1$__constructor__(getAuthTokenByTypeAndFeaturesTask);
                }
                {
                    this.this$1 = getAuthTokenByTypeAndFeaturesTask;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1$__constructor__(android.accounts.AccountManager$GetAuthTokenByTypeAndFeaturesTask ), 0, this, getAuthTokenByTypeAndFeaturesTask);
                }

                @Override
                public void run(AccountManagerFuture<Account[]> accountManagerFuture) {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask_1$run(android.accounts.AccountManagerFuture<android.accounts.Account[]> ), 0, this, accountManagerFuture);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }, this.mHandler);
        }

        private final void $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$run(AccountManagerFuture<Bundle> future) {
            try {
                Bundle result = future.getResult();
                if (this.mNumAccounts == 0) {
                    String accountName = result.getString("authAccount");
                    String accountType = result.getString("accountType");
                    if (TextUtils.isEmpty(accountName) || TextUtils.isEmpty(accountType)) {
                        this.setException(new AuthenticatorException("account not in result"));
                        return;
                    }
                    Account account = new Account(accountName, accountType);
                    this.mNumAccounts = 1;
                    this.this$0.getAuthToken(account, this.mAuthTokenType, null, this.mActivity, this.mMyCallback, this.mHandler);
                    return;
                }
                this.set(result);
            }
            catch (OperationCanceledException e) {
                this.cancel(true);
            }
            catch (IOException e) {
                this.setException(e);
            }
            catch (AuthenticatorException e) {
                this.setException(e);
            }
        }

        private void __constructor__(AccountManager accountManager, String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
            this.$$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$__constructor__(accountManager, string2, string3, stringArray, activity, bundle, bundle2, accountManagerCallback, handler);
        }

        GetAuthTokenByTypeAndFeaturesTask(AccountManager accountManager, String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
            this.this$0 = accountManager;
            super(accountManager, activity, handler, accountManagerCallback);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$__constructor__(android.accounts.AccountManager java.lang.String java.lang.String java.lang.String[] android.app.Activity android.os.Bundle android.os.Bundle android.accounts.AccountManagerCallback<android.os.Bundle> android.os.Handler ), 0, this, accountManager, string2, string3, stringArray, activity, bundle, bundle2, accountManagerCallback, handler);
        }

        @Override
        public void doWork() throws RemoteException {
            InvokeDynamicSupport.bootstrap("doWork", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$doWork(), 0, this);
        }

        @Override
        public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AccountManager_GetAuthTokenByTypeAndFeaturesTask$run(android.accounts.AccountManagerFuture<android.os.Bundle> ), 0, this, accountManagerFuture);
        }

        public /* synthetic */ GetAuthTokenByTypeAndFeaturesTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetAuthTokenByTypeAndFeaturesTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class Future2Task<T>
    extends BaseFutureTask<T>
    implements AccountManagerFuture<T> {
        public transient /* synthetic */ Object __robo_data__;
        AccountManagerCallback<T> mCallback;
        /* synthetic */ AccountManager this$0;

        private void $$robo$$android_accounts_AccountManager_Future2Task$__constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback<T> callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_accounts_AccountManager_Future2Task$done() {
            if (this.mCallback != null) {
                this.postRunnableToHandler(new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Future2Task this$1;

                    private void $$robo$$android_accounts_AccountManager_Future2Task_1$__constructor__(Future2Task future2Task) {
                    }

                    private final void $$robo$$android_accounts_AccountManager_Future2Task_1$run() {
                        this.this$1.mCallback.run(this.this$1);
                    }

                    private void __constructor__(Future2Task future2Task) {
                        this.$$robo$$android_accounts_AccountManager_Future2Task_1$__constructor__(future2Task);
                    }
                    {
                        this.this$1 = future2Task;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_Future2Task_1$__constructor__(android.accounts.AccountManager$Future2Task ), 0, this, future2Task);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_AccountManager_Future2Task_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private final Future2Task<T> $$robo$$android_accounts_AccountManager_Future2Task$start() {
            this.startTask();
            return this;
        }

        private final T $$robo$$android_accounts_AccountManager_Future2Task$internalGetResult(Long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            if (!this.isDone()) {
                this.this$0.ensureNotOnMainThread();
            }
            try {
                if (timeout == null) {
                    Object v = this.get();
                    return (T)v;
                }
                Object v = this.get(timeout, unit);
                return (T)v;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw new AuthenticatorException(cause);
                }
                if (cause instanceof AuthenticatorException) {
                    throw (AuthenticatorException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IllegalStateException(cause);
            }
            finally {
                this.cancel(true);
            }
            throw new OperationCanceledException();
        }

        private final T $$robo$$android_accounts_AccountManager_Future2Task$getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        private final T $$robo$$android_accounts_AccountManager_Future2Task$getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(timeout, unit);
        }

        private void __constructor__(AccountManager accountManager, Handler handler, AccountManagerCallback<T> accountManagerCallback) {
            this.$$robo$$android_accounts_AccountManager_Future2Task$__constructor__(accountManager, handler, accountManagerCallback);
        }

        public Future2Task(AccountManager accountManager, Handler handler, AccountManagerCallback<T> accountManagerCallback) {
            this.this$0 = accountManager;
            super(accountManager, handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_Future2Task$__constructor__(android.accounts.AccountManager android.os.Handler android.accounts.AccountManagerCallback<T> ), 0, this, accountManager, handler, accountManagerCallback);
        }

        @Override
        protected void done() {
            InvokeDynamicSupport.bootstrap("done", $$robo$$android_accounts_AccountManager_Future2Task$done(), 0, this);
        }

        public Future2Task<T> start() {
            return InvokeDynamicSupport.bootstrap("start", $$robo$$android_accounts_AccountManager_Future2Task$start(), 0, this);
        }

        private T internalGetResult(Long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            return (T)InvokeDynamicSupport.bootstrap("internalGetResult", $$robo$$android_accounts_AccountManager_Future2Task$internalGetResult(java.lang.Long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
        }

        @Override
        public T getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return (T)InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_accounts_AccountManager_Future2Task$getResult(), 0, this);
        }

        @Override
        public T getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            return (T)InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_accounts_AccountManager_Future2Task$getResult(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
        }

        public /* synthetic */ Future2Task() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Future2Task)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class BaseFutureTask<T>
    extends FutureTask<T> {
        public transient /* synthetic */ Object __robo_data__;
        public IAccountManagerResponse mResponse;
        Handler mHandler;
        /* synthetic */ AccountManager this$0;

        private void $$robo$$android_accounts_AccountManager_BaseFutureTask$__constructor__(AccountManager accountManager, Handler handler) {
            this.mHandler = handler;
            this.mResponse = new Response(this);
        }

        public abstract void doWork() throws RemoteException;

        public abstract T bundleToResult(Bundle var1) throws AuthenticatorException;

        private final void $$robo$$android_accounts_AccountManager_BaseFutureTask$postRunnableToHandler(Runnable runnable) {
            Handler handler = this.mHandler == null ? this.this$0.mMainHandler : this.mHandler;
            handler.post(runnable);
        }

        private final void $$robo$$android_accounts_AccountManager_BaseFutureTask$startTask() {
            try {
                this.doWork();
            }
            catch (RemoteException e) {
                this.setException(e);
            }
        }

        private void __constructor__(AccountManager accountManager, Handler handler) {
            this.$$robo$$android_accounts_AccountManager_BaseFutureTask$__constructor__(accountManager, handler);
        }

        public BaseFutureTask(AccountManager accountManager, Handler handler) {
            this.this$0 = accountManager;
            super(new Callable<T>(accountManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AccountManager val$this$0;

                private void $$robo$$android_accounts_AccountManager_BaseFutureTask_1$__constructor__(AccountManager accountManager) {
                }

                private final T $$robo$$android_accounts_AccountManager_BaseFutureTask_1$call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }

                private void __constructor__(AccountManager accountManager) {
                    this.$$robo$$android_accounts_AccountManager_BaseFutureTask_1$__constructor__(accountManager);
                }
                {
                    this.val$this$0 = accountManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_BaseFutureTask_1$__constructor__(android.accounts.AccountManager ), 0, this, accountManager);
                }

                @Override
                public T call() throws Exception {
                    return InvokeDynamicSupport.bootstrap("call", $$robo$$android_accounts_AccountManager_BaseFutureTask_1$call(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_BaseFutureTask$__constructor__(android.accounts.AccountManager android.os.Handler ), 0, this, accountManager, handler);
        }

        protected void postRunnableToHandler(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("postRunnableToHandler", $$robo$$android_accounts_AccountManager_BaseFutureTask$postRunnableToHandler(java.lang.Runnable ), 0, this, runnable);
        }

        protected void startTask() {
            InvokeDynamicSupport.bootstrap("startTask", $$robo$$android_accounts_AccountManager_BaseFutureTask$startTask(), 0, this);
        }

        public /* synthetic */ BaseFutureTask() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseFutureTask)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        protected class Response
        extends IAccountManagerResponse.Stub
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BaseFutureTask this$1;

            private void $$robo$$android_accounts_AccountManager_BaseFutureTask_Response$__constructor__(BaseFutureTask baseFutureTask) {
            }

            private final void $$robo$$android_accounts_AccountManager_BaseFutureTask_Response$onResult(Bundle bundle) {
                try {
                    Object result = this.this$1.bundleToResult(bundle);
                    if (result == null) {
                        return;
                    }
                    this.this$1.set(result);
                    return;
                }
                catch (ClassCastException classCastException) {
                }
                catch (AuthenticatorException authenticatorException) {
                    // empty catch block
                }
                this.onError(5, "no result in response");
            }

            private final void $$robo$$android_accounts_AccountManager_BaseFutureTask_Response$onError(int code, String message) {
                if (code == 4 || code == 100 || code == 101) {
                    this.this$1.cancel(true);
                    return;
                }
                this.this$1.setException(this.this$1.this$0.convertErrorToException(code, message));
            }

            private void __constructor__(BaseFutureTask baseFutureTask) {
                this.$$robo$$android_accounts_AccountManager_BaseFutureTask_Response$__constructor__(baseFutureTask);
            }

            protected Response(BaseFutureTask baseFutureTask) {
                this.this$1 = baseFutureTask;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_BaseFutureTask_Response$__constructor__(android.accounts.AccountManager$BaseFutureTask ), 0, this, baseFutureTask);
            }

            @Override
            public void onResult(Bundle bundle) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_accounts_AccountManager_BaseFutureTask_Response$onResult(android.os.Bundle ), 0, this, bundle);
            }

            @Override
            public void onError(int n, String string2) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_accounts_AccountManager_BaseFutureTask_Response$onError(int java.lang.String ), 0, this, n, string2);
            }

            public /* synthetic */ Response() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Response)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private abstract class AmsTask
    extends FutureTask<Bundle>
    implements AccountManagerFuture<Bundle> {
        public transient /* synthetic */ Object __robo_data__;
        IAccountManagerResponse mResponse;
        Handler mHandler;
        AccountManagerCallback<Bundle> mCallback;
        Activity mActivity;
        /* synthetic */ AccountManager this$0;

        private void $$robo$$android_accounts_AccountManager_AmsTask$__constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback<Bundle> callback) {
            this.mHandler = handler;
            this.mCallback = callback;
            this.mActivity = activity;
            this.mResponse = new Response(this);
        }

        private final AccountManagerFuture<Bundle> $$robo$$android_accounts_AccountManager_AmsTask$start() {
            try {
                this.doWork();
            }
            catch (RemoteException e) {
                this.setException(e);
            }
            return this;
        }

        private final void $$robo$$android_accounts_AccountManager_AmsTask$set(Bundle bundle) {
            if (bundle == null) {
                Log.e("AccountManager", "the bundle must not be null", new Exception());
            }
            super.set(bundle);
        }

        public abstract void doWork() throws RemoteException;

        private final Bundle $$robo$$android_accounts_AccountManager_AmsTask$internalGetResult(Long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            if (!this.isDone()) {
                this.this$0.ensureNotOnMainThread();
            }
            try {
                if (timeout == null) {
                    Bundle bundle = (Bundle)this.get();
                    return bundle;
                }
                Bundle bundle = (Bundle)this.get(timeout, unit);
                return bundle;
            }
            catch (CancellationException e) {
                throw new OperationCanceledException();
            }
            catch (TimeoutException e) {
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw new AuthenticatorException(cause);
                }
                if (cause instanceof AuthenticatorException) {
                    throw (AuthenticatorException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IllegalStateException(cause);
            }
            finally {
                this.cancel(true);
            }
            throw new OperationCanceledException();
        }

        private final Bundle $$robo$$android_accounts_AccountManager_AmsTask$getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        private final Bundle $$robo$$android_accounts_AccountManager_AmsTask$getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(timeout, unit);
        }

        private final void $$robo$$android_accounts_AccountManager_AmsTask$done() {
            if (this.mCallback != null) {
                this.this$0.postToHandler(this.mHandler, this.mCallback, this);
            }
        }

        private void __constructor__(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback<Bundle> accountManagerCallback) {
            this.$$robo$$android_accounts_AccountManager_AmsTask$__constructor__(accountManager, activity, handler, accountManagerCallback);
        }

        public AmsTask(AccountManager accountManager, Activity activity, Handler handler, AccountManagerCallback<Bundle> accountManagerCallback) {
            this.this$0 = accountManager;
            super(new Callable<Bundle>(accountManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AccountManager val$this$0;

                private void $$robo$$android_accounts_AccountManager_AmsTask_1$__constructor__(AccountManager accountManager) {
                }

                private final Bundle $$robo$$android_accounts_AccountManager_AmsTask_1$call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }

                private void __constructor__(AccountManager accountManager) {
                    this.$$robo$$android_accounts_AccountManager_AmsTask_1$__constructor__(accountManager);
                }
                {
                    this.val$this$0 = accountManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_AmsTask_1$__constructor__(android.accounts.AccountManager ), 0, this, accountManager);
                }

                @Override
                public Bundle call() throws Exception {
                    return InvokeDynamicSupport.bootstrap("call", $$robo$$android_accounts_AccountManager_AmsTask_1$call(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_AmsTask$__constructor__(android.accounts.AccountManager android.app.Activity android.os.Handler android.accounts.AccountManagerCallback<android.os.Bundle> ), 0, this, accountManager, activity, handler, accountManagerCallback);
        }

        public AccountManagerFuture<Bundle> start() {
            return InvokeDynamicSupport.bootstrap("start", $$robo$$android_accounts_AccountManager_AmsTask$start(), 0, this);
        }

        @Override
        protected void set(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_accounts_AccountManager_AmsTask$set(android.os.Bundle ), 0, this, bundle);
        }

        private Bundle internalGetResult(Long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            return InvokeDynamicSupport.bootstrap("internalGetResult", $$robo$$android_accounts_AccountManager_AmsTask$internalGetResult(java.lang.Long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
        }

        @Override
        public Bundle getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_accounts_AccountManager_AmsTask$getResult(), 0, this);
        }

        @Override
        public Bundle getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            return InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_accounts_AccountManager_AmsTask$getResult(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
        }

        @Override
        protected void done() {
            InvokeDynamicSupport.bootstrap("done", $$robo$$android_accounts_AccountManager_AmsTask$done(), 0, this);
        }

        public /* synthetic */ AmsTask() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AmsTask)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class Response
        extends IAccountManagerResponse.Stub
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AmsTask this$1;

            private void $$robo$$android_accounts_AccountManager_AmsTask_Response$__constructor__(AmsTask amsTask) {
            }

            private final void $$robo$$android_accounts_AccountManager_AmsTask_Response$onResult(Bundle bundle) {
                Intent intent = (Intent)bundle.getParcelable("intent");
                if (intent != null && this.this$1.mActivity != null) {
                    this.this$1.mActivity.startActivity(intent);
                } else if (bundle.getBoolean("retry")) {
                    try {
                        this.this$1.doWork();
                    }
                    catch (RemoteException remoteException) {}
                } else {
                    this.this$1.set(bundle);
                }
            }

            private final void $$robo$$android_accounts_AccountManager_AmsTask_Response$onError(int code, String message) {
                if (code == 4 || code == 100 || code == 101) {
                    this.this$1.cancel(true);
                    return;
                }
                this.this$1.setException(this.this$1.this$0.convertErrorToException(code, message));
            }

            private /* synthetic */ void $$robo$$android_accounts_AccountManager_AmsTask_Response$__constructor__(AmsTask x0, 1 x1) {
            }

            private void __constructor__(AmsTask amsTask) {
                this.$$robo$$android_accounts_AccountManager_AmsTask_Response$__constructor__(amsTask);
            }

            private Response(AmsTask amsTask) {
                this.this$1 = amsTask;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_AccountManager_AmsTask_Response$__constructor__(android.accounts.AccountManager$AmsTask ), 0, this, amsTask);
            }

            @Override
            public void onResult(Bundle bundle) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_accounts_AccountManager_AmsTask_Response$onResult(android.os.Bundle ), 0, this, bundle);
            }

            @Override
            public void onError(int n, String string2) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_accounts_AccountManager_AmsTask_Response$onError(int java.lang.String ), 0, this, n, string2);
            }

            private /* synthetic */ void __constructor__(AmsTask amsTask, 1 var2_2) {
                this.$$robo$$android_accounts_AccountManager_AmsTask_Response$__constructor__(amsTask, var2_2);
            }

            public /* synthetic */ Response() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Response)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

