/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.ChooseAccountTypeActivity;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class ChooseTypeAndAccountActivity
extends Activity
implements AccountManagerCallback<Bundle> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AccountChooser";
    public static String EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST = "allowableAccounts";
    public static String EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY = "allowableAccountTypes";
    public static String EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE = "addAccountOptions";
    public static String EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY = "addAccountRequiredFeatures";
    public static String EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING = "authTokenType";
    public static String EXTRA_SELECTED_ACCOUNT = "selectedAccount";
    public static String EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT = "alwaysPromptForAccount";
    public static String EXTRA_DESCRIPTION_TEXT_OVERRIDE = "descriptionTextOverride";
    public static int REQUEST_NULL = 0;
    public static int REQUEST_CHOOSE_TYPE = 1;
    public static int REQUEST_ADD_ACCOUNT = 2;
    private static String KEY_INSTANCE_STATE_PENDING_REQUEST = "pendingRequest";
    private static String KEY_INSTANCE_STATE_EXISTING_ACCOUNTS = "existingAccounts";
    private static String KEY_INSTANCE_STATE_SELECTED_ACCOUNT_NAME = "selectedAccountName";
    private static String KEY_INSTANCE_STATE_SELECTED_ADD_ACCOUNT = "selectedAddAccount";
    private static String KEY_INSTANCE_STATE_ACCOUNT_LIST = "accountList";
    private static int SELECTED_ITEM_NONE = -1;
    private Set<Account> mSetOfAllowableAccounts;
    private Set<String> mSetOfRelevantAccountTypes;
    private String mSelectedAccountName;
    private boolean mSelectedAddNewAccount;
    private boolean mAlwaysPromptForAccount;
    private String mDescriptionOverride;
    private ArrayList<Account> mAccounts;
    private int mPendingRequest;
    private Parcelable[] mExistingAccounts;
    private int mSelectedItemIndex;
    private Button mOkButton;
    private int mCallingUid;
    private String mCallingPackage;
    private boolean mDisallowAddAccounts;
    private boolean mDontShowPicker;

    private void $$robo$$android_accounts_ChooseTypeAndAccountActivity$__constructor__() {
        this.mSelectedAccountName = null;
        this.mSelectedAddNewAccount = false;
        this.mAlwaysPromptForAccount = false;
        this.mPendingRequest = 0;
        this.mExistingAccounts = null;
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseTypeAndAccountActivity.onCreate(savedInstanceState=" + savedInstanceState + ")");
        }
        Object message = null;
        try {
            IBinder activityToken = this.getActivityToken();
            this.mCallingUid = ActivityManagerNative.getDefault().getLaunchedFromUid(activityToken);
            this.mCallingPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(activityToken);
            if (this.mCallingUid != 0 && this.mCallingPackage != null) {
                Bundle restrictions = UserManager.get(this).getUserRestrictions(new UserHandle(UserHandle.getUserId(this.mCallingUid)));
                this.mDisallowAddAccounts = restrictions.getBoolean("no_modify_accounts", false);
            }
        }
        catch (RemoteException re) {
            Log.w(this.getClass().getSimpleName(), "Unable to get caller identity \n" + re);
        }
        Intent intent = this.getIntent();
        if (savedInstanceState != null) {
            this.mPendingRequest = savedInstanceState.getInt("pendingRequest");
            this.mExistingAccounts = savedInstanceState.getParcelableArray("existingAccounts");
            this.mSelectedAccountName = savedInstanceState.getString("selectedAccountName");
            this.mSelectedAddNewAccount = savedInstanceState.getBoolean("selectedAddAccount", false);
            this.mAccounts = savedInstanceState.getParcelableArrayList("accountList");
        } else {
            this.mPendingRequest = 0;
            this.mExistingAccounts = null;
            Account selectedAccount = (Account)intent.getParcelableExtra("selectedAccount");
            if (selectedAccount != null) {
                this.mSelectedAccountName = selectedAccount.name;
            }
        }
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "selected account name is " + this.mSelectedAccountName);
        }
        this.mSetOfAllowableAccounts = this.getAllowableAccountSet(intent);
        this.mSetOfRelevantAccountTypes = this.getReleventAccountTypes(intent);
        this.mAlwaysPromptForAccount = intent.getBooleanExtra("alwaysPromptForAccount", false);
        this.mDescriptionOverride = intent.getStringExtra("descriptionTextOverride");
        this.mAccounts = this.getAcceptableAccountChoices(AccountManager.get(this));
        if (this.mAccounts.isEmpty() && this.mDisallowAddAccounts) {
            this.requestWindowFeature(1);
            this.setContentView(17367089);
            this.mDontShowPicker = true;
        }
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onResume() {
        super.onResume();
        if (this.mDontShowPicker) {
            return;
        }
        AccountManager accountManager = AccountManager.get(this);
        this.mAccounts = this.getAcceptableAccountChoices(accountManager);
        if (this.mPendingRequest == 0) {
            if (this.mAccounts.isEmpty()) {
                if (this.mSetOfRelevantAccountTypes.size() == 1) {
                    this.runAddAccountForAuthenticator(this.mSetOfRelevantAccountTypes.iterator().next());
                } else {
                    this.startChooseAccountTypeActivity();
                }
                return;
            }
            if (!this.mAlwaysPromptForAccount && this.mAccounts.size() == 1) {
                Account account = this.mAccounts.get(0);
                this.setResultAndFinish(account.name, account.type);
                return;
            }
        }
        String[] listItems = this.getListOfDisplayableOptions(this.mAccounts);
        this.mSelectedItemIndex = this.getItemIndexToSelect(this.mAccounts, this.mSelectedAccountName, this.mSelectedAddNewAccount);
        this.setContentView(17367103);
        this.overrideDescriptionIfSupplied(this.mDescriptionOverride);
        this.populateUIAccountList(listItems);
        this.mOkButton = (Button)this.findViewById(16908314);
        this.mOkButton.setEnabled(this.mSelectedItemIndex != -1);
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onDestroy() {
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseTypeAndAccountActivity.onDestroy()");
        }
        super.onDestroy();
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("pendingRequest", this.mPendingRequest);
        if (this.mPendingRequest == 2) {
            outState.putParcelableArray("existingAccounts", this.mExistingAccounts);
        }
        if (this.mSelectedItemIndex != -1) {
            if (this.mSelectedItemIndex == this.mAccounts.size()) {
                outState.putBoolean("selectedAddAccount", true);
            } else {
                outState.putBoolean("selectedAddAccount", false);
                outState.putString("selectedAccountName", this.mAccounts.get((int)this.mSelectedItemIndex).name);
            }
        }
        outState.putParcelableArrayList("accountList", this.mAccounts);
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onCancelButtonClicked(View view) {
        this.onBackPressed();
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onOkButtonClicked(View view) {
        if (this.mSelectedItemIndex == this.mAccounts.size()) {
            this.startChooseAccountTypeActivity();
        } else if (this.mSelectedItemIndex != -1) {
            this.onAccountSelected(this.mAccounts.get(this.mSelectedItemIndex));
        }
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onActivityResult(int requestCode, int resultCode, Intent data) {
        if (Log.isLoggable("AccountChooser", 2)) {
            if (data != null && data.getExtras() != null) {
                data.getExtras().keySet();
            }
            Bundle extras = data != null ? data.getExtras() : null;
            Log.v("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult(reqCode=" + requestCode + ", resCode=" + resultCode + ", extras=" + extras + ")");
        }
        this.mPendingRequest = 0;
        if (resultCode == 0) {
            if (this.mAccounts.isEmpty()) {
                this.setResult(0);
                this.finish();
            }
            return;
        }
        if (resultCode == -1) {
            if (requestCode == 1) {
                String accountType;
                if (data != null && (accountType = data.getStringExtra("accountType")) != null) {
                    this.runAddAccountForAuthenticator(accountType);
                    return;
                }
                Log.d("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult: unable to find account type, pretending the request was canceled");
            } else if (requestCode == 2) {
                String accountName = null;
                String accountType = null;
                if (data != null) {
                    accountName = data.getStringExtra("authAccount");
                    accountType = data.getStringExtra("accountType");
                }
                if (accountName == null || accountType == null) {
                    Account[] currentAccounts = AccountManager.get(this).getAccountsForPackage(this.mCallingPackage, this.mCallingUid);
                    HashSet<Account> preExistingAccounts = new HashSet<Account>();
                    for (Parcelable parcelable : this.mExistingAccounts) {
                        preExistingAccounts.add((Account)parcelable);
                    }
                    for (Parcelable parcelable : currentAccounts) {
                        if (preExistingAccounts.contains(parcelable)) continue;
                        accountName = ((Account)parcelable).name;
                        accountType = ((Account)parcelable).type;
                        break;
                    }
                }
                if (accountName != null || accountType != null) {
                    this.setResultAndFinish(accountName, accountType);
                    return;
                }
            }
            Log.d("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult: unable to find added account, pretending the request was canceled");
        }
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult: canceled");
        }
        this.setResult(0);
        this.finish();
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$runAddAccountForAuthenticator(String type) {
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "runAddAccountForAuthenticator: " + type);
        }
        Bundle options = this.getIntent().getBundleExtra("addAccountOptions");
        String[] requiredFeatures = this.getIntent().getStringArrayExtra("addAccountRequiredFeatures");
        String authTokenType = this.getIntent().getStringExtra("authTokenType");
        AccountManager.get(this).addAccount(type, authTokenType, requiredFeatures, options, null, this, null);
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$run(AccountManagerFuture<Bundle> accountManagerFuture) {
        try {
            Bundle accountManagerResult = accountManagerFuture.getResult();
            Intent intent = (Intent)accountManagerResult.getParcelable("intent");
            if (intent != null) {
                this.mPendingRequest = 2;
                this.mExistingAccounts = AccountManager.get(this).getAccountsForPackage(this.mCallingPackage, this.mCallingUid);
                intent.setFlags(intent.getFlags() & 0xEFFFFFFF);
                this.startActivityForResult(intent, 2);
                return;
            }
        }
        catch (OperationCanceledException e) {
            this.setResult(0);
            this.finish();
            return;
        }
        catch (IOException e) {
        }
        catch (AuthenticatorException e) {
            // empty catch block
        }
        Bundle bundle = new Bundle();
        bundle.putString("errorMessage", "error communicating with server");
        this.setResult(-1, new Intent().putExtras(bundle));
        this.finish();
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$onAccountSelected(Account account) {
        Log.d("AccountChooser", "selected account " + account);
        this.setResultAndFinish(account.name, account.type);
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$setResultAndFinish(String accountName, String accountType) {
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", accountName);
        bundle.putString("accountType", accountType);
        this.setResult(-1, new Intent().putExtras(bundle));
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseTypeAndAccountActivity.setResultAndFinish: selected account " + accountName + ", " + accountType);
        }
        this.finish();
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$startChooseAccountTypeActivity() {
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseAccountTypeActivity.startChooseAccountTypeActivity()");
        }
        Intent intent = new Intent(this, ChooseAccountTypeActivity.class);
        intent.setFlags(524288);
        intent.putExtra("allowableAccountTypes", this.getIntent().getStringArrayExtra("allowableAccountTypes"));
        intent.putExtra("addAccountOptions", this.getIntent().getBundleExtra("addAccountOptions"));
        intent.putExtra("addAccountRequiredFeatures", this.getIntent().getStringArrayExtra("addAccountRequiredFeatures"));
        intent.putExtra("authTokenType", this.getIntent().getStringExtra("authTokenType"));
        this.startActivityForResult(intent, 1);
        this.mPendingRequest = 1;
    }

    private final int $$robo$$android_accounts_ChooseTypeAndAccountActivity$getItemIndexToSelect(ArrayList<Account> accounts, String selectedAccountName, boolean selectedAddNewAccount) {
        if (selectedAddNewAccount) {
            return accounts.size();
        }
        for (int i = 0; i < accounts.size(); ++i) {
            if (!accounts.get((int)i).name.equals(selectedAccountName)) continue;
            return i;
        }
        return -1;
    }

    private final String[] $$robo$$android_accounts_ChooseTypeAndAccountActivity$getListOfDisplayableOptions(ArrayList<Account> accounts) {
        String[] listItems = new String[accounts.size() + (this.mDisallowAddAccounts ? 0 : 1)];
        for (int i = 0; i < accounts.size(); ++i) {
            listItems[i] = accounts.get((int)i).name;
        }
        if (!this.mDisallowAddAccounts) {
            listItems[accounts.size()] = this.getResources().getString(17040746);
        }
        return listItems;
    }

    private final ArrayList<Account> $$robo$$android_accounts_ChooseTypeAndAccountActivity$getAcceptableAccountChoices(AccountManager accountManager) {
        Account[] accounts = accountManager.getAccountsForPackage(this.mCallingPackage, this.mCallingUid);
        ArrayList<Account> accountsToPopulate = new ArrayList<Account>(accounts.length);
        for (Account account : accounts) {
            if (this.mSetOfAllowableAccounts != null && !this.mSetOfAllowableAccounts.contains(account) || this.mSetOfRelevantAccountTypes != null && !this.mSetOfRelevantAccountTypes.contains(account.type)) continue;
            accountsToPopulate.add(account);
        }
        return accountsToPopulate;
    }

    private final Set<String> $$robo$$android_accounts_ChooseTypeAndAccountActivity$getReleventAccountTypes(Intent intent) {
        HashSet<String> setOfRelevantAccountTypes = null;
        String[] allowedAccountTypes = intent.getStringArrayExtra("allowableAccountTypes");
        if (allowedAccountTypes != null) {
            setOfRelevantAccountTypes = Sets.newHashSet(allowedAccountTypes);
            AuthenticatorDescription[] descs = AccountManager.get(this).getAuthenticatorTypes();
            HashSet<String> supportedAccountTypes = new HashSet<String>(descs.length);
            for (AuthenticatorDescription desc : descs) {
                supportedAccountTypes.add(desc.type);
            }
            setOfRelevantAccountTypes.retainAll(supportedAccountTypes);
        }
        return setOfRelevantAccountTypes;
    }

    private final Set<Account> $$robo$$android_accounts_ChooseTypeAndAccountActivity$getAllowableAccountSet(Intent intent) {
        HashSet<Account> setOfAllowableAccounts = null;
        ArrayList validAccounts = intent.getParcelableArrayListExtra("allowableAccounts");
        if (validAccounts != null) {
            setOfAllowableAccounts = new HashSet<Account>(validAccounts.size());
            for (Parcelable parcelable : validAccounts) {
                setOfAllowableAccounts.add((Account)parcelable);
            }
        }
        return setOfAllowableAccounts;
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$overrideDescriptionIfSupplied(String descriptionOverride) {
        TextView descriptionView = (TextView)this.findViewById(16909009);
        if (!TextUtils.isEmpty(descriptionOverride)) {
            descriptionView.setText(descriptionOverride);
        } else {
            descriptionView.setVisibility(8);
        }
    }

    private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity$populateUIAccountList(String[] listItems) {
        ListView list = (ListView)this.findViewById(16908298);
        list.setAdapter(new ArrayAdapter<String>((Context)this, 17367055, listItems));
        list.setChoiceMode(1);
        list.setItemsCanFocus(false);
        list.setOnItemClickListener(new AdapterView.OnItemClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ChooseTypeAndAccountActivity this$0;

            private void $$robo$$android_accounts_ChooseTypeAndAccountActivity_1$__constructor__(ChooseTypeAndAccountActivity chooseTypeAndAccountActivity) {
            }

            private final void $$robo$$android_accounts_ChooseTypeAndAccountActivity_1$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                this.this$0.mSelectedItemIndex = position;
                this.this$0.mOkButton.setEnabled(true);
            }

            private void __constructor__(ChooseTypeAndAccountActivity chooseTypeAndAccountActivity) {
                this.$$robo$$android_accounts_ChooseTypeAndAccountActivity_1$__constructor__(chooseTypeAndAccountActivity);
            }
            {
                this.this$0 = chooseTypeAndAccountActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseTypeAndAccountActivity_1$__constructor__(android.accounts.ChooseTypeAndAccountActivity ), 0, this, chooseTypeAndAccountActivity);
            }

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_accounts_ChooseTypeAndAccountActivity_1$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        if (this.mSelectedItemIndex != -1) {
            list.setItemChecked(this.mSelectedItemIndex, true);
            if (Log.isLoggable("AccountChooser", 2)) {
                Log.v("AccountChooser", "List item " + this.mSelectedItemIndex + " should be selected");
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_accounts_ChooseTypeAndAccountActivity$__constructor__();
    }

    public ChooseTypeAndAccountActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseTypeAndAccountActivity$__constructor__(), 0, this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    protected void onResume() {
        InvokeDynamicSupport.bootstrap("onResume", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onResume(), 0, this);
    }

    @Override
    protected void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onDestroy(), 0, this);
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onSaveInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    public void onCancelButtonClicked(View view) {
        InvokeDynamicSupport.bootstrap("onCancelButtonClicked", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onCancelButtonClicked(android.view.View ), 0, this, view);
    }

    public void onOkButtonClicked(View view) {
        InvokeDynamicSupport.bootstrap("onOkButtonClicked", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onOkButtonClicked(android.view.View ), 0, this, view);
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("onActivityResult", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onActivityResult(int int android.content.Intent ), 0, this, n, n2, intent);
    }

    protected void runAddAccountForAuthenticator(String string2) {
        InvokeDynamicSupport.bootstrap("runAddAccountForAuthenticator", $$robo$$android_accounts_ChooseTypeAndAccountActivity$runAddAccountForAuthenticator(java.lang.String ), 0, this, string2);
    }

    @Override
    public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_ChooseTypeAndAccountActivity$run(android.accounts.AccountManagerFuture<android.os.Bundle> ), 0, this, accountManagerFuture);
    }

    private void onAccountSelected(Account account) {
        InvokeDynamicSupport.bootstrap("onAccountSelected", $$robo$$android_accounts_ChooseTypeAndAccountActivity$onAccountSelected(android.accounts.Account ), 0, this, account);
    }

    private void setResultAndFinish(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setResultAndFinish", $$robo$$android_accounts_ChooseTypeAndAccountActivity$setResultAndFinish(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void startChooseAccountTypeActivity() {
        InvokeDynamicSupport.bootstrap("startChooseAccountTypeActivity", $$robo$$android_accounts_ChooseTypeAndAccountActivity$startChooseAccountTypeActivity(), 0, this);
    }

    private int getItemIndexToSelect(ArrayList<Account> arrayList, String string2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getItemIndexToSelect", $$robo$$android_accounts_ChooseTypeAndAccountActivity$getItemIndexToSelect(java.util.ArrayList<android.accounts.Account> java.lang.String boolean ), 0, this, arrayList, string2, bl);
    }

    private String[] getListOfDisplayableOptions(ArrayList<Account> arrayList) {
        return InvokeDynamicSupport.bootstrap("getListOfDisplayableOptions", $$robo$$android_accounts_ChooseTypeAndAccountActivity$getListOfDisplayableOptions(java.util.ArrayList<android.accounts.Account> ), 0, this, arrayList);
    }

    private ArrayList<Account> getAcceptableAccountChoices(AccountManager accountManager) {
        return InvokeDynamicSupport.bootstrap("getAcceptableAccountChoices", $$robo$$android_accounts_ChooseTypeAndAccountActivity$getAcceptableAccountChoices(android.accounts.AccountManager ), 0, this, accountManager);
    }

    private Set<String> getReleventAccountTypes(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getReleventAccountTypes", $$robo$$android_accounts_ChooseTypeAndAccountActivity$getReleventAccountTypes(android.content.Intent ), 0, this, intent);
    }

    private Set<Account> getAllowableAccountSet(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getAllowableAccountSet", $$robo$$android_accounts_ChooseTypeAndAccountActivity$getAllowableAccountSet(android.content.Intent ), 0, this, intent);
    }

    private void overrideDescriptionIfSupplied(String string2) {
        InvokeDynamicSupport.bootstrap("overrideDescriptionIfSupplied", $$robo$$android_accounts_ChooseTypeAndAccountActivity$overrideDescriptionIfSupplied(java.lang.String ), 0, this, string2);
    }

    private void populateUIAccountList(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("populateUIAccountList", $$robo$$android_accounts_ChooseTypeAndAccountActivity$populateUIAccountList(java.lang.String[] ), 0, this, stringArray);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooseTypeAndAccountActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

