/*
 * Decompiled with CFR 0.152.
 */
package android.alsa;

import android.alsa.LineTokenizer;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlsaDevicesParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AlsaDevicesParser";
    private static int kIndex_CardDeviceField = 5;
    private static int kStartIndex_CardNum = 6;
    private static int kEndIndex_CardNum = 8;
    private static int kStartIndex_DeviceNum = 9;
    private static int kEndIndex_DeviceNum = 11;
    private static int kStartIndex_Type = 14;
    private static LineTokenizer mTokenizer;
    private boolean mHasCaptureDevices;
    private boolean mHasPlaybackDevices;
    private boolean mHasMIDIDevices;
    private Vector<AlsaDeviceRecord> deviceRecords_;

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$isLineDeviceRecord(String line) {
        return line.charAt(5) == '[';
    }

    private void $$robo$$android_alsa_AlsaDevicesParser$__constructor__() {
        this.mHasCaptureDevices = false;
        this.mHasPlaybackDevices = false;
        this.mHasMIDIDevices = false;
        this.deviceRecords_ = new Vector();
    }

    private final int $$robo$$android_alsa_AlsaDevicesParser$getNumDeviceRecords() {
        return this.deviceRecords_.size();
    }

    private final AlsaDeviceRecord $$robo$$android_alsa_AlsaDevicesParser$getDeviceRecordAt(int index) {
        return this.deviceRecords_.get(index);
    }

    private final void $$robo$$android_alsa_AlsaDevicesParser$Log() {
        int numDevRecs = this.getNumDeviceRecords();
        for (int index = 0; index < numDevRecs; ++index) {
            Slog.w("AlsaDevicesParser", "usb:" + this.getDeviceRecordAt(index).textFormat());
        }
    }

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$hasPlaybackDevices() {
        return this.mHasPlaybackDevices;
    }

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$hasPlaybackDevices(int card) {
        for (int index = 0; index < this.deviceRecords_.size(); ++index) {
            AlsaDeviceRecord deviceRecord = this.deviceRecords_.get(index);
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 0 || deviceRecord.mDeviceDir != 1) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$hasCaptureDevices() {
        return this.mHasCaptureDevices;
    }

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$hasCaptureDevices(int card) {
        for (int index = 0; index < this.deviceRecords_.size(); ++index) {
            AlsaDeviceRecord deviceRecord = this.deviceRecords_.get(index);
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 0 || deviceRecord.mDeviceDir != 0) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$hasMIDIDevices() {
        return this.mHasMIDIDevices;
    }

    private final boolean $$robo$$android_alsa_AlsaDevicesParser$hasMIDIDevices(int card) {
        for (int index = 0; index < this.deviceRecords_.size(); ++index) {
            AlsaDeviceRecord deviceRecord = this.deviceRecords_.get(index);
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 2) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_alsa_AlsaDevicesParser$scan() {
        this.deviceRecords_.clear();
        String devicesFilePath = "/proc/asound/devices";
        File devicesFile = new File("/proc/asound/devices");
        try {
            FileReader reader = new FileReader(devicesFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (!this.isLineDeviceRecord(line)) continue;
                AlsaDeviceRecord deviceRecord = new AlsaDeviceRecord(this);
                deviceRecord.parse(line);
                this.deviceRecords_.add(deviceRecord);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void __staticInitializer__() {
        mTokenizer = new LineTokenizer(" :[]-");
    }

    private boolean isLineDeviceRecord(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLineDeviceRecord", $$robo$$android_alsa_AlsaDevicesParser$isLineDeviceRecord(java.lang.String ), 0, this, string2);
    }

    private void __constructor__() {
        this.$$robo$$android_alsa_AlsaDevicesParser$__constructor__();
    }

    public AlsaDevicesParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_alsa_AlsaDevicesParser$__constructor__(), 0, this);
    }

    public int getNumDeviceRecords() {
        return (int)InvokeDynamicSupport.bootstrap("getNumDeviceRecords", $$robo$$android_alsa_AlsaDevicesParser$getNumDeviceRecords(), 0, this);
    }

    public AlsaDeviceRecord getDeviceRecordAt(int n) {
        return InvokeDynamicSupport.bootstrap("getDeviceRecordAt", $$robo$$android_alsa_AlsaDevicesParser$getDeviceRecordAt(int ), 0, this, n);
    }

    public void Log() {
        InvokeDynamicSupport.bootstrap("Log", $$robo$$android_alsa_AlsaDevicesParser$Log(), 0, this);
    }

    public boolean hasPlaybackDevices() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPlaybackDevices", $$robo$$android_alsa_AlsaDevicesParser$hasPlaybackDevices(), 0, this);
    }

    public boolean hasPlaybackDevices(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPlaybackDevices", $$robo$$android_alsa_AlsaDevicesParser$hasPlaybackDevices(int ), 0, this, n);
    }

    public boolean hasCaptureDevices() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCaptureDevices", $$robo$$android_alsa_AlsaDevicesParser$hasCaptureDevices(), 0, this);
    }

    public boolean hasCaptureDevices(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCaptureDevices", $$robo$$android_alsa_AlsaDevicesParser$hasCaptureDevices(int ), 0, this, n);
    }

    public boolean hasMIDIDevices() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMIDIDevices", $$robo$$android_alsa_AlsaDevicesParser$hasMIDIDevices(), 0, this);
    }

    public boolean hasMIDIDevices(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMIDIDevices", $$robo$$android_alsa_AlsaDevicesParser$hasMIDIDevices(int ), 0, this, n);
    }

    public void scan() {
        InvokeDynamicSupport.bootstrap("scan", $$robo$$android_alsa_AlsaDevicesParser$scan(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AlsaDevicesParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaDevicesParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class AlsaDeviceRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int kDeviceType_Unknown = -1;
        public static int kDeviceType_Audio = 0;
        public static int kDeviceType_Control = 1;
        public static int kDeviceType_MIDI = 2;
        public static int kDeviceDir_Unknown = -1;
        public static int kDeviceDir_Capture = 0;
        public static int kDeviceDir_Playback = 1;
        int mCardNum;
        int mDeviceNum;
        int mDeviceType;
        int mDeviceDir;
        /* synthetic */ AlsaDevicesParser this$0;

        private void $$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$__constructor__(AlsaDevicesParser alsaDevicesParser) {
            this.mCardNum = -1;
            this.mDeviceNum = -1;
            this.mDeviceType = -1;
            this.mDeviceDir = -1;
        }

        private final boolean $$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$parse(String line) {
            boolean kToken_LineNum = false;
            boolean kToken_CardNum = true;
            int kToken_DeviceNum = 2;
            int kToken_Type0 = 3;
            int kToken_Type1 = 4;
            int kToken_Type2 = 5;
            int tokenOffset = 0;
            int delimOffset = 0;
            int tokenIndex = 0;
            while ((tokenOffset = mTokenizer.nextToken(line, delimOffset)) != -1) {
                delimOffset = mTokenizer.nextDelimiter(line, tokenOffset);
                if (delimOffset == -1) {
                    delimOffset = line.length();
                }
                String token = line.substring(tokenOffset, delimOffset);
                switch (tokenIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.mCardNum = Integer.parseInt(token);
                        if (line.charAt(delimOffset) == '-') break;
                        ++tokenIndex;
                        break;
                    }
                    case 2: {
                        this.mDeviceNum = Integer.parseInt(token);
                        break;
                    }
                    case 3: {
                        if (token.equals("digital")) break;
                        if (token.equals("control")) {
                            this.mDeviceType = 1;
                            break;
                        }
                        if (!token.equals("raw")) break;
                        break;
                    }
                    case 4: {
                        if (token.equals("audio")) {
                            this.mDeviceType = 0;
                            break;
                        }
                        if (!token.equals("midi")) break;
                        this.mDeviceType = 2;
                        this.this$0.mHasMIDIDevices = true;
                        break;
                    }
                    case 5: {
                        if (token.equals("capture")) {
                            this.mDeviceDir = 0;
                            this.this$0.mHasCaptureDevices = true;
                            break;
                        }
                        if (!token.equals("playback")) break;
                        this.mDeviceDir = 1;
                        this.this$0.mHasPlaybackDevices = true;
                    }
                }
                ++tokenIndex;
            }
            return true;
        }

        private final String $$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$textFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.mCardNum + ":" + this.mDeviceNum + "]");
            switch (this.mDeviceType) {
                case -1: {
                    sb.append(" N/A");
                    break;
                }
                case 0: {
                    sb.append(" Audio");
                    break;
                }
                case 1: {
                    sb.append(" Control");
                    break;
                }
                case 2: {
                    sb.append(" MIDI");
                }
            }
            switch (this.mDeviceDir) {
                case -1: {
                    sb.append(" N/A");
                    break;
                }
                case 0: {
                    sb.append(" Capture");
                    break;
                }
                case 1: {
                    sb.append(" Playback");
                }
            }
            return sb.toString();
        }

        private void __constructor__(AlsaDevicesParser alsaDevicesParser) {
            this.$$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$__constructor__(alsaDevicesParser);
        }

        public AlsaDeviceRecord(AlsaDevicesParser alsaDevicesParser) {
            this.this$0 = alsaDevicesParser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$__constructor__(android.alsa.AlsaDevicesParser ), 0, this, alsaDevicesParser);
        }

        public boolean parse(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$parse(java.lang.String ), 0, this, string2);
        }

        public String textFormat() {
            return InvokeDynamicSupport.bootstrap("textFormat", $$robo$$android_alsa_AlsaDevicesParser_AlsaDeviceRecord$textFormat(), 0, this);
        }

        public /* synthetic */ AlsaDeviceRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaDeviceRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

