/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AnimatorSet
extends Animator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ArrayList<Animator> mPlayingSet;
    private HashMap<Animator, Node> mNodeMap;
    private ArrayList<Node> mNodes;
    private ArrayList<Node> mSortedNodes;
    private boolean mNeedsSort;
    private AnimatorSetListener mSetListener;
    boolean mTerminated;
    private boolean mStarted;
    private long mStartDelay;
    private ValueAnimator mDelayAnim;
    private long mDuration;
    private TimeInterpolator mInterpolator;
    private boolean mReversible;

    private void $$robo$$android_animation_AnimatorSet$__constructor__() {
        this.mPlayingSet = new ArrayList();
        this.mNodeMap = new HashMap();
        this.mNodes = new ArrayList();
        this.mSortedNodes = new ArrayList();
        this.mNeedsSort = true;
        this.mSetListener = null;
        this.mTerminated = false;
        this.mStarted = false;
        this.mStartDelay = 0L;
        this.mDelayAnim = null;
        this.mDuration = -1L;
        this.mInterpolator = null;
        this.mReversible = true;
    }

    private final void $$robo$$android_animation_AnimatorSet$playTogether(Animator ... items) {
        if (items != null) {
            this.mNeedsSort = true;
            Builder builder = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder.with(items[i]);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            this.mNeedsSort = true;
            Builder builder = null;
            for (Animator anim2 : items) {
                if (builder == null) {
                    builder = this.play(anim2);
                    continue;
                }
                builder.with(anim2);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playSequentially(Animator ... items) {
        if (items != null) {
            this.mNeedsSort = true;
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                this.mReversible = false;
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            this.mNeedsSort = true;
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                this.mReversible = false;
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    private final ArrayList<Animator> $$robo$$android_animation_AnimatorSet$getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        for (Node node : this.mNodes) {
            childList.add(node.animation);
        }
        return childList;
    }

    private final void $$robo$$android_animation_AnimatorSet$setTarget(Object target) {
        for (Node node : this.mNodes) {
            Animator animation = node.animation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    private final TimeInterpolator $$robo$$android_animation_AnimatorSet$getInterpolator() {
        return this.mInterpolator;
    }

    private final Builder $$robo$$android_animation_AnimatorSet$play(Animator anim2) {
        if (anim2 != null) {
            this.mNeedsSort = true;
            return new Builder(this, anim2);
        }
        return null;
    }

    private final void $$robo$$android_animation_AnimatorSet$cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationCancel(this);
                }
            }
            if (this.mDelayAnim != null && this.mDelayAnim.isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.cancel();
                }
            }
            if (tmpListeners != null) {
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                this.sortNodes();
                for (Node node : this.mSortedNodes) {
                    if (this.mSetListener == null) {
                        this.mSetListener = new AnimatorSetListener(this, this);
                    }
                    node.animation.addListener(this.mSetListener);
                }
            }
            if (this.mDelayAnim != null) {
                this.mDelayAnim.cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.end();
                }
            }
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isRunning() {
        for (Node node : this.mNodes) {
            if (!node.animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isStarted() {
        return this.mStarted;
    }

    private final long $$robo$$android_animation_AnimatorSet$getStartDelay() {
        return this.mStartDelay;
    }

    private final void $$robo$$android_animation_AnimatorSet$setStartDelay(long startDelay) {
        if (this.mStartDelay > 0L) {
            this.mReversible = false;
        }
        this.mStartDelay = startDelay;
    }

    private final long $$robo$$android_animation_AnimatorSet$getDuration() {
        return this.mDuration;
    }

    private final AnimatorSet $$robo$$android_animation_AnimatorSet$setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDuration = duration;
        return this;
    }

    private final void $$robo$$android_animation_AnimatorSet$setupStartValues() {
        for (Node node : this.mNodes) {
            node.animation.setupStartValues();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$setupEndValues() {
        for (Node node : this.mNodes) {
            node.animation.setupEndValues();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            if (this.mDelayAnim != null) {
                this.mDelayAnim.pause();
            } else {
                for (Node node : this.mNodes) {
                    node.animation.pause();
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$resume() {
        boolean previouslyPaused = this.mPaused;
        super.resume();
        if (previouslyPaused && !this.mPaused) {
            if (this.mDelayAnim != null) {
                this.mDelayAnim.resume();
            } else {
                for (Node node : this.mNodes) {
                    node.animation.resume();
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$start() {
        this.mTerminated = false;
        this.mStarted = true;
        this.mPaused = false;
        for (Node node : this.mNodes) {
            node.animation.setAllowRunningAsynchronously(false);
        }
        if (this.mDuration >= 0L) {
            for (Node node : this.mNodes) {
                node.animation.setDuration(this.mDuration);
            }
        }
        if (this.mInterpolator != null) {
            for (Node node : this.mNodes) {
                node.animation.setInterpolator(this.mInterpolator);
            }
        }
        this.sortNodes();
        int numSortedNodes = this.mSortedNodes.size();
        for (int i = 0; i < numSortedNodes; ++i) {
            Node node = this.mSortedNodes.get(i);
            ArrayList<Animator.AnimatorListener> oldListeners = node.animation.getListeners();
            if (oldListeners == null || oldListeners.size() <= 0) continue;
            ArrayList<Animator.AnimatorListener> clonedListeners = new ArrayList<Animator.AnimatorListener>(oldListeners);
            for (Animator.AnimatorListener listener : clonedListeners) {
                if (!(listener instanceof DependencyListener) && !(listener instanceof AnimatorSetListener)) continue;
                node.animation.removeListener(listener);
            }
        }
        ArrayList<Node> nodesToStart = new ArrayList<Node>();
        for (int i = 0; i < numSortedNodes; ++i) {
            Node node = this.mSortedNodes.get(i);
            if (this.mSetListener == null) {
                this.mSetListener = new AnimatorSetListener(this, this);
            }
            if (node.dependencies == null || node.dependencies.size() == 0) {
                nodesToStart.add(node);
            } else {
                int numDependencies = node.dependencies.size();
                for (int j = 0; j < numDependencies; ++j) {
                    Dependency dependency = node.dependencies.get(j);
                    dependency.node.animation.addListener(new DependencyListener(this, node, dependency.rule));
                }
                node.tmpDependencies = (ArrayList)node.dependencies.clone();
            }
            node.animation.addListener(this.mSetListener);
        }
        if (this.mStartDelay <= 0L) {
            for (Node node : nodesToStart) {
                node.animation.start();
                this.mPlayingSet.add(node.animation);
            }
        } else {
            this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mDelayAnim.setDuration(this.mStartDelay);
            this.mDelayAnim.addListener((Animator.AnimatorListener)new ShadowedObject(this, nodesToStart){
                public transient /* synthetic */ Object __robo_data__;
                boolean canceled;
                /* synthetic */ ArrayList val$nodesToStart;
                /* synthetic */ AnimatorSet this$0;

                private void $$robo$$android_animation_AnimatorSet_1$__constructor__(AnimatorSet animatorSet, ArrayList arrayList) {
                    this.canceled = false;
                }

                private final void $$robo$$android_animation_AnimatorSet_1$onAnimationCancel(Animator anim2) {
                    this.canceled = true;
                }

                private final void $$robo$$android_animation_AnimatorSet_1$onAnimationEnd(Animator anim2) {
                    if (!this.canceled) {
                        int numNodes = this.val$nodesToStart.size();
                        for (int i = 0; i < numNodes; ++i) {
                            Node node = (Node)this.val$nodesToStart.get(i);
                            node.animation.start();
                            this.this$0.mPlayingSet.add(node.animation);
                        }
                    }
                    this.this$0.mDelayAnim = null;
                }

                private void __constructor__(AnimatorSet animatorSet, ArrayList arrayList) {
                    this.$$robo$$android_animation_AnimatorSet_1$__constructor__(animatorSet, arrayList);
                }
                {
                    this.this$0 = animatorSet;
                    this.val$nodesToStart = arrayList;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_1$__constructor__(android.animation.AnimatorSet java.util.ArrayList ), 0, this, animatorSet, arrayList);
                }

                @Override
                public void onAnimationCancel(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_animation_AnimatorSet_1$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_AnimatorSet_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mDelayAnim.start();
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
            }
        }
        if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
            this.mStarted = false;
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                }
            }
        }
    }

    private final AnimatorSet $$robo$$android_animation_AnimatorSet$clone() {
        Object nodeClone;
        AnimatorSet anim2 = (AnimatorSet)super.clone();
        anim2.mNeedsSort = true;
        anim2.mTerminated = false;
        anim2.mStarted = false;
        anim2.mPlayingSet = new ArrayList();
        anim2.mNodeMap = new HashMap();
        anim2.mNodes = new ArrayList();
        anim2.mSortedNodes = new ArrayList();
        anim2.mReversible = this.mReversible;
        anim2.mSetListener = null;
        HashMap<Node, Object> nodeCloneMap = new HashMap<Node, Object>();
        for (Node node : this.mNodes) {
            nodeClone = node.clone();
            nodeCloneMap.put(node, nodeClone);
            anim2.mNodes.add((Node)nodeClone);
            anim2.mNodeMap.put(((Node)nodeClone).animation, (Node)nodeClone);
            ((Node)nodeClone).dependencies = null;
            ((Node)nodeClone).tmpDependencies = null;
            ((Node)nodeClone).nodeDependents = null;
            ((Node)nodeClone).nodeDependencies = null;
            ArrayList<Animator.AnimatorListener> cloneListeners = ((Node)nodeClone).animation.getListeners();
            if (cloneListeners == null) continue;
            ArrayList<Animator.AnimatorListener> listenersToRemove = null;
            for (Animator.AnimatorListener listener : cloneListeners) {
                if (!(listener instanceof AnimatorSetListener)) continue;
                if (listenersToRemove == null) {
                    listenersToRemove = new ArrayList<Animator.AnimatorListener>();
                }
                listenersToRemove.add(listener);
            }
            if (listenersToRemove == null) continue;
            for (Animator.AnimatorListener listener : listenersToRemove) {
                cloneListeners.remove(listener);
            }
        }
        for (Node node : this.mNodes) {
            nodeClone = (Node)nodeCloneMap.get(node);
            if (node.dependencies == null) continue;
            for (Dependency dependency : node.dependencies) {
                Node clonedDependencyNode = (Node)nodeCloneMap.get(dependency.node);
                Dependency cloneDependency = new Dependency(clonedDependencyNode, dependency.rule);
                ((Node)nodeClone).addDependency(cloneDependency);
            }
        }
        return anim2;
    }

    private final void $$robo$$android_animation_AnimatorSet$sortNodes() {
        if (this.mNeedsSort) {
            this.mSortedNodes.clear();
            ArrayList<Node> roots = new ArrayList<Node>();
            int numNodes = this.mNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() != 0) continue;
                roots.add(node);
            }
            ArrayList<Node> tmpRoots = new ArrayList<Node>();
            while (roots.size() > 0) {
                int numRoots = roots.size();
                for (int i = 0; i < numRoots; ++i) {
                    Node root = (Node)roots.get(i);
                    this.mSortedNodes.add(root);
                    if (root.nodeDependents == null) continue;
                    int numDependents = root.nodeDependents.size();
                    for (int j = 0; j < numDependents; ++j) {
                        Node node = root.nodeDependents.get(j);
                        node.nodeDependencies.remove(root);
                        if (node.nodeDependencies.size() != 0) continue;
                        tmpRoots.add(node);
                    }
                }
                roots.clear();
                roots.addAll(tmpRoots);
                tmpRoots.clear();
            }
            this.mNeedsSort = false;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
            }
        } else {
            int numNodes = this.mNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() > 0) {
                    int numDependencies = node.dependencies.size();
                    for (int j = 0; j < numDependencies; ++j) {
                        Dependency dependency = node.dependencies.get(j);
                        if (node.nodeDependencies == null) {
                            node.nodeDependencies = new ArrayList();
                        }
                        if (node.nodeDependencies.contains(dependency.node)) continue;
                        node.nodeDependencies.add(dependency.node);
                    }
                }
                node.done = false;
            }
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$canReverse() {
        if (!this.mReversible) {
            return false;
        }
        for (Node node : this.mNodes) {
            if (node.animation.canReverse() && node.animation.getStartDelay() <= 0L) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_animation_AnimatorSet$reverse() {
        if (this.canReverse()) {
            for (Node node : this.mNodes) {
                node.animation.reverse();
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_animation_AnimatorSet$__constructor__();
    }

    public AnimatorSet() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet$__constructor__(), 0, this);
    }

    public void playTogether(Animator ... animatorArray) {
        InvokeDynamicSupport.bootstrap("playTogether", $$robo$$android_animation_AnimatorSet$playTogether(android.animation.Animator[] ), 0, this, animatorArray);
    }

    public void playTogether(Collection<Animator> collection) {
        InvokeDynamicSupport.bootstrap("playTogether", $$robo$$android_animation_AnimatorSet$playTogether(java.util.Collection<android.animation.Animator> ), 0, this, collection);
    }

    public void playSequentially(Animator ... animatorArray) {
        InvokeDynamicSupport.bootstrap("playSequentially", $$robo$$android_animation_AnimatorSet$playSequentially(android.animation.Animator[] ), 0, this, animatorArray);
    }

    public void playSequentially(List<Animator> list) {
        InvokeDynamicSupport.bootstrap("playSequentially", $$robo$$android_animation_AnimatorSet$playSequentially(java.util.List<android.animation.Animator> ), 0, this, list);
    }

    public ArrayList<Animator> getChildAnimations() {
        return InvokeDynamicSupport.bootstrap("getChildAnimations", $$robo$$android_animation_AnimatorSet$getChildAnimations(), 0, this);
    }

    @Override
    public void setTarget(Object object) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_animation_AnimatorSet$setTarget(java.lang.Object ), 0, this, object);
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_animation_AnimatorSet$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_animation_AnimatorSet$getInterpolator(), 0, this);
    }

    public Builder play(Animator animator2) {
        return InvokeDynamicSupport.bootstrap("play", $$robo$$android_animation_AnimatorSet$play(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_AnimatorSet$cancel(), 0, this);
    }

    @Override
    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_animation_AnimatorSet$end(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_animation_AnimatorSet$isRunning(), 0, this);
    }

    @Override
    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_animation_AnimatorSet$isStarted(), 0, this);
    }

    @Override
    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_animation_AnimatorSet$getStartDelay(), 0, this);
    }

    @Override
    public void setStartDelay(long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_animation_AnimatorSet$setStartDelay(long ), 0, this, l);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_animation_AnimatorSet$getDuration(), 0, this);
    }

    @Override
    public AnimatorSet setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_AnimatorSet$setDuration(long ), 0, this, l);
    }

    @Override
    public void setupStartValues() {
        InvokeDynamicSupport.bootstrap("setupStartValues", $$robo$$android_animation_AnimatorSet$setupStartValues(), 0, this);
    }

    @Override
    public void setupEndValues() {
        InvokeDynamicSupport.bootstrap("setupEndValues", $$robo$$android_animation_AnimatorSet$setupEndValues(), 0, this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_animation_AnimatorSet$pause(), 0, this);
    }

    @Override
    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_animation_AnimatorSet$resume(), 0, this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_AnimatorSet$start(), 0, this);
    }

    @Override
    public AnimatorSet clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_AnimatorSet$clone(), 0, this);
    }

    private void sortNodes() {
        InvokeDynamicSupport.bootstrap("sortNodes", $$robo$$android_animation_AnimatorSet$sortNodes(), 0, this);
    }

    @Override
    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_animation_AnimatorSet$canReverse(), 0, this);
    }

    @Override
    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_animation_AnimatorSet$reverse(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatorSet)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Node mCurrentNode;
        /* synthetic */ AnimatorSet this$0;

        private void $$robo$$android_animation_AnimatorSet_Builder$__constructor__(AnimatorSet animatorSet, Animator anim2) {
            this.mCurrentNode = (Node)animatorSet.mNodeMap.get(anim2);
            if (this.mCurrentNode == null) {
                this.mCurrentNode = new Node(anim2);
                animatorSet.mNodeMap.put(anim2, this.mCurrentNode);
                animatorSet.mNodes.add(this.mCurrentNode);
            }
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$with(Animator anim2) {
            Node node = (Node)this.this$0.mNodeMap.get(anim2);
            if (node == null) {
                node = new Node(anim2);
                this.this$0.mNodeMap.put(anim2, node);
                this.this$0.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 0);
            node.addDependency(dependency);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$before(Animator anim2) {
            this.this$0.mReversible = false;
            Node node = (Node)this.this$0.mNodeMap.get(anim2);
            if (node == null) {
                node = new Node(anim2);
                this.this$0.mNodeMap.put(anim2, node);
                this.this$0.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 1);
            node.addDependency(dependency);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$after(Animator anim2) {
            this.this$0.mReversible = false;
            Node node = (Node)this.this$0.mNodeMap.get(anim2);
            if (node == null) {
                node = new Node(anim2);
                this.this$0.mNodeMap.put(anim2, node);
                this.this$0.mNodes.add(node);
            }
            Dependency dependency = new Dependency(node, 1);
            this.mCurrentNode.addDependency(dependency);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$after(long delay) {
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(delay);
            this.after(anim2);
            return this;
        }

        private void __constructor__(AnimatorSet animatorSet, Animator animator2) {
            this.$$robo$$android_animation_AnimatorSet_Builder$__constructor__(animatorSet, animator2);
        }

        Builder(AnimatorSet animatorSet, Animator animator2) {
            this.this$0 = animatorSet;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Builder$__constructor__(android.animation.AnimatorSet android.animation.Animator ), 0, this, animatorSet, animator2);
        }

        public Builder with(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("with", $$robo$$android_animation_AnimatorSet_Builder$with(android.animation.Animator ), 0, this, animator2);
        }

        public Builder before(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("before", $$robo$$android_animation_AnimatorSet_Builder$before(android.animation.Animator ), 0, this, animator2);
        }

        public Builder after(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("after", $$robo$$android_animation_AnimatorSet_Builder$after(android.animation.Animator ), 0, this, animator2);
        }

        public Builder after(long l) {
            return InvokeDynamicSupport.bootstrap("after", $$robo$$android_animation_AnimatorSet_Builder$after(long ), 0, this, l);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Node
    implements Cloneable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Animator animation;
        public ArrayList<Dependency> dependencies;
        public ArrayList<Dependency> tmpDependencies;
        public ArrayList<Node> nodeDependencies;
        public ArrayList<Node> nodeDependents;
        public boolean done;

        private void $$robo$$android_animation_AnimatorSet_Node$__constructor__(Animator animation) {
            this.dependencies = null;
            this.tmpDependencies = null;
            this.nodeDependencies = null;
            this.nodeDependents = null;
            this.done = false;
            this.animation = animation;
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addDependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
                this.nodeDependencies = new ArrayList();
            }
            this.dependencies.add(dependency);
            if (!this.nodeDependencies.contains(dependency.node)) {
                this.nodeDependencies.add(dependency.node);
            }
            Node dependencyNode = dependency.node;
            if (dependencyNode.nodeDependents == null) {
                dependencyNode.nodeDependents = new ArrayList();
            }
            dependencyNode.nodeDependents.add(this);
        }

        private final Node $$robo$$android_animation_AnimatorSet_Node$clone() {
            try {
                Node node = (Node)super.clone();
                node.animation = this.animation.clone();
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        private void __constructor__(Animator animator2) {
            this.$$robo$$android_animation_AnimatorSet_Node$__constructor__(animator2);
        }

        public Node(Animator animator2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Node$__constructor__(android.animation.Animator ), 0, this, animator2);
        }

        public void addDependency(Dependency dependency) {
            InvokeDynamicSupport.bootstrap("addDependency", $$robo$$android_animation_AnimatorSet_Node$addDependency(android.animation.AnimatorSet$Dependency ), 0, this, dependency);
        }

        public Node clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_AnimatorSet_Node$clone(), 0, this);
        }

        public /* synthetic */ Node() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Dependency
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int WITH = 0;
        static int AFTER = 1;
        public Node node;
        public int rule;

        private void $$robo$$android_animation_AnimatorSet_Dependency$__constructor__(Node node, int rule) {
            this.node = node;
            this.rule = rule;
        }

        private void __constructor__(Node node, int n) {
            this.$$robo$$android_animation_AnimatorSet_Dependency$__constructor__(node, n);
        }

        public Dependency(Node node, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Dependency$__constructor__(android.animation.AnimatorSet$Node int ), 0, this, node, n);
        }

        public /* synthetic */ Dependency() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Dependency)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AnimatorSetListener
    implements Animator.AnimatorListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AnimatorSet mAnimatorSet;
        /* synthetic */ AnimatorSet this$0;

        private void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$__constructor__(AnimatorSet animatorSet, AnimatorSet animatorSet2) {
            this.mAnimatorSet = animatorSet2;
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationCancel(Animator animation) {
            if (!this.this$0.mTerminated && this.this$0.mPlayingSet.size() == 0 && this.this$0.mListeners != null) {
                int numListeners = this.this$0.mListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)this.this$0.mListeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationEnd(Animator animation) {
            animation.removeListener(this);
            this.this$0.mPlayingSet.remove(animation);
            Node animNode = (Node)this.mAnimatorSet.mNodeMap.get(animation);
            animNode.done = true;
            if (!this.this$0.mTerminated) {
                ArrayList sortedNodes = this.mAnimatorSet.mSortedNodes;
                boolean allDone = true;
                int numSortedNodes = sortedNodes.size();
                for (int i = 0; i < numSortedNodes; ++i) {
                    if (((Node)sortedNodes.get((int)i)).done) continue;
                    allDone = false;
                    break;
                }
                if (allDone) {
                    if (this.this$0.mListeners != null) {
                        ArrayList tmpListeners = (ArrayList)this.this$0.mListeners.clone();
                        int numListeners = tmpListeners.size();
                        for (int i = 0; i < numListeners; ++i) {
                            ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this.mAnimatorSet);
                        }
                    }
                    this.mAnimatorSet.mStarted = false;
                    this.mAnimatorSet.mPaused = false;
                }
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationRepeat(Animator animation) {
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationStart(Animator animation) {
        }

        private void __constructor__(AnimatorSet animatorSet, AnimatorSet animatorSet2) {
            this.$$robo$$android_animation_AnimatorSet_AnimatorSetListener$__constructor__(animatorSet, animatorSet2);
        }

        AnimatorSetListener(AnimatorSet animatorSet, AnimatorSet animatorSet2) {
            this.this$0 = animatorSet;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$__constructor__(android.animation.AnimatorSet android.animation.AnimatorSet ), 0, this, animatorSet, animatorSet2);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        public /* synthetic */ AnimatorSetListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatorSetListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DependencyListener
    implements Animator.AnimatorListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AnimatorSet mAnimatorSet;
        private Node mNode;
        private int mRule;

        private void $$robo$$android_animation_AnimatorSet_DependencyListener$__constructor__(AnimatorSet animatorSet, Node node, int rule) {
            this.mAnimatorSet = animatorSet;
            this.mNode = node;
            this.mRule = rule;
        }

        private final void $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationCancel(Animator animation) {
        }

        private final void $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationEnd(Animator animation) {
            if (this.mRule == 1) {
                this.startIfReady(animation);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationRepeat(Animator animation) {
        }

        private final void $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationStart(Animator animation) {
            if (this.mRule == 0) {
                this.startIfReady(animation);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_DependencyListener$startIfReady(Animator dependencyAnimation) {
            if (this.mAnimatorSet.mTerminated) {
                return;
            }
            Dependency dependencyToRemove = null;
            int numDependencies = this.mNode.tmpDependencies.size();
            for (int i = 0; i < numDependencies; ++i) {
                Dependency dependency = this.mNode.tmpDependencies.get(i);
                if (dependency.rule != this.mRule || dependency.node.animation != dependencyAnimation) continue;
                dependencyToRemove = dependency;
                dependencyAnimation.removeListener(this);
                break;
            }
            this.mNode.tmpDependencies.remove(dependencyToRemove);
            if (this.mNode.tmpDependencies.size() == 0) {
                this.mNode.animation.start();
                this.mAnimatorSet.mPlayingSet.add(this.mNode.animation);
            }
        }

        private void __constructor__(AnimatorSet animatorSet, Node node, int n) {
            this.$$robo$$android_animation_AnimatorSet_DependencyListener$__constructor__(animatorSet, node, n);
        }

        public DependencyListener(AnimatorSet animatorSet, Node node, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_DependencyListener$__constructor__(android.animation.AnimatorSet android.animation.AnimatorSet$Node int ), 0, this, animatorSet, node, n);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_animation_AnimatorSet_DependencyListener$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        private void startIfReady(Animator animator2) {
            InvokeDynamicSupport.bootstrap("startIfReady", $$robo$$android_animation_AnimatorSet_DependencyListener$startIfReady(android.animation.Animator ), 0, this, animator2);
        }

        public /* synthetic */ DependencyListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DependencyListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

