/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.PropertyValuesHolder;
import android.animation.TypeConverter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.Property;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ObjectAnimator
extends ValueAnimator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ObjectAnimator";
    private static boolean DBG = false;
    private WeakReference<Object> mTarget;
    private String mPropertyName;
    private Property mProperty;
    private boolean mAutoCancel;

    private final void $$robo$$android_animation_ObjectAnimator$setPropertyName(String propertyName) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setPropertyName(propertyName);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(propertyName, valuesHolder);
        }
        this.mPropertyName = propertyName;
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ObjectAnimator$setProperty(Property property) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setProperty(property);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(this.mPropertyName, valuesHolder);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        this.mProperty = property;
        this.mInitialized = false;
    }

    private final String $$robo$$android_animation_ObjectAnimator$getPropertyName() {
        String propertyName = null;
        if (this.mPropertyName != null) {
            propertyName = this.mPropertyName;
        } else if (this.mProperty != null) {
            propertyName = this.mProperty.getName();
        } else if (this.mValues != null && this.mValues.length > 0) {
            for (int i = 0; i < this.mValues.length; ++i) {
                propertyName = i == 0 ? "" : propertyName + ",";
                propertyName = propertyName + this.mValues[i].getPropertyName();
            }
        }
        return propertyName;
    }

    private final String $$robo$$android_animation_ObjectAnimator$getNameForTrace() {
        return "animator:" + this.getPropertyName();
    }

    private void $$robo$$android_animation_ObjectAnimator$__constructor__() {
        this.mAutoCancel = false;
    }

    private void $$robo$$android_animation_ObjectAnimator$__constructor__(Object target, String propertyName) {
        this.mAutoCancel = false;
        this.setTarget(target);
        this.setPropertyName(propertyName);
    }

    private <T> void $$robo$$android_animation_ObjectAnimator$__constructor__(T target, Property<T, ?> property) {
        this.mAutoCancel = false;
        this.setTarget(target);
        this.setProperty(property);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofInt(Object target, String propertyName, int ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setIntValues(values);
        return anim2;
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofInt(Object target, String xPropertyName, String yPropertyName, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xPropertyName, (Keyframes)keyframes.createXIntKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yPropertyName, (Keyframes)keyframes.createYIntKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofInt(T target, Property<T, Integer> property, int ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, property);
        anim2.setIntValues(values);
        return anim2;
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofInt(T target, Property<T, Integer> xProperty, Property<T, Integer> yProperty, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xProperty, (Keyframes)keyframes.createXIntKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yProperty, (Keyframes)keyframes.createYIntKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofMultiInt(Object target, String propertyName, int[][] values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiInt(propertyName, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofMultiInt(Object target, String propertyName, Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiInt(propertyName, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofMultiInt(Object target, String propertyName, TypeConverter<T, int[]> converter, TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiInt(propertyName, converter, evaluator, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofArgb(Object target, String propertyName, int ... values) {
        ObjectAnimator animator2 = ObjectAnimator.ofInt(target, propertyName, values);
        animator2.setEvaluator(ArgbEvaluator.getInstance());
        return animator2;
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofArgb(T target, Property<T, Integer> property, int ... values) {
        ObjectAnimator animator2 = ObjectAnimator.ofInt(target, property, values);
        animator2.setEvaluator(ArgbEvaluator.getInstance());
        return animator2;
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofFloat(Object target, String propertyName, float ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setFloatValues(values);
        return anim2;
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofFloat(Object target, String xPropertyName, String yPropertyName, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xPropertyName, (Keyframes)keyframes.createXFloatKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yPropertyName, (Keyframes)keyframes.createYFloatKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofFloat(T target, Property<T, Float> property, float ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, property);
        anim2.setFloatValues(values);
        return anim2;
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofFloat(T target, Property<T, Float> xProperty, Property<T, Float> yProperty, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xProperty, (Keyframes)keyframes.createXFloatKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yProperty, (Keyframes)keyframes.createYFloatKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofMultiFloat(Object target, String propertyName, float[][] values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiFloat(propertyName, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofMultiFloat(Object target, String propertyName, Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiFloat(propertyName, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final <T> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofMultiFloat(Object target, String propertyName, TypeConverter<T, float[]> converter, TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiFloat(propertyName, converter, evaluator, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofObject(Object target, String propertyName, TypeEvaluator evaluator, Object ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofObject(Object target, String propertyName, TypeConverter<PointF, ?> converter, Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofObject(propertyName, converter, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final <T, V> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofObject(T target, Property<T, V> property, TypeEvaluator<V> evaluator, V ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, property);
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    private static final <T, V, P> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofObject(T target, Property<T, P> property, TypeConverter<V, P> converter, TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofObject(property, converter, evaluator, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final <T, V> ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofObject(T target, Property<T, V> property, TypeConverter<PointF, V> converter, Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofObject(property, converter, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    private static final ObjectAnimator $$robo$$android_animation_ObjectAnimator$ofPropertyValuesHolder(Object target, PropertyValuesHolder ... values) {
        ObjectAnimator anim2 = new ObjectAnimator();
        anim2.setTarget(target);
        anim2.setValues(values);
        return anim2;
    }

    private final void $$robo$$android_animation_ObjectAnimator$setIntValues(int ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofInt(this.mProperty, values));
            } else {
                this.setValues(PropertyValuesHolder.ofInt(this.mPropertyName, values));
            }
        } else {
            super.setIntValues(values);
        }
    }

    private final void $$robo$$android_animation_ObjectAnimator$setFloatValues(float ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofFloat(this.mProperty, values));
            } else {
                this.setValues(PropertyValuesHolder.ofFloat(this.mPropertyName, values));
            }
        } else {
            super.setFloatValues(values);
        }
    }

    private final void $$robo$$android_animation_ObjectAnimator$setObjectValues(Object ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofObject(this.mProperty, (TypeEvaluator)null, values));
            } else {
                this.setValues(PropertyValuesHolder.ofObject(this.mPropertyName, (TypeEvaluator)null, values));
            }
        } else {
            super.setObjectValues(values);
        }
    }

    private final void $$robo$$android_animation_ObjectAnimator$setAutoCancel(boolean cancel) {
        this.mAutoCancel = cancel;
    }

    private final boolean $$robo$$android_animation_ObjectAnimator$hasSameTargetAndProperties(Animator anim2) {
        if (anim2 instanceof ObjectAnimator) {
            PropertyValuesHolder[] theirValues = ((ObjectAnimator)anim2).getValues();
            if (((ObjectAnimator)anim2).getTarget() == this.getTarget() && this.mValues.length == theirValues.length) {
                for (int i = 0; i < this.mValues.length; ++i) {
                    PropertyValuesHolder pvhMine = this.mValues[i];
                    PropertyValuesHolder pvhTheirs = theirValues[i];
                    if (pvhMine.getPropertyName() != null && pvhMine.getPropertyName().equals(pvhTheirs.getPropertyName())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_animation_ObjectAnimator$start() {
        ValueAnimator.AnimationHandler handler = (ValueAnimator.AnimationHandler)sAnimationHandler.get();
        if (handler != null) {
            ObjectAnimator anim2;
            int i;
            int numAnims = handler.mAnimations.size();
            for (i = numAnims - 1; i >= 0; --i) {
                if (!(handler.mAnimations.get(i) instanceof ObjectAnimator)) continue;
                anim2 = (ObjectAnimator)handler.mAnimations.get(i);
                if (!anim2.mAutoCancel || !this.hasSameTargetAndProperties(anim2)) continue;
                anim2.cancel();
            }
            numAnims = handler.mPendingAnimations.size();
            for (i = numAnims - 1; i >= 0; --i) {
                if (!(handler.mPendingAnimations.get(i) instanceof ObjectAnimator)) continue;
                anim2 = (ObjectAnimator)handler.mPendingAnimations.get(i);
                if (!anim2.mAutoCancel || !this.hasSameTargetAndProperties(anim2)) continue;
                anim2.cancel();
            }
            numAnims = handler.mDelayedAnims.size();
            for (i = numAnims - 1; i >= 0; --i) {
                if (!(handler.mDelayedAnims.get(i) instanceof ObjectAnimator)) continue;
                anim2 = (ObjectAnimator)handler.mDelayedAnims.get(i);
                if (!anim2.mAutoCancel || !this.hasSameTargetAndProperties(anim2)) continue;
                anim2.cancel();
            }
        }
        super.start();
    }

    private final void $$robo$$android_animation_ObjectAnimator$initAnimation() {
        if (!this.mInitialized) {
            Object target = this.getTarget();
            if (target != null) {
                int numValues = this.mValues.length;
                for (int i = 0; i < numValues; ++i) {
                    this.mValues[i].setupSetterAndGetter(target);
                }
            }
            super.initAnimation();
        }
    }

    private final ObjectAnimator $$robo$$android_animation_ObjectAnimator$setDuration(long duration) {
        super.setDuration(duration);
        return this;
    }

    private final Object $$robo$$android_animation_ObjectAnimator$getTarget() {
        return this.mTarget == null ? null : this.mTarget.get();
    }

    private final void $$robo$$android_animation_ObjectAnimator$setTarget(Object target) {
        Object oldTarget = this.getTarget();
        if (oldTarget != target) {
            this.mTarget = target == null ? null : new WeakReference<Object>(target);
            this.mInitialized = false;
        }
    }

    private final void $$robo$$android_animation_ObjectAnimator$setupStartValues() {
        this.initAnimation();
        Object target = this.getTarget();
        if (target != null) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].setupStartValue(target);
            }
        }
    }

    private final void $$robo$$android_animation_ObjectAnimator$setupEndValues() {
        this.initAnimation();
        Object target = this.getTarget();
        if (target != null) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].setupEndValue(target);
            }
        }
    }

    private final void $$robo$$android_animation_ObjectAnimator$animateValue(float fraction2) {
        Object target = this.getTarget();
        if (this.mTarget != null && target == null) {
            this.cancel();
            return;
        }
        super.animateValue(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setAnimatedValue(target);
        }
    }

    private final ObjectAnimator $$robo$$android_animation_ObjectAnimator$clone() {
        ObjectAnimator anim2 = (ObjectAnimator)super.clone();
        return anim2;
    }

    private final String $$robo$$android_animation_ObjectAnimator$toString() {
        String returnVal = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.getTarget();
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }

    public void setPropertyName(String string2) {
        InvokeDynamicSupport.bootstrap("setPropertyName", $$robo$$android_animation_ObjectAnimator$setPropertyName(java.lang.String ), 0, this, string2);
    }

    public void setProperty(Property property) {
        InvokeDynamicSupport.bootstrap("setProperty", $$robo$$android_animation_ObjectAnimator$setProperty(android.util.Property ), 0, this, property);
    }

    public String getPropertyName() {
        return InvokeDynamicSupport.bootstrap("getPropertyName", $$robo$$android_animation_ObjectAnimator$getPropertyName(), 0, this);
    }

    @Override
    String getNameForTrace() {
        return InvokeDynamicSupport.bootstrap("getNameForTrace", $$robo$$android_animation_ObjectAnimator$getNameForTrace(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_animation_ObjectAnimator$__constructor__();
    }

    public ObjectAnimator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_ObjectAnimator$__constructor__(), 0, this);
    }

    private void __constructor__(Object object, String string2) {
        this.$$robo$$android_animation_ObjectAnimator$__constructor__(object, string2);
    }

    private ObjectAnimator(Object object, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_ObjectAnimator$__constructor__(java.lang.Object java.lang.String ), 0, this, object, string2);
    }

    private <T> void __constructor__(T t, Property<T, ?> property) {
        this.$$robo$$android_animation_ObjectAnimator$__constructor__(t, property);
    }

    private <T> ObjectAnimator(T t, Property<T, ?> property) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_ObjectAnimator$__constructor__(T android.util.Property<T, ?> ), 0, this, t, property);
    }

    public static ObjectAnimator ofInt(Object object, String string2, int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_ObjectAnimator$ofInt(java.lang.Object java.lang.String int[] ), 0, (Object)object, (String)string2, (int[])nArray);
    }

    public static ObjectAnimator ofInt(Object object, String string2, String string3, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_ObjectAnimator$ofInt(java.lang.Object java.lang.String java.lang.String android.graphics.Path ), 0, (Object)object, (String)string2, (String)string3, (Path)path);
    }

    public static <T> ObjectAnimator ofInt(T t, Property<T, Integer> property, int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_ObjectAnimator$ofInt(T android.util.Property<T, java.lang.Integer> int[] ), 0, t, property, (int[])nArray);
    }

    public static <T> ObjectAnimator ofInt(T t, Property<T, Integer> property, Property<T, Integer> property2, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_ObjectAnimator$ofInt(T android.util.Property<T, java.lang.Integer> android.util.Property<T, java.lang.Integer> android.graphics.Path ), 0, t, property, property2, (Path)path);
    }

    public static ObjectAnimator ofMultiInt(Object object, String string2, int[][] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_ObjectAnimator$ofMultiInt(java.lang.Object java.lang.String int[][] ), 0, (Object)object, (String)string2, (int[][])nArray);
    }

    public static ObjectAnimator ofMultiInt(Object object, String string2, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_ObjectAnimator$ofMultiInt(java.lang.Object java.lang.String android.graphics.Path ), 0, (Object)object, (String)string2, (Path)path);
    }

    public static <T> ObjectAnimator ofMultiInt(Object object, String string2, TypeConverter<T, int[]> typeConverter, TypeEvaluator<T> typeEvaluator, T ... TArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_ObjectAnimator$ofMultiInt(java.lang.Object java.lang.String android.animation.TypeConverter<T, int[]> android.animation.TypeEvaluator<T> T[] ), 0, (Object)object, (String)string2, typeConverter, typeEvaluator, (Object[])TArray);
    }

    public static ObjectAnimator ofArgb(Object object, String string2, int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofArgb", $$robo$$android_animation_ObjectAnimator$ofArgb(java.lang.Object java.lang.String int[] ), 0, (Object)object, (String)string2, (int[])nArray);
    }

    public static <T> ObjectAnimator ofArgb(T t, Property<T, Integer> property, int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofArgb", $$robo$$android_animation_ObjectAnimator$ofArgb(T android.util.Property<T, java.lang.Integer> int[] ), 0, t, property, (int[])nArray);
    }

    public static ObjectAnimator ofFloat(Object object, String string2, float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_ObjectAnimator$ofFloat(java.lang.Object java.lang.String float[] ), 0, (Object)object, (String)string2, (float[])fArray);
    }

    public static ObjectAnimator ofFloat(Object object, String string2, String string3, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_ObjectAnimator$ofFloat(java.lang.Object java.lang.String java.lang.String android.graphics.Path ), 0, (Object)object, (String)string2, (String)string3, (Path)path);
    }

    public static <T> ObjectAnimator ofFloat(T t, Property<T, Float> property, float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_ObjectAnimator$ofFloat(T android.util.Property<T, java.lang.Float> float[] ), 0, t, property, (float[])fArray);
    }

    public static <T> ObjectAnimator ofFloat(T t, Property<T, Float> property, Property<T, Float> property2, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_ObjectAnimator$ofFloat(T android.util.Property<T, java.lang.Float> android.util.Property<T, java.lang.Float> android.graphics.Path ), 0, t, property, property2, (Path)path);
    }

    public static ObjectAnimator ofMultiFloat(Object object, String string2, float[][] fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_ObjectAnimator$ofMultiFloat(java.lang.Object java.lang.String float[][] ), 0, (Object)object, (String)string2, (float[][])fArray);
    }

    public static ObjectAnimator ofMultiFloat(Object object, String string2, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_ObjectAnimator$ofMultiFloat(java.lang.Object java.lang.String android.graphics.Path ), 0, (Object)object, (String)string2, (Path)path);
    }

    public static <T> ObjectAnimator ofMultiFloat(Object object, String string2, TypeConverter<T, float[]> typeConverter, TypeEvaluator<T> typeEvaluator, T ... TArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_ObjectAnimator$ofMultiFloat(java.lang.Object java.lang.String android.animation.TypeConverter<T, float[]> android.animation.TypeEvaluator<T> T[] ), 0, (Object)object, (String)string2, typeConverter, typeEvaluator, (Object[])TArray);
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ObjectAnimator$ofObject(java.lang.Object java.lang.String android.animation.TypeEvaluator java.lang.Object[] ), 0, (Object)object, (String)string2, (TypeEvaluator)typeEvaluator, (Object[])objectArray);
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeConverter<PointF, ?> typeConverter, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ObjectAnimator$ofObject(java.lang.Object java.lang.String android.animation.TypeConverter<android.graphics.PointF, ?> android.graphics.Path ), 0, (Object)object, (String)string2, typeConverter, (Path)path);
    }

    public static <T, V> ObjectAnimator ofObject(T t, Property<T, V> property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ObjectAnimator$ofObject(T android.util.Property<T, V> android.animation.TypeEvaluator<V> V[] ), 0, t, property, typeEvaluator, (Object[])VArray);
    }

    public static <T, V, P> ObjectAnimator ofObject(T t, Property<T, P> property, TypeConverter<V, P> typeConverter, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ObjectAnimator$ofObject(T android.util.Property<T, P> android.animation.TypeConverter<V, P> android.animation.TypeEvaluator<V> V[] ), 0, t, property, typeConverter, typeEvaluator, (Object[])VArray);
    }

    public static <T, V> ObjectAnimator ofObject(T t, Property<T, V> property, TypeConverter<PointF, V> typeConverter, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ObjectAnimator$ofObject(T android.util.Property<T, V> android.animation.TypeConverter<android.graphics.PointF, V> android.graphics.Path ), 0, t, property, typeConverter, (Path)path);
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object object, PropertyValuesHolder ... propertyValuesHolderArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofPropertyValuesHolder", $$robo$$android_animation_ObjectAnimator$ofPropertyValuesHolder(java.lang.Object android.animation.PropertyValuesHolder[] ), 0, (Object)object, (PropertyValuesHolder[])propertyValuesHolderArray);
    }

    @Override
    public void setIntValues(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setIntValues", $$robo$$android_animation_ObjectAnimator$setIntValues(int[] ), 0, this, nArray);
    }

    @Override
    public void setFloatValues(float ... fArray) {
        InvokeDynamicSupport.bootstrap("setFloatValues", $$robo$$android_animation_ObjectAnimator$setFloatValues(float[] ), 0, this, fArray);
    }

    @Override
    public void setObjectValues(Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("setObjectValues", $$robo$$android_animation_ObjectAnimator$setObjectValues(java.lang.Object[] ), 0, this, objectArray);
    }

    public void setAutoCancel(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoCancel", $$robo$$android_animation_ObjectAnimator$setAutoCancel(boolean ), 0, this, bl);
    }

    private boolean hasSameTargetAndProperties(Animator animator2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameTargetAndProperties", $$robo$$android_animation_ObjectAnimator$hasSameTargetAndProperties(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_ObjectAnimator$start(), 0, this);
    }

    @Override
    void initAnimation() {
        InvokeDynamicSupport.bootstrap("initAnimation", $$robo$$android_animation_ObjectAnimator$initAnimation(), 0, this);
    }

    @Override
    public ObjectAnimator setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_ObjectAnimator$setDuration(long ), 0, this, l);
    }

    public Object getTarget() {
        return InvokeDynamicSupport.bootstrap("getTarget", $$robo$$android_animation_ObjectAnimator$getTarget(), 0, this);
    }

    @Override
    public void setTarget(Object object) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_animation_ObjectAnimator$setTarget(java.lang.Object ), 0, this, object);
    }

    @Override
    public void setupStartValues() {
        InvokeDynamicSupport.bootstrap("setupStartValues", $$robo$$android_animation_ObjectAnimator$setupStartValues(), 0, this);
    }

    @Override
    public void setupEndValues() {
        InvokeDynamicSupport.bootstrap("setupEndValues", $$robo$$android_animation_ObjectAnimator$setupEndValues(), 0, this);
    }

    @Override
    void animateValue(float f) {
        InvokeDynamicSupport.bootstrap("animateValue", $$robo$$android_animation_ObjectAnimator$animateValue(float ), 0, this, f);
    }

    @Override
    public ObjectAnimator clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_ObjectAnimator$clone(), 0, this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_ObjectAnimator$toString(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ObjectAnimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

