/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.BidirectionalTypeConverter;
import android.animation.FloatArrayEvaluator;
import android.animation.FloatEvaluator;
import android.animation.IntArrayEvaluator;
import android.animation.IntEvaluator;
import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.TypeConverter;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.FloatProperty;
import android.util.IntProperty;
import android.util.Log;
import android.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PropertyValuesHolder
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    String mPropertyName;
    protected Property mProperty;
    Method mSetter;
    private Method mGetter;
    Class mValueType;
    Keyframes mKeyframes;
    private static TypeEvaluator sIntEvaluator;
    private static TypeEvaluator sFloatEvaluator;
    private static Class[] FLOAT_VARIANTS;
    private static Class[] INTEGER_VARIANTS;
    private static Class[] DOUBLE_VARIANTS;
    private static HashMap<Class, HashMap<String, Method>> sSetterPropertyMap;
    private static HashMap<Class, HashMap<String, Method>> sGetterPropertyMap;
    ReentrantReadWriteLock mPropertyMapLock;
    Object[] mTmpValueArray;
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;
    private TypeConverter mConverter;

    private void $$robo$$android_animation_PropertyValuesHolder$__constructor__(String propertyName) {
        this.mSetter = null;
        this.mGetter = null;
        this.mKeyframes = null;
        this.mPropertyMapLock = new ReentrantReadWriteLock();
        this.mTmpValueArray = new Object[1];
        this.mPropertyName = propertyName;
    }

    private void $$robo$$android_animation_PropertyValuesHolder$__constructor__(Property property) {
        this.mSetter = null;
        this.mGetter = null;
        this.mKeyframes = null;
        this.mPropertyMapLock = new ReentrantReadWriteLock();
        this.mTmpValueArray = new Object[1];
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofInt(String propertyName, int ... values) {
        return new IntPropertyValuesHolder(propertyName, values);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofInt(Property<?, Integer> property, int ... values) {
        return new IntPropertyValuesHolder(property, values);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(String propertyName, int[][] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int numParameters = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int length = values[i].length;
            if (i == 0) {
                numParameters = length;
                continue;
            }
            if (length == numParameters) continue;
            throw new IllegalArgumentException("Values must all have the same length");
        }
        IntArrayEvaluator evaluator = new IntArrayEvaluator(new int[numParameters]);
        return new MultiIntValuesHolder(propertyName, null, (TypeEvaluator)evaluator, (Object[])values);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(String propertyName, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PointFToIntArray converter = new PointFToIntArray();
        return new MultiIntValuesHolder(propertyName, (TypeConverter)converter, null, keyframes);
    }

    private static final <V> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(String propertyName, TypeConverter<V, int[]> converter, TypeEvaluator<V> evaluator, V ... values) {
        return new MultiIntValuesHolder(propertyName, converter, evaluator, values);
    }

    private static final <T> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(String propertyName, TypeConverter<T, int[]> converter, TypeEvaluator<T> evaluator, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return new MultiIntValuesHolder(propertyName, converter, evaluator, keyframeSet);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofFloat(String propertyName, float ... values) {
        return new FloatPropertyValuesHolder(propertyName, values);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofFloat(Property<?, Float> property, float ... values) {
        return new FloatPropertyValuesHolder(property, values);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(String propertyName, float[][] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int numParameters = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int length = values[i].length;
            if (i == 0) {
                numParameters = length;
                continue;
            }
            if (length == numParameters) continue;
            throw new IllegalArgumentException("Values must all have the same length");
        }
        FloatArrayEvaluator evaluator = new FloatArrayEvaluator(new float[numParameters]);
        return new MultiFloatValuesHolder(propertyName, null, (TypeEvaluator)evaluator, (Object[])values);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(String propertyName, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PointFToFloatArray converter = new PointFToFloatArray();
        return new MultiFloatValuesHolder(propertyName, (TypeConverter)converter, null, keyframes);
    }

    private static final <V> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(String propertyName, TypeConverter<V, float[]> converter, TypeEvaluator<V> evaluator, V ... values) {
        return new MultiFloatValuesHolder(propertyName, converter, evaluator, values);
    }

    private static final <T> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(String propertyName, TypeConverter<T, float[]> converter, TypeEvaluator<T> evaluator, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return new MultiFloatValuesHolder(propertyName, converter, evaluator, keyframeSet);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofObject(String propertyName, TypeEvaluator evaluator, Object ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofObject(String propertyName, TypeConverter<PointF, ?> converter, Path path) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframes = KeyframeSet.ofPath(path);
        pvh.mValueType = PointF.class;
        pvh.setConverter(converter);
        return pvh;
    }

    private static final <V> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofObject(Property property, TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    private static final <T, V> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofObject(Property<?, V> property, TypeConverter<T, V> converter, TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setConverter(converter);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    private static final <V> PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofObject(Property<?, V> property, TypeConverter<PointF, V> converter, Path path) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframes = KeyframeSet.ofPath(path);
        pvh.mValueType = PointF.class;
        pvh.setConverter(converter);
        return pvh;
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofKeyframe(String propertyName, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return PropertyValuesHolder.ofKeyframes(propertyName, (Keyframes)keyframeSet);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofKeyframe(Property property, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return PropertyValuesHolder.ofKeyframes(property, (Keyframes)keyframeSet);
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofKeyframes(String propertyName, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(propertyName, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(propertyName, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframes = keyframes;
        pvh.mValueType = keyframes.getType();
        return pvh;
    }

    private static final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$ofKeyframes(Property property, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(property, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(property, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframes = keyframes;
        pvh.mValueType = keyframes.getType();
        return pvh;
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setIntValues(int ... values) {
        this.mValueType = Integer.TYPE;
        this.mKeyframes = KeyframeSet.ofInt(values);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setFloatValues(float ... values) {
        this.mValueType = Float.TYPE;
        this.mKeyframes = KeyframeSet.ofFloat(values);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setKeyframes(Keyframe ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe[Math.max(numKeyframes, 2)];
        this.mValueType = values[0].getType();
        for (int i = 0; i < numKeyframes; ++i) {
            keyframes[i] = values[i];
        }
        this.mKeyframes = new KeyframeSet(keyframes);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setObjectValues(Object ... values) {
        this.mValueType = values[0].getClass();
        this.mKeyframes = KeyframeSet.ofObject(values);
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setConverter(TypeConverter converter) {
        this.mConverter = converter;
    }

    private final Method $$robo$$android_animation_PropertyValuesHolder$getPropertyFunction(Class targetClass, String prefix, Class valueType) {
        Method returnVal = null;
        String methodName = PropertyValuesHolder.getMethodName(prefix, this.mPropertyName);
        Class[] args = null;
        if (valueType == null) {
            try {
                returnVal = targetClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            args = new Class[1];
            Class[] typeVariants = valueType.equals(Float.class) ? FLOAT_VARIANTS : (valueType.equals(Integer.class) ? INTEGER_VARIANTS : (valueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{valueType}));
            Class[] arr$ = typeVariants;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class typeVariant;
                args[0] = typeVariant = arr$[i$];
                try {
                    returnVal = targetClass.getMethod(methodName, args);
                    if (this.mConverter == null) {
                        this.mValueType = typeVariant;
                    }
                    return returnVal;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        if (returnVal == null) {
            Log.w("PropertyValuesHolder", "Method " + PropertyValuesHolder.getMethodName(prefix, this.mPropertyName) + "() with type " + valueType + " not found on target class " + targetClass);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Method $$robo$$android_animation_PropertyValuesHolder$setupSetterOrGetter(Class targetClass, HashMap<Class, HashMap<String, Method>> propertyMapMap, String prefix, Class valueType) {
        Method setterOrGetter = null;
        try {
            this.mPropertyMapLock.writeLock().lock();
            HashMap<String, Method> propertyMap = propertyMapMap.get(targetClass);
            if (propertyMap != null) {
                setterOrGetter = propertyMap.get(this.mPropertyName);
            }
            if (setterOrGetter == null) {
                setterOrGetter = this.getPropertyFunction(targetClass, prefix, valueType);
                if (propertyMap == null) {
                    propertyMap = new HashMap();
                    propertyMapMap.put(targetClass, propertyMap);
                }
                propertyMap.put(this.mPropertyName, setterOrGetter);
            }
        }
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
        return setterOrGetter;
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setupSetter(Class targetClass) {
        Class propertyType = this.mConverter == null ? this.mValueType : this.mConverter.getTargetType();
        this.mSetter = this.setupSetterOrGetter(targetClass, sSetterPropertyMap, "set", propertyType);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setupGetter(Class targetClass) {
        this.mGetter = this.setupSetterOrGetter(targetClass, sGetterPropertyMap, "get", null);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setupSetterAndGetter(Object target) {
        ArrayList<Keyframe> keyframes;
        this.mKeyframes.invalidateCache();
        if (this.mProperty != null) {
            try {
                Object testValue = null;
                ArrayList<Keyframe> keyframes2 = this.mKeyframes.getKeyframes();
                int keyframeCount = keyframes2 == null ? 0 : keyframes2.size();
                for (int i = 0; i < keyframeCount; ++i) {
                    Keyframe kf = keyframes2.get(i);
                    if (kf.hasValue() && !kf.valueWasSetOnStart()) continue;
                    if (testValue == null) {
                        testValue = this.convertBack(this.mProperty.get(target));
                    }
                    kf.setValue(testValue);
                    kf.setValueWasSetOnStart(true);
                }
                return;
            }
            catch (ClassCastException e) {
                Log.w("PropertyValuesHolder", "No such property (" + this.mProperty.getName() + ") on target object " + target + ". Trying reflection instead");
                this.mProperty = null;
            }
        }
        Class<?> targetClass = target.getClass();
        if (this.mSetter == null) {
            this.setupSetter(targetClass);
        }
        int keyframeCount = (keyframes = this.mKeyframes.getKeyframes()) == null ? 0 : keyframes.size();
        for (int i = 0; i < keyframeCount; ++i) {
            Keyframe kf = keyframes.get(i);
            if (kf.hasValue() && !kf.valueWasSetOnStart()) continue;
            if (this.mGetter == null) {
                this.setupGetter(targetClass);
                if (this.mGetter == null) {
                    return;
                }
            }
            try {
                Object value = this.convertBack(this.mGetter.invoke(target, new Object[0]));
                kf.setValue(value);
                kf.setValueWasSetOnStart(true);
                continue;
            }
            catch (InvocationTargetException e) {
                Log.e("PropertyValuesHolder", e.toString());
                continue;
            }
            catch (IllegalAccessException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
        }
    }

    private final Object $$robo$$android_animation_PropertyValuesHolder$convertBack(Object value) {
        if (this.mConverter != null) {
            if (!(this.mConverter instanceof BidirectionalTypeConverter)) {
                throw new IllegalArgumentException("Converter " + this.mConverter.getClass().getName() + " must be a BidirectionalTypeConverter");
            }
            value = ((BidirectionalTypeConverter)this.mConverter).convertBack(value);
        }
        return value;
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setupValue(Object target, Keyframe kf) {
        Object value;
        if (this.mProperty != null) {
            value = this.convertBack(this.mProperty.get(target));
            kf.setValue(value);
        }
        try {
            if (this.mGetter == null) {
                Class<?> targetClass = target.getClass();
                this.setupGetter(targetClass);
                if (this.mGetter == null) {
                    return;
                }
            }
            value = this.convertBack(this.mGetter.invoke(target, new Object[0]));
            kf.setValue(value);
        }
        catch (InvocationTargetException e) {
            Log.e("PropertyValuesHolder", e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e("PropertyValuesHolder", e.toString());
        }
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setupStartValue(Object target) {
        ArrayList<Keyframe> keyframes = this.mKeyframes.getKeyframes();
        if (!keyframes.isEmpty()) {
            this.setupValue(target, keyframes.get(0));
        }
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setupEndValue(Object target) {
        ArrayList<Keyframe> keyframes = this.mKeyframes.getKeyframes();
        if (!keyframes.isEmpty()) {
            this.setupValue(target, keyframes.get(keyframes.size() - 1));
        }
    }

    private final PropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder$clone() {
        try {
            PropertyValuesHolder newPVH = (PropertyValuesHolder)super.clone();
            newPVH.mPropertyName = this.mPropertyName;
            newPVH.mProperty = this.mProperty;
            newPVH.mKeyframes = this.mKeyframes.clone();
            newPVH.mEvaluator = this.mEvaluator;
            return newPVH;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setAnimatedValue(Object target) {
        if (this.mProperty != null) {
            this.mProperty.set(target, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(target, this.mTmpValueArray);
            }
            catch (InvocationTargetException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
        }
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mEvaluator = this.mValueType == Float.class ? sFloatEvaluator : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
        this.mKeyframes.setEvaluator(evaluator);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$calculateValue(float fraction2) {
        Object value = this.mKeyframes.getValue(fraction2);
        this.mAnimatedValue = this.mConverter == null ? value : this.mConverter.convert(value);
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setPropertyName(String propertyName) {
        this.mPropertyName = propertyName;
    }

    private final void $$robo$$android_animation_PropertyValuesHolder$setProperty(Property property) {
        this.mProperty = property;
    }

    private final String $$robo$$android_animation_PropertyValuesHolder$getPropertyName() {
        return this.mPropertyName;
    }

    private final Object $$robo$$android_animation_PropertyValuesHolder$getAnimatedValue() {
        return this.mAnimatedValue;
    }

    private final String $$robo$$android_animation_PropertyValuesHolder$toString() {
        return this.mPropertyName + ": " + this.mKeyframes.toString();
    }

    private static final String $$robo$$android_animation_PropertyValuesHolder$getMethodName(String prefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String theRest = propertyName.substring(1);
        return prefix + firstLetter + theRest;
    }

    private static final long $$robo$$android_animation_PropertyValuesHolder$nGetIntMethod(Class clazz, String string2) {
        return 0L;
    }

    private static final long $$robo$$android_animation_PropertyValuesHolder$nGetFloatMethod(Class clazz, String string2) {
        return 0L;
    }

    private static final long $$robo$$android_animation_PropertyValuesHolder$nGetMultipleIntMethod(Class clazz, String string2, int n) {
        return 0L;
    }

    private static final long $$robo$$android_animation_PropertyValuesHolder$nGetMultipleFloatMethod(Class clazz, String string2, int n) {
        return 0L;
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallIntMethod(Object object, long l, int n) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallFloatMethod(Object object, long l, float f) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallTwoIntMethod(Object object, long l, int n, int n2) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallFourIntMethod(Object object, long l, int n, int n2, int n3, int n4) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallMultipleIntMethod(Object object, long l, int[] nArray) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallTwoFloatMethod(Object object, long l, float f, float f2) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallFourFloatMethod(Object object, long l, float f, float f2, float f3, float f4) {
    }

    private static final void $$robo$$android_animation_PropertyValuesHolder$nCallMultipleFloatMethod(Object object, long l, float[] fArray) {
    }

    private /* synthetic */ void $$robo$$android_animation_PropertyValuesHolder$__constructor__(String x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_animation_PropertyValuesHolder$__constructor__(Property x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sIntEvaluator = new IntEvaluator();
        sFloatEvaluator = new FloatEvaluator();
        FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
        INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
        DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
        sSetterPropertyMap = new HashMap();
        sGetterPropertyMap = new HashMap();
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_animation_PropertyValuesHolder$__constructor__(string2);
    }

    private PropertyValuesHolder(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(Property property) {
        this.$$robo$$android_animation_PropertyValuesHolder$__constructor__(property);
    }

    private PropertyValuesHolder(Property property) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder$__constructor__(android.util.Property ), 0, this, property);
    }

    public static PropertyValuesHolder ofInt(String string2, int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_PropertyValuesHolder$ofInt(java.lang.String int[] ), 0, (String)string2, (int[])nArray);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_PropertyValuesHolder$ofInt(android.util.Property<?, java.lang.Integer> int[] ), 0, property, (int[])nArray);
    }

    public static PropertyValuesHolder ofMultiInt(String string2, int[][] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(java.lang.String int[][] ), 0, (String)string2, (int[][])nArray);
    }

    public static PropertyValuesHolder ofMultiInt(String string2, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(java.lang.String android.graphics.Path ), 0, (String)string2, (Path)path);
    }

    public static <V> PropertyValuesHolder ofMultiInt(String string2, TypeConverter<V, int[]> typeConverter, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(java.lang.String android.animation.TypeConverter<V, int[]> android.animation.TypeEvaluator<V> V[] ), 0, (String)string2, typeConverter, typeEvaluator, (Object[])VArray);
    }

    public static <T> PropertyValuesHolder ofMultiInt(String string2, TypeConverter<T, int[]> typeConverter, TypeEvaluator<T> typeEvaluator, Keyframe ... keyframeArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiInt", $$robo$$android_animation_PropertyValuesHolder$ofMultiInt(java.lang.String android.animation.TypeConverter<T, int[]> android.animation.TypeEvaluator<T> android.animation.Keyframe[] ), 0, (String)string2, typeConverter, typeEvaluator, (Keyframe[])keyframeArray);
    }

    public static PropertyValuesHolder ofFloat(String string2, float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_PropertyValuesHolder$ofFloat(java.lang.String float[] ), 0, (String)string2, (float[])fArray);
    }

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_PropertyValuesHolder$ofFloat(android.util.Property<?, java.lang.Float> float[] ), 0, property, (float[])fArray);
    }

    public static PropertyValuesHolder ofMultiFloat(String string2, float[][] fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(java.lang.String float[][] ), 0, (String)string2, (float[][])fArray);
    }

    public static PropertyValuesHolder ofMultiFloat(String string2, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(java.lang.String android.graphics.Path ), 0, (String)string2, (Path)path);
    }

    public static <V> PropertyValuesHolder ofMultiFloat(String string2, TypeConverter<V, float[]> typeConverter, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(java.lang.String android.animation.TypeConverter<V, float[]> android.animation.TypeEvaluator<V> V[] ), 0, (String)string2, typeConverter, typeEvaluator, (Object[])VArray);
    }

    public static <T> PropertyValuesHolder ofMultiFloat(String string2, TypeConverter<T, float[]> typeConverter, TypeEvaluator<T> typeEvaluator, Keyframe ... keyframeArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofMultiFloat", $$robo$$android_animation_PropertyValuesHolder$ofMultiFloat(java.lang.String android.animation.TypeConverter<T, float[]> android.animation.TypeEvaluator<T> android.animation.Keyframe[] ), 0, (String)string2, typeConverter, typeEvaluator, (Keyframe[])keyframeArray);
    }

    public static PropertyValuesHolder ofObject(String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_PropertyValuesHolder$ofObject(java.lang.String android.animation.TypeEvaluator java.lang.Object[] ), 0, (String)string2, (TypeEvaluator)typeEvaluator, (Object[])objectArray);
    }

    public static PropertyValuesHolder ofObject(String string2, TypeConverter<PointF, ?> typeConverter, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_PropertyValuesHolder$ofObject(java.lang.String android.animation.TypeConverter<android.graphics.PointF, ?> android.graphics.Path ), 0, (String)string2, typeConverter, (Path)path);
    }

    public static <V> PropertyValuesHolder ofObject(Property property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_PropertyValuesHolder$ofObject(android.util.Property android.animation.TypeEvaluator<V> V[] ), 0, (Property)property, typeEvaluator, (Object[])VArray);
    }

    public static <T, V> PropertyValuesHolder ofObject(Property<?, V> property, TypeConverter<T, V> typeConverter, TypeEvaluator<T> typeEvaluator, T ... TArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_PropertyValuesHolder$ofObject(android.util.Property<?, V> android.animation.TypeConverter<T, V> android.animation.TypeEvaluator<T> T[] ), 0, property, typeConverter, typeEvaluator, (Object[])TArray);
    }

    public static <V> PropertyValuesHolder ofObject(Property<?, V> property, TypeConverter<PointF, V> typeConverter, Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_PropertyValuesHolder$ofObject(android.util.Property<?, V> android.animation.TypeConverter<android.graphics.PointF, V> android.graphics.Path ), 0, property, typeConverter, (Path)path);
    }

    public static PropertyValuesHolder ofKeyframe(String string2, Keyframe ... keyframeArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofKeyframe", $$robo$$android_animation_PropertyValuesHolder$ofKeyframe(java.lang.String android.animation.Keyframe[] ), 0, (String)string2, (Keyframe[])keyframeArray);
    }

    public static PropertyValuesHolder ofKeyframe(Property property, Keyframe ... keyframeArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofKeyframe", $$robo$$android_animation_PropertyValuesHolder$ofKeyframe(android.util.Property android.animation.Keyframe[] ), 0, (Property)property, (Keyframe[])keyframeArray);
    }

    static PropertyValuesHolder ofKeyframes(String string2, Keyframes keyframes) {
        return InvokeDynamicSupport.bootstrapStatic("ofKeyframes", $$robo$$android_animation_PropertyValuesHolder$ofKeyframes(java.lang.String android.animation.Keyframes ), 0, (String)string2, (Keyframes)keyframes);
    }

    static PropertyValuesHolder ofKeyframes(Property property, Keyframes keyframes) {
        return InvokeDynamicSupport.bootstrapStatic("ofKeyframes", $$robo$$android_animation_PropertyValuesHolder$ofKeyframes(android.util.Property android.animation.Keyframes ), 0, (Property)property, (Keyframes)keyframes);
    }

    public void setIntValues(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setIntValues", $$robo$$android_animation_PropertyValuesHolder$setIntValues(int[] ), 0, this, nArray);
    }

    public void setFloatValues(float ... fArray) {
        InvokeDynamicSupport.bootstrap("setFloatValues", $$robo$$android_animation_PropertyValuesHolder$setFloatValues(float[] ), 0, this, fArray);
    }

    public void setKeyframes(Keyframe ... keyframeArray) {
        InvokeDynamicSupport.bootstrap("setKeyframes", $$robo$$android_animation_PropertyValuesHolder$setKeyframes(android.animation.Keyframe[] ), 0, this, keyframeArray);
    }

    public void setObjectValues(Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("setObjectValues", $$robo$$android_animation_PropertyValuesHolder$setObjectValues(java.lang.Object[] ), 0, this, objectArray);
    }

    public void setConverter(TypeConverter typeConverter) {
        InvokeDynamicSupport.bootstrap("setConverter", $$robo$$android_animation_PropertyValuesHolder$setConverter(android.animation.TypeConverter ), 0, this, typeConverter);
    }

    private Method getPropertyFunction(Class clazz, String string2, Class clazz2) {
        return InvokeDynamicSupport.bootstrap("getPropertyFunction", $$robo$$android_animation_PropertyValuesHolder$getPropertyFunction(java.lang.Class java.lang.String java.lang.Class ), 0, this, clazz, string2, clazz2);
    }

    private Method setupSetterOrGetter(Class clazz, HashMap<Class, HashMap<String, Method>> hashMap, String string2, Class clazz2) {
        return InvokeDynamicSupport.bootstrap("setupSetterOrGetter", $$robo$$android_animation_PropertyValuesHolder$setupSetterOrGetter(java.lang.Class java.util.HashMap<java.lang.Class, java.util.HashMap<java.lang.String, java.lang.reflect.Method>> java.lang.String java.lang.Class ), 0, this, clazz, hashMap, string2, clazz2);
    }

    void setupSetter(Class clazz) {
        InvokeDynamicSupport.bootstrap("setupSetter", $$robo$$android_animation_PropertyValuesHolder$setupSetter(java.lang.Class ), 0, this, clazz);
    }

    private void setupGetter(Class clazz) {
        InvokeDynamicSupport.bootstrap("setupGetter", $$robo$$android_animation_PropertyValuesHolder$setupGetter(java.lang.Class ), 0, this, clazz);
    }

    void setupSetterAndGetter(Object object) {
        InvokeDynamicSupport.bootstrap("setupSetterAndGetter", $$robo$$android_animation_PropertyValuesHolder$setupSetterAndGetter(java.lang.Object ), 0, this, object);
    }

    private Object convertBack(Object object) {
        return InvokeDynamicSupport.bootstrap("convertBack", $$robo$$android_animation_PropertyValuesHolder$convertBack(java.lang.Object ), 0, this, object);
    }

    private void setupValue(Object object, Keyframe keyframe) {
        InvokeDynamicSupport.bootstrap("setupValue", $$robo$$android_animation_PropertyValuesHolder$setupValue(java.lang.Object android.animation.Keyframe ), 0, this, object, keyframe);
    }

    void setupStartValue(Object object) {
        InvokeDynamicSupport.bootstrap("setupStartValue", $$robo$$android_animation_PropertyValuesHolder$setupStartValue(java.lang.Object ), 0, this, object);
    }

    void setupEndValue(Object object) {
        InvokeDynamicSupport.bootstrap("setupEndValue", $$robo$$android_animation_PropertyValuesHolder$setupEndValue(java.lang.Object ), 0, this, object);
    }

    public PropertyValuesHolder clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_PropertyValuesHolder$clone(), 0, this);
    }

    void setAnimatedValue(Object object) {
        InvokeDynamicSupport.bootstrap("setAnimatedValue", $$robo$$android_animation_PropertyValuesHolder$setAnimatedValue(java.lang.Object ), 0, this, object);
    }

    void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_animation_PropertyValuesHolder$init(), 0, this);
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        InvokeDynamicSupport.bootstrap("setEvaluator", $$robo$$android_animation_PropertyValuesHolder$setEvaluator(android.animation.TypeEvaluator ), 0, this, typeEvaluator);
    }

    void calculateValue(float f) {
        InvokeDynamicSupport.bootstrap("calculateValue", $$robo$$android_animation_PropertyValuesHolder$calculateValue(float ), 0, this, f);
    }

    public void setPropertyName(String string2) {
        InvokeDynamicSupport.bootstrap("setPropertyName", $$robo$$android_animation_PropertyValuesHolder$setPropertyName(java.lang.String ), 0, this, string2);
    }

    public void setProperty(Property property) {
        InvokeDynamicSupport.bootstrap("setProperty", $$robo$$android_animation_PropertyValuesHolder$setProperty(android.util.Property ), 0, this, property);
    }

    public String getPropertyName() {
        return InvokeDynamicSupport.bootstrap("getPropertyName", $$robo$$android_animation_PropertyValuesHolder$getPropertyName(), 0, this);
    }

    Object getAnimatedValue() {
        return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_PropertyValuesHolder$getAnimatedValue(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_PropertyValuesHolder$toString(), 0, this);
    }

    static String getMethodName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getMethodName", $$robo$$android_animation_PropertyValuesHolder$getMethodName(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ long $$robo$$nGetIntMethod$nativeBinding(Class var0, String var1);

    private static long nGetIntMethod(Class clazz, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetIntMethod", $$robo$$android_animation_PropertyValuesHolder$nGetIntMethod(java.lang.Class java.lang.String ), 1, (Class)clazz, (String)string2);
    }

    private static final native /* synthetic */ long $$robo$$nGetFloatMethod$nativeBinding(Class var0, String var1);

    private static long nGetFloatMethod(Class clazz, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetFloatMethod", $$robo$$android_animation_PropertyValuesHolder$nGetFloatMethod(java.lang.Class java.lang.String ), 1, (Class)clazz, (String)string2);
    }

    private static final native /* synthetic */ long $$robo$$nGetMultipleIntMethod$nativeBinding(Class var0, String var1, int var2);

    private static long nGetMultipleIntMethod(Class clazz, String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetMultipleIntMethod", $$robo$$android_animation_PropertyValuesHolder$nGetMultipleIntMethod(java.lang.Class java.lang.String int ), 1, (Class)clazz, (String)string2, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nGetMultipleFloatMethod$nativeBinding(Class var0, String var1, int var2);

    private static long nGetMultipleFloatMethod(Class clazz, String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetMultipleFloatMethod", $$robo$$android_animation_PropertyValuesHolder$nGetMultipleFloatMethod(java.lang.Class java.lang.String int ), 1, (Class)clazz, (String)string2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nCallIntMethod$nativeBinding(Object var0, long var1, int var3);

    private static void nCallIntMethod(Object object, long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nCallIntMethod", $$robo$$android_animation_PropertyValuesHolder$nCallIntMethod(java.lang.Object long int ), 1, (Object)object, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nCallFloatMethod$nativeBinding(Object var0, long var1, float var3);

    private static void nCallFloatMethod(Object object, long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nCallFloatMethod", $$robo$$android_animation_PropertyValuesHolder$nCallFloatMethod(java.lang.Object long float ), 1, (Object)object, (long)l, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$nCallTwoIntMethod$nativeBinding(Object var0, long var1, int var3, int var4);

    private static void nCallTwoIntMethod(Object object, long l, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nCallTwoIntMethod", $$robo$$android_animation_PropertyValuesHolder$nCallTwoIntMethod(java.lang.Object long int int ), 1, (Object)object, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$nCallFourIntMethod$nativeBinding(Object var0, long var1, int var3, int var4, int var5, int var6);

    private static void nCallFourIntMethod(Object object, long l, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrapStatic("nCallFourIntMethod", $$robo$$android_animation_PropertyValuesHolder$nCallFourIntMethod(java.lang.Object long int int int int ), 1, (Object)object, (long)l, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private static final native /* synthetic */ void $$robo$$nCallMultipleIntMethod$nativeBinding(Object var0, long var1, int[] var3);

    private static void nCallMultipleIntMethod(Object object, long l, int[] nArray) {
        InvokeDynamicSupport.bootstrapStatic("nCallMultipleIntMethod", $$robo$$android_animation_PropertyValuesHolder$nCallMultipleIntMethod(java.lang.Object long int[] ), 1, (Object)object, (long)l, (int[])nArray);
    }

    private static final native /* synthetic */ void $$robo$$nCallTwoFloatMethod$nativeBinding(Object var0, long var1, float var3, float var4);

    private static void nCallTwoFloatMethod(Object object, long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nCallTwoFloatMethod", $$robo$$android_animation_PropertyValuesHolder$nCallTwoFloatMethod(java.lang.Object long float float ), 1, (Object)object, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$nCallFourFloatMethod$nativeBinding(Object var0, long var1, float var3, float var4, float var5, float var6);

    private static void nCallFourFloatMethod(Object object, long l, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrapStatic("nCallFourFloatMethod", $$robo$$android_animation_PropertyValuesHolder$nCallFourFloatMethod(java.lang.Object long float float float float ), 1, (Object)object, (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    private static final native /* synthetic */ void $$robo$$nCallMultipleFloatMethod$nativeBinding(Object var0, long var1, float[] var3);

    private static void nCallMultipleFloatMethod(Object object, long l, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("nCallMultipleFloatMethod", $$robo$$android_animation_PropertyValuesHolder$nCallMultipleFloatMethod(java.lang.Object long float[] ), 1, (Object)object, (long)l, (float[])fArray);
    }

    private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
        this.$$robo$$android_animation_PropertyValuesHolder$__constructor__(string2, var2_2);
    }

    private /* synthetic */ void __constructor__(Property property, 1 var2_2) {
        this.$$robo$$android_animation_PropertyValuesHolder$__constructor__(property, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PropertyValuesHolder.class);
    }

    public /* synthetic */ PropertyValuesHolder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PropertyValuesHolder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PointFToIntArray
    extends TypeConverter<PointF, int[]> {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mCoordinates;

        private void $$robo$$android_animation_PropertyValuesHolder_PointFToIntArray$__constructor__() {
            this.mCoordinates = new int[2];
        }

        private final int[] $$robo$$android_animation_PropertyValuesHolder_PointFToIntArray$convert(PointF value) {
            this.mCoordinates[0] = Math.round(value.x);
            this.mCoordinates[1] = Math.round(value.y);
            return this.mCoordinates;
        }

        private void __constructor__() {
            this.$$robo$$android_animation_PropertyValuesHolder_PointFToIntArray$__constructor__();
        }

        public PointFToIntArray() {
            super(PointF.class, int[].class);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_PointFToIntArray$__constructor__(), 0, this);
        }

        @Override
        public int[] convert(PointF pointF) {
            return InvokeDynamicSupport.bootstrap("convert", $$robo$$android_animation_PropertyValuesHolder_PointFToIntArray$convert(android.graphics.PointF ), 0, this, pointF);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointFToIntArray)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PointFToFloatArray
    extends TypeConverter<PointF, float[]> {
        public transient /* synthetic */ Object __robo_data__;
        private float[] mCoordinates;

        private void $$robo$$android_animation_PropertyValuesHolder_PointFToFloatArray$__constructor__() {
            this.mCoordinates = new float[2];
        }

        private final float[] $$robo$$android_animation_PropertyValuesHolder_PointFToFloatArray$convert(PointF value) {
            this.mCoordinates[0] = value.x;
            this.mCoordinates[1] = value.y;
            return this.mCoordinates;
        }

        private void __constructor__() {
            this.$$robo$$android_animation_PropertyValuesHolder_PointFToFloatArray$__constructor__();
        }

        public PointFToFloatArray() {
            super(PointF.class, float[].class);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_PointFToFloatArray$__constructor__(), 0, this);
        }

        @Override
        public float[] convert(PointF pointF) {
            return InvokeDynamicSupport.bootstrap("convert", $$robo$$android_animation_PropertyValuesHolder_PointFToFloatArray$convert(android.graphics.PointF ), 0, this, pointF);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointFToFloatArray)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MultiIntValuesHolder
    extends PropertyValuesHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mJniSetter;
        private static HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap;

        private void $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$__constructor__(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Object ... values) {
            this.setConverter(converter);
            this.setObjectValues(values);
            this.setEvaluator(evaluator);
        }

        private void $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$__constructor__(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Keyframes keyframes) {
            this.setConverter(converter);
            this.mKeyframes = keyframes;
            this.setEvaluator(evaluator);
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$setAnimatedValue(Object target) {
            int[] values = (int[])this.getAnimatedValue();
            int numParameters = values.length;
            if (this.mJniSetter != 0L) {
                switch (numParameters) {
                    case 1: {
                        PropertyValuesHolder.nCallIntMethod(target, this.mJniSetter, values[0]);
                        break;
                    }
                    case 2: {
                        PropertyValuesHolder.nCallTwoIntMethod(target, this.mJniSetter, values[0], values[1]);
                        break;
                    }
                    case 4: {
                        PropertyValuesHolder.nCallFourIntMethod(target, this.mJniSetter, values[0], values[1], values[2], values[3]);
                        break;
                    }
                    default: {
                        PropertyValuesHolder.nCallMultipleIntMethod(target, this.mJniSetter, values);
                    }
                }
            }
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$setupSetterAndGetter(Object target) {
            this.setupSetter(target.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$setupSetter(Class targetClass) {
            block9: {
                if (this.mJniSetter != 0L) {
                    return;
                }
                try {
                    Long jniSetterLong;
                    this.mPropertyMapLock.writeLock().lock();
                    HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                    if (propertyMap != null && (jniSetterLong = propertyMap.get(this.mPropertyName)) != null) {
                        this.mJniSetter = jniSetterLong;
                    }
                    if (this.mJniSetter != 0L) break block9;
                    String methodName = MultiIntValuesHolder.getMethodName("set", this.mPropertyName);
                    this.calculateValue(0.0f);
                    int[] values = (int[])this.getAnimatedValue();
                    int numParams = values.length;
                    try {
                        this.mJniSetter = PropertyValuesHolder.nGetMultipleIntMethod(targetClass, methodName, numParams);
                    }
                    catch (NoSuchMethodError e) {
                        this.mJniSetter = PropertyValuesHolder.nGetMultipleIntMethod(targetClass, this.mPropertyName, numParams);
                    }
                    if (this.mJniSetter != 0L) {
                        if (propertyMap == null) {
                            propertyMap = new HashMap();
                            sJNISetterPropertyMap.put(targetClass, propertyMap);
                        }
                        propertyMap.put(this.mPropertyName, this.mJniSetter);
                    }
                }
                finally {
                    this.mPropertyMapLock.writeLock().unlock();
                }
            }
        }

        static void __staticInitializer__() {
            sJNISetterPropertyMap = new HashMap();
        }

        private void __constructor__(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Object ... objectArray) {
            this.$$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$__constructor__(string2, typeConverter, typeEvaluator, objectArray);
        }

        public MultiIntValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Object ... objectArray) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$__constructor__(java.lang.String android.animation.TypeConverter android.animation.TypeEvaluator java.lang.Object[] ), 0, this, string2, typeConverter, typeEvaluator, objectArray);
        }

        private void __constructor__(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Keyframes keyframes) {
            this.$$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$__constructor__(string2, typeConverter, typeEvaluator, keyframes);
        }

        public MultiIntValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Keyframes keyframes) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$__constructor__(java.lang.String android.animation.TypeConverter android.animation.TypeEvaluator android.animation.Keyframes ), 0, this, string2, typeConverter, typeEvaluator, keyframes);
        }

        @Override
        void setAnimatedValue(Object object) {
            InvokeDynamicSupport.bootstrap("setAnimatedValue", $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$setAnimatedValue(java.lang.Object ), 0, this, object);
        }

        @Override
        void setupSetterAndGetter(Object object) {
            InvokeDynamicSupport.bootstrap("setupSetterAndGetter", $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$setupSetterAndGetter(java.lang.Object ), 0, this, object);
        }

        @Override
        void setupSetter(Class clazz) {
            InvokeDynamicSupport.bootstrap("setupSetter", $$robo$$android_animation_PropertyValuesHolder_MultiIntValuesHolder$setupSetter(java.lang.Class ), 0, this, clazz);
        }

        static {
            RobolectricInternals.classInitializing(MultiIntValuesHolder.class);
        }

        public /* synthetic */ MultiIntValuesHolder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultiIntValuesHolder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MultiFloatValuesHolder
    extends PropertyValuesHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mJniSetter;
        private static HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap;

        private void $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$__constructor__(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Object ... values) {
            this.setConverter(converter);
            this.setObjectValues(values);
            this.setEvaluator(evaluator);
        }

        private void $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$__constructor__(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Keyframes keyframes) {
            this.setConverter(converter);
            this.mKeyframes = keyframes;
            this.setEvaluator(evaluator);
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$setAnimatedValue(Object target) {
            float[] values = (float[])this.getAnimatedValue();
            int numParameters = values.length;
            if (this.mJniSetter != 0L) {
                switch (numParameters) {
                    case 1: {
                        PropertyValuesHolder.nCallFloatMethod(target, this.mJniSetter, values[0]);
                        break;
                    }
                    case 2: {
                        PropertyValuesHolder.nCallTwoFloatMethod(target, this.mJniSetter, values[0], values[1]);
                        break;
                    }
                    case 4: {
                        PropertyValuesHolder.nCallFourFloatMethod(target, this.mJniSetter, values[0], values[1], values[2], values[3]);
                        break;
                    }
                    default: {
                        PropertyValuesHolder.nCallMultipleFloatMethod(target, this.mJniSetter, values);
                    }
                }
            }
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$setupSetterAndGetter(Object target) {
            this.setupSetter(target.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$setupSetter(Class targetClass) {
            block9: {
                if (this.mJniSetter != 0L) {
                    return;
                }
                try {
                    Long jniSetterLong;
                    this.mPropertyMapLock.writeLock().lock();
                    HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                    if (propertyMap != null && (jniSetterLong = propertyMap.get(this.mPropertyName)) != null) {
                        this.mJniSetter = jniSetterLong;
                    }
                    if (this.mJniSetter != 0L) break block9;
                    String methodName = MultiFloatValuesHolder.getMethodName("set", this.mPropertyName);
                    this.calculateValue(0.0f);
                    float[] values = (float[])this.getAnimatedValue();
                    int numParams = values.length;
                    try {
                        this.mJniSetter = PropertyValuesHolder.nGetMultipleFloatMethod(targetClass, methodName, numParams);
                    }
                    catch (NoSuchMethodError e) {
                        this.mJniSetter = PropertyValuesHolder.nGetMultipleFloatMethod(targetClass, this.mPropertyName, numParams);
                    }
                    if (this.mJniSetter != 0L) {
                        if (propertyMap == null) {
                            propertyMap = new HashMap();
                            sJNISetterPropertyMap.put(targetClass, propertyMap);
                        }
                        propertyMap.put(this.mPropertyName, this.mJniSetter);
                    }
                }
                finally {
                    this.mPropertyMapLock.writeLock().unlock();
                }
            }
        }

        static void __staticInitializer__() {
            sJNISetterPropertyMap = new HashMap();
        }

        private void __constructor__(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Object ... objectArray) {
            this.$$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$__constructor__(string2, typeConverter, typeEvaluator, objectArray);
        }

        public MultiFloatValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Object ... objectArray) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$__constructor__(java.lang.String android.animation.TypeConverter android.animation.TypeEvaluator java.lang.Object[] ), 0, this, string2, typeConverter, typeEvaluator, objectArray);
        }

        private void __constructor__(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Keyframes keyframes) {
            this.$$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$__constructor__(string2, typeConverter, typeEvaluator, keyframes);
        }

        public MultiFloatValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Keyframes keyframes) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$__constructor__(java.lang.String android.animation.TypeConverter android.animation.TypeEvaluator android.animation.Keyframes ), 0, this, string2, typeConverter, typeEvaluator, keyframes);
        }

        @Override
        void setAnimatedValue(Object object) {
            InvokeDynamicSupport.bootstrap("setAnimatedValue", $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$setAnimatedValue(java.lang.Object ), 0, this, object);
        }

        @Override
        void setupSetterAndGetter(Object object) {
            InvokeDynamicSupport.bootstrap("setupSetterAndGetter", $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$setupSetterAndGetter(java.lang.Object ), 0, this, object);
        }

        @Override
        void setupSetter(Class clazz) {
            InvokeDynamicSupport.bootstrap("setupSetter", $$robo$$android_animation_PropertyValuesHolder_MultiFloatValuesHolder$setupSetter(java.lang.Class ), 0, this, clazz);
        }

        static {
            RobolectricInternals.classInitializing(MultiFloatValuesHolder.class);
        }

        public /* synthetic */ MultiFloatValuesHolder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultiFloatValuesHolder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FloatPropertyValuesHolder
    extends PropertyValuesHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap;
        long mJniSetter;
        private FloatProperty mFloatProperty;
        Keyframes.FloatKeyframes mFloatKeyframes;
        float mFloatAnimatedValue;

        private void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(String propertyName, Keyframes.FloatKeyframes keyframes) {
            this.mValueType = Float.TYPE;
            this.mKeyframes = keyframes;
            this.mFloatKeyframes = keyframes;
        }

        private void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(Property property, Keyframes.FloatKeyframes keyframes) {
            this.mValueType = Float.TYPE;
            this.mKeyframes = keyframes;
            this.mFloatKeyframes = keyframes;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        private void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(String propertyName, float ... values) {
            this.setFloatValues(values);
        }

        private void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(Property property, float ... values) {
            this.setFloatValues(values);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$setFloatValues(float ... values) {
            super.setFloatValues(values);
            this.mFloatKeyframes = (Keyframes.FloatKeyframes)this.mKeyframes;
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$calculateValue(float fraction2) {
            this.mFloatAnimatedValue = this.mFloatKeyframes.getFloatValue(fraction2);
        }

        private final Object $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        private final FloatPropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$clone() {
            FloatPropertyValuesHolder newPVH = (FloatPropertyValuesHolder)super.clone();
            newPVH.mFloatKeyframes = (Keyframes.FloatKeyframes)newPVH.mKeyframes;
            return newPVH;
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$setAnimatedValue(Object target) {
            if (this.mFloatProperty != null) {
                this.mFloatProperty.setValue(target, this.mFloatAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, Float.valueOf(this.mFloatAnimatedValue));
                return;
            }
            if (this.mJniSetter != 0L) {
                PropertyValuesHolder.nCallFloatMethod(target, this.mJniSetter, this.mFloatAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$setupSetter(Class targetClass) {
            if (this.mProperty != null) {
                return;
            }
            try {
                Long jniSetter;
                this.mPropertyMapLock.writeLock().lock();
                HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                if (propertyMap != null && (jniSetter = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = jniSetter;
                }
                if (this.mJniSetter == 0L) {
                    String methodName = FloatPropertyValuesHolder.getMethodName("set", this.mPropertyName);
                    this.mJniSetter = PropertyValuesHolder.nGetFloatMethod(targetClass, methodName);
                    if (this.mJniSetter != 0L) {
                        if (propertyMap == null) {
                            propertyMap = new HashMap();
                            sJNISetterPropertyMap.put(targetClass, propertyMap);
                        }
                        propertyMap.put(this.mPropertyName, this.mJniSetter);
                    }
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            finally {
                this.mPropertyMapLock.writeLock().unlock();
            }
            if (this.mJniSetter == 0L) {
                super.setupSetter(targetClass);
            }
        }

        static void __staticInitializer__() {
            sJNISetterPropertyMap = new HashMap();
        }

        private void __constructor__(String string2, Keyframes.FloatKeyframes floatKeyframes) {
            this.$$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(string2, floatKeyframes);
        }

        public FloatPropertyValuesHolder(String string2, Keyframes.FloatKeyframes floatKeyframes) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(java.lang.String android.animation.Keyframes$FloatKeyframes ), 0, this, string2, floatKeyframes);
        }

        private void __constructor__(Property property, Keyframes.FloatKeyframes floatKeyframes) {
            this.$$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(property, floatKeyframes);
        }

        public FloatPropertyValuesHolder(Property property, Keyframes.FloatKeyframes floatKeyframes) {
            super(property);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(android.util.Property android.animation.Keyframes$FloatKeyframes ), 0, this, property, floatKeyframes);
        }

        private void __constructor__(String string2, float ... fArray) {
            this.$$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(string2, fArray);
        }

        public FloatPropertyValuesHolder(String string2, float ... fArray) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(java.lang.String float[] ), 0, this, string2, fArray);
        }

        private void __constructor__(Property property, float ... fArray) {
            this.$$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(property, fArray);
        }

        public FloatPropertyValuesHolder(Property property, float ... fArray) {
            super(property);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$__constructor__(android.util.Property float[] ), 0, this, property, fArray);
        }

        @Override
        public void setFloatValues(float ... fArray) {
            InvokeDynamicSupport.bootstrap("setFloatValues", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$setFloatValues(float[] ), 0, this, fArray);
        }

        @Override
        void calculateValue(float f) {
            InvokeDynamicSupport.bootstrap("calculateValue", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$calculateValue(float ), 0, this, f);
        }

        @Override
        Object getAnimatedValue() {
            return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$getAnimatedValue(), 0, this);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$clone(), 0, this);
        }

        @Override
        void setAnimatedValue(Object object) {
            InvokeDynamicSupport.bootstrap("setAnimatedValue", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$setAnimatedValue(java.lang.Object ), 0, this, object);
        }

        @Override
        void setupSetter(Class clazz) {
            InvokeDynamicSupport.bootstrap("setupSetter", $$robo$$android_animation_PropertyValuesHolder_FloatPropertyValuesHolder$setupSetter(java.lang.Class ), 0, this, clazz);
        }

        static {
            RobolectricInternals.classInitializing(FloatPropertyValuesHolder.class);
        }

        public /* synthetic */ FloatPropertyValuesHolder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FloatPropertyValuesHolder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IntPropertyValuesHolder
    extends PropertyValuesHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap;
        long mJniSetter;
        private IntProperty mIntProperty;
        Keyframes.IntKeyframes mIntKeyframes;
        int mIntAnimatedValue;

        private void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(String propertyName, Keyframes.IntKeyframes keyframes) {
            this.mValueType = Integer.TYPE;
            this.mKeyframes = keyframes;
            this.mIntKeyframes = keyframes;
        }

        private void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(Property property, Keyframes.IntKeyframes keyframes) {
            this.mValueType = Integer.TYPE;
            this.mKeyframes = keyframes;
            this.mIntKeyframes = keyframes;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        private void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(String propertyName, int ... values) {
            this.setIntValues(values);
        }

        private void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(Property property, int ... values) {
            this.setIntValues(values);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$setIntValues(int ... values) {
            super.setIntValues(values);
            this.mIntKeyframes = (Keyframes.IntKeyframes)this.mKeyframes;
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$calculateValue(float fraction2) {
            this.mIntAnimatedValue = this.mIntKeyframes.getIntValue(fraction2);
        }

        private final Object $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        private final IntPropertyValuesHolder $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$clone() {
            IntPropertyValuesHolder newPVH = (IntPropertyValuesHolder)super.clone();
            newPVH.mIntKeyframes = (Keyframes.IntKeyframes)newPVH.mKeyframes;
            return newPVH;
        }

        private final void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$setAnimatedValue(Object target) {
            if (this.mIntProperty != null) {
                this.mIntProperty.setValue(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mJniSetter != 0L) {
                PropertyValuesHolder.nCallIntMethod(target, this.mJniSetter, this.mIntAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = this.mIntAnimatedValue;
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$setupSetter(Class targetClass) {
            if (this.mProperty != null) {
                return;
            }
            try {
                Long jniSetter;
                this.mPropertyMapLock.writeLock().lock();
                HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                if (propertyMap != null && (jniSetter = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = jniSetter;
                }
                if (this.mJniSetter == 0L) {
                    String methodName = IntPropertyValuesHolder.getMethodName("set", this.mPropertyName);
                    this.mJniSetter = PropertyValuesHolder.nGetIntMethod(targetClass, methodName);
                    if (this.mJniSetter != 0L) {
                        if (propertyMap == null) {
                            propertyMap = new HashMap();
                            sJNISetterPropertyMap.put(targetClass, propertyMap);
                        }
                        propertyMap.put(this.mPropertyName, this.mJniSetter);
                    }
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            finally {
                this.mPropertyMapLock.writeLock().unlock();
            }
            if (this.mJniSetter == 0L) {
                super.setupSetter(targetClass);
            }
        }

        static void __staticInitializer__() {
            sJNISetterPropertyMap = new HashMap();
        }

        private void __constructor__(String string2, Keyframes.IntKeyframes intKeyframes) {
            this.$$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(string2, intKeyframes);
        }

        public IntPropertyValuesHolder(String string2, Keyframes.IntKeyframes intKeyframes) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(java.lang.String android.animation.Keyframes$IntKeyframes ), 0, this, string2, intKeyframes);
        }

        private void __constructor__(Property property, Keyframes.IntKeyframes intKeyframes) {
            this.$$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(property, intKeyframes);
        }

        public IntPropertyValuesHolder(Property property, Keyframes.IntKeyframes intKeyframes) {
            super(property);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(android.util.Property android.animation.Keyframes$IntKeyframes ), 0, this, property, intKeyframes);
        }

        private void __constructor__(String string2, int ... nArray) {
            this.$$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(string2, nArray);
        }

        public IntPropertyValuesHolder(String string2, int ... nArray) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(java.lang.String int[] ), 0, this, string2, nArray);
        }

        private void __constructor__(Property property, int ... nArray) {
            this.$$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(property, nArray);
        }

        public IntPropertyValuesHolder(Property property, int ... nArray) {
            super(property);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$__constructor__(android.util.Property int[] ), 0, this, property, nArray);
        }

        @Override
        public void setIntValues(int ... nArray) {
            InvokeDynamicSupport.bootstrap("setIntValues", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$setIntValues(int[] ), 0, this, nArray);
        }

        @Override
        void calculateValue(float f) {
            InvokeDynamicSupport.bootstrap("calculateValue", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$calculateValue(float ), 0, this, f);
        }

        @Override
        Object getAnimatedValue() {
            return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$getAnimatedValue(), 0, this);
        }

        @Override
        public IntPropertyValuesHolder clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$clone(), 0, this);
        }

        @Override
        void setAnimatedValue(Object object) {
            InvokeDynamicSupport.bootstrap("setAnimatedValue", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$setAnimatedValue(java.lang.Object ), 0, this, object);
        }

        @Override
        void setupSetter(Class clazz) {
            InvokeDynamicSupport.bootstrap("setupSetter", $$robo$$android_animation_PropertyValuesHolder_IntPropertyValuesHolder$setupSetter(java.lang.Class ), 0, this, clazz);
        }

        static {
            RobolectricInternals.classInitializing(IntPropertyValuesHolder.class);
        }

        public /* synthetic */ IntPropertyValuesHolder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntPropertyValuesHolder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

