/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.os.Looper;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.view.Choreographer;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ValueAnimator
extends Animator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float sDurationScale;
    static int STOPPED = 0;
    static int RUNNING = 1;
    static int SEEKED = 2;
    long mStartTime;
    long mSeekTime;
    private long mPauseTime;
    private boolean mResumed;
    protected static ThreadLocal<AnimationHandler> sAnimationHandler;
    private static TimeInterpolator sDefaultInterpolator;
    private boolean mPlayingBackwards;
    private int mCurrentIteration;
    private float mCurrentFraction;
    private boolean mStartedDelay;
    private long mDelayStartTime;
    int mPlayingState;
    private boolean mRunning;
    private boolean mStarted;
    private boolean mStartListenersCalled;
    boolean mInitialized;
    private long mDuration;
    private long mUnscaledDuration;
    private long mStartDelay;
    private long mUnscaledStartDelay;
    private int mRepeatCount;
    private int mRepeatMode;
    private TimeInterpolator mInterpolator;
    ArrayList<AnimatorUpdateListener> mUpdateListeners;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static int RESTART = 1;
    public static int REVERSE = 2;
    public static int INFINITE = -1;

    private static final void $$robo$$android_animation_ValueAnimator$setDurationScale(float durationScale) {
        sDurationScale = durationScale;
    }

    private static final float $$robo$$android_animation_ValueAnimator$getDurationScale() {
        return sDurationScale;
    }

    private void $$robo$$android_animation_ValueAnimator$__constructor__() {
        this.mSeekTime = -1L;
        this.mResumed = false;
        this.mPlayingBackwards = false;
        this.mCurrentIteration = 0;
        this.mCurrentFraction = 0.0f;
        this.mStartedDelay = false;
        this.mPlayingState = 0;
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mInitialized = false;
        this.mDuration = (long)(300.0f * sDurationScale);
        this.mUnscaledDuration = 300L;
        this.mStartDelay = 0L;
        this.mUnscaledStartDelay = 0L;
        this.mRepeatCount = 0;
        this.mRepeatMode = 1;
        this.mInterpolator = sDefaultInterpolator;
        this.mUpdateListeners = null;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofInt(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofArgb(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        anim2.setEvaluator(ArgbEvaluator.getInstance());
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofFloat(float ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setFloatValues(values);
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setValues(values);
        return anim2;
    }

    private static final ValueAnimator $$robo$$android_animation_ValueAnimator$ofObject(TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    private final void $$robo$$android_animation_ValueAnimator$setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    private final void $$robo$$android_animation_ValueAnimator$setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        for (int i = 0; i < numValues; ++i) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
        }
        this.mInitialized = false;
    }

    private final PropertyValuesHolder[] $$robo$$android_animation_ValueAnimator$getValues() {
        return this.mValues;
    }

    private final void $$robo$$android_animation_ValueAnimator$initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    private final ValueAnimator $$robo$$android_animation_ValueAnimator$setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mUnscaledDuration = duration;
        this.updateScaledDuration();
        return this;
    }

    private final void $$robo$$android_animation_ValueAnimator$updateScaledDuration() {
        this.mDuration = (long)((float)this.mUnscaledDuration * sDurationScale);
    }

    private final long $$robo$$android_animation_ValueAnimator$getDuration() {
        return this.mUnscaledDuration;
    }

    private final void $$robo$$android_animation_ValueAnimator$setCurrentPlayTime(long playTime) {
        this.initAnimation();
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = playTime;
            this.mPlayingState = 2;
        }
        this.mStartTime = currentTime - playTime;
        this.doAnimationFrame(currentTime);
    }

    private final long $$robo$$android_animation_ValueAnimator$getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    private final long $$robo$$android_animation_ValueAnimator$getStartDelay() {
        return this.mUnscaledStartDelay;
    }

    private final void $$robo$$android_animation_ValueAnimator$setStartDelay(long startDelay) {
        this.mStartDelay = (long)((float)startDelay * sDurationScale);
        this.mUnscaledStartDelay = startDelay;
    }

    private static final long $$robo$$android_animation_ValueAnimator$getFrameDelay() {
        return Choreographer.getFrameDelay();
    }

    private static final void $$robo$$android_animation_ValueAnimator$setFrameDelay(long frameDelay) {
        Choreographer.setFrameDelay(frameDelay);
    }

    private final Object $$robo$$android_animation_ValueAnimator$getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    private final Object $$robo$$android_animation_ValueAnimator$getAnimatedValue(String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    private final void $$robo$$android_animation_ValueAnimator$setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    private final int $$robo$$android_animation_ValueAnimator$getRepeatCount() {
        return this.mRepeatCount;
    }

    private final void $$robo$$android_animation_ValueAnimator$setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    private final int $$robo$$android_animation_ValueAnimator$getRepeatMode() {
        return this.mRepeatMode;
    }

    private final void $$robo$$android_animation_ValueAnimator$addUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    private final void $$robo$$android_animation_ValueAnimator$removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    private final void $$robo$$android_animation_ValueAnimator$removeUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$setInterpolator(TimeInterpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    private final TimeInterpolator $$robo$$android_animation_ValueAnimator$getInterpolator() {
        return this.mInterpolator;
    }

    private final void $$robo$$android_animation_ValueAnimator$setEvaluator(TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
            }
        }
        this.mStartListenersCalled = true;
    }

    private final void $$robo$$android_animation_ValueAnimator$start(boolean playBackwards) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = playBackwards;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        this.mPaused = false;
        this.updateScaledDuration();
        AnimationHandler animationHandler = ValueAnimator.getOrCreateAnimationHandler();
        animationHandler.mPendingAnimations.add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(0L);
            this.mPlayingState = 0;
            this.mRunning = true;
            this.notifyStartListeners();
        }
        animationHandler.start();
    }

    private final void $$robo$$android_animation_ValueAnimator$start() {
        this.start(false);
    }

    private final void $$robo$$android_animation_ValueAnimator$cancel() {
        AnimationHandler handler = ValueAnimator.getOrCreateAnimationHandler();
        if (this.mPlayingState != 0 || handler.mPendingAnimations.contains(this) || handler.mDelayedAnims.contains(this)) {
            if ((this.mStarted || this.mRunning) && this.mListeners != null) {
                if (!this.mRunning) {
                    this.notifyStartListeners();
                }
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationCancel(this);
                }
            }
            this.endAnimation(handler);
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$end() {
        AnimationHandler handler = ValueAnimator.getOrCreateAnimationHandler();
        if (!handler.mAnimations.contains(this) && !handler.mPendingAnimations.contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation(handler);
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        this.animateValue(this.mPlayingBackwards ? 0.0f : 1.0f);
        this.endAnimation(handler);
    }

    private final void $$robo$$android_animation_ValueAnimator$resume() {
        if (this.mPaused) {
            this.mResumed = true;
        }
        super.resume();
    }

    private final void $$robo$$android_animation_ValueAnimator$pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    private final boolean $$robo$$android_animation_ValueAnimator$isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$isStarted() {
        return this.mStarted;
    }

    private final void $$robo$$android_animation_ValueAnimator$reverse() {
        boolean bl = this.mPlayingBackwards = !this.mPlayingBackwards;
        if (this.mPlayingState == 1) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.mDuration - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
        } else if (this.mStarted) {
            this.end();
        } else {
            this.start(true);
        }
    }

    private final boolean $$robo$$android_animation_ValueAnimator$canReverse() {
        return true;
    }

    private final void $$robo$$android_animation_ValueAnimator$endAnimation(AnimationHandler handler) {
        handler.mAnimations.remove(this);
        handler.mPendingAnimations.remove(this);
        handler.mDelayedAnims.remove(this);
        this.mPlayingState = 0;
        this.mPaused = false;
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
            }
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mPlayingBackwards = false;
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceEnd(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
    }

    private final void $$robo$$android_animation_ValueAnimator$startAnimation(AnimationHandler handler) {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceBegin(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
        this.initAnimation();
        handler.mAnimations.add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    private final String $$robo$$android_animation_ValueAnimator$getNameForTrace() {
        return "animator";
    }

    private final boolean $$robo$$android_animation_ValueAnimator$delayedAnimationFrame(long currentTime) {
        long deltaTime;
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = currentTime;
        }
        if (this.mPaused) {
            if (this.mPauseTime < 0L) {
                this.mPauseTime = currentTime;
            }
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mDelayStartTime += currentTime - this.mPauseTime;
            }
        }
        if ((deltaTime = currentTime - this.mDelayStartTime) > this.mStartDelay) {
            this.mStartTime = currentTime - (deltaTime - this.mStartDelay);
            this.mPlayingState = 1;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$animationFrame(long currentTime) {
        boolean done = false;
        switch (this.mPlayingState) {
            case 1: 
            case 2: {
                float fraction2;
                float f = fraction2 = this.mDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)this.mDuration : 1.0f;
                if (fraction2 >= 1.0f) {
                    if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                        if (this.mListeners != null) {
                            int numListeners = this.mListeners.size();
                            for (int i = 0; i < numListeners; ++i) {
                                ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                            }
                        }
                        if (this.mRepeatMode == 2) {
                            this.mPlayingBackwards = !this.mPlayingBackwards;
                        }
                        this.mCurrentIteration += (int)fraction2;
                        fraction2 %= 1.0f;
                        this.mStartTime += this.mDuration;
                    } else {
                        done = true;
                        fraction2 = Math.min(fraction2, 1.0f);
                    }
                }
                if (this.mPlayingBackwards) {
                    fraction2 = 1.0f - fraction2;
                }
                this.animateValue(fraction2);
            }
        }
        return done;
    }

    private final boolean $$robo$$android_animation_ValueAnimator$doAnimationFrame(long frameTime) {
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = frameTime;
            } else {
                this.mStartTime = frameTime - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        if (this.mPaused) {
            if (this.mPauseTime < 0L) {
                this.mPauseTime = frameTime;
            }
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += frameTime - this.mPauseTime;
            }
        }
        long currentTime = Math.max(frameTime, this.mStartTime);
        return this.animationFrame(currentTime);
    }

    private final float $$robo$$android_animation_ValueAnimator$getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    private final void $$robo$$android_animation_ValueAnimator$animateValue(float fraction2) {
        this.mCurrentFraction = fraction2 = this.mInterpolator.getInterpolation(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].calculateValue(fraction2);
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    private final ValueAnimator $$robo$$android_animation_ValueAnimator$clone() {
        int i;
        ValueAnimator anim2 = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            ArrayList<AnimatorUpdateListener> oldListeners = this.mUpdateListeners;
            anim2.mUpdateListeners = new ArrayList();
            int numListeners = oldListeners.size();
            for (i = 0; i < numListeners; ++i) {
                anim2.mUpdateListeners.add(oldListeners.get(i));
            }
        }
        anim2.mSeekTime = -1L;
        anim2.mPlayingBackwards = false;
        anim2.mCurrentIteration = 0;
        anim2.mInitialized = false;
        anim2.mPlayingState = 0;
        anim2.mStartedDelay = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim2.mValues = new PropertyValuesHolder[numValues];
            anim2.mValuesMap = new HashMap(numValues);
            for (i = 0; i < numValues; ++i) {
                Object newValuesHolder;
                anim2.mValues[i] = newValuesHolder = oldValues[i].clone();
                anim2.mValuesMap.put(((PropertyValuesHolder)newValuesHolder).getPropertyName(), (PropertyValuesHolder)newValuesHolder);
            }
        }
        return anim2;
    }

    private static final int $$robo$$android_animation_ValueAnimator$getCurrentAnimationsCount() {
        AnimationHandler handler = sAnimationHandler.get();
        return handler != null ? handler.mAnimations.size() : 0;
    }

    private static final void $$robo$$android_animation_ValueAnimator$clearAllAnimations() {
        AnimationHandler handler = sAnimationHandler.get();
        if (handler != null) {
            handler.mAnimations.clear();
            handler.mPendingAnimations.clear();
            handler.mDelayedAnims.clear();
        }
    }

    private static final AnimationHandler $$robo$$android_animation_ValueAnimator$getOrCreateAnimationHandler() {
        AnimationHandler handler = sAnimationHandler.get();
        if (handler == null) {
            handler = new AnimationHandler();
            sAnimationHandler.set(handler);
        }
        return handler;
    }

    private final String $$robo$$android_animation_ValueAnimator$toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }

    private final void $$robo$$android_animation_ValueAnimator$setAllowRunningAsynchronously(boolean mayRunAsync) {
    }

    static void __staticInitializer__() {
        sDurationScale = 1.0f;
        sAnimationHandler = new ThreadLocal();
        sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    }

    public static void setDurationScale(float f) {
        InvokeDynamicSupport.bootstrapStatic("setDurationScale", $$robo$$android_animation_ValueAnimator$setDurationScale(float ), 0, (float)f);
    }

    public static float getDurationScale() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getDurationScale", $$robo$$android_animation_ValueAnimator$getDurationScale(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_animation_ValueAnimator$__constructor__();
    }

    public ValueAnimator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_ValueAnimator$__constructor__(), 0, this);
    }

    public static ValueAnimator ofInt(int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_ValueAnimator$ofInt(int[] ), 0, (int[])nArray);
    }

    public static ValueAnimator ofArgb(int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofArgb", $$robo$$android_animation_ValueAnimator$ofArgb(int[] ), 0, (int[])nArray);
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_ValueAnimator$ofFloat(float[] ), 0, (float[])fArray);
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofPropertyValuesHolder", $$robo$$android_animation_ValueAnimator$ofPropertyValuesHolder(android.animation.PropertyValuesHolder[] ), 0, (PropertyValuesHolder[])propertyValuesHolderArray);
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_ValueAnimator$ofObject(android.animation.TypeEvaluator java.lang.Object[] ), 0, (TypeEvaluator)typeEvaluator, (Object[])objectArray);
    }

    public void setIntValues(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setIntValues", $$robo$$android_animation_ValueAnimator$setIntValues(int[] ), 0, this, nArray);
    }

    public void setFloatValues(float ... fArray) {
        InvokeDynamicSupport.bootstrap("setFloatValues", $$robo$$android_animation_ValueAnimator$setFloatValues(float[] ), 0, this, fArray);
    }

    public void setObjectValues(Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("setObjectValues", $$robo$$android_animation_ValueAnimator$setObjectValues(java.lang.Object[] ), 0, this, objectArray);
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        InvokeDynamicSupport.bootstrap("setValues", $$robo$$android_animation_ValueAnimator$setValues(android.animation.PropertyValuesHolder[] ), 0, this, propertyValuesHolderArray);
    }

    public PropertyValuesHolder[] getValues() {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_animation_ValueAnimator$getValues(), 0, this);
    }

    void initAnimation() {
        InvokeDynamicSupport.bootstrap("initAnimation", $$robo$$android_animation_ValueAnimator$initAnimation(), 0, this);
    }

    @Override
    public ValueAnimator setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_ValueAnimator$setDuration(long ), 0, this, l);
    }

    private void updateScaledDuration() {
        InvokeDynamicSupport.bootstrap("updateScaledDuration", $$robo$$android_animation_ValueAnimator$updateScaledDuration(), 0, this);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_animation_ValueAnimator$getDuration(), 0, this);
    }

    public void setCurrentPlayTime(long l) {
        InvokeDynamicSupport.bootstrap("setCurrentPlayTime", $$robo$$android_animation_ValueAnimator$setCurrentPlayTime(long ), 0, this, l);
    }

    public long getCurrentPlayTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentPlayTime", $$robo$$android_animation_ValueAnimator$getCurrentPlayTime(), 0, this);
    }

    @Override
    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_animation_ValueAnimator$getStartDelay(), 0, this);
    }

    @Override
    public void setStartDelay(long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_animation_ValueAnimator$setStartDelay(long ), 0, this, l);
    }

    public static long getFrameDelay() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFrameDelay", $$robo$$android_animation_ValueAnimator$getFrameDelay(), 0);
    }

    public static void setFrameDelay(long l) {
        InvokeDynamicSupport.bootstrapStatic("setFrameDelay", $$robo$$android_animation_ValueAnimator$setFrameDelay(long ), 0, (long)l);
    }

    public Object getAnimatedValue() {
        return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_ValueAnimator$getAnimatedValue(), 0, this);
    }

    public Object getAnimatedValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getAnimatedValue", $$robo$$android_animation_ValueAnimator$getAnimatedValue(java.lang.String ), 0, this, string2);
    }

    public void setRepeatCount(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatCount", $$robo$$android_animation_ValueAnimator$setRepeatCount(int ), 0, this, n);
    }

    public int getRepeatCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatCount", $$robo$$android_animation_ValueAnimator$getRepeatCount(), 0, this);
    }

    public void setRepeatMode(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatMode", $$robo$$android_animation_ValueAnimator$setRepeatMode(int ), 0, this, n);
    }

    public int getRepeatMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatMode", $$robo$$android_animation_ValueAnimator$getRepeatMode(), 0, this);
    }

    public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        InvokeDynamicSupport.bootstrap("addUpdateListener", $$robo$$android_animation_ValueAnimator$addUpdateListener(android.animation.ValueAnimator$AnimatorUpdateListener ), 0, this, animatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        InvokeDynamicSupport.bootstrap("removeAllUpdateListeners", $$robo$$android_animation_ValueAnimator$removeAllUpdateListeners(), 0, this);
    }

    public void removeUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        InvokeDynamicSupport.bootstrap("removeUpdateListener", $$robo$$android_animation_ValueAnimator$removeUpdateListener(android.animation.ValueAnimator$AnimatorUpdateListener ), 0, this, animatorUpdateListener);
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_animation_ValueAnimator$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_animation_ValueAnimator$getInterpolator(), 0, this);
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        InvokeDynamicSupport.bootstrap("setEvaluator", $$robo$$android_animation_ValueAnimator$setEvaluator(android.animation.TypeEvaluator ), 0, this, typeEvaluator);
    }

    private void notifyStartListeners() {
        InvokeDynamicSupport.bootstrap("notifyStartListeners", $$robo$$android_animation_ValueAnimator$notifyStartListeners(), 0, this);
    }

    private void start(boolean bl) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_ValueAnimator$start(boolean ), 0, this, bl);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_ValueAnimator$start(), 0, this);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_ValueAnimator$cancel(), 0, this);
    }

    @Override
    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_animation_ValueAnimator$end(), 0, this);
    }

    @Override
    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_animation_ValueAnimator$resume(), 0, this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_animation_ValueAnimator$pause(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_animation_ValueAnimator$isRunning(), 0, this);
    }

    @Override
    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_animation_ValueAnimator$isStarted(), 0, this);
    }

    @Override
    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_animation_ValueAnimator$reverse(), 0, this);
    }

    @Override
    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_animation_ValueAnimator$canReverse(), 0, this);
    }

    protected void endAnimation(AnimationHandler animationHandler) {
        InvokeDynamicSupport.bootstrap("endAnimation", $$robo$$android_animation_ValueAnimator$endAnimation(android.animation.ValueAnimator$AnimationHandler ), 0, this, animationHandler);
    }

    private void startAnimation(AnimationHandler animationHandler) {
        InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$android_animation_ValueAnimator$startAnimation(android.animation.ValueAnimator$AnimationHandler ), 0, this, animationHandler);
    }

    String getNameForTrace() {
        return InvokeDynamicSupport.bootstrap("getNameForTrace", $$robo$$android_animation_ValueAnimator$getNameForTrace(), 0, this);
    }

    private boolean delayedAnimationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("delayedAnimationFrame", $$robo$$android_animation_ValueAnimator$delayedAnimationFrame(long ), 0, this, l);
    }

    boolean animationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("animationFrame", $$robo$$android_animation_ValueAnimator$animationFrame(long ), 0, this, l);
    }

    boolean doAnimationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("doAnimationFrame", $$robo$$android_animation_ValueAnimator$doAnimationFrame(long ), 0, this, l);
    }

    public float getAnimatedFraction() {
        return (float)InvokeDynamicSupport.bootstrap("getAnimatedFraction", $$robo$$android_animation_ValueAnimator$getAnimatedFraction(), 0, this);
    }

    void animateValue(float f) {
        InvokeDynamicSupport.bootstrap("animateValue", $$robo$$android_animation_ValueAnimator$animateValue(float ), 0, this, f);
    }

    @Override
    public ValueAnimator clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_ValueAnimator$clone(), 0, this);
    }

    public static int getCurrentAnimationsCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCurrentAnimationsCount", $$robo$$android_animation_ValueAnimator$getCurrentAnimationsCount(), 0);
    }

    public static void clearAllAnimations() {
        InvokeDynamicSupport.bootstrapStatic("clearAllAnimations", $$robo$$android_animation_ValueAnimator$clearAllAnimations(), 0);
    }

    private static AnimationHandler getOrCreateAnimationHandler() {
        return InvokeDynamicSupport.bootstrapStatic("getOrCreateAnimationHandler", $$robo$$android_animation_ValueAnimator$getOrCreateAnimationHandler(), 0);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_ValueAnimator$toString(), 0, this);
    }

    @Override
    public void setAllowRunningAsynchronously(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowRunningAsynchronously", $$robo$$android_animation_ValueAnimator$setAllowRunningAsynchronously(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(ValueAnimator.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValueAnimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface AnimatorUpdateListener
    extends InstrumentedInterface {
        public void onAnimationUpdate(ValueAnimator var1);
    }

    protected static class AnimationHandler
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected ArrayList<ValueAnimator> mAnimations;
        private ArrayList<ValueAnimator> mTmpAnimations;
        protected ArrayList<ValueAnimator> mPendingAnimations;
        protected ArrayList<ValueAnimator> mDelayedAnims;
        private ArrayList<ValueAnimator> mEndingAnims;
        private ArrayList<ValueAnimator> mReadyAnims;
        private Choreographer mChoreographer;
        private boolean mAnimationScheduled;

        private void $$robo$$android_animation_ValueAnimator_AnimationHandler$__constructor__() {
            this.mAnimations = new ArrayList();
            this.mTmpAnimations = new ArrayList();
            this.mPendingAnimations = new ArrayList();
            this.mDelayedAnims = new ArrayList();
            this.mEndingAnims = new ArrayList();
            this.mReadyAnims = new ArrayList();
            this.mChoreographer = Choreographer.getInstance();
        }

        private final void $$robo$$android_animation_ValueAnimator_AnimationHandler$start() {
            this.scheduleAnimation();
        }

        private final void $$robo$$android_animation_ValueAnimator_AnimationHandler$doAnimationFrame(long frameTime) {
            int i;
            ValueAnimator anim2;
            while (this.mPendingAnimations.size() > 0) {
                ArrayList pendingCopy = (ArrayList)this.mPendingAnimations.clone();
                this.mPendingAnimations.clear();
                int count = pendingCopy.size();
                for (int i2 = 0; i2 < count; ++i2) {
                    anim2 = (ValueAnimator)pendingCopy.get(i2);
                    if (anim2.mStartDelay == 0L) {
                        anim2.startAnimation(this);
                        continue;
                    }
                    this.mDelayedAnims.add(anim2);
                }
            }
            int numDelayedAnims = this.mDelayedAnims.size();
            for (int i3 = 0; i3 < numDelayedAnims; ++i3) {
                ValueAnimator anim3 = this.mDelayedAnims.get(i3);
                if (!anim3.delayedAnimationFrame(frameTime)) continue;
                this.mReadyAnims.add(anim3);
            }
            int numReadyAnims = this.mReadyAnims.size();
            if (numReadyAnims > 0) {
                for (int i4 = 0; i4 < numReadyAnims; ++i4) {
                    anim2 = this.mReadyAnims.get(i4);
                    anim2.startAnimation(this);
                    anim2.mRunning = true;
                    this.mDelayedAnims.remove(anim2);
                }
                this.mReadyAnims.clear();
            }
            int numAnims = this.mAnimations.size();
            for (i = 0; i < numAnims; ++i) {
                this.mTmpAnimations.add(this.mAnimations.get(i));
            }
            for (i = 0; i < numAnims; ++i) {
                ValueAnimator anim4 = this.mTmpAnimations.get(i);
                if (!this.mAnimations.contains(anim4) || !anim4.doAnimationFrame(frameTime)) continue;
                this.mEndingAnims.add(anim4);
            }
            this.mTmpAnimations.clear();
            if (this.mEndingAnims.size() > 0) {
                for (i = 0; i < this.mEndingAnims.size(); ++i) {
                    this.mEndingAnims.get(i).endAnimation(this);
                }
                this.mEndingAnims.clear();
            }
            if (!this.mAnimations.isEmpty() || !this.mDelayedAnims.isEmpty()) {
                this.scheduleAnimation();
            }
        }

        private final void $$robo$$android_animation_ValueAnimator_AnimationHandler$run() {
            this.mAnimationScheduled = false;
            this.doAnimationFrame(this.mChoreographer.getFrameTime());
        }

        private final void $$robo$$android_animation_ValueAnimator_AnimationHandler$scheduleAnimation() {
            if (!this.mAnimationScheduled) {
                this.mChoreographer.postCallback(1, this, null);
                this.mAnimationScheduled = true;
            }
        }

        private /* synthetic */ void $$robo$$android_animation_ValueAnimator_AnimationHandler$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_animation_ValueAnimator_AnimationHandler$__constructor__();
        }

        private AnimationHandler() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_ValueAnimator_AnimationHandler$__constructor__(), 0, this);
        }

        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_ValueAnimator_AnimationHandler$start(), 0, this);
        }

        private void doAnimationFrame(long l) {
            InvokeDynamicSupport.bootstrap("doAnimationFrame", $$robo$$android_animation_ValueAnimator_AnimationHandler$doAnimationFrame(long ), 0, this, l);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_animation_ValueAnimator_AnimationHandler$run(), 0, this);
        }

        private void scheduleAnimation() {
            InvokeDynamicSupport.bootstrap("scheduleAnimation", $$robo$$android_animation_ValueAnimator_AnimationHandler$scheduleAnimation(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_animation_ValueAnimator_AnimationHandler$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

