/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.SurfaceTexture;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActivityView
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActivityView";
    private static boolean DEBUG = false;
    DisplayMetrics mMetrics;
    private TextureView mTextureView;
    private ActivityContainerWrapper mActivityContainer;
    private Activity mActivity;
    private int mWidth;
    private int mHeight;
    private Surface mSurface;
    private int mLastVisibility;
    private ActivityViewCallback mActivityViewCallback;
    IIntentSender mQueuedPendingIntent;
    Intent mQueuedIntent;

    private void $$robo$$android_app_ActivityView$__constructor__(Context context) {
    }

    private void $$robo$$android_app_ActivityView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_app_ActivityView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.mActivity = (Activity)context;
                break;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (this.mActivity == null) {
            throw new IllegalStateException("The ActivityView's Context is not an Activity.");
        }
        try {
            this.mActivityContainer = new ActivityContainerWrapper(ActivityManagerNative.getDefault().createActivityContainer(this.mActivity.getActivityToken(), new ActivityContainerCallback(this)));
        }
        catch (RemoteException e) {
            throw new RuntimeException("ActivityView: Unable to create ActivityContainer. " + e);
        }
        this.mTextureView = new TextureView(context);
        this.mTextureView.setSurfaceTextureListener(new ActivityViewSurfaceTextureListener(this));
        this.addView(this.mTextureView);
        WindowManager wm = (WindowManager)this.mActivity.getSystemService("window");
        this.mMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(this.mMetrics);
        this.mLastVisibility = this.getVisibility();
    }

    private final void $$robo$$android_app_ActivityView$onLayout(boolean changed, int l, int t, int r, int b) {
        this.mTextureView.layout(0, 0, r - l, b - t);
    }

    private final void $$robo$$android_app_ActivityView$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mSurface != null) {
            try {
                if (visibility == 8) {
                    this.mActivityContainer.setSurface(null, this.mWidth, this.mHeight, this.mMetrics.densityDpi);
                } else if (this.mLastVisibility == 8) {
                    this.mActivityContainer.setSurface(this.mSurface, this.mWidth, this.mHeight, this.mMetrics.densityDpi);
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to set surface of ActivityContainer. " + e);
            }
        }
        this.mLastVisibility = visibility;
    }

    private final boolean $$robo$$android_app_ActivityView$injectInputEvent(InputEvent event) {
        return this.mActivityContainer != null && this.mActivityContainer.injectEvent(event);
    }

    private final boolean $$robo$$android_app_ActivityView$onTouchEvent(MotionEvent event) {
        return this.injectInputEvent(event) || super.onTouchEvent(event);
    }

    private final boolean $$robo$$android_app_ActivityView$onGenericMotionEvent(MotionEvent event) {
        if (event.isFromSource(2) && this.injectInputEvent(event)) {
            return true;
        }
        return super.onGenericMotionEvent(event);
    }

    private final void $$robo$$android_app_ActivityView$onAttachedToWindow() {
    }

    private final void $$robo$$android_app_ActivityView$onDetachedFromWindow() {
    }

    private final boolean $$robo$$android_app_ActivityView$isAttachedToDisplay() {
        return this.mSurface != null;
    }

    private final void $$robo$$android_app_ActivityView$startActivity(Intent intent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface != null) {
            this.mActivityContainer.startActivity(intent);
        } else {
            this.mActivityContainer.checkEmbeddedAllowed(intent);
            this.mQueuedIntent = intent;
            this.mQueuedPendingIntent = null;
        }
    }

    private final void $$robo$$android_app_ActivityView$startActivity(IntentSender intentSender) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        IIntentSender iIntentSender = intentSender.getTarget();
        if (this.mSurface != null) {
            this.mActivityContainer.startActivityIntentSender(iIntentSender);
        } else {
            this.mActivityContainer.checkEmbeddedAllowedIntentSender(iIntentSender);
            this.mQueuedPendingIntent = iIntentSender;
            this.mQueuedIntent = null;
        }
    }

    private final void $$robo$$android_app_ActivityView$startActivity(PendingIntent pendingIntent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        IIntentSender iIntentSender = pendingIntent.getTarget();
        if (this.mSurface != null) {
            this.mActivityContainer.startActivityIntentSender(iIntentSender);
        } else {
            this.mActivityContainer.checkEmbeddedAllowedIntentSender(iIntentSender);
            this.mQueuedPendingIntent = iIntentSender;
            this.mQueuedIntent = null;
        }
    }

    private final void $$robo$$android_app_ActivityView$release() {
        if (this.mActivityContainer == null) {
            Log.e("ActivityView", "Duplicate call to release");
            return;
        }
        this.mActivityContainer.release();
        this.mActivityContainer = null;
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        this.mTextureView.setSurfaceTextureListener(null);
    }

    private final void $$robo$$android_app_ActivityView$attachToSurfaceWhenReady() {
        SurfaceTexture surfaceTexture = this.mTextureView.getSurfaceTexture();
        if (surfaceTexture == null || this.mSurface != null) {
            return;
        }
        this.mSurface = new Surface(surfaceTexture);
        try {
            this.mActivityContainer.setSurface(this.mSurface, this.mWidth, this.mHeight, this.mMetrics.densityDpi);
        }
        catch (RemoteException e) {
            this.mSurface.release();
            this.mSurface = null;
            throw new RuntimeException("ActivityView: Unable to create ActivityContainer. " + e);
        }
        if (this.mQueuedIntent != null) {
            this.mActivityContainer.startActivity(this.mQueuedIntent);
            this.mQueuedIntent = null;
        } else if (this.mQueuedPendingIntent != null) {
            this.mActivityContainer.startActivityIntentSender(this.mQueuedPendingIntent);
            this.mQueuedPendingIntent = null;
        }
    }

    private final void $$robo$$android_app_ActivityView$setCallback(ActivityViewCallback callback) {
        this.mActivityViewCallback = callback;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_ActivityView$__constructor__(context);
    }

    public ActivityView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_app_ActivityView$__constructor__(context, attributeSet);
    }

    public ActivityView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_app_ActivityView$__constructor__(context, attributeSet, n);
    }

    public ActivityView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_app_ActivityView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_app_ActivityView$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    private boolean injectInputEvent(InputEvent inputEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_app_ActivityView$injectInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_app_ActivityView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_app_ActivityView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_app_ActivityView$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_app_ActivityView$onDetachedFromWindow(), 0, this);
    }

    public boolean isAttachedToDisplay() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAttachedToDisplay", $$robo$$android_app_ActivityView$isAttachedToDisplay(), 0, this);
    }

    public void startActivity(Intent intent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.content.Intent ), 0, this, intent);
    }

    public void startActivity(IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.content.IntentSender ), 0, this, intentSender);
    }

    public void startActivity(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_app_ActivityView$release(), 0, this);
    }

    private void attachToSurfaceWhenReady() {
        InvokeDynamicSupport.bootstrap("attachToSurfaceWhenReady", $$robo$$android_app_ActivityView$attachToSurfaceWhenReady(), 0, this);
    }

    public void setCallback(ActivityViewCallback activityViewCallback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_app_ActivityView$setCallback(android.app.ActivityView$ActivityViewCallback ), 0, this, activityViewCallback);
    }

    public /* synthetic */ ActivityView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ActivityContainerWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IActivityContainer mIActivityContainer;
        private CloseGuard mGuard;
        boolean mOpened;

        private void $$robo$$android_app_ActivityView_ActivityContainerWrapper$__constructor__(IActivityContainer container) {
            this.mGuard = CloseGuard.get();
            this.mIActivityContainer = container;
            this.mOpened = true;
            this.mGuard.open("release");
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$attachToDisplay(int displayId) {
            try {
                this.mIActivityContainer.attachToDisplay(displayId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$setSurface(Surface surface, int width, int height, int density) throws RemoteException {
            this.mIActivityContainer.setSurface(surface, width, height, density);
        }

        private final int $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivity(Intent intent) {
            try {
                return this.mIActivityContainer.startActivity(intent);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity. " + e);
            }
        }

        private final int $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivityIntentSender(IIntentSender intentSender) {
            try {
                return this.mIActivityContainer.startActivityIntentSender(intentSender);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity from IntentSender. " + e);
            }
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$checkEmbeddedAllowed(Intent intent) {
            try {
                this.mIActivityContainer.checkEmbeddedAllowed(intent);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity from Intent. " + e);
            }
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$checkEmbeddedAllowedIntentSender(IIntentSender intentSender) {
            try {
                this.mIActivityContainer.checkEmbeddedAllowedIntentSender(intentSender);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity from IntentSender. " + e);
            }
        }

        private final int $$robo$$android_app_ActivityView_ActivityContainerWrapper$getDisplayId() {
            try {
                return this.mIActivityContainer.getDisplayId();
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        private final boolean $$robo$$android_app_ActivityView_ActivityContainerWrapper$injectEvent(InputEvent event) {
            try {
                return this.mIActivityContainer.injectEvent(event);
            }
            catch (RemoteException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$release() {
            CloseGuard closeGuard = this.mGuard;
            synchronized (closeGuard) {
                if (this.mOpened) {
                    try {
                        this.mIActivityContainer.release();
                        this.mGuard.close();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mOpened = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$finalize() throws Throwable {
            try {
                if (this.mGuard != null) {
                    this.mGuard.warnIfOpen();
                    this.release();
                }
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(IActivityContainer iActivityContainer) {
            this.$$robo$$android_app_ActivityView_ActivityContainerWrapper$__constructor__(iActivityContainer);
        }

        ActivityContainerWrapper(IActivityContainer iActivityContainer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityContainerWrapper$__constructor__(android.app.IActivityContainer ), 0, this, iActivityContainer);
        }

        void attachToDisplay(int n) {
            InvokeDynamicSupport.bootstrap("attachToDisplay", $$robo$$android_app_ActivityView_ActivityContainerWrapper$attachToDisplay(int ), 0, this, n);
        }

        void setSurface(Surface surface, int n, int n2, int n3) throws RemoteException {
            InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_app_ActivityView_ActivityContainerWrapper$setSurface(android.view.Surface int int int ), 0, this, surface, n, n2, n3);
        }

        int startActivity(Intent intent) {
            return (int)InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivity(android.content.Intent ), 0, this, intent);
        }

        int startActivityIntentSender(IIntentSender iIntentSender) {
            return (int)InvokeDynamicSupport.bootstrap("startActivityIntentSender", $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivityIntentSender(android.content.IIntentSender ), 0, this, iIntentSender);
        }

        void checkEmbeddedAllowed(Intent intent) {
            InvokeDynamicSupport.bootstrap("checkEmbeddedAllowed", $$robo$$android_app_ActivityView_ActivityContainerWrapper$checkEmbeddedAllowed(android.content.Intent ), 0, this, intent);
        }

        void checkEmbeddedAllowedIntentSender(IIntentSender iIntentSender) {
            InvokeDynamicSupport.bootstrap("checkEmbeddedAllowedIntentSender", $$robo$$android_app_ActivityView_ActivityContainerWrapper$checkEmbeddedAllowedIntentSender(android.content.IIntentSender ), 0, this, iIntentSender);
        }

        int getDisplayId() {
            return (int)InvokeDynamicSupport.bootstrap("getDisplayId", $$robo$$android_app_ActivityView_ActivityContainerWrapper$getDisplayId(), 0, this);
        }

        boolean injectEvent(InputEvent inputEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("injectEvent", $$robo$$android_app_ActivityView_ActivityContainerWrapper$injectEvent(android.view.InputEvent ), 0, this, inputEvent);
        }

        void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_app_ActivityView_ActivityContainerWrapper$release(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_app_ActivityView_ActivityContainerWrapper$finalize(), 0, this);
        }

        public /* synthetic */ ActivityContainerWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityContainerWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ActivityContainerCallback
    extends IActivityContainerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<ActivityView> mActivityViewWeakReference;

        private void $$robo$$android_app_ActivityView_ActivityContainerCallback$__constructor__(ActivityView activityView) {
            this.mActivityViewWeakReference = new WeakReference<ActivityView>(activityView);
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerCallback$setVisible(IBinder container, boolean visible) {
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerCallback$onAllActivitiesComplete(IBinder container) {
            ActivityViewCallback callback;
            ActivityView activityView = (ActivityView)this.mActivityViewWeakReference.get();
            if (activityView != null && (callback = activityView.mActivityViewCallback) != null) {
                activityView.post(new Runnable(this, callback, activityView){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ActivityViewCallback val$callback;
                    /* synthetic */ ActivityView val$activityView;
                    /* synthetic */ ActivityContainerCallback this$0;

                    private void $$robo$$android_app_ActivityView_ActivityContainerCallback_1$__constructor__(ActivityContainerCallback activityContainerCallback, ActivityViewCallback activityViewCallback, ActivityView activityView) {
                    }

                    private final void $$robo$$android_app_ActivityView_ActivityContainerCallback_1$run() {
                        this.val$callback.onAllActivitiesComplete(this.val$activityView);
                    }

                    private void __constructor__(ActivityContainerCallback activityContainerCallback, ActivityViewCallback activityViewCallback, ActivityView activityView) {
                        this.$$robo$$android_app_ActivityView_ActivityContainerCallback_1$__constructor__(activityContainerCallback, activityViewCallback, activityView);
                    }
                    {
                        this.this$0 = activityContainerCallback;
                        this.val$callback = activityViewCallback;
                        this.val$activityView = activityView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityContainerCallback_1$__constructor__(android.app.ActivityView$ActivityContainerCallback android.app.ActivityView$ActivityViewCallback android.app.ActivityView ), 0, this, activityContainerCallback, activityViewCallback, activityView);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_ActivityView_ActivityContainerCallback_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private void __constructor__(ActivityView activityView) {
            this.$$robo$$android_app_ActivityView_ActivityContainerCallback$__constructor__(activityView);
        }

        ActivityContainerCallback(ActivityView activityView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityContainerCallback$__constructor__(android.app.ActivityView ), 0, this, activityView);
        }

        @Override
        public void setVisible(IBinder iBinder, boolean bl) {
            InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_app_ActivityView_ActivityContainerCallback$setVisible(android.os.IBinder boolean ), 0, this, iBinder, bl);
        }

        @Override
        public void onAllActivitiesComplete(IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onAllActivitiesComplete", $$robo$$android_app_ActivityView_ActivityContainerCallback$onAllActivitiesComplete(android.os.IBinder ), 0, this, iBinder);
        }

        public /* synthetic */ ActivityContainerCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityContainerCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActivityViewSurfaceTextureListener
    implements TextureView.SurfaceTextureListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActivityView this$0;

        private void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(ActivityView activityView) {
        }

        private final void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            if (this.this$0.mActivityContainer == null) {
                return;
            }
            this.this$0.mWidth = width;
            this.this$0.mHeight = height;
            this.this$0.attachToSurfaceWhenReady();
        }

        private final void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            if (this.this$0.mActivityContainer == null) {
                return;
            }
        }

        private final boolean $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            if (this.this$0.mActivityContainer == null) {
                return true;
            }
            this.this$0.mSurface.release();
            this.this$0.mSurface = null;
            try {
                this.this$0.mActivityContainer.setSurface(null, this.this$0.mWidth, this.this$0.mHeight, this.this$0.mMetrics.densityDpi);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to set surface of ActivityContainer. " + e);
            }
            return true;
        }

        private final void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        private /* synthetic */ void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(ActivityView x0, 1 x1) {
        }

        private void __constructor__(ActivityView activityView) {
            this.$$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(activityView);
        }

        private ActivityViewSurfaceTextureListener(ActivityView activityView) {
            this.this$0 = activityView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(android.app.ActivityView ), 0, this, activityView);
        }

        @Override
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSurfaceTextureAvailable", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureAvailable(android.graphics.SurfaceTexture int int ), 0, this, surfaceTexture, n, n2);
        }

        @Override
        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSurfaceTextureSizeChanged", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureSizeChanged(android.graphics.SurfaceTexture int int ), 0, this, surfaceTexture, n, n2);
        }

        @Override
        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            return (boolean)InvokeDynamicSupport.bootstrap("onSurfaceTextureDestroyed", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureDestroyed(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
        }

        @Override
        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            InvokeDynamicSupport.bootstrap("onSurfaceTextureUpdated", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureUpdated(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
        }

        private /* synthetic */ void __constructor__(ActivityView activityView, 1 var2_2) {
            this.$$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(activityView, var2_2);
        }

        public /* synthetic */ ActivityViewSurfaceTextureListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityViewSurfaceTextureListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ActivityViewCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_ActivityView_ActivityViewCallback$__constructor__() {
        }

        public abstract void onAllActivitiesComplete(ActivityView var1);

        private void __constructor__() {
            this.$$robo$$android_app_ActivityView_ActivityViewCallback$__constructor__();
        }

        public ActivityViewCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityViewCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityViewCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

