/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ApplicationLoaders;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.IntentReceiverLeaked;
import android.app.ServiceConnectionLeaked;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.Trace;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayAdjustments;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LoadedApk
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LoadedApk";
    private ActivityThread mActivityThread;
    private ApplicationInfo mApplicationInfo;
    String mPackageName;
    private String mAppDir;
    private String mResDir;
    private String[] mSplitAppDirs;
    private String[] mSplitResDirs;
    private String[] mOverlayDirs;
    private String[] mSharedLibraries;
    private String mDataDir;
    private String mLibDir;
    private File mDataDirFile;
    private ClassLoader mBaseClassLoader;
    private boolean mSecurityViolation;
    private boolean mIncludeCode;
    private boolean mRegisterPackage;
    private DisplayAdjustments mDisplayAdjustments;
    Resources mResources;
    private ClassLoader mClassLoader;
    private Application mApplication;
    private ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mReceivers;
    private ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mUnregisteredReceivers;
    private ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mServices;
    private ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mUnboundServices;
    int mClientCount;
    static /* synthetic */ boolean $assertionsDisabled;

    private final Application $$robo$$android_app_LoadedApk$getApplication() {
        return this.mApplication;
    }

    private void $$robo$$android_app_LoadedApk$__constructor__(ActivityThread activityThread, ApplicationInfo aInfo, CompatibilityInfo compatInfo, ClassLoader baseLoader, boolean securityViolation, boolean includeCode, boolean registerPackage) {
        this.mDisplayAdjustments = new DisplayAdjustments();
        this.mReceivers = new ArrayMap();
        this.mUnregisteredReceivers = new ArrayMap();
        this.mServices = new ArrayMap();
        this.mUnboundServices = new ArrayMap();
        this.mClientCount = 0;
        int myUid = Process.myUid();
        aInfo = LoadedApk.adjustNativeLibraryPaths(aInfo);
        this.mActivityThread = activityThread;
        this.mApplicationInfo = aInfo;
        this.mPackageName = aInfo.packageName;
        this.mAppDir = aInfo.sourceDir;
        this.mResDir = aInfo.uid == myUid ? aInfo.sourceDir : aInfo.publicSourceDir;
        this.mSplitAppDirs = aInfo.splitSourceDirs;
        this.mSplitResDirs = aInfo.uid == myUid ? aInfo.splitSourceDirs : aInfo.splitPublicSourceDirs;
        this.mOverlayDirs = aInfo.resourceDirs;
        if (!UserHandle.isSameUser(aInfo.uid, myUid) && !Process.isIsolated()) {
            aInfo.dataDir = PackageManager.getDataDirForUser(UserHandle.getUserId(myUid), this.mPackageName);
        }
        this.mSharedLibraries = aInfo.sharedLibraryFiles;
        this.mDataDir = aInfo.dataDir;
        this.mDataDirFile = this.mDataDir != null ? new File(this.mDataDir) : null;
        this.mLibDir = aInfo.nativeLibraryDir;
        this.mBaseClassLoader = baseLoader;
        this.mSecurityViolation = securityViolation;
        this.mIncludeCode = includeCode;
        this.mRegisterPackage = registerPackage;
        this.mDisplayAdjustments.setCompatibilityInfo(compatInfo);
    }

    private static final ApplicationInfo $$robo$$android_app_LoadedApk$adjustNativeLibraryPaths(ApplicationInfo info) {
        String secondaryIsa;
        String runtimeIsa;
        if (info.primaryCpuAbi != null && info.secondaryCpuAbi != null && (runtimeIsa = VMRuntime.getRuntime().vmInstructionSet()).equals(secondaryIsa = VMRuntime.getInstructionSet(info.secondaryCpuAbi))) {
            ApplicationInfo modified = new ApplicationInfo(info);
            modified.nativeLibraryDir = modified.secondaryNativeLibraryDir;
            return modified;
        }
        return info;
    }

    private void $$robo$$android_app_LoadedApk$__constructor__(ActivityThread activityThread) {
        this.mDisplayAdjustments = new DisplayAdjustments();
        this.mReceivers = new ArrayMap();
        this.mUnregisteredReceivers = new ArrayMap();
        this.mServices = new ArrayMap();
        this.mUnboundServices = new ArrayMap();
        this.mClientCount = 0;
        this.mActivityThread = activityThread;
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.packageName = "android";
        this.mPackageName = "android";
        this.mAppDir = null;
        this.mResDir = null;
        this.mSplitAppDirs = null;
        this.mSplitResDirs = null;
        this.mOverlayDirs = null;
        this.mSharedLibraries = null;
        this.mDataDir = null;
        this.mDataDirFile = null;
        this.mLibDir = null;
        this.mBaseClassLoader = null;
        this.mSecurityViolation = false;
        this.mIncludeCode = true;
        this.mRegisterPackage = false;
        this.mClassLoader = ClassLoader.getSystemClassLoader();
        this.mResources = Resources.getSystem();
    }

    private final void $$robo$$android_app_LoadedApk$installSystemApplicationInfo(ApplicationInfo info, ClassLoader classLoader) {
        if (!$assertionsDisabled && !info.packageName.equals("android")) {
            throw new AssertionError();
        }
        this.mApplicationInfo = info;
        this.mClassLoader = classLoader;
    }

    private final String $$robo$$android_app_LoadedApk$getPackageName() {
        return this.mPackageName;
    }

    private final ApplicationInfo $$robo$$android_app_LoadedApk$getApplicationInfo() {
        return this.mApplicationInfo;
    }

    private final boolean $$robo$$android_app_LoadedApk$isSecurityViolation() {
        return this.mSecurityViolation;
    }

    private final CompatibilityInfo $$robo$$android_app_LoadedApk$getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    private final void $$robo$$android_app_LoadedApk$setCompatibilityInfo(CompatibilityInfo compatInfo) {
        this.mDisplayAdjustments.setCompatibilityInfo(compatInfo);
    }

    private static final String[] $$robo$$android_app_LoadedApk$getLibrariesFor(String packageName) {
        ApplicationInfo ai = null;
        try {
            ai = ActivityThread.getPackageManager().getApplicationInfo(packageName, 1024, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw new AssertionError((Object)e);
        }
        if (ai == null) {
            return null;
        }
        return ai.sharedLibraryFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ClassLoader $$robo$$android_app_LoadedApk$getClassLoader() {
        LoadedApk loadedApk = this;
        synchronized (loadedApk) {
            if (this.mClassLoader != null) {
                return this.mClassLoader;
            }
            if (this.mIncludeCode && !this.mPackageName.equals("android")) {
                if (!Objects.equals(this.mPackageName, ActivityThread.currentPackageName())) {
                    String isa = VMRuntime.getRuntime().vmInstructionSet();
                    try {
                        ActivityThread.getPackageManager().performDexOptIfNeeded(this.mPackageName, isa);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                ArrayList<String> zipPaths = new ArrayList<String>();
                ArrayList<String> libPaths = new ArrayList<String>();
                if (this.mRegisterPackage) {
                    try {
                        ActivityManagerNative.getDefault().addPackageDependency(this.mPackageName);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                zipPaths.add(this.mAppDir);
                if (this.mSplitAppDirs != null) {
                    Collections.addAll(zipPaths, this.mSplitAppDirs);
                }
                libPaths.add(this.mLibDir);
                String instrumentationPackageName = this.mActivityThread.mInstrumentationPackageName;
                String instrumentationAppDir = this.mActivityThread.mInstrumentationAppDir;
                String[] instrumentationSplitAppDirs = this.mActivityThread.mInstrumentationSplitAppDirs;
                String instrumentationLibDir = this.mActivityThread.mInstrumentationLibDir;
                String instrumentedAppDir = this.mActivityThread.mInstrumentedAppDir;
                String[] instrumentedSplitAppDirs = this.mActivityThread.mInstrumentedSplitAppDirs;
                String instrumentedLibDir = this.mActivityThread.mInstrumentedLibDir;
                String[] instrumentationLibs = null;
                if (this.mAppDir.equals(instrumentationAppDir) || this.mAppDir.equals(instrumentedAppDir)) {
                    zipPaths.clear();
                    zipPaths.add(instrumentationAppDir);
                    if (instrumentationSplitAppDirs != null) {
                        Collections.addAll(zipPaths, instrumentationSplitAppDirs);
                    }
                    zipPaths.add(instrumentedAppDir);
                    if (instrumentedSplitAppDirs != null) {
                        Collections.addAll(zipPaths, instrumentedSplitAppDirs);
                    }
                    libPaths.clear();
                    libPaths.add(instrumentationLibDir);
                    libPaths.add(instrumentedLibDir);
                    if (!instrumentedAppDir.equals(instrumentationAppDir)) {
                        instrumentationLibs = LoadedApk.getLibrariesFor(instrumentationPackageName);
                    }
                }
                if (this.mSharedLibraries != null) {
                    for (String lib : this.mSharedLibraries) {
                        if (zipPaths.contains(lib)) continue;
                        zipPaths.add(0, lib);
                    }
                }
                if (instrumentationLibs != null) {
                    for (String lib : instrumentationLibs) {
                        if (zipPaths.contains(lib)) continue;
                        zipPaths.add(0, lib);
                    }
                }
                String zip = TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
                String lib = TextUtils.join((CharSequence)File.pathSeparator, libPaths);
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                this.mClassLoader = ApplicationLoaders.getDefault().getClassLoader(zip, lib, this.mBaseClassLoader);
                StrictMode.setThreadPolicy(oldPolicy);
            } else {
                this.mClassLoader = this.mBaseClassLoader == null ? ClassLoader.getSystemClassLoader() : this.mBaseClassLoader;
            }
            return this.mClassLoader;
        }
    }

    private final void $$robo$$android_app_LoadedApk$initializeJavaContextClassLoader() {
        PackageInfo pi;
        IPackageManager pm = ActivityThread.getPackageManager();
        try {
            pi = pm.getPackageInfo(this.mPackageName, 0, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unable to get package info for " + this.mPackageName + "; is system dying?", e);
        }
        if (pi == null) {
            throw new IllegalStateException("Unable to get package info for " + this.mPackageName + "; is package not installed?");
        }
        boolean sharedUserIdSet = pi.sharedUserId != null;
        boolean processNameNotDefault = pi.applicationInfo != null && !this.mPackageName.equals(pi.applicationInfo.processName);
        boolean sharable = sharedUserIdSet || processNameNotDefault;
        ClassLoader contextClassLoader = sharable ? new WarningContextClassLoader() : this.mClassLoader;
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    private final String $$robo$$android_app_LoadedApk$getAppDir() {
        return this.mAppDir;
    }

    private final String $$robo$$android_app_LoadedApk$getLibDir() {
        return this.mLibDir;
    }

    private final String $$robo$$android_app_LoadedApk$getResDir() {
        return this.mResDir;
    }

    private final String[] $$robo$$android_app_LoadedApk$getSplitAppDirs() {
        return this.mSplitAppDirs;
    }

    private final String[] $$robo$$android_app_LoadedApk$getSplitResDirs() {
        return this.mSplitResDirs;
    }

    private final String[] $$robo$$android_app_LoadedApk$getOverlayDirs() {
        return this.mOverlayDirs;
    }

    private final String $$robo$$android_app_LoadedApk$getDataDir() {
        return this.mDataDir;
    }

    private final File $$robo$$android_app_LoadedApk$getDataDirFile() {
        return this.mDataDirFile;
    }

    private final AssetManager $$robo$$android_app_LoadedApk$getAssets(ActivityThread mainThread) {
        return this.getResources(mainThread).getAssets();
    }

    private final Resources $$robo$$android_app_LoadedApk$getResources(ActivityThread mainThread) {
        if (this.mResources == null) {
            this.mResources = mainThread.getTopLevelResources(this.mResDir, this.mSplitResDirs, this.mOverlayDirs, this.mApplicationInfo.sharedLibraryFiles, 0, null, this);
        }
        return this.mResources;
    }

    private final Application $$robo$$android_app_LoadedApk$makeApplication(boolean forceDefaultAppClass, Instrumentation instrumentation) {
        Application app;
        block10: {
            block9: {
                if (this.mApplication != null) {
                    return this.mApplication;
                }
                app = null;
                String appClass = this.mApplicationInfo.className;
                if (forceDefaultAppClass || appClass == null) {
                    appClass = "android.app.Application";
                }
                try {
                    ClassLoader cl = this.getClassLoader();
                    if (!this.mPackageName.equals("android")) {
                        this.initializeJavaContextClassLoader();
                    }
                    ContextImpl appContext = ContextImpl.createAppContext(this.mActivityThread, this);
                    app = this.mActivityThread.mInstrumentation.newApplication(cl, appClass, appContext);
                    appContext.setOuterContext(app);
                }
                catch (Exception e) {
                    if (this.mActivityThread.mInstrumentation.onException(app, e)) break block9;
                    throw new RuntimeException("Unable to instantiate application " + appClass + ": " + e.toString(), e);
                }
            }
            this.mActivityThread.mAllApplications.add(app);
            this.mApplication = app;
            if (instrumentation != null) {
                try {
                    instrumentation.callApplicationOnCreate(app);
                }
                catch (Exception e) {
                    if (instrumentation.onException(app, e)) break block10;
                    throw new RuntimeException("Unable to create application " + app.getClass().getName() + ": " + e.toString(), e);
                }
            }
        }
        SparseArray<String> packageIdentifiers = this.getAssets(this.mActivityThread).getAssignedPackageIdentifiers();
        int N = packageIdentifiers.size();
        for (int i = 0; i < N; ++i) {
            int id2 = packageIdentifiers.keyAt(i);
            if (id2 == 1 || id2 == 127) continue;
            this.rewriteRValues(this.getClassLoader(), packageIdentifiers.valueAt(i), id2);
        }
        return app;
    }

    private final void $$robo$$android_app_LoadedApk$rewriteRValues(ClassLoader cl, String packageName, int id2) {
        Throwable cause;
        Method callback;
        Class<?> rClazz;
        try {
            rClazz = cl.loadClass(packageName + ".R");
        }
        catch (ClassNotFoundException e) {
            Log.i("LoadedApk", "No resource references to update in package " + packageName);
            return;
        }
        try {
            callback = rClazz.getMethod("onResourcesLoaded", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        try {
            callback.invoke(null, id2);
            return;
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e.getCause();
        }
        throw new RuntimeException("Failed to rewrite resource references for " + packageName, cause);
    }

    private final void $$robo$$android_app_LoadedApk$removeContextRegistrations(Context context, String who, String what) {
        boolean reportRegistrationLeaks = StrictMode.vmRegistrationLeaksEnabled();
        ArrayMap<BroadcastReceiver, ReceiverDispatcher> rmap = this.mReceivers.remove(context);
        if (rmap != null) {
            for (int i = 0; i < rmap.size(); ++i) {
                ReceiverDispatcher rd = rmap.valueAt(i);
                IntentReceiverLeaked leak = new IntentReceiverLeaked(what + " " + who + " has leaked IntentReceiver " + rd.getIntentReceiver() + " that was " + "originally registered here. Are you missing a " + "call to unregisterReceiver()?");
                leak.setStackTrace(rd.getLocation().getStackTrace());
                Slog.e("ActivityThread", leak.getMessage(), leak);
                if (reportRegistrationLeaks) {
                    StrictMode.onIntentReceiverLeaked(leak);
                }
                try {
                    ActivityManagerNative.getDefault().unregisterReceiver(rd.getIIntentReceiver());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        this.mUnregisteredReceivers.remove(context);
        ArrayMap<ServiceConnection, ServiceDispatcher> smap = this.mServices.remove(context);
        if (smap != null) {
            for (int i = 0; i < smap.size(); ++i) {
                ServiceDispatcher sd = smap.valueAt(i);
                ServiceConnectionLeaked leak = new ServiceConnectionLeaked(what + " " + who + " has leaked ServiceConnection " + sd.getServiceConnection() + " that was originally bound here");
                leak.setStackTrace(sd.getLocation().getStackTrace());
                Slog.e("ActivityThread", leak.getMessage(), leak);
                if (reportRegistrationLeaks) {
                    StrictMode.onServiceConnectionLeaked(leak);
                }
                try {
                    ActivityManagerNative.getDefault().unbindService(sd.getIServiceConnection());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                sd.doForget();
            }
        }
        this.mUnboundServices.remove(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IIntentReceiver $$robo$$android_app_LoadedApk$getReceiverDispatcher(BroadcastReceiver r, Context context, Handler handler, Instrumentation instrumentation, boolean registered) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ReceiverDispatcher rd = null;
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> map = null;
            if (registered && (map = this.mReceivers.get(context)) != null) {
                rd = map.get(r);
            }
            if (rd == null) {
                rd = new ReceiverDispatcher(r, context, handler, instrumentation, registered);
                if (registered) {
                    if (map == null) {
                        map = new ArrayMap();
                        this.mReceivers.put(context, map);
                    }
                    map.put(r, rd);
                }
            } else {
                rd.validate(context, handler);
            }
            rd.mForgotten = false;
            return rd.getIIntentReceiver();
        }
    }

    private final IIntentReceiver $$robo$$android_app_LoadedApk$forgetReceiverDispatcher(Context context, BroadcastReceiver r) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> map = this.mReceivers.get(context);
            ReceiverDispatcher rd = null;
            if (map != null && (rd = map.get(r)) != null) {
                map.remove(r);
                if (map.size() == 0) {
                    this.mReceivers.remove(context);
                }
                if (r.getDebugUnregister()) {
                    ArrayMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
                    if (holder == null) {
                        holder = new ArrayMap();
                        this.mUnregisteredReceivers.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unregistered here:");
                    ex.fillInStackTrace();
                    rd.setUnregisterLocation(ex);
                    holder.put(r, rd);
                }
                rd.mForgotten = true;
                return rd.getIIntentReceiver();
            }
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
            if (holder != null && (rd = holder.get(r)) != null) {
                RuntimeException ex = rd.getUnregisterLocation();
                throw new IllegalArgumentException("Unregistering Receiver " + r + " that was already unregistered", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Receiver " + r + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Receiver not registered: " + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IServiceConnection $$robo$$android_app_LoadedApk$getServiceDispatcher(ServiceConnection c, Context context, Handler handler, int flags) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ServiceDispatcher sd = null;
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            if (map != null) {
                sd = map.get(c);
            }
            if (sd == null) {
                sd = new ServiceDispatcher(c, context, handler, flags);
                if (map == null) {
                    map = new ArrayMap();
                    this.mServices.put(context, map);
                }
                map.put(c, sd);
            } else {
                sd.validate(context, handler);
            }
            return sd.getIServiceConnection();
        }
    }

    private final IServiceConnection $$robo$$android_app_LoadedApk$forgetServiceDispatcher(Context context, ServiceConnection c) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            ServiceDispatcher sd = null;
            if (map != null && (sd = map.get(c)) != null) {
                map.remove(c);
                sd.doForget();
                if (map.size() == 0) {
                    this.mServices.remove(context);
                }
                if ((sd.getFlags() & 2) != 0) {
                    ArrayMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
                    if (holder == null) {
                        holder = new ArrayMap();
                        this.mUnboundServices.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unbound here:");
                    ex.fillInStackTrace();
                    sd.setUnbindLocation(ex);
                    holder.put(c, sd);
                }
                return sd.getIServiceConnection();
            }
            ArrayMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
            if (holder != null && (sd = holder.get(c)) != null) {
                RuntimeException ex = sd.getUnbindLocation();
                throw new IllegalArgumentException("Unbinding Service " + c + " that was already unbound", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Service " + c + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Service not registered: " + c);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !LoadedApk.class.desiredAssertionStatus();
    }

    Application getApplication() {
        return InvokeDynamicSupport.bootstrap("getApplication", $$robo$$android_app_LoadedApk$getApplication(), 0, this);
    }

    private void __constructor__(ActivityThread activityThread, ApplicationInfo applicationInfo, CompatibilityInfo compatibilityInfo, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3) {
        this.$$robo$$android_app_LoadedApk$__constructor__(activityThread, applicationInfo, compatibilityInfo, classLoader, bl, bl2, bl3);
    }

    public LoadedApk(ActivityThread activityThread, ApplicationInfo applicationInfo, CompatibilityInfo compatibilityInfo, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk$__constructor__(android.app.ActivityThread android.content.pm.ApplicationInfo android.content.res.CompatibilityInfo java.lang.ClassLoader boolean boolean boolean ), 0, this, activityThread, applicationInfo, compatibilityInfo, classLoader, bl, bl2, bl3);
    }

    private static ApplicationInfo adjustNativeLibraryPaths(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrapStatic("adjustNativeLibraryPaths", $$robo$$android_app_LoadedApk$adjustNativeLibraryPaths(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    private void __constructor__(ActivityThread activityThread) {
        this.$$robo$$android_app_LoadedApk$__constructor__(activityThread);
    }

    LoadedApk(ActivityThread activityThread) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk$__constructor__(android.app.ActivityThread ), 0, this, activityThread);
    }

    void installSystemApplicationInfo(ApplicationInfo applicationInfo, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("installSystemApplicationInfo", $$robo$$android_app_LoadedApk$installSystemApplicationInfo(android.content.pm.ApplicationInfo java.lang.ClassLoader ), 0, this, applicationInfo, classLoader);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_app_LoadedApk$getPackageName(), 0, this);
    }

    public ApplicationInfo getApplicationInfo() {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_app_LoadedApk$getApplicationInfo(), 0, this);
    }

    public boolean isSecurityViolation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecurityViolation", $$robo$$android_app_LoadedApk$isSecurityViolation(), 0, this);
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return InvokeDynamicSupport.bootstrap("getCompatibilityInfo", $$robo$$android_app_LoadedApk$getCompatibilityInfo(), 0, this);
    }

    public void setCompatibilityInfo(CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrap("setCompatibilityInfo", $$robo$$android_app_LoadedApk$setCompatibilityInfo(android.content.res.CompatibilityInfo ), 0, this, compatibilityInfo);
    }

    private static String[] getLibrariesFor(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getLibrariesFor", $$robo$$android_app_LoadedApk$getLibrariesFor(java.lang.String ), 0, (String)string2);
    }

    public ClassLoader getClassLoader() {
        return InvokeDynamicSupport.bootstrap("getClassLoader", $$robo$$android_app_LoadedApk$getClassLoader(), 0, this);
    }

    private void initializeJavaContextClassLoader() {
        InvokeDynamicSupport.bootstrap("initializeJavaContextClassLoader", $$robo$$android_app_LoadedApk$initializeJavaContextClassLoader(), 0, this);
    }

    public String getAppDir() {
        return InvokeDynamicSupport.bootstrap("getAppDir", $$robo$$android_app_LoadedApk$getAppDir(), 0, this);
    }

    public String getLibDir() {
        return InvokeDynamicSupport.bootstrap("getLibDir", $$robo$$android_app_LoadedApk$getLibDir(), 0, this);
    }

    public String getResDir() {
        return InvokeDynamicSupport.bootstrap("getResDir", $$robo$$android_app_LoadedApk$getResDir(), 0, this);
    }

    public String[] getSplitAppDirs() {
        return InvokeDynamicSupport.bootstrap("getSplitAppDirs", $$robo$$android_app_LoadedApk$getSplitAppDirs(), 0, this);
    }

    public String[] getSplitResDirs() {
        return InvokeDynamicSupport.bootstrap("getSplitResDirs", $$robo$$android_app_LoadedApk$getSplitResDirs(), 0, this);
    }

    public String[] getOverlayDirs() {
        return InvokeDynamicSupport.bootstrap("getOverlayDirs", $$robo$$android_app_LoadedApk$getOverlayDirs(), 0, this);
    }

    public String getDataDir() {
        return InvokeDynamicSupport.bootstrap("getDataDir", $$robo$$android_app_LoadedApk$getDataDir(), 0, this);
    }

    public File getDataDirFile() {
        return InvokeDynamicSupport.bootstrap("getDataDirFile", $$robo$$android_app_LoadedApk$getDataDirFile(), 0, this);
    }

    public AssetManager getAssets(ActivityThread activityThread) {
        return InvokeDynamicSupport.bootstrap("getAssets", $$robo$$android_app_LoadedApk$getAssets(android.app.ActivityThread ), 0, this, activityThread);
    }

    public Resources getResources(ActivityThread activityThread) {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_app_LoadedApk$getResources(android.app.ActivityThread ), 0, this, activityThread);
    }

    public Application makeApplication(boolean bl, Instrumentation instrumentation) {
        return InvokeDynamicSupport.bootstrap("makeApplication", $$robo$$android_app_LoadedApk$makeApplication(boolean android.app.Instrumentation ), 0, this, bl, instrumentation);
    }

    private void rewriteRValues(ClassLoader classLoader, String string2, int n) {
        InvokeDynamicSupport.bootstrap("rewriteRValues", $$robo$$android_app_LoadedApk$rewriteRValues(java.lang.ClassLoader java.lang.String int ), 0, this, classLoader, string2, n);
    }

    public void removeContextRegistrations(Context context, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("removeContextRegistrations", $$robo$$android_app_LoadedApk$removeContextRegistrations(android.content.Context java.lang.String java.lang.String ), 0, this, context, string2, string3);
    }

    public IIntentReceiver getReceiverDispatcher(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getReceiverDispatcher", $$robo$$android_app_LoadedApk$getReceiverDispatcher(android.content.BroadcastReceiver android.content.Context android.os.Handler android.app.Instrumentation boolean ), 0, this, broadcastReceiver, context, handler, instrumentation, bl);
    }

    public IIntentReceiver forgetReceiverDispatcher(Context context, BroadcastReceiver broadcastReceiver) {
        return InvokeDynamicSupport.bootstrap("forgetReceiverDispatcher", $$robo$$android_app_LoadedApk$forgetReceiverDispatcher(android.content.Context android.content.BroadcastReceiver ), 0, this, context, broadcastReceiver);
    }

    public IServiceConnection getServiceDispatcher(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
        return InvokeDynamicSupport.bootstrap("getServiceDispatcher", $$robo$$android_app_LoadedApk$getServiceDispatcher(android.content.ServiceConnection android.content.Context android.os.Handler int ), 0, this, serviceConnection, context, handler, n);
    }

    public IServiceConnection forgetServiceDispatcher(Context context, ServiceConnection serviceConnection) {
        return InvokeDynamicSupport.bootstrap("forgetServiceDispatcher", $$robo$$android_app_LoadedApk$forgetServiceDispatcher(android.content.Context android.content.ServiceConnection ), 0, this, context, serviceConnection);
    }

    static {
        RobolectricInternals.classInitializing(LoadedApk.class);
    }

    public /* synthetic */ LoadedApk() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadedApk)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ServiceDispatcher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InnerConnection mIServiceConnection;
        private ServiceConnection mConnection;
        private Context mContext;
        private Handler mActivityThread;
        private ServiceConnectionLeaked mLocation;
        private int mFlags;
        private RuntimeException mUnbindLocation;
        private boolean mDied;
        private boolean mForgotten;
        private ArrayMap<ComponentName, ConnectionInfo> mActiveConnections;

        private void $$robo$$android_app_LoadedApk_ServiceDispatcher$__constructor__(ServiceConnection conn, Context context, Handler activityThread, int flags) {
            this.mActiveConnections = new ArrayMap();
            this.mIServiceConnection = new InnerConnection(this);
            this.mConnection = conn;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = flags;
        }

        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$doForget() {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                for (int i = 0; i < this.mActiveConnections.size(); ++i) {
                    ConnectionInfo ci = this.mActiveConnections.valueAt(i);
                    ci.binder.unlinkToDeath(ci.deathMonitor, 0);
                }
                this.mActiveConnections.clear();
                this.mForgotten = true;
            }
        }

        private final ServiceConnectionLeaked $$robo$$android_app_LoadedApk_ServiceDispatcher$getLocation() {
            return this.mLocation;
        }

        private final ServiceConnection $$robo$$android_app_LoadedApk_ServiceDispatcher$getServiceConnection() {
            return this.mConnection;
        }

        private final IServiceConnection $$robo$$android_app_LoadedApk_ServiceDispatcher$getIServiceConnection() {
            return this.mIServiceConnection;
        }

        private final int $$robo$$android_app_LoadedApk_ServiceDispatcher$getFlags() {
            return this.mFlags;
        }

        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$setUnbindLocation(RuntimeException ex) {
            this.mUnbindLocation = ex;
        }

        private final RuntimeException $$robo$$android_app_LoadedApk_ServiceDispatcher$getUnbindLocation() {
            return this.mUnbindLocation;
        }

        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$connected(ComponentName name, IBinder service) {
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(this, name, service, 0));
            } else {
                this.doConnected(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$death(ComponentName name, IBinder service) {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                this.mDied = true;
                ConnectionInfo old = this.mActiveConnections.remove(name);
                if (old == null || old.binder != service) {
                    return;
                }
                old.binder.unlinkToDeath(old.deathMonitor, 0);
            }
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(this, name, service, 1));
            } else {
                this.doDeath(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$doConnected(ComponentName name, IBinder service) {
            ConnectionInfo old;
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                if (this.mForgotten) {
                    return;
                }
                old = this.mActiveConnections.get(name);
                if (old != null && old.binder == service) {
                    return;
                }
                if (service != null) {
                    this.mDied = false;
                    ConnectionInfo info = new ConnectionInfo();
                    info.binder = service;
                    info.deathMonitor = new DeathMonitor(this, name, service);
                    try {
                        service.linkToDeath(info.deathMonitor, 0);
                        this.mActiveConnections.put(name, info);
                    }
                    catch (RemoteException e) {
                        this.mActiveConnections.remove(name);
                        return;
                    }
                } else {
                    this.mActiveConnections.remove(name);
                }
                if (old != null) {
                    old.binder.unlinkToDeath(old.deathMonitor, 0);
                }
            }
            if (old != null) {
                this.mConnection.onServiceDisconnected(name);
            }
            if (service != null) {
                this.mConnection.onServiceConnected(name, service);
            }
        }

        private final void $$robo$$android_app_LoadedApk_ServiceDispatcher$doDeath(ComponentName name, IBinder service) {
            this.mConnection.onServiceDisconnected(name);
        }

        private void __constructor__(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
            this.$$robo$$android_app_LoadedApk_ServiceDispatcher$__constructor__(serviceConnection, context, handler, n);
        }

        ServiceDispatcher(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ServiceDispatcher$__constructor__(android.content.ServiceConnection android.content.Context android.os.Handler int ), 0, this, serviceConnection, context, handler, n);
        }

        void validate(Context context, Handler handler) {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$android_app_LoadedApk_ServiceDispatcher$validate(android.content.Context android.os.Handler ), 0, this, context, handler);
        }

        void doForget() {
            InvokeDynamicSupport.bootstrap("doForget", $$robo$$android_app_LoadedApk_ServiceDispatcher$doForget(), 0, this);
        }

        ServiceConnectionLeaked getLocation() {
            return InvokeDynamicSupport.bootstrap("getLocation", $$robo$$android_app_LoadedApk_ServiceDispatcher$getLocation(), 0, this);
        }

        ServiceConnection getServiceConnection() {
            return InvokeDynamicSupport.bootstrap("getServiceConnection", $$robo$$android_app_LoadedApk_ServiceDispatcher$getServiceConnection(), 0, this);
        }

        IServiceConnection getIServiceConnection() {
            return InvokeDynamicSupport.bootstrap("getIServiceConnection", $$robo$$android_app_LoadedApk_ServiceDispatcher$getIServiceConnection(), 0, this);
        }

        int getFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_app_LoadedApk_ServiceDispatcher$getFlags(), 0, this);
        }

        void setUnbindLocation(RuntimeException runtimeException) {
            InvokeDynamicSupport.bootstrap("setUnbindLocation", $$robo$$android_app_LoadedApk_ServiceDispatcher$setUnbindLocation(java.lang.RuntimeException ), 0, this, runtimeException);
        }

        RuntimeException getUnbindLocation() {
            return InvokeDynamicSupport.bootstrap("getUnbindLocation", $$robo$$android_app_LoadedApk_ServiceDispatcher$getUnbindLocation(), 0, this);
        }

        public void connected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("connected", $$robo$$android_app_LoadedApk_ServiceDispatcher$connected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        public void death(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("death", $$robo$$android_app_LoadedApk_ServiceDispatcher$death(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        public void doConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("doConnected", $$robo$$android_app_LoadedApk_ServiceDispatcher$doConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        public void doDeath(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("doDeath", $$robo$$android_app_LoadedApk_ServiceDispatcher$doDeath(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        public /* synthetic */ ServiceDispatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceDispatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private final class DeathMonitor
        implements IBinder.DeathRecipient,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            ComponentName mName;
            IBinder mService;
            /* synthetic */ ServiceDispatcher this$0;

            private void $$robo$$android_app_LoadedApk_ServiceDispatcher_DeathMonitor$__constructor__(ServiceDispatcher serviceDispatcher, ComponentName name, IBinder service) {
                this.mName = name;
                this.mService = service;
            }

            private final void $$robo$$android_app_LoadedApk_ServiceDispatcher_DeathMonitor$binderDied() {
                this.this$0.death(this.mName, this.mService);
            }

            private void __constructor__(ServiceDispatcher serviceDispatcher, ComponentName componentName, IBinder iBinder) {
                this.$$robo$$android_app_LoadedApk_ServiceDispatcher_DeathMonitor$__constructor__(serviceDispatcher, componentName, iBinder);
            }

            DeathMonitor(ServiceDispatcher serviceDispatcher, ComponentName componentName, IBinder iBinder) {
                this.this$0 = serviceDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ServiceDispatcher_DeathMonitor$__constructor__(android.app.LoadedApk$ServiceDispatcher android.content.ComponentName android.os.IBinder ), 0, this, serviceDispatcher, componentName, iBinder);
            }

            @Override
            public void binderDied() {
                InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_app_LoadedApk_ServiceDispatcher_DeathMonitor$binderDied(), 0, this);
            }

            public /* synthetic */ DeathMonitor() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeathMonitor)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private final class RunConnection
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            ComponentName mName;
            IBinder mService;
            int mCommand;
            /* synthetic */ ServiceDispatcher this$0;

            private void $$robo$$android_app_LoadedApk_ServiceDispatcher_RunConnection$__constructor__(ServiceDispatcher serviceDispatcher, ComponentName name, IBinder service, int command) {
                this.mName = name;
                this.mService = service;
                this.mCommand = command;
            }

            private final void $$robo$$android_app_LoadedApk_ServiceDispatcher_RunConnection$run() {
                if (this.mCommand == 0) {
                    this.this$0.doConnected(this.mName, this.mService);
                } else if (this.mCommand == 1) {
                    this.this$0.doDeath(this.mName, this.mService);
                }
            }

            private void __constructor__(ServiceDispatcher serviceDispatcher, ComponentName componentName, IBinder iBinder, int n) {
                this.$$robo$$android_app_LoadedApk_ServiceDispatcher_RunConnection$__constructor__(serviceDispatcher, componentName, iBinder, n);
            }

            RunConnection(ServiceDispatcher serviceDispatcher, ComponentName componentName, IBinder iBinder, int n) {
                this.this$0 = serviceDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ServiceDispatcher_RunConnection$__constructor__(android.app.LoadedApk$ServiceDispatcher android.content.ComponentName android.os.IBinder int ), 0, this, serviceDispatcher, componentName, iBinder, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_LoadedApk_ServiceDispatcher_RunConnection$run(), 0, this);
            }

            public /* synthetic */ RunConnection() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunConnection)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private static class InnerConnection
        extends IServiceConnection.Stub
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            WeakReference<ServiceDispatcher> mDispatcher;

            private void $$robo$$android_app_LoadedApk_ServiceDispatcher_InnerConnection$__constructor__(ServiceDispatcher sd) {
                this.mDispatcher = new WeakReference<ServiceDispatcher>(sd);
            }

            private final void $$robo$$android_app_LoadedApk_ServiceDispatcher_InnerConnection$connected(ComponentName name, IBinder service) throws RemoteException {
                ServiceDispatcher sd = (ServiceDispatcher)this.mDispatcher.get();
                if (sd != null) {
                    sd.connected(name, service);
                }
            }

            private void __constructor__(ServiceDispatcher serviceDispatcher) {
                this.$$robo$$android_app_LoadedApk_ServiceDispatcher_InnerConnection$__constructor__(serviceDispatcher);
            }

            InnerConnection(ServiceDispatcher serviceDispatcher) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ServiceDispatcher_InnerConnection$__constructor__(android.app.LoadedApk$ServiceDispatcher ), 0, this, serviceDispatcher);
            }

            @Override
            public void connected(ComponentName componentName, IBinder iBinder) throws RemoteException {
                InvokeDynamicSupport.bootstrap("connected", $$robo$$android_app_LoadedApk_ServiceDispatcher_InnerConnection$connected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            public /* synthetic */ InnerConnection() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InnerConnection)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private static class ConnectionInfo
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            IBinder binder;
            IBinder.DeathRecipient deathMonitor;

            private void $$robo$$android_app_LoadedApk_ServiceDispatcher_ConnectionInfo$__constructor__() {
            }

            private /* synthetic */ void $$robo$$android_app_LoadedApk_ServiceDispatcher_ConnectionInfo$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_app_LoadedApk_ServiceDispatcher_ConnectionInfo$__constructor__();
            }

            private ConnectionInfo() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ServiceDispatcher_ConnectionInfo$__constructor__(), 0, this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_app_LoadedApk_ServiceDispatcher_ConnectionInfo$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionInfo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ReceiverDispatcher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        IIntentReceiver.Stub mIIntentReceiver;
        BroadcastReceiver mReceiver;
        Context mContext;
        Handler mActivityThread;
        Instrumentation mInstrumentation;
        boolean mRegistered;
        IntentReceiverLeaked mLocation;
        RuntimeException mUnregisterLocation;
        boolean mForgotten;

        private void $$robo$$android_app_LoadedApk_ReceiverDispatcher$__constructor__(BroadcastReceiver receiver, Context context, Handler activityThread, Instrumentation instrumentation, boolean registered) {
            if (activityThread == null) {
                throw new NullPointerException("Handler must not be null");
            }
            this.mIIntentReceiver = new InnerReceiver(this, !registered);
            this.mReceiver = receiver;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mInstrumentation = instrumentation;
            this.mRegistered = registered;
            this.mLocation = new IntentReceiverLeaked(null);
            this.mLocation.fillInStackTrace();
        }

        private final void $$robo$$android_app_LoadedApk_ReceiverDispatcher$validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        private final IntentReceiverLeaked $$robo$$android_app_LoadedApk_ReceiverDispatcher$getLocation() {
            return this.mLocation;
        }

        private final BroadcastReceiver $$robo$$android_app_LoadedApk_ReceiverDispatcher$getIntentReceiver() {
            return this.mReceiver;
        }

        private final IIntentReceiver $$robo$$android_app_LoadedApk_ReceiverDispatcher$getIIntentReceiver() {
            return this.mIIntentReceiver;
        }

        private final void $$robo$$android_app_LoadedApk_ReceiverDispatcher$setUnregisterLocation(RuntimeException ex) {
            this.mUnregisterLocation = ex;
        }

        private final RuntimeException $$robo$$android_app_LoadedApk_ReceiverDispatcher$getUnregisterLocation() {
            return this.mUnregisterLocation;
        }

        private final void $$robo$$android_app_LoadedApk_ReceiverDispatcher$performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
            Args args = new Args(this, intent, resultCode, data, extras, ordered, sticky, sendingUser);
            if (!this.mActivityThread.post(args) && this.mRegistered && ordered) {
                IActivityManager mgr = ActivityManagerNative.getDefault();
                args.sendFinished(mgr);
            }
        }

        private void __constructor__(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
            this.$$robo$$android_app_LoadedApk_ReceiverDispatcher$__constructor__(broadcastReceiver, context, handler, instrumentation, bl);
        }

        ReceiverDispatcher(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ReceiverDispatcher$__constructor__(android.content.BroadcastReceiver android.content.Context android.os.Handler android.app.Instrumentation boolean ), 0, this, broadcastReceiver, context, handler, instrumentation, bl);
        }

        void validate(Context context, Handler handler) {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$android_app_LoadedApk_ReceiverDispatcher$validate(android.content.Context android.os.Handler ), 0, this, context, handler);
        }

        IntentReceiverLeaked getLocation() {
            return InvokeDynamicSupport.bootstrap("getLocation", $$robo$$android_app_LoadedApk_ReceiverDispatcher$getLocation(), 0, this);
        }

        BroadcastReceiver getIntentReceiver() {
            return InvokeDynamicSupport.bootstrap("getIntentReceiver", $$robo$$android_app_LoadedApk_ReceiverDispatcher$getIntentReceiver(), 0, this);
        }

        IIntentReceiver getIIntentReceiver() {
            return InvokeDynamicSupport.bootstrap("getIIntentReceiver", $$robo$$android_app_LoadedApk_ReceiverDispatcher$getIIntentReceiver(), 0, this);
        }

        void setUnregisterLocation(RuntimeException runtimeException) {
            InvokeDynamicSupport.bootstrap("setUnregisterLocation", $$robo$$android_app_LoadedApk_ReceiverDispatcher$setUnregisterLocation(java.lang.RuntimeException ), 0, this, runtimeException);
        }

        RuntimeException getUnregisterLocation() {
            return InvokeDynamicSupport.bootstrap("getUnregisterLocation", $$robo$$android_app_LoadedApk_ReceiverDispatcher$getUnregisterLocation(), 0, this);
        }

        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
            InvokeDynamicSupport.bootstrap("performReceive", $$robo$$android_app_LoadedApk_ReceiverDispatcher$performReceive(android.content.Intent int java.lang.String android.os.Bundle boolean boolean int ), 0, this, intent, n, string2, bundle, bl, bl2, n2);
        }

        public /* synthetic */ ReceiverDispatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReceiverDispatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public final class Args
        extends BroadcastReceiver.PendingResult
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Intent mCurIntent;
            private boolean mOrdered;
            /* synthetic */ ReceiverDispatcher this$0;

            private void $$robo$$android_app_LoadedApk_ReceiverDispatcher_Args$__constructor__(ReceiverDispatcher receiverDispatcher, Intent intent, int resultCode, String resultData, Bundle resultExtras, boolean ordered, boolean sticky, int sendingUser) {
                this.mCurIntent = intent;
                this.mOrdered = ordered;
            }

            private final void $$robo$$android_app_LoadedApk_ReceiverDispatcher_Args$run() {
                BroadcastReceiver receiver;
                block6: {
                    receiver = this.this$0.mReceiver;
                    boolean ordered = this.mOrdered;
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    Intent intent = this.mCurIntent;
                    this.mCurIntent = null;
                    if (receiver == null || this.this$0.mForgotten) {
                        if (this.this$0.mRegistered && ordered) {
                            this.sendFinished(mgr);
                        }
                        return;
                    }
                    Trace.traceBegin(64L, "broadcastReceiveReg");
                    try {
                        ClassLoader cl = this.this$0.mReceiver.getClass().getClassLoader();
                        intent.setExtrasClassLoader(cl);
                        this.setExtrasClassLoader(cl);
                        receiver.setPendingResult(this);
                        receiver.onReceive(this.this$0.mContext, intent);
                    }
                    catch (Exception e) {
                        if (this.this$0.mRegistered && ordered) {
                            this.sendFinished(mgr);
                        }
                        if (this.this$0.mInstrumentation != null && this.this$0.mInstrumentation.onException(this.this$0.mReceiver, e)) break block6;
                        Trace.traceEnd(64L);
                        throw new RuntimeException("Error receiving broadcast " + intent + " in " + this.this$0.mReceiver, e);
                    }
                }
                if (receiver.getPendingResult() != null) {
                    this.finish();
                }
                Trace.traceEnd(64L);
            }

            private void __constructor__(ReceiverDispatcher receiverDispatcher, Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
                this.$$robo$$android_app_LoadedApk_ReceiverDispatcher_Args$__constructor__(receiverDispatcher, intent, n, string2, bundle, bl, bl2, n2);
            }

            public Args(ReceiverDispatcher receiverDispatcher, Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
                this.this$0 = receiverDispatcher;
                super(n, string2, bundle, receiverDispatcher.mRegistered ? 1 : 2, bl, bl2, receiverDispatcher.mIIntentReceiver.asBinder(), n2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ReceiverDispatcher_Args$__constructor__(android.app.LoadedApk$ReceiverDispatcher android.content.Intent int java.lang.String android.os.Bundle boolean boolean int ), 0, this, receiverDispatcher, intent, n, string2, bundle, bl, bl2, n2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_LoadedApk_ReceiverDispatcher_Args$run(), 0, this);
            }

            public /* synthetic */ Args() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Args)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class InnerReceiver
        extends IIntentReceiver.Stub
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            WeakReference<ReceiverDispatcher> mDispatcher;
            ReceiverDispatcher mStrongRef;

            private void $$robo$$android_app_LoadedApk_ReceiverDispatcher_InnerReceiver$__constructor__(ReceiverDispatcher rd, boolean strong) {
                this.mDispatcher = new WeakReference<ReceiverDispatcher>(rd);
                this.mStrongRef = strong ? rd : null;
            }

            private final void $$robo$$android_app_LoadedApk_ReceiverDispatcher_InnerReceiver$performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                ReceiverDispatcher rd = (ReceiverDispatcher)this.mDispatcher.get();
                if (rd != null) {
                    rd.performReceive(intent, resultCode, data, extras, ordered, sticky, sendingUser);
                } else {
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    try {
                        if (extras != null) {
                            extras.setAllowFds(false);
                        }
                        mgr.finishReceiver(this, resultCode, data, extras, false);
                    }
                    catch (RemoteException e) {
                        Slog.w("ActivityThread", "Couldn't finish broadcast to unregistered receiver");
                    }
                }
            }

            private void __constructor__(ReceiverDispatcher receiverDispatcher, boolean bl) {
                this.$$robo$$android_app_LoadedApk_ReceiverDispatcher_InnerReceiver$__constructor__(receiverDispatcher, bl);
            }

            InnerReceiver(ReceiverDispatcher receiverDispatcher, boolean bl) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_ReceiverDispatcher_InnerReceiver$__constructor__(android.app.LoadedApk$ReceiverDispatcher boolean ), 0, this, receiverDispatcher, bl);
            }

            @Override
            public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
                InvokeDynamicSupport.bootstrap("performReceive", $$robo$$android_app_LoadedApk_ReceiverDispatcher_InnerReceiver$performReceive(android.content.Intent int java.lang.String android.os.Bundle boolean boolean int ), 0, this, intent, n, string2, bundle, bl, bl2, n2);
            }

            public /* synthetic */ InnerReceiver() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InnerReceiver)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class WarningContextClassLoader
    extends ClassLoader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static boolean warned;

        private void $$robo$$android_app_LoadedApk_WarningContextClassLoader$__constructor__() {
        }

        private final void $$robo$$android_app_LoadedApk_WarningContextClassLoader$warn(String methodName) {
            if (warned) {
                return;
            }
            warned = true;
            Thread.currentThread().setContextClassLoader(this.getParent());
            Slog.w("ActivityThread", "ClassLoader." + methodName + ": " + "The class loader returned by " + "Thread.getContextClassLoader() may fail for processes " + "that host multiple applications. You should explicitly " + "specify a context class loader. For example: " + "Thread.setContextClassLoader(getClass().getClassLoader());");
        }

        private final URL $$robo$$android_app_LoadedApk_WarningContextClassLoader$getResource(String resName) {
            this.warn("getResource");
            return this.getParent().getResource(resName);
        }

        private final Enumeration<URL> $$robo$$android_app_LoadedApk_WarningContextClassLoader$getResources(String resName) throws IOException {
            this.warn("getResources");
            return this.getParent().getResources(resName);
        }

        private final InputStream $$robo$$android_app_LoadedApk_WarningContextClassLoader$getResourceAsStream(String resName) {
            this.warn("getResourceAsStream");
            return this.getParent().getResourceAsStream(resName);
        }

        private final Class<?> $$robo$$android_app_LoadedApk_WarningContextClassLoader$loadClass(String className) throws ClassNotFoundException {
            this.warn("loadClass");
            return this.getParent().loadClass(className);
        }

        private final void $$robo$$android_app_LoadedApk_WarningContextClassLoader$setClassAssertionStatus(String cname, boolean enable) {
            this.warn("setClassAssertionStatus");
            this.getParent().setClassAssertionStatus(cname, enable);
        }

        private final void $$robo$$android_app_LoadedApk_WarningContextClassLoader$setPackageAssertionStatus(String pname, boolean enable) {
            this.warn("setPackageAssertionStatus");
            this.getParent().setPackageAssertionStatus(pname, enable);
        }

        private final void $$robo$$android_app_LoadedApk_WarningContextClassLoader$setDefaultAssertionStatus(boolean enable) {
            this.warn("setDefaultAssertionStatus");
            this.getParent().setDefaultAssertionStatus(enable);
        }

        private final void $$robo$$android_app_LoadedApk_WarningContextClassLoader$clearAssertionStatus() {
            this.warn("clearAssertionStatus");
            this.getParent().clearAssertionStatus();
        }

        private /* synthetic */ void $$robo$$android_app_LoadedApk_WarningContextClassLoader$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            warned = false;
        }

        private void __constructor__() {
            this.$$robo$$android_app_LoadedApk_WarningContextClassLoader$__constructor__();
        }

        private WarningContextClassLoader() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoadedApk_WarningContextClassLoader$__constructor__(), 0, this);
        }

        private void warn(String string2) {
            InvokeDynamicSupport.bootstrap("warn", $$robo$$android_app_LoadedApk_WarningContextClassLoader$warn(java.lang.String ), 0, this, string2);
        }

        @Override
        public URL getResource(String string2) {
            return InvokeDynamicSupport.bootstrap("getResource", $$robo$$android_app_LoadedApk_WarningContextClassLoader$getResource(java.lang.String ), 0, this, string2);
        }

        @Override
        public Enumeration<URL> getResources(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_app_LoadedApk_WarningContextClassLoader$getResources(java.lang.String ), 0, this, string2);
        }

        @Override
        public InputStream getResourceAsStream(String string2) {
            return InvokeDynamicSupport.bootstrap("getResourceAsStream", $$robo$$android_app_LoadedApk_WarningContextClassLoader$getResourceAsStream(java.lang.String ), 0, this, string2);
        }

        @Override
        public Class<?> loadClass(String string2) throws ClassNotFoundException {
            return InvokeDynamicSupport.bootstrap("loadClass", $$robo$$android_app_LoadedApk_WarningContextClassLoader$loadClass(java.lang.String ), 0, this, string2);
        }

        @Override
        public void setClassAssertionStatus(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("setClassAssertionStatus", $$robo$$android_app_LoadedApk_WarningContextClassLoader$setClassAssertionStatus(java.lang.String boolean ), 0, this, string2, bl);
        }

        @Override
        public void setPackageAssertionStatus(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("setPackageAssertionStatus", $$robo$$android_app_LoadedApk_WarningContextClassLoader$setPackageAssertionStatus(java.lang.String boolean ), 0, this, string2, bl);
        }

        @Override
        public void setDefaultAssertionStatus(boolean bl) {
            InvokeDynamicSupport.bootstrap("setDefaultAssertionStatus", $$robo$$android_app_LoadedApk_WarningContextClassLoader$setDefaultAssertionStatus(boolean ), 0, this, bl);
        }

        @Override
        public void clearAssertionStatus() {
            InvokeDynamicSupport.bootstrap("clearAssertionStatus", $$robo$$android_app_LoadedApk_WarningContextClassLoader$clearAssertionStatus(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_LoadedApk_WarningContextClassLoader$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(WarningContextClassLoader.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WarningContextClassLoader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

