/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.MediaRouteButton;
import android.content.Context;
import android.media.MediaRouter;
import android.util.Log;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaRouteActionProvider
extends ActionProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaRouteActionProvider";
    private Context mContext;
    private MediaRouter mRouter;
    private MediaRouterCallback mCallback;
    private int mRouteTypes;
    private MediaRouteButton mButton;
    private View.OnClickListener mExtendedSettingsListener;

    private void $$robo$$android_app_MediaRouteActionProvider$__constructor__(Context context) {
        this.mContext = context;
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback(this);
        this.setRouteTypes(1);
    }

    private final void $$robo$$android_app_MediaRouteActionProvider$setRouteTypes(int types) {
        if (this.mRouteTypes != types) {
            if (this.mRouteTypes != 0) {
                this.mRouter.removeCallback(this.mCallback);
            }
            this.mRouteTypes = types;
            if (types != 0) {
                this.mRouter.addCallback(types, this.mCallback, 8);
            }
            this.refreshRoute();
            if (this.mButton != null) {
                this.mButton.setRouteTypes(this.mRouteTypes);
            }
        }
    }

    private final void $$robo$$android_app_MediaRouteActionProvider$setExtendedSettingsClickListener(View.OnClickListener listener) {
        this.mExtendedSettingsListener = listener;
        if (this.mButton != null) {
            this.mButton.setExtendedSettingsClickListener(listener);
        }
    }

    private final View $$robo$$android_app_MediaRouteActionProvider$onCreateActionView() {
        throw new UnsupportedOperationException("Use onCreateActionView(MenuItem) instead.");
    }

    private final View $$robo$$android_app_MediaRouteActionProvider$onCreateActionView(MenuItem item) {
        if (this.mButton != null) {
            Log.e("MediaRouteActionProvider", "onCreateActionView: this ActionProvider is already associated with a menu item. Don't reuse MediaRouteActionProvider instances! Abandoning the old one...");
        }
        this.mButton = new MediaRouteButton(this.mContext);
        this.mButton.setCheatSheetEnabled(true);
        this.mButton.setRouteTypes(this.mRouteTypes);
        this.mButton.setExtendedSettingsClickListener(this.mExtendedSettingsListener);
        this.mButton.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        return this.mButton;
    }

    private final boolean $$robo$$android_app_MediaRouteActionProvider$onPerformDefaultAction() {
        if (this.mButton != null) {
            return this.mButton.showDialogInternal();
        }
        return false;
    }

    private final boolean $$robo$$android_app_MediaRouteActionProvider$overridesItemVisibility() {
        return true;
    }

    private final boolean $$robo$$android_app_MediaRouteActionProvider$isVisible() {
        return this.mRouter.isRouteAvailable(this.mRouteTypes, 1);
    }

    private final void $$robo$$android_app_MediaRouteActionProvider$refreshRoute() {
        this.refreshVisibility();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_MediaRouteActionProvider$__constructor__(context);
    }

    public MediaRouteActionProvider(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteActionProvider$__constructor__(android.content.Context ), 0, this, context);
    }

    public void setRouteTypes(int n) {
        InvokeDynamicSupport.bootstrap("setRouteTypes", $$robo$$android_app_MediaRouteActionProvider$setRouteTypes(int ), 0, this, n);
    }

    public void setExtendedSettingsClickListener(View.OnClickListener onClickListener) {
        InvokeDynamicSupport.bootstrap("setExtendedSettingsClickListener", $$robo$$android_app_MediaRouteActionProvider$setExtendedSettingsClickListener(android.view.View$OnClickListener ), 0, this, onClickListener);
    }

    @Override
    public View onCreateActionView() {
        return InvokeDynamicSupport.bootstrap("onCreateActionView", $$robo$$android_app_MediaRouteActionProvider$onCreateActionView(), 0, this);
    }

    @Override
    public View onCreateActionView(MenuItem menuItem) {
        return InvokeDynamicSupport.bootstrap("onCreateActionView", $$robo$$android_app_MediaRouteActionProvider$onCreateActionView(android.view.MenuItem ), 0, this, menuItem);
    }

    @Override
    public boolean onPerformDefaultAction() {
        return (boolean)InvokeDynamicSupport.bootstrap("onPerformDefaultAction", $$robo$$android_app_MediaRouteActionProvider$onPerformDefaultAction(), 0, this);
    }

    @Override
    public boolean overridesItemVisibility() {
        return (boolean)InvokeDynamicSupport.bootstrap("overridesItemVisibility", $$robo$$android_app_MediaRouteActionProvider$overridesItemVisibility(), 0, this);
    }

    @Override
    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_app_MediaRouteActionProvider$isVisible(), 0, this);
    }

    private void refreshRoute() {
        InvokeDynamicSupport.bootstrap("refreshRoute", $$robo$$android_app_MediaRouteActionProvider$refreshRoute(), 0, this);
    }

    public /* synthetic */ MediaRouteActionProvider() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouteActionProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class MediaRouterCallback
    extends MediaRouter.SimpleCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<MediaRouteActionProvider> mProviderWeak;

        private void $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$__constructor__(MediaRouteActionProvider provider) {
            this.mProviderWeak = new WeakReference<MediaRouteActionProvider>(provider);
        }

        private final void $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            this.refreshRoute(router);
        }

        private final void $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            this.refreshRoute(router);
        }

        private final void $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            this.refreshRoute(router);
        }

        private final void $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$refreshRoute(MediaRouter router) {
            MediaRouteActionProvider provider = (MediaRouteActionProvider)this.mProviderWeak.get();
            if (provider != null) {
                provider.refreshRoute();
            } else {
                router.removeCallback(this);
            }
        }

        private void __constructor__(MediaRouteActionProvider mediaRouteActionProvider) {
            this.$$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$__constructor__(mediaRouteActionProvider);
        }

        public MediaRouterCallback(MediaRouteActionProvider mediaRouteActionProvider) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$__constructor__(android.app.MediaRouteActionProvider ), 0, this, mediaRouteActionProvider);
        }

        @Override
        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteAdded", $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$onRouteAdded(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteRemoved", $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$onRouteRemoved(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteChanged", $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$onRouteChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        private void refreshRoute(MediaRouter mediaRouter) {
            InvokeDynamicSupport.bootstrap("refreshRoute", $$robo$$android_app_MediaRouteActionProvider_MediaRouterCallback$refreshRoute(android.media.MediaRouter ), 0, this, mediaRouter);
        }

        public /* synthetic */ MediaRouterCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouterCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

