/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.MathUtils;
import android.widget.RemoteViews;
import com.android.internal.util.NotificationColorUtil;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Notification
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Notification";
    public static String INTENT_CATEGORY_NOTIFICATION_PREFERENCES = "android.intent.category.NOTIFICATION_PREFERENCES";
    public static int DEFAULT_ALL = -1;
    public static int DEFAULT_SOUND = 1;
    public static int DEFAULT_VIBRATE = 2;
    public static int DEFAULT_LIGHTS = 4;
    private static int MAX_CHARSEQUENCE_LENGTH = 5120;
    public long when;
    public int icon;
    public int iconLevel;
    public int number;
    public PendingIntent contentIntent;
    public PendingIntent deleteIntent;
    public PendingIntent fullScreenIntent;
    public CharSequence tickerText;
    @Deprecated
    public RemoteViews tickerView;
    public RemoteViews contentView;
    public RemoteViews bigContentView;
    public RemoteViews headsUpContentView;
    public Bitmap largeIcon;
    public Uri sound;
    @Deprecated
    public static int STREAM_DEFAULT = -1;
    @Deprecated
    public int audioStreamType;
    public static AudioAttributes AUDIO_ATTRIBUTES_DEFAULT;
    public AudioAttributes audioAttributes;
    public long[] vibrate;
    public int ledARGB;
    public int ledOnMS;
    public int ledOffMS;
    public int defaults;
    public static int FLAG_SHOW_LIGHTS = 1;
    public static int FLAG_ONGOING_EVENT = 2;
    public static int FLAG_INSISTENT = 4;
    public static int FLAG_ONLY_ALERT_ONCE = 8;
    public static int FLAG_AUTO_CANCEL = 16;
    public static int FLAG_NO_CLEAR = 32;
    public static int FLAG_FOREGROUND_SERVICE = 64;
    public static int FLAG_HIGH_PRIORITY = 128;
    public static int FLAG_LOCAL_ONLY = 256;
    public static int FLAG_GROUP_SUMMARY = 512;
    public int flags;
    public static int PRIORITY_DEFAULT = 0;
    public static int PRIORITY_LOW = -1;
    public static int PRIORITY_MIN = -2;
    public static int PRIORITY_HIGH = 1;
    public static int PRIORITY_MAX = 2;
    public int priority;
    public int color;
    public static int COLOR_DEFAULT = 0;
    public int visibility;
    public static int VISIBILITY_PUBLIC = 1;
    public static int VISIBILITY_PRIVATE = 0;
    public static int VISIBILITY_SECRET = -1;
    public static String CATEGORY_CALL = "call";
    public static String CATEGORY_MESSAGE = "msg";
    public static String CATEGORY_EMAIL = "email";
    public static String CATEGORY_EVENT = "event";
    public static String CATEGORY_PROMO = "promo";
    public static String CATEGORY_ALARM = "alarm";
    public static String CATEGORY_PROGRESS = "progress";
    public static String CATEGORY_SOCIAL = "social";
    public static String CATEGORY_ERROR = "err";
    public static String CATEGORY_TRANSPORT = "transport";
    public static String CATEGORY_SYSTEM = "sys";
    public static String CATEGORY_SERVICE = "service";
    public static String CATEGORY_RECOMMENDATION = "recommendation";
    public static String CATEGORY_STATUS = "status";
    public String category;
    private String mGroupKey;
    private String mSortKey;
    public Bundle extras;
    public static String EXTRA_TITLE = "android.title";
    public static String EXTRA_TITLE_BIG = "android.title.big";
    public static String EXTRA_TEXT = "android.text";
    public static String EXTRA_SUB_TEXT = "android.subText";
    public static String EXTRA_INFO_TEXT = "android.infoText";
    public static String EXTRA_SUMMARY_TEXT = "android.summaryText";
    public static String EXTRA_BIG_TEXT = "android.bigText";
    public static String EXTRA_SMALL_ICON = "android.icon";
    public static String EXTRA_LARGE_ICON = "android.largeIcon";
    public static String EXTRA_LARGE_ICON_BIG = "android.largeIcon.big";
    public static String EXTRA_PROGRESS = "android.progress";
    public static String EXTRA_PROGRESS_MAX = "android.progressMax";
    public static String EXTRA_PROGRESS_INDETERMINATE = "android.progressIndeterminate";
    public static String EXTRA_SHOW_CHRONOMETER = "android.showChronometer";
    public static String EXTRA_SHOW_WHEN = "android.showWhen";
    public static String EXTRA_PICTURE = "android.picture";
    public static String EXTRA_TEXT_LINES = "android.textLines";
    public static String EXTRA_TEMPLATE = "android.template";
    public static String EXTRA_PEOPLE = "android.people";
    public static String EXTRA_AS_HEADS_UP = "headsup";
    public static String EXTRA_ALLOW_DURING_SETUP = "android.allowDuringSetup";
    public static String EXTRA_BACKGROUND_IMAGE_URI = "android.backgroundImageUri";
    public static String EXTRA_MEDIA_SESSION = "android.mediaSession";
    public static String EXTRA_COMPACT_ACTIONS = "android.compactActions";
    public static String EXTRA_ORIGINATING_USERID = "android.originatingUserId";
    public static int HEADS_UP_NEVER = 0;
    public static int HEADS_UP_ALLOWED = 1;
    public static int HEADS_UP_REQUESTED = 2;
    public Action[] actions;
    public Notification publicVersion;
    public static Parcelable.Creator<Notification> CREATOR;

    private final String $$robo$$android_app_Notification$getGroup() {
        return this.mGroupKey;
    }

    private final String $$robo$$android_app_Notification$getSortKey() {
        return this.mSortKey;
    }

    private void $$robo$$android_app_Notification$__constructor__() {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        this.when = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.priority = 0;
    }

    private void $$robo$$android_app_Notification$__constructor__(Context context, int icon, CharSequence tickerText, long when, CharSequence contentTitle, CharSequence contentText, Intent contentIntent) {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        this.when = when;
        this.icon = icon;
        this.tickerText = tickerText;
        this.setLatestEventInfo(context, contentTitle, contentText, PendingIntent.getActivity(context, 0, contentIntent, 0));
    }

    @Deprecated
    private void $$robo$$android_app_Notification$__constructor__(int icon, CharSequence tickerText, long when) {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        this.icon = icon;
        this.tickerText = tickerText;
        this.when = when;
    }

    private void $$robo$$android_app_Notification$__constructor__(Parcel parcel) {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        int version = parcel.readInt();
        this.when = parcel.readLong();
        this.icon = parcel.readInt();
        this.number = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.contentIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.deleteIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.contentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.largeIcon = Bitmap.CREATOR.createFromParcel(parcel);
        }
        this.defaults = parcel.readInt();
        this.flags = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.sound = Uri.CREATOR.createFromParcel(parcel);
        }
        this.audioStreamType = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.audioAttributes = AudioAttributes.CREATOR.createFromParcel(parcel);
        }
        this.vibrate = parcel.createLongArray();
        this.ledARGB = parcel.readInt();
        this.ledOnMS = parcel.readInt();
        this.ledOffMS = parcel.readInt();
        this.iconLevel = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.fullScreenIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        this.priority = parcel.readInt();
        this.category = parcel.readString();
        this.mGroupKey = parcel.readString();
        this.mSortKey = parcel.readString();
        this.extras = parcel.readBundle();
        this.actions = parcel.createTypedArray(Action.CREATOR);
        if (parcel.readInt() != 0) {
            this.bigContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.headsUpContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        this.visibility = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.publicVersion = CREATOR.createFromParcel(parcel);
        }
        this.color = parcel.readInt();
    }

    private final Notification $$robo$$android_app_Notification$clone() {
        Notification that = new Notification();
        this.cloneInto(that, true);
        return that;
    }

    private final void $$robo$$android_app_Notification$cloneInto(Notification that, boolean heavy) {
        long[] vibrate;
        that.when = this.when;
        that.icon = this.icon;
        that.number = this.number;
        that.contentIntent = this.contentIntent;
        that.deleteIntent = this.deleteIntent;
        that.fullScreenIntent = this.fullScreenIntent;
        if (this.tickerText != null) {
            that.tickerText = this.tickerText.toString();
        }
        if (heavy && this.tickerView != null) {
            that.tickerView = this.tickerView.clone();
        }
        if (heavy && this.contentView != null) {
            that.contentView = this.contentView.clone();
        }
        if (heavy && this.largeIcon != null) {
            that.largeIcon = Bitmap.createBitmap(this.largeIcon);
        }
        that.iconLevel = this.iconLevel;
        that.sound = this.sound;
        that.audioStreamType = this.audioStreamType;
        if (this.audioAttributes != null) {
            that.audioAttributes = new AudioAttributes.Builder(this.audioAttributes).build();
        }
        if ((vibrate = this.vibrate) != null) {
            int N = vibrate.length;
            that.vibrate = new long[N];
            long[] vib = that.vibrate;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])vibrate, (int)0, (long[])vib, (int)0, (int)N);
        }
        that.ledARGB = this.ledARGB;
        that.ledOnMS = this.ledOnMS;
        that.ledOffMS = this.ledOffMS;
        that.defaults = this.defaults;
        that.flags = this.flags;
        that.priority = this.priority;
        that.category = this.category;
        that.mGroupKey = this.mGroupKey;
        that.mSortKey = this.mSortKey;
        if (this.extras != null) {
            try {
                that.extras = new Bundle(this.extras);
                that.extras.size();
            }
            catch (BadParcelableException e) {
                Log.e("Notification", "could not unparcel extras from notification: " + this, e);
                that.extras = null;
            }
        }
        if (this.actions != null) {
            that.actions = new Action[this.actions.length];
            for (int i = 0; i < this.actions.length; ++i) {
                that.actions[i] = this.actions[i].clone();
            }
        }
        if (heavy && this.bigContentView != null) {
            that.bigContentView = this.bigContentView.clone();
        }
        if (heavy && this.headsUpContentView != null) {
            that.headsUpContentView = this.headsUpContentView.clone();
        }
        that.visibility = this.visibility;
        if (this.publicVersion != null) {
            that.publicVersion = new Notification();
            this.publicVersion.cloneInto(that.publicVersion, heavy);
        }
        that.color = this.color;
        if (!heavy) {
            that.lightenPayload();
        }
    }

    private final void $$robo$$android_app_Notification$lightenPayload() {
        this.tickerView = null;
        this.contentView = null;
        this.bigContentView = null;
        this.headsUpContentView = null;
        this.largeIcon = null;
        if (this.extras != null) {
            this.extras.remove("android.largeIcon");
            this.extras.remove("android.largeIcon.big");
            this.extras.remove("android.picture");
            this.extras.remove("android.bigText");
            this.extras.remove("android.rebuild");
        }
    }

    private static final CharSequence $$robo$$android_app_Notification$safeCharSequence(CharSequence cs) {
        if (cs == null) {
            return cs;
        }
        if (cs.length() > 5120) {
            cs = cs.subSequence(0, 5120);
        }
        if (cs instanceof Parcelable) {
            Log.e("Notification", "warning: " + cs.getClass().getCanonicalName() + " instance is a custom Parcelable and not allowed in Notification");
            return cs.toString();
        }
        return cs;
    }

    private final int $$robo$$android_app_Notification$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_Notification$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(1);
        parcel.writeLong(this.when);
        parcel.writeInt(this.icon);
        parcel.writeInt(this.number);
        if (this.contentIntent != null) {
            parcel.writeInt(1);
            this.contentIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.deleteIntent != null) {
            parcel.writeInt(1);
            this.deleteIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.tickerText, parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerView != null) {
            parcel.writeInt(1);
            this.tickerView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.contentView != null) {
            parcel.writeInt(1);
            this.contentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.largeIcon != null) {
            parcel.writeInt(1);
            this.largeIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.defaults);
        parcel.writeInt(this.flags);
        if (this.sound != null) {
            parcel.writeInt(1);
            this.sound.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.audioStreamType);
        if (this.audioAttributes != null) {
            parcel.writeInt(1);
            this.audioAttributes.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLongArray(this.vibrate);
        parcel.writeInt(this.ledARGB);
        parcel.writeInt(this.ledOnMS);
        parcel.writeInt(this.ledOffMS);
        parcel.writeInt(this.iconLevel);
        if (this.fullScreenIntent != null) {
            parcel.writeInt(1);
            this.fullScreenIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.priority);
        parcel.writeString(this.category);
        parcel.writeString(this.mGroupKey);
        parcel.writeString(this.mSortKey);
        parcel.writeBundle(this.extras);
        parcel.writeTypedArray(this.actions, 0);
        if (this.bigContentView != null) {
            parcel.writeInt(1);
            this.bigContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.headsUpContentView != null) {
            parcel.writeInt(1);
            this.headsUpContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.visibility);
        if (this.publicVersion != null) {
            parcel.writeInt(1);
            this.publicVersion.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.color);
    }

    @Deprecated
    private final void $$robo$$android_app_Notification$setLatestEventInfo(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
        Builder builder = new Builder(context);
        builder.setWhen(this.when);
        builder.setSmallIcon(this.icon);
        builder.setPriority(this.priority);
        builder.setTicker(this.tickerText);
        builder.setNumber(this.number);
        builder.setColor(this.color);
        builder.mFlags = this.flags;
        builder.setSound(this.sound, this.audioStreamType);
        builder.setDefaults(this.defaults);
        builder.setVibrate(this.vibrate);
        if (contentTitle != null) {
            builder.setContentTitle(contentTitle);
        }
        if (contentText != null) {
            builder.setContentText(contentText);
        }
        builder.setContentIntent(contentIntent);
        builder.buildInto(this);
    }

    private final String $$robo$$android_app_Notification$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Notification(pri=");
        sb.append(this.priority);
        sb.append(" contentView=");
        if (this.contentView != null) {
            sb.append(this.contentView.getPackage());
            sb.append("/0x");
            sb.append(Integer.toHexString(this.contentView.getLayoutId()));
        } else {
            sb.append("null");
        }
        sb.append(" vibrate=");
        if ((this.defaults & 2) != 0) {
            sb.append("default");
        } else if (this.vibrate != null) {
            int N = this.vibrate.length - 1;
            sb.append("[");
            for (int i = 0; i < N; ++i) {
                sb.append(this.vibrate[i]);
                sb.append(',');
            }
            if (N != -1) {
                sb.append(this.vibrate[N]);
            }
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(" sound=");
        if ((this.defaults & 1) != 0) {
            sb.append("default");
        } else if (this.sound != null) {
            sb.append(this.sound.toString());
        } else {
            sb.append("null");
        }
        sb.append(" defaults=0x");
        sb.append(Integer.toHexString(this.defaults));
        sb.append(" flags=0x");
        sb.append(Integer.toHexString(this.flags));
        sb.append(String.format(" color=0x%08x", this.color));
        if (this.category != null) {
            sb.append(" category=");
            sb.append(this.category);
        }
        if (this.mGroupKey != null) {
            sb.append(" groupKey=");
            sb.append(this.mGroupKey);
        }
        if (this.mSortKey != null) {
            sb.append(" sortKey=");
            sb.append(this.mSortKey);
        }
        if (this.actions != null) {
            sb.append(" actions=");
            sb.append(this.actions.length);
        }
        sb.append(" vis=");
        sb.append(Notification.visibilityToString(this.visibility));
        if (this.publicVersion != null) {
            sb.append(" publicVersion=");
            sb.append(this.publicVersion.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    private static final String $$robo$$android_app_Notification$visibilityToString(int vis) {
        switch (vis) {
            case 0: {
                return "PRIVATE";
            }
            case 1: {
                return "PUBLIC";
            }
            case -1: {
                return "SECRET";
            }
        }
        return "UNKNOWN(" + String.valueOf(vis) + ")";
    }

    private final boolean $$robo$$android_app_Notification$isValid() {
        return this.contentView != null || this.extras.getBoolean("android.rebuild.contentView");
    }

    private final boolean $$robo$$android_app_Notification$isGroupSummary() {
        return this.mGroupKey != null && (this.flags & 0x200) != 0;
    }

    private final boolean $$robo$$android_app_Notification$isGroupChild() {
        return this.mGroupKey != null && (this.flags & 0x200) == 0;
    }

    private static final Notification[] $$robo$$android_app_Notification$getNotificationArrayFromBundle(Bundle bundle, String key) {
        Parcelable[] array2 = bundle.getParcelableArray(key);
        if (array2 instanceof Notification[] || array2 == null) {
            return (Notification[])array2;
        }
        Parcelable[] typedArray = (Notification[])Arrays.copyOf(array2, array2.length, Notification[].class);
        bundle.putParcelableArray(key, typedArray);
        return typedArray;
    }

    static void __staticInitializer__() {
        AUDIO_ATTRIBUTES_DEFAULT = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
        CREATOR = new Parcelable.Creator<Notification>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_Notification_1$__constructor__() {
            }

            private final Notification $$robo$$android_app_Notification_1$createFromParcel(Parcel parcel) {
                return new Notification(parcel);
            }

            private final Notification[] $$robo$$android_app_Notification_1$newArray(int size) {
                return new Notification[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_Notification_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_1$__constructor__(), 0, this);
            }

            @Override
            public Notification createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_Notification_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Notification[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_Notification_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public String getGroup() {
        return InvokeDynamicSupport.bootstrap("getGroup", $$robo$$android_app_Notification$getGroup(), 0, this);
    }

    public String getSortKey() {
        return InvokeDynamicSupport.bootstrap("getSortKey", $$robo$$android_app_Notification$getSortKey(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_app_Notification$__constructor__();
    }

    public Notification() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, int n, CharSequence charSequence, long l, CharSequence charSequence2, CharSequence charSequence3, Intent intent) {
        this.$$robo$$android_app_Notification$__constructor__(context, n, charSequence, l, charSequence2, charSequence3, intent);
    }

    public Notification(Context context, int n, CharSequence charSequence, long l, CharSequence charSequence2, CharSequence charSequence3, Intent intent) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(android.content.Context int java.lang.CharSequence long java.lang.CharSequence java.lang.CharSequence android.content.Intent ), 0, this, context, n, charSequence, l, charSequence2, charSequence3, intent);
    }

    private void __constructor__(int n, CharSequence charSequence, long l) {
        this.$$robo$$android_app_Notification$__constructor__(n, charSequence, l);
    }

    public Notification(int n, CharSequence charSequence, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(int java.lang.CharSequence long ), 0, this, n, charSequence, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_Notification$__constructor__(parcel);
    }

    public Notification(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public Notification clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification$clone(), 0, this);
    }

    public void cloneInto(Notification notification, boolean bl) {
        InvokeDynamicSupport.bootstrap("cloneInto", $$robo$$android_app_Notification$cloneInto(android.app.Notification boolean ), 0, this, notification, bl);
    }

    public void lightenPayload() {
        InvokeDynamicSupport.bootstrap("lightenPayload", $$robo$$android_app_Notification$lightenPayload(), 0, this);
    }

    public static CharSequence safeCharSequence(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("safeCharSequence", $$robo$$android_app_Notification$safeCharSequence(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_Notification$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_Notification$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Deprecated
    public void setLatestEventInfo(Context context, CharSequence charSequence, CharSequence charSequence2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setLatestEventInfo", $$robo$$android_app_Notification$setLatestEventInfo(android.content.Context java.lang.CharSequence java.lang.CharSequence android.app.PendingIntent ), 0, this, context, charSequence, charSequence2, pendingIntent);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_Notification$toString(), 0, this);
    }

    public static String visibilityToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("visibilityToString", $$robo$$android_app_Notification$visibilityToString(int ), 0, (int)n);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_app_Notification$isValid(), 0, this);
    }

    public boolean isGroupSummary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupSummary", $$robo$$android_app_Notification$isGroupSummary(), 0, this);
    }

    public boolean isGroupChild() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupChild", $$robo$$android_app_Notification$isGroupChild(), 0, this);
    }

    private static Notification[] getNotificationArrayFromBundle(Bundle bundle, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getNotificationArrayFromBundle", $$robo$$android_app_Notification$getNotificationArrayFromBundle(android.os.Bundle java.lang.String ), 0, (Bundle)bundle, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Notification.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Notification)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BuilderRemoteViews
    extends RemoteViews
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(Parcel parcel) {
        }

        private void $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(ApplicationInfo appInfo, int layoutId) {
        }

        private final BuilderRemoteViews $$robo$$android_app_Notification_BuilderRemoteViews$clone() {
            Parcel p = Parcel.obtain();
            this.writeToParcel(p, 0);
            p.setDataPosition(0);
            BuilderRemoteViews brv = new BuilderRemoteViews(p);
            p.recycle();
            return brv;
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(parcel);
        }

        public BuilderRemoteViews(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(ApplicationInfo applicationInfo, int n) {
            this.$$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(applicationInfo, n);
        }

        public BuilderRemoteViews(ApplicationInfo applicationInfo, int n) {
            super(applicationInfo, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(android.content.pm.ApplicationInfo int ), 0, this, applicationInfo, n);
        }

        @Override
        public BuilderRemoteViews clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_BuilderRemoteViews$clone(), 0, this);
        }

        public /* synthetic */ BuilderRemoteViews() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BuilderRemoteViews)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class WearableExtender
    implements Extender,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int UNSET_ACTION_INDEX = -1;
        public static int SIZE_DEFAULT = 0;
        public static int SIZE_XSMALL = 1;
        public static int SIZE_SMALL = 2;
        public static int SIZE_MEDIUM = 3;
        public static int SIZE_LARGE = 4;
        public static int SIZE_FULL_SCREEN = 5;
        private static String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
        private static String KEY_ACTIONS = "actions";
        private static String KEY_FLAGS = "flags";
        private static String KEY_DISPLAY_INTENT = "displayIntent";
        private static String KEY_PAGES = "pages";
        private static String KEY_BACKGROUND = "background";
        private static String KEY_CONTENT_ICON = "contentIcon";
        private static String KEY_CONTENT_ICON_GRAVITY = "contentIconGravity";
        private static String KEY_CONTENT_ACTION_INDEX = "contentActionIndex";
        private static String KEY_CUSTOM_SIZE_PRESET = "customSizePreset";
        private static String KEY_CUSTOM_CONTENT_HEIGHT = "customContentHeight";
        private static String KEY_GRAVITY = "gravity";
        private static int FLAG_CONTENT_INTENT_AVAILABLE_OFFLINE = 1;
        private static int FLAG_HINT_HIDE_ICON = 2;
        private static int FLAG_HINT_SHOW_BACKGROUND_ONLY = 4;
        private static int FLAG_START_SCROLL_BOTTOM = 8;
        private static int DEFAULT_FLAGS = 1;
        private static int DEFAULT_CONTENT_ICON_GRAVITY = 0x800005;
        private static int DEFAULT_GRAVITY = 80;
        private ArrayList<Action> mActions;
        private int mFlags;
        private PendingIntent mDisplayIntent;
        private ArrayList<Notification> mPages;
        private Bitmap mBackground;
        private int mContentIcon;
        private int mContentIconGravity;
        private int mContentActionIndex;
        private int mCustomSizePreset;
        private int mCustomContentHeight;
        private int mGravity;

        private void $$robo$$android_app_Notification_WearableExtender$__constructor__() {
            this.mActions = new ArrayList();
            this.mFlags = 1;
            this.mPages = new ArrayList();
            this.mContentIconGravity = 0x800005;
            this.mContentActionIndex = -1;
            this.mCustomSizePreset = 0;
            this.mGravity = 80;
        }

        private void $$robo$$android_app_Notification_WearableExtender$__constructor__(Notification notif) {
            this.mActions = new ArrayList();
            this.mFlags = 1;
            this.mPages = new ArrayList();
            this.mContentIconGravity = 0x800005;
            this.mContentActionIndex = -1;
            this.mCustomSizePreset = 0;
            this.mGravity = 80;
            Bundle wearableBundle = notif.extras.getBundle("android.wearable.EXTENSIONS");
            if (wearableBundle != null) {
                ArrayList actions = wearableBundle.getParcelableArrayList("actions");
                if (actions != null) {
                    this.mActions.addAll(actions);
                }
                this.mFlags = wearableBundle.getInt("flags", 1);
                this.mDisplayIntent = (PendingIntent)wearableBundle.getParcelable("displayIntent");
                Notification[] pages = Notification.getNotificationArrayFromBundle(wearableBundle, "pages");
                if (pages != null) {
                    Collections.addAll(this.mPages, pages);
                }
                this.mBackground = (Bitmap)wearableBundle.getParcelable("background");
                this.mContentIcon = wearableBundle.getInt("contentIcon");
                this.mContentIconGravity = wearableBundle.getInt("contentIconGravity", 0x800005);
                this.mContentActionIndex = wearableBundle.getInt("contentActionIndex", -1);
                this.mCustomSizePreset = wearableBundle.getInt("customSizePreset", 0);
                this.mCustomContentHeight = wearableBundle.getInt("customContentHeight");
                this.mGravity = wearableBundle.getInt("gravity", 80);
            }
        }

        private final Builder $$robo$$android_app_Notification_WearableExtender$extend(Builder builder) {
            Bundle wearableBundle = new Bundle();
            if (!this.mActions.isEmpty()) {
                wearableBundle.putParcelableArrayList("actions", this.mActions);
            }
            if (this.mFlags != 1) {
                wearableBundle.putInt("flags", this.mFlags);
            }
            if (this.mDisplayIntent != null) {
                wearableBundle.putParcelable("displayIntent", this.mDisplayIntent);
            }
            if (!this.mPages.isEmpty()) {
                wearableBundle.putParcelableArray("pages", this.mPages.toArray(new Notification[this.mPages.size()]));
            }
            if (this.mBackground != null) {
                wearableBundle.putParcelable("background", this.mBackground);
            }
            if (this.mContentIcon != 0) {
                wearableBundle.putInt("contentIcon", this.mContentIcon);
            }
            if (this.mContentIconGravity != 0x800005) {
                wearableBundle.putInt("contentIconGravity", this.mContentIconGravity);
            }
            if (this.mContentActionIndex != -1) {
                wearableBundle.putInt("contentActionIndex", this.mContentActionIndex);
            }
            if (this.mCustomSizePreset != 0) {
                wearableBundle.putInt("customSizePreset", this.mCustomSizePreset);
            }
            if (this.mCustomContentHeight != 0) {
                wearableBundle.putInt("customContentHeight", this.mCustomContentHeight);
            }
            if (this.mGravity != 80) {
                wearableBundle.putInt("gravity", this.mGravity);
            }
            builder.getExtras().putBundle("android.wearable.EXTENSIONS", wearableBundle);
            return builder;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$clone() {
            WearableExtender that = new WearableExtender();
            that.mActions = new ArrayList<Action>(this.mActions);
            that.mFlags = this.mFlags;
            that.mDisplayIntent = this.mDisplayIntent;
            that.mPages = new ArrayList<Notification>(this.mPages);
            that.mBackground = this.mBackground;
            that.mContentIcon = this.mContentIcon;
            that.mContentIconGravity = this.mContentIconGravity;
            that.mContentActionIndex = this.mContentActionIndex;
            that.mCustomSizePreset = this.mCustomSizePreset;
            that.mCustomContentHeight = this.mCustomContentHeight;
            that.mGravity = this.mGravity;
            return that;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addActions(List<Action> actions) {
            this.mActions.addAll(actions);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$clearActions() {
            this.mActions.clear();
            return this;
        }

        private final List<Action> $$robo$$android_app_Notification_WearableExtender$getActions() {
            return this.mActions;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setDisplayIntent(PendingIntent intent) {
            this.mDisplayIntent = intent;
            return this;
        }

        private final PendingIntent $$robo$$android_app_Notification_WearableExtender$getDisplayIntent() {
            return this.mDisplayIntent;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addPage(Notification page) {
            this.mPages.add(page);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addPages(List<Notification> pages) {
            this.mPages.addAll(pages);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$clearPages() {
            this.mPages.clear();
            return this;
        }

        private final List<Notification> $$robo$$android_app_Notification_WearableExtender$getPages() {
            return this.mPages;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setBackground(Bitmap background) {
            this.mBackground = background;
            return this;
        }

        private final Bitmap $$robo$$android_app_Notification_WearableExtender$getBackground() {
            return this.mBackground;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentIcon(int icon) {
            this.mContentIcon = icon;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getContentIcon() {
            return this.mContentIcon;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentIconGravity(int contentIconGravity) {
            this.mContentIconGravity = contentIconGravity;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getContentIconGravity() {
            return this.mContentIconGravity;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentAction(int actionIndex) {
            this.mContentActionIndex = actionIndex;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getContentAction() {
            return this.mContentActionIndex;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setGravity(int gravity) {
            this.mGravity = gravity;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getGravity() {
            return this.mGravity;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setCustomSizePreset(int sizePreset) {
            this.mCustomSizePreset = sizePreset;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getCustomSizePreset() {
            return this.mCustomSizePreset;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setCustomContentHeight(int height) {
            this.mCustomContentHeight = height;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getCustomContentHeight() {
            return this.mCustomContentHeight;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setStartScrollBottom(boolean startScrollBottom) {
            this.setFlag(8, startScrollBottom);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getStartScrollBottom() {
            return (this.mFlags & 8) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentIntentAvailableOffline(boolean contentIntentAvailableOffline) {
            this.setFlag(1, contentIntentAvailableOffline);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getContentIntentAvailableOffline() {
            return (this.mFlags & 1) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintHideIcon(boolean hintHideIcon) {
            this.setFlag(2, hintHideIcon);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintHideIcon() {
            return (this.mFlags & 2) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintShowBackgroundOnly(boolean hintShowBackgroundOnly) {
            this.setFlag(4, hintShowBackgroundOnly);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintShowBackgroundOnly() {
            return (this.mFlags & 4) != 0;
        }

        private final void $$robo$$android_app_Notification_WearableExtender$setFlag(int mask, boolean value) {
            this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_WearableExtender$__constructor__();
        }

        public WearableExtender() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_WearableExtender$__constructor__(), 0, this);
        }

        private void __constructor__(Notification notification) {
            this.$$robo$$android_app_Notification_WearableExtender$__constructor__(notification);
        }

        public WearableExtender(Notification notification) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_WearableExtender$__constructor__(android.app.Notification ), 0, this, notification);
        }

        @Override
        public Builder extend(Builder builder) {
            return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_WearableExtender$extend(android.app.Notification$Builder ), 0, this, builder);
        }

        public WearableExtender clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_WearableExtender$clone(), 0, this);
        }

        public WearableExtender addAction(Action action) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_Notification_WearableExtender$addAction(android.app.Notification$Action ), 0, this, action);
        }

        public WearableExtender addActions(List<Action> list) {
            return InvokeDynamicSupport.bootstrap("addActions", $$robo$$android_app_Notification_WearableExtender$addActions(java.util.List<android.app.Notification$Action> ), 0, this, list);
        }

        public WearableExtender clearActions() {
            return InvokeDynamicSupport.bootstrap("clearActions", $$robo$$android_app_Notification_WearableExtender$clearActions(), 0, this);
        }

        public List<Action> getActions() {
            return InvokeDynamicSupport.bootstrap("getActions", $$robo$$android_app_Notification_WearableExtender$getActions(), 0, this);
        }

        public WearableExtender setDisplayIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setDisplayIntent", $$robo$$android_app_Notification_WearableExtender$setDisplayIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public PendingIntent getDisplayIntent() {
            return InvokeDynamicSupport.bootstrap("getDisplayIntent", $$robo$$android_app_Notification_WearableExtender$getDisplayIntent(), 0, this);
        }

        public WearableExtender addPage(Notification notification) {
            return InvokeDynamicSupport.bootstrap("addPage", $$robo$$android_app_Notification_WearableExtender$addPage(android.app.Notification ), 0, this, notification);
        }

        public WearableExtender addPages(List<Notification> list) {
            return InvokeDynamicSupport.bootstrap("addPages", $$robo$$android_app_Notification_WearableExtender$addPages(java.util.List<android.app.Notification> ), 0, this, list);
        }

        public WearableExtender clearPages() {
            return InvokeDynamicSupport.bootstrap("clearPages", $$robo$$android_app_Notification_WearableExtender$clearPages(), 0, this);
        }

        public List<Notification> getPages() {
            return InvokeDynamicSupport.bootstrap("getPages", $$robo$$android_app_Notification_WearableExtender$getPages(), 0, this);
        }

        public WearableExtender setBackground(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("setBackground", $$robo$$android_app_Notification_WearableExtender$setBackground(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Bitmap getBackground() {
            return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_app_Notification_WearableExtender$getBackground(), 0, this);
        }

        public WearableExtender setContentIcon(int n) {
            return InvokeDynamicSupport.bootstrap("setContentIcon", $$robo$$android_app_Notification_WearableExtender$setContentIcon(int ), 0, this, n);
        }

        public int getContentIcon() {
            return (int)InvokeDynamicSupport.bootstrap("getContentIcon", $$robo$$android_app_Notification_WearableExtender$getContentIcon(), 0, this);
        }

        public WearableExtender setContentIconGravity(int n) {
            return InvokeDynamicSupport.bootstrap("setContentIconGravity", $$robo$$android_app_Notification_WearableExtender$setContentIconGravity(int ), 0, this, n);
        }

        public int getContentIconGravity() {
            return (int)InvokeDynamicSupport.bootstrap("getContentIconGravity", $$robo$$android_app_Notification_WearableExtender$getContentIconGravity(), 0, this);
        }

        public WearableExtender setContentAction(int n) {
            return InvokeDynamicSupport.bootstrap("setContentAction", $$robo$$android_app_Notification_WearableExtender$setContentAction(int ), 0, this, n);
        }

        public int getContentAction() {
            return (int)InvokeDynamicSupport.bootstrap("getContentAction", $$robo$$android_app_Notification_WearableExtender$getContentAction(), 0, this);
        }

        public WearableExtender setGravity(int n) {
            return InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_app_Notification_WearableExtender$setGravity(int ), 0, this, n);
        }

        public int getGravity() {
            return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_app_Notification_WearableExtender$getGravity(), 0, this);
        }

        public WearableExtender setCustomSizePreset(int n) {
            return InvokeDynamicSupport.bootstrap("setCustomSizePreset", $$robo$$android_app_Notification_WearableExtender$setCustomSizePreset(int ), 0, this, n);
        }

        public int getCustomSizePreset() {
            return (int)InvokeDynamicSupport.bootstrap("getCustomSizePreset", $$robo$$android_app_Notification_WearableExtender$getCustomSizePreset(), 0, this);
        }

        public WearableExtender setCustomContentHeight(int n) {
            return InvokeDynamicSupport.bootstrap("setCustomContentHeight", $$robo$$android_app_Notification_WearableExtender$setCustomContentHeight(int ), 0, this, n);
        }

        public int getCustomContentHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getCustomContentHeight", $$robo$$android_app_Notification_WearableExtender$getCustomContentHeight(), 0, this);
        }

        public WearableExtender setStartScrollBottom(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setStartScrollBottom", $$robo$$android_app_Notification_WearableExtender$setStartScrollBottom(boolean ), 0, this, bl);
        }

        public boolean getStartScrollBottom() {
            return (boolean)InvokeDynamicSupport.bootstrap("getStartScrollBottom", $$robo$$android_app_Notification_WearableExtender$getStartScrollBottom(), 0, this);
        }

        public WearableExtender setContentIntentAvailableOffline(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setContentIntentAvailableOffline", $$robo$$android_app_Notification_WearableExtender$setContentIntentAvailableOffline(boolean ), 0, this, bl);
        }

        public boolean getContentIntentAvailableOffline() {
            return (boolean)InvokeDynamicSupport.bootstrap("getContentIntentAvailableOffline", $$robo$$android_app_Notification_WearableExtender$getContentIntentAvailableOffline(), 0, this);
        }

        public WearableExtender setHintHideIcon(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintHideIcon", $$robo$$android_app_Notification_WearableExtender$setHintHideIcon(boolean ), 0, this, bl);
        }

        public boolean getHintHideIcon() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintHideIcon", $$robo$$android_app_Notification_WearableExtender$getHintHideIcon(), 0, this);
        }

        public WearableExtender setHintShowBackgroundOnly(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintShowBackgroundOnly", $$robo$$android_app_Notification_WearableExtender$setHintShowBackgroundOnly(boolean ), 0, this, bl);
        }

        public boolean getHintShowBackgroundOnly() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintShowBackgroundOnly", $$robo$$android_app_Notification_WearableExtender$getHintShowBackgroundOnly(), 0, this);
        }

        private void setFlag(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_Notification_WearableExtender$setFlag(int boolean ), 0, this, n, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WearableExtender)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Extender
    extends InstrumentedInterface {
        public Builder extend(Builder var1);
    }

    public static class MediaStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int MAX_MEDIA_BUTTONS_IN_COMPACT = 3;
        static int MAX_MEDIA_BUTTONS = 5;
        private int[] mActionsToShowInCompact;
        private MediaSession.Token mToken;

        private void $$robo$$android_app_Notification_MediaStyle$__constructor__() {
            this.mActionsToShowInCompact = null;
        }

        private void $$robo$$android_app_Notification_MediaStyle$__constructor__(Builder builder) {
            this.mActionsToShowInCompact = null;
            this.setBuilder(builder);
        }

        private final MediaStyle $$robo$$android_app_Notification_MediaStyle$setShowActionsInCompactView(int ... actions) {
            this.mActionsToShowInCompact = actions;
            return this;
        }

        private final MediaStyle $$robo$$android_app_Notification_MediaStyle$setMediaSession(MediaSession.Token token) {
            this.mToken = token;
            return this;
        }

        private final Notification $$robo$$android_app_Notification_MediaStyle$buildStyled(Notification wip) {
            super.buildStyled(wip);
            if (wip.category == null) {
                wip.category = "transport";
            }
            return wip;
        }

        private final void $$robo$$android_app_Notification_MediaStyle$populateContentView(Notification wip) {
            this.mBuilder.setBuilderContentView(wip, this.makeMediaContentView());
        }

        private final void $$robo$$android_app_Notification_MediaStyle$populateBigContentView(Notification wip) {
            this.mBuilder.setBuilderBigContentView(wip, this.makeMediaBigContentView());
        }

        private final void $$robo$$android_app_Notification_MediaStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mToken != null) {
                extras.putParcelable("android.mediaSession", this.mToken);
            }
            if (this.mActionsToShowInCompact != null) {
                extras.putIntArray("android.compactActions", this.mActionsToShowInCompact);
            }
        }

        private final void $$robo$$android_app_Notification_MediaStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey("android.mediaSession")) {
                this.mToken = (MediaSession.Token)extras.getParcelable("android.mediaSession");
            }
            if (extras.containsKey("android.compactActions")) {
                this.mActionsToShowInCompact = extras.getIntArray("android.compactActions");
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$generateMediaActionButton(Action action) {
            boolean tombstone = action.actionIntent == null;
            RemoteViews button = new RemoteViews(this.mBuilder.mContext.getPackageName(), 17367158);
            button.setImageViewResource(16909101, action.icon);
            button.setDrawableParameters(16909101, false, -1, -1, PorterDuff.Mode.SRC_ATOP, -1);
            if (!tombstone) {
                button.setOnClickPendingIntent(16909101, action.actionIntent);
            }
            button.setContentDescription(16909101, action.title);
            return button;
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeMediaContentView() {
            int N;
            RemoteViews view = this.mBuilder.applyStandardTemplate(17367167, false);
            int numActions = this.mBuilder.mActions.size();
            int n = N = this.mActionsToShowInCompact == null ? 0 : Math.min(this.mActionsToShowInCompact.length, 3);
            if (N > 0) {
                view.removeAllViews(16909109);
                for (int i = 0; i < N; ++i) {
                    if (i >= numActions) {
                        throw new IllegalArgumentException(String.format("setShowActionsInCompactView: action %d out of bounds (max %d)", i, numActions - 1));
                    }
                    Action action = (Action)this.mBuilder.mActions.get(this.mActionsToShowInCompact[i]);
                    RemoteViews button = this.generateMediaActionButton(action);
                    view.addView(16909109, button);
                }
            }
            this.styleText(view);
            this.hideRightIcon(view);
            return view;
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeMediaBigContentView() {
            int actionCount = Math.min(this.mBuilder.mActions.size(), 5);
            RemoteViews big = this.mBuilder.applyStandardTemplate(this.getBigLayoutResource(actionCount), false);
            if (actionCount > 0) {
                big.removeAllViews(16909109);
                for (int i = 0; i < actionCount; ++i) {
                    RemoteViews button = this.generateMediaActionButton((Action)this.mBuilder.mActions.get(i));
                    big.addView(16909109, button);
                }
            }
            this.styleText(big);
            this.hideRightIcon(big);
            this.applyTopPadding(big);
            big.setViewVisibility(16908301, 8);
            return big;
        }

        private final int $$robo$$android_app_Notification_MediaStyle$getBigLayoutResource(int actionCount) {
            if (actionCount <= 3) {
                return 17367163;
            }
            return 17367162;
        }

        private final void $$robo$$android_app_Notification_MediaStyle$hideRightIcon(RemoteViews contentView) {
            contentView.setViewVisibility(16908340, 8);
        }

        private final void $$robo$$android_app_Notification_MediaStyle$styleText(RemoteViews contentView) {
            int primaryColor = this.mBuilder.mContext.getResources().getColor(17170513);
            int secondaryColor = this.mBuilder.mContext.getResources().getColor(17170514);
            contentView.setTextColor(16908310, primaryColor);
            if (this.mBuilder.showsTimeOrChronometer()) {
                if (this.mBuilder.mUseChronometer) {
                    contentView.setTextColor(16909121, secondaryColor);
                } else {
                    contentView.setTextColor(16908415, secondaryColor);
                }
            }
            contentView.setTextColor(16908309, secondaryColor);
            contentView.setTextColor(16908392, secondaryColor);
            contentView.setTextColor(16909125, secondaryColor);
        }

        private final boolean $$robo$$android_app_Notification_MediaStyle$hasProgress() {
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_MediaStyle$__constructor__();
        }

        public MediaStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MediaStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_MediaStyle$__constructor__(builder);
        }

        public MediaStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MediaStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public MediaStyle setShowActionsInCompactView(int ... nArray) {
            return InvokeDynamicSupport.bootstrap("setShowActionsInCompactView", $$robo$$android_app_Notification_MediaStyle$setShowActionsInCompactView(int[] ), 0, this, nArray);
        }

        public MediaStyle setMediaSession(MediaSession.Token token) {
            return InvokeDynamicSupport.bootstrap("setMediaSession", $$robo$$android_app_Notification_MediaStyle$setMediaSession(android.media.session.MediaSession$Token ), 0, this, token);
        }

        @Override
        public Notification buildStyled(Notification notification) {
            return InvokeDynamicSupport.bootstrap("buildStyled", $$robo$$android_app_Notification_MediaStyle$buildStyled(android.app.Notification ), 0, this, notification);
        }

        @Override
        public void populateContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateContentView", $$robo$$android_app_Notification_MediaStyle$populateContentView(android.app.Notification ), 0, this, notification);
        }

        @Override
        public void populateBigContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateBigContentView", $$robo$$android_app_Notification_MediaStyle$populateBigContentView(android.app.Notification ), 0, this, notification);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_MediaStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_MediaStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        private RemoteViews generateMediaActionButton(Action action) {
            return InvokeDynamicSupport.bootstrap("generateMediaActionButton", $$robo$$android_app_Notification_MediaStyle$generateMediaActionButton(android.app.Notification$Action ), 0, this, action);
        }

        private RemoteViews makeMediaContentView() {
            return InvokeDynamicSupport.bootstrap("makeMediaContentView", $$robo$$android_app_Notification_MediaStyle$makeMediaContentView(), 0, this);
        }

        private RemoteViews makeMediaBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeMediaBigContentView", $$robo$$android_app_Notification_MediaStyle$makeMediaBigContentView(), 0, this);
        }

        private int getBigLayoutResource(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getBigLayoutResource", $$robo$$android_app_Notification_MediaStyle$getBigLayoutResource(int ), 0, this, n);
        }

        private void hideRightIcon(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("hideRightIcon", $$robo$$android_app_Notification_MediaStyle$hideRightIcon(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void styleText(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("styleText", $$robo$$android_app_Notification_MediaStyle$styleText(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        @Override
        protected boolean hasProgress() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasProgress", $$robo$$android_app_Notification_MediaStyle$hasProgress(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InboxStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<CharSequence> mTexts;

        private void $$robo$$android_app_Notification_InboxStyle$__constructor__() {
            this.mTexts = new ArrayList(5);
        }

        private void $$robo$$android_app_Notification_InboxStyle$__constructor__(Builder builder) {
            this.mTexts = new ArrayList(5);
            this.setBuilder(builder);
        }

        private final InboxStyle $$robo$$android_app_Notification_InboxStyle$setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        private final InboxStyle $$robo$$android_app_Notification_InboxStyle$setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        private final InboxStyle $$robo$$android_app_Notification_InboxStyle$addLine(CharSequence cs) {
            this.mTexts.add(Notification.safeCharSequence(cs));
            return this;
        }

        private final void $$robo$$android_app_Notification_InboxStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            CharSequence[] a = new CharSequence[this.mTexts.size()];
            extras.putCharSequenceArray("android.textLines", this.mTexts.toArray(a));
        }

        private final void $$robo$$android_app_Notification_InboxStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mTexts.clear();
            if (extras.containsKey("android.textLines")) {
                Collections.addAll(this.mTexts, extras.getCharSequenceArray("android.textLines"));
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_InboxStyle$makeBigContentView() {
            int[] rowIds;
            CharSequence oldBuilderContentText = this.mBuilder.mContentText;
            this.mBuilder.mContentText = null;
            RemoteViews contentView = this.getStandardView(this.mBuilder.getInboxLayoutResource());
            this.mBuilder.mContentText = oldBuilderContentText;
            contentView.setViewVisibility(16908309, 8);
            for (int rowId : rowIds = new int[]{16909112, 16909113, 16909114, 16909115, 16909116, 16909117, 16909118}) {
                contentView.setViewVisibility(rowId, 8);
            }
            boolean largeText = ((Builder)this.mBuilder).mContext.getResources().getConfiguration().fontScale > 1.0f;
            float subTextSize = this.mBuilder.mContext.getResources().getDimensionPixelSize(17104980);
            for (int i = 0; i < this.mTexts.size() && i < rowIds.length; ++i) {
                CharSequence str = this.mTexts.get(i);
                if (str == null || str.equals("")) continue;
                contentView.setViewVisibility(rowIds[i], 0);
                contentView.setTextViewText(rowIds[i], this.mBuilder.processLegacyText(str));
                if (!largeText) continue;
                contentView.setTextViewTextSize(rowIds[i], 0, subTextSize);
            }
            contentView.setViewVisibility(16909120, this.mTexts.size() > 0 ? 0 : 8);
            contentView.setViewVisibility(16909119, this.mTexts.size() > rowIds.length ? 0 : 8);
            this.applyTopPadding(contentView);
            this.mBuilder.shrinkLine3Text(contentView);
            this.mBuilder.addProfileBadge(contentView, 16909107);
            return contentView;
        }

        private final void $$robo$$android_app_Notification_InboxStyle$populateBigContentView(Notification wip) {
            this.mBuilder.setBuilderBigContentView(wip, this.makeBigContentView());
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_InboxStyle$__constructor__();
        }

        public InboxStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_InboxStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_InboxStyle$__constructor__(builder);
        }

        public InboxStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_InboxStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public InboxStyle setBigContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setBigContentTitle", $$robo$$android_app_Notification_InboxStyle$setBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public InboxStyle setSummaryText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSummaryText", $$robo$$android_app_Notification_InboxStyle$setSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public InboxStyle addLine(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("addLine", $$robo$$android_app_Notification_InboxStyle$addLine(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_InboxStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_InboxStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        private RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_InboxStyle$makeBigContentView(), 0, this);
        }

        @Override
        public void populateBigContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateBigContentView", $$robo$$android_app_Notification_InboxStyle$populateBigContentView(android.app.Notification ), 0, this, notification);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InboxStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BigTextStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_LINES = 13;
        private static int LINES_CONSUMED_BY_ACTIONS = 3;
        private static int LINES_CONSUMED_BY_SUMMARY = 2;
        private CharSequence mBigText;

        private void $$robo$$android_app_Notification_BigTextStyle$__constructor__() {
        }

        private void $$robo$$android_app_Notification_BigTextStyle$__constructor__(Builder builder) {
            this.setBuilder(builder);
        }

        private final BigTextStyle $$robo$$android_app_Notification_BigTextStyle$setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        private final BigTextStyle $$robo$$android_app_Notification_BigTextStyle$setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        private final BigTextStyle $$robo$$android_app_Notification_BigTextStyle$bigText(CharSequence cs) {
            this.mBigText = Notification.safeCharSequence(cs);
            return this;
        }

        private final void $$robo$$android_app_Notification_BigTextStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            extras.putCharSequence("android.bigText", this.mBigText);
        }

        private final void $$robo$$android_app_Notification_BigTextStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mBigText = extras.getCharSequence("android.bigText");
        }

        private final RemoteViews $$robo$$android_app_Notification_BigTextStyle$makeBigContentView() {
            CharSequence oldBuilderContentText = this.mBuilder.mContentText;
            this.mBuilder.mContentText = null;
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigTextLayoutResource());
            this.mBuilder.mContentText = oldBuilderContentText;
            contentView.setTextViewText(16909106, this.mBuilder.processLegacyText(this.mBigText));
            contentView.setViewVisibility(16909106, 0);
            contentView.setInt(16909106, "setMaxLines", this.calculateMaxLines());
            contentView.setViewVisibility(16908309, 8);
            this.applyTopPadding(contentView);
            this.mBuilder.shrinkLine3Text(contentView);
            this.mBuilder.addProfileBadge(contentView, 16909107);
            return contentView;
        }

        private final int $$robo$$android_app_Notification_BigTextStyle$calculateMaxLines() {
            boolean hasSummary;
            int lineCount = 13;
            boolean hasActions = this.mBuilder.mActions.size() > 0;
            boolean bl = hasSummary = (this.mSummaryTextSet ? this.mSummaryText : this.mBuilder.mSubText) != null;
            if (hasActions) {
                lineCount -= 3;
            }
            if (hasSummary) {
                lineCount -= 2;
            }
            if (!this.mBuilder.mHasThreeLines) {
                --lineCount;
            }
            return lineCount;
        }

        private final void $$robo$$android_app_Notification_BigTextStyle$populateBigContentView(Notification wip) {
            this.mBuilder.setBuilderBigContentView(wip, this.makeBigContentView());
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_BigTextStyle$__constructor__();
        }

        public BigTextStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigTextStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_BigTextStyle$__constructor__(builder);
        }

        public BigTextStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigTextStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public BigTextStyle setBigContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setBigContentTitle", $$robo$$android_app_Notification_BigTextStyle$setBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigTextStyle setSummaryText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSummaryText", $$robo$$android_app_Notification_BigTextStyle$setSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigTextStyle bigText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("bigText", $$robo$$android_app_Notification_BigTextStyle$bigText(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_BigTextStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_BigTextStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        private RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_BigTextStyle$makeBigContentView(), 0, this);
        }

        private int calculateMaxLines() {
            return (int)InvokeDynamicSupport.bootstrap("calculateMaxLines", $$robo$$android_app_Notification_BigTextStyle$calculateMaxLines(), 0, this);
        }

        @Override
        public void populateBigContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateBigContentView", $$robo$$android_app_Notification_BigTextStyle$populateBigContentView(android.app.Notification ), 0, this, notification);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BigTextStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BigPictureStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bitmap mPicture;
        private Bitmap mBigLargeIcon;
        private boolean mBigLargeIconSet;

        private void $$robo$$android_app_Notification_BigPictureStyle$__constructor__() {
            this.mBigLargeIconSet = false;
        }

        private void $$robo$$android_app_Notification_BigPictureStyle$__constructor__(Builder builder) {
            this.mBigLargeIconSet = false;
            this.setBuilder(builder);
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$bigPicture(Bitmap b) {
            this.mPicture = b;
            return this;
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$bigLargeIcon(Bitmap b) {
            this.mBigLargeIconSet = true;
            this.mBigLargeIcon = b;
            return this;
        }

        private final RemoteViews $$robo$$android_app_Notification_BigPictureStyle$makeBigContentView() {
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigPictureLayoutResource());
            contentView.setImageViewBitmap(16909110, this.mPicture);
            this.applyTopPadding(contentView);
            boolean twoTextLines = this.mBuilder.mSubText != null && this.mBuilder.mContentText != null;
            this.mBuilder.addProfileBadge(contentView, twoTextLines ? 16909123 : 16909126);
            return contentView;
        }

        private final void $$robo$$android_app_Notification_BigPictureStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mBigLargeIconSet) {
                extras.putParcelable("android.largeIcon.big", this.mBigLargeIcon);
            }
            extras.putParcelable("android.picture", this.mPicture);
        }

        private final void $$robo$$android_app_Notification_BigPictureStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey("android.largeIcon.big")) {
                this.mBigLargeIcon = (Bitmap)extras.getParcelable("android.largeIcon.big");
            }
            this.mPicture = (Bitmap)extras.getParcelable("android.picture");
        }

        private final void $$robo$$android_app_Notification_BigPictureStyle$populateBigContentView(Notification wip) {
            this.mBuilder.setBuilderBigContentView(wip, this.makeBigContentView());
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_BigPictureStyle$__constructor__();
        }

        public BigPictureStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigPictureStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_BigPictureStyle$__constructor__(builder);
        }

        public BigPictureStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigPictureStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public BigPictureStyle setBigContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setBigContentTitle", $$robo$$android_app_Notification_BigPictureStyle$setBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigPictureStyle setSummaryText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSummaryText", $$robo$$android_app_Notification_BigPictureStyle$setSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigPictureStyle bigPicture(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("bigPicture", $$robo$$android_app_Notification_BigPictureStyle$bigPicture(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public BigPictureStyle bigLargeIcon(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("bigLargeIcon", $$robo$$android_app_Notification_BigPictureStyle$bigLargeIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        private RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_BigPictureStyle$makeBigContentView(), 0, this);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_BigPictureStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_BigPictureStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public void populateBigContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateBigContentView", $$robo$$android_app_Notification_BigPictureStyle$populateBigContentView(android.app.Notification ), 0, this, notification);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BigPictureStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mBigContentTitle;
        protected CharSequence mSummaryText;
        protected boolean mSummaryTextSet;
        protected Builder mBuilder;

        private void $$robo$$android_app_Notification_Style$__constructor__() {
            this.mSummaryText = null;
            this.mSummaryTextSet = false;
        }

        private final void $$robo$$android_app_Notification_Style$internalSetBigContentTitle(CharSequence title) {
            this.mBigContentTitle = title;
        }

        private final void $$robo$$android_app_Notification_Style$internalSetSummaryText(CharSequence cs) {
            this.mSummaryText = cs;
            this.mSummaryTextSet = true;
        }

        private final void $$robo$$android_app_Notification_Style$setBuilder(Builder builder) {
            if (this.mBuilder != builder) {
                this.mBuilder = builder;
                if (this.mBuilder != null) {
                    this.mBuilder.setStyle(this);
                }
            }
        }

        private final void $$robo$$android_app_Notification_Style$checkBuilder() {
            if (this.mBuilder == null) {
                throw new IllegalArgumentException("Style requires a valid Builder object");
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_Style$getStandardView(int layoutId) {
            CharSequence overflowText;
            this.checkBuilder();
            CharSequence oldBuilderContentTitle = this.mBuilder.mContentTitle;
            if (this.mBigContentTitle != null) {
                this.mBuilder.setContentTitle(this.mBigContentTitle);
            }
            RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(layoutId);
            this.mBuilder.mContentTitle = oldBuilderContentTitle;
            if (this.mBigContentTitle != null && this.mBigContentTitle.equals("")) {
                contentView.setViewVisibility(16909122, 8);
            } else {
                contentView.setViewVisibility(16909122, 0);
            }
            CharSequence charSequence = overflowText = this.mSummaryTextSet ? this.mSummaryText : this.mBuilder.mSubText;
            if (overflowText != null) {
                contentView.setTextViewText(16908392, this.mBuilder.processLegacyText(overflowText));
                contentView.setViewVisibility(16909111, 0);
                contentView.setViewVisibility(16909124, 0);
            } else {
                contentView.setTextViewText(16908392, "");
                contentView.setViewVisibility(16909111, 8);
                contentView.setViewVisibility(16909124, 8);
            }
            return contentView;
        }

        private final void $$robo$$android_app_Notification_Style$applyTopPadding(RemoteViews contentView) {
            int topPadding = Builder.calculateTopPadding(this.mBuilder.mContext, this.mBuilder.mHasThreeLines, ((Builder)this.mBuilder).mContext.getResources().getConfiguration().fontScale);
            contentView.setViewPadding(16909122, 0, topPadding, 0, 0);
        }

        private final void $$robo$$android_app_Notification_Style$addExtras(Bundle extras) {
            if (this.mSummaryTextSet) {
                extras.putCharSequence("android.summaryText", this.mSummaryText);
            }
            if (this.mBigContentTitle != null) {
                extras.putCharSequence("android.title.big", this.mBigContentTitle);
            }
            extras.putString("android.template", this.getClass().getName());
        }

        private final void $$robo$$android_app_Notification_Style$restoreFromExtras(Bundle extras) {
            if (extras.containsKey("android.summaryText")) {
                this.mSummaryText = extras.getCharSequence("android.summaryText");
                this.mSummaryTextSet = true;
            }
            if (extras.containsKey("android.title.big")) {
                this.mBigContentTitle = extras.getCharSequence("android.title.big");
            }
        }

        private final Notification $$robo$$android_app_Notification_Style$buildStyled(Notification wip) {
            this.populateTickerView(wip);
            this.populateContentView(wip);
            this.populateBigContentView(wip);
            this.populateHeadsUpContentView(wip);
            return wip;
        }

        private final void $$robo$$android_app_Notification_Style$populateTickerView(Notification wip) {
        }

        private final void $$robo$$android_app_Notification_Style$populateContentView(Notification wip) {
        }

        private final void $$robo$$android_app_Notification_Style$populateBigContentView(Notification wip) {
        }

        private final void $$robo$$android_app_Notification_Style$populateHeadsUpContentView(Notification wip) {
        }

        private final Notification $$robo$$android_app_Notification_Style$build() {
            this.checkBuilder();
            return this.mBuilder.build();
        }

        private final boolean $$robo$$android_app_Notification_Style$hasProgress() {
            return true;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_Style$__constructor__();
        }

        public Style() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Style$__constructor__(), 0, this);
        }

        protected void internalSetBigContentTitle(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("internalSetBigContentTitle", $$robo$$android_app_Notification_Style$internalSetBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        protected void internalSetSummaryText(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("internalSetSummaryText", $$robo$$android_app_Notification_Style$internalSetSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public void setBuilder(Builder builder) {
            InvokeDynamicSupport.bootstrap("setBuilder", $$robo$$android_app_Notification_Style$setBuilder(android.app.Notification$Builder ), 0, this, builder);
        }

        protected void checkBuilder() {
            InvokeDynamicSupport.bootstrap("checkBuilder", $$robo$$android_app_Notification_Style$checkBuilder(), 0, this);
        }

        protected RemoteViews getStandardView(int n) {
            return InvokeDynamicSupport.bootstrap("getStandardView", $$robo$$android_app_Notification_Style$getStandardView(int ), 0, this, n);
        }

        protected void applyTopPadding(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("applyTopPadding", $$robo$$android_app_Notification_Style$applyTopPadding(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_Style$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_Style$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        public Notification buildStyled(Notification notification) {
            return InvokeDynamicSupport.bootstrap("buildStyled", $$robo$$android_app_Notification_Style$buildStyled(android.app.Notification ), 0, this, notification);
        }

        protected void populateTickerView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateTickerView", $$robo$$android_app_Notification_Style$populateTickerView(android.app.Notification ), 0, this, notification);
        }

        protected void populateContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateContentView", $$robo$$android_app_Notification_Style$populateContentView(android.app.Notification ), 0, this, notification);
        }

        protected void populateBigContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateBigContentView", $$robo$$android_app_Notification_Style$populateBigContentView(android.app.Notification ), 0, this, notification);
        }

        protected void populateHeadsUpContentView(Notification notification) {
            InvokeDynamicSupport.bootstrap("populateHeadsUpContentView", $$robo$$android_app_Notification_Style$populateHeadsUpContentView(android.app.Notification ), 0, this, notification);
        }

        public Notification build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_Style$build(), 0, this);
        }

        protected boolean hasProgress() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasProgress", $$robo$$android_app_Notification_Style$hasProgress(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_ACTION_BUTTONS = 3;
        private static float LARGE_TEXT_SCALE = 1.3f;
        public static String EXTRA_NEEDS_REBUILD = "android.rebuild";
        public static String EXTRA_REBUILD_LARGE_ICON = "android.rebuild.largeIcon";
        public static String EXTRA_REBUILD_CONTENT_VIEW = "android.rebuild.contentView";
        public static String EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.contentViewActionCount";
        public static String EXTRA_REBUILD_BIG_CONTENT_VIEW = "android.rebuild.bigView";
        public static String EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.bigViewActionCount";
        public static String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW = "android.rebuild.hudView";
        public static String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.hudViewActionCount";
        private static String EXTRA_REBUILD_CONTEXT_APPLICATION_INFO = "android.rebuild.applicationInfo";
        private static boolean STRIP_AND_REBUILD = true;
        private Context mContext;
        private long mWhen;
        private int mSmallIcon;
        private int mSmallIconLevel;
        private int mNumber;
        private CharSequence mContentTitle;
        private CharSequence mContentText;
        private CharSequence mContentInfo;
        private CharSequence mSubText;
        private PendingIntent mContentIntent;
        private RemoteViews mContentView;
        private PendingIntent mDeleteIntent;
        private PendingIntent mFullScreenIntent;
        private CharSequence mTickerText;
        private RemoteViews mTickerView;
        private Bitmap mLargeIcon;
        private Uri mSound;
        private int mAudioStreamType;
        private AudioAttributes mAudioAttributes;
        private long[] mVibrate;
        private int mLedArgb;
        private int mLedOnMs;
        private int mLedOffMs;
        private int mDefaults;
        private int mFlags;
        private int mProgressMax;
        private int mProgress;
        private boolean mProgressIndeterminate;
        private String mCategory;
        private String mGroupKey;
        private String mSortKey;
        private Bundle mExtras;
        private int mPriority;
        private ArrayList<Action> mActions;
        private boolean mUseChronometer;
        private Style mStyle;
        private boolean mShowWhen;
        private int mVisibility;
        private Notification mPublicVersion;
        private NotificationColorUtil mColorUtil;
        private ArrayList<String> mPeople;
        private int mColor;
        private int mOriginatingUserId;
        private Bundle mRebuildBundle;
        private Notification mRebuildNotification;
        private boolean mHasThreeLines;

        private void $$robo$$android_app_Notification_Builder$__constructor__(Context context) {
            this.mActions = new ArrayList(3);
            this.mShowWhen = true;
            this.mVisibility = 0;
            this.mPublicVersion = null;
            this.mColor = 0;
            this.mRebuildBundle = new Bundle();
            this.mRebuildNotification = null;
            this.mContext = context;
            this.mWhen = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mAudioStreamType = -1;
            this.mAudioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            this.mPriority = 0;
            this.mPeople = new ArrayList();
            this.mColorUtil = context.getApplicationInfo().targetSdkVersion < 21 ? NotificationColorUtil.getInstance(this.mContext) : null;
        }

        private void $$robo$$android_app_Notification_Builder$__constructor__(Context context, Notification n) {
            this.mRebuildNotification = n;
            this.restoreFromNotification(n);
            Style style2 = null;
            Bundle extras = n.extras;
            String templateClass = extras.getString("android.template");
            if (!TextUtils.isEmpty(templateClass)) {
                Class<? extends Style> styleClass = Builder.getNotificationStyleClass(templateClass);
                if (styleClass == null) {
                    Log.d("Notification", "Unknown style class: " + styleClass);
                    return;
                }
                try {
                    Constructor<? extends Style> constructor = styleClass.getConstructor(new Class[0]);
                    style2 = constructor.newInstance(new Object[0]);
                    style2.restoreFromExtras(extras);
                }
                catch (Throwable t) {
                    Log.e("Notification", "Could not create Style", t);
                    return;
                }
            }
            if (style2 != null) {
                this.setStyle(style2);
            }
        }

        private final Builder $$robo$$android_app_Notification_Builder$setWhen(long when) {
            this.mWhen = when;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setShowWhen(boolean show) {
            this.mShowWhen = show;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setUsesChronometer(boolean b) {
            this.mUseChronometer = b;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSmallIcon(int icon) {
            this.mSmallIcon = icon;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSmallIcon(int icon, int level) {
            this.mSmallIcon = icon;
            this.mSmallIconLevel = level;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentTitle(CharSequence title) {
            this.mContentTitle = Notification.safeCharSequence(title);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentText(CharSequence text) {
            this.mContentText = Notification.safeCharSequence(text);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSubText(CharSequence text) {
            this.mSubText = Notification.safeCharSequence(text);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setNumber(int number) {
            this.mNumber = number;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentInfo(CharSequence info) {
            this.mContentInfo = Notification.safeCharSequence(info);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setProgress(int max, int progress, boolean indeterminate) {
            this.mProgressMax = max;
            this.mProgress = progress;
            this.mProgressIndeterminate = indeterminate;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContent(RemoteViews views) {
            this.mContentView = views;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentIntent(PendingIntent intent) {
            this.mContentIntent = intent;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setDeleteIntent(PendingIntent intent) {
            this.mDeleteIntent = intent;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setFullScreenIntent(PendingIntent intent, boolean highPriority) {
            this.mFullScreenIntent = intent;
            this.setFlag(128, highPriority);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setTicker(CharSequence tickerText) {
            this.mTickerText = Notification.safeCharSequence(tickerText);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_Notification_Builder$setTicker(CharSequence tickerText, RemoteViews views) {
            this.mTickerText = Notification.safeCharSequence(tickerText);
            this.mTickerView = views;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLargeIcon(Bitmap icon) {
            this.mLargeIcon = icon;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSound(Uri sound) {
            this.mSound = sound;
            this.mAudioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_Notification_Builder$setSound(Uri sound, int streamType) {
            this.mSound = sound;
            this.mAudioStreamType = streamType;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSound(Uri sound, AudioAttributes audioAttributes) {
            this.mSound = sound;
            this.mAudioAttributes = audioAttributes;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setVibrate(long[] pattern) {
            this.mVibrate = pattern;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLights(int argb, int onMs, int offMs) {
            this.mLedArgb = argb;
            this.mLedOnMs = onMs;
            this.mLedOffMs = offMs;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setOngoing(boolean ongoing) {
            this.setFlag(2, ongoing);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setOnlyAlertOnce(boolean onlyAlertOnce) {
            this.setFlag(8, onlyAlertOnce);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setAutoCancel(boolean autoCancel) {
            this.setFlag(16, autoCancel);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLocalOnly(boolean localOnly) {
            this.setFlag(256, localOnly);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setDefaults(int defaults) {
            this.mDefaults = defaults;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setPriority(int pri) {
            this.mPriority = pri;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setCategory(String category) {
            this.mCategory = category;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addPerson(String uri) {
            this.mPeople.add(uri);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setGroup(String groupKey) {
            this.mGroupKey = groupKey;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setGroupSummary(boolean isGroupSummary) {
            this.setFlag(512, isGroupSummary);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSortKey(String sortKey) {
            this.mSortKey = sortKey;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addExtras(Bundle extras) {
            if (extras != null) {
                if (this.mExtras == null) {
                    this.mExtras = new Bundle(extras);
                } else {
                    this.mExtras.putAll(extras);
                }
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        private final Bundle $$robo$$android_app_Notification_Builder$getExtras() {
            if (this.mExtras == null) {
                this.mExtras = new Bundle();
            }
            return this.mExtras;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addAction(int icon, CharSequence title, PendingIntent intent) {
            this.mActions.add(new Action(icon, Notification.safeCharSequence(title), intent));
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setStyle(Style style2) {
            if (this.mStyle != style2) {
                this.mStyle = style2;
                if (this.mStyle != null) {
                    this.mStyle.setBuilder(this);
                }
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setVisibility(int visibility) {
            this.mVisibility = visibility;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setPublicVersion(Notification n) {
            this.mPublicVersion = n;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$extend(Extender extender) {
            extender.extend(this);
            return this;
        }

        private final void $$robo$$android_app_Notification_Builder$setFlag(int mask, boolean value) {
            this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
        }

        private final Builder $$robo$$android_app_Notification_Builder$setColor(int argb) {
            this.mColor = argb;
            return this;
        }

        private final Drawable $$robo$$android_app_Notification_Builder$getProfileBadgeDrawable() {
            return this.mContext.getPackageManager().getUserBadgeForDensity(new UserHandle(this.mOriginatingUserId), 0);
        }

        private final Bitmap $$robo$$android_app_Notification_Builder$getProfileBadge() {
            Drawable badge = this.getProfileBadgeDrawable();
            if (badge == null) {
                return null;
            }
            int size = this.mContext.getResources().getDimensionPixelSize(17104986);
            Bitmap bitmap = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            badge.setBounds(0, 0, size, size);
            badge.draw(canvas);
            return bitmap;
        }

        private final boolean $$robo$$android_app_Notification_Builder$addProfileBadge(RemoteViews contentView, int resId) {
            Bitmap profileBadge = this.getProfileBadge();
            contentView.setViewVisibility(16909107, 8);
            contentView.setViewVisibility(16909123, 8);
            contentView.setViewVisibility(16909126, 8);
            if (profileBadge != null) {
                contentView.setImageViewBitmap(resId, profileBadge);
                contentView.setViewVisibility(resId, 0);
                if (resId == 16909126) {
                    contentView.setViewVisibility(16909124, 0);
                }
                return true;
            }
            return false;
        }

        private final void $$robo$$android_app_Notification_Builder$shrinkLine3Text(RemoteViews contentView) {
            float subTextSize = this.mContext.getResources().getDimensionPixelSize(17104980);
            contentView.setTextViewTextSize(16908392, 0, subTextSize);
        }

        private final void $$robo$$android_app_Notification_Builder$unshrinkLine3Text(RemoteViews contentView) {
            float regularTextSize = this.mContext.getResources().getDimensionPixelSize(17104978);
            contentView.setTextViewTextSize(16908392, 0, regularTextSize);
        }

        private final void $$robo$$android_app_Notification_Builder$resetStandardTemplate(RemoteViews contentView) {
            this.removeLargeIconBackground(contentView);
            contentView.setViewPadding(16908294, 0, 0, 0, 0);
            contentView.setImageViewResource(16908294, 0);
            contentView.setInt(16908294, "setBackgroundResource", 0);
            contentView.setViewVisibility(16908340, 8);
            contentView.setInt(16908340, "setBackgroundResource", 0);
            contentView.setImageViewResource(16908340, 0);
            contentView.setImageViewResource(16908294, 0);
            contentView.setTextViewText(16908310, null);
            contentView.setTextViewText(16908392, null);
            this.unshrinkLine3Text(contentView);
            contentView.setTextViewText(16908309, null);
            contentView.setViewVisibility(16908309, 8);
            contentView.setViewVisibility(16909125, 8);
            contentView.setViewVisibility(16908415, 8);
            contentView.setViewVisibility(16909124, 8);
            contentView.setViewVisibility(16909111, 8);
            contentView.setViewVisibility(16908301, 8);
            contentView.setViewVisibility(16909121, 8);
            contentView.setViewVisibility(16908415, 8);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplate(int resId) {
            return this.applyStandardTemplate(resId, true);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplate(int resId, boolean hasProgress) {
            BuilderRemoteViews contentView = new BuilderRemoteViews(this.mContext.getApplicationInfo(), resId);
            this.resetStandardTemplate(contentView);
            boolean showLine3 = false;
            boolean showLine2 = false;
            boolean contentTextInLine2 = false;
            if (this.mLargeIcon != null) {
                contentView.setImageViewBitmap(16908294, this.mLargeIcon);
                this.processLargeLegacyIcon(this.mLargeIcon, contentView);
                contentView.setImageViewResource(16908340, this.mSmallIcon);
                contentView.setViewVisibility(16908340, 0);
                this.processSmallRightIcon(this.mSmallIcon, contentView);
            } else {
                contentView.setImageViewResource(16908294, this.mSmallIcon);
                contentView.setViewVisibility(16908294, 0);
                this.processSmallIconAsLarge(this.mSmallIcon, contentView);
            }
            if (this.mContentTitle != null) {
                contentView.setTextViewText(16908310, this.processLegacyText(this.mContentTitle));
            }
            if (this.mContentText != null) {
                contentView.setTextViewText(16908392, this.processLegacyText(this.mContentText));
                showLine3 = true;
            }
            if (this.mContentInfo != null) {
                contentView.setTextViewText(16909125, this.processLegacyText(this.mContentInfo));
                contentView.setViewVisibility(16909125, 0);
                showLine3 = true;
            } else if (this.mNumber > 0) {
                int tooBig = this.mContext.getResources().getInteger(17694723);
                if (this.mNumber > tooBig) {
                    contentView.setTextViewText(16909125, this.processLegacyText(this.mContext.getResources().getString(17039383)));
                } else {
                    NumberFormat f = NumberFormat.getIntegerInstance();
                    contentView.setTextViewText(16909125, this.processLegacyText(f.format(this.mNumber)));
                }
                contentView.setViewVisibility(16909125, 0);
                showLine3 = true;
            } else {
                contentView.setViewVisibility(16909125, 8);
            }
            if (this.mSubText != null) {
                contentView.setTextViewText(16908392, this.processLegacyText(this.mSubText));
                if (this.mContentText != null) {
                    contentView.setTextViewText(16908309, this.processLegacyText(this.mContentText));
                    contentView.setViewVisibility(16908309, 0);
                    showLine2 = true;
                    contentTextInLine2 = true;
                } else {
                    contentView.setViewVisibility(16908309, 8);
                }
            } else {
                contentView.setViewVisibility(16908309, 8);
                if (hasProgress && (this.mProgressMax != 0 || this.mProgressIndeterminate)) {
                    contentView.setViewVisibility(16908301, 0);
                    contentView.setProgressBar(16908301, this.mProgressMax, this.mProgress, this.mProgressIndeterminate);
                    showLine2 = true;
                } else {
                    contentView.setViewVisibility(16908301, 8);
                }
            }
            if (showLine2) {
                this.shrinkLine3Text(contentView);
            }
            if (this.showsTimeOrChronometer()) {
                if (this.mUseChronometer) {
                    contentView.setViewVisibility(16909121, 0);
                    contentView.setLong(16909121, "setBase", this.mWhen + (SystemClock.elapsedRealtime() - InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")));
                    contentView.setBoolean(16909121, "setStarted", true);
                } else {
                    contentView.setViewVisibility(16908415, 0);
                    contentView.setLong(16908415, "setTime", this.mWhen);
                }
            }
            contentView.setViewPadding(16909122, 0, Builder.calculateTopPadding(this.mContext, this.mHasThreeLines, this.mContext.getResources().getConfiguration().fontScale), 0, 0);
            boolean addedBadge = this.addProfileBadge(contentView, contentTextInLine2 ? 16909123 : 16909126);
            if (addedBadge && !contentTextInLine2) {
                showLine3 = true;
            }
            contentView.setViewVisibility(16909124, showLine3 ? 0 : 8);
            contentView.setViewVisibility(16909111, showLine3 ? 0 : 8);
            return contentView;
        }

        private final boolean $$robo$$android_app_Notification_Builder$showsTimeOrChronometer() {
            return this.mWhen != 0L && this.mShowWhen;
        }

        private final boolean $$robo$$android_app_Notification_Builder$hasThreeLines() {
            boolean contentTextInLine2 = this.mSubText != null && this.mContentText != null;
            boolean hasProgress = this.mStyle == null || this.mStyle.hasProgress();
            boolean badgeInLine3 = this.getProfileBadgeDrawable() != null && !contentTextInLine2;
            boolean hasLine3 = this.mContentText != null || this.mContentInfo != null || this.mNumber > 0 || badgeInLine3;
            boolean hasLine2 = this.mSubText != null && this.mContentText != null || hasProgress && this.mSubText == null && (this.mProgressMax != 0 || this.mProgressIndeterminate);
            return hasLine2 && hasLine3;
        }

        private static final int $$robo$$android_app_Notification_Builder$calculateTopPadding(Context ctx, boolean hasThreeLines, float fontScale) {
            int padding = ctx.getResources().getDimensionPixelSize(hasThreeLines ? 17104982 : 0x1050055);
            int largePadding = ctx.getResources().getDimensionPixelSize(hasThreeLines ? 17104984 : 17104983);
            float largeFactor = (MathUtils.constrain(fontScale, 1.0f, 1.3f) - 1.0f) / 0.29999995f;
            return Math.round((1.0f - largeFactor) * (float)padding + largeFactor * (float)largePadding);
        }

        private final void $$robo$$android_app_Notification_Builder$resetStandardTemplateWithActions(RemoteViews big) {
            big.setViewVisibility(16909100, 8);
            big.setViewVisibility(16909108, 8);
            big.removeAllViews(16909100);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplateWithActions(int layoutId) {
            RemoteViews big = this.applyStandardTemplate(layoutId);
            this.resetStandardTemplateWithActions(big);
            int N = this.mActions.size();
            if (N > 0) {
                big.setViewVisibility(16909100, 0);
                big.setViewVisibility(16909108, 0);
                if (N > 3) {
                    N = 3;
                }
                for (int i = 0; i < N; ++i) {
                    RemoteViews button = this.generateActionButton(this.mActions.get(i));
                    big.addView(16909100, button);
                }
            }
            return big;
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$makeContentView() {
            if (this.mContentView != null) {
                return this.mContentView;
            }
            return this.applyStandardTemplate(this.getBaseLayoutResource());
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$makeTickerView() {
            if (this.mTickerView != null) {
                return this.mTickerView;
            }
            return null;
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$makeBigContentView() {
            if (this.mActions.size() == 0) {
                return null;
            }
            return this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$makeHeadsUpContentView() {
            if (this.mActions.size() == 0) {
                return null;
            }
            return this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$generateActionButton(Action action) {
            boolean tombstone = action.actionIntent == null;
            RemoteViews button = new RemoteViews(this.mContext.getPackageName(), tombstone ? this.getActionTombstoneLayoutResource() : this.getActionLayoutResource());
            button.setTextViewCompoundDrawablesRelative(16909101, action.icon, 0, 0, 0);
            button.setTextViewText(16909101, this.processLegacyText(action.title));
            if (!tombstone) {
                button.setOnClickPendingIntent(16909101, action.actionIntent);
            }
            button.setContentDescription(16909101, action.title);
            this.processLegacyAction(action, button);
            return button;
        }

        private final boolean $$robo$$android_app_Notification_Builder$isLegacy() {
            return this.mColorUtil != null;
        }

        private final void $$robo$$android_app_Notification_Builder$processLegacyAction(Action action, RemoteViews button) {
            if (!this.isLegacy() || this.mColorUtil.isGrayscaleIcon(this.mContext, action.icon)) {
                button.setTextViewCompoundDrawablesRelativeColorFilter(16909101, 0, this.mContext.getResources().getColor(17170512), PorterDuff.Mode.MULTIPLY);
            }
        }

        private final CharSequence $$robo$$android_app_Notification_Builder$processLegacyText(CharSequence charSequence) {
            if (this.isLegacy()) {
                return this.mColorUtil.invertCharSequenceColors(charSequence);
            }
            return charSequence;
        }

        private final void $$robo$$android_app_Notification_Builder$processSmallIconAsLarge(int largeIconId, RemoteViews contentView) {
            if (!this.isLegacy() || this.mColorUtil.isGrayscaleIcon(this.mContext, largeIconId)) {
                this.applyLargeIconBackground(contentView);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$processLargeLegacyIcon(Bitmap largeIcon, RemoteViews contentView) {
            if (this.isLegacy() && this.mColorUtil.isGrayscaleIcon(largeIcon)) {
                this.applyLargeIconBackground(contentView);
            } else {
                this.removeLargeIconBackground(contentView);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$applyLargeIconBackground(RemoteViews contentView) {
            contentView.setInt(16908294, "setBackgroundResource", 17302768);
            contentView.setDrawableParameters(16908294, true, -1, this.resolveColor(), PorterDuff.Mode.SRC_ATOP, -1);
            int padding = this.mContext.getResources().getDimensionPixelSize(17104985);
            contentView.setViewPadding(16908294, padding, padding, padding, padding);
        }

        private final void $$robo$$android_app_Notification_Builder$removeLargeIconBackground(RemoteViews contentView) {
            contentView.setInt(16908294, "setBackgroundResource", 0);
        }

        private final void $$robo$$android_app_Notification_Builder$processSmallRightIcon(int smallIconDrawableId, RemoteViews contentView) {
            if (!this.isLegacy() || this.mColorUtil.isGrayscaleIcon(this.mContext, smallIconDrawableId)) {
                contentView.setDrawableParameters(16908340, false, -1, -1, PorterDuff.Mode.SRC_ATOP, -1);
                contentView.setInt(16908340, "setBackgroundResource", 17302768);
                contentView.setDrawableParameters(16908340, true, -1, this.resolveColor(), PorterDuff.Mode.SRC_ATOP, -1);
            }
        }

        private final int $$robo$$android_app_Notification_Builder$sanitizeColor() {
            if (this.mColor != 0) {
                this.mColor |= 0xFF000000;
            }
            return this.mColor;
        }

        private final int $$robo$$android_app_Notification_Builder$resolveColor() {
            if (this.mColor == 0) {
                return this.mContext.getResources().getColor(17170511);
            }
            return this.mColor;
        }

        private final Notification $$robo$$android_app_Notification_Builder$buildUnstyled() {
            Notification n = new Notification();
            n.when = this.mWhen;
            n.icon = this.mSmallIcon;
            n.iconLevel = this.mSmallIconLevel;
            n.number = this.mNumber;
            n.color = this.sanitizeColor();
            this.setBuilderContentView(n, this.makeContentView());
            n.contentIntent = this.mContentIntent;
            n.deleteIntent = this.mDeleteIntent;
            n.fullScreenIntent = this.mFullScreenIntent;
            n.tickerText = this.mTickerText;
            n.tickerView = this.makeTickerView();
            n.largeIcon = this.mLargeIcon;
            n.sound = this.mSound;
            n.audioStreamType = this.mAudioStreamType;
            n.audioAttributes = this.mAudioAttributes;
            n.vibrate = this.mVibrate;
            n.ledARGB = this.mLedArgb;
            n.ledOnMS = this.mLedOnMs;
            n.ledOffMS = this.mLedOffMs;
            n.defaults = this.mDefaults;
            n.flags = this.mFlags;
            this.setBuilderBigContentView(n, this.makeBigContentView());
            this.setBuilderHeadsUpContentView(n, this.makeHeadsUpContentView());
            if (this.mLedOnMs != 0 || this.mLedOffMs != 0) {
                n.flags |= 1;
            }
            if ((this.mDefaults & 4) != 0) {
                n.flags |= 1;
            }
            n.category = this.mCategory;
            n.mGroupKey = this.mGroupKey;
            n.mSortKey = this.mSortKey;
            n.priority = this.mPriority;
            if (this.mActions.size() > 0) {
                n.actions = new Action[this.mActions.size()];
                this.mActions.toArray(n.actions);
            }
            n.visibility = this.mVisibility;
            if (this.mPublicVersion != null) {
                n.publicVersion = new Notification();
                this.mPublicVersion.cloneInto(n.publicVersion, true);
            }
            return n;
        }

        private final void $$robo$$android_app_Notification_Builder$populateExtras(Bundle extras) {
            extras.putInt("android.originatingUserId", this.mOriginatingUserId);
            extras.putParcelable("android.rebuild.applicationInfo", this.mContext.getApplicationInfo());
            extras.putCharSequence("android.title", this.mContentTitle);
            extras.putCharSequence("android.text", this.mContentText);
            extras.putCharSequence("android.subText", this.mSubText);
            extras.putCharSequence("android.infoText", this.mContentInfo);
            extras.putInt("android.icon", this.mSmallIcon);
            extras.putInt("android.progress", this.mProgress);
            extras.putInt("android.progressMax", this.mProgressMax);
            extras.putBoolean("android.progressIndeterminate", this.mProgressIndeterminate);
            extras.putBoolean("android.showChronometer", this.mUseChronometer);
            extras.putBoolean("android.showWhen", this.mShowWhen);
            if (this.mLargeIcon != null) {
                extras.putParcelable("android.largeIcon", this.mLargeIcon);
            }
            if (!this.mPeople.isEmpty()) {
                extras.putStringArray("android.people", this.mPeople.toArray(new String[this.mPeople.size()]));
            }
        }

        private static final void $$robo$$android_app_Notification_Builder$stripForDelivery(Notification n) {
            String templateClass = n.extras.getString("android.template");
            boolean stripViews = TextUtils.isEmpty(templateClass) || Builder.getNotificationStyleClass(templateClass) != null;
            boolean isStripped = false;
            if (n.largeIcon != null && n.extras.containsKey("android.largeIcon")) {
                n.largeIcon = null;
                n.extras.putBoolean("android.rebuild.largeIcon", true);
                isStripped = true;
            }
            if (stripViews && n.contentView instanceof BuilderRemoteViews && n.extras.getInt("android.rebuild.contentViewActionCount", -1) == n.contentView.getSequenceNumber()) {
                n.contentView = null;
                n.extras.putBoolean("android.rebuild.contentView", true);
                n.extras.remove("android.rebuild.contentViewActionCount");
                isStripped = true;
            }
            if (stripViews && n.bigContentView instanceof BuilderRemoteViews && n.extras.getInt("android.rebuild.bigViewActionCount", -1) == n.bigContentView.getSequenceNumber()) {
                n.bigContentView = null;
                n.extras.putBoolean("android.rebuild.bigView", true);
                n.extras.remove("android.rebuild.bigViewActionCount");
                isStripped = true;
            }
            if (stripViews && n.headsUpContentView instanceof BuilderRemoteViews && n.extras.getInt("android.rebuild.hudViewActionCount", -1) == n.headsUpContentView.getSequenceNumber()) {
                n.headsUpContentView = null;
                n.extras.putBoolean("android.rebuild.hudView", true);
                n.extras.remove("android.rebuild.hudViewActionCount");
                isStripped = true;
            }
            if (isStripped) {
                n.extras.putBoolean("android.rebuild", true);
            }
        }

        private static final Notification $$robo$$android_app_Notification_Builder$rebuild(Context context, Notification n) {
            Context builderContext;
            Bundle extras = n.extras;
            if (!extras.getBoolean("android.rebuild")) {
                return n;
            }
            extras.remove("android.rebuild");
            ApplicationInfo applicationInfo = (ApplicationInfo)extras.getParcelable("android.rebuild.applicationInfo");
            try {
                builderContext = context.createApplicationContext(applicationInfo, 4);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e("Notification", "ApplicationInfo " + applicationInfo + " not found");
                builderContext = context;
            }
            Builder b = new Builder(builderContext, n);
            return b.rebuild();
        }

        private final Notification $$robo$$android_app_Notification_Builder$rebuild() {
            if (this.mRebuildNotification == null) {
                throw new IllegalStateException("rebuild() only valid when in 'rebuild' mode.");
            }
            this.mHasThreeLines = this.hasThreeLines();
            Bundle extras = this.mRebuildNotification.extras;
            if (extras.getBoolean("android.rebuild.largeIcon")) {
                this.mRebuildNotification.largeIcon = (Bitmap)extras.getParcelable("android.largeIcon");
            }
            extras.remove("android.rebuild.largeIcon");
            if (extras.getBoolean("android.rebuild.contentView")) {
                this.setBuilderContentView(this.mRebuildNotification, this.makeContentView());
                if (this.mStyle != null) {
                    this.mStyle.populateContentView(this.mRebuildNotification);
                }
            }
            extras.remove("android.rebuild.contentView");
            if (extras.getBoolean("android.rebuild.bigView")) {
                this.setBuilderBigContentView(this.mRebuildNotification, this.makeBigContentView());
                if (this.mStyle != null) {
                    this.mStyle.populateBigContentView(this.mRebuildNotification);
                }
            }
            extras.remove("android.rebuild.bigView");
            if (extras.getBoolean("android.rebuild.hudView")) {
                this.setBuilderHeadsUpContentView(this.mRebuildNotification, this.makeHeadsUpContentView());
                if (this.mStyle != null) {
                    this.mStyle.populateHeadsUpContentView(this.mRebuildNotification);
                }
            }
            extras.remove("android.rebuild.hudView");
            this.mHasThreeLines = false;
            return this.mRebuildNotification;
        }

        private static final Class<? extends Style> $$robo$$android_app_Notification_Builder$getNotificationStyleClass(String templateClass) {
            Class[] classes;
            for (Class innerClass : classes = new Class[]{BigTextStyle.class, BigPictureStyle.class, InboxStyle.class, MediaStyle.class}) {
                if (!templateClass.equals(innerClass.getName())) continue;
                return innerClass;
            }
            return null;
        }

        private final void $$robo$$android_app_Notification_Builder$setBuilderContentView(Notification n, RemoteViews contentView) {
            n.contentView = contentView;
            if (contentView instanceof BuilderRemoteViews) {
                this.mRebuildBundle.putInt("android.rebuild.contentViewActionCount", contentView.getSequenceNumber());
            }
        }

        private final void $$robo$$android_app_Notification_Builder$setBuilderBigContentView(Notification n, RemoteViews bigContentView) {
            n.bigContentView = bigContentView;
            if (bigContentView instanceof BuilderRemoteViews) {
                this.mRebuildBundle.putInt("android.rebuild.bigViewActionCount", bigContentView.getSequenceNumber());
            }
        }

        private final void $$robo$$android_app_Notification_Builder$setBuilderHeadsUpContentView(Notification n, RemoteViews headsUpContentView) {
            n.headsUpContentView = headsUpContentView;
            if (headsUpContentView instanceof BuilderRemoteViews) {
                this.mRebuildBundle.putInt("android.rebuild.hudViewActionCount", headsUpContentView.getSequenceNumber());
            }
        }

        private final void $$robo$$android_app_Notification_Builder$restoreFromNotification(Notification n) {
            this.mWhen = n.when;
            this.mSmallIcon = n.icon;
            this.mSmallIconLevel = n.iconLevel;
            this.mNumber = n.number;
            this.mColor = n.color;
            this.mContentView = n.contentView;
            this.mDeleteIntent = n.deleteIntent;
            this.mFullScreenIntent = n.fullScreenIntent;
            this.mTickerText = n.tickerText;
            this.mTickerView = n.tickerView;
            this.mLargeIcon = n.largeIcon;
            this.mSound = n.sound;
            this.mAudioStreamType = n.audioStreamType;
            this.mAudioAttributes = n.audioAttributes;
            this.mVibrate = n.vibrate;
            this.mLedArgb = n.ledARGB;
            this.mLedOnMs = n.ledOnMS;
            this.mLedOffMs = n.ledOffMS;
            this.mDefaults = n.defaults;
            this.mFlags = n.flags;
            this.mCategory = n.category;
            this.mGroupKey = n.mGroupKey;
            this.mSortKey = n.mSortKey;
            this.mPriority = n.priority;
            this.mActions.clear();
            if (n.actions != null) {
                Collections.addAll(this.mActions, n.actions);
            }
            this.mVisibility = n.visibility;
            this.mPublicVersion = n.publicVersion;
            Bundle extras = n.extras;
            this.mOriginatingUserId = extras.getInt("android.originatingUserId");
            this.mContentTitle = extras.getCharSequence("android.title");
            this.mContentText = extras.getCharSequence("android.text");
            this.mSubText = extras.getCharSequence("android.subText");
            this.mContentInfo = extras.getCharSequence("android.infoText");
            this.mSmallIcon = extras.getInt("android.icon");
            this.mProgress = extras.getInt("android.progress");
            this.mProgressMax = extras.getInt("android.progressMax");
            this.mProgressIndeterminate = extras.getBoolean("android.progressIndeterminate");
            this.mUseChronometer = extras.getBoolean("android.showChronometer");
            this.mShowWhen = extras.getBoolean("android.showWhen");
            if (extras.containsKey("android.largeIcon")) {
                this.mLargeIcon = (Bitmap)extras.getParcelable("android.largeIcon");
            }
            if (extras.containsKey("android.people")) {
                this.mPeople.clear();
                Collections.addAll(this.mPeople, extras.getStringArray("android.people"));
            }
        }

        @Deprecated
        private final Notification $$robo$$android_app_Notification_Builder$getNotification() {
            return this.build();
        }

        private final Notification $$robo$$android_app_Notification_Builder$build() {
            this.mOriginatingUserId = this.mContext.getUserId();
            this.mHasThreeLines = this.hasThreeLines();
            Notification n = this.buildUnstyled();
            if (this.mStyle != null) {
                n = this.mStyle.buildStyled(n);
            }
            if (this.mExtras != null) {
                n.extras.putAll(this.mExtras);
            }
            if (this.mRebuildBundle.size() > 0) {
                n.extras.putAll(this.mRebuildBundle);
                this.mRebuildBundle.clear();
            }
            this.populateExtras(n.extras);
            if (this.mStyle != null) {
                this.mStyle.addExtras(n.extras);
            }
            this.mHasThreeLines = false;
            return n;
        }

        private final Notification $$robo$$android_app_Notification_Builder$buildInto(Notification n) {
            this.build().cloneInto(n, true);
            return n;
        }

        private final int $$robo$$android_app_Notification_Builder$getBaseLayoutResource() {
            return 17367160;
        }

        private final int $$robo$$android_app_Notification_Builder$getBigBaseLayoutResource() {
            return 17367161;
        }

        private final int $$robo$$android_app_Notification_Builder$getBigPictureLayoutResource() {
            return 17367164;
        }

        private final int $$robo$$android_app_Notification_Builder$getBigTextLayoutResource() {
            return 17367165;
        }

        private final int $$robo$$android_app_Notification_Builder$getInboxLayoutResource() {
            return 17367166;
        }

        private final int $$robo$$android_app_Notification_Builder$getActionLayoutResource() {
            return 17367155;
        }

        private final int $$robo$$android_app_Notification_Builder$getActionTombstoneLayoutResource() {
            return 17367157;
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_app_Notification_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        private void __constructor__(Context context, Notification notification) {
            this.$$robo$$android_app_Notification_Builder$__constructor__(context, notification);
        }

        private Builder(Context context, Notification notification) {
            this(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Builder$__constructor__(android.content.Context android.app.Notification ), 0, this, context, notification);
        }

        public Builder setWhen(long l) {
            return InvokeDynamicSupport.bootstrap("setWhen", $$robo$$android_app_Notification_Builder$setWhen(long ), 0, this, l);
        }

        public Builder setShowWhen(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setShowWhen", $$robo$$android_app_Notification_Builder$setShowWhen(boolean ), 0, this, bl);
        }

        public Builder setUsesChronometer(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUsesChronometer", $$robo$$android_app_Notification_Builder$setUsesChronometer(boolean ), 0, this, bl);
        }

        public Builder setSmallIcon(int n) {
            return InvokeDynamicSupport.bootstrap("setSmallIcon", $$robo$$android_app_Notification_Builder$setSmallIcon(int ), 0, this, n);
        }

        public Builder setSmallIcon(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setSmallIcon", $$robo$$android_app_Notification_Builder$setSmallIcon(int int ), 0, this, n, n2);
        }

        public Builder setContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setContentTitle", $$robo$$android_app_Notification_Builder$setContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setContentText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setContentText", $$robo$$android_app_Notification_Builder$setContentText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setSubText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSubText", $$robo$$android_app_Notification_Builder$setSubText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setNumber(int n) {
            return InvokeDynamicSupport.bootstrap("setNumber", $$robo$$android_app_Notification_Builder$setNumber(int ), 0, this, n);
        }

        public Builder setContentInfo(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setContentInfo", $$robo$$android_app_Notification_Builder$setContentInfo(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setProgress(int n, int n2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_app_Notification_Builder$setProgress(int int boolean ), 0, this, n, n2, bl);
        }

        public Builder setContent(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setContent", $$robo$$android_app_Notification_Builder$setContent(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public Builder setContentIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setContentIntent", $$robo$$android_app_Notification_Builder$setContentIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public Builder setDeleteIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setDeleteIntent", $$robo$$android_app_Notification_Builder$setDeleteIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public Builder setFullScreenIntent(PendingIntent pendingIntent, boolean bl) {
            return InvokeDynamicSupport.bootstrap("setFullScreenIntent", $$robo$$android_app_Notification_Builder$setFullScreenIntent(android.app.PendingIntent boolean ), 0, this, pendingIntent, bl);
        }

        public Builder setTicker(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setTicker", $$robo$$android_app_Notification_Builder$setTicker(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Deprecated
        public Builder setTicker(CharSequence charSequence, RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setTicker", $$robo$$android_app_Notification_Builder$setTicker(java.lang.CharSequence android.widget.RemoteViews ), 0, this, charSequence, remoteViews);
        }

        public Builder setLargeIcon(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("setLargeIcon", $$robo$$android_app_Notification_Builder$setLargeIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Builder setSound(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_Notification_Builder$setSound(android.net.Uri ), 0, this, uri);
        }

        @Deprecated
        public Builder setSound(Uri uri, int n) {
            return InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_Notification_Builder$setSound(android.net.Uri int ), 0, this, uri, n);
        }

        public Builder setSound(Uri uri, AudioAttributes audioAttributes) {
            return InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_Notification_Builder$setSound(android.net.Uri android.media.AudioAttributes ), 0, this, uri, audioAttributes);
        }

        public Builder setVibrate(long[] lArray) {
            return InvokeDynamicSupport.bootstrap("setVibrate", $$robo$$android_app_Notification_Builder$setVibrate(long[] ), 0, this, lArray);
        }

        public Builder setLights(int n, int n2, int n3) {
            return InvokeDynamicSupport.bootstrap("setLights", $$robo$$android_app_Notification_Builder$setLights(int int int ), 0, this, n, n2, n3);
        }

        public Builder setOngoing(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setOngoing", $$robo$$android_app_Notification_Builder$setOngoing(boolean ), 0, this, bl);
        }

        public Builder setOnlyAlertOnce(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setOnlyAlertOnce", $$robo$$android_app_Notification_Builder$setOnlyAlertOnce(boolean ), 0, this, bl);
        }

        public Builder setAutoCancel(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAutoCancel", $$robo$$android_app_Notification_Builder$setAutoCancel(boolean ), 0, this, bl);
        }

        public Builder setLocalOnly(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setLocalOnly", $$robo$$android_app_Notification_Builder$setLocalOnly(boolean ), 0, this, bl);
        }

        public Builder setDefaults(int n) {
            return InvokeDynamicSupport.bootstrap("setDefaults", $$robo$$android_app_Notification_Builder$setDefaults(int ), 0, this, n);
        }

        public Builder setPriority(int n) {
            return InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_app_Notification_Builder$setPriority(int ), 0, this, n);
        }

        public Builder setCategory(String string2) {
            return InvokeDynamicSupport.bootstrap("setCategory", $$robo$$android_app_Notification_Builder$setCategory(java.lang.String ), 0, this, string2);
        }

        public Builder addPerson(String string2) {
            return InvokeDynamicSupport.bootstrap("addPerson", $$robo$$android_app_Notification_Builder$addPerson(java.lang.String ), 0, this, string2);
        }

        public Builder setGroup(String string2) {
            return InvokeDynamicSupport.bootstrap("setGroup", $$robo$$android_app_Notification_Builder$setGroup(java.lang.String ), 0, this, string2);
        }

        public Builder setGroupSummary(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setGroupSummary", $$robo$$android_app_Notification_Builder$setGroupSummary(boolean ), 0, this, bl);
        }

        public Builder setSortKey(String string2) {
            return InvokeDynamicSupport.bootstrap("setSortKey", $$robo$$android_app_Notification_Builder$setSortKey(java.lang.String ), 0, this, string2);
        }

        public Builder addExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_Builder$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        public Builder setExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_app_Notification_Builder$setExtras(android.os.Bundle ), 0, this, bundle);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_Notification_Builder$getExtras(), 0, this);
        }

        public Builder addAction(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_Notification_Builder$addAction(int java.lang.CharSequence android.app.PendingIntent ), 0, this, n, charSequence, pendingIntent);
        }

        public Builder addAction(Action action) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_Notification_Builder$addAction(android.app.Notification$Action ), 0, this, action);
        }

        public Builder setStyle(Style style2) {
            return InvokeDynamicSupport.bootstrap("setStyle", $$robo$$android_app_Notification_Builder$setStyle(android.app.Notification$Style ), 0, this, style2);
        }

        public Builder setVisibility(int n) {
            return InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_app_Notification_Builder$setVisibility(int ), 0, this, n);
        }

        public Builder setPublicVersion(Notification notification) {
            return InvokeDynamicSupport.bootstrap("setPublicVersion", $$robo$$android_app_Notification_Builder$setPublicVersion(android.app.Notification ), 0, this, notification);
        }

        public Builder extend(Extender extender) {
            return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_Builder$extend(android.app.Notification$Extender ), 0, this, extender);
        }

        private void setFlag(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_Notification_Builder$setFlag(int boolean ), 0, this, n, bl);
        }

        public Builder setColor(int n) {
            return InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_app_Notification_Builder$setColor(int ), 0, this, n);
        }

        private Drawable getProfileBadgeDrawable() {
            return InvokeDynamicSupport.bootstrap("getProfileBadgeDrawable", $$robo$$android_app_Notification_Builder$getProfileBadgeDrawable(), 0, this);
        }

        private Bitmap getProfileBadge() {
            return InvokeDynamicSupport.bootstrap("getProfileBadge", $$robo$$android_app_Notification_Builder$getProfileBadge(), 0, this);
        }

        private boolean addProfileBadge(RemoteViews remoteViews, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("addProfileBadge", $$robo$$android_app_Notification_Builder$addProfileBadge(android.widget.RemoteViews int ), 0, this, remoteViews, n);
        }

        private void shrinkLine3Text(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("shrinkLine3Text", $$robo$$android_app_Notification_Builder$shrinkLine3Text(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void unshrinkLine3Text(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("unshrinkLine3Text", $$robo$$android_app_Notification_Builder$unshrinkLine3Text(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void resetStandardTemplate(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("resetStandardTemplate", $$robo$$android_app_Notification_Builder$resetStandardTemplate(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private RemoteViews applyStandardTemplate(int n) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplate", $$robo$$android_app_Notification_Builder$applyStandardTemplate(int ), 0, this, n);
        }

        private RemoteViews applyStandardTemplate(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplate", $$robo$$android_app_Notification_Builder$applyStandardTemplate(int boolean ), 0, this, n, bl);
        }

        private boolean showsTimeOrChronometer() {
            return (boolean)InvokeDynamicSupport.bootstrap("showsTimeOrChronometer", $$robo$$android_app_Notification_Builder$showsTimeOrChronometer(), 0, this);
        }

        private boolean hasThreeLines() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasThreeLines", $$robo$$android_app_Notification_Builder$hasThreeLines(), 0, this);
        }

        public static int calculateTopPadding(Context context, boolean bl, float f) {
            return (int)InvokeDynamicSupport.bootstrapStatic("calculateTopPadding", $$robo$$android_app_Notification_Builder$calculateTopPadding(android.content.Context boolean float ), 0, (Context)context, (boolean)bl, (float)f);
        }

        private void resetStandardTemplateWithActions(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("resetStandardTemplateWithActions", $$robo$$android_app_Notification_Builder$resetStandardTemplateWithActions(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private RemoteViews applyStandardTemplateWithActions(int n) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplateWithActions", $$robo$$android_app_Notification_Builder$applyStandardTemplateWithActions(int ), 0, this, n);
        }

        private RemoteViews makeContentView() {
            return InvokeDynamicSupport.bootstrap("makeContentView", $$robo$$android_app_Notification_Builder$makeContentView(), 0, this);
        }

        private RemoteViews makeTickerView() {
            return InvokeDynamicSupport.bootstrap("makeTickerView", $$robo$$android_app_Notification_Builder$makeTickerView(), 0, this);
        }

        private RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_Builder$makeBigContentView(), 0, this);
        }

        private RemoteViews makeHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeHeadsUpContentView", $$robo$$android_app_Notification_Builder$makeHeadsUpContentView(), 0, this);
        }

        private RemoteViews generateActionButton(Action action) {
            return InvokeDynamicSupport.bootstrap("generateActionButton", $$robo$$android_app_Notification_Builder$generateActionButton(android.app.Notification$Action ), 0, this, action);
        }

        private boolean isLegacy() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLegacy", $$robo$$android_app_Notification_Builder$isLegacy(), 0, this);
        }

        private void processLegacyAction(Action action, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("processLegacyAction", $$robo$$android_app_Notification_Builder$processLegacyAction(android.app.Notification$Action android.widget.RemoteViews ), 0, this, action, remoteViews);
        }

        private CharSequence processLegacyText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("processLegacyText", $$robo$$android_app_Notification_Builder$processLegacyText(java.lang.CharSequence ), 0, this, charSequence);
        }

        private void processSmallIconAsLarge(int n, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("processSmallIconAsLarge", $$robo$$android_app_Notification_Builder$processSmallIconAsLarge(int android.widget.RemoteViews ), 0, this, n, remoteViews);
        }

        private void processLargeLegacyIcon(Bitmap bitmap, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("processLargeLegacyIcon", $$robo$$android_app_Notification_Builder$processLargeLegacyIcon(android.graphics.Bitmap android.widget.RemoteViews ), 0, this, bitmap, remoteViews);
        }

        private void applyLargeIconBackground(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("applyLargeIconBackground", $$robo$$android_app_Notification_Builder$applyLargeIconBackground(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void removeLargeIconBackground(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("removeLargeIconBackground", $$robo$$android_app_Notification_Builder$removeLargeIconBackground(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void processSmallRightIcon(int n, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("processSmallRightIcon", $$robo$$android_app_Notification_Builder$processSmallRightIcon(int android.widget.RemoteViews ), 0, this, n, remoteViews);
        }

        private int sanitizeColor() {
            return (int)InvokeDynamicSupport.bootstrap("sanitizeColor", $$robo$$android_app_Notification_Builder$sanitizeColor(), 0, this);
        }

        private int resolveColor() {
            return (int)InvokeDynamicSupport.bootstrap("resolveColor", $$robo$$android_app_Notification_Builder$resolveColor(), 0, this);
        }

        public Notification buildUnstyled() {
            return InvokeDynamicSupport.bootstrap("buildUnstyled", $$robo$$android_app_Notification_Builder$buildUnstyled(), 0, this);
        }

        public void populateExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("populateExtras", $$robo$$android_app_Notification_Builder$populateExtras(android.os.Bundle ), 0, this, bundle);
        }

        public static void stripForDelivery(Notification notification) {
            InvokeDynamicSupport.bootstrapStatic("stripForDelivery", $$robo$$android_app_Notification_Builder$stripForDelivery(android.app.Notification ), 0, (Notification)notification);
        }

        public static Notification rebuild(Context context, Notification notification) {
            return InvokeDynamicSupport.bootstrapStatic("rebuild", $$robo$$android_app_Notification_Builder$rebuild(android.content.Context android.app.Notification ), 0, (Context)context, (Notification)notification);
        }

        private Notification rebuild() {
            return InvokeDynamicSupport.bootstrap("rebuild", $$robo$$android_app_Notification_Builder$rebuild(), 0, this);
        }

        private static Class<? extends Style> getNotificationStyleClass(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getNotificationStyleClass", $$robo$$android_app_Notification_Builder$getNotificationStyleClass(java.lang.String ), 0, (String)string2);
        }

        private void setBuilderContentView(Notification notification, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("setBuilderContentView", $$robo$$android_app_Notification_Builder$setBuilderContentView(android.app.Notification android.widget.RemoteViews ), 0, this, notification, remoteViews);
        }

        private void setBuilderBigContentView(Notification notification, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("setBuilderBigContentView", $$robo$$android_app_Notification_Builder$setBuilderBigContentView(android.app.Notification android.widget.RemoteViews ), 0, this, notification, remoteViews);
        }

        private void setBuilderHeadsUpContentView(Notification notification, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("setBuilderHeadsUpContentView", $$robo$$android_app_Notification_Builder$setBuilderHeadsUpContentView(android.app.Notification android.widget.RemoteViews ), 0, this, notification, remoteViews);
        }

        private void restoreFromNotification(Notification notification) {
            InvokeDynamicSupport.bootstrap("restoreFromNotification", $$robo$$android_app_Notification_Builder$restoreFromNotification(android.app.Notification ), 0, this, notification);
        }

        @Deprecated
        public Notification getNotification() {
            return InvokeDynamicSupport.bootstrap("getNotification", $$robo$$android_app_Notification_Builder$getNotification(), 0, this);
        }

        public Notification build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_Builder$build(), 0, this);
        }

        public Notification buildInto(Notification notification) {
            return InvokeDynamicSupport.bootstrap("buildInto", $$robo$$android_app_Notification_Builder$buildInto(android.app.Notification ), 0, this, notification);
        }

        private int getBaseLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBaseLayoutResource", $$robo$$android_app_Notification_Builder$getBaseLayoutResource(), 0, this);
        }

        private int getBigBaseLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBigBaseLayoutResource", $$robo$$android_app_Notification_Builder$getBigBaseLayoutResource(), 0, this);
        }

        private int getBigPictureLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBigPictureLayoutResource", $$robo$$android_app_Notification_Builder$getBigPictureLayoutResource(), 0, this);
        }

        private int getBigTextLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBigTextLayoutResource", $$robo$$android_app_Notification_Builder$getBigTextLayoutResource(), 0, this);
        }

        private int getInboxLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getInboxLayoutResource", $$robo$$android_app_Notification_Builder$getInboxLayoutResource(), 0, this);
        }

        private int getActionLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getActionLayoutResource", $$robo$$android_app_Notification_Builder$getActionLayoutResource(), 0, this);
        }

        private int getActionTombstoneLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTombstoneLayoutResource", $$robo$$android_app_Notification_Builder$getActionTombstoneLayoutResource(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Action
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bundle mExtras;
        private RemoteInput[] mRemoteInputs;
        public int icon;
        public CharSequence title;
        public PendingIntent actionIntent;
        public static Parcelable.Creator<Action> CREATOR;

        private void $$robo$$android_app_Notification_Action$__constructor__(Parcel in) {
            this.icon = in.readInt();
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() == 1) {
                this.actionIntent = PendingIntent.CREATOR.createFromParcel(in);
            }
            this.mExtras = in.readBundle();
            this.mRemoteInputs = in.createTypedArray(RemoteInput.CREATOR);
        }

        private void $$robo$$android_app_Notification_Action$__constructor__(int icon, CharSequence title, PendingIntent intent) {
        }

        private void $$robo$$android_app_Notification_Action$__constructor__(int icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs) {
            this.icon = icon;
            this.title = title;
            this.actionIntent = intent;
            this.mExtras = extras != null ? extras : new Bundle();
            this.mRemoteInputs = remoteInputs;
        }

        private final Bundle $$robo$$android_app_Notification_Action$getExtras() {
            return this.mExtras;
        }

        private final RemoteInput[] $$robo$$android_app_Notification_Action$getRemoteInputs() {
            return this.mRemoteInputs;
        }

        private final Action $$robo$$android_app_Notification_Action$clone() {
            return new Action(this.icon, this.title, this.actionIntent, new Bundle(this.mExtras), this.getRemoteInputs());
        }

        private final int $$robo$$android_app_Notification_Action$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_Notification_Action$writeToParcel(Parcel out, int flags) {
            out.writeInt(this.icon);
            TextUtils.writeToParcel(this.title, out, flags);
            if (this.actionIntent != null) {
                out.writeInt(1);
                this.actionIntent.writeToParcel(out, flags);
            } else {
                out.writeInt(0);
            }
            out.writeBundle(this.mExtras);
            out.writeTypedArray(this.mRemoteInputs, flags);
        }

        private /* synthetic */ void $$robo$$android_app_Notification_Action$__constructor__(int x0, CharSequence x1, PendingIntent x2, Bundle x3, RemoteInput[] x4, 1 x5) {
        }

        private /* synthetic */ void $$robo$$android_app_Notification_Action$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Action>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_Notification_Action_1$__constructor__() {
                }

                private final Action $$robo$$android_app_Notification_Action_1$createFromParcel(Parcel in) {
                    return new Action(in);
                }

                private final Action[] $$robo$$android_app_Notification_Action_1$newArray(int size) {
                    return new Action[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_Notification_Action_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_1$__constructor__(), 0, this);
                }

                @Override
                public Action createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_Notification_Action_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Action[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_Notification_Action_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_Notification_Action$__constructor__(parcel);
        }

        private Action(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            this.$$robo$$android_app_Notification_Action$__constructor__(n, charSequence, pendingIntent);
        }

        public Action(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            this(n, charSequence, pendingIntent, new Bundle(), null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action$__constructor__(int java.lang.CharSequence android.app.PendingIntent ), 0, this, n, charSequence, pendingIntent);
        }

        private void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
            this.$$robo$$android_app_Notification_Action$__constructor__(n, charSequence, pendingIntent, bundle, remoteInputArray);
        }

        private Action(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action$__constructor__(int java.lang.CharSequence android.app.PendingIntent android.os.Bundle android.app.RemoteInput[] ), 0, this, n, charSequence, pendingIntent, bundle, remoteInputArray);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_Notification_Action$getExtras(), 0, this);
        }

        public RemoteInput[] getRemoteInputs() {
            return InvokeDynamicSupport.bootstrap("getRemoteInputs", $$robo$$android_app_Notification_Action$getRemoteInputs(), 0, this);
        }

        public Action clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_Action$clone(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_Notification_Action$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_Notification_Action$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray, 1 var6_6) {
            this.$$robo$$android_app_Notification_Action$__constructor__(n, charSequence, pendingIntent, bundle, remoteInputArray, var6_6);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_Notification_Action$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Action.class);
        }

        public /* synthetic */ Action() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Action)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class WearableExtender
        implements Extender,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private static String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
            private static String KEY_FLAGS = "flags";
            private static int FLAG_AVAILABLE_OFFLINE = 1;
            private static int DEFAULT_FLAGS = 1;
            private int mFlags;

            private void $$robo$$android_app_Notification_Action_WearableExtender$__constructor__() {
                this.mFlags = 1;
            }

            private void $$robo$$android_app_Notification_Action_WearableExtender$__constructor__(Action action) {
                this.mFlags = 1;
                Bundle wearableBundle = action.getExtras().getBundle("android.wearable.EXTENSIONS");
                if (wearableBundle != null) {
                    this.mFlags = wearableBundle.getInt("flags", 1);
                }
            }

            private final Builder $$robo$$android_app_Notification_Action_WearableExtender$extend(Builder builder) {
                Bundle wearableBundle = new Bundle();
                if (this.mFlags != 1) {
                    wearableBundle.putInt("flags", this.mFlags);
                }
                builder.getExtras().putBundle("android.wearable.EXTENSIONS", wearableBundle);
                return builder;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$clone() {
                WearableExtender that = new WearableExtender();
                that.mFlags = this.mFlags;
                return that;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$setAvailableOffline(boolean availableOffline) {
                this.setFlag(1, availableOffline);
                return this;
            }

            private final boolean $$robo$$android_app_Notification_Action_WearableExtender$isAvailableOffline() {
                return (this.mFlags & 1) != 0;
            }

            private final void $$robo$$android_app_Notification_Action_WearableExtender$setFlag(int mask, boolean value) {
                this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
            }

            private void __constructor__() {
                this.$$robo$$android_app_Notification_Action_WearableExtender$__constructor__();
            }

            public WearableExtender() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_WearableExtender$__constructor__(), 0, this);
            }

            private void __constructor__(Action action) {
                this.$$robo$$android_app_Notification_Action_WearableExtender$__constructor__(action);
            }

            public WearableExtender(Action action) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_WearableExtender$__constructor__(android.app.Notification$Action ), 0, this, action);
            }

            @Override
            public Builder extend(Builder builder) {
                return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_Action_WearableExtender$extend(android.app.Notification$Action$Builder ), 0, this, builder);
            }

            public WearableExtender clone() {
                return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_Action_WearableExtender$clone(), 0, this);
            }

            public WearableExtender setAvailableOffline(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setAvailableOffline", $$robo$$android_app_Notification_Action_WearableExtender$setAvailableOffline(boolean ), 0, this, bl);
            }

            public boolean isAvailableOffline() {
                return (boolean)InvokeDynamicSupport.bootstrap("isAvailableOffline", $$robo$$android_app_Notification_Action_WearableExtender$isAvailableOffline(), 0, this);
            }

            private void setFlag(int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_Notification_Action_WearableExtender$setFlag(int boolean ), 0, this, n, bl);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WearableExtender)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface Extender
        extends InstrumentedInterface {
            public Builder extend(Builder var1);
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private int mIcon;
            private CharSequence mTitle;
            private PendingIntent mIntent;
            private Bundle mExtras;
            private ArrayList<RemoteInput> mRemoteInputs;

            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(int icon, CharSequence title, PendingIntent intent) {
            }

            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(Action action) {
            }

            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(int icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs) {
                this.mIcon = icon;
                this.mTitle = title;
                this.mIntent = intent;
                this.mExtras = extras;
                if (remoteInputs != null) {
                    this.mRemoteInputs = new ArrayList(remoteInputs.length);
                    Collections.addAll(this.mRemoteInputs, remoteInputs);
                }
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$addExtras(Bundle extras) {
                if (extras != null) {
                    this.mExtras.putAll(extras);
                }
                return this;
            }

            private final Bundle $$robo$$android_app_Notification_Action_Builder$getExtras() {
                return this.mExtras;
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$addRemoteInput(RemoteInput remoteInput) {
                if (this.mRemoteInputs == null) {
                    this.mRemoteInputs = new ArrayList();
                }
                this.mRemoteInputs.add(remoteInput);
                return this;
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$extend(Extender extender) {
                extender.extend(this);
                return this;
            }

            private final Action $$robo$$android_app_Notification_Action_Builder$build() {
                RemoteInput[] remoteInputs = this.mRemoteInputs != null ? this.mRemoteInputs.toArray(new RemoteInput[this.mRemoteInputs.size()]) : null;
                return new Action(this.mIcon, this.mTitle, this.mIntent, this.mExtras, remoteInputs);
            }

            private void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(n, charSequence, pendingIntent);
            }

            public Builder(int n, CharSequence charSequence, PendingIntent pendingIntent) {
                this(n, charSequence, pendingIntent, new Bundle(), null);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(int java.lang.CharSequence android.app.PendingIntent ), 0, this, n, charSequence, pendingIntent);
            }

            private void __constructor__(Action action) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(action);
            }

            public Builder(Action action) {
                this(action.icon, action.title, action.actionIntent, new Bundle(action.mExtras), action.getRemoteInputs());
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(android.app.Notification$Action ), 0, this, action);
            }

            private void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(n, charSequence, pendingIntent, bundle, remoteInputArray);
            }

            private Builder(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(int java.lang.CharSequence android.app.PendingIntent android.os.Bundle android.app.RemoteInput[] ), 0, this, n, charSequence, pendingIntent, bundle, remoteInputArray);
            }

            public Builder addExtras(Bundle bundle) {
                return InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_Action_Builder$addExtras(android.os.Bundle ), 0, this, bundle);
            }

            public Bundle getExtras() {
                return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_Notification_Action_Builder$getExtras(), 0, this);
            }

            public Builder addRemoteInput(RemoteInput remoteInput) {
                return InvokeDynamicSupport.bootstrap("addRemoteInput", $$robo$$android_app_Notification_Action_Builder$addRemoteInput(android.app.RemoteInput ), 0, this, remoteInput);
            }

            public Builder extend(Extender extender) {
                return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_Action_Builder$extend(android.app.Notification$Action$Extender ), 0, this, extender);
            }

            public Action build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_Action_Builder$build(), 0, this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

