/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.INotificationManager;
import android.app.Notification;
import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.UserHandle;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NotificationManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean localLOGV;
    public static String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    private static INotificationManager sService;
    private Context mContext;

    private static final INotificationManager $$robo$$android_app_NotificationManager$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("notification");
        sService = INotificationManager.Stub.asInterface(b);
        return sService;
    }

    private void $$robo$$android_app_NotificationManager$__constructor__(Context context, Handler handler) {
        this.mContext = context;
    }

    private static final NotificationManager $$robo$$android_app_NotificationManager$from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    private final void $$robo$$android_app_NotificationManager$notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    private final void $$robo$$android_app_NotificationManager$notify(String tag, int id2, Notification notification) {
        int[] idOut = new int[1];
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        if (localLOGV) {
            Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
        }
        Object stripped = notification.clone();
        Notification.Builder.stripForDelivery((Notification)stripped);
        try {
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, (Notification)stripped, idOut, UserHandle.myUserId());
            if (id2 != idOut[0]) {
                Log.w(TAG, "notify: id corrupted: sent " + id2 + ", got back " + idOut[0]);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_NotificationManager$notifyAsUser(String tag, int id2, Notification notification, UserHandle user) {
        int[] idOut = new int[1];
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        if (localLOGV) {
            Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
        }
        Object stripped = notification.clone();
        Notification.Builder.stripForDelivery((Notification)stripped);
        try {
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, (Notification)stripped, idOut, user.getIdentifier());
            if (id2 != idOut[0]) {
                Log.w(TAG, "notify: id corrupted: sent " + id2 + ", got back " + idOut[0]);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_NotificationManager$cancel(int id2) {
        this.cancel(null, id2);
    }

    private final void $$robo$$android_app_NotificationManager$cancel(String tag, int id2) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, tag, id2, UserHandle.myUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_NotificationManager$cancelAsUser(String tag, int id2, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, tag, id2, user.getIdentifier());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_NotificationManager$cancelAll() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.cancelAllNotifications(pkg, UserHandle.myUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final ComponentName $$robo$$android_app_NotificationManager$getEffectsSuppressor() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEffectsSuppressor();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$matchesCallFilter(Bundle extras) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.matchesCallFilter(extras);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    static void __staticInitializer__() {
        TAG = "NotificationManager";
        localLOGV = false;
    }

    public static INotificationManager getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_app_NotificationManager$getService(), 0);
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_app_NotificationManager$__constructor__(context, handler);
    }

    NotificationManager(Context context, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public static NotificationManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_app_NotificationManager$from(android.content.Context ), 0, (Context)context);
    }

    public void notify(int n, Notification notification) {
        InvokeDynamicSupport.bootstrap("notify", $$robo$$android_app_NotificationManager$notify(int android.app.Notification ), 0, this, n, notification);
    }

    public void notify(String string2, int n, Notification notification) {
        InvokeDynamicSupport.bootstrap("notify", $$robo$$android_app_NotificationManager$notify(java.lang.String int android.app.Notification ), 0, this, string2, n, notification);
    }

    public void notifyAsUser(String string2, int n, Notification notification, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("notifyAsUser", $$robo$$android_app_NotificationManager$notifyAsUser(java.lang.String int android.app.Notification android.os.UserHandle ), 0, this, string2, n, notification, userHandle);
    }

    public void cancel(int n) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_NotificationManager$cancel(int ), 0, this, n);
    }

    public void cancel(String string2, int n) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_NotificationManager$cancel(java.lang.String int ), 0, this, string2, n);
    }

    public void cancelAsUser(String string2, int n, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("cancelAsUser", $$robo$$android_app_NotificationManager$cancelAsUser(java.lang.String int android.os.UserHandle ), 0, this, string2, n, userHandle);
    }

    public void cancelAll() {
        InvokeDynamicSupport.bootstrap("cancelAll", $$robo$$android_app_NotificationManager$cancelAll(), 0, this);
    }

    public ComponentName getEffectsSuppressor() {
        return InvokeDynamicSupport.bootstrap("getEffectsSuppressor", $$robo$$android_app_NotificationManager$getEffectsSuppressor(), 0, this);
    }

    public boolean matchesCallFilter(Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesCallFilter", $$robo$$android_app_NotificationManager$matchesCallFilter(android.os.Bundle ), 0, this, bundle);
    }

    static {
        RobolectricInternals.classInitializing(NotificationManager.class);
    }

    public /* synthetic */ NotificationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

