/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.internal.R;
import java.text.NumberFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ProgressDialog
extends AlertDialog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STYLE_SPINNER = 0;
    public static int STYLE_HORIZONTAL = 1;
    private ProgressBar mProgress;
    private TextView mMessageView;
    private int mProgressStyle;
    private TextView mProgressNumber;
    private String mProgressNumberFormat;
    private TextView mProgressPercent;
    private NumberFormat mProgressPercentFormat;
    private int mMax;
    private int mProgressVal;
    private int mSecondaryProgressVal;
    private int mIncrementBy;
    private int mIncrementSecondaryBy;
    private Drawable mProgressDrawable;
    private Drawable mIndeterminateDrawable;
    private CharSequence mMessage;
    private boolean mIndeterminate;
    private boolean mHasStarted;
    private Handler mViewUpdateHandler;

    private void $$robo$$android_app_ProgressDialog$__constructor__(Context context) {
        this.mProgressStyle = 0;
        this.initFormats();
    }

    private void $$robo$$android_app_ProgressDialog$__constructor__(Context context, int theme) {
        this.mProgressStyle = 0;
        this.initFormats();
    }

    private final void $$robo$$android_app_ProgressDialog$initFormats() {
        this.mProgressNumberFormat = "%1d/%2d";
        this.mProgressPercentFormat = NumberFormat.getPercentInstance();
        this.mProgressPercentFormat.setMaximumFractionDigits(0);
    }

    private static final ProgressDialog $$robo$$android_app_ProgressDialog$show(Context context, CharSequence title, CharSequence message) {
        return ProgressDialog.show(context, title, message, false);
    }

    private static final ProgressDialog $$robo$$android_app_ProgressDialog$show(Context context, CharSequence title, CharSequence message, boolean indeterminate) {
        return ProgressDialog.show(context, title, message, indeterminate, false, null);
    }

    private static final ProgressDialog $$robo$$android_app_ProgressDialog$show(Context context, CharSequence title, CharSequence message, boolean indeterminate, boolean cancelable) {
        return ProgressDialog.show(context, title, message, indeterminate, cancelable, null);
    }

    private static final ProgressDialog $$robo$$android_app_ProgressDialog$show(Context context, CharSequence title, CharSequence message, boolean indeterminate, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        ProgressDialog dialog = new ProgressDialog(context);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setIndeterminate(indeterminate);
        dialog.setCancelable(cancelable);
        dialog.setOnCancelListener(cancelListener);
        dialog.show();
        return dialog;
    }

    private final void $$robo$$android_app_ProgressDialog$onCreate(Bundle savedInstanceState) {
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        TypedArray a = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        if (this.mProgressStyle == 1) {
            this.mViewUpdateHandler = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ProgressDialog this$0;

                private void $$robo$$android_app_ProgressDialog_1$__constructor__(ProgressDialog progressDialog) {
                }

                private final void $$robo$$android_app_ProgressDialog_1$handleMessage(Message msg) {
                    super.handleMessage(msg);
                    int progress = this.this$0.mProgress.getProgress();
                    int max = this.this$0.mProgress.getMax();
                    if (this.this$0.mProgressNumberFormat != null) {
                        String format = this.this$0.mProgressNumberFormat;
                        this.this$0.mProgressNumber.setText(String.format(format, progress, max));
                    } else {
                        this.this$0.mProgressNumber.setText("");
                    }
                    if (this.this$0.mProgressPercentFormat != null) {
                        double percent = (double)progress / (double)max;
                        SpannableString tmp = new SpannableString(this.this$0.mProgressPercentFormat.format(percent));
                        tmp.setSpan(new StyleSpan(1), 0, tmp.length(), 33);
                        this.this$0.mProgressPercent.setText(tmp);
                    } else {
                        this.this$0.mProgressPercent.setText("");
                    }
                }

                private void __constructor__(ProgressDialog progressDialog) {
                    this.$$robo$$android_app_ProgressDialog_1$__constructor__(progressDialog);
                }
                {
                    this.this$0 = progressDialog;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ProgressDialog_1$__constructor__(android.app.ProgressDialog ), 0, this, progressDialog);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_ProgressDialog_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            View view = inflater.inflate(a.getResourceId(17, 17367084), null);
            this.mProgress = (ProgressBar)view.findViewById(16908301);
            this.mProgressNumber = (TextView)view.findViewById(16909003);
            this.mProgressPercent = (TextView)view.findViewById(16909002);
            this.setView(view);
        } else {
            View view = inflater.inflate(a.getResourceId(16, 17367206), null);
            this.mProgress = (ProgressBar)view.findViewById(16908301);
            this.mMessageView = (TextView)view.findViewById(16908299);
            this.setView(view);
        }
        a.recycle();
        if (this.mMax > 0) {
            this.setMax(this.mMax);
        }
        if (this.mProgressVal > 0) {
            this.setProgress(this.mProgressVal);
        }
        if (this.mSecondaryProgressVal > 0) {
            this.setSecondaryProgress(this.mSecondaryProgressVal);
        }
        if (this.mIncrementBy > 0) {
            this.incrementProgressBy(this.mIncrementBy);
        }
        if (this.mIncrementSecondaryBy > 0) {
            this.incrementSecondaryProgressBy(this.mIncrementSecondaryBy);
        }
        if (this.mProgressDrawable != null) {
            this.setProgressDrawable(this.mProgressDrawable);
        }
        if (this.mIndeterminateDrawable != null) {
            this.setIndeterminateDrawable(this.mIndeterminateDrawable);
        }
        if (this.mMessage != null) {
            this.setMessage(this.mMessage);
        }
        this.setIndeterminate(this.mIndeterminate);
        this.onProgressChanged();
        super.onCreate(savedInstanceState);
    }

    private final void $$robo$$android_app_ProgressDialog$onStart() {
        super.onStart();
        this.mHasStarted = true;
    }

    private final void $$robo$$android_app_ProgressDialog$onStop() {
        super.onStop();
        this.mHasStarted = false;
    }

    private final void $$robo$$android_app_ProgressDialog$setProgress(int value) {
        if (this.mHasStarted) {
            this.mProgress.setProgress(value);
            this.onProgressChanged();
        } else {
            this.mProgressVal = value;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$setSecondaryProgress(int secondaryProgress) {
        if (this.mProgress != null) {
            this.mProgress.setSecondaryProgress(secondaryProgress);
            this.onProgressChanged();
        } else {
            this.mSecondaryProgressVal = secondaryProgress;
        }
    }

    private final int $$robo$$android_app_ProgressDialog$getProgress() {
        if (this.mProgress != null) {
            return this.mProgress.getProgress();
        }
        return this.mProgressVal;
    }

    private final int $$robo$$android_app_ProgressDialog$getSecondaryProgress() {
        if (this.mProgress != null) {
            return this.mProgress.getSecondaryProgress();
        }
        return this.mSecondaryProgressVal;
    }

    private final int $$robo$$android_app_ProgressDialog$getMax() {
        if (this.mProgress != null) {
            return this.mProgress.getMax();
        }
        return this.mMax;
    }

    private final void $$robo$$android_app_ProgressDialog$setMax(int max) {
        if (this.mProgress != null) {
            this.mProgress.setMax(max);
            this.onProgressChanged();
        } else {
            this.mMax = max;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$incrementProgressBy(int diff) {
        if (this.mProgress != null) {
            this.mProgress.incrementProgressBy(diff);
            this.onProgressChanged();
        } else {
            this.mIncrementBy += diff;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$incrementSecondaryProgressBy(int diff) {
        if (this.mProgress != null) {
            this.mProgress.incrementSecondaryProgressBy(diff);
            this.onProgressChanged();
        } else {
            this.mIncrementSecondaryBy += diff;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$setProgressDrawable(Drawable d) {
        if (this.mProgress != null) {
            this.mProgress.setProgressDrawable(d);
        } else {
            this.mProgressDrawable = d;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$setIndeterminateDrawable(Drawable d) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminateDrawable(d);
        } else {
            this.mIndeterminateDrawable = d;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$setIndeterminate(boolean indeterminate) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminate(indeterminate);
        } else {
            this.mIndeterminate = indeterminate;
        }
    }

    private final boolean $$robo$$android_app_ProgressDialog$isIndeterminate() {
        if (this.mProgress != null) {
            return this.mProgress.isIndeterminate();
        }
        return this.mIndeterminate;
    }

    private final void $$robo$$android_app_ProgressDialog$setMessage(CharSequence message) {
        if (this.mProgress != null) {
            if (this.mProgressStyle == 1) {
                super.setMessage(message);
            } else {
                this.mMessageView.setText(message);
            }
        } else {
            this.mMessage = message;
        }
    }

    private final void $$robo$$android_app_ProgressDialog$setProgressStyle(int style2) {
        this.mProgressStyle = style2;
    }

    private final void $$robo$$android_app_ProgressDialog$setProgressNumberFormat(String format) {
        this.mProgressNumberFormat = format;
        this.onProgressChanged();
    }

    private final void $$robo$$android_app_ProgressDialog$setProgressPercentFormat(NumberFormat format) {
        this.mProgressPercentFormat = format;
        this.onProgressChanged();
    }

    private final void $$robo$$android_app_ProgressDialog$onProgressChanged() {
        if (this.mProgressStyle == 1 && this.mViewUpdateHandler != null && !this.mViewUpdateHandler.hasMessages(0)) {
            this.mViewUpdateHandler.sendEmptyMessage(0);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_ProgressDialog$__constructor__(context);
    }

    public ProgressDialog(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ProgressDialog$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_app_ProgressDialog$__constructor__(context, n);
    }

    public ProgressDialog(Context context, int n) {
        super(context, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ProgressDialog$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    private void initFormats() {
        InvokeDynamicSupport.bootstrap("initFormats", $$robo$$android_app_ProgressDialog$initFormats(), 0, this);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2) {
        return InvokeDynamicSupport.bootstrapStatic("show", $$robo$$android_app_ProgressDialog$show(android.content.Context java.lang.CharSequence java.lang.CharSequence ), 0, (Context)context, (CharSequence)charSequence, (CharSequence)charSequence2);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("show", $$robo$$android_app_ProgressDialog$show(android.content.Context java.lang.CharSequence java.lang.CharSequence boolean ), 0, (Context)context, (CharSequence)charSequence, (CharSequence)charSequence2, (boolean)bl);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("show", $$robo$$android_app_ProgressDialog$show(android.content.Context java.lang.CharSequence java.lang.CharSequence boolean boolean ), 0, (Context)context, (CharSequence)charSequence, (CharSequence)charSequence2, (boolean)bl, (boolean)bl2);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2, DialogInterface.OnCancelListener onCancelListener) {
        return InvokeDynamicSupport.bootstrapStatic("show", $$robo$$android_app_ProgressDialog$show(android.content.Context java.lang.CharSequence java.lang.CharSequence boolean boolean android.content.DialogInterface$OnCancelListener ), 0, (Context)context, (CharSequence)charSequence, (CharSequence)charSequence2, (boolean)bl, (boolean)bl2, (DialogInterface.OnCancelListener)onCancelListener);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_app_ProgressDialog$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_app_ProgressDialog$onStart(), 0, this);
    }

    @Override
    protected void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_app_ProgressDialog$onStop(), 0, this);
    }

    public void setProgress(int n) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_app_ProgressDialog$setProgress(int ), 0, this, n);
    }

    public void setSecondaryProgress(int n) {
        InvokeDynamicSupport.bootstrap("setSecondaryProgress", $$robo$$android_app_ProgressDialog$setSecondaryProgress(int ), 0, this, n);
    }

    public int getProgress() {
        return (int)InvokeDynamicSupport.bootstrap("getProgress", $$robo$$android_app_ProgressDialog$getProgress(), 0, this);
    }

    public int getSecondaryProgress() {
        return (int)InvokeDynamicSupport.bootstrap("getSecondaryProgress", $$robo$$android_app_ProgressDialog$getSecondaryProgress(), 0, this);
    }

    public int getMax() {
        return (int)InvokeDynamicSupport.bootstrap("getMax", $$robo$$android_app_ProgressDialog$getMax(), 0, this);
    }

    public void setMax(int n) {
        InvokeDynamicSupport.bootstrap("setMax", $$robo$$android_app_ProgressDialog$setMax(int ), 0, this, n);
    }

    public void incrementProgressBy(int n) {
        InvokeDynamicSupport.bootstrap("incrementProgressBy", $$robo$$android_app_ProgressDialog$incrementProgressBy(int ), 0, this, n);
    }

    public void incrementSecondaryProgressBy(int n) {
        InvokeDynamicSupport.bootstrap("incrementSecondaryProgressBy", $$robo$$android_app_ProgressDialog$incrementSecondaryProgressBy(int ), 0, this, n);
    }

    public void setProgressDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setProgressDrawable", $$robo$$android_app_ProgressDialog$setProgressDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIndeterminateDrawable", $$robo$$android_app_ProgressDialog$setIndeterminateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setIndeterminate(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIndeterminate", $$robo$$android_app_ProgressDialog$setIndeterminate(boolean ), 0, this, bl);
    }

    public boolean isIndeterminate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIndeterminate", $$robo$$android_app_ProgressDialog$isIndeterminate(), 0, this);
    }

    @Override
    public void setMessage(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setMessage", $$robo$$android_app_ProgressDialog$setMessage(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setProgressStyle(int n) {
        InvokeDynamicSupport.bootstrap("setProgressStyle", $$robo$$android_app_ProgressDialog$setProgressStyle(int ), 0, this, n);
    }

    public void setProgressNumberFormat(String string2) {
        InvokeDynamicSupport.bootstrap("setProgressNumberFormat", $$robo$$android_app_ProgressDialog$setProgressNumberFormat(java.lang.String ), 0, this, string2);
    }

    public void setProgressPercentFormat(NumberFormat numberFormat) {
        InvokeDynamicSupport.bootstrap("setProgressPercentFormat", $$robo$$android_app_ProgressDialog$setProgressPercentFormat(java.text.NumberFormat ), 0, this, numberFormat);
    }

    private void onProgressChanged() {
        InvokeDynamicSupport.bootstrap("onProgressChanged", $$robo$$android_app_ProgressDialog$onProgressChanged(), 0, this);
    }

    public /* synthetic */ ProgressDialog() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgressDialog)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

