/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesKey;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import java.lang.ref.WeakReference;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResourcesManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "ResourcesManager";
    static boolean DEBUG_CACHE = false;
    static boolean DEBUG_STATS = true;
    private static ResourcesManager sResourcesManager;
    ArrayMap<ResourcesKey, WeakReference<Resources>> mActiveResources;
    ArrayMap<DisplayAdjustments, DisplayMetrics> mDefaultDisplayMetrics;
    CompatibilityInfo mResCompatibilityInfo;
    Configuration mResConfiguration;
    Configuration mTmpConfig;

    private void $$robo$$android_app_ResourcesManager$__constructor__() {
        this.mActiveResources = new ArrayMap();
        this.mDefaultDisplayMetrics = new ArrayMap();
        this.mTmpConfig = new Configuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourcesManager $$robo$$android_app_ResourcesManager$getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    private final Configuration $$robo$$android_app_ResourcesManager$getConfiguration() {
        return this.mResConfiguration;
    }

    private final void $$robo$$android_app_ResourcesManager$flushDisplayMetricsLocked() {
        this.mDefaultDisplayMetrics.clear();
    }

    private final DisplayMetrics $$robo$$android_app_ResourcesManager$getDisplayMetricsLocked(int displayId) {
        return this.getDisplayMetricsLocked(displayId, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    private final DisplayMetrics $$robo$$android_app_ResourcesManager$getDisplayMetricsLocked(int displayId, DisplayAdjustments daj) {
        Display d;
        DisplayMetrics dm;
        boolean isDefaultDisplay = displayId == 0;
        DisplayMetrics displayMetrics = dm = isDefaultDisplay ? this.mDefaultDisplayMetrics.get(daj) : null;
        if (dm != null) {
            return dm;
        }
        dm = new DisplayMetrics();
        DisplayManagerGlobal displayManager = DisplayManagerGlobal.getInstance();
        if (displayManager == null) {
            dm.setToDefaults();
            return dm;
        }
        if (isDefaultDisplay) {
            this.mDefaultDisplayMetrics.put(daj, dm);
        }
        if ((d = displayManager.getCompatibleDisplay(displayId, daj)) != null) {
            d.getMetrics(dm);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private final void $$robo$$android_app_ResourcesManager$applyNonDefaultDisplayMetricsToConfigurationLocked(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = config.screenWidthDp;
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    private final boolean $$robo$$android_app_ResourcesManager$applyCompatConfiguration(int displayDensity, Configuration compatConfiguration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$getTopLevelResources(String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfiguration, CompatibilityInfo compatInfo, IBinder token) {
        Configuration config;
        Resources r;
        float scale = compatInfo.applicationScale;
        ResourcesKey key = new ResourcesKey(resDir, displayId, overrideConfiguration, scale, token);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            WeakReference<Resources> wr = this.mActiveResources.get(key);
            Resources resources = r = wr != null ? (Resources)wr.get() : null;
            if (r != null && r.getAssets().isUpToDate()) {
                return r;
            }
        }
        AssetManager assets = new AssetManager();
        if (resDir != null && assets.addAssetPath(resDir) == 0) {
            return null;
        }
        if (splitResDirs != null) {
            for (String splitResDir : splitResDirs) {
                if (assets.addAssetPath(splitResDir) != 0) continue;
                return null;
            }
        }
        if (overlayDirs != null) {
            for (String idmapPath : overlayDirs) {
                assets.addOverlayPath(idmapPath);
            }
        }
        if (libDirs != null) {
            for (String libDir : libDirs) {
                if (assets.addAssetPath(libDir) != 0) continue;
                Slog.w("ResourcesManager", "Asset path '" + libDir + "' does not exist or contains no resources.");
            }
        }
        DisplayMetrics dm = this.getDisplayMetricsLocked(displayId);
        boolean isDefaultDisplay = displayId == 0;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (!isDefaultDisplay || hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            if (!isDefaultDisplay) {
                this.applyNonDefaultDisplayMetricsToConfigurationLocked(dm, config);
            }
            if (hasOverrideConfig) {
                config.updateFrom(key.mOverrideConfiguration);
            }
        } else {
            config = this.getConfiguration();
        }
        r = new Resources(assets, dm, config, compatInfo, token);
        ResourcesManager resourcesManager2 = this;
        synchronized (resourcesManager2) {
            Resources existing;
            WeakReference<Resources> wr = this.mActiveResources.get(key);
            Resources resources = existing = wr != null ? (Resources)wr.get() : null;
            if (existing != null && existing.getAssets().isUpToDate()) {
                r.getAssets().close();
                return existing;
            }
            this.mActiveResources.put(key, new WeakReference<Resources>(r));
            return r;
        }
    }

    private final boolean $$robo$$android_app_ResourcesManager$applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        if (this.mResConfiguration == null) {
            this.mResConfiguration = new Configuration();
        }
        if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
            return false;
        }
        int changes = this.mResConfiguration.updateFrom(config);
        this.flushDisplayMetricsLocked();
        DisplayMetrics defaultDisplayMetrics = this.getDisplayMetricsLocked(0);
        if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
            this.mResCompatibilityInfo = compat;
            changes |= 0xD00;
        }
        if (config.locale != null) {
            Locale.setDefault(config.locale);
        }
        Resources.updateSystemConfiguration(config, defaultDisplayMetrics, compat);
        ApplicationPackageManager.configurationChanged();
        Configuration tmpConfig = null;
        for (int i = this.mActiveResources.size() - 1; i >= 0; --i) {
            ResourcesKey key = this.mActiveResources.keyAt(i);
            Resources r = (Resources)this.mActiveResources.valueAt(i).get();
            if (r != null) {
                int displayId = key.mDisplayId;
                boolean isDefaultDisplay = displayId == 0;
                DisplayMetrics dm = defaultDisplayMetrics;
                boolean hasOverrideConfiguration = key.hasOverrideConfiguration();
                if (!isDefaultDisplay || hasOverrideConfiguration) {
                    if (tmpConfig == null) {
                        tmpConfig = new Configuration();
                    }
                    tmpConfig.setTo(config);
                    if (!isDefaultDisplay) {
                        dm = this.getDisplayMetricsLocked(displayId);
                        this.applyNonDefaultDisplayMetricsToConfigurationLocked(dm, tmpConfig);
                    }
                    if (hasOverrideConfiguration) {
                        tmpConfig.updateFrom(key.mOverrideConfiguration);
                    }
                    r.updateConfiguration(tmpConfig, dm, compat);
                    continue;
                }
                r.updateConfiguration(config, dm, compat);
                continue;
            }
            this.mActiveResources.removeAt(i);
        }
        return changes != 0;
    }

    private void __constructor__() {
        this.$$robo$$android_app_ResourcesManager$__constructor__();
    }

    public ResourcesManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager$__constructor__(), 0, this);
    }

    public static ResourcesManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_app_ResourcesManager$getInstance(), 0);
    }

    public Configuration getConfiguration() {
        return InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_app_ResourcesManager$getConfiguration(), 0, this);
    }

    public void flushDisplayMetricsLocked() {
        InvokeDynamicSupport.bootstrap("flushDisplayMetricsLocked", $$robo$$android_app_ResourcesManager$flushDisplayMetricsLocked(), 0, this);
    }

    public DisplayMetrics getDisplayMetricsLocked(int n) {
        return InvokeDynamicSupport.bootstrap("getDisplayMetricsLocked", $$robo$$android_app_ResourcesManager$getDisplayMetricsLocked(int ), 0, this, n);
    }

    public DisplayMetrics getDisplayMetricsLocked(int n, DisplayAdjustments displayAdjustments) {
        return InvokeDynamicSupport.bootstrap("getDisplayMetricsLocked", $$robo$$android_app_ResourcesManager$getDisplayMetricsLocked(int android.view.DisplayAdjustments ), 0, this, n, displayAdjustments);
    }

    void applyNonDefaultDisplayMetricsToConfigurationLocked(DisplayMetrics displayMetrics, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("applyNonDefaultDisplayMetricsToConfigurationLocked", $$robo$$android_app_ResourcesManager$applyNonDefaultDisplayMetricsToConfigurationLocked(android.util.DisplayMetrics android.content.res.Configuration ), 0, this, displayMetrics, configuration);
    }

    public boolean applyCompatConfiguration(int n, Configuration configuration) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyCompatConfiguration", $$robo$$android_app_ResourcesManager$applyCompatConfiguration(int android.content.res.Configuration ), 0, this, n, configuration);
    }

    public Resources getTopLevelResources(String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo, IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("getTopLevelResources", $$robo$$android_app_ResourcesManager$getTopLevelResources(java.lang.String java.lang.String[] java.lang.String[] java.lang.String[] int android.content.res.Configuration android.content.res.CompatibilityInfo android.os.IBinder ), 0, this, string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo, iBinder);
    }

    public boolean applyConfigurationToResourcesLocked(Configuration configuration, CompatibilityInfo compatibilityInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyConfigurationToResourcesLocked", $$robo$$android_app_ResourcesManager$applyConfigurationToResourcesLocked(android.content.res.Configuration android.content.res.CompatibilityInfo ), 0, this, configuration, compatibilityInfo);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourcesManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

