/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.DeviceAdminInfo;
import android.app.admin.IDevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ProxyInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.security.Credentials;
import android.util.Log;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class DevicePolicyManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private Context mContext;
    private IDevicePolicyManager mService;
    public static String ACTION_PROVISION_MANAGED_PROFILE = "android.app.action.PROVISION_MANAGED_PROFILE";
    public static String EXTRA_PROVISIONING_ADMIN_EXTRAS_BUNDLE = "android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME";
    public static String EXTRA_PROVISIONING_EMAIL_ADDRESS = "android.app.extra.PROVISIONING_EMAIL_ADDRESS";
    public static String EXTRA_PROVISIONING_TIME_ZONE = "android.app.extra.PROVISIONING_TIME_ZONE";
    public static String EXTRA_PROVISIONING_LOCAL_TIME = "android.app.extra.PROVISIONING_LOCAL_TIME";
    public static String EXTRA_PROVISIONING_LOCALE = "android.app.extra.PROVISIONING_LOCALE";
    public static String EXTRA_PROVISIONING_WIFI_SSID = "android.app.extra.PROVISIONING_WIFI_SSID";
    public static String EXTRA_PROVISIONING_WIFI_HIDDEN = "android.app.extra.PROVISIONING_WIFI_HIDDEN";
    public static String EXTRA_PROVISIONING_WIFI_SECURITY_TYPE = "android.app.extra.PROVISIONING_WIFI_SECURITY_TYPE";
    public static String EXTRA_PROVISIONING_WIFI_PASSWORD = "android.app.extra.PROVISIONING_WIFI_PASSWORD";
    public static String EXTRA_PROVISIONING_WIFI_PROXY_HOST = "android.app.extra.PROVISIONING_WIFI_PROXY_HOST";
    public static String EXTRA_PROVISIONING_WIFI_PROXY_PORT = "android.app.extra.PROVISIONING_WIFI_PROXY_PORT";
    public static String EXTRA_PROVISIONING_WIFI_PROXY_BYPASS = "android.app.extra.PROVISIONING_WIFI_PROXY_BYPASS";
    public static String EXTRA_PROVISIONING_WIFI_PAC_URL = "android.app.extra.PROVISIONING_WIFI_PAC_URL";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM";
    public static String MIME_TYPE_PROVISIONING_NFC = "application/com.android.managedprovisioning";
    public static String ACTION_ADD_DEVICE_ADMIN = "android.app.action.ADD_DEVICE_ADMIN";
    public static String ACTION_SET_PROFILE_OWNER = "android.app.action.SET_PROFILE_OWNER";
    public static String EXTRA_PROFILE_OWNER_NAME = "android.app.extra.PROFILE_OWNER_NAME";
    public static String ACTION_DEVICE_POLICY_MANAGER_STATE_CHANGED = "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED";
    public static String EXTRA_DEVICE_ADMIN = "android.app.extra.DEVICE_ADMIN";
    public static String EXTRA_ADD_EXPLANATION = "android.app.extra.ADD_EXPLANATION";
    public static String ACTION_SET_NEW_PASSWORD = "android.app.action.SET_NEW_PASSWORD";
    public static int FLAG_PARENT_CAN_ACCESS_MANAGED = 1;
    public static int FLAG_MANAGED_CAN_ACCESS_PARENT = 2;
    public static int PASSWORD_QUALITY_UNSPECIFIED = 0;
    public static int PASSWORD_QUALITY_BIOMETRIC_WEAK = 32768;
    public static int PASSWORD_QUALITY_SOMETHING = 65536;
    public static int PASSWORD_QUALITY_NUMERIC = 131072;
    public static int PASSWORD_QUALITY_NUMERIC_COMPLEX = 196608;
    public static int PASSWORD_QUALITY_ALPHABETIC = 262144;
    public static int PASSWORD_QUALITY_ALPHANUMERIC = 327680;
    public static int PASSWORD_QUALITY_COMPLEX = 393216;
    public static int RESET_PASSWORD_REQUIRE_ENTRY = 1;
    public static int WIPE_EXTERNAL_STORAGE = 1;
    public static int ENCRYPTION_STATUS_UNSUPPORTED = 0;
    public static int ENCRYPTION_STATUS_INACTIVE = 1;
    public static int ENCRYPTION_STATUS_ACTIVATING = 2;
    public static int ENCRYPTION_STATUS_ACTIVE = 3;
    public static String ACTION_START_ENCRYPTION = "android.app.action.START_ENCRYPTION";
    public static int KEYGUARD_DISABLE_FEATURES_NONE = 0;
    public static int KEYGUARD_DISABLE_WIDGETS_ALL = 1;
    public static int KEYGUARD_DISABLE_SECURE_CAMERA = 2;
    public static int KEYGUARD_DISABLE_SECURE_NOTIFICATIONS = 4;
    public static int KEYGUARD_DISABLE_UNREDACTED_NOTIFICATIONS = 8;
    public static int KEYGUARD_DISABLE_TRUST_AGENTS = 16;
    public static int KEYGUARD_DISABLE_FINGERPRINT = 32;
    public static int KEYGUARD_DISABLE_FEATURES_ALL = Integer.MAX_VALUE;

    private void $$robo$$android_app_admin_DevicePolicyManager$__constructor__(Context context, Handler handler) {
        this.mContext = context;
        this.mService = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
    }

    private static final DevicePolicyManager $$robo$$android_app_admin_DevicePolicyManager$create(Context context, Handler handler) {
        DevicePolicyManager me = new DevicePolicyManager(context, handler);
        return me.mService != null ? me : null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isAdminActive(ComponentName who) {
        return this.isAdminActiveAsUser(who, UserHandle.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isAdminActiveAsUser(ComponentName who, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isAdminActive(who, userId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final List<ComponentName> $$robo$$android_app_admin_DevicePolicyManager$getActiveAdmins() {
        return this.getActiveAdminsAsUser(UserHandle.myUserId());
    }

    private final List<ComponentName> $$robo$$android_app_admin_DevicePolicyManager$getActiveAdminsAsUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getActiveAdmins(userId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$packageHasActiveAdmins(String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.packageHasActiveAdmins(packageName, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$removeActiveAdmin(ComponentName who) {
        if (this.mService != null) {
            try {
                this.mService.removeActiveAdmin(who, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$hasGrantedPolicy(ComponentName admin, int usesPolicy) {
        if (this.mService != null) {
            try {
                return this.mService.hasGrantedPolicy(admin, usesPolicy, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordQuality(ComponentName admin, int quality) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordQuality(admin, quality, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(ComponentName admin) {
        return this.getPasswordQuality(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordQuality(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLength(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLength(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(ComponentName admin) {
        return this.getPasswordMinimumLength(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLength(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumUpperCase(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumUpperCase(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(ComponentName admin) {
        return this.getPasswordMinimumUpperCase(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumUpperCase(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLowerCase(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLowerCase(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(ComponentName admin) {
        return this.getPasswordMinimumLowerCase(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLowerCase(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLetters(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLetters(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(ComponentName admin) {
        return this.getPasswordMinimumLetters(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLetters(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNumeric(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumNumeric(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(ComponentName admin) {
        return this.getPasswordMinimumNumeric(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumNumeric(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumSymbols(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumSymbols(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(ComponentName admin) {
        return this.getPasswordMinimumSymbols(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumSymbols(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNonLetter(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumNonLetter(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(ComponentName admin) {
        return this.getPasswordMinimumNonLetter(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumNonLetter(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordHistoryLength(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordHistoryLength(admin, length, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordExpirationTimeout(ComponentName admin, long timeout) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordExpirationTimeout(admin, timeout, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpirationTimeout(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordExpirationTimeout(admin, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0L;
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpiration(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordExpiration(admin, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0L;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(ComponentName admin) {
        return this.getPasswordHistoryLength(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordHistoryLength(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMaximumLength(int quality) {
        return 16;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isActivePasswordSufficient() {
        if (this.mService != null) {
            try {
                return this.mService.isActivePasswordSufficient(UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getCurrentFailedPasswordAttempts() {
        if (this.mService != null) {
            try {
                return this.mService.getCurrentFailedPasswordAttempts(UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return -1;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setMaximumFailedPasswordsForWipe(ComponentName admin, int num) {
        if (this.mService != null) {
            try {
                this.mService.setMaximumFailedPasswordsForWipe(admin, num, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(ComponentName admin) {
        return this.getMaximumFailedPasswordsForWipe(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getMaximumFailedPasswordsForWipe(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$resetPassword(String password, int flags) {
        if (this.mService != null) {
            try {
                return this.mService.resetPassword(password, flags, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setMaximumTimeToLock(ComponentName admin, long timeMs) {
        if (this.mService != null) {
            try {
                this.mService.setMaximumTimeToLock(admin, timeMs, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(ComponentName admin) {
        return this.getMaximumTimeToLock(admin, UserHandle.myUserId());
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getMaximumTimeToLock(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0L;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$lockNow() {
        if (this.mService != null) {
            try {
                this.mService.lockNow();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$wipeData(int flags) {
        if (this.mService != null) {
            try {
                this.mService.wipeData(flags, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$setGlobalProxy(ComponentName admin, Proxy proxySpec, List<String> exclusionList) {
        if (proxySpec == null) {
            throw new NullPointerException();
        }
        if (this.mService != null) {
            try {
                String exclSpec;
                String hostSpec;
                if (proxySpec.equals(Proxy.NO_PROXY)) {
                    hostSpec = null;
                    exclSpec = null;
                } else {
                    if (!proxySpec.type().equals((Object)Proxy.Type.HTTP)) {
                        throw new IllegalArgumentException();
                    }
                    InetSocketAddress sa = (InetSocketAddress)proxySpec.address();
                    String hostName = sa.getHostName();
                    int port = sa.getPort();
                    StringBuilder hostBuilder = new StringBuilder();
                    hostSpec = hostBuilder.append(hostName).append(":").append(Integer.toString(port)).toString();
                    if (exclusionList == null) {
                        exclSpec = "";
                    } else {
                        StringBuilder listBuilder = new StringBuilder();
                        boolean firstDomain = true;
                        for (String exclDomain : exclusionList) {
                            if (!firstDomain) {
                                listBuilder = listBuilder.append(",");
                            } else {
                                firstDomain = false;
                            }
                            listBuilder = listBuilder.append(exclDomain.trim());
                        }
                        exclSpec = listBuilder.toString();
                    }
                    if (android.net.Proxy.validate(hostName, Integer.toString(port), exclSpec) != 0) {
                        throw new IllegalArgumentException();
                    }
                }
                return this.mService.setGlobalProxy(admin, hostSpec, exclSpec, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setRecommendedGlobalProxy(ComponentName admin, ProxyInfo proxyInfo) {
        if (this.mService != null) {
            try {
                this.mService.setRecommendedGlobalProxy(admin, proxyInfo);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getGlobalProxyAdmin() {
        if (this.mService != null) {
            try {
                return this.mService.getGlobalProxyAdmin(UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$setStorageEncryption(ComponentName admin, boolean encrypt) {
        if (this.mService != null) {
            try {
                return this.mService.setStorageEncryption(admin, encrypt, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryption(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getStorageEncryption(admin, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus() {
        return this.getStorageEncryptionStatus(UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getStorageEncryptionStatus(userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installCaCert(ComponentName admin, byte[] certBuffer) {
        if (this.mService != null) {
            try {
                return this.mService.installCaCert(admin, certBuffer);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$uninstallCaCert(ComponentName admin, byte[] certBuffer) {
        if (this.mService != null) {
            try {
                String alias = DevicePolicyManager.getCaCertAlias(certBuffer);
                this.mService.uninstallCaCert(admin, alias);
            }
            catch (CertificateException e) {
                Log.w(TAG, "Unable to parse certificate", e);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final List<byte[]> $$robo$$android_app_admin_DevicePolicyManager$getInstalledCaCerts(ComponentName admin) {
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        if (this.mService != null) {
            try {
                this.mService.enforceCanManageCaCerts(admin);
                TrustedCertificateStore certStore = new TrustedCertificateStore();
                for (String alias : certStore.userAliases()) {
                    try {
                        certs.add(certStore.getCertificate(alias).getEncoded());
                    }
                    catch (CertificateException ce) {
                        Log.w(TAG, "Could not encode certificate: " + alias, ce);
                    }
                }
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed talking with device policy service", re);
            }
        }
        return certs;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$uninstallAllUserCaCerts(ComponentName admin) {
        if (this.mService != null) {
            for (String alias : new TrustedCertificateStore().userAliases()) {
                try {
                    this.mService.uninstallCaCert(admin, alias);
                }
                catch (RemoteException re) {
                    Log.w(TAG, "Failed talking with device policy service", re);
                }
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$hasCaCertInstalled(ComponentName admin, byte[] certBuffer) {
        if (this.mService != null) {
            try {
                this.mService.enforceCanManageCaCerts(admin);
                return DevicePolicyManager.getCaCertAlias(certBuffer) != null;
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed talking with device policy service", re);
            }
            catch (CertificateException ce) {
                Log.w(TAG, "Could not parse certificate", ce);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(ComponentName who, PrivateKey privKey, Certificate cert, String alias) {
        try {
            byte[] pemCert = Credentials.convertToPem(cert);
            return this.mService.installKeyPair(who, privKey.getEncoded(), pemCert, alias);
        }
        catch (CertificateException e) {
            Log.w(TAG, "Error encoding certificate", e);
        }
        catch (IOException e) {
            Log.w(TAG, "Error writing certificate", e);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed talking with device policy service", e);
        }
        return false;
    }

    private static final String $$robo$$android_app_admin_DevicePolicyManager$getCaCertAlias(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
        return new TrustedCertificateStore().getCertificateAlias(cert);
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setCameraDisabled(ComponentName admin, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setCameraDisabled(admin, disabled, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(ComponentName admin) {
        return this.getCameraDisabled(admin, UserHandle.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCameraDisabled(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setScreenCaptureDisabled(ComponentName admin, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setScreenCaptureDisabled(admin, UserHandle.myUserId(), disabled);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(ComponentName admin) {
        return this.getScreenCaptureDisabled(admin, UserHandle.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getScreenCaptureDisabled(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setAutoTimeRequired(ComponentName admin, boolean required) {
        if (this.mService != null) {
            try {
                this.mService.setAutoTimeRequired(admin, UserHandle.myUserId(), required);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getAutoTimeRequired() {
        if (this.mService != null) {
            try {
                return this.mService.getAutoTimeRequired();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setKeyguardDisabledFeatures(ComponentName admin, int which) {
        if (this.mService != null) {
            try {
                this.mService.setKeyguardDisabledFeatures(admin, which, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(ComponentName admin) {
        return this.getKeyguardDisabledFeatures(admin, UserHandle.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getKeyguardDisabledFeatures(admin, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(ComponentName policyReceiver, boolean refreshing, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setActiveAdmin(policyReceiver, refreshing, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(ComponentName policyReceiver, boolean refreshing) {
        this.setActiveAdmin(policyReceiver, refreshing, UserHandle.myUserId());
    }

    private final DeviceAdminInfo $$robo$$android_app_admin_DevicePolicyManager$getAdminInfo(ComponentName cn) {
        ActivityInfo ai;
        try {
            ai = this.mContext.getPackageManager().getReceiverInfo(cn, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Unable to retrieve device policy " + cn, e);
            return null;
        }
        ResolveInfo ri = new ResolveInfo();
        ri.activityInfo = ai;
        try {
            return new DeviceAdminInfo(this.mContext, ri);
        }
        catch (XmlPullParserException e) {
            Log.w(TAG, "Unable to parse device policy " + cn, e);
            return null;
        }
        catch (IOException e) {
            Log.w(TAG, "Unable to parse device policy " + cn, e);
            return null;
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$getRemoveWarning(ComponentName admin, RemoteCallback result) {
        if (this.mService != null) {
            try {
                this.mService.getRemoveWarning(admin, result, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setActivePasswordState(int quality, int length, int letters, int uppercase, int lowercase, int numbers, int symbols, int nonletter, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setActivePasswordState(quality, length, letters, uppercase, lowercase, numbers, symbols, nonletter, userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportFailedPasswordAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportFailedPasswordAttempt(userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportSuccessfulPasswordAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportSuccessfulPasswordAttempt(userHandle);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(String packageName) throws IllegalArgumentException, IllegalStateException {
        return this.setDeviceOwner(packageName, null);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(String packageName, String ownerName) throws IllegalArgumentException, IllegalStateException {
        if (this.mService != null) {
            try {
                return this.mService.setDeviceOwner(packageName, ownerName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to set device owner");
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerApp(String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.isDeviceOwner(packageName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to check device owner");
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwner(String packageName) {
        return this.isDeviceOwnerApp(packageName);
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearDeviceOwnerApp(String packageName) {
        if (this.mService != null) {
            try {
                this.mService.clearDeviceOwner(packageName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to clear device owner");
            }
        }
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwner() {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwner();
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to get device owner");
            }
        }
        return null;
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerName() {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerName();
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to get device owner");
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setActiveProfileOwner(ComponentName admin, String ownerName) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                int myUserId = UserHandle.myUserId();
                this.mService.setActiveAdmin(admin, false, myUserId);
                return this.mService.setProfileOwner(admin, ownerName, myUserId);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to set profile owner " + re);
                throw new IllegalArgumentException("Couldn't set profile owner.", re);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearProfileOwner(ComponentName admin) {
        if (this.mService != null) {
            try {
                this.mService.clearProfileOwner(admin);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to clear profile owner " + admin + re);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$hasUserSetupCompleted() {
        if (this.mService != null) {
            try {
                return this.mService.hasUserSetupCompleted();
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to check if user setup has completed");
            }
        }
        return true;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setProfileOwner(String packageName, String ownerName, int userHandle) throws IllegalArgumentException {
        if (packageName == null) {
            throw new NullPointerException("packageName cannot be null");
        }
        return this.setProfileOwner(new ComponentName(packageName, ""), ownerName, userHandle);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setProfileOwner(ComponentName admin, String ownerName, int userHandle) throws IllegalArgumentException {
        if (admin == null) {
            throw new NullPointerException("admin cannot be null");
        }
        if (this.mService != null) {
            try {
                if (ownerName == null) {
                    ownerName = "";
                }
                return this.mService.setProfileOwner(admin, ownerName, userHandle);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to set profile owner", re);
                throw new IllegalArgumentException("Couldn't set profile owner.", re);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setProfileEnabled(ComponentName admin) {
        if (this.mService != null) {
            try {
                this.mService.setProfileEnabled(admin);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setProfileName(ComponentName who, String profileName) {
        if (this.mService != null) {
            try {
                this.mService.setProfileName(who, profileName);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isProfileOwnerApp(String packageName) {
        if (this.mService != null) {
            try {
                ComponentName profileOwner = this.mService.getProfileOwner(Process.myUserHandle().getIdentifier());
                return profileOwner != null && profileOwner.getPackageName().equals(packageName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to check profile owner");
            }
        }
        return false;
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getProfileOwner() throws IllegalArgumentException {
        return this.getProfileOwnerAsUser(Process.myUserHandle().getIdentifier());
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerAsUser(int userId) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwner(userId);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to get profile owner");
                throw new IllegalArgumentException("Requested profile owner for invalid userId", re);
            }
        }
        return null;
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerName() throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerName(Process.myUserHandle().getIdentifier());
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to get profile owner");
                throw new IllegalArgumentException("Requested profile owner for invalid userId", re);
            }
        }
        return null;
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerNameAsUser(int userId) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerName(userId);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to get profile owner");
                throw new IllegalArgumentException("Requested profile owner for invalid userId", re);
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$addPersistentPreferredActivity(ComponentName admin, IntentFilter filter, ComponentName activity) {
        if (this.mService != null) {
            try {
                this.mService.addPersistentPreferredActivity(admin, filter, activity);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearPackagePersistentPreferredActivities(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                this.mService.clearPackagePersistentPreferredActivities(admin, packageName);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setApplicationRestrictions(ComponentName admin, String packageName, Bundle settings) {
        if (this.mService != null) {
            try {
                this.mService.setApplicationRestrictions(admin, packageName, settings);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setTrustAgentFeaturesEnabled(ComponentName admin, ComponentName agent, List<String> features) {
        if (this.mService != null) {
            try {
                this.mService.setTrustAgentFeaturesEnabled(admin, agent, features, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getTrustAgentFeaturesEnabled(ComponentName admin, ComponentName agent) {
        if (this.mService != null) {
            try {
                return this.mService.getTrustAgentFeaturesEnabled(admin, agent, UserHandle.myUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return new ArrayList<String>();
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setCrossProfileCallerIdDisabled(ComponentName who, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setCrossProfileCallerIdDisabled(who, disabled);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(ComponentName who) {
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileCallerIdDisabled(who);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileCallerIdDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileIntentFilter(ComponentName admin, IntentFilter filter, int flags) {
        if (this.mService != null) {
            try {
                this.mService.addCrossProfileIntentFilter(admin, filter, flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearCrossProfileIntentFilters(ComponentName admin) {
        if (this.mService != null) {
            try {
                this.mService.clearCrossProfileIntentFilters(admin);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setPermittedAccessibilityServices(ComponentName admin, List<String> packageNames) {
        if (this.mService != null) {
            try {
                return this.mService.setPermittedAccessibilityServices(admin, packageNames);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPermittedAccessibilityServices(admin);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getPermittedAccessibilityServicesForUser(userId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setPermittedInputMethods(ComponentName admin, List<String> packageNames) {
        if (this.mService != null) {
            try {
                return this.mService.setPermittedInputMethods(admin, packageNames);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethods(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPermittedInputMethods(admin);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethodsForCurrentUser() {
        if (this.mService != null) {
            try {
                return this.mService.getPermittedInputMethodsForCurrentUser();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final UserHandle $$robo$$android_app_admin_DevicePolicyManager$createUser(ComponentName admin, String name) {
        try {
            return this.mService.createUser(admin, name);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not create a user", re);
            return null;
        }
    }

    private final UserHandle $$robo$$android_app_admin_DevicePolicyManager$createAndInitializeUser(ComponentName admin, String name, String ownerName, ComponentName profileOwnerComponent, Bundle adminExtras) {
        try {
            return this.mService.createAndInitializeUser(admin, name, ownerName, profileOwnerComponent, adminExtras);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not create a user", re);
            return null;
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$removeUser(ComponentName admin, UserHandle userHandle) {
        try {
            return this.mService.removeUser(admin, userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not remove user ", re);
            return false;
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$switchUser(ComponentName admin, UserHandle userHandle) {
        try {
            return this.mService.switchUser(admin, userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not switch user ", re);
            return false;
        }
    }

    private final Bundle $$robo$$android_app_admin_DevicePolicyManager$getApplicationRestrictions(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.getApplicationRestrictions(admin, packageName);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$addUserRestriction(ComponentName admin, String key) {
        if (this.mService != null) {
            try {
                this.mService.setUserRestriction(admin, key, true);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearUserRestriction(ComponentName admin, String key) {
        if (this.mService != null) {
            try {
                this.mService.setUserRestriction(admin, key, false);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setApplicationHidden(ComponentName admin, String packageName, boolean hidden) {
        if (this.mService != null) {
            try {
                return this.mService.setApplicationHidden(admin, packageName, hidden);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isApplicationHidden(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.isApplicationHidden(admin, packageName);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                this.mService.enableSystemApp(admin, packageName);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to install package: " + packageName);
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(ComponentName admin, Intent intent) {
        if (this.mService != null) {
            try {
                return this.mService.enableSystemAppWithIntent(admin, intent);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to install packages matching filter: " + intent);
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setAccountManagementDisabled(ComponentName admin, String accountType, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setAccountManagementDisabled(admin, accountType, disabled);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(UserHandle.myUserId());
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabledAsUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getAccountTypesWithManagementDisabledAsUser(userId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setLockTaskPackages(ComponentName admin, String[] packages) throws SecurityException {
        if (this.mService != null) {
            try {
                this.mService.setLockTaskPackages(admin, packages);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$getLockTaskPackages(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getLockTaskPackages(admin);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isLockTaskPermitted(String pkg) {
        if (this.mService != null) {
            try {
                return this.mService.isLockTaskPermitted(pkg);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setGlobalSetting(ComponentName admin, String setting, String value) {
        if (this.mService != null) {
            try {
                this.mService.setGlobalSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setSecureSetting(ComponentName admin, String setting, String value) {
        if (this.mService != null) {
            try {
                this.mService.setSecureSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with device policy service", e);
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setRestrictionsProvider(ComponentName admin, ComponentName provider) {
        if (this.mService != null) {
            try {
                this.mService.setRestrictionsProvider(admin, provider);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to set permission provider on device policy service");
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setMasterVolumeMuted(ComponentName admin, boolean on) {
        if (this.mService != null) {
            try {
                this.mService.setMasterVolumeMuted(admin, on);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to setMasterMute on device policy service");
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isMasterVolumeMuted(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.isMasterVolumeMuted(admin);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to get isMasterMute on device policy service");
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setUninstallBlocked(ComponentName admin, String packageName, boolean uninstallBlocked) {
        if (this.mService != null) {
            try {
                this.mService.setUninstallBlocked(admin, packageName, uninstallBlocked);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to call block uninstall on device policy service");
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isUninstallBlocked(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.isUninstallBlocked(admin, packageName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Failed to call block uninstall on device policy service");
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.addCrossProfileWidgetProvider(admin, packageName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Error calling addCrossProfileWidgetProvider", re);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.removeCrossProfileWidgetProvider(admin, packageName);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Error calling removeCrossProfileWidgetProvider", re);
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileWidgetProviders(ComponentName admin) {
        if (this.mService != null) {
            try {
                List<String> providers = this.mService.getCrossProfileWidgetProviders(admin);
                if (providers != null) {
                    return providers;
                }
            }
            catch (RemoteException re) {
                Log.w(TAG, "Error calling getCrossProfileWidgetProviders", re);
            }
        }
        return Collections.emptyList();
    }

    static void __staticInitializer__() {
        TAG = "DevicePolicyManager";
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_app_admin_DevicePolicyManager$__constructor__(context, handler);
    }

    private DevicePolicyManager(Context context, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DevicePolicyManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public static DevicePolicyManager create(Context context, Handler handler) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_app_admin_DevicePolicyManager$create(android.content.Context android.os.Handler ), 0, (Context)context, (Handler)handler);
    }

    public boolean isAdminActive(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdminActive", $$robo$$android_app_admin_DevicePolicyManager$isAdminActive(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isAdminActiveAsUser(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdminActiveAsUser", $$robo$$android_app_admin_DevicePolicyManager$isAdminActiveAsUser(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public List<ComponentName> getActiveAdmins() {
        return InvokeDynamicSupport.bootstrap("getActiveAdmins", $$robo$$android_app_admin_DevicePolicyManager$getActiveAdmins(), 0, this);
    }

    public List<ComponentName> getActiveAdminsAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveAdminsAsUser", $$robo$$android_app_admin_DevicePolicyManager$getActiveAdminsAsUser(int ), 0, this, n);
    }

    public boolean packageHasActiveAdmins(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("packageHasActiveAdmins", $$robo$$android_app_admin_DevicePolicyManager$packageHasActiveAdmins(java.lang.String ), 0, this, string2);
    }

    public void removeActiveAdmin(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("removeActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$removeActiveAdmin(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean hasGrantedPolicy(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasGrantedPolicy", $$robo$$android_app_admin_DevicePolicyManager$hasGrantedPolicy(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordQuality(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordQuality", $$robo$$android_app_admin_DevicePolicyManager$setPasswordQuality(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordQuality(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordQuality", $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordQuality(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordQuality", $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumLength(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumLength", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumLength(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumLength(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumUpperCase(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumUpperCase", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumUpperCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumUpperCase(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumUpperCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumUpperCase(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumUpperCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumLowerCase(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumLowerCase", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLowerCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumLowerCase(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLowerCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumLowerCase(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLowerCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumLetters(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumLetters", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLetters(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumLetters(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLetters", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumLetters(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLetters", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumNumeric(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumNumeric", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNumeric(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumNumeric(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNumeric", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumNumeric(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNumeric", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumSymbols(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumSymbols", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumSymbols(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumSymbols(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumSymbols", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumSymbols(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumSymbols", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumNonLetter(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumNonLetter", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNonLetter(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumNonLetter(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNonLetter", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumNonLetter(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNonLetter", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordHistoryLength(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordHistoryLength", $$robo$$android_app_admin_DevicePolicyManager$setPasswordHistoryLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordExpirationTimeout(ComponentName componentName, long l) {
        InvokeDynamicSupport.bootstrap("setPasswordExpirationTimeout", $$robo$$android_app_admin_DevicePolicyManager$setPasswordExpirationTimeout(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public long getPasswordExpirationTimeout(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getPasswordExpirationTimeout", $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpirationTimeout(android.content.ComponentName ), 0, this, componentName);
    }

    public long getPasswordExpiration(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getPasswordExpiration", $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpiration(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordHistoryLength(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordHistoryLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordHistoryLength(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordHistoryLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMaximumLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMaximumLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMaximumLength(int ), 0, this, n);
    }

    public boolean isActivePasswordSufficient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivePasswordSufficient", $$robo$$android_app_admin_DevicePolicyManager$isActivePasswordSufficient(), 0, this);
    }

    public int getCurrentFailedPasswordAttempts() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentFailedPasswordAttempts", $$robo$$android_app_admin_DevicePolicyManager$getCurrentFailedPasswordAttempts(), 0, this);
    }

    public void setMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setMaximumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$setMaximumFailedPasswordsForWipe(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(android.content.ComponentName ), 0, this, componentName);
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public boolean resetPassword(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetPassword", $$robo$$android_app_admin_DevicePolicyManager$resetPassword(java.lang.String int ), 0, this, string2, n);
    }

    public void setMaximumTimeToLock(ComponentName componentName, long l) {
        InvokeDynamicSupport.bootstrap("setMaximumTimeToLock", $$robo$$android_app_admin_DevicePolicyManager$setMaximumTimeToLock(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public long getMaximumTimeToLock(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getMaximumTimeToLock", $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(android.content.ComponentName ), 0, this, componentName);
    }

    public long getMaximumTimeToLock(ComponentName componentName, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getMaximumTimeToLock", $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void lockNow() {
        InvokeDynamicSupport.bootstrap("lockNow", $$robo$$android_app_admin_DevicePolicyManager$lockNow(), 0, this);
    }

    public void wipeData(int n) {
        InvokeDynamicSupport.bootstrap("wipeData", $$robo$$android_app_admin_DevicePolicyManager$wipeData(int ), 0, this, n);
    }

    public ComponentName setGlobalProxy(ComponentName componentName, Proxy proxy, List<String> list) {
        return InvokeDynamicSupport.bootstrap("setGlobalProxy", $$robo$$android_app_admin_DevicePolicyManager$setGlobalProxy(android.content.ComponentName java.net.Proxy java.util.List<java.lang.String> ), 0, this, componentName, proxy, list);
    }

    public void setRecommendedGlobalProxy(ComponentName componentName, ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setRecommendedGlobalProxy", $$robo$$android_app_admin_DevicePolicyManager$setRecommendedGlobalProxy(android.content.ComponentName android.net.ProxyInfo ), 0, this, componentName, proxyInfo);
    }

    public ComponentName getGlobalProxyAdmin() {
        return InvokeDynamicSupport.bootstrap("getGlobalProxyAdmin", $$robo$$android_app_admin_DevicePolicyManager$getGlobalProxyAdmin(), 0, this);
    }

    public int setStorageEncryption(ComponentName componentName, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setStorageEncryption", $$robo$$android_app_admin_DevicePolicyManager$setStorageEncryption(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getStorageEncryption(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getStorageEncryption", $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryption(android.content.ComponentName ), 0, this, componentName);
    }

    public int getStorageEncryptionStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStorageEncryptionStatus", $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus(), 0, this);
    }

    public int getStorageEncryptionStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStorageEncryptionStatus", $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus(int ), 0, this, n);
    }

    public boolean installCaCert(ComponentName componentName, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("installCaCert", $$robo$$android_app_admin_DevicePolicyManager$installCaCert(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public void uninstallCaCert(ComponentName componentName, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("uninstallCaCert", $$robo$$android_app_admin_DevicePolicyManager$uninstallCaCert(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public List<byte[]> getInstalledCaCerts(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getInstalledCaCerts", $$robo$$android_app_admin_DevicePolicyManager$getInstalledCaCerts(android.content.ComponentName ), 0, this, componentName);
    }

    public void uninstallAllUserCaCerts(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("uninstallAllUserCaCerts", $$robo$$android_app_admin_DevicePolicyManager$uninstallAllUserCaCerts(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean hasCaCertInstalled(ComponentName componentName, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCaCertInstalled", $$robo$$android_app_admin_DevicePolicyManager$hasCaCertInstalled(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public boolean installKeyPair(ComponentName componentName, PrivateKey privateKey, Certificate certificate, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("installKeyPair", $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(android.content.ComponentName java.security.PrivateKey java.security.cert.Certificate java.lang.String ), 0, this, componentName, privateKey, certificate, string2);
    }

    private static String getCaCertAlias(byte[] byArray) throws CertificateException {
        return InvokeDynamicSupport.bootstrapStatic("getCaCertAlias", $$robo$$android_app_admin_DevicePolicyManager$getCaCertAlias(byte[] ), 0, (byte[])byArray);
    }

    public void setCameraDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCameraDisabled", $$robo$$android_app_admin_DevicePolicyManager$setCameraDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getCameraDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCameraDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getCameraDisabled(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCameraDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setScreenCaptureDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setScreenCaptureDisabled", $$robo$$android_app_admin_DevicePolicyManager$setScreenCaptureDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getScreenCaptureDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getScreenCaptureDisabled", $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getScreenCaptureDisabled(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getScreenCaptureDisabled", $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setAutoTimeRequired(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoTimeRequired", $$robo$$android_app_admin_DevicePolicyManager$setAutoTimeRequired(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getAutoTimeRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAutoTimeRequired", $$robo$$android_app_admin_DevicePolicyManager$getAutoTimeRequired(), 0, this);
    }

    public void setKeyguardDisabledFeatures(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setKeyguardDisabledFeatures", $$robo$$android_app_admin_DevicePolicyManager$setKeyguardDisabledFeatures(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getKeyguardDisabledFeatures(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardDisabledFeatures", $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(android.content.ComponentName ), 0, this, componentName);
    }

    public int getKeyguardDisabledFeatures(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardDisabledFeatures", $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setActiveAdmin(ComponentName componentName, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(android.content.ComponentName boolean int ), 0, this, componentName, bl, n);
    }

    public void setActiveAdmin(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public DeviceAdminInfo getAdminInfo(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getAdminInfo", $$robo$$android_app_admin_DevicePolicyManager$getAdminInfo(android.content.ComponentName ), 0, this, componentName);
    }

    public void getRemoveWarning(ComponentName componentName, RemoteCallback remoteCallback) {
        InvokeDynamicSupport.bootstrap("getRemoveWarning", $$robo$$android_app_admin_DevicePolicyManager$getRemoveWarning(android.content.ComponentName android.os.RemoteCallback ), 0, this, componentName, remoteCallback);
    }

    public void setActivePasswordState(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        InvokeDynamicSupport.bootstrap("setActivePasswordState", $$robo$$android_app_admin_DevicePolicyManager$setActivePasswordState(int int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void reportFailedPasswordAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportFailedPasswordAttempt", $$robo$$android_app_admin_DevicePolicyManager$reportFailedPasswordAttempt(int ), 0, this, n);
    }

    public void reportSuccessfulPasswordAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportSuccessfulPasswordAttempt", $$robo$$android_app_admin_DevicePolicyManager$reportSuccessfulPasswordAttempt(int ), 0, this, n);
    }

    public boolean setDeviceOwner(String string2) throws IllegalArgumentException, IllegalStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(java.lang.String ), 0, this, string2);
    }

    public boolean setDeviceOwner(String string2, String string3) throws IllegalArgumentException, IllegalStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean isDeviceOwnerApp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwnerApp", $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerApp(java.lang.String ), 0, this, string2);
    }

    public boolean isDeviceOwner(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwner(java.lang.String ), 0, this, string2);
    }

    public void clearDeviceOwnerApp(String string2) {
        InvokeDynamicSupport.bootstrap("clearDeviceOwnerApp", $$robo$$android_app_admin_DevicePolicyManager$clearDeviceOwnerApp(java.lang.String ), 0, this, string2);
    }

    public String getDeviceOwner() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwner(), 0, this);
    }

    public String getDeviceOwnerName() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerName", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerName(), 0, this);
    }

    public boolean setActiveProfileOwner(ComponentName componentName, String string2) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setActiveProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$setActiveProfileOwner(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void clearProfileOwner(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("clearProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$clearProfileOwner(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean hasUserSetupCompleted() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUserSetupCompleted", $$robo$$android_app_admin_DevicePolicyManager$hasUserSetupCompleted(), 0, this);
    }

    public boolean setProfileOwner(String string2, String string3, int n) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$setProfileOwner(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public boolean setProfileOwner(ComponentName componentName, String string2, int n) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$setProfileOwner(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    public void setProfileEnabled(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("setProfileEnabled", $$robo$$android_app_admin_DevicePolicyManager$setProfileEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public void setProfileName(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("setProfileName", $$robo$$android_app_admin_DevicePolicyManager$setProfileName(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean isProfileOwnerApp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProfileOwnerApp", $$robo$$android_app_admin_DevicePolicyManager$isProfileOwnerApp(java.lang.String ), 0, this, string2);
    }

    public ComponentName getProfileOwner() throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwner(), 0, this);
    }

    public ComponentName getProfileOwnerAsUser(int n) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwnerAsUser", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerAsUser(int ), 0, this, n);
    }

    public String getProfileOwnerName() throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwnerName", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerName(), 0, this);
    }

    public String getProfileOwnerNameAsUser(int n) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwnerNameAsUser", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerNameAsUser(int ), 0, this, n);
    }

    public void addPersistentPreferredActivity(ComponentName componentName, IntentFilter intentFilter, ComponentName componentName2) {
        InvokeDynamicSupport.bootstrap("addPersistentPreferredActivity", $$robo$$android_app_admin_DevicePolicyManager$addPersistentPreferredActivity(android.content.ComponentName android.content.IntentFilter android.content.ComponentName ), 0, this, componentName, intentFilter, componentName2);
    }

    public void clearPackagePersistentPreferredActivities(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("clearPackagePersistentPreferredActivities", $$robo$$android_app_admin_DevicePolicyManager$clearPackagePersistentPreferredActivities(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void setApplicationRestrictions(ComponentName componentName, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setApplicationRestrictions", $$robo$$android_app_admin_DevicePolicyManager$setApplicationRestrictions(android.content.ComponentName java.lang.String android.os.Bundle ), 0, this, componentName, string2, bundle);
    }

    public void setTrustAgentFeaturesEnabled(ComponentName componentName, ComponentName componentName2, List<String> list) {
        InvokeDynamicSupport.bootstrap("setTrustAgentFeaturesEnabled", $$robo$$android_app_admin_DevicePolicyManager$setTrustAgentFeaturesEnabled(android.content.ComponentName android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, componentName2, list);
    }

    public List<String> getTrustAgentFeaturesEnabled(ComponentName componentName, ComponentName componentName2) {
        return InvokeDynamicSupport.bootstrap("getTrustAgentFeaturesEnabled", $$robo$$android_app_admin_DevicePolicyManager$getTrustAgentFeaturesEnabled(android.content.ComponentName android.content.ComponentName ), 0, this, componentName, componentName2);
    }

    public void setCrossProfileCallerIdDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCrossProfileCallerIdDisabled", $$robo$$android_app_admin_DevicePolicyManager$setCrossProfileCallerIdDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getCrossProfileCallerIdDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCrossProfileCallerIdDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getCrossProfileCallerIdDisabled(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCrossProfileCallerIdDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(android.os.UserHandle ), 0, this, userHandle);
    }

    public void addCrossProfileIntentFilter(ComponentName componentName, IntentFilter intentFilter, int n) {
        InvokeDynamicSupport.bootstrap("addCrossProfileIntentFilter", $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileIntentFilter(android.content.ComponentName android.content.IntentFilter int ), 0, this, componentName, intentFilter, n);
    }

    public void clearCrossProfileIntentFilters(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("clearCrossProfileIntentFilters", $$robo$$android_app_admin_DevicePolicyManager$clearCrossProfileIntentFilters(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setPermittedAccessibilityServices(ComponentName componentName, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPermittedAccessibilityServices", $$robo$$android_app_admin_DevicePolicyManager$setPermittedAccessibilityServices(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    public List<String> getPermittedAccessibilityServices(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getPermittedAccessibilityServices", $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(android.content.ComponentName ), 0, this, componentName);
    }

    public List<String> getPermittedAccessibilityServices(int n) {
        return InvokeDynamicSupport.bootstrap("getPermittedAccessibilityServices", $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(int ), 0, this, n);
    }

    public boolean setPermittedInputMethods(ComponentName componentName, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPermittedInputMethods", $$robo$$android_app_admin_DevicePolicyManager$setPermittedInputMethods(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    public List<String> getPermittedInputMethods(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getPermittedInputMethods", $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethods(android.content.ComponentName ), 0, this, componentName);
    }

    public List<String> getPermittedInputMethodsForCurrentUser() {
        return InvokeDynamicSupport.bootstrap("getPermittedInputMethodsForCurrentUser", $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethodsForCurrentUser(), 0, this);
    }

    public UserHandle createUser(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("createUser", $$robo$$android_app_admin_DevicePolicyManager$createUser(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public UserHandle createAndInitializeUser(ComponentName componentName, String string2, String string3, ComponentName componentName2, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("createAndInitializeUser", $$robo$$android_app_admin_DevicePolicyManager$createAndInitializeUser(android.content.ComponentName java.lang.String java.lang.String android.content.ComponentName android.os.Bundle ), 0, this, componentName, string2, string3, componentName2, bundle);
    }

    public boolean removeUser(ComponentName componentName, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUser", $$robo$$android_app_admin_DevicePolicyManager$removeUser(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public boolean switchUser(ComponentName componentName, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchUser", $$robo$$android_app_admin_DevicePolicyManager$switchUser(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public Bundle getApplicationRestrictions(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_app_admin_DevicePolicyManager$getApplicationRestrictions(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void addUserRestriction(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("addUserRestriction", $$robo$$android_app_admin_DevicePolicyManager$addUserRestriction(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void clearUserRestriction(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("clearUserRestriction", $$robo$$android_app_admin_DevicePolicyManager$clearUserRestriction(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean setApplicationHidden(ComponentName componentName, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setApplicationHidden", $$robo$$android_app_admin_DevicePolicyManager$setApplicationHidden(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public boolean isApplicationHidden(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApplicationHidden", $$robo$$android_app_admin_DevicePolicyManager$isApplicationHidden(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void enableSystemApp(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("enableSystemApp", $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public int enableSystemApp(ComponentName componentName, Intent intent) {
        return (int)InvokeDynamicSupport.bootstrap("enableSystemApp", $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(android.content.ComponentName android.content.Intent ), 0, this, componentName, intent);
    }

    public void setAccountManagementDisabled(ComponentName componentName, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setAccountManagementDisabled", $$robo$$android_app_admin_DevicePolicyManager$setAccountManagementDisabled(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public String[] getAccountTypesWithManagementDisabled() {
        return InvokeDynamicSupport.bootstrap("getAccountTypesWithManagementDisabled", $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabled(), 0, this);
    }

    public String[] getAccountTypesWithManagementDisabledAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getAccountTypesWithManagementDisabledAsUser", $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabledAsUser(int ), 0, this, n);
    }

    public void setLockTaskPackages(ComponentName componentName, String[] stringArray) throws SecurityException {
        InvokeDynamicSupport.bootstrap("setLockTaskPackages", $$robo$$android_app_admin_DevicePolicyManager$setLockTaskPackages(android.content.ComponentName java.lang.String[] ), 0, this, componentName, stringArray);
    }

    public String[] getLockTaskPackages(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getLockTaskPackages", $$robo$$android_app_admin_DevicePolicyManager$getLockTaskPackages(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isLockTaskPermitted(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockTaskPermitted", $$robo$$android_app_admin_DevicePolicyManager$isLockTaskPermitted(java.lang.String ), 0, this, string2);
    }

    public void setGlobalSetting(ComponentName componentName, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setGlobalSetting", $$robo$$android_app_admin_DevicePolicyManager$setGlobalSetting(android.content.ComponentName java.lang.String java.lang.String ), 0, this, componentName, string2, string3);
    }

    public void setSecureSetting(ComponentName componentName, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSecureSetting", $$robo$$android_app_admin_DevicePolicyManager$setSecureSetting(android.content.ComponentName java.lang.String java.lang.String ), 0, this, componentName, string2, string3);
    }

    public void setRestrictionsProvider(ComponentName componentName, ComponentName componentName2) {
        InvokeDynamicSupport.bootstrap("setRestrictionsProvider", $$robo$$android_app_admin_DevicePolicyManager$setRestrictionsProvider(android.content.ComponentName android.content.ComponentName ), 0, this, componentName, componentName2);
    }

    public void setMasterVolumeMuted(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setMasterVolumeMuted", $$robo$$android_app_admin_DevicePolicyManager$setMasterVolumeMuted(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isMasterVolumeMuted(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMasterVolumeMuted", $$robo$$android_app_admin_DevicePolicyManager$isMasterVolumeMuted(android.content.ComponentName ), 0, this, componentName);
    }

    public void setUninstallBlocked(ComponentName componentName, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUninstallBlocked", $$robo$$android_app_admin_DevicePolicyManager$setUninstallBlocked(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public boolean isUninstallBlocked(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUninstallBlocked", $$robo$$android_app_admin_DevicePolicyManager$isUninstallBlocked(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean addCrossProfileWidgetProvider(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("addCrossProfileWidgetProvider", $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileWidgetProvider(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean removeCrossProfileWidgetProvider(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeCrossProfileWidgetProvider", $$robo$$android_app_admin_DevicePolicyManager$removeCrossProfileWidgetProvider(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public List<String> getCrossProfileWidgetProviders(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getCrossProfileWidgetProviders", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileWidgetProviders(android.content.ComponentName ), 0, this, componentName);
    }

    static {
        RobolectricInternals.classInitializing(DevicePolicyManager.class);
    }

    public /* synthetic */ DevicePolicyManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DevicePolicyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

