/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.QueuedWork;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BackupAgent
extends ContextWrapper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BackupAgent";
    private static boolean DEBUG = true;
    public static int TYPE_EOF = 0;
    public static int TYPE_FILE = 1;
    public static int TYPE_DIRECTORY = 2;
    public static int TYPE_SYMLINK = 3;
    Handler mHandler;
    private IBinder mBinder;

    private final Handler $$robo$$android_app_backup_BackupAgent$getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private final void $$robo$$android_app_backup_BackupAgent$waitForSharedPrefs() {
        Handler h = this.getHandler();
        SharedPrefsSynchronizer s = new SharedPrefsSynchronizer(this);
        h.postAtFrontOfQueue(s);
        try {
            s.mLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void $$robo$$android_app_backup_BackupAgent$__constructor__() {
        this.mHandler = null;
        this.mBinder = new BackupServiceBinder(this).asBinder();
    }

    private final void $$robo$$android_app_backup_BackupAgent$onCreate() {
    }

    private final void $$robo$$android_app_backup_BackupAgent$onDestroy() {
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    private final void $$robo$$android_app_backup_BackupAgent$onFullBackup(FullBackupDataOutput data) throws IOException {
        File efLocation;
        ApplicationInfo appInfo = this.getApplicationInfo();
        String rootDir = new File(appInfo.dataDir).getCanonicalPath();
        String filesDir = this.getFilesDir().getCanonicalPath();
        String databaseDir = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String sharedPrefsDir = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
        String cacheDir = this.getCacheDir().getCanonicalPath();
        String libDir = appInfo.nativeLibraryDir != null ? new File(appInfo.nativeLibraryDir).getCanonicalPath() : null;
        HashSet<String> filterSet = new HashSet<String>();
        String packageName = this.getPackageName();
        if (libDir != null) {
            filterSet.add(libDir);
        }
        filterSet.add(cacheDir);
        filterSet.add(databaseDir);
        filterSet.add(sharedPrefsDir);
        filterSet.add(filesDir);
        this.fullBackupFileTree(packageName, "r", rootDir, filterSet, data);
        filterSet.add(rootDir);
        filterSet.remove(filesDir);
        this.fullBackupFileTree(packageName, "f", filesDir, filterSet, data);
        filterSet.add(filesDir);
        filterSet.remove(databaseDir);
        this.fullBackupFileTree(packageName, "db", databaseDir, filterSet, data);
        filterSet.add(databaseDir);
        filterSet.remove(sharedPrefsDir);
        this.fullBackupFileTree(packageName, "sp", sharedPrefsDir, filterSet, data);
        if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
            this.fullBackupFileTree(packageName, "ef", efLocation.getCanonicalPath(), null, data);
        }
    }

    private final void $$robo$$android_app_backup_BackupAgent$fullBackupFile(File file, FullBackupDataOutput output) {
        String domain;
        String filePath;
        String libDir;
        String cacheDir;
        String spDir;
        String dbDir;
        String nbFilesDir;
        String filesDir;
        String mainDir;
        String efDir = null;
        ApplicationInfo appInfo = this.getApplicationInfo();
        try {
            File efLocation;
            mainDir = new File(appInfo.dataDir).getCanonicalPath();
            filesDir = this.getFilesDir().getCanonicalPath();
            nbFilesDir = this.getNoBackupFilesDir().getCanonicalPath();
            dbDir = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
            spDir = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
            cacheDir = this.getCacheDir().getCanonicalPath();
            String string2 = libDir = appInfo.nativeLibraryDir == null ? null : new File(appInfo.nativeLibraryDir).getCanonicalPath();
            if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
                efDir = efLocation.getCanonicalPath();
            }
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            Log.w("BackupAgent", "Unable to obtain canonical paths");
            return;
        }
        if (filePath.startsWith(cacheDir) || filePath.startsWith(libDir) || filePath.startsWith(nbFilesDir)) {
            Log.w("BackupAgent", "lib, cache, and no_backup files are not backed up");
            return;
        }
        String rootpath = null;
        if (filePath.startsWith(dbDir)) {
            domain = "db";
            rootpath = dbDir;
        } else if (filePath.startsWith(spDir)) {
            domain = "sp";
            rootpath = spDir;
        } else if (filePath.startsWith(filesDir)) {
            domain = "f";
            rootpath = filesDir;
        } else if (filePath.startsWith(mainDir)) {
            domain = "r";
            rootpath = mainDir;
        } else if (efDir != null && filePath.startsWith(efDir)) {
            domain = "ef";
            rootpath = efDir;
        } else {
            Log.w("BackupAgent", "File " + filePath + " is in an unsupported location; skipping");
            return;
        }
        Log.i("BackupAgent", "backupFile() of " + filePath + " => domain=" + domain + " rootpath=" + rootpath);
        FullBackup.backupToTar(this.getPackageName(), domain, null, rootpath, filePath, output.getData());
    }

    private final void $$robo$$android_app_backup_BackupAgent$fullBackupFileTree(String packageName, String domain, String rootPath, HashSet<String> excludes, FullBackupDataOutput output) {
        File rootFile = new File(rootPath);
        if (rootFile.exists()) {
            LinkedList<File> scanQueue = new LinkedList<File>();
            scanQueue.add(rootFile);
            while (scanQueue.size() > 0) {
                String filePath;
                block7: {
                    File file = (File)scanQueue.remove(0);
                    try {
                        File[] contents;
                        filePath = file.getCanonicalPath();
                        if (excludes != null && excludes.contains(filePath)) continue;
                        StructStat stat = Os.lstat(filePath);
                        if (OsConstants.S_ISLNK(stat.st_mode)) {
                            Log.i("BackupAgent", "Symlink (skipping)!: " + file);
                            continue;
                        }
                        if (!OsConstants.S_ISDIR(stat.st_mode) || (contents = file.listFiles()) == null) break block7;
                        for (File entry : contents) {
                            scanQueue.add(0, entry);
                        }
                    }
                    catch (IOException e) {
                        Log.w("BackupAgent", "Error canonicalizing path of " + file);
                        continue;
                    }
                    catch (ErrnoException e) {
                        Log.w("BackupAgent", "Error scanning file " + file + " : " + e);
                        continue;
                    }
                }
                FullBackup.backupToTar(packageName, domain, null, rootPath, filePath, output.getData());
            }
        }
    }

    private final void $$robo$$android_app_backup_BackupAgent$onRestoreFile(ParcelFileDescriptor data, long size, File destination, int type, long mode, long mtime) throws IOException {
        FullBackup.restoreFile(data, size, type, mode, mtime, destination);
    }

    private final void $$robo$$android_app_backup_BackupAgent$onRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime) throws IOException {
        String basePath = null;
        Log.d("BackupAgent", "onRestoreFile() size=" + size + " type=" + type + " domain=" + domain + " relpath=" + path + " mode=" + mode + " mtime=" + mtime);
        if (domain.equals("f")) {
            basePath = this.getFilesDir().getCanonicalPath();
        } else if (domain.equals("db")) {
            basePath = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
        } else if (domain.equals("r")) {
            basePath = new File(this.getApplicationInfo().dataDir).getCanonicalPath();
        } else if (domain.equals("sp")) {
            basePath = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
        } else if (domain.equals("c")) {
            basePath = this.getCacheDir().getCanonicalPath();
        } else if (domain.equals("ef")) {
            File efLocation;
            if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
                basePath = this.getExternalFilesDir(null).getCanonicalPath();
                mode = -1L;
            }
        } else if (domain.equals("nb")) {
            basePath = this.getNoBackupFilesDir().getCanonicalPath();
        } else {
            Log.i("BackupAgent", "Unrecognized domain " + domain);
        }
        if (basePath != null) {
            File outFile = new File(basePath, path);
            String outPath = outFile.getCanonicalPath();
            if (outPath.startsWith(basePath + File.separatorChar)) {
                Log.i("BackupAgent", "[" + domain + " : " + path + "] mapped to " + outPath);
                this.onRestoreFile(data, size, outFile, type, mode, mtime);
                return;
            }
            Log.e("BackupAgent", "Cross-domain restore attempt: " + outPath);
        }
        Log.i("BackupAgent", "[ skipping file " + path + "]");
        FullBackup.restoreFile(data, size, type, mode, mtime, null);
    }

    private final void $$robo$$android_app_backup_BackupAgent$onRestoreFinished() {
    }

    private final IBinder $$robo$$android_app_backup_BackupAgent$onBind() {
        return this.mBinder;
    }

    private final void $$robo$$android_app_backup_BackupAgent$attach(Context context) {
        this.attachBaseContext(context);
    }

    Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_app_backup_BackupAgent$getHandler(), 0, this);
    }

    private void waitForSharedPrefs() {
        InvokeDynamicSupport.bootstrap("waitForSharedPrefs", $$robo$$android_app_backup_BackupAgent$waitForSharedPrefs(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_app_backup_BackupAgent$__constructor__();
    }

    public BackupAgent() {
        super(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent$__constructor__(), 0, this);
    }

    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_app_backup_BackupAgent$onCreate(), 0, this);
    }

    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_app_backup_BackupAgent$onDestroy(), 0, this);
    }

    public void onFullBackup(FullBackupDataOutput fullBackupDataOutput) throws IOException {
        InvokeDynamicSupport.bootstrap("onFullBackup", $$robo$$android_app_backup_BackupAgent$onFullBackup(android.app.backup.FullBackupDataOutput ), 0, this, fullBackupDataOutput);
    }

    public void fullBackupFile(File file, FullBackupDataOutput fullBackupDataOutput) {
        InvokeDynamicSupport.bootstrap("fullBackupFile", $$robo$$android_app_backup_BackupAgent$fullBackupFile(java.io.File android.app.backup.FullBackupDataOutput ), 0, this, file, fullBackupDataOutput);
    }

    protected void fullBackupFileTree(String string2, String string3, String string4, HashSet<String> hashSet, FullBackupDataOutput fullBackupDataOutput) {
        InvokeDynamicSupport.bootstrap("fullBackupFileTree", $$robo$$android_app_backup_BackupAgent$fullBackupFileTree(java.lang.String java.lang.String java.lang.String java.util.HashSet<java.lang.String> android.app.backup.FullBackupDataOutput ), 0, this, string2, string3, string4, hashSet, fullBackupDataOutput);
    }

    public void onRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, File file, int n, long l2, long l3) throws IOException {
        InvokeDynamicSupport.bootstrap("onRestoreFile", $$robo$$android_app_backup_BackupAgent$onRestoreFile(android.os.ParcelFileDescriptor long java.io.File int long long ), 0, this, parcelFileDescriptor, l, file, n, l2, l3);
    }

    protected void onRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, String string2, String string3, long l2, long l3) throws IOException {
        InvokeDynamicSupport.bootstrap("onRestoreFile", $$robo$$android_app_backup_BackupAgent$onRestoreFile(android.os.ParcelFileDescriptor long int java.lang.String java.lang.String long long ), 0, this, parcelFileDescriptor, l, n, string2, string3, l2, l3);
    }

    public void onRestoreFinished() {
        InvokeDynamicSupport.bootstrap("onRestoreFinished", $$robo$$android_app_backup_BackupAgent$onRestoreFinished(), 0, this);
    }

    public IBinder onBind() {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_app_backup_BackupAgent$onBind(), 0, this);
    }

    public void attach(Context context) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$android_app_backup_BackupAgent$attach(android.content.Context ), 0, this, context);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupAgent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FailRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mMessage;

        private void $$robo$$android_app_backup_BackupAgent_FailRunnable$__constructor__(String message) {
            this.mMessage = message;
        }

        private final void $$robo$$android_app_backup_BackupAgent_FailRunnable$run() {
            throw new IllegalStateException(this.mMessage);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_backup_BackupAgent_FailRunnable$__constructor__(string2);
        }

        FailRunnable(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent_FailRunnable$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_backup_BackupAgent_FailRunnable$run(), 0, this);
        }

        public /* synthetic */ FailRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FailRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BackupServiceBinder
    extends IBackupAgent.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "BackupServiceBinder";
        /* synthetic */ BackupAgent this$0;

        private void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(BackupAgent backupAgent) {
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            Log.v("BackupServiceBinder", "doBackup() invoked");
            BackupDataOutput output = new BackupDataOutput(data.getFileDescriptor());
            try {
                this.this$0.onBackup(oldState, output, newState);
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestore(ParcelFileDescriptor data, int appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            Log.v("BackupServiceBinder", "doRestore() invoked");
            BackupDataInput input = new BackupDataInput(data.getFileDescriptor());
            try {
                this.this$0.onRestore(input, appVersionCode, newState);
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onRestore (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onRestore (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doFullBackup(ParcelFileDescriptor data, int token, IBackupManager callbackBinder) {
            long ident = Binder.clearCallingIdentity();
            Log.v("BackupServiceBinder", "doFullBackup() invoked");
            this.this$0.waitForSharedPrefs();
            try {
                this.this$0.onFullBackup(new FullBackupDataOutput(data));
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                try {
                    FileOutputStream out = new FileOutputStream(data.getFileDescriptor());
                    byte[] buf = new byte[4];
                    out.write(buf);
                }
                catch (IOException e) {
                    Log.e("BackupServiceBinder", "Unable to finalize backup stream!");
                }
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            try {
                this.this$0.onRestoreFile(data, size, type, domain, path, mode, mtime);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException remoteException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFinished(int token, IBackupManager callbackBinder) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.this$0.onRestoreFinished();
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$fail(String message) {
            this.this$0.getHandler().post(new FailRunnable(message));
        }

        private /* synthetic */ void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(BackupAgent x0, 1 x1) {
        }

        private void __constructor__(BackupAgent backupAgent) {
            this.$$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(backupAgent);
        }

        private BackupServiceBinder(BackupAgent backupAgent) {
            this.this$0 = backupAgent;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(android.app.backup.BackupAgent ), 0, this, backupAgent);
        }

        @Override
        public void doBackup(ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, ParcelFileDescriptor parcelFileDescriptor3, int n, IBackupManager iBackupManager) throws RemoteException {
            InvokeDynamicSupport.bootstrap("doBackup", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doBackup(android.os.ParcelFileDescriptor android.os.ParcelFileDescriptor android.os.ParcelFileDescriptor int android.app.backup.IBackupManager ), 0, this, parcelFileDescriptor, parcelFileDescriptor2, parcelFileDescriptor3, n, iBackupManager);
        }

        @Override
        public void doRestore(ParcelFileDescriptor parcelFileDescriptor, int n, ParcelFileDescriptor parcelFileDescriptor2, int n2, IBackupManager iBackupManager) throws RemoteException {
            InvokeDynamicSupport.bootstrap("doRestore", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestore(android.os.ParcelFileDescriptor int android.os.ParcelFileDescriptor int android.app.backup.IBackupManager ), 0, this, parcelFileDescriptor, n, parcelFileDescriptor2, n2, iBackupManager);
        }

        @Override
        public void doFullBackup(ParcelFileDescriptor parcelFileDescriptor, int n, IBackupManager iBackupManager) {
            InvokeDynamicSupport.bootstrap("doFullBackup", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doFullBackup(android.os.ParcelFileDescriptor int android.app.backup.IBackupManager ), 0, this, parcelFileDescriptor, n, iBackupManager);
        }

        @Override
        public void doRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, String string2, String string3, long l2, long l3, int n2, IBackupManager iBackupManager) throws RemoteException {
            InvokeDynamicSupport.bootstrap("doRestoreFile", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFile(android.os.ParcelFileDescriptor long int java.lang.String java.lang.String long long int android.app.backup.IBackupManager ), 0, this, parcelFileDescriptor, l, n, string2, string3, l2, l3, n2, iBackupManager);
        }

        @Override
        public void doRestoreFinished(int n, IBackupManager iBackupManager) {
            InvokeDynamicSupport.bootstrap("doRestoreFinished", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFinished(int android.app.backup.IBackupManager ), 0, this, n, iBackupManager);
        }

        @Override
        public void fail(String string2) {
            InvokeDynamicSupport.bootstrap("fail", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$fail(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(BackupAgent backupAgent, 1 var2_2) {
            this.$$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(backupAgent, var2_2);
        }

        public /* synthetic */ BackupServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class SharedPrefsSynchronizer
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public CountDownLatch mLatch;
        /* synthetic */ BackupAgent this$0;

        private void $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$__constructor__(BackupAgent backupAgent) {
            this.mLatch = new CountDownLatch(1);
        }

        private final void $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$run() {
            QueuedWork.waitToFinish();
            this.mLatch.countDown();
        }

        private void __constructor__(BackupAgent backupAgent) {
            this.$$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$__constructor__(backupAgent);
        }

        SharedPrefsSynchronizer(BackupAgent backupAgent) {
            this.this$0 = backupAgent;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$__constructor__(android.app.backup.BackupAgent ), 0, this, backupAgent);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$run(), 0, this);
        }

        public /* synthetic */ SharedPrefsSynchronizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SharedPrefsSynchronizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

