/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BackupManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BackupManager";
    private Context mContext;
    private static IBackupManager sService;

    private static final void $$robo$$android_app_backup_BackupManager$checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    private void $$robo$$android_app_backup_BackupManager$__constructor__(Context context) {
        this.mContext = context;
    }

    private final void $$robo$$android_app_backup_BackupManager$dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.d("BackupManager", "dataChanged() couldn't connect");
            }
        }
    }

    private static final void $$robo$$android_app_backup_BackupManager$dataChanged(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "dataChanged(pkg) couldn't connect");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_backup_BackupManager$requestRestore(RestoreObserver observer) {
        int result = -1;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            RestoreSession session = null;
            try {
                IRestoreSession binder = sService.beginRestoreSession(this.mContext.getPackageName(), null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                    result = session.restorePackage(this.mContext.getPackageName(), observer);
                }
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "restoreSelf() unable to contact service");
            }
            finally {
                if (session != null) {
                    session.endRestoreSession();
                }
            }
        }
        return result;
    }

    private final RestoreSession $$robo$$android_app_backup_BackupManager$beginRestoreSession() {
        RestoreSession session = null;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                IRestoreSession binder = sService.beginRestoreSession(null, null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                }
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "beginRestoreSession() couldn't connect");
            }
        }
        return session;
    }

    private final void $$robo$$android_app_backup_BackupManager$setBackupEnabled(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setBackupEnabled(isEnabled);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "setBackupEnabled() couldn't connect");
            }
        }
    }

    private final boolean $$robo$$android_app_backup_BackupManager$isBackupEnabled() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isBackupEnabled();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    private final void $$robo$$android_app_backup_BackupManager$setAutoRestore(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setAutoRestore(isEnabled);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "setAutoRestore() couldn't connect");
            }
        }
    }

    private final String $$robo$$android_app_backup_BackupManager$getCurrentTransport() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getCurrentTransport();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getCurrentTransport() couldn't connect");
            }
        }
        return null;
    }

    private final String[] $$robo$$android_app_backup_BackupManager$listAllTransports() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.listAllTransports();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "listAllTransports() couldn't connect");
            }
        }
        return null;
    }

    private final String $$robo$$android_app_backup_BackupManager$selectBackupTransport(String transport) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.selectBackupTransport(transport);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "selectBackupTransport() couldn't connect");
            }
        }
        return null;
    }

    private final void $$robo$$android_app_backup_BackupManager$backupNow() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.backupNow();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "backupNow() couldn't connect");
            }
        }
    }

    private static void checkServiceBinder() {
        InvokeDynamicSupport.bootstrapStatic("checkServiceBinder", $$robo$$android_app_backup_BackupManager$checkServiceBinder(), 0);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_backup_BackupManager$__constructor__(context);
    }

    public BackupManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public void dataChanged() {
        InvokeDynamicSupport.bootstrap("dataChanged", $$robo$$android_app_backup_BackupManager$dataChanged(), 0, this);
    }

    public static void dataChanged(String string2) {
        InvokeDynamicSupport.bootstrapStatic("dataChanged", $$robo$$android_app_backup_BackupManager$dataChanged(java.lang.String ), 0, (String)string2);
    }

    public int requestRestore(RestoreObserver restoreObserver) {
        return (int)InvokeDynamicSupport.bootstrap("requestRestore", $$robo$$android_app_backup_BackupManager$requestRestore(android.app.backup.RestoreObserver ), 0, this, restoreObserver);
    }

    public RestoreSession beginRestoreSession() {
        return InvokeDynamicSupport.bootstrap("beginRestoreSession", $$robo$$android_app_backup_BackupManager$beginRestoreSession(), 0, this);
    }

    public void setBackupEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackupEnabled", $$robo$$android_app_backup_BackupManager$setBackupEnabled(boolean ), 0, this, bl);
    }

    public boolean isBackupEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBackupEnabled", $$robo$$android_app_backup_BackupManager$isBackupEnabled(), 0, this);
    }

    public void setAutoRestore(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoRestore", $$robo$$android_app_backup_BackupManager$setAutoRestore(boolean ), 0, this, bl);
    }

    public String getCurrentTransport() {
        return InvokeDynamicSupport.bootstrap("getCurrentTransport", $$robo$$android_app_backup_BackupManager$getCurrentTransport(), 0, this);
    }

    public String[] listAllTransports() {
        return InvokeDynamicSupport.bootstrap("listAllTransports", $$robo$$android_app_backup_BackupManager$listAllTransports(), 0, this);
    }

    public String selectBackupTransport(String string2) {
        return InvokeDynamicSupport.bootstrap("selectBackupTransport", $$robo$$android_app_backup_BackupManager$selectBackupTransport(java.lang.String ), 0, this, string2);
    }

    public void backupNow() {
        InvokeDynamicSupport.bootstrap("backupNow", $$robo$$android_app_backup_BackupManager$backupNow(), 0, this);
    }

    public /* synthetic */ BackupManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

