/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileBackupHelperBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FileBackupHelperBase";
    long mPtr;
    Context mContext;
    boolean mExceptionLogged;

    private void $$robo$$android_app_backup_FileBackupHelperBase$__constructor__(Context context) {
        this.mPtr = FileBackupHelperBase.ctor();
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_backup_FileBackupHelperBase$finalize() throws Throwable {
        try {
            FileBackupHelperBase.dtor(this.mPtr);
        }
        finally {
            super.finalize();
        }
    }

    private static final void $$robo$$android_app_backup_FileBackupHelperBase$performBackup_checked(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState, String[] files, String[] keys) {
        if (files.length == 0) {
            return;
        }
        for (String f : files) {
            if (f.charAt(0) == '/') continue;
            throw new RuntimeException("files must have all absolute paths: " + f);
        }
        if (files.length != keys.length) {
            throw new RuntimeException("files.length=" + files.length + " keys.length=" + keys.length);
        }
        FileDescriptor oldStateFd = oldState != null ? oldState.getFileDescriptor() : null;
        FileDescriptor newStateFd = newState.getFileDescriptor();
        if (newStateFd == null) {
            throw new NullPointerException();
        }
        int err = FileBackupHelperBase.performBackup_native(oldStateFd, data.mBackupWriter, newStateFd, files, keys);
        if (err != 0) {
            throw new RuntimeException("Backup failed 0x" + Integer.toHexString(err));
        }
    }

    private final boolean $$robo$$android_app_backup_FileBackupHelperBase$writeFile(File f, BackupDataInputStream in) {
        int result = -1;
        File parent = f.getParentFile();
        parent.mkdirs();
        result = FileBackupHelperBase.writeFile_native(this.mPtr, f.getAbsolutePath(), in.mData.mBackupReader);
        if (result != 0 && !this.mExceptionLogged) {
            Log.e("FileBackupHelperBase", "Failed restoring file '" + f + "' for app '" + this.mContext.getPackageName() + "' result=0x" + Integer.toHexString(result));
            this.mExceptionLogged = true;
        }
        return result == 0;
    }

    private final void $$robo$$android_app_backup_FileBackupHelperBase$writeNewStateDescription(ParcelFileDescriptor fd) {
        int result = FileBackupHelperBase.writeSnapshot_native(this.mPtr, fd.getFileDescriptor());
    }

    private final boolean $$robo$$android_app_backup_FileBackupHelperBase$isKeyInList(String key, String[] list) {
        for (String s : list) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static final long $$robo$$android_app_backup_FileBackupHelperBase$ctor() {
        return 0L;
    }

    private static final void $$robo$$android_app_backup_FileBackupHelperBase$dtor(long l) {
    }

    private static final int $$robo$$android_app_backup_FileBackupHelperBase$performBackup_native(FileDescriptor fileDescriptor, long l, FileDescriptor fileDescriptor2, String[] stringArray, String[] stringArray2) {
        return 0;
    }

    private static final int $$robo$$android_app_backup_FileBackupHelperBase$writeFile_native(long l, String string2, long l2) {
        return 0;
    }

    private static final int $$robo$$android_app_backup_FileBackupHelperBase$writeSnapshot_native(long l, FileDescriptor fileDescriptor) {
        return 0;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_backup_FileBackupHelperBase$__constructor__(context);
    }

    FileBackupHelperBase(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_FileBackupHelperBase$__constructor__(android.content.Context ), 0, this, context);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_app_backup_FileBackupHelperBase$finalize(), 0, this);
    }

    static void performBackup_checked(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2, String[] stringArray, String[] stringArray2) {
        InvokeDynamicSupport.bootstrapStatic("performBackup_checked", $$robo$$android_app_backup_FileBackupHelperBase$performBackup_checked(android.os.ParcelFileDescriptor android.app.backup.BackupDataOutput android.os.ParcelFileDescriptor java.lang.String[] java.lang.String[] ), 0, (ParcelFileDescriptor)parcelFileDescriptor, (BackupDataOutput)backupDataOutput, (ParcelFileDescriptor)parcelFileDescriptor2, (String[])stringArray, (String[])stringArray2);
    }

    boolean writeFile(File file, BackupDataInputStream backupDataInputStream) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeFile", $$robo$$android_app_backup_FileBackupHelperBase$writeFile(java.io.File android.app.backup.BackupDataInputStream ), 0, this, file, backupDataInputStream);
    }

    public void writeNewStateDescription(ParcelFileDescriptor parcelFileDescriptor) {
        InvokeDynamicSupport.bootstrap("writeNewStateDescription", $$robo$$android_app_backup_FileBackupHelperBase$writeNewStateDescription(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    boolean isKeyInList(String string2, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isKeyInList", $$robo$$android_app_backup_FileBackupHelperBase$isKeyInList(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    private static final native /* synthetic */ long $$robo$$ctor$nativeBinding();

    private static long ctor() {
        return (long)InvokeDynamicSupport.bootstrapStatic("ctor", $$robo$$android_app_backup_FileBackupHelperBase$ctor(), 1);
    }

    private static final native /* synthetic */ void $$robo$$dtor$nativeBinding(long var0);

    private static void dtor(long l) {
        InvokeDynamicSupport.bootstrapStatic("dtor", $$robo$$android_app_backup_FileBackupHelperBase$dtor(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$performBackup_native$nativeBinding(FileDescriptor var0, long var1, FileDescriptor var3, String[] var4, String[] var5);

    private static int performBackup_native(FileDescriptor fileDescriptor, long l, FileDescriptor fileDescriptor2, String[] stringArray, String[] stringArray2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("performBackup_native", $$robo$$android_app_backup_FileBackupHelperBase$performBackup_native(java.io.FileDescriptor long java.io.FileDescriptor java.lang.String[] java.lang.String[] ), 1, (FileDescriptor)fileDescriptor, (long)l, (FileDescriptor)fileDescriptor2, (String[])stringArray, (String[])stringArray2);
    }

    private static final native /* synthetic */ int $$robo$$writeFile_native$nativeBinding(long var0, String var2, long var3);

    private static int writeFile_native(long l, String string2, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeFile_native", $$robo$$android_app_backup_FileBackupHelperBase$writeFile_native(long java.lang.String long ), 1, (long)l, (String)string2, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$writeSnapshot_native$nativeBinding(long var0, FileDescriptor var2);

    private static int writeSnapshot_native(long l, FileDescriptor fileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeSnapshot_native", $$robo$$android_app_backup_FileBackupHelperBase$writeSnapshot_native(long java.io.FileDescriptor ), 1, (long)l, (FileDescriptor)fileDescriptor);
    }

    public /* synthetic */ FileBackupHelperBase() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileBackupHelperBase)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

