/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.app.Service;
import android.app.job.IJobCallback;
import android.app.job.IJobService;
import android.app.job.JobParameters;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class JobService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "JobService";
    public static String PERMISSION_BIND = "android.permission.BIND_JOB_SERVICE";
    private int MSG_EXECUTE_JOB = 0;
    private int MSG_STOP_JOB = 1;
    private int MSG_JOB_FINISHED = 2;
    private Object mHandlerLock;
    @GuardedBy(value="mHandlerLock")
    JobHandler mHandler;
    IJobService mBinder;

    private void $$robo$$android_app_job_JobService$__constructor__() {
        this.MSG_EXECUTE_JOB = 0;
        this.MSG_STOP_JOB = 1;
        this.MSG_JOB_FINISHED = 2;
        this.mHandlerLock = new Object();
        this.mBinder = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ JobService this$0;

            private void $$robo$$android_app_job_JobService_1$__constructor__(JobService jobService) {
            }

            private final void $$robo$$android_app_job_JobService_1$startJob(JobParameters jobParams) {
                this.this$0.ensureHandler();
                Message m = Message.obtain(this.this$0.mHandler, 0, jobParams);
                m.sendToTarget();
            }

            private final void $$robo$$android_app_job_JobService_1$stopJob(JobParameters jobParams) {
                this.this$0.ensureHandler();
                Message m = Message.obtain(this.this$0.mHandler, 1, jobParams);
                m.sendToTarget();
            }

            private void __constructor__(JobService jobService) {
                this.$$robo$$android_app_job_JobService_1$__constructor__(jobService);
            }
            {
                this.this$0 = jobService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobService_1$__constructor__(android.app.job.JobService ), 0, this, jobService);
            }

            @Override
            public void startJob(JobParameters jobParameters) {
                InvokeDynamicSupport.bootstrap("startJob", $$robo$$android_app_job_JobService_1$startJob(android.app.job.JobParameters ), 0, this, jobParameters);
            }

            @Override
            public void stopJob(JobParameters jobParameters) {
                InvokeDynamicSupport.bootstrap("stopJob", $$robo$$android_app_job_JobService_1$stopJob(android.app.job.JobParameters ), 0, this, jobParameters);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_job_JobService$ensureHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mHandler == null) {
                this.mHandler = new JobHandler(this, this.getMainLooper());
            }
        }
    }

    private final IBinder $$robo$$android_app_job_JobService$onBind(Intent intent) {
        return this.mBinder.asBinder();
    }

    public abstract boolean onStartJob(JobParameters var1);

    public abstract boolean onStopJob(JobParameters var1);

    private final void $$robo$$android_app_job_JobService$jobFinished(JobParameters params, boolean needsReschedule) {
        this.ensureHandler();
        Message m = Message.obtain(this.mHandler, 2, params);
        m.arg2 = needsReschedule ? 1 : 0;
        m.sendToTarget();
    }

    private void __constructor__() {
        this.$$robo$$android_app_job_JobService$__constructor__();
    }

    public JobService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobService$__constructor__(), 0, this);
    }

    void ensureHandler() {
        InvokeDynamicSupport.bootstrap("ensureHandler", $$robo$$android_app_job_JobService$ensureHandler(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_app_job_JobService$onBind(android.content.Intent ), 0, this, intent);
    }

    public void jobFinished(JobParameters jobParameters, boolean bl) {
        InvokeDynamicSupport.bootstrap("jobFinished", $$robo$$android_app_job_JobService$jobFinished(android.app.job.JobParameters boolean ), 0, this, jobParameters, bl);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JobService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class JobHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ JobService this$0;

        private void $$robo$$android_app_job_JobService_JobHandler$__constructor__(JobService jobService, Looper looper) {
        }

        private final void $$robo$$android_app_job_JobService_JobHandler$handleMessage(Message msg) {
            JobParameters params = (JobParameters)msg.obj;
            switch (msg.what) {
                case 0: {
                    try {
                        boolean workOngoing = this.this$0.onStartJob(params);
                        this.ackStartMessage(params, workOngoing);
                        break;
                    }
                    catch (Exception e) {
                        Log.e("JobService", "Error while executing job: " + params.getJobId());
                        throw new RuntimeException(e);
                    }
                }
                case 1: {
                    try {
                        boolean ret = this.this$0.onStopJob(params);
                        this.ackStopMessage(params, ret);
                        break;
                    }
                    catch (Exception e) {
                        Log.e("JobService", "Application unable to handle onStopJob.", e);
                        throw new RuntimeException(e);
                    }
                }
                case 2: {
                    boolean needsReschedule = msg.arg2 == 1;
                    IJobCallback callback = params.getCallback();
                    if (callback != null) {
                        try {
                            callback.jobFinished(params.getJobId(), needsReschedule);
                        }
                        catch (RemoteException e) {
                            Log.e("JobService", "Error reporting job finish to system: binder has goneaway.");
                        }
                        break;
                    }
                    Log.e("JobService", "finishJob() called for a nonexistent job id.");
                    break;
                }
                default: {
                    Log.e("JobService", "Unrecognised message received.");
                }
            }
        }

        private final void $$robo$$android_app_job_JobService_JobHandler$ackStartMessage(JobParameters params, boolean workOngoing) {
            IJobCallback callback = params.getCallback();
            int jobId = params.getJobId();
            if (callback != null) {
                try {
                    callback.acknowledgeStartMessage(jobId, workOngoing);
                }
                catch (RemoteException e) {
                    Log.e("JobService", "System unreachable for starting job.");
                }
            } else if (Log.isLoggable("JobService", 3)) {
                Log.d("JobService", "Attempting to ack a job that has already been processed.");
            }
        }

        private final void $$robo$$android_app_job_JobService_JobHandler$ackStopMessage(JobParameters params, boolean reschedule) {
            IJobCallback callback = params.getCallback();
            int jobId = params.getJobId();
            if (callback != null) {
                try {
                    callback.acknowledgeStopMessage(jobId, reschedule);
                }
                catch (RemoteException e) {
                    Log.e("JobService", "System unreachable for stopping job.");
                }
            } else if (Log.isLoggable("JobService", 3)) {
                Log.d("JobService", "Attempting to ack a job that has already been processed.");
            }
        }

        private void __constructor__(JobService jobService, Looper looper) {
            this.$$robo$$android_app_job_JobService_JobHandler$__constructor__(jobService, looper);
        }

        JobHandler(JobService jobService, Looper looper) {
            this.this$0 = jobService;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobService_JobHandler$__constructor__(android.app.job.JobService android.os.Looper ), 0, this, jobService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_job_JobService_JobHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private void ackStartMessage(JobParameters jobParameters, boolean bl) {
            InvokeDynamicSupport.bootstrap("ackStartMessage", $$robo$$android_app_job_JobService_JobHandler$ackStartMessage(android.app.job.JobParameters boolean ), 0, this, jobParameters, bl);
        }

        private void ackStopMessage(JobParameters jobParameters, boolean bl) {
            InvokeDynamicSupport.bootstrap("ackStopMessage", $$robo$$android_app_job_JobService_JobHandler$ackStopMessage(android.app.job.JobParameters boolean ), 0, this, jobParameters, bl);
        }

        public /* synthetic */ JobHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JobHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

