/*
 * Decompiled with CFR 0.152.
 */
package android.app.trust;

import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TrustManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MSG_TRUST_CHANGED = 1;
    private static int MSG_TRUST_MANAGED_CHANGED = 2;
    private static String TAG = "TrustManager";
    private static String DATA_INITIATED_BY_USER = "initiatedByUser";
    private ITrustManager mService;
    private ArrayMap<TrustListener, ITrustListener> mTrustListeners;
    private Handler mHandler;

    private void $$robo$$android_app_trust_TrustManager$__constructor__(IBinder b) {
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TrustManager this$0;

            private void $$robo$$android_app_trust_TrustManager_2$__constructor__(TrustManager trustManager, Looper x0) {
            }

            private final void $$robo$$android_app_trust_TrustManager_2$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        boolean initiatedByUser = msg.peekData() != null && msg.peekData().getBoolean("initiatedByUser");
                        ((TrustListener)msg.obj).onTrustChanged(msg.arg1 != 0, msg.arg2, initiatedByUser);
                        break;
                    }
                    case 2: {
                        ((TrustListener)msg.obj).onTrustManagedChanged(msg.arg1 != 0, msg.arg2);
                    }
                }
            }

            private void __constructor__(TrustManager trustManager, Looper looper) {
                this.$$robo$$android_app_trust_TrustManager_2$__constructor__(trustManager, looper);
            }
            {
                this.this$0 = trustManager;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_trust_TrustManager_2$__constructor__(android.app.trust.TrustManager android.os.Looper ), 0, this, trustManager, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_trust_TrustManager_2$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mService = ITrustManager.Stub.asInterface(b);
        this.mTrustListeners = new ArrayMap();
    }

    private final void $$robo$$android_app_trust_TrustManager$reportUnlockAttempt(boolean successful, int userId) {
        try {
            this.mService.reportUnlockAttempt(successful, userId);
        }
        catch (RemoteException e) {
            this.onError(e);
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$reportEnabledTrustAgentsChanged(int userId) {
        try {
            this.mService.reportEnabledTrustAgentsChanged(userId);
        }
        catch (RemoteException e) {
            this.onError(e);
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$reportRequireCredentialEntry(int userId) {
        try {
            this.mService.reportRequireCredentialEntry(userId);
        }
        catch (RemoteException e) {
            this.onError(e);
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$registerTrustListener(TrustListener trustListener) {
        try {
            ShadowedObject iTrustListener = new ShadowedObject(this, trustListener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TrustListener val$trustListener;
                /* synthetic */ TrustManager this$0;

                private void $$robo$$android_app_trust_TrustManager_1$__constructor__(TrustManager trustManager, TrustListener trustListener) {
                }

                private final void $$robo$$android_app_trust_TrustManager_1$onTrustChanged(boolean enabled, int userId, boolean initiatedByUser) {
                    Message m = this.this$0.mHandler.obtainMessage(1, enabled ? 1 : 0, userId, this.val$trustListener);
                    if (initiatedByUser) {
                        m.getData().putBoolean("initiatedByUser", initiatedByUser);
                    }
                    m.sendToTarget();
                }

                private final void $$robo$$android_app_trust_TrustManager_1$onTrustManagedChanged(boolean managed, int userId) {
                    this.this$0.mHandler.obtainMessage(2, managed ? 1 : 0, userId, this.val$trustListener).sendToTarget();
                }

                private void __constructor__(TrustManager trustManager, TrustListener trustListener) {
                    this.$$robo$$android_app_trust_TrustManager_1$__constructor__(trustManager, trustListener);
                }
                {
                    this.this$0 = trustManager;
                    this.val$trustListener = trustListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_trust_TrustManager_1$__constructor__(android.app.trust.TrustManager android.app.trust.TrustManager$TrustListener ), 0, this, trustManager, trustListener);
                }

                @Override
                public void onTrustChanged(boolean bl, int n, boolean bl2) {
                    InvokeDynamicSupport.bootstrap("onTrustChanged", $$robo$$android_app_trust_TrustManager_1$onTrustChanged(boolean int boolean ), 0, this, bl, n, bl2);
                }

                @Override
                public void onTrustManagedChanged(boolean bl, int n) {
                    InvokeDynamicSupport.bootstrap("onTrustManagedChanged", $$robo$$android_app_trust_TrustManager_1$onTrustManagedChanged(boolean int ), 0, this, bl, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mService.registerTrustListener((ITrustListener)iTrustListener);
            this.mTrustListeners.put(trustListener, (ITrustListener)iTrustListener);
        }
        catch (RemoteException e) {
            this.onError(e);
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$unregisterTrustListener(TrustListener trustListener) {
        ITrustListener iTrustListener = this.mTrustListeners.remove(trustListener);
        if (iTrustListener != null) {
            try {
                this.mService.unregisterTrustListener(iTrustListener);
            }
            catch (RemoteException e) {
                this.onError(e);
            }
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$onError(Exception e) {
        Log.e("TrustManager", "Error while calling TrustManagerService", e);
    }

    private void __constructor__(IBinder iBinder) {
        this.$$robo$$android_app_trust_TrustManager$__constructor__(iBinder);
    }

    public TrustManager(IBinder iBinder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_trust_TrustManager$__constructor__(android.os.IBinder ), 0, this, iBinder);
    }

    public void reportUnlockAttempt(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("reportUnlockAttempt", $$robo$$android_app_trust_TrustManager$reportUnlockAttempt(boolean int ), 0, this, bl, n);
    }

    public void reportEnabledTrustAgentsChanged(int n) {
        InvokeDynamicSupport.bootstrap("reportEnabledTrustAgentsChanged", $$robo$$android_app_trust_TrustManager$reportEnabledTrustAgentsChanged(int ), 0, this, n);
    }

    public void reportRequireCredentialEntry(int n) {
        InvokeDynamicSupport.bootstrap("reportRequireCredentialEntry", $$robo$$android_app_trust_TrustManager$reportRequireCredentialEntry(int ), 0, this, n);
    }

    public void registerTrustListener(TrustListener trustListener) {
        InvokeDynamicSupport.bootstrap("registerTrustListener", $$robo$$android_app_trust_TrustManager$registerTrustListener(android.app.trust.TrustManager$TrustListener ), 0, this, trustListener);
    }

    public void unregisterTrustListener(TrustListener trustListener) {
        InvokeDynamicSupport.bootstrap("unregisterTrustListener", $$robo$$android_app_trust_TrustManager$unregisterTrustListener(android.app.trust.TrustManager$TrustListener ), 0, this, trustListener);
    }

    private void onError(Exception exception) {
        InvokeDynamicSupport.bootstrap("onError", $$robo$$android_app_trust_TrustManager$onError(java.lang.Exception ), 0, this, exception);
    }

    public /* synthetic */ TrustManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrustManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface TrustListener
    extends InstrumentedInterface {
        public void onTrustChanged(boolean var1, int var2, boolean var3);

        public void onTrustManagedChanged(boolean var1, int var2);
    }
}

