/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UsageStatsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int INTERVAL_DAILY = 0;
    public static int INTERVAL_WEEKLY = 1;
    public static int INTERVAL_MONTHLY = 2;
    public static int INTERVAL_YEARLY = 3;
    public static int INTERVAL_BEST = 4;
    public static int INTERVAL_COUNT = 4;
    private static UsageEvents sEmptyResults;
    private Context mContext;
    private IUsageStatsManager mService;

    private void $$robo$$android_app_usage_UsageStatsManager$__constructor__(Context context, IUsageStatsManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final List<UsageStats> $$robo$$android_app_usage_UsageStatsManager$queryUsageStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryUsageStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final List<ConfigurationStats> $$robo$$android_app_usage_UsageStatsManager$queryConfigurations(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryConfigurationStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final UsageEvents $$robo$$android_app_usage_UsageStatsManager$queryEvents(long beginTime, long endTime) {
        try {
            UsageEvents iter = this.mService.queryEvents(beginTime, endTime, this.mContext.getOpPackageName());
            if (iter != null) {
                return iter;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    private final Map<String, UsageStats> $$robo$$android_app_usage_UsageStatsManager$queryAndAggregateUsageStats(long beginTime, long endTime) {
        List<UsageStats> stats = this.queryUsageStats(4, beginTime, endTime);
        if (stats.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, UsageStats> aggregatedStats = new ArrayMap<String, UsageStats>();
        int statCount = stats.size();
        for (int i = 0; i < statCount; ++i) {
            UsageStats newStat = stats.get(i);
            UsageStats existingStat = aggregatedStats.get(newStat.getPackageName());
            if (existingStat == null) {
                aggregatedStats.put(newStat.mPackageName, newStat);
                continue;
            }
            existingStat.add(newStat);
        }
        return aggregatedStats;
    }

    static void __staticInitializer__() {
        sEmptyResults = new UsageEvents();
    }

    private void __constructor__(Context context, IUsageStatsManager iUsageStatsManager) {
        this.$$robo$$android_app_usage_UsageStatsManager$__constructor__(context, iUsageStatsManager);
    }

    public UsageStatsManager(Context context, IUsageStatsManager iUsageStatsManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_UsageStatsManager$__constructor__(android.content.Context android.app.usage.IUsageStatsManager ), 0, this, context, iUsageStatsManager);
    }

    public List<UsageStats> queryUsageStats(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryUsageStats", $$robo$$android_app_usage_UsageStatsManager$queryUsageStats(int long long ), 0, this, n, l, l2);
    }

    public List<ConfigurationStats> queryConfigurations(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryConfigurations", $$robo$$android_app_usage_UsageStatsManager$queryConfigurations(int long long ), 0, this, n, l, l2);
    }

    public UsageEvents queryEvents(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryEvents", $$robo$$android_app_usage_UsageStatsManager$queryEvents(long long ), 0, this, l, l2);
    }

    public Map<String, UsageStats> queryAndAggregateUsageStats(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryAndAggregateUsageStats", $$robo$$android_app_usage_UsageStatsManager$queryAndAggregateUsageStats(long long ), 0, this, l, l2);
    }

    static {
        RobolectricInternals.classInitializing(UsageStatsManager.class);
    }

    public /* synthetic */ UsageStatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsageStatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

