/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHealth;
import android.bluetooth.BluetoothInputDevice;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothAdapter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothAdapter";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static int ERROR = Integer.MIN_VALUE;
    public static String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static int STATE_OFF = 10;
    public static int STATE_TURNING_ON = 11;
    public static int STATE_ON = 12;
    public static int STATE_TURNING_OFF = 13;
    public static String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static int SCAN_MODE_NONE = 20;
    public static int SCAN_MODE_CONNECTABLE = 21;
    public static int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    public static int STATE_DISCONNECTED = 0;
    public static int STATE_CONNECTING = 1;
    public static int STATE_CONNECTED = 2;
    public static int STATE_DISCONNECTING = 3;
    public static String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    private static int ADDRESS_LENGTH = 17;
    private static int CONTROLLER_ENERGY_UPDATE_TIMEOUT_MILLIS = 30;
    public static int ACTIVITY_ENERGY_INFO_CACHED = 0;
    public static int ACTIVITY_ENERGY_INFO_REFRESHED = 1;
    private static BluetoothAdapter sAdapter;
    private static BluetoothLeScanner sBluetoothLeScanner;
    private static BluetoothLeAdvertiser sBluetoothLeAdvertiser;
    private IBluetoothManager mManagerService;
    private IBluetooth mService;
    private Object mLock;
    private Map<LeScanCallback, ScanCallback> mLeScanClients;
    private IBluetoothManagerCallback mManagerCallback;
    private ArrayList<IBluetoothManagerCallback> mProxyServiceStateCallbacks;

    private static final synchronized BluetoothAdapter $$robo$$android_bluetooth_BluetoothAdapter$getDefaultAdapter() {
        if (sAdapter == null) {
            IBinder b = ServiceManager.getService("bluetooth_manager");
            if (b != null) {
                IBluetoothManager managerService = IBluetoothManager.Stub.asInterface(b);
                sAdapter = new BluetoothAdapter(managerService);
            } else {
                Log.e("BluetoothAdapter", "Bluetooth binder is null");
            }
        }
        return sAdapter;
    }

    private void $$robo$$android_bluetooth_BluetoothAdapter$__constructor__(IBluetoothManager managerService) {
        this.mLock = new Object();
        this.mManagerCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothAdapter this$0;

            private void $$robo$$android_bluetooth_BluetoothAdapter_1$__constructor__(BluetoothAdapter bluetoothAdapter) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceUp(IBluetooth bluetoothService) {
                IBluetoothManagerCallback iBluetoothManagerCallback = this.this$0.mManagerCallback;
                synchronized (iBluetoothManagerCallback) {
                    this.this$0.mService = bluetoothService;
                    for (IBluetoothManagerCallback cb : this.this$0.mProxyServiceStateCallbacks) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceUp(bluetoothService);
                                continue;
                            }
                            Log.d("BluetoothAdapter", "onBluetoothServiceUp: cb is null!!!");
                        }
                        catch (Exception e) {
                            Log.e("BluetoothAdapter", "", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceDown() {
                IBluetoothManagerCallback iBluetoothManagerCallback = this.this$0.mManagerCallback;
                synchronized (iBluetoothManagerCallback) {
                    this.this$0.mService = null;
                    this.this$0.mLeScanClients.clear();
                    if (sBluetoothLeAdvertiser != null) {
                        sBluetoothLeAdvertiser.cleanup();
                    }
                    if (sBluetoothLeScanner != null) {
                        sBluetoothLeScanner.cleanup();
                    }
                    for (IBluetoothManagerCallback cb : this.this$0.mProxyServiceStateCallbacks) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceDown();
                                continue;
                            }
                            Log.d("BluetoothAdapter", "onBluetoothServiceDown: cb is null!!!");
                        }
                        catch (Exception e) {
                            Log.e("BluetoothAdapter", "", e);
                        }
                    }
                }
            }

            private void __constructor__(BluetoothAdapter bluetoothAdapter) {
                this.$$robo$$android_bluetooth_BluetoothAdapter_1$__constructor__(bluetoothAdapter);
            }
            {
                this.this$0 = bluetoothAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter_1$__constructor__(android.bluetooth.BluetoothAdapter ), 0, this, bluetoothAdapter);
            }

            @Override
            public void onBluetoothServiceUp(IBluetooth iBluetooth) {
                InvokeDynamicSupport.bootstrap("onBluetoothServiceUp", $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceUp(android.bluetooth.IBluetooth ), 0, this, iBluetooth);
            }

            @Override
            public void onBluetoothServiceDown() {
                InvokeDynamicSupport.bootstrap("onBluetoothServiceDown", $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceDown(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mProxyServiceStateCallbacks = new ArrayList();
        if (managerService == null) {
            throw new IllegalArgumentException("bluetooth manager service is null");
        }
        try {
            this.mService = managerService.registerAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        this.mManagerService = managerService;
        this.mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(String address) {
        return new BluetoothDevice(address);
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        return new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BluetoothLeAdvertiser $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeAdvertiser() {
        if (this.getState() != 12) {
            return null;
        }
        if (!this.isMultipleAdvertisementSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeAdvertiser == null) {
                sBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this.mManagerService);
            }
        }
        return sBluetoothLeAdvertiser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BluetoothLeScanner $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeScanner() {
        if (this.getState() != 12) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeScanner == null) {
                sBluetoothLeScanner = new BluetoothLeScanner(this.mManagerService);
            }
        }
        return sBluetoothLeScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isEnabled() {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.isEnabled();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothAdapter$getState() {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    int state = this.mService.getState();
                    return state;
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        Log.d("BluetoothAdapter", "" + this.hashCode() + ": getState() :  mService = null. Returning STATE_OFF");
        return 10;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$enable() {
        if (this.isEnabled()) {
            Log.d("BluetoothAdapter", "enable(): BT is already enabled..!");
            return true;
        }
        try {
            return this.mManagerService.enable();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$disable() {
        try {
            return this.mManagerService.disable(true);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$disable(boolean persist) {
        try {
            return this.mManagerService.disable(persist);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothAdapter$getAddress() {
        try {
            return this.mManagerService.getAddress();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return null;
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothAdapter$getName() {
        try {
            return this.mManagerService.getName();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$configHciSnoopLog(boolean enable) {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.configHciSnoopLog(enable);
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParcelUuid[] $$robo$$android_bluetooth_BluetoothAdapter$getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getUuids();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.setName(name);
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothAdapter$getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getScanMode();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int mode, int duration) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.setScanMode(mode, duration);
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int mode) {
        if (this.getState() != 12) {
            return false;
        }
        return this.setScanMode(mode, this.getDiscoverableTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothAdapter$getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getDiscoverableTimeout();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothAdapter$setDiscoverableTimeout(int timeout) {
        if (this.getState() != 12) {
            return;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    this.mService.setDiscoverableTimeout(timeout);
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.startDiscovery();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.cancelDiscovery();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.isDiscovering();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.isMultiAdvertisementSupported();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isMultipleAdvertisementSupported, error: ", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedFilteringSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.isOffloadedFilteringSupported();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isOffloadedFilteringSupported, error: ", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedScanBatchingSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.isOffloadedScanBatchingSupported();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isOffloadedScanBatchingSupported, error: ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BluetoothActivityEnergyInfo $$robo$$android_bluetooth_BluetoothAdapter$getControllerActivityEnergyInfo(int updateType) {
        if (this.getState() != 12) {
            return null;
        }
        try {
            if (!this.mService.isActivityAndEnergyReportingSupported()) {
                return null;
            }
            BluetoothAdapter bluetoothAdapter = this;
            synchronized (bluetoothAdapter) {
                BluetoothActivityEnergyInfo record;
                if (updateType == 1) {
                    this.mService.getActivityEnergyInfoFromController();
                    this.wait(30L);
                }
                if ((record = this.mService.reportActivityInfo()).isValid()) {
                    return record;
                }
                return null;
            }
        }
        catch (InterruptedException e) {
            Log.e("BluetoothAdapter", "getControllerActivityEnergyInfoCallback wait interrupted: " + e);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getControllerActivityEnergyInfoCallback: " + e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<BluetoothDevice> $$robo$$android_bluetooth_BluetoothAdapter$getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.toDeviceSet(this.mService.getBondedDevices());
                }
            }
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothAdapter$getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getAdapterConnectionState();
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getConnectionState:", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothAdapter$getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getProfileConnectionState(profile);
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getProfileConnectionState:", e);
        }
        return 0;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommOn(int channel) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, true, port);
        int errno = socket.mSocket.bindListen();
        if (errno < 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private static final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingScoOn() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(2, false, false, -1);
        int errno = socket.mSocket.bindListen();
        if (errno < 0) {
            // empty if block
        }
        return socket;
    }

    private final Pair<byte[], byte[]> $$robo$$android_bluetooth_BluetoothAdapter$readOutOfBandData() {
        if (this.getState() != 12) {
            return null;
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener);
            return true;
        }
        if (profile == 10) {
            BluetoothA2dpSink a2dpSink = new BluetoothA2dpSink(context, listener);
            return true;
        }
        if (profile == 11) {
            BluetoothAvrcpController avrcp = new BluetoothAvrcpController(context, listener);
            return true;
        }
        if (profile == 4) {
            BluetoothInputDevice iDev = new BluetoothInputDevice(context, listener);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener);
            return true;
        }
        if (profile == 3) {
            BluetoothHealth health = new BluetoothHealth(context, listener);
            return true;
        }
        if (profile == 9) {
            BluetoothMap map = new BluetoothMap(context, listener);
            return true;
        }
        if (profile == 16) {
            BluetoothHeadsetClient headsetClient = new BluetoothHeadsetClient(context, listener);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_bluetooth_BluetoothAdapter$closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        switch (profile) {
            case 1: {
                BluetoothHeadset headset = (BluetoothHeadset)proxy;
                headset.close();
                break;
            }
            case 2: {
                BluetoothA2dp a2dp = (BluetoothA2dp)proxy;
                a2dp.close();
                break;
            }
            case 10: {
                BluetoothA2dpSink a2dpSink = (BluetoothA2dpSink)proxy;
                a2dpSink.close();
                break;
            }
            case 11: {
                BluetoothAvrcpController avrcp = (BluetoothAvrcpController)proxy;
                avrcp.close();
                break;
            }
            case 4: {
                BluetoothInputDevice iDev = (BluetoothInputDevice)proxy;
                iDev.close();
                break;
            }
            case 5: {
                BluetoothPan pan = (BluetoothPan)proxy;
                pan.close();
                break;
            }
            case 3: {
                BluetoothHealth health = (BluetoothHealth)proxy;
                health.close();
                break;
            }
            case 7: {
                BluetoothGatt gatt = (BluetoothGatt)proxy;
                gatt.close();
                break;
            }
            case 8: {
                BluetoothGattServer gattServer = (BluetoothGattServer)proxy;
                gattServer.close();
                break;
            }
            case 9: {
                BluetoothMap map = (BluetoothMap)proxy;
                map.close();
                break;
            }
            case 16: {
                BluetoothHeadsetClient headsetClient = (BluetoothHeadsetClient)proxy;
                headsetClient.close();
            }
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d("BluetoothAdapter", "enableNoAutoConnect(): BT is already enabled..!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback) {
        if (callback == null) {
            return false;
        }
        return false;
    }

    private final Set<BluetoothDevice> $$robo$$android_bluetooth_BluetoothAdapter$toDeviceSet(BluetoothDevice[] devices) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(Arrays.asList(devices));
        return Collections.unmodifiableSet(deviceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothAdapter$finalize() throws Throwable {
        try {
            this.mManagerService.unregisterAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            super.finalize();
        }
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothAdapter$checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private final IBluetoothManager $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothManager() {
        return this.mManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IBluetooth $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothService(IBluetoothManagerCallback cb) {
        IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
        synchronized (iBluetoothManagerCallback) {
            if (cb == null) {
                Log.w("BluetoothAdapter", "getBluetoothService() called with no BluetoothManagerCallback");
            } else if (!this.mProxyServiceStateCallbacks.contains(cb)) {
                this.mProxyServiceStateCallbacks.add(cb);
            }
        }
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothAdapter$removeServiceStateCallback(IBluetoothManagerCallback cb) {
        IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
        synchronized (iBluetoothManagerCallback) {
            this.mProxyServiceStateCallbacks.remove(cb);
        }
    }

    @Deprecated
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(UUID[] serviceUuids, LeScanCallback callback) {
        Log.d("BluetoothAdapter", "startLeScan(): " + serviceUuids);
        if (callback == null) {
            Log.e("BluetoothAdapter", "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            Log.e("BluetoothAdapter", "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            if (this.mLeScanClients.containsKey(callback)) {
                Log.e("BluetoothAdapter", "LE Scan has already started");
                return false;
            }
            try {
                IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
                if (iGatt == null) {
                    return false;
                }
                ShadowedObject scanCallback = new ShadowedObject(this, serviceUuids, callback){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ UUID[] val$serviceUuids;
                    /* synthetic */ LeScanCallback val$callback;
                    /* synthetic */ BluetoothAdapter this$0;

                    private void $$robo$$android_bluetooth_BluetoothAdapter_2$__constructor__(BluetoothAdapter bluetoothAdapter, UUID[] uUIDArray, LeScanCallback leScanCallback) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothAdapter_2$onScanResult(int callbackType, ScanResult result) {
                        if (callbackType != 1) {
                            Log.e("BluetoothAdapter", "LE Scan has already started");
                            return;
                        }
                        ScanRecord scanRecord = result.getScanRecord();
                        if (scanRecord == null) {
                            return;
                        }
                        if (this.val$serviceUuids != null) {
                            ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
                            for (UUID uuid : this.val$serviceUuids) {
                                uuids.add(new ParcelUuid(uuid));
                            }
                            List<ParcelUuid> scanServiceUuids = scanRecord.getServiceUuids();
                            if (scanServiceUuids == null || !scanServiceUuids.containsAll(uuids)) {
                                Log.d("BluetoothAdapter", "uuids does not match");
                                return;
                            }
                        }
                        this.val$callback.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                    }

                    private void __constructor__(BluetoothAdapter bluetoothAdapter, UUID[] uUIDArray, LeScanCallback leScanCallback) {
                        this.$$robo$$android_bluetooth_BluetoothAdapter_2$__constructor__(bluetoothAdapter, uUIDArray, leScanCallback);
                    }
                    {
                        this.this$0 = bluetoothAdapter;
                        this.val$serviceUuids = uUIDArray;
                        this.val$callback = leScanCallback;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter_2$__constructor__(android.bluetooth.BluetoothAdapter java.util.UUID[] android.bluetooth.BluetoothAdapter$LeScanCallback ), 0, this, bluetoothAdapter, uUIDArray, leScanCallback);
                    }

                    @Override
                    public void onScanResult(int n, ScanResult scanResult) {
                        InvokeDynamicSupport.bootstrap("onScanResult", $$robo$$android_bluetooth_BluetoothAdapter_2$onScanResult(int android.bluetooth.le.ScanResult ), 0, this, n, scanResult);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
                ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                if (serviceUuids != null && serviceUuids.length > 0) {
                    ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuids[0])).build();
                    filters.add(filter);
                }
                scanner.startScan(filters, settings, (ScanCallback)scanCallback);
                this.mLeScanClients.put(callback, (ScanCallback)scanCallback);
                return true;
            }
            catch (RemoteException e) {
                Log.e("BluetoothAdapter", "", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final void $$robo$$android_bluetooth_BluetoothAdapter$stopLeScan(LeScanCallback callback) {
        Log.d("BluetoothAdapter", "stopLeScan()");
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            ScanCallback scanCallback = this.mLeScanClients.remove(callback);
            if (scanCallback == null) {
                Log.d("BluetoothAdapter", "scan not started yet");
                return;
            }
            scanner.stopScan(scanCallback);
        }
    }

    public static synchronized BluetoothAdapter getDefaultAdapter() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultAdapter", $$robo$$android_bluetooth_BluetoothAdapter$getDefaultAdapter(), 0);
    }

    private void __constructor__(IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_BluetoothAdapter$__constructor__(iBluetoothManager);
    }

    BluetoothAdapter(IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter$__constructor__(android.bluetooth.IBluetoothManager ), 0, this, iBluetoothManager);
    }

    public BluetoothDevice getRemoteDevice(String string2) {
        return InvokeDynamicSupport.bootstrap("getRemoteDevice", $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(java.lang.String ), 0, this, string2);
    }

    public BluetoothDevice getRemoteDevice(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getRemoteDevice", $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(byte[] ), 0, this, byArray);
    }

    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        return InvokeDynamicSupport.bootstrap("getBluetoothLeAdvertiser", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeAdvertiser(), 0, this);
    }

    public BluetoothLeScanner getBluetoothLeScanner() {
        return InvokeDynamicSupport.bootstrap("getBluetoothLeScanner", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeScanner(), 0, this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothAdapter$isEnabled(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_bluetooth_BluetoothAdapter$getState(), 0, this);
    }

    public boolean enable() {
        return (boolean)InvokeDynamicSupport.bootstrap("enable", $$robo$$android_bluetooth_BluetoothAdapter$enable(), 0, this);
    }

    public boolean disable() {
        return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_bluetooth_BluetoothAdapter$disable(), 0, this);
    }

    public boolean disable(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_bluetooth_BluetoothAdapter$disable(boolean ), 0, this, bl);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_bluetooth_BluetoothAdapter$getAddress(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_bluetooth_BluetoothAdapter$getName(), 0, this);
    }

    public boolean configHciSnoopLog(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("configHciSnoopLog", $$robo$$android_bluetooth_BluetoothAdapter$configHciSnoopLog(boolean ), 0, this, bl);
    }

    public ParcelUuid[] getUuids() {
        return InvokeDynamicSupport.bootstrap("getUuids", $$robo$$android_bluetooth_BluetoothAdapter$getUuids(), 0, this);
    }

    public boolean setName(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setName", $$robo$$android_bluetooth_BluetoothAdapter$setName(java.lang.String ), 0, this, string2);
    }

    public int getScanMode() {
        return (int)InvokeDynamicSupport.bootstrap("getScanMode", $$robo$$android_bluetooth_BluetoothAdapter$getScanMode(), 0, this);
    }

    public boolean setScanMode(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setScanMode", $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int int ), 0, this, n, n2);
    }

    public boolean setScanMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setScanMode", $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int ), 0, this, n);
    }

    public int getDiscoverableTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getDiscoverableTimeout", $$robo$$android_bluetooth_BluetoothAdapter$getDiscoverableTimeout(), 0, this);
    }

    public void setDiscoverableTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setDiscoverableTimeout", $$robo$$android_bluetooth_BluetoothAdapter$setDiscoverableTimeout(int ), 0, this, n);
    }

    public boolean startDiscovery() {
        return (boolean)InvokeDynamicSupport.bootstrap("startDiscovery", $$robo$$android_bluetooth_BluetoothAdapter$startDiscovery(), 0, this);
    }

    public boolean cancelDiscovery() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelDiscovery", $$robo$$android_bluetooth_BluetoothAdapter$cancelDiscovery(), 0, this);
    }

    public boolean isDiscovering() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDiscovering", $$robo$$android_bluetooth_BluetoothAdapter$isDiscovering(), 0, this);
    }

    public boolean isMultipleAdvertisementSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultipleAdvertisementSupported", $$robo$$android_bluetooth_BluetoothAdapter$isMultipleAdvertisementSupported(), 0, this);
    }

    public boolean isOffloadedFilteringSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedFilteringSupported", $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedFilteringSupported(), 0, this);
    }

    public boolean isOffloadedScanBatchingSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedScanBatchingSupported", $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedScanBatchingSupported(), 0, this);
    }

    public BluetoothActivityEnergyInfo getControllerActivityEnergyInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getControllerActivityEnergyInfo", $$robo$$android_bluetooth_BluetoothAdapter$getControllerActivityEnergyInfo(int ), 0, this, n);
    }

    public Set<BluetoothDevice> getBondedDevices() {
        return InvokeDynamicSupport.bootstrap("getBondedDevices", $$robo$$android_bluetooth_BluetoothAdapter$getBondedDevices(), 0, this);
    }

    public int getConnectionState() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothAdapter$getConnectionState(), 0, this);
    }

    public int getProfileConnectionState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getProfileConnectionState", $$robo$$android_bluetooth_BluetoothAdapter$getProfileConnectionState(int ), 0, this, n);
    }

    public BluetoothServerSocket listenUsingRfcommOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommOn(int ), 0, this, n);
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingRfcommWithServiceRecord", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommWithServiceRecord(java.lang.String java.util.UUID ), 0, this, string2, uUID);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingInsecureRfcommWithServiceRecord", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommWithServiceRecord(java.lang.String java.util.UUID ), 0, this, string2, uUID);
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingEncryptedRfcommWithServiceRecord", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommWithServiceRecord(java.lang.String java.util.UUID ), 0, this, string2, uUID);
    }

    private BluetoothServerSocket createNewRfcommSocketAndRecord(String string2, UUID uUID, boolean bl, boolean bl2) throws IOException {
        return InvokeDynamicSupport.bootstrap("createNewRfcommSocketAndRecord", $$robo$$android_bluetooth_BluetoothAdapter$createNewRfcommSocketAndRecord(java.lang.String java.util.UUID boolean boolean ), 0, this, string2, uUID, bl, bl2);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingInsecureRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommOn(int ), 0, this, n);
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingEncryptedRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommOn(int ), 0, this, n);
    }

    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("listenUsingScoOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingScoOn(), 0);
    }

    public Pair<byte[], byte[]> readOutOfBandData() {
        return InvokeDynamicSupport.bootstrap("readOutOfBandData", $$robo$$android_bluetooth_BluetoothAdapter$readOutOfBandData(), 0, this);
    }

    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener serviceListener, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getProfileProxy", $$robo$$android_bluetooth_BluetoothAdapter$getProfileProxy(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener int ), 0, this, context, serviceListener, n);
    }

    public void closeProfileProxy(int n, BluetoothProfile bluetoothProfile) {
        InvokeDynamicSupport.bootstrap("closeProfileProxy", $$robo$$android_bluetooth_BluetoothAdapter$closeProfileProxy(int android.bluetooth.BluetoothProfile ), 0, this, n, bluetoothProfile);
    }

    public boolean enableNoAutoConnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableNoAutoConnect", $$robo$$android_bluetooth_BluetoothAdapter$enableNoAutoConnect(), 0, this);
    }

    public boolean changeApplicationBluetoothState(boolean bl, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("changeApplicationBluetoothState", $$robo$$android_bluetooth_BluetoothAdapter$changeApplicationBluetoothState(boolean android.bluetooth.BluetoothAdapter$BluetoothStateChangeCallback ), 0, this, bl, bluetoothStateChangeCallback);
    }

    private Set<BluetoothDevice> toDeviceSet(BluetoothDevice[] bluetoothDeviceArray) {
        return InvokeDynamicSupport.bootstrap("toDeviceSet", $$robo$$android_bluetooth_BluetoothAdapter$toDeviceSet(android.bluetooth.BluetoothDevice[] ), 0, this, bluetoothDeviceArray);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothAdapter$finalize(), 0, this);
    }

    public static boolean checkBluetoothAddress(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkBluetoothAddress", $$robo$$android_bluetooth_BluetoothAdapter$checkBluetoothAddress(java.lang.String ), 0, (String)string2);
    }

    IBluetoothManager getBluetoothManager() {
        return InvokeDynamicSupport.bootstrap("getBluetoothManager", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothManager(), 0, this);
    }

    IBluetooth getBluetoothService(IBluetoothManagerCallback iBluetoothManagerCallback) {
        return InvokeDynamicSupport.bootstrap("getBluetoothService", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothService(android.bluetooth.IBluetoothManagerCallback ), 0, this, iBluetoothManagerCallback);
    }

    void removeServiceStateCallback(IBluetoothManagerCallback iBluetoothManagerCallback) {
        InvokeDynamicSupport.bootstrap("removeServiceStateCallback", $$robo$$android_bluetooth_BluetoothAdapter$removeServiceStateCallback(android.bluetooth.IBluetoothManagerCallback ), 0, this, iBluetoothManagerCallback);
    }

    @Deprecated
    public boolean startLeScan(LeScanCallback leScanCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("startLeScan", $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(android.bluetooth.BluetoothAdapter$LeScanCallback ), 0, this, leScanCallback);
    }

    @Deprecated
    public boolean startLeScan(UUID[] uUIDArray, LeScanCallback leScanCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("startLeScan", $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(java.util.UUID[] android.bluetooth.BluetoothAdapter$LeScanCallback ), 0, this, uUIDArray, leScanCallback);
    }

    @Deprecated
    public void stopLeScan(LeScanCallback leScanCallback) {
        InvokeDynamicSupport.bootstrap("stopLeScan", $$robo$$android_bluetooth_BluetoothAdapter$stopLeScan(android.bluetooth.BluetoothAdapter$LeScanCallback ), 0, this, leScanCallback);
    }

    public /* synthetic */ BluetoothAdapter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface LeScanCallback
    extends InstrumentedInterface {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private BluetoothStateChangeCallback mCallback;
        /* synthetic */ BluetoothAdapter this$0;

        private void $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$__constructor__(BluetoothAdapter bluetoothAdapter, BluetoothStateChangeCallback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }

        private void __constructor__(BluetoothAdapter bluetoothAdapter, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
            this.$$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$__constructor__(bluetoothAdapter, bluetoothStateChangeCallback);
        }

        StateChangeCallbackWrapper(BluetoothAdapter bluetoothAdapter, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
            this.this$0 = bluetoothAdapter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$__constructor__(android.bluetooth.BluetoothAdapter android.bluetooth.BluetoothAdapter$BluetoothStateChangeCallback ), 0, this, bluetoothAdapter, bluetoothStateChangeCallback);
        }

        @Override
        public void onBluetoothStateChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$onBluetoothStateChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ StateChangeCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateChangeCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface BluetoothStateChangeCallback
    extends InstrumentedInterface {
        public void onBluetoothStateChange(boolean var1);
    }
}

