/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.content.Context;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothGatt
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothGatt";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private Context mContext;
    private IBluetoothGatt mService;
    private BluetoothGattCallback mCallback;
    private int mClientIf;
    private boolean mAuthRetry;
    private BluetoothDevice mDevice;
    private boolean mAutoConnect;
    private int mConnState;
    private Object mStateLock;
    private Boolean mDeviceBusy;
    private int mTransport;
    private static int CONN_STATE_IDLE = 0;
    private static int CONN_STATE_CONNECTING = 1;
    private static int CONN_STATE_CONNECTED = 2;
    private static int CONN_STATE_DISCONNECTING = 3;
    private static int CONN_STATE_CLOSED = 4;
    private List<BluetoothGattService> mServices;
    public static int GATT_SUCCESS = 0;
    public static int GATT_READ_NOT_PERMITTED = 2;
    public static int GATT_WRITE_NOT_PERMITTED = 3;
    public static int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static int GATT_INVALID_OFFSET = 7;
    public static int GATT_INVALID_ATTRIBUTE_LENGTH = 13;
    public static int GATT_CONNECTION_CONGESTED = 143;
    public static int GATT_FAILURE = 257;
    public static int CONNECTION_PRIORITY_BALANCED = 0;
    public static int CONNECTION_PRIORITY_HIGH = 1;
    public static int CONNECTION_PRIORITY_LOW_POWER = 2;
    static int AUTHENTICATION_NONE = 0;
    static int AUTHENTICATION_NO_MITM = 1;
    static int AUTHENTICATION_MITM = 2;
    private IBluetoothGattCallback mBluetoothGattCallback;

    private void $$robo$$android_bluetooth_BluetoothGatt$__constructor__(Context context, IBluetoothGatt iGatt, BluetoothDevice device, int transport) {
        this.mAuthRetry = false;
        this.mStateLock = new Object();
        this.mDeviceBusy = false;
        this.mBluetoothGattCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothGatt this$0;

            private void $$robo$$android_bluetooth_BluetoothGatt_1$__constructor__(BluetoothGatt bluetoothGatt) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onClientRegistered(int status, int clientIf) {
                Log.d("BluetoothGatt", "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
                this.this$0.mClientIf = clientIf;
                if (status != 0) {
                    this.this$0.mCallback.onConnectionStateChange(this.this$0, 257, 0);
                    Object object = this.this$0.mStateLock;
                    synchronized (object) {
                        this.this$0.mConnState = 0;
                    }
                    return;
                }
                try {
                    this.this$0.mService.clientConnect(this.this$0.mClientIf, this.this$0.mDevice.getAddress(), !this.this$0.mAutoConnect, this.this$0.mTransport);
                }
                catch (RemoteException e) {
                    Log.e("BluetoothGatt", "", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onClientConnectionState(int status, int clientIf, boolean connected, String address) {
                Log.d("BluetoothGatt", "onClientConnectionState() - status=" + status + " clientIf=" + clientIf + " device=" + address);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                int profileState = connected ? 2 : 0;
                try {
                    this.this$0.mCallback.onConnectionStateChange(this.this$0, status, profileState);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
                Object object = this.this$0.mStateLock;
                synchronized (object) {
                    if (connected) {
                        this.this$0.mConnState = 2;
                    } else {
                        this.this$0.mConnState = 0;
                    }
                }
                object = this.this$0.mDeviceBusy;
                synchronized (object) {
                    this.this$0.mDeviceBusy = false;
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onGetService(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                this.this$0.mServices.add(new BluetoothGattService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType));
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onGetIncludedService(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int inclSrvcType, int inclSrvcInstId, ParcelUuid inclSrvcUuid) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                BluetoothGattService includedService = this.this$0.getService(this.this$0.mDevice, inclSrvcUuid.getUuid(), inclSrvcInstId, inclSrvcType);
                if (service != null && includedService != null) {
                    service.addIncludedService(includedService);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onGetCharacteristic(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int charProps) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service != null) {
                    service.addCharacteristic(new BluetoothGattCharacteristic(service, charUuid.getUuid(), charInstId, charProps, 0));
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onGetDescriptor(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int descrInstId, ParcelUuid descUuid) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service == null) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(charUuid.getUuid(), charInstId);
                if (characteristic == null) {
                    return;
                }
                characteristic.addDescriptor(new BluetoothGattDescriptor(characteristic, descUuid.getUuid(), descrInstId, 0));
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onSearchComplete(String address, int status) {
                Log.d("BluetoothGatt", "onSearchComplete() = Device=" + address + " Status=" + status);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                try {
                    this.this$0.mCallback.onServicesDiscovered(this.this$0, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicRead(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, byte[] value) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                if (!(status != 5 && status != 15 || this.this$0.mAuthRetry)) {
                    try {
                        this.this$0.mAuthRetry = true;
                        this.this$0.mService.readCharacteristic(this.this$0.mClientIf, address, srvcType, srvcInstId, srvcUuid, charInstId, charUuid, 2);
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetry = false;
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service == null) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(charUuid.getUuid(), charInstId);
                if (characteristic == null) {
                    return;
                }
                if (status == 0) {
                    characteristic.setValue(value);
                }
                try {
                    this.this$0.mCallback.onCharacteristicRead(this.this$0, characteristic, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicWrite(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service == null) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(charUuid.getUuid(), charInstId);
                if (characteristic == null) {
                    return;
                }
                if (!(status != 5 && status != 15 || this.this$0.mAuthRetry)) {
                    try {
                        this.this$0.mAuthRetry = true;
                        this.this$0.mService.writeCharacteristic(this.this$0.mClientIf, address, srvcType, srvcInstId, srvcUuid, charInstId, charUuid, characteristic.getWriteType(), 2, characteristic.getValue());
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetry = false;
                try {
                    this.this$0.mCallback.onCharacteristicWrite(this.this$0, characteristic, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onNotify(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, byte[] value) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service == null) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(charUuid.getUuid(), charInstId);
                if (characteristic == null) {
                    return;
                }
                characteristic.setValue(value);
                try {
                    this.this$0.mCallback.onCharacteristicChanged(this.this$0, characteristic);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorRead(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int descrInstId, ParcelUuid descrUuid, byte[] value) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service == null) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(charUuid.getUuid(), charInstId);
                if (characteristic == null) {
                    return;
                }
                BluetoothGattDescriptor descriptor = characteristic.getDescriptor(descrUuid.getUuid(), descrInstId);
                if (descriptor == null) {
                    return;
                }
                if (status == 0) {
                    descriptor.setValue(value);
                }
                if (!(status != 5 && status != 15 || this.this$0.mAuthRetry)) {
                    try {
                        this.this$0.mAuthRetry = true;
                        this.this$0.mService.readDescriptor(this.this$0.mClientIf, address, srvcType, srvcInstId, srvcUuid, charInstId, charUuid, descrInstId, descrUuid, 2);
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetry = true;
                try {
                    this.this$0.mCallback.onDescriptorRead(this.this$0, descriptor, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorWrite(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int descrInstId, ParcelUuid descrUuid) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                BluetoothGattService service = this.this$0.getService(this.this$0.mDevice, srvcUuid.getUuid(), srvcInstId, srvcType);
                if (service == null) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(charUuid.getUuid(), charInstId);
                if (characteristic == null) {
                    return;
                }
                BluetoothGattDescriptor descriptor = characteristic.getDescriptor(descrUuid.getUuid(), descrInstId);
                if (descriptor == null) {
                    return;
                }
                if (!(status != 5 && status != 15 || this.this$0.mAuthRetry)) {
                    try {
                        this.this$0.mAuthRetry = true;
                        this.this$0.mService.writeDescriptor(this.this$0.mClientIf, address, srvcType, srvcInstId, srvcUuid, charInstId, charUuid, descrInstId, descrUuid, characteristic.getWriteType(), 2, descriptor.getValue());
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetry = false;
                try {
                    this.this$0.mCallback.onDescriptorWrite(this.this$0, descriptor, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onExecuteWrite(String address, int status) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                try {
                    this.this$0.mCallback.onReliableWriteCompleted(this.this$0, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onReadRemoteRssi(String address, int rssi, int status) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                try {
                    this.this$0.mCallback.onReadRemoteRssi(this.this$0, rssi, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onConfigureMTU(String address, int mtu, int status) {
                Log.d("BluetoothGatt", "onConfigureMTU() - Device=" + address + " mtu=" + mtu + " status=" + status);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                try {
                    this.this$0.mCallback.onMtuChanged(this.this$0, mtu, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
                }
            }

            private void __constructor__(BluetoothGatt bluetoothGatt) {
                this.$$robo$$android_bluetooth_BluetoothGatt_1$__constructor__(bluetoothGatt);
            }
            {
                this.this$0 = bluetoothGatt;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1$__constructor__(android.bluetooth.BluetoothGatt ), 0, this, bluetoothGatt);
            }

            @Override
            public void onClientRegistered(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onClientRegistered", $$robo$$android_bluetooth_BluetoothGatt_1$onClientRegistered(int int ), 0, this, n, n2);
            }

            @Override
            public void onClientConnectionState(int n, int n2, boolean bl, String string2) {
                InvokeDynamicSupport.bootstrap("onClientConnectionState", $$robo$$android_bluetooth_BluetoothGatt_1$onClientConnectionState(int int boolean java.lang.String ), 0, this, n, n2, bl, string2);
            }

            @Override
            public void onGetService(String string2, int n, int n2, ParcelUuid parcelUuid) {
                InvokeDynamicSupport.bootstrap("onGetService", $$robo$$android_bluetooth_BluetoothGatt_1$onGetService(java.lang.String int int android.os.ParcelUuid ), 0, this, string2, n, n2, parcelUuid);
            }

            @Override
            public void onGetIncludedService(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, int n4, ParcelUuid parcelUuid2) {
                InvokeDynamicSupport.bootstrap("onGetIncludedService", $$robo$$android_bluetooth_BluetoothGatt_1$onGetIncludedService(java.lang.String int int android.os.ParcelUuid int int android.os.ParcelUuid ), 0, this, string2, n, n2, parcelUuid, n3, n4, parcelUuid2);
            }

            @Override
            public void onGetCharacteristic(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, int n4) {
                InvokeDynamicSupport.bootstrap("onGetCharacteristic", $$robo$$android_bluetooth_BluetoothGatt_1$onGetCharacteristic(java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid int ), 0, this, string2, n, n2, parcelUuid, n3, parcelUuid2, n4);
            }

            @Override
            public void onGetDescriptor(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, int n4, ParcelUuid parcelUuid3) {
                InvokeDynamicSupport.bootstrap("onGetDescriptor", $$robo$$android_bluetooth_BluetoothGatt_1$onGetDescriptor(java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid int android.os.ParcelUuid ), 0, this, string2, n, n2, parcelUuid, n3, parcelUuid2, n4, parcelUuid3);
            }

            @Override
            public void onSearchComplete(String string2, int n) {
                InvokeDynamicSupport.bootstrap("onSearchComplete", $$robo$$android_bluetooth_BluetoothGatt_1$onSearchComplete(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void onCharacteristicRead(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onCharacteristicRead", $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicRead(java.lang.String int int int android.os.ParcelUuid int android.os.ParcelUuid byte[] ), 0, this, string2, n, n2, n3, parcelUuid, n4, parcelUuid2, byArray);
            }

            @Override
            public void onCharacteristicWrite(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2) {
                InvokeDynamicSupport.bootstrap("onCharacteristicWrite", $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicWrite(java.lang.String int int int android.os.ParcelUuid int android.os.ParcelUuid ), 0, this, string2, n, n2, n3, parcelUuid, n4, parcelUuid2);
            }

            @Override
            public void onNotify(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onNotify", $$robo$$android_bluetooth_BluetoothGatt_1$onNotify(java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid byte[] ), 0, this, string2, n, n2, parcelUuid, n3, parcelUuid2, byArray);
            }

            @Override
            public void onDescriptorRead(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onDescriptorRead", $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorRead(java.lang.String int int int android.os.ParcelUuid int android.os.ParcelUuid int android.os.ParcelUuid byte[] ), 0, this, string2, n, n2, n3, parcelUuid, n4, parcelUuid2, n5, parcelUuid3, byArray);
            }

            @Override
            public void onDescriptorWrite(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3) {
                InvokeDynamicSupport.bootstrap("onDescriptorWrite", $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorWrite(java.lang.String int int int android.os.ParcelUuid int android.os.ParcelUuid int android.os.ParcelUuid ), 0, this, string2, n, n2, n3, parcelUuid, n4, parcelUuid2, n5, parcelUuid3);
            }

            @Override
            public void onExecuteWrite(String string2, int n) {
                InvokeDynamicSupport.bootstrap("onExecuteWrite", $$robo$$android_bluetooth_BluetoothGatt_1$onExecuteWrite(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void onReadRemoteRssi(String string2, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onReadRemoteRssi", $$robo$$android_bluetooth_BluetoothGatt_1$onReadRemoteRssi(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public void onConfigureMTU(String string2, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onConfigureMTU", $$robo$$android_bluetooth_BluetoothGatt_1$onConfigureMTU(java.lang.String int int ), 0, this, string2, n, n2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mService = iGatt;
        this.mDevice = device;
        this.mTransport = transport;
        this.mServices = new ArrayList<BluetoothGattService>();
        this.mConnState = 0;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$close() {
        Log.d("BluetoothGatt", "close()");
        this.unregisterApp();
        this.mConnState = 4;
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGatt$getService(BluetoothDevice device, UUID uuid, int instanceId, int type) {
        for (BluetoothGattService svc : this.mServices) {
            if (!svc.getDevice().equals(device) || svc.getType() != type || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$registerApp(BluetoothGattCallback callback) {
        Log.d("BluetoothGatt", "registerApp()");
        if (this.mService == null) {
            return false;
        }
        this.mCallback = callback;
        UUID uuid = UUID.randomUUID();
        Log.d("BluetoothGatt", "registerApp() - UUID=" + uuid);
        try {
            this.mService.registerClient(new ParcelUuid(uuid), this.mBluetoothGattCallback);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$unregisterApp() {
        Log.d("BluetoothGatt", "unregisterApp() - mClientIf=" + this.mClientIf);
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterClient(this.mClientIf);
            this.mClientIf = 0;
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$connect(Boolean autoConnect, BluetoothGattCallback callback) {
        Log.d("BluetoothGatt", "connect() - device: " + this.mDevice.getAddress() + ", auto: " + autoConnect);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mConnState != 0) {
                throw new IllegalStateException("Not idle");
            }
            this.mConnState = 1;
        }
        if (!this.registerApp(callback)) {
            object = this.mStateLock;
            synchronized (object) {
                this.mConnState = 0;
            }
            Log.e("BluetoothGatt", "Failed to register callback");
            return false;
        }
        this.mAutoConnect = autoConnect;
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$disconnect() {
        Log.d("BluetoothGatt", "cancelOpen() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.clientDisconnect(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$connect() {
        try {
            this.mService.clientConnect(this.mClientIf, this.mDevice.getAddress(), false, this.mTransport);
            return true;
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothGatt$getDevice() {
        return this.mDevice;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$discoverServices() {
        Log.d("BluetoothGatt", "discoverServices() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServices(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final List<BluetoothGattService> $$robo$$android_bluetooth_BluetoothGatt$getServices() {
        ArrayList<BluetoothGattService> result = new ArrayList<BluetoothGattService>();
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice)) continue;
            result.add(service);
        }
        return result;
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGatt$getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice) || !service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 2) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readCharacteristic(this.mClientIf, device.getAddress(), service.getType(), service.getInstanceId(), new ParcelUuid(service.getUuid()), characteristic.getInstanceId(), new ParcelUuid(characteristic.getUuid()), 0);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeCharacteristic(this.mClientIf, device.getAddress(), service.getType(), service.getInstanceId(), new ParcelUuid(service.getUuid()), characteristic.getInstanceId(), new ParcelUuid(characteristic.getUuid()), characteristic.getWriteType(), 0, characteristic.getValue());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readDescriptor(this.mClientIf, device.getAddress(), service.getType(), service.getInstanceId(), new ParcelUuid(service.getUuid()), characteristic.getInstanceId(), new ParcelUuid(characteristic.getUuid()), descriptor.getInstanceId(), new ParcelUuid(descriptor.getUuid()), 0);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$writeDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeDescriptor(this.mClientIf, device.getAddress(), service.getType(), service.getInstanceId(), new ParcelUuid(service.getUuid()), characteristic.getInstanceId(), new ParcelUuid(characteristic.getUuid()), descriptor.getInstanceId(), new ParcelUuid(descriptor.getUuid()), characteristic.getWriteType(), 0, descriptor.getValue());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$beginReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.beginReliableWrite(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$executeReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), true);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), false);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite(BluetoothDevice mDevice) {
        this.abortReliableWrite();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        Log.d("BluetoothGatt", "setCharacteristicNotification() - uuid: " + characteristic.getUuid() + " enable: " + enable);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        try {
            this.mService.registerForNotification(this.mClientIf, device.getAddress(), service.getType(), service.getInstanceId(), new ParcelUuid(service.getUuid()), characteristic.getInstanceId(), new ParcelUuid(characteristic.getUuid()), enable);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$refresh() {
        Log.d("BluetoothGatt", "refresh() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.refreshDevice(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readRemoteRssi() {
        Log.d("BluetoothGatt", "readRssi() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.readRemoteRssi(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$requestMtu(int mtu) {
        Log.d("BluetoothGatt", "configureMTU() - device: " + this.mDevice.getAddress() + " mtu: " + mtu);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.configureMTU(this.mClientIf, this.mDevice.getAddress(), mtu);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$requestConnectionPriority(int connectionPriority) {
        if (connectionPriority < 0 || connectionPriority > 2) {
            throw new IllegalArgumentException("connectionPriority not within valid range");
        }
        Log.d("BluetoothGatt", "requestConnectionPriority() - params: " + connectionPriority);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.connectionParameterUpdate(this.mClientIf, this.mDevice.getAddress(), connectionPriority);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final int $$robo$$android_bluetooth_BluetoothGatt$getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothGatt$getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothGatt$getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    private void __constructor__(Context context, IBluetoothGatt iBluetoothGatt, BluetoothDevice bluetoothDevice, int n) {
        this.$$robo$$android_bluetooth_BluetoothGatt$__constructor__(context, iBluetoothGatt, bluetoothDevice, n);
    }

    BluetoothGatt(Context context, IBluetoothGatt iBluetoothGatt, BluetoothDevice bluetoothDevice, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt$__constructor__(android.content.Context android.bluetooth.IBluetoothGatt android.bluetooth.BluetoothDevice int ), 0, this, context, iBluetoothGatt, bluetoothDevice, n);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothGatt$close(), 0, this);
    }

    BluetoothGattService getService(BluetoothDevice bluetoothDevice, UUID uUID, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGatt$getService(android.bluetooth.BluetoothDevice java.util.UUID int int ), 0, this, bluetoothDevice, uUID, n, n2);
    }

    private boolean registerApp(BluetoothGattCallback bluetoothGattCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerApp", $$robo$$android_bluetooth_BluetoothGatt$registerApp(android.bluetooth.BluetoothGattCallback ), 0, this, bluetoothGattCallback);
    }

    private void unregisterApp() {
        InvokeDynamicSupport.bootstrap("unregisterApp", $$robo$$android_bluetooth_BluetoothGatt$unregisterApp(), 0, this);
    }

    boolean connect(Boolean bl, BluetoothGattCallback bluetoothGattCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothGatt$connect(java.lang.Boolean android.bluetooth.BluetoothGattCallback ), 0, this, bl, bluetoothGattCallback);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothGatt$disconnect(), 0, this);
    }

    public boolean connect() {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothGatt$connect(), 0, this);
    }

    public BluetoothDevice getDevice() {
        return InvokeDynamicSupport.bootstrap("getDevice", $$robo$$android_bluetooth_BluetoothGatt$getDevice(), 0, this);
    }

    public boolean discoverServices() {
        return (boolean)InvokeDynamicSupport.bootstrap("discoverServices", $$robo$$android_bluetooth_BluetoothGatt$discoverServices(), 0, this);
    }

    public List<BluetoothGattService> getServices() {
        return InvokeDynamicSupport.bootstrap("getServices", $$robo$$android_bluetooth_BluetoothGatt$getServices(), 0, this);
    }

    public BluetoothGattService getService(UUID uUID) {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGatt$getService(java.util.UUID ), 0, this, uUID);
    }

    public boolean readCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return (boolean)InvokeDynamicSupport.bootstrap("readCharacteristic", $$robo$$android_bluetooth_BluetoothGatt$readCharacteristic(android.bluetooth.BluetoothGattCharacteristic ), 0, this, bluetoothGattCharacteristic);
    }

    public boolean writeCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeCharacteristic", $$robo$$android_bluetooth_BluetoothGatt$writeCharacteristic(android.bluetooth.BluetoothGattCharacteristic ), 0, this, bluetoothGattCharacteristic);
    }

    public boolean readDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("readDescriptor", $$robo$$android_bluetooth_BluetoothGatt$readDescriptor(android.bluetooth.BluetoothGattDescriptor ), 0, this, bluetoothGattDescriptor);
    }

    public boolean writeDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeDescriptor", $$robo$$android_bluetooth_BluetoothGatt$writeDescriptor(android.bluetooth.BluetoothGattDescriptor ), 0, this, bluetoothGattDescriptor);
    }

    public boolean beginReliableWrite() {
        return (boolean)InvokeDynamicSupport.bootstrap("beginReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$beginReliableWrite(), 0, this);
    }

    public boolean executeReliableWrite() {
        return (boolean)InvokeDynamicSupport.bootstrap("executeReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$executeReliableWrite(), 0, this);
    }

    public void abortReliableWrite() {
        InvokeDynamicSupport.bootstrap("abortReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite(), 0, this);
    }

    public void abortReliableWrite(BluetoothDevice bluetoothDevice) {
        InvokeDynamicSupport.bootstrap("abortReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setCharacteristicNotification(BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCharacteristicNotification", $$robo$$android_bluetooth_BluetoothGatt$setCharacteristicNotification(android.bluetooth.BluetoothGattCharacteristic boolean ), 0, this, bluetoothGattCharacteristic, bl);
    }

    public boolean refresh() {
        return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_bluetooth_BluetoothGatt$refresh(), 0, this);
    }

    public boolean readRemoteRssi() {
        return (boolean)InvokeDynamicSupport.bootstrap("readRemoteRssi", $$robo$$android_bluetooth_BluetoothGatt$readRemoteRssi(), 0, this);
    }

    public boolean requestMtu(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestMtu", $$robo$$android_bluetooth_BluetoothGatt$requestMtu(int ), 0, this, n);
    }

    public boolean requestConnectionPriority(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestConnectionPriority", $$robo$$android_bluetooth_BluetoothGatt$requestConnectionPriority(int ), 0, this, n);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothGatt$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothGatt$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothGatt$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    public /* synthetic */ BluetoothGatt() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothGatt)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

