/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BluetoothGattCharacteristic
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PROPERTY_BROADCAST = 1;
    public static int PROPERTY_READ = 2;
    public static int PROPERTY_WRITE_NO_RESPONSE = 4;
    public static int PROPERTY_WRITE = 8;
    public static int PROPERTY_NOTIFY = 16;
    public static int PROPERTY_INDICATE = 32;
    public static int PROPERTY_SIGNED_WRITE = 64;
    public static int PROPERTY_EXTENDED_PROPS = 128;
    public static int PERMISSION_READ = 1;
    public static int PERMISSION_READ_ENCRYPTED = 2;
    public static int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static int PERMISSION_WRITE = 16;
    public static int PERMISSION_WRITE_ENCRYPTED = 32;
    public static int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static int PERMISSION_WRITE_SIGNED = 128;
    public static int PERMISSION_WRITE_SIGNED_MITM = 256;
    public static int WRITE_TYPE_DEFAULT = 2;
    public static int WRITE_TYPE_NO_RESPONSE = 1;
    public static int WRITE_TYPE_SIGNED = 4;
    public static int FORMAT_UINT8 = 17;
    public static int FORMAT_UINT16 = 18;
    public static int FORMAT_UINT32 = 20;
    public static int FORMAT_SINT8 = 33;
    public static int FORMAT_SINT16 = 34;
    public static int FORMAT_SINT32 = 36;
    public static int FORMAT_SFLOAT = 50;
    public static int FORMAT_FLOAT = 52;
    protected UUID mUuid;
    protected int mInstance;
    protected int mProperties;
    protected int mPermissions;
    protected int mKeySize;
    protected int mWriteType;
    protected BluetoothGattService mService;
    protected byte[] mValue;
    protected List<BluetoothGattDescriptor> mDescriptors;

    private void $$robo$$android_bluetooth_BluetoothGattCharacteristic$__constructor__(UUID uuid, int properties, int permissions) {
        this.mKeySize = 16;
        this.initCharacteristic(null, uuid, 0, properties, permissions);
    }

    private void $$robo$$android_bluetooth_BluetoothGattCharacteristic$__constructor__(BluetoothGattService service, UUID uuid, int instanceId, int properties, int permissions) {
        this.mKeySize = 16;
        this.initCharacteristic(service, uuid, instanceId, properties, permissions);
    }

    private final void $$robo$$android_bluetooth_BluetoothGattCharacteristic$initCharacteristic(BluetoothGattService service, UUID uuid, int instanceId, int properties, int permissions) {
        this.mUuid = uuid;
        this.mInstance = instanceId;
        this.mProperties = properties;
        this.mPermissions = permissions;
        this.mService = service;
        this.mValue = null;
        this.mDescriptors = new ArrayList<BluetoothGattDescriptor>();
        this.mWriteType = (this.mProperties & 4) != 0 ? 1 : 2;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$getKeySize() {
        return this.mKeySize;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattCharacteristic$addDescriptor(BluetoothGattDescriptor descriptor) {
        this.mDescriptors.add(descriptor);
        descriptor.setCharacteristic(this);
        return true;
    }

    private final BluetoothGattDescriptor $$robo$$android_bluetooth_BluetoothGattCharacteristic$getDescriptor(UUID uuid, int instanceId) {
        for (BluetoothGattDescriptor descriptor : this.mDescriptors) {
            if (!descriptor.getUuid().equals(uuid) || descriptor.getInstanceId() != instanceId) continue;
            return descriptor;
        }
        return null;
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGattCharacteristic$getService() {
        return this.mService;
    }

    private final void $$robo$$android_bluetooth_BluetoothGattCharacteristic$setService(BluetoothGattService service) {
        this.mService = service;
    }

    private final UUID $$robo$$android_bluetooth_BluetoothGattCharacteristic$getUuid() {
        return this.mUuid;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$getInstanceId() {
        return this.mInstance;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$getProperties() {
        return this.mProperties;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$getPermissions() {
        return this.mPermissions;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$getWriteType() {
        return this.mWriteType;
    }

    private final void $$robo$$android_bluetooth_BluetoothGattCharacteristic$setWriteType(int writeType) {
        this.mWriteType = writeType;
    }

    private final void $$robo$$android_bluetooth_BluetoothGattCharacteristic$setKeySize(int keySize) {
        this.mKeySize = keySize;
    }

    private final List<BluetoothGattDescriptor> $$robo$$android_bluetooth_BluetoothGattCharacteristic$getDescriptors() {
        return this.mDescriptors;
    }

    private final BluetoothGattDescriptor $$robo$$android_bluetooth_BluetoothGattCharacteristic$getDescriptor(UUID uuid) {
        for (BluetoothGattDescriptor descriptor : this.mDescriptors) {
            if (!descriptor.getUuid().equals(uuid)) continue;
            return descriptor;
        }
        return null;
    }

    private final byte[] $$robo$$android_bluetooth_BluetoothGattCharacteristic$getValue() {
        return this.mValue;
    }

    private final Integer $$robo$$android_bluetooth_BluetoothGattCharacteristic$getIntValue(int formatType, int offset) {
        if (offset + this.getTypeLen(formatType) > this.mValue.length) {
            return null;
        }
        switch (formatType) {
            case 17: {
                return this.unsignedByteToInt(this.mValue[offset]);
            }
            case 18: {
                return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]);
            }
            case 20: {
                return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]);
            }
            case 33: {
                return this.unsignedToSigned(this.unsignedByteToInt(this.mValue[offset]), 8);
            }
            case 34: {
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]), 16);
            }
            case 36: {
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]), 32);
            }
        }
        return null;
    }

    private final Float $$robo$$android_bluetooth_BluetoothGattCharacteristic$getFloatValue(int formatType, int offset) {
        if (offset + this.getTypeLen(formatType) > this.mValue.length) {
            return null;
        }
        switch (formatType) {
            case 50: {
                return Float.valueOf(this.bytesToFloat(this.mValue[offset], this.mValue[offset + 1]));
            }
            case 52: {
                return Float.valueOf(this.bytesToFloat(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]));
            }
        }
        return null;
    }

    private final String $$robo$$android_bluetooth_BluetoothGattCharacteristic$getStringValue(int offset) {
        if (offset > this.mValue.length) {
            return null;
        }
        byte[] strBytes = new byte[this.mValue.length - offset];
        for (int i = 0; i != this.mValue.length - offset; ++i) {
            strBytes[i] = this.mValue[offset + i];
        }
        return new String(strBytes);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(byte[] value) {
        this.mValue = value;
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(int value, int formatType, int offset) {
        int len = offset + this.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 33: {
                value = this.intToSignedBits(value, 8);
            }
            case 17: {
                this.mValue[offset] = (byte)(value & 0xFF);
                break;
            }
            case 34: {
                value = this.intToSignedBits(value, 16);
            }
            case 18: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset] = (byte)(value >> 8 & 0xFF);
                break;
            }
            case 36: {
                value = this.intToSignedBits(value, 32);
            }
            case 20: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(value >> 16 & 0xFF);
                this.mValue[offset] = (byte)(value >> 24 & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(int mantissa, int exponent, int formatType, int offset) {
        int len = offset + this.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 50: {
                mantissa = this.intToSignedBits(mantissa, 12);
                exponent = this.intToSignedBits(exponent, 4);
                this.mValue[offset++] = (byte)(mantissa & 0xFF);
                this.mValue[offset] = (byte)(mantissa >> 8 & 0xF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)((exponent & 0xF) << 4));
                break;
            }
            case 52: {
                mantissa = this.intToSignedBits(mantissa, 24);
                exponent = this.intToSignedBits(exponent, 8);
                this.mValue[offset++] = (byte)(mantissa & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 16 & 0xFF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)(exponent & 0xFF));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(String value) {
        this.mValue = value.getBytes();
        return true;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedBytesToInt(byte b0, byte b1) {
        return this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8);
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedBytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8) + (this.unsignedByteToInt(b2) << 16) + (this.unsignedByteToInt(b3) << 24);
    }

    private final float $$robo$$android_bluetooth_BluetoothGattCharacteristic$bytesToFloat(byte b0, byte b1) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(b0) + ((this.unsignedByteToInt(b1) & 0xF) << 8), 12);
        int exponent = this.unsignedToSigned(this.unsignedByteToInt(b1) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private final float $$robo$$android_bluetooth_BluetoothGattCharacteristic$bytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8) + (this.unsignedByteToInt(b2) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, b3));
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            unsigned = -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattCharacteristic$intToSignedBits(int i, int size) {
        if (i < 0) {
            i = (1 << size - 1) + (i & (1 << size - 1) - 1);
        }
        return i;
    }

    private void __constructor__(UUID uUID, int n, int n2) {
        this.$$robo$$android_bluetooth_BluetoothGattCharacteristic$__constructor__(uUID, n, n2);
    }

    public BluetoothGattCharacteristic(UUID uUID, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGattCharacteristic$__constructor__(java.util.UUID int int ), 0, this, uUID, n, n2);
    }

    private void __constructor__(BluetoothGattService bluetoothGattService, UUID uUID, int n, int n2, int n3) {
        this.$$robo$$android_bluetooth_BluetoothGattCharacteristic$__constructor__(bluetoothGattService, uUID, n, n2, n3);
    }

    BluetoothGattCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGattCharacteristic$__constructor__(android.bluetooth.BluetoothGattService java.util.UUID int int int ), 0, this, bluetoothGattService, uUID, n, n2, n3);
    }

    private void initCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("initCharacteristic", $$robo$$android_bluetooth_BluetoothGattCharacteristic$initCharacteristic(android.bluetooth.BluetoothGattService java.util.UUID int int int ), 0, this, bluetoothGattService, uUID, n, n2, n3);
    }

    int getKeySize() {
        return (int)InvokeDynamicSupport.bootstrap("getKeySize", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getKeySize(), 0, this);
    }

    public boolean addDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("addDescriptor", $$robo$$android_bluetooth_BluetoothGattCharacteristic$addDescriptor(android.bluetooth.BluetoothGattDescriptor ), 0, this, bluetoothGattDescriptor);
    }

    BluetoothGattDescriptor getDescriptor(UUID uUID, int n) {
        return InvokeDynamicSupport.bootstrap("getDescriptor", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getDescriptor(java.util.UUID int ), 0, this, uUID, n);
    }

    public BluetoothGattService getService() {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getService(), 0, this);
    }

    void setService(BluetoothGattService bluetoothGattService) {
        InvokeDynamicSupport.bootstrap("setService", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setService(android.bluetooth.BluetoothGattService ), 0, this, bluetoothGattService);
    }

    public UUID getUuid() {
        return InvokeDynamicSupport.bootstrap("getUuid", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getUuid(), 0, this);
    }

    public int getInstanceId() {
        return (int)InvokeDynamicSupport.bootstrap("getInstanceId", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getInstanceId(), 0, this);
    }

    public int getProperties() {
        return (int)InvokeDynamicSupport.bootstrap("getProperties", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getProperties(), 0, this);
    }

    public int getPermissions() {
        return (int)InvokeDynamicSupport.bootstrap("getPermissions", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getPermissions(), 0, this);
    }

    public int getWriteType() {
        return (int)InvokeDynamicSupport.bootstrap("getWriteType", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getWriteType(), 0, this);
    }

    public void setWriteType(int n) {
        InvokeDynamicSupport.bootstrap("setWriteType", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setWriteType(int ), 0, this, n);
    }

    public void setKeySize(int n) {
        InvokeDynamicSupport.bootstrap("setKeySize", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setKeySize(int ), 0, this, n);
    }

    public List<BluetoothGattDescriptor> getDescriptors() {
        return InvokeDynamicSupport.bootstrap("getDescriptors", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getDescriptors(), 0, this);
    }

    public BluetoothGattDescriptor getDescriptor(UUID uUID) {
        return InvokeDynamicSupport.bootstrap("getDescriptor", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getDescriptor(java.util.UUID ), 0, this, uUID);
    }

    public byte[] getValue() {
        return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getValue(), 0, this);
    }

    public Integer getIntValue(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getIntValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getIntValue(int int ), 0, this, n, n2);
    }

    public Float getFloatValue(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getFloatValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getFloatValue(int int ), 0, this, n, n2);
    }

    public String getStringValue(int n) {
        return InvokeDynamicSupport.bootstrap("getStringValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getStringValue(int ), 0, this, n);
    }

    public boolean setValue(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(byte[] ), 0, this, byArray);
    }

    public boolean setValue(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(int int int ), 0, this, n, n2, n3);
    }

    public boolean setValue(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean setValue(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_bluetooth_BluetoothGattCharacteristic$setValue(java.lang.String ), 0, this, string2);
    }

    private int getTypeLen(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTypeLen", $$robo$$android_bluetooth_BluetoothGattCharacteristic$getTypeLen(int ), 0, this, n);
    }

    private int unsignedByteToInt(byte by) {
        return (int)InvokeDynamicSupport.bootstrap("unsignedByteToInt", $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedByteToInt(byte ), 0, this, by);
    }

    private int unsignedBytesToInt(byte by, byte by2) {
        return (int)InvokeDynamicSupport.bootstrap("unsignedBytesToInt", $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedBytesToInt(byte byte ), 0, this, by, by2);
    }

    private int unsignedBytesToInt(byte by, byte by2, byte by3, byte by4) {
        return (int)InvokeDynamicSupport.bootstrap("unsignedBytesToInt", $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedBytesToInt(byte byte byte byte ), 0, this, by, by2, by3, by4);
    }

    private float bytesToFloat(byte by, byte by2) {
        return (float)InvokeDynamicSupport.bootstrap("bytesToFloat", $$robo$$android_bluetooth_BluetoothGattCharacteristic$bytesToFloat(byte byte ), 0, this, by, by2);
    }

    private float bytesToFloat(byte by, byte by2, byte by3, byte by4) {
        return (float)InvokeDynamicSupport.bootstrap("bytesToFloat", $$robo$$android_bluetooth_BluetoothGattCharacteristic$bytesToFloat(byte byte byte byte ), 0, this, by, by2, by3, by4);
    }

    private int unsignedToSigned(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("unsignedToSigned", $$robo$$android_bluetooth_BluetoothGattCharacteristic$unsignedToSigned(int int ), 0, this, n, n2);
    }

    private int intToSignedBits(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("intToSignedBits", $$robo$$android_bluetooth_BluetoothGattCharacteristic$intToSignedBits(int int ), 0, this, n, n2);
    }

    public /* synthetic */ BluetoothGattCharacteristic() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothGattCharacteristic)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

