/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadsetClientCall;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHeadsetClient;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothHeadsetClient
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothHeadsetClient";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headsetclient.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headsetclient.profile.action.AUDIO_STATE_CHANGED";
    public static String ACTION_AG_EVENT = "android.bluetooth.headsetclient.profile.action.AG_EVENT";
    public static String ACTION_CALL_CHANGED = "android.bluetooth.headsetclient.profile.action.AG_CALL_CHANGED";
    public static String ACTION_RESULT = "android.bluetooth.headsetclient.profile.action.RESULT";
    public static String ACTION_LAST_VTAG = "android.bluetooth.headsetclient.profile.action.LAST_VTAG";
    public static int STATE_AUDIO_DISCONNECTED = 0;
    public static int STATE_AUDIO_CONNECTING = 1;
    public static int STATE_AUDIO_CONNECTED = 2;
    public static String EXTRA_AUDIO_WBS = "android.bluetooth.headsetclient.extra.AUDIO_WBS";
    public static String EXTRA_NETWORK_STATUS = "android.bluetooth.headsetclient.extra.NETWORK_STATUS";
    public static String EXTRA_NETWORK_SIGNAL_STRENGTH = "android.bluetooth.headsetclient.extra.NETWORK_SIGNAL_STRENGTH";
    public static String EXTRA_NETWORK_ROAMING = "android.bluetooth.headsetclient.extra.NETWORK_ROAMING";
    public static String EXTRA_BATTERY_LEVEL = "android.bluetooth.headsetclient.extra.BATTERY_LEVEL";
    public static String EXTRA_OPERATOR_NAME = "android.bluetooth.headsetclient.extra.OPERATOR_NAME";
    public static String EXTRA_VOICE_RECOGNITION = "android.bluetooth.headsetclient.extra.VOICE_RECOGNITION";
    public static String EXTRA_IN_BAND_RING = "android.bluetooth.headsetclient.extra.IN_BAND_RING";
    public static String EXTRA_SUBSCRIBER_INFO = "android.bluetooth.headsetclient.extra.SUBSCRIBER_INFO";
    public static String EXTRA_CALL = "android.bluetooth.headsetclient.extra.CALL";
    public static String EXTRA_NUMBER = "android.bluetooth.headsetclient.extra.NUMBER";
    public static String EXTRA_RESULT_CODE = "android.bluetooth.headsetclient.extra.RESULT_CODE";
    public static String EXTRA_CME_CODE = "android.bluetooth.headsetclient.extra.CME_CODE";
    public static String EXTRA_AG_FEATURE_3WAY_CALLING = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_3WAY_CALLING";
    public static String EXTRA_AG_FEATURE_VOICE_RECOGNITION = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_VOICE_RECOGNITION";
    public static String EXTRA_AG_FEATURE_ATTACH_NUMBER_TO_VT = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_ATTACH_NUMBER_TO_VT";
    public static String EXTRA_AG_FEATURE_REJECT_CALL = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_REJECT_CALL";
    public static String EXTRA_AG_FEATURE_ECC = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_ECC";
    public static String EXTRA_AG_FEATURE_RESPONSE_AND_HOLD = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_RESPONSE_AND_HOLD";
    public static String EXTRA_AG_FEATURE_ACCEPT_HELD_OR_WAITING_CALL = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_ACCEPT_HELD_OR_WAITING_CALL";
    public static String EXTRA_AG_FEATURE_RELEASE_HELD_OR_WAITING_CALL = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_RELEASE_HELD_OR_WAITING_CALL";
    public static String EXTRA_AG_FEATURE_RELEASE_AND_ACCEPT = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_RELEASE_AND_ACCEPT";
    public static String EXTRA_AG_FEATURE_MERGE = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_MERGE";
    public static String EXTRA_AG_FEATURE_MERGE_AND_DETACH = "android.bluetooth.headsetclient.extra.EXTRA_AG_FEATURE_MERGE_AND_DETACH";
    public static int ACTION_RESULT_OK = 0;
    public static int ACTION_RESULT_ERROR = 1;
    public static int ACTION_RESULT_ERROR_NO_CARRIER = 2;
    public static int ACTION_RESULT_ERROR_BUSY = 3;
    public static int ACTION_RESULT_ERROR_NO_ANSWER = 4;
    public static int ACTION_RESULT_ERROR_DELAYED = 5;
    public static int ACTION_RESULT_ERROR_BLACKLISTED = 6;
    public static int ACTION_RESULT_ERROR_CME = 7;
    public static int CME_PHONE_FAILURE = 0;
    public static int CME_NO_CONNECTION_TO_PHONE = 1;
    public static int CME_OPERATION_NOT_ALLOWED = 3;
    public static int CME_OPERATION_NOT_SUPPORTED = 4;
    public static int CME_PHSIM_PIN_REQUIRED = 5;
    public static int CME_PHFSIM_PIN_REQUIRED = 6;
    public static int CME_PHFSIM_PUK_REQUIRED = 7;
    public static int CME_SIM_NOT_INSERTED = 10;
    public static int CME_SIM_PIN_REQUIRED = 11;
    public static int CME_SIM_PUK_REQUIRED = 12;
    public static int CME_SIM_FAILURE = 13;
    public static int CME_SIM_BUSY = 14;
    public static int CME_SIM_WRONG = 15;
    public static int CME_INCORRECT_PASSWORD = 16;
    public static int CME_SIM_PIN2_REQUIRED = 17;
    public static int CME_SIM_PUK2_REQUIRED = 18;
    public static int CME_MEMORY_FULL = 20;
    public static int CME_INVALID_INDEX = 21;
    public static int CME_NOT_FOUND = 22;
    public static int CME_MEMORY_FAILURE = 23;
    public static int CME_TEXT_STRING_TOO_LONG = 24;
    public static int CME_INVALID_CHARACTER_IN_TEXT_STRING = 25;
    public static int CME_DIAL_STRING_TOO_LONG = 26;
    public static int CME_INVALID_CHARACTER_IN_DIAL_STRING = 27;
    public static int CME_NO_NETWORK_SERVICE = 30;
    public static int CME_NETWORK_TIMEOUT = 31;
    public static int CME_EMERGENCY_SERVICE_ONLY = 32;
    public static int CME_NO_SIMULTANOUS_VOIP_CS_CALLS = 33;
    public static int CME_NOT_SUPPORTED_FOR_VOIP = 34;
    public static int CME_SIP_RESPONSE_CODE = 35;
    public static int CME_NETWORK_PERSONALIZATION_PIN_REQUIRED = 40;
    public static int CME_NETWORK_PERSONALIZATION_PUK_REQUIRED = 41;
    public static int CME_NETWORK_SUBSET_PERSONALIZATION_PIN_REQUIRED = 42;
    public static int CME_NETWORK_SUBSET_PERSONALIZATION_PUK_REQUIRED = 43;
    public static int CME_SERVICE_PROVIDER_PERSONALIZATION_PIN_REQUIRED = 44;
    public static int CME_SERVICE_PROVIDER_PERSONALIZATION_PUK_REQUIRED = 45;
    public static int CME_CORPORATE_PERSONALIZATION_PIN_REQUIRED = 46;
    public static int CME_CORPORATE_PERSONALIZATION_PUK_REQUIRED = 47;
    public static int CME_HIDDEN_KEY_REQUIRED = 48;
    public static int CME_EAP_NOT_SUPPORTED = 49;
    public static int CME_INCORRECT_PARAMETERS = 50;
    public static int CALL_ACCEPT_NONE = 0;
    public static int CALL_ACCEPT_HOLD = 1;
    public static int CALL_ACCEPT_TERMINATE = 2;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private IBluetoothHeadsetClient mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothHeadsetClient$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadsetClient this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadsetClient_1$__constructor__(BluetoothHeadsetClient bluetoothHeadsetClient) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHeadsetClient_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothHeadsetClient", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothHeadsetClient", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            Intent intent = new Intent(IBluetoothHeadsetClient.class.getName());
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothHeadsetClient", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothHeadsetClient bluetoothHeadsetClient) {
                this.$$robo$$android_bluetooth_BluetoothHeadsetClient_1$__constructor__(bluetoothHeadsetClient);
            }
            {
                this.this$0 = bluetoothHeadsetClient;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadsetClient_1$__constructor__(android.bluetooth.BluetoothHeadsetClient ), 0, this, bluetoothHeadsetClient);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHeadsetClient_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadsetClient this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadsetClient_2$__constructor__(BluetoothHeadsetClient bluetoothHeadsetClient) {
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadsetClient_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothHeadsetClient", "Proxy object connected");
                this.this$0.mService = IBluetoothHeadsetClient.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(16, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadsetClient_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothHeadsetClient", "Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(16);
                }
            }

            private void __constructor__(BluetoothHeadsetClient bluetoothHeadsetClient) {
                this.$$robo$$android_bluetooth_BluetoothHeadsetClient_2$__constructor__(bluetoothHeadsetClient);
            }
            {
                this.this$0 = bluetoothHeadsetClient;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadsetClient_2$__constructor__(android.bluetooth.BluetoothHeadsetClient ), 0, this, bluetoothHeadsetClient);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHeadsetClient_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHeadsetClient_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$doBind() {
        Intent intent = new Intent(IBluetoothHeadsetClient.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothHeadsetClient", "Could not bind to Bluetooth Headset Client Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothHeadsetClient$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothHeadsetClient", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothHeadsetClient", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$connect(BluetoothDevice device) {
        BluetoothHeadsetClient.log("connect(" + device + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$disconnect(BluetoothDevice device) {
        BluetoothHeadsetClient.log("disconnect(" + device + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHeadsetClient$getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHeadsetClient$getDevicesMatchingConnectionStates(int[] states) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadsetClient$getConnectionState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$setPriority(BluetoothDevice device, int priority) {
        BluetoothHeadsetClient.log("setPriority(" + device + ", " + priority + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadsetClient$getPriority(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$startVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadsetClient.log("startVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.startVoiceRecognition(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$stopVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadsetClient.log("stopVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.stopVoiceRecognition(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothHeadsetClientCall> $$robo$$android_bluetooth_BluetoothHeadsetClient$getCurrentCalls(BluetoothDevice device) {
        BluetoothHeadsetClient.log("getCurrentCalls()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getCurrentCalls(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return null;
    }

    private final Bundle $$robo$$android_bluetooth_BluetoothHeadsetClient$getCurrentAgEvents(BluetoothDevice device) {
        BluetoothHeadsetClient.log("getCurrentCalls()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getCurrentAgEvents(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$acceptCall(BluetoothDevice device, int flag) {
        BluetoothHeadsetClient.log("acceptCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.acceptCall(device, flag);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$holdCall(BluetoothDevice device) {
        BluetoothHeadsetClient.log("holdCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.holdCall(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$rejectCall(BluetoothDevice device) {
        BluetoothHeadsetClient.log("rejectCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.rejectCall(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$terminateCall(BluetoothDevice device, int index) {
        BluetoothHeadsetClient.log("terminateCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.terminateCall(device, index);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$enterPrivateMode(BluetoothDevice device, int index) {
        BluetoothHeadsetClient.log("enterPrivateMode()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.enterPrivateMode(device, index);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$explicitCallTransfer(BluetoothDevice device) {
        BluetoothHeadsetClient.log("explicitCallTransfer()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.explicitCallTransfer(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$redial(BluetoothDevice device) {
        BluetoothHeadsetClient.log("redial()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.redial(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$dial(BluetoothDevice device, String number) {
        BluetoothHeadsetClient.log("dial()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.dial(device, number);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$dialMemory(BluetoothDevice device, int location) {
        BluetoothHeadsetClient.log("dialMemory()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.dialMemory(device, location);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$sendDTMF(BluetoothDevice device, byte code) {
        BluetoothHeadsetClient.log("sendDTMF()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.sendDTMF(device, code);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$getLastVoiceTagNumber(BluetoothDevice device) {
        BluetoothHeadsetClient.log("getLastVoiceTagNumber()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getLastVoiceTagNumber(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$acceptIncomingConnect(BluetoothDevice device) {
        BluetoothHeadsetClient.log("acceptIncomingConnect");
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.acceptIncomingConnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", e.toString());
            }
        } else {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
            Log.d("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$rejectIncomingConnect(BluetoothDevice device) {
        BluetoothHeadsetClient.log("rejectIncomingConnect");
        if (this.mService != null) {
            try {
                return this.mService.rejectIncomingConnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", e.toString());
            }
        } else {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
            Log.d("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadsetClient$getAudioState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getAudioState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", e.toString());
            }
        } else {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
            Log.d("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$connectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.connectAudio();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", e.toString());
            }
        } else {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
            Log.d("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$disconnectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.disconnectAudio();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", e.toString());
            }
        } else {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
            Log.d("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final Bundle $$robo$$android_bluetooth_BluetoothHeadsetClient$getCurrentAgFeatures(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getCurrentAgFeatures(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadsetClient", e.toString());
            }
        } else {
            Log.w("BluetoothHeadsetClient", "Proxy not attached to service");
            Log.d("BluetoothHeadsetClient", Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadsetClient$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothHeadsetClient$log(String msg) {
        Log.d("BluetoothHeadsetClient", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHeadsetClient$__constructor__(context, serviceListener);
    }

    BluetoothHeadsetClient(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadsetClient$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHeadsetClient$doBind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHeadsetClient$close(), 0, this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothHeadsetClient$connect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothHeadsetClient$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHeadsetClient$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHeadsetClient$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHeadsetClient$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothHeadsetClient$setPriority(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothHeadsetClient$getPriority(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean startVoiceRecognition(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("startVoiceRecognition", $$robo$$android_bluetooth_BluetoothHeadsetClient$startVoiceRecognition(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean stopVoiceRecognition(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopVoiceRecognition", $$robo$$android_bluetooth_BluetoothHeadsetClient$stopVoiceRecognition(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public List<BluetoothHeadsetClientCall> getCurrentCalls(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getCurrentCalls", $$robo$$android_bluetooth_BluetoothHeadsetClient$getCurrentCalls(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public Bundle getCurrentAgEvents(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getCurrentAgEvents", $$robo$$android_bluetooth_BluetoothHeadsetClient$getCurrentAgEvents(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean acceptCall(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$android_bluetooth_BluetoothHeadsetClient$acceptCall(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public boolean holdCall(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("holdCall", $$robo$$android_bluetooth_BluetoothHeadsetClient$holdCall(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean rejectCall(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$android_bluetooth_BluetoothHeadsetClient$rejectCall(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean terminateCall(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("terminateCall", $$robo$$android_bluetooth_BluetoothHeadsetClient$terminateCall(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public boolean enterPrivateMode(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("enterPrivateMode", $$robo$$android_bluetooth_BluetoothHeadsetClient$enterPrivateMode(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public boolean explicitCallTransfer(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$android_bluetooth_BluetoothHeadsetClient$explicitCallTransfer(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean redial(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("redial", $$robo$$android_bluetooth_BluetoothHeadsetClient$redial(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean dial(BluetoothDevice bluetoothDevice, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("dial", $$robo$$android_bluetooth_BluetoothHeadsetClient$dial(android.bluetooth.BluetoothDevice java.lang.String ), 0, this, bluetoothDevice, string2);
    }

    public boolean dialMemory(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("dialMemory", $$robo$$android_bluetooth_BluetoothHeadsetClient$dialMemory(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public boolean sendDTMF(BluetoothDevice bluetoothDevice, byte by) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendDTMF", $$robo$$android_bluetooth_BluetoothHeadsetClient$sendDTMF(android.bluetooth.BluetoothDevice byte ), 0, this, bluetoothDevice, by);
    }

    public boolean getLastVoiceTagNumber(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLastVoiceTagNumber", $$robo$$android_bluetooth_BluetoothHeadsetClient$getLastVoiceTagNumber(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean acceptIncomingConnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptIncomingConnect", $$robo$$android_bluetooth_BluetoothHeadsetClient$acceptIncomingConnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean rejectIncomingConnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("rejectIncomingConnect", $$robo$$android_bluetooth_BluetoothHeadsetClient$rejectIncomingConnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public int getAudioState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_bluetooth_BluetoothHeadsetClient$getAudioState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean connectAudio() {
        return (boolean)InvokeDynamicSupport.bootstrap("connectAudio", $$robo$$android_bluetooth_BluetoothHeadsetClient$connectAudio(), 0, this);
    }

    public boolean disconnectAudio() {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnectAudio", $$robo$$android_bluetooth_BluetoothHeadsetClient$disconnectAudio(), 0, this);
    }

    public Bundle getCurrentAgFeatures(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getCurrentAgFeatures", $$robo$$android_bluetooth_BluetoothHeadsetClient$getCurrentAgFeatures(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothHeadsetClient$isEnabled(), 0, this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothHeadsetClient$isValidDevice(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothHeadsetClient$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothHeadsetClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHeadsetClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

