/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGattCallback;
import android.bluetooth.IBluetoothGattServerCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IBluetoothGatt
extends IInterface,
InstrumentedInterface {
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1) throws RemoteException;

    public void startScan(int var1, boolean var2, ScanSettings var3, List<ScanFilter> var4, List var5) throws RemoteException;

    public void stopScan(int var1, boolean var2) throws RemoteException;

    public void flushPendingBatchResults(int var1, boolean var2) throws RemoteException;

    public void startMultiAdvertising(int var1, AdvertiseData var2, AdvertiseData var3, AdvertiseSettings var4) throws RemoteException;

    public void stopMultiAdvertising(int var1) throws RemoteException;

    public void registerClient(ParcelUuid var1, IBluetoothGattCallback var2) throws RemoteException;

    public void unregisterClient(int var1) throws RemoteException;

    public void clientConnect(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public void clientDisconnect(int var1, String var2) throws RemoteException;

    public void refreshDevice(int var1, String var2) throws RemoteException;

    public void discoverServices(int var1, String var2) throws RemoteException;

    public void readCharacteristic(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8) throws RemoteException;

    public void writeCharacteristic(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, int var9, byte[] var10) throws RemoteException;

    public void readDescriptor(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, ParcelUuid var9, int var10) throws RemoteException;

    public void writeDescriptor(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, ParcelUuid var9, int var10, int var11, byte[] var12) throws RemoteException;

    public void registerForNotification(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, boolean var8) throws RemoteException;

    public void beginReliableWrite(int var1, String var2) throws RemoteException;

    public void endReliableWrite(int var1, String var2, boolean var3) throws RemoteException;

    public void readRemoteRssi(int var1, String var2) throws RemoteException;

    public void configureMTU(int var1, String var2, int var3) throws RemoteException;

    public void connectionParameterUpdate(int var1, String var2, int var3) throws RemoteException;

    public void registerServer(ParcelUuid var1, IBluetoothGattServerCallback var2) throws RemoteException;

    public void unregisterServer(int var1) throws RemoteException;

    public void serverConnect(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public void serverDisconnect(int var1, String var2) throws RemoteException;

    public void beginServiceDeclaration(int var1, int var2, int var3, int var4, ParcelUuid var5, boolean var6) throws RemoteException;

    public void addIncludedService(int var1, int var2, int var3, ParcelUuid var4) throws RemoteException;

    public void addCharacteristic(int var1, ParcelUuid var2, int var3, int var4) throws RemoteException;

    public void addDescriptor(int var1, ParcelUuid var2, int var3) throws RemoteException;

    public void endServiceDeclaration(int var1) throws RemoteException;

    public void removeService(int var1, int var2, int var3, ParcelUuid var4) throws RemoteException;

    public void clearServices(int var1) throws RemoteException;

    public void sendResponse(int var1, String var2, int var3, int var4, int var5, byte[] var6) throws RemoteException;

    public void sendNotification(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, boolean var8, byte[] var9) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGatt,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.bluetooth.IBluetoothGatt";
        static int TRANSACTION_getDevicesMatchingConnectionStates = 1;
        static int TRANSACTION_startScan = 2;
        static int TRANSACTION_stopScan = 3;
        static int TRANSACTION_flushPendingBatchResults = 4;
        static int TRANSACTION_startMultiAdvertising = 5;
        static int TRANSACTION_stopMultiAdvertising = 6;
        static int TRANSACTION_registerClient = 7;
        static int TRANSACTION_unregisterClient = 8;
        static int TRANSACTION_clientConnect = 9;
        static int TRANSACTION_clientDisconnect = 10;
        static int TRANSACTION_refreshDevice = 11;
        static int TRANSACTION_discoverServices = 12;
        static int TRANSACTION_readCharacteristic = 13;
        static int TRANSACTION_writeCharacteristic = 14;
        static int TRANSACTION_readDescriptor = 15;
        static int TRANSACTION_writeDescriptor = 16;
        static int TRANSACTION_registerForNotification = 17;
        static int TRANSACTION_beginReliableWrite = 18;
        static int TRANSACTION_endReliableWrite = 19;
        static int TRANSACTION_readRemoteRssi = 20;
        static int TRANSACTION_configureMTU = 21;
        static int TRANSACTION_connectionParameterUpdate = 22;
        static int TRANSACTION_registerServer = 23;
        static int TRANSACTION_unregisterServer = 24;
        static int TRANSACTION_serverConnect = 25;
        static int TRANSACTION_serverDisconnect = 26;
        static int TRANSACTION_beginServiceDeclaration = 27;
        static int TRANSACTION_addIncludedService = 28;
        static int TRANSACTION_addCharacteristic = 29;
        static int TRANSACTION_addDescriptor = 30;
        static int TRANSACTION_endServiceDeclaration = 31;
        static int TRANSACTION_removeService = 32;
        static int TRANSACTION_clearServices = 33;
        static int TRANSACTION_sendResponse = 34;
        static int TRANSACTION_sendNotification = 35;

        private void $$robo$$android_bluetooth_IBluetoothGatt_Stub$__constructor__() {
            this.attachInterface(this, "android.bluetooth.IBluetoothGatt");
        }

        private static final IBluetoothGatt $$robo$$android_bluetooth_IBluetoothGatt_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.bluetooth.IBluetoothGatt");
            if (iin != null && iin instanceof IBluetoothGatt) {
                return (IBluetoothGatt)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_bluetooth_IBluetoothGatt_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_bluetooth_IBluetoothGatt_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("android.bluetooth.IBluetoothGatt");
                    return true;
                }
                case 1: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int[] _arg0 = data.createIntArray();
                    List _result = this.getDevicesMatchingConnectionStates(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    ScanSettings _arg2 = 0 != data.readInt() ? ScanSettings.CREATOR.createFromParcel(data) : null;
                    ArrayList<ScanFilter> _arg3 = data.createTypedArrayList(ScanFilter.CREATOR);
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList _arg4 = data.readArrayList(cl);
                    this.startScan(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.stopScan(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.flushPendingBatchResults(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg2 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AdvertiseSettings _arg3 = 0 != data.readInt() ? AdvertiseSettings.CREATOR.createFromParcel(data) : null;
                    this.startMultiAdvertising(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    this.stopMultiAdvertising(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothGattCallback _arg1 = IBluetoothGattCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerClient(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    this.clientConnect(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.clientDisconnect(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.refreshDevice(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.discoverServices(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    ParcelUuid _arg6 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg7 = data.readInt();
                    this.readCharacteristic(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    ParcelUuid _arg6 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg7 = data.readInt();
                    int _arg8 = data.readInt();
                    byte[] _arg9 = data.createByteArray();
                    this.writeCharacteristic(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    ParcelUuid _arg6 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg7 = data.readInt();
                    ParcelUuid _arg8 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg9 = data.readInt();
                    this.readDescriptor(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    ParcelUuid _arg6 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg7 = data.readInt();
                    ParcelUuid _arg8 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg9 = data.readInt();
                    int _arg10 = data.readInt();
                    byte[] _arg11 = data.createByteArray();
                    this.writeDescriptor(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10, _arg11);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    ParcelUuid _arg6 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    boolean _arg7 = 0 != data.readInt();
                    this.registerForNotification(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.beginReliableWrite(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    this.endReliableWrite(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.readRemoteRssi(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.configureMTU(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.connectionParameterUpdate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothGattServerCallback _arg1 = IBluetoothGattServerCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerServer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    this.unregisterServer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    this.serverConnect(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.serverDisconnect(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    boolean _arg5 = 0 != data.readInt();
                    this.beginServiceDeclaration(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParcelUuid _arg3 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    this.addIncludedService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.addCharacteristic(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.addDescriptor(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    this.endServiceDeclaration(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParcelUuid _arg3 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    this.removeService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    this.clearServices(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    this.sendResponse(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface("android.bluetooth.IBluetoothGatt");
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ParcelUuid _arg4 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    ParcelUuid _arg6 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    boolean _arg7 = 0 != data.readInt();
                    byte[] _arg8 = data.createByteArray();
                    this.sendNotification(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_bluetooth_IBluetoothGatt_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_IBluetoothGatt_Stub$__constructor__(), 0, this);
        }

        public static IBluetoothGatt asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_bluetooth_IBluetoothGatt_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_bluetooth_IBluetoothGatt_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_bluetooth_IBluetoothGatt_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IBluetoothGatt,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getInterfaceDescriptor() {
                return "android.bluetooth.IBluetoothGatt";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<BluetoothDevice> $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getDevicesMatchingConnectionStates(int[] states) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeIntArray(states);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startScan(int appIf, boolean isServer, ScanSettings settings, List<ScanFilter> filters, List scanStorages) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(appIf);
                    _data.writeInt(isServer ? 1 : 0);
                    if (settings != null) {
                        _data.writeInt(1);
                        settings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(filters);
                    _data.writeList(scanStorages);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopScan(int appIf, boolean isServer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(appIf);
                    _data.writeInt(isServer ? 1 : 0);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$flushPendingBatchResults(int appIf, boolean isServer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(appIf);
                    _data.writeInt(isServer ? 1 : 0);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startMultiAdvertising(int appIf, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseSettings settings) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(appIf);
                    if (advertiseData != null) {
                        _data.writeInt(1);
                        advertiseData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (scanResponse != null) {
                        _data.writeInt(1);
                        scanResponse.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (settings != null) {
                        _data.writeInt(1);
                        settings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopMultiAdvertising(int appIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(appIf);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerClient(ParcelUuid appId, IBluetoothGattCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (appId != null) {
                        _data.writeInt(1);
                        appId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterClient(int clientIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientConnect(int clientIf, String address, boolean isDirect, int transport) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(isDirect ? 1 : 0);
                    _data.writeInt(transport);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientDisconnect(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$refreshDevice(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$discoverServices(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readCharacteristic(int clientIf, String address, int srvcType, int srvcInstanceId, ParcelUuid srvcId, int charInstanceId, ParcelUuid charId, int authReq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(charInstanceId);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(authReq);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeCharacteristic(int clientIf, String address, int srvcType, int srvcInstanceId, ParcelUuid srvcId, int charInstanceId, ParcelUuid charId, int writeType, int authReq, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(charInstanceId);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(writeType);
                    _data.writeInt(authReq);
                    _data.writeByteArray(value);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readDescriptor(int clientIf, String address, int srvcType, int srvcInstanceId, ParcelUuid srvcId, int charInstanceId, ParcelUuid charId, int descrInstanceId, ParcelUuid descrUuid, int authReq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(charInstanceId);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(descrInstanceId);
                    if (descrUuid != null) {
                        _data.writeInt(1);
                        descrUuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(authReq);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeDescriptor(int clientIf, String address, int srvcType, int srvcInstanceId, ParcelUuid srvcId, int charInstanceId, ParcelUuid charId, int descrInstanceId, ParcelUuid descrId, int writeType, int authReq, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(charInstanceId);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(descrInstanceId);
                    if (descrId != null) {
                        _data.writeInt(1);
                        descrId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(writeType);
                    _data.writeInt(authReq);
                    _data.writeByteArray(value);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerForNotification(int clientIf, String address, int srvcType, int srvcInstanceId, ParcelUuid srvcId, int charInstanceId, ParcelUuid charId, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(charInstanceId);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$beginReliableWrite(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$endReliableWrite(int clientIf, String address, boolean execute) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(execute ? 1 : 0);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readRemoteRssi(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$configureMTU(int clientIf, String address, int mtu) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(mtu);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$connectionParameterUpdate(int clientIf, String address, int connectionPriority) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(connectionPriority);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerServer(ParcelUuid appId, IBluetoothGattServerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (appId != null) {
                        _data.writeInt(1);
                        appId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterServer(int serverIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverConnect(int servertIf, String address, boolean isDirect, int transport) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(servertIf);
                    _data.writeString(address);
                    _data.writeInt(isDirect ? 1 : 0);
                    _data.writeInt(transport);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverDisconnect(int serverIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$beginServiceDeclaration(int serverIf, int srvcType, int srvcInstanceId, int minHandles, ParcelUuid srvcId, boolean advertisePreferred) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    _data.writeInt(minHandles);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(advertisePreferred ? 1 : 0);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addIncludedService(int serverIf, int srvcType, int srvcInstanceId, ParcelUuid srvcId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addCharacteristic(int serverIf, ParcelUuid charId, int properties, int permissions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(properties);
                    _data.writeInt(permissions);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addDescriptor(int serverIf, ParcelUuid descId, int permissions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    if (descId != null) {
                        _data.writeInt(1);
                        descId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(permissions);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$endServiceDeclaration(int serverIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$removeService(int serverIf, int srvcType, int srvcInstanceId, ParcelUuid srvcId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clearServices(int serverIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendResponse(int serverIf, String address, int requestId, int status, int offset, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(requestId);
                    _data.writeInt(status);
                    _data.writeInt(offset);
                    _data.writeByteArray(value);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendNotification(int serverIf, String address, int srvcType, int srvcInstanceId, ParcelUuid srvcId, int charInstanceId, ParcelUuid charId, boolean confirm, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(srvcType);
                    _data.writeInt(srvcInstanceId);
                    if (srvcId != null) {
                        _data.writeInt(1);
                        srvcId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(charInstanceId);
                    if (charId != null) {
                        _data.writeInt(1);
                        charId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(confirm ? 1 : 0);
                    _data.writeByteArray(value);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
            }

            @Override
            public void startScan(int n, boolean bl, ScanSettings scanSettings, List<ScanFilter> list, List list2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startScan(int boolean android.bluetooth.le.ScanSettings java.util.List<android.bluetooth.le.ScanFilter> java.util.List ), 0, this, n, bl, scanSettings, list, list2);
            }

            @Override
            public void stopScan(int n, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopScan", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopScan(int boolean ), 0, this, n, bl);
            }

            @Override
            public void flushPendingBatchResults(int n, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("flushPendingBatchResults", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$flushPendingBatchResults(int boolean ), 0, this, n, bl);
            }

            @Override
            public void startMultiAdvertising(int n, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startMultiAdvertising", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startMultiAdvertising(int android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseSettings ), 0, this, n, advertiseData, advertiseData2, advertiseSettings);
            }

            @Override
            public void stopMultiAdvertising(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopMultiAdvertising", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopMultiAdvertising(int ), 0, this, n);
            }

            @Override
            public void registerClient(ParcelUuid parcelUuid, IBluetoothGattCallback iBluetoothGattCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerClient", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerClient(android.os.ParcelUuid android.bluetooth.IBluetoothGattCallback ), 0, this, parcelUuid, iBluetoothGattCallback);
            }

            @Override
            public void unregisterClient(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterClient", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterClient(int ), 0, this, n);
            }

            @Override
            public void clientConnect(int n, String string2, boolean bl, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clientConnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientConnect(int java.lang.String boolean int ), 0, this, n, string2, bl, n2);
            }

            @Override
            public void clientDisconnect(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clientDisconnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientDisconnect(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void refreshDevice(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("refreshDevice", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$refreshDevice(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void discoverServices(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("discoverServices", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$discoverServices(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void readCharacteristic(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readCharacteristic", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readCharacteristic(int java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid int ), 0, this, n, string2, n2, n3, parcelUuid, n4, parcelUuid2, n5);
            }

            @Override
            public void writeCharacteristic(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, int n6, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("writeCharacteristic", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeCharacteristic(int java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid int int byte[] ), 0, this, n, string2, n2, n3, parcelUuid, n4, parcelUuid2, n5, n6, byArray);
            }

            @Override
            public void readDescriptor(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, int n6) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readDescriptor(int java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid int android.os.ParcelUuid int ), 0, this, n, string2, n2, n3, parcelUuid, n4, parcelUuid2, n5, parcelUuid3, n6);
            }

            @Override
            public void writeDescriptor(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, int n6, int n7, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("writeDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeDescriptor(int java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid int android.os.ParcelUuid int int byte[] ), 0, this, n, string2, n2, n3, parcelUuid, n4, parcelUuid2, n5, parcelUuid3, n6, n7, byArray);
            }

            @Override
            public void registerForNotification(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerForNotification", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerForNotification(int java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid boolean ), 0, this, n, string2, n2, n3, parcelUuid, n4, parcelUuid2, bl);
            }

            @Override
            public void beginReliableWrite(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("beginReliableWrite", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$beginReliableWrite(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void endReliableWrite(int n, String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("endReliableWrite", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$endReliableWrite(int java.lang.String boolean ), 0, this, n, string2, bl);
            }

            @Override
            public void readRemoteRssi(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readRemoteRssi", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readRemoteRssi(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void configureMTU(int n, String string2, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("configureMTU", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$configureMTU(int java.lang.String int ), 0, this, n, string2, n2);
            }

            @Override
            public void connectionParameterUpdate(int n, String string2, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("connectionParameterUpdate", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$connectionParameterUpdate(int java.lang.String int ), 0, this, n, string2, n2);
            }

            @Override
            public void registerServer(ParcelUuid parcelUuid, IBluetoothGattServerCallback iBluetoothGattServerCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerServer", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerServer(android.os.ParcelUuid android.bluetooth.IBluetoothGattServerCallback ), 0, this, parcelUuid, iBluetoothGattServerCallback);
            }

            @Override
            public void unregisterServer(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterServer", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterServer(int ), 0, this, n);
            }

            @Override
            public void serverConnect(int n, String string2, boolean bl, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("serverConnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverConnect(int java.lang.String boolean int ), 0, this, n, string2, bl, n2);
            }

            @Override
            public void serverDisconnect(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("serverDisconnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverDisconnect(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void beginServiceDeclaration(int n, int n2, int n3, int n4, ParcelUuid parcelUuid, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("beginServiceDeclaration", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$beginServiceDeclaration(int int int int android.os.ParcelUuid boolean ), 0, this, n, n2, n3, n4, parcelUuid, bl);
            }

            @Override
            public void addIncludedService(int n, int n2, int n3, ParcelUuid parcelUuid) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addIncludedService", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addIncludedService(int int int android.os.ParcelUuid ), 0, this, n, n2, n3, parcelUuid);
            }

            @Override
            public void addCharacteristic(int n, ParcelUuid parcelUuid, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addCharacteristic", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addCharacteristic(int android.os.ParcelUuid int int ), 0, this, n, parcelUuid, n2, n3);
            }

            @Override
            public void addDescriptor(int n, ParcelUuid parcelUuid, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addDescriptor(int android.os.ParcelUuid int ), 0, this, n, parcelUuid, n2);
            }

            @Override
            public void endServiceDeclaration(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("endServiceDeclaration", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$endServiceDeclaration(int ), 0, this, n);
            }

            @Override
            public void removeService(int n, int n2, int n3, ParcelUuid parcelUuid) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeService", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$removeService(int int int android.os.ParcelUuid ), 0, this, n, n2, n3, parcelUuid);
            }

            @Override
            public void clearServices(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearServices", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clearServices(int ), 0, this, n);
            }

            @Override
            public void sendResponse(int n, String string2, int n2, int n3, int n4, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("sendResponse", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendResponse(int java.lang.String int int int byte[] ), 0, this, n, string2, n2, n3, n4, byArray);
            }

            @Override
            public void sendNotification(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, boolean bl, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("sendNotification", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendNotification(int java.lang.String int int android.os.ParcelUuid int android.os.ParcelUuid boolean byte[] ), 0, this, n, string2, n2, n3, parcelUuid, n4, parcelUuid2, bl, byArray);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

