/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.util.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ClipData
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String[] MIMETYPES_TEXT_PLAIN;
    static String[] MIMETYPES_TEXT_HTML;
    static String[] MIMETYPES_TEXT_URILIST;
    static String[] MIMETYPES_TEXT_INTENT;
    ClipDescription mClipDescription;
    Bitmap mIcon;
    ArrayList<Item> mItems;
    public static Parcelable.Creator<ClipData> CREATOR;

    private void $$robo$$android_content_ClipData$__constructor__(CharSequence label, String[] mimeTypes, Item item) {
        this.mClipDescription = new ClipDescription(label, mimeTypes);
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
    }

    private void $$robo$$android_content_ClipData$__constructor__(ClipDescription description, Item item) {
        this.mClipDescription = description;
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
    }

    private void $$robo$$android_content_ClipData$__constructor__(ClipData other) {
        this.mClipDescription = other.mClipDescription;
        this.mIcon = other.mIcon;
        this.mItems = new ArrayList<Item>(other.mItems);
    }

    private static final ClipData $$robo$$android_content_ClipData$newPlainText(CharSequence label, CharSequence text) {
        Item item = new Item(text);
        return new ClipData(label, MIMETYPES_TEXT_PLAIN, item);
    }

    private static final ClipData $$robo$$android_content_ClipData$newHtmlText(CharSequence label, CharSequence text, String htmlText) {
        Item item = new Item(text, htmlText);
        return new ClipData(label, MIMETYPES_TEXT_HTML, item);
    }

    private static final ClipData $$robo$$android_content_ClipData$newIntent(CharSequence label, Intent intent) {
        Item item = new Item(intent);
        return new ClipData(label, MIMETYPES_TEXT_INTENT, item);
    }

    private static final ClipData $$robo$$android_content_ClipData$newUri(ContentResolver resolver, CharSequence label, Uri uri) {
        Item item = new Item(uri);
        String[] mimeTypes = null;
        if ("content".equals(uri.getScheme())) {
            String realType = resolver.getType(uri);
            mimeTypes = resolver.getStreamTypes(uri, "*/*");
            if (mimeTypes == null) {
                if (realType != null) {
                    mimeTypes = new String[]{realType, "text/uri-list"};
                }
            } else {
                String[] tmp = new String[mimeTypes.length + (realType != null ? 2 : 1)];
                int i = 0;
                if (realType != null) {
                    tmp[0] = realType;
                    ++i;
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)mimeTypes, (int)0, (Object)tmp, (int)i, (int)mimeTypes.length);
                tmp[i + mimeTypes.length] = "text/uri-list";
                mimeTypes = tmp;
            }
        }
        if (mimeTypes == null) {
            mimeTypes = MIMETYPES_TEXT_URILIST;
        }
        return new ClipData(label, mimeTypes, item);
    }

    private static final ClipData $$robo$$android_content_ClipData$newRawUri(CharSequence label, Uri uri) {
        Item item = new Item(uri);
        return new ClipData(label, MIMETYPES_TEXT_URILIST, item);
    }

    private final ClipDescription $$robo$$android_content_ClipData$getDescription() {
        return this.mClipDescription;
    }

    private final void $$robo$$android_content_ClipData$addItem(Item item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mItems.add(item);
    }

    private final Bitmap $$robo$$android_content_ClipData$getIcon() {
        return this.mIcon;
    }

    private final int $$robo$$android_content_ClipData$getItemCount() {
        return this.mItems.size();
    }

    private final Item $$robo$$android_content_ClipData$getItemAt(int index) {
        return this.mItems.get(index);
    }

    private final void $$robo$$android_content_ClipData$prepareToLeaveProcess() {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.prepareToLeaveProcess();
            }
            if (item.mUri == null || !StrictMode.vmFileUriExposureEnabled()) continue;
            item.mUri.checkFileUriExposed("ClipData.Item.getUri()");
        }
    }

    private final void $$robo$$android_content_ClipData$fixUris(int contentUserHint) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.fixUris(contentUserHint);
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, contentUserHint);
        }
    }

    private final void $$robo$$android_content_ClipData$fixUrisLight(int contentUserHint) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Uri data;
            Item item = this.mItems.get(i);
            if (item.mIntent != null && (data = item.mIntent.getData()) != null) {
                item.mIntent.setData(ContentProvider.maybeAddUserId(data, contentUserHint));
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, contentUserHint);
        }
    }

    private final String $$robo$$android_content_ClipData$toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("ClipData { ");
        this.toShortString(b);
        b.append(" }");
        return b.toString();
    }

    private final void $$robo$$android_content_ClipData$toShortString(StringBuilder b) {
        boolean first = this.mClipDescription != null ? !this.mClipDescription.toShortString(b) : true;
        if (this.mIcon != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("I:");
            b.append(this.mIcon.getWidth());
            b.append('x');
            b.append(this.mIcon.getHeight());
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append('{');
            this.mItems.get(i).toShortString(b);
            b.append('}');
        }
    }

    private final int $$robo$$android_content_ClipData$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_ClipData$writeToParcel(Parcel dest, int flags) {
        this.mClipDescription.writeToParcel(dest, flags);
        if (this.mIcon != null) {
            dest.writeInt(1);
            this.mIcon.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        int N = this.mItems.size();
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            Item item = this.mItems.get(i);
            TextUtils.writeToParcel(item.mText, dest, flags);
            dest.writeString(item.mHtmlText);
            if (item.mIntent != null) {
                dest.writeInt(1);
                item.mIntent.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
            if (item.mUri != null) {
                dest.writeInt(1);
                item.mUri.writeToParcel(dest, flags);
                continue;
            }
            dest.writeInt(0);
        }
    }

    private void $$robo$$android_content_ClipData$__constructor__(Parcel in) {
        this.mClipDescription = new ClipDescription(in);
        this.mIcon = in.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(in) : null;
        this.mItems = new ArrayList();
        int N = in.readInt();
        for (int i = 0; i < N; ++i) {
            CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            String htmlText = in.readString();
            Intent intent = in.readInt() != 0 ? Intent.CREATOR.createFromParcel(in) : null;
            Uri uri = in.readInt() != 0 ? Uri.CREATOR.createFromParcel(in) : null;
            this.mItems.add(new Item(text, htmlText, intent, uri));
        }
    }

    static void __staticInitializer__() {
        MIMETYPES_TEXT_PLAIN = new String[]{"text/plain"};
        MIMETYPES_TEXT_HTML = new String[]{"text/html"};
        MIMETYPES_TEXT_URILIST = new String[]{"text/uri-list"};
        MIMETYPES_TEXT_INTENT = new String[]{"text/vnd.android.intent"};
        CREATOR = new Parcelable.Creator<ClipData>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_ClipData_1$__constructor__() {
            }

            private final ClipData $$robo$$android_content_ClipData_1$createFromParcel(Parcel source) {
                return new ClipData(source);
            }

            private final ClipData[] $$robo$$android_content_ClipData_1$newArray(int size) {
                return new ClipData[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_ClipData_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_1$__constructor__(), 0, this);
            }

            @Override
            public ClipData createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_ClipData_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ClipData[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_ClipData_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(CharSequence charSequence, String[] stringArray, Item item) {
        this.$$robo$$android_content_ClipData$__constructor__(charSequence, stringArray, item);
    }

    public ClipData(CharSequence charSequence, String[] stringArray, Item item) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData$__constructor__(java.lang.CharSequence java.lang.String[] android.content.ClipData$Item ), 0, this, charSequence, stringArray, item);
    }

    private void __constructor__(ClipDescription clipDescription, Item item) {
        this.$$robo$$android_content_ClipData$__constructor__(clipDescription, item);
    }

    public ClipData(ClipDescription clipDescription, Item item) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData$__constructor__(android.content.ClipDescription android.content.ClipData$Item ), 0, this, clipDescription, item);
    }

    private void __constructor__(ClipData clipData) {
        this.$$robo$$android_content_ClipData$__constructor__(clipData);
    }

    public ClipData(ClipData clipData) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData$__constructor__(android.content.ClipData ), 0, this, clipData);
    }

    public static ClipData newPlainText(CharSequence charSequence, CharSequence charSequence2) {
        return InvokeDynamicSupport.bootstrapStatic("newPlainText", $$robo$$android_content_ClipData$newPlainText(java.lang.CharSequence java.lang.CharSequence ), 0, (CharSequence)charSequence, (CharSequence)charSequence2);
    }

    public static ClipData newHtmlText(CharSequence charSequence, CharSequence charSequence2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("newHtmlText", $$robo$$android_content_ClipData$newHtmlText(java.lang.CharSequence java.lang.CharSequence java.lang.String ), 0, (CharSequence)charSequence, (CharSequence)charSequence2, (String)string2);
    }

    public static ClipData newIntent(CharSequence charSequence, Intent intent) {
        return InvokeDynamicSupport.bootstrapStatic("newIntent", $$robo$$android_content_ClipData$newIntent(java.lang.CharSequence android.content.Intent ), 0, (CharSequence)charSequence, (Intent)intent);
    }

    public static ClipData newUri(ContentResolver contentResolver, CharSequence charSequence, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("newUri", $$robo$$android_content_ClipData$newUri(android.content.ContentResolver java.lang.CharSequence android.net.Uri ), 0, (ContentResolver)contentResolver, (CharSequence)charSequence, (Uri)uri);
    }

    public static ClipData newRawUri(CharSequence charSequence, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("newRawUri", $$robo$$android_content_ClipData$newRawUri(java.lang.CharSequence android.net.Uri ), 0, (CharSequence)charSequence, (Uri)uri);
    }

    public ClipDescription getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_content_ClipData$getDescription(), 0, this);
    }

    public void addItem(Item item) {
        InvokeDynamicSupport.bootstrap("addItem", $$robo$$android_content_ClipData$addItem(android.content.ClipData$Item ), 0, this, item);
    }

    public Bitmap getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_content_ClipData$getIcon(), 0, this);
    }

    public int getItemCount() {
        return (int)InvokeDynamicSupport.bootstrap("getItemCount", $$robo$$android_content_ClipData$getItemCount(), 0, this);
    }

    public Item getItemAt(int n) {
        return InvokeDynamicSupport.bootstrap("getItemAt", $$robo$$android_content_ClipData$getItemAt(int ), 0, this, n);
    }

    public void prepareToLeaveProcess() {
        InvokeDynamicSupport.bootstrap("prepareToLeaveProcess", $$robo$$android_content_ClipData$prepareToLeaveProcess(), 0, this);
    }

    public void fixUris(int n) {
        InvokeDynamicSupport.bootstrap("fixUris", $$robo$$android_content_ClipData$fixUris(int ), 0, this, n);
    }

    public void fixUrisLight(int n) {
        InvokeDynamicSupport.bootstrap("fixUrisLight", $$robo$$android_content_ClipData$fixUrisLight(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_ClipData$toString(), 0, this);
    }

    public void toShortString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_content_ClipData$toShortString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_ClipData$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_ClipData$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_ClipData$__constructor__(parcel);
    }

    ClipData(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    static {
        RobolectricInternals.classInitializing(ClipData.class);
    }

    public /* synthetic */ ClipData() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClipData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Item
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CharSequence mText;
        String mHtmlText;
        Intent mIntent;
        Uri mUri;

        private void $$robo$$android_content_ClipData_Item$__constructor__(CharSequence text) {
            this.mText = text;
            this.mHtmlText = null;
            this.mIntent = null;
            this.mUri = null;
        }

        private void $$robo$$android_content_ClipData_Item$__constructor__(CharSequence text, String htmlText) {
            this.mText = text;
            this.mHtmlText = htmlText;
            this.mIntent = null;
            this.mUri = null;
        }

        private void $$robo$$android_content_ClipData_Item$__constructor__(Intent intent) {
            this.mText = null;
            this.mHtmlText = null;
            this.mIntent = intent;
            this.mUri = null;
        }

        private void $$robo$$android_content_ClipData_Item$__constructor__(Uri uri) {
            this.mText = null;
            this.mHtmlText = null;
            this.mIntent = null;
            this.mUri = uri;
        }

        private void $$robo$$android_content_ClipData_Item$__constructor__(CharSequence text, Intent intent, Uri uri) {
            this.mText = text;
            this.mHtmlText = null;
            this.mIntent = intent;
            this.mUri = uri;
        }

        private void $$robo$$android_content_ClipData_Item$__constructor__(CharSequence text, String htmlText, Intent intent, Uri uri) {
            if (htmlText != null && text == null) {
                throw new IllegalArgumentException("Plain text must be supplied if HTML text is supplied");
            }
            this.mText = text;
            this.mHtmlText = htmlText;
            this.mIntent = intent;
            this.mUri = uri;
        }

        private final CharSequence $$robo$$android_content_ClipData_Item$getText() {
            return this.mText;
        }

        private final String $$robo$$android_content_ClipData_Item$getHtmlText() {
            return this.mHtmlText;
        }

        private final Intent $$robo$$android_content_ClipData_Item$getIntent() {
            return this.mIntent;
        }

        private final Uri $$robo$$android_content_ClipData_Item$getUri() {
            return this.mUri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final CharSequence $$robo$$android_content_ClipData_Item$coerceToText(Context context) {
            CharSequence text = this.getText();
            if (text != null) {
                return text;
            }
            Uri uri = this.getUri();
            if (uri != null) {
                FileInputStream stream = null;
                try {
                    int len;
                    AssetFileDescriptor descr = context.getContentResolver().openTypedAssetFileDescriptor(uri, "text/*", null);
                    stream = descr.createInputStream();
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
                    StringBuilder builder = new StringBuilder(128);
                    char[] buffer = new char[8192];
                    while ((len = reader.read(buffer)) > 0) {
                        builder.append(buffer, 0, len);
                    }
                    String string2 = builder.toString();
                    return string2;
                }
                catch (FileNotFoundException descr) {
                }
                catch (IOException e) {
                    Log.w("ClippedData", "Failure loading text", e);
                    String string3 = e.toString();
                    return string3;
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return uri.toString();
            }
            Intent intent = this.getIntent();
            if (intent != null) {
                return intent.toUri(1);
            }
            return "";
        }

        private final CharSequence $$robo$$android_content_ClipData_Item$coerceToStyledText(Context context) {
            CharSequence text = this.getText();
            if (text instanceof Spanned) {
                return text;
            }
            String htmlText = this.getHtmlText();
            if (htmlText != null) {
                try {
                    Spanned newText = Html.fromHtml(htmlText);
                    if (newText != null) {
                        return newText;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (text != null) {
                return text;
            }
            return this.coerceToHtmlOrStyledText(context, true);
        }

        private final String $$robo$$android_content_ClipData_Item$coerceToHtmlText(Context context) {
            String htmlText = this.getHtmlText();
            if (htmlText != null) {
                return htmlText;
            }
            CharSequence text = this.getText();
            if (text != null) {
                if (text instanceof Spanned) {
                    return Html.toHtml((Spanned)text);
                }
                return Html.escapeHtml(text);
            }
            text = this.coerceToHtmlOrStyledText(context, false);
            return text != null ? text.toString() : null;
        }

        /*
         * Exception decompiling
         */
        private final CharSequence $$robo$$android_content_ClipData_Item$coerceToHtmlOrStyledText(Context context, boolean styled) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 39[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final String $$robo$$android_content_ClipData_Item$uriToHtml(String uri) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("<a href=\"");
            builder.append(Html.escapeHtml(uri));
            builder.append("\">");
            builder.append(Html.escapeHtml(uri));
            builder.append("</a>");
            return builder.toString();
        }

        private final CharSequence $$robo$$android_content_ClipData_Item$uriToStyledText(String uri) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            builder.append(uri);
            builder.setSpan(new URLSpan(uri), 0, builder.length(), 33);
            return builder;
        }

        private final String $$robo$$android_content_ClipData_Item$toString() {
            StringBuilder b = new StringBuilder(128);
            b.append("ClipData.Item { ");
            this.toShortString(b);
            b.append(" }");
            return b.toString();
        }

        private final void $$robo$$android_content_ClipData_Item$toShortString(StringBuilder b) {
            if (this.mHtmlText != null) {
                b.append("H:");
                b.append(this.mHtmlText);
            } else if (this.mText != null) {
                b.append("T:");
                b.append(this.mText);
            } else if (this.mUri != null) {
                b.append("U:");
                b.append(this.mUri);
            } else if (this.mIntent != null) {
                b.append("I:");
                this.mIntent.toShortString(b, true, true, true, true);
            } else {
                b.append("NULL");
            }
        }

        private void __constructor__(CharSequence charSequence) {
            this.$$robo$$android_content_ClipData_Item$__constructor__(charSequence);
        }

        public Item(CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_Item$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
        }

        private void __constructor__(CharSequence charSequence, String string2) {
            this.$$robo$$android_content_ClipData_Item$__constructor__(charSequence, string2);
        }

        public Item(CharSequence charSequence, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_Item$__constructor__(java.lang.CharSequence java.lang.String ), 0, this, charSequence, string2);
        }

        private void __constructor__(Intent intent) {
            this.$$robo$$android_content_ClipData_Item$__constructor__(intent);
        }

        public Item(Intent intent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_Item$__constructor__(android.content.Intent ), 0, this, intent);
        }

        private void __constructor__(Uri uri) {
            this.$$robo$$android_content_ClipData_Item$__constructor__(uri);
        }

        public Item(Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_Item$__constructor__(android.net.Uri ), 0, this, uri);
        }

        private void __constructor__(CharSequence charSequence, Intent intent, Uri uri) {
            this.$$robo$$android_content_ClipData_Item$__constructor__(charSequence, intent, uri);
        }

        public Item(CharSequence charSequence, Intent intent, Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_Item$__constructor__(java.lang.CharSequence android.content.Intent android.net.Uri ), 0, this, charSequence, intent, uri);
        }

        private void __constructor__(CharSequence charSequence, String string2, Intent intent, Uri uri) {
            this.$$robo$$android_content_ClipData_Item$__constructor__(charSequence, string2, intent, uri);
        }

        public Item(CharSequence charSequence, String string2, Intent intent, Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipData_Item$__constructor__(java.lang.CharSequence java.lang.String android.content.Intent android.net.Uri ), 0, this, charSequence, string2, intent, uri);
        }

        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_ClipData_Item$getText(), 0, this);
        }

        public String getHtmlText() {
            return InvokeDynamicSupport.bootstrap("getHtmlText", $$robo$$android_content_ClipData_Item$getHtmlText(), 0, this);
        }

        public Intent getIntent() {
            return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_content_ClipData_Item$getIntent(), 0, this);
        }

        public Uri getUri() {
            return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_content_ClipData_Item$getUri(), 0, this);
        }

        public CharSequence coerceToText(Context context) {
            return InvokeDynamicSupport.bootstrap("coerceToText", $$robo$$android_content_ClipData_Item$coerceToText(android.content.Context ), 0, this, context);
        }

        public CharSequence coerceToStyledText(Context context) {
            return InvokeDynamicSupport.bootstrap("coerceToStyledText", $$robo$$android_content_ClipData_Item$coerceToStyledText(android.content.Context ), 0, this, context);
        }

        public String coerceToHtmlText(Context context) {
            return InvokeDynamicSupport.bootstrap("coerceToHtmlText", $$robo$$android_content_ClipData_Item$coerceToHtmlText(android.content.Context ), 0, this, context);
        }

        private CharSequence coerceToHtmlOrStyledText(Context context, boolean bl) {
            return InvokeDynamicSupport.bootstrap("coerceToHtmlOrStyledText", $$robo$$android_content_ClipData_Item$coerceToHtmlOrStyledText(android.content.Context boolean ), 0, this, context, bl);
        }

        private String uriToHtml(String string2) {
            return InvokeDynamicSupport.bootstrap("uriToHtml", $$robo$$android_content_ClipData_Item$uriToHtml(java.lang.String ), 0, this, string2);
        }

        private CharSequence uriToStyledText(String string2) {
            return InvokeDynamicSupport.bootstrap("uriToStyledText", $$robo$$android_content_ClipData_Item$uriToStyledText(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_ClipData_Item$toString(), 0, this);
        }

        public void toShortString(StringBuilder stringBuilder) {
            InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_content_ClipData_Item$toShortString(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        public /* synthetic */ Item() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Item)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

