/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Intent
implements Parcelable,
Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String ATTR_ACTION = "action";
    private static String TAG_CATEGORIES = "categories";
    private static String ATTR_CATEGORY = "category";
    private static String TAG_EXTRA = "extra";
    private static String ATTR_TYPE = "type";
    private static String ATTR_COMPONENT = "component";
    private static String ATTR_DATA = "data";
    private static String ATTR_FLAGS = "flags";
    public static String ACTION_MAIN = "android.intent.action.MAIN";
    public static String ACTION_VIEW = "android.intent.action.VIEW";
    public static String ACTION_DEFAULT = "android.intent.action.VIEW";
    public static String ACTION_ATTACH_DATA = "android.intent.action.ATTACH_DATA";
    public static String ACTION_EDIT = "android.intent.action.EDIT";
    public static String ACTION_INSERT_OR_EDIT = "android.intent.action.INSERT_OR_EDIT";
    public static String ACTION_PICK = "android.intent.action.PICK";
    public static String ACTION_CREATE_SHORTCUT = "android.intent.action.CREATE_SHORTCUT";
    public static String EXTRA_SHORTCUT_INTENT = "android.intent.extra.shortcut.INTENT";
    public static String EXTRA_SHORTCUT_NAME = "android.intent.extra.shortcut.NAME";
    public static String EXTRA_SHORTCUT_ICON = "android.intent.extra.shortcut.ICON";
    public static String EXTRA_SHORTCUT_ICON_RESOURCE = "android.intent.extra.shortcut.ICON_RESOURCE";
    public static String ACTION_CHOOSER = "android.intent.action.CHOOSER";
    public static String ACTION_GET_CONTENT = "android.intent.action.GET_CONTENT";
    public static String ACTION_DIAL = "android.intent.action.DIAL";
    public static String ACTION_CALL = "android.intent.action.CALL";
    public static String ACTION_CALL_EMERGENCY = "android.intent.action.CALL_EMERGENCY";
    public static String ACTION_CALL_PRIVILEGED = "android.intent.action.CALL_PRIVILEGED";
    public static String ACTION_SENDTO = "android.intent.action.SENDTO";
    public static String ACTION_SEND = "android.intent.action.SEND";
    public static String ACTION_SEND_MULTIPLE = "android.intent.action.SEND_MULTIPLE";
    public static String ACTION_ANSWER = "android.intent.action.ANSWER";
    public static String ACTION_INSERT = "android.intent.action.INSERT";
    public static String ACTION_PASTE = "android.intent.action.PASTE";
    public static String ACTION_DELETE = "android.intent.action.DELETE";
    public static String ACTION_RUN = "android.intent.action.RUN";
    public static String ACTION_SYNC = "android.intent.action.SYNC";
    public static String ACTION_PICK_ACTIVITY = "android.intent.action.PICK_ACTIVITY";
    public static String ACTION_SEARCH = "android.intent.action.SEARCH";
    public static String ACTION_SYSTEM_TUTORIAL = "android.intent.action.SYSTEM_TUTORIAL";
    public static String ACTION_WEB_SEARCH = "android.intent.action.WEB_SEARCH";
    public static String ACTION_ASSIST = "android.intent.action.ASSIST";
    public static String ACTION_VOICE_ASSIST = "android.intent.action.VOICE_ASSIST";
    public static String EXTRA_ASSIST_PACKAGE = "android.intent.extra.ASSIST_PACKAGE";
    public static String EXTRA_ASSIST_CONTEXT = "android.intent.extra.ASSIST_CONTEXT";
    public static String EXTRA_ASSIST_INPUT_HINT_KEYBOARD = "android.intent.extra.ASSIST_INPUT_HINT_KEYBOARD";
    public static String ACTION_ALL_APPS = "android.intent.action.ALL_APPS";
    public static String ACTION_SET_WALLPAPER = "android.intent.action.SET_WALLPAPER";
    public static String ACTION_BUG_REPORT = "android.intent.action.BUG_REPORT";
    public static String ACTION_FACTORY_TEST = "android.intent.action.FACTORY_TEST";
    public static String ACTION_CALL_BUTTON = "android.intent.action.CALL_BUTTON";
    public static String ACTION_VOICE_COMMAND = "android.intent.action.VOICE_COMMAND";
    public static String ACTION_SEARCH_LONG_PRESS = "android.intent.action.SEARCH_LONG_PRESS";
    public static String ACTION_APP_ERROR = "android.intent.action.APP_ERROR";
    public static String ACTION_POWER_USAGE_SUMMARY = "android.intent.action.POWER_USAGE_SUMMARY";
    public static String ACTION_UPGRADE_SETUP = "android.intent.action.UPGRADE_SETUP";
    public static String ACTION_MANAGE_NETWORK_USAGE = "android.intent.action.MANAGE_NETWORK_USAGE";
    public static String ACTION_INSTALL_PACKAGE = "android.intent.action.INSTALL_PACKAGE";
    public static String EXTRA_INSTALLER_PACKAGE_NAME = "android.intent.extra.INSTALLER_PACKAGE_NAME";
    public static String EXTRA_NOT_UNKNOWN_SOURCE = "android.intent.extra.NOT_UNKNOWN_SOURCE";
    public static String EXTRA_ORIGINATING_URI = "android.intent.extra.ORIGINATING_URI";
    public static String EXTRA_REFERRER = "android.intent.extra.REFERRER";
    public static String EXTRA_ORIGINATING_UID = "android.intent.extra.ORIGINATING_UID";
    @Deprecated
    public static String EXTRA_ALLOW_REPLACE = "android.intent.extra.ALLOW_REPLACE";
    public static String EXTRA_RETURN_RESULT = "android.intent.extra.RETURN_RESULT";
    public static String EXTRA_INSTALL_RESULT = "android.intent.extra.INSTALL_RESULT";
    public static String ACTION_UNINSTALL_PACKAGE = "android.intent.action.UNINSTALL_PACKAGE";
    public static String EXTRA_UNINSTALL_ALL_USERS = "android.intent.extra.UNINSTALL_ALL_USERS";
    public static String METADATA_SETUP_VERSION = "android.SETUP_VERSION";
    public static String ACTION_SCREEN_OFF = "android.intent.action.SCREEN_OFF";
    public static String ACTION_SCREEN_ON = "android.intent.action.SCREEN_ON";
    public static String ACTION_DREAMING_STOPPED = "android.intent.action.DREAMING_STOPPED";
    public static String ACTION_DREAMING_STARTED = "android.intent.action.DREAMING_STARTED";
    public static String ACTION_USER_PRESENT = "android.intent.action.USER_PRESENT";
    public static String ACTION_TIME_TICK = "android.intent.action.TIME_TICK";
    public static String ACTION_TIME_CHANGED = "android.intent.action.TIME_SET";
    public static String ACTION_DATE_CHANGED = "android.intent.action.DATE_CHANGED";
    public static String ACTION_TIMEZONE_CHANGED = "android.intent.action.TIMEZONE_CHANGED";
    public static String ACTION_CLEAR_DNS_CACHE = "android.intent.action.CLEAR_DNS_CACHE";
    public static String ACTION_ALARM_CHANGED = "android.intent.action.ALARM_CHANGED";
    public static String ACTION_SYNC_STATE_CHANGED = "android.intent.action.SYNC_STATE_CHANGED";
    public static String ACTION_BOOT_COMPLETED = "android.intent.action.BOOT_COMPLETED";
    public static String ACTION_CLOSE_SYSTEM_DIALOGS = "android.intent.action.CLOSE_SYSTEM_DIALOGS";
    @Deprecated
    public static String ACTION_PACKAGE_INSTALL = "android.intent.action.PACKAGE_INSTALL";
    public static String ACTION_PACKAGE_ADDED = "android.intent.action.PACKAGE_ADDED";
    public static String ACTION_PACKAGE_REPLACED = "android.intent.action.PACKAGE_REPLACED";
    public static String ACTION_MY_PACKAGE_REPLACED = "android.intent.action.MY_PACKAGE_REPLACED";
    public static String ACTION_PACKAGE_REMOVED = "android.intent.action.PACKAGE_REMOVED";
    public static String ACTION_PACKAGE_FULLY_REMOVED = "android.intent.action.PACKAGE_FULLY_REMOVED";
    public static String ACTION_PACKAGE_CHANGED = "android.intent.action.PACKAGE_CHANGED";
    public static String ACTION_QUERY_PACKAGE_RESTART = "android.intent.action.QUERY_PACKAGE_RESTART";
    public static String ACTION_PACKAGE_RESTARTED = "android.intent.action.PACKAGE_RESTARTED";
    public static String ACTION_PACKAGE_DATA_CLEARED = "android.intent.action.PACKAGE_DATA_CLEARED";
    public static String ACTION_UID_REMOVED = "android.intent.action.UID_REMOVED";
    public static String ACTION_PACKAGE_FIRST_LAUNCH = "android.intent.action.PACKAGE_FIRST_LAUNCH";
    public static String ACTION_PACKAGE_NEEDS_VERIFICATION = "android.intent.action.PACKAGE_NEEDS_VERIFICATION";
    public static String ACTION_PACKAGE_VERIFIED = "android.intent.action.PACKAGE_VERIFIED";
    public static String ACTION_EXTERNAL_APPLICATIONS_AVAILABLE = "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE";
    public static String ACTION_EXTERNAL_APPLICATIONS_UNAVAILABLE = "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
    @Deprecated
    public static String ACTION_WALLPAPER_CHANGED = "android.intent.action.WALLPAPER_CHANGED";
    public static String ACTION_CONFIGURATION_CHANGED = "android.intent.action.CONFIGURATION_CHANGED";
    public static String ACTION_LOCALE_CHANGED = "android.intent.action.LOCALE_CHANGED";
    public static String ACTION_BATTERY_CHANGED = "android.intent.action.BATTERY_CHANGED";
    public static String ACTION_BATTERY_LOW = "android.intent.action.BATTERY_LOW";
    public static String ACTION_BATTERY_OKAY = "android.intent.action.BATTERY_OKAY";
    public static String ACTION_POWER_CONNECTED = "android.intent.action.ACTION_POWER_CONNECTED";
    public static String ACTION_POWER_DISCONNECTED = "android.intent.action.ACTION_POWER_DISCONNECTED";
    public static String ACTION_SHUTDOWN = "android.intent.action.ACTION_SHUTDOWN";
    public static String ACTION_REQUEST_SHUTDOWN = "android.intent.action.ACTION_REQUEST_SHUTDOWN";
    public static String ACTION_DEVICE_STORAGE_LOW = "android.intent.action.DEVICE_STORAGE_LOW";
    public static String ACTION_DEVICE_STORAGE_OK = "android.intent.action.DEVICE_STORAGE_OK";
    public static String ACTION_DEVICE_STORAGE_FULL = "android.intent.action.DEVICE_STORAGE_FULL";
    public static String ACTION_DEVICE_STORAGE_NOT_FULL = "android.intent.action.DEVICE_STORAGE_NOT_FULL";
    public static String ACTION_MANAGE_PACKAGE_STORAGE = "android.intent.action.MANAGE_PACKAGE_STORAGE";
    @Deprecated
    public static String ACTION_UMS_CONNECTED = "android.intent.action.UMS_CONNECTED";
    @Deprecated
    public static String ACTION_UMS_DISCONNECTED = "android.intent.action.UMS_DISCONNECTED";
    public static String ACTION_MEDIA_REMOVED = "android.intent.action.MEDIA_REMOVED";
    public static String ACTION_MEDIA_UNMOUNTED = "android.intent.action.MEDIA_UNMOUNTED";
    public static String ACTION_MEDIA_CHECKING = "android.intent.action.MEDIA_CHECKING";
    public static String ACTION_MEDIA_NOFS = "android.intent.action.MEDIA_NOFS";
    public static String ACTION_MEDIA_MOUNTED = "android.intent.action.MEDIA_MOUNTED";
    public static String ACTION_MEDIA_SHARED = "android.intent.action.MEDIA_SHARED";
    public static String ACTION_MEDIA_UNSHARED = "android.intent.action.MEDIA_UNSHARED";
    public static String ACTION_MEDIA_BAD_REMOVAL = "android.intent.action.MEDIA_BAD_REMOVAL";
    public static String ACTION_MEDIA_UNMOUNTABLE = "android.intent.action.MEDIA_UNMOUNTABLE";
    public static String ACTION_MEDIA_EJECT = "android.intent.action.MEDIA_EJECT";
    public static String ACTION_MEDIA_SCANNER_STARTED = "android.intent.action.MEDIA_SCANNER_STARTED";
    public static String ACTION_MEDIA_SCANNER_FINISHED = "android.intent.action.MEDIA_SCANNER_FINISHED";
    public static String ACTION_MEDIA_SCANNER_SCAN_FILE = "android.intent.action.MEDIA_SCANNER_SCAN_FILE";
    public static String ACTION_MEDIA_BUTTON = "android.intent.action.MEDIA_BUTTON";
    public static String ACTION_CAMERA_BUTTON = "android.intent.action.CAMERA_BUTTON";
    public static String ACTION_GTALK_SERVICE_CONNECTED = "android.intent.action.GTALK_CONNECTED";
    public static String ACTION_GTALK_SERVICE_DISCONNECTED = "android.intent.action.GTALK_DISCONNECTED";
    public static String ACTION_INPUT_METHOD_CHANGED = "android.intent.action.INPUT_METHOD_CHANGED";
    public static String ACTION_AIRPLANE_MODE_CHANGED = "android.intent.action.AIRPLANE_MODE";
    public static String ACTION_PROVIDER_CHANGED = "android.intent.action.PROVIDER_CHANGED";
    public static String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    public static String ACTION_ADVANCED_SETTINGS_CHANGED = "android.intent.action.ADVANCED_SETTINGS";
    public static String ACTION_APPLICATION_RESTRICTIONS_CHANGED = "android.intent.action.APPLICATION_RESTRICTIONS_CHANGED";
    public static String ACTION_NEW_OUTGOING_CALL = "android.intent.action.NEW_OUTGOING_CALL";
    public static String ACTION_REBOOT = "android.intent.action.REBOOT";
    public static String ACTION_DOCK_EVENT = "android.intent.action.DOCK_EVENT";
    public static String ACTION_IDLE_MAINTENANCE_START = "android.intent.action.ACTION_IDLE_MAINTENANCE_START";
    public static String ACTION_IDLE_MAINTENANCE_END = "android.intent.action.ACTION_IDLE_MAINTENANCE_END";
    public static String ACTION_REMOTE_INTENT = "com.google.android.c2dm.intent.RECEIVE";
    public static String ACTION_PRE_BOOT_COMPLETED = "android.intent.action.PRE_BOOT_COMPLETED";
    public static String ACTION_GET_RESTRICTION_ENTRIES = "android.intent.action.GET_RESTRICTION_ENTRIES";
    public static String ACTION_RESTRICTIONS_CHALLENGE = "android.intent.action.RESTRICTIONS_CHALLENGE";
    public static String ACTION_USER_INITIALIZE = "android.intent.action.USER_INITIALIZE";
    public static String ACTION_USER_FOREGROUND = "android.intent.action.USER_FOREGROUND";
    public static String ACTION_USER_BACKGROUND = "android.intent.action.USER_BACKGROUND";
    public static String ACTION_USER_ADDED = "android.intent.action.USER_ADDED";
    public static String ACTION_USER_STARTED = "android.intent.action.USER_STARTED";
    public static String ACTION_USER_STARTING = "android.intent.action.USER_STARTING";
    public static String ACTION_USER_STOPPING = "android.intent.action.USER_STOPPING";
    public static String ACTION_USER_STOPPED = "android.intent.action.USER_STOPPED";
    public static String ACTION_USER_REMOVED = "android.intent.action.USER_REMOVED";
    public static String ACTION_USER_SWITCHED = "android.intent.action.USER_SWITCHED";
    public static String ACTION_USER_INFO_CHANGED = "android.intent.action.USER_INFO_CHANGED";
    public static String ACTION_MANAGED_PROFILE_ADDED = "android.intent.action.MANAGED_PROFILE_ADDED";
    public static String ACTION_MANAGED_PROFILE_REMOVED = "android.intent.action.MANAGED_PROFILE_REMOVED";
    public static String ACTION_QUICK_CLOCK = "android.intent.action.QUICK_CLOCK";
    public static String ACTION_SHOW_BRIGHTNESS_DIALOG = "android.intent.action.SHOW_BRIGHTNESS_DIALOG";
    public static String ACTION_GLOBAL_BUTTON = "android.intent.action.GLOBAL_BUTTON";
    public static String ACTION_OPEN_DOCUMENT = "android.intent.action.OPEN_DOCUMENT";
    public static String ACTION_CREATE_DOCUMENT = "android.intent.action.CREATE_DOCUMENT";
    public static String ACTION_OPEN_DOCUMENT_TREE = "android.intent.action.OPEN_DOCUMENT_TREE";
    public static String ACTION_MASTER_CLEAR = "android.intent.action.MASTER_CLEAR";
    public static String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    public static String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    public static String CATEGORY_VOICE = "android.intent.category.VOICE";
    public static String CATEGORY_ALTERNATIVE = "android.intent.category.ALTERNATIVE";
    public static String CATEGORY_SELECTED_ALTERNATIVE = "android.intent.category.SELECTED_ALTERNATIVE";
    public static String CATEGORY_TAB = "android.intent.category.TAB";
    public static String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";
    public static String CATEGORY_LEANBACK_LAUNCHER = "android.intent.category.LEANBACK_LAUNCHER";
    public static String CATEGORY_LEANBACK_SETTINGS = "android.intent.category.LEANBACK_SETTINGS";
    public static String CATEGORY_INFO = "android.intent.category.INFO";
    public static String CATEGORY_HOME = "android.intent.category.HOME";
    public static String CATEGORY_PREFERENCE = "android.intent.category.PREFERENCE";
    public static String CATEGORY_DEVELOPMENT_PREFERENCE = "android.intent.category.DEVELOPMENT_PREFERENCE";
    public static String CATEGORY_EMBED = "android.intent.category.EMBED";
    public static String CATEGORY_APP_MARKET = "android.intent.category.APP_MARKET";
    public static String CATEGORY_MONKEY = "android.intent.category.MONKEY";
    public static String CATEGORY_TEST = "android.intent.category.TEST";
    public static String CATEGORY_UNIT_TEST = "android.intent.category.UNIT_TEST";
    public static String CATEGORY_SAMPLE_CODE = "android.intent.category.SAMPLE_CODE";
    public static String CATEGORY_OPENABLE = "android.intent.category.OPENABLE";
    public static String CATEGORY_FRAMEWORK_INSTRUMENTATION_TEST = "android.intent.category.FRAMEWORK_INSTRUMENTATION_TEST";
    public static String CATEGORY_CAR_DOCK = "android.intent.category.CAR_DOCK";
    public static String CATEGORY_DESK_DOCK = "android.intent.category.DESK_DOCK";
    public static String CATEGORY_LE_DESK_DOCK = "android.intent.category.LE_DESK_DOCK";
    public static String CATEGORY_HE_DESK_DOCK = "android.intent.category.HE_DESK_DOCK";
    public static String CATEGORY_CAR_MODE = "android.intent.category.CAR_MODE";
    public static String CATEGORY_APP_BROWSER = "android.intent.category.APP_BROWSER";
    public static String CATEGORY_APP_CALCULATOR = "android.intent.category.APP_CALCULATOR";
    public static String CATEGORY_APP_CALENDAR = "android.intent.category.APP_CALENDAR";
    public static String CATEGORY_APP_CONTACTS = "android.intent.category.APP_CONTACTS";
    public static String CATEGORY_APP_EMAIL = "android.intent.category.APP_EMAIL";
    public static String CATEGORY_APP_GALLERY = "android.intent.category.APP_GALLERY";
    public static String CATEGORY_APP_MAPS = "android.intent.category.APP_MAPS";
    public static String CATEGORY_APP_MESSAGING = "android.intent.category.APP_MESSAGING";
    public static String CATEGORY_APP_MUSIC = "android.intent.category.APP_MUSIC";
    public static String EXTRA_TEMPLATE = "android.intent.extra.TEMPLATE";
    public static String EXTRA_TEXT = "android.intent.extra.TEXT";
    public static String EXTRA_HTML_TEXT = "android.intent.extra.HTML_TEXT";
    public static String EXTRA_STREAM = "android.intent.extra.STREAM";
    public static String EXTRA_EMAIL = "android.intent.extra.EMAIL";
    public static String EXTRA_CC = "android.intent.extra.CC";
    public static String EXTRA_BCC = "android.intent.extra.BCC";
    public static String EXTRA_SUBJECT = "android.intent.extra.SUBJECT";
    public static String EXTRA_INTENT = "android.intent.extra.INTENT";
    public static String EXTRA_TITLE = "android.intent.extra.TITLE";
    public static String EXTRA_INITIAL_INTENTS = "android.intent.extra.INITIAL_INTENTS";
    public static String EXTRA_REPLACEMENT_EXTRAS = "android.intent.extra.REPLACEMENT_EXTRAS";
    public static String EXTRA_KEY_EVENT = "android.intent.extra.KEY_EVENT";
    public static String EXTRA_KEY_CONFIRM = "android.intent.extra.KEY_CONFIRM";
    public static String EXTRA_DONT_KILL_APP = "android.intent.extra.DONT_KILL_APP";
    public static String EXTRA_PHONE_NUMBER = "android.intent.extra.PHONE_NUMBER";
    public static String EXTRA_UID = "android.intent.extra.UID";
    public static String EXTRA_PACKAGES = "android.intent.extra.PACKAGES";
    public static String EXTRA_DATA_REMOVED = "android.intent.extra.DATA_REMOVED";
    public static String EXTRA_REMOVED_FOR_ALL_USERS = "android.intent.extra.REMOVED_FOR_ALL_USERS";
    public static String EXTRA_REPLACING = "android.intent.extra.REPLACING";
    public static String EXTRA_ALARM_COUNT = "android.intent.extra.ALARM_COUNT";
    public static String EXTRA_DOCK_STATE = "android.intent.extra.DOCK_STATE";
    public static int EXTRA_DOCK_STATE_UNDOCKED = 0;
    public static int EXTRA_DOCK_STATE_DESK = 1;
    public static int EXTRA_DOCK_STATE_CAR = 2;
    public static int EXTRA_DOCK_STATE_LE_DESK = 3;
    public static int EXTRA_DOCK_STATE_HE_DESK = 4;
    public static String METADATA_DOCK_HOME = "android.dock_home";
    public static String EXTRA_BUG_REPORT = "android.intent.extra.BUG_REPORT";
    public static String EXTRA_REMOTE_INTENT_TOKEN = "android.intent.extra.remote_intent_token";
    @Deprecated
    public static String EXTRA_CHANGED_COMPONENT_NAME = "android.intent.extra.changed_component_name";
    public static String EXTRA_CHANGED_COMPONENT_NAME_LIST = "android.intent.extra.changed_component_name_list";
    public static String EXTRA_CHANGED_PACKAGE_LIST = "android.intent.extra.changed_package_list";
    public static String EXTRA_CHANGED_UID_LIST = "android.intent.extra.changed_uid_list";
    public static String EXTRA_CLIENT_LABEL = "android.intent.extra.client_label";
    public static String EXTRA_CLIENT_INTENT = "android.intent.extra.client_intent";
    public static String EXTRA_LOCAL_ONLY = "android.intent.extra.LOCAL_ONLY";
    public static String EXTRA_ALLOW_MULTIPLE = "android.intent.extra.ALLOW_MULTIPLE";
    public static String EXTRA_USER_HANDLE = "android.intent.extra.user_handle";
    public static String EXTRA_USER = "android.intent.extra.USER";
    public static String EXTRA_RESTRICTIONS_LIST = "android.intent.extra.restrictions_list";
    public static String EXTRA_RESTRICTIONS_BUNDLE = "android.intent.extra.restrictions_bundle";
    public static String EXTRA_RESTRICTIONS_INTENT = "android.intent.extra.restrictions_intent";
    public static String EXTRA_MIME_TYPES = "android.intent.extra.MIME_TYPES";
    public static String EXTRA_SHUTDOWN_USERSPACE_ONLY = "android.intent.extra.SHUTDOWN_USERSPACE_ONLY";
    public static String EXTRA_TIME_PREF_24_HOUR_FORMAT = "android.intent.extra.TIME_PREF_24_HOUR_FORMAT";
    public static String EXTRA_REASON = "android.intent.extra.REASON";
    public static int FLAG_GRANT_READ_URI_PERMISSION = 1;
    public static int FLAG_GRANT_WRITE_URI_PERMISSION = 2;
    public static int FLAG_FROM_BACKGROUND = 4;
    public static int FLAG_DEBUG_LOG_RESOLUTION = 8;
    public static int FLAG_EXCLUDE_STOPPED_PACKAGES = 16;
    public static int FLAG_INCLUDE_STOPPED_PACKAGES = 32;
    public static int FLAG_GRANT_PERSISTABLE_URI_PERMISSION = 64;
    public static int FLAG_GRANT_PREFIX_URI_PERMISSION = 128;
    public static int FLAG_ACTIVITY_NO_HISTORY = 0x40000000;
    public static int FLAG_ACTIVITY_SINGLE_TOP = 0x20000000;
    public static int FLAG_ACTIVITY_NEW_TASK = 0x10000000;
    public static int FLAG_ACTIVITY_MULTIPLE_TASK = 0x8000000;
    public static int FLAG_ACTIVITY_CLEAR_TOP = 0x4000000;
    public static int FLAG_ACTIVITY_FORWARD_RESULT = 0x2000000;
    public static int FLAG_ACTIVITY_PREVIOUS_IS_TOP = 0x1000000;
    public static int FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS = 0x800000;
    public static int FLAG_ACTIVITY_BROUGHT_TO_FRONT = 0x400000;
    public static int FLAG_ACTIVITY_RESET_TASK_IF_NEEDED = 0x200000;
    public static int FLAG_ACTIVITY_LAUNCHED_FROM_HISTORY = 0x100000;
    public static int FLAG_ACTIVITY_CLEAR_WHEN_TASK_RESET = 524288;
    public static int FLAG_ACTIVITY_NEW_DOCUMENT = 524288;
    public static int FLAG_ACTIVITY_NO_USER_ACTION = 262144;
    public static int FLAG_ACTIVITY_REORDER_TO_FRONT = 131072;
    public static int FLAG_ACTIVITY_NO_ANIMATION = 65536;
    public static int FLAG_ACTIVITY_CLEAR_TASK = 32768;
    public static int FLAG_ACTIVITY_TASK_ON_HOME = 16384;
    public static int FLAG_ACTIVITY_RETAIN_IN_RECENTS = 8192;
    public static int FLAG_RECEIVER_REGISTERED_ONLY = 0x40000000;
    public static int FLAG_RECEIVER_REPLACE_PENDING = 0x20000000;
    public static int FLAG_RECEIVER_FOREGROUND = 0x10000000;
    public static int FLAG_RECEIVER_NO_ABORT = 0x8000000;
    public static int FLAG_RECEIVER_REGISTERED_ONLY_BEFORE_BOOT = 0x4000000;
    public static int FLAG_RECEIVER_BOOT_UPGRADE = 0x2000000;
    public static int IMMUTABLE_FLAGS = 195;
    public static int URI_INTENT_SCHEME = 1;
    private String mAction;
    private Uri mData;
    private String mType;
    private String mPackage;
    private ComponentName mComponent;
    private int mFlags;
    private ArraySet<String> mCategories;
    private Bundle mExtras;
    private Rect mSourceBounds;
    private Intent mSelector;
    private ClipData mClipData;
    private int mContentUserHint;
    public static int FILL_IN_ACTION = 1;
    public static int FILL_IN_DATA = 2;
    public static int FILL_IN_CATEGORIES = 4;
    public static int FILL_IN_COMPONENT = 8;
    public static int FILL_IN_PACKAGE = 16;
    public static int FILL_IN_SOURCE_BOUNDS = 32;
    public static int FILL_IN_SELECTOR = 64;
    public static int FILL_IN_CLIP_DATA = 128;
    public static Parcelable.Creator<Intent> CREATOR;

    private static final Intent $$robo$$android_content_Intent$createChooser(Intent target, CharSequence title) {
        int permFlags;
        Intent intent = new Intent("android.intent.action.CHOOSER");
        intent.putExtra("android.intent.extra.INTENT", target);
        if (title != null) {
            intent.putExtra("android.intent.extra.TITLE", title);
        }
        if ((permFlags = target.getFlags() & 0xC3) != 0) {
            ClipData targetClipData = target.getClipData();
            if (targetClipData == null && target.getData() != null) {
                ClipData.Item item = new ClipData.Item(target.getData());
                String[] mimeTypes = target.getType() != null ? new String[]{target.getType()} : new String[]{};
                targetClipData = new ClipData(null, mimeTypes, item);
            }
            if (targetClipData != null) {
                intent.setClipData(targetClipData);
                intent.addFlags(permFlags);
            }
        }
        return intent;
    }

    private static final boolean $$robo$$android_content_Intent$isAccessUriMode(int modeFlags) {
        return (modeFlags & 3) != 0;
    }

    private void $$robo$$android_content_Intent$__constructor__() {
        this.mContentUserHint = -2;
    }

    private void $$robo$$android_content_Intent$__constructor__(Intent o) {
        this.mContentUserHint = -2;
        this.mAction = o.mAction;
        this.mData = o.mData;
        this.mType = o.mType;
        this.mPackage = o.mPackage;
        this.mComponent = o.mComponent;
        this.mFlags = o.mFlags;
        this.mContentUserHint = o.mContentUserHint;
        if (o.mCategories != null) {
            this.mCategories = new ArraySet(o.mCategories);
        }
        if (o.mExtras != null) {
            this.mExtras = new Bundle(o.mExtras);
        }
        if (o.mSourceBounds != null) {
            this.mSourceBounds = new Rect(o.mSourceBounds);
        }
        if (o.mSelector != null) {
            this.mSelector = new Intent(o.mSelector);
        }
        if (o.mClipData != null) {
            this.mClipData = new ClipData(o.mClipData);
        }
    }

    private final Object $$robo$$android_content_Intent$clone() {
        return new Intent(this);
    }

    private void $$robo$$android_content_Intent$__constructor__(Intent o, boolean all) {
        this.mContentUserHint = -2;
        this.mAction = o.mAction;
        this.mData = o.mData;
        this.mType = o.mType;
        this.mPackage = o.mPackage;
        this.mComponent = o.mComponent;
        if (o.mCategories != null) {
            this.mCategories = new ArraySet(o.mCategories);
        }
    }

    private final Intent $$robo$$android_content_Intent$cloneFilter() {
        return new Intent(this, false);
    }

    private void $$robo$$android_content_Intent$__constructor__(String action) {
        this.mContentUserHint = -2;
        this.setAction(action);
    }

    private void $$robo$$android_content_Intent$__constructor__(String action, Uri uri) {
        this.mContentUserHint = -2;
        this.setAction(action);
        this.mData = uri;
    }

    private void $$robo$$android_content_Intent$__constructor__(Context packageContext, Class<?> cls) {
        this.mContentUserHint = -2;
        this.mComponent = new ComponentName(packageContext, cls);
    }

    private void $$robo$$android_content_Intent$__constructor__(String action, Uri uri, Context packageContext, Class<?> cls) {
        this.mContentUserHint = -2;
        this.setAction(action);
        this.mData = uri;
        this.mComponent = new ComponentName(packageContext, cls);
    }

    private static final Intent $$robo$$android_content_Intent$makeMainActivity(ComponentName mainActivity) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setComponent(mainActivity);
        intent.addCategory("android.intent.category.LAUNCHER");
        return intent;
    }

    private static final Intent $$robo$$android_content_Intent$makeMainSelectorActivity(String selectorAction, String selectorCategory) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        Intent selector = new Intent();
        selector.setAction(selectorAction);
        selector.addCategory(selectorCategory);
        intent.setSelector(selector);
        return intent;
    }

    private static final Intent $$robo$$android_content_Intent$makeRestartActivityTask(ComponentName mainActivity) {
        Intent intent = Intent.makeMainActivity(mainActivity);
        intent.addFlags(0x10008000);
        return intent;
    }

    @Deprecated
    private static final Intent $$robo$$android_content_Intent$getIntent(String uri) throws URISyntaxException {
        return Intent.parseUri(uri, 0);
    }

    private static final Intent $$robo$$android_content_Intent$parseUri(String uri, int flags) throws URISyntaxException {
        int i = 0;
        try {
            Intent intent;
            if ((flags & 1) != 0 && !uri.startsWith("intent:")) {
                Intent intent2 = new Intent("android.intent.action.VIEW");
                try {
                    intent2.setData(Uri.parse(uri));
                }
                catch (IllegalArgumentException e) {
                    throw new URISyntaxException(uri, e.getMessage());
                }
                return intent2;
            }
            i = uri.lastIndexOf("#");
            if (i == -1) {
                return new Intent("android.intent.action.VIEW", Uri.parse(uri));
            }
            if (!uri.startsWith("#Intent;", i)) {
                return Intent.getIntentOld(uri);
            }
            Intent baseIntent = intent = new Intent("android.intent.action.VIEW");
            String data = i >= 0 ? uri.substring(0, i) : null;
            String scheme = null;
            i += "#Intent;".length();
            while (!uri.startsWith("end", i)) {
                int semi;
                String value;
                int eq = uri.indexOf(61, i);
                if (eq < 0) {
                    eq = i - 1;
                }
                String string2 = value = eq < (semi = uri.indexOf(59, i)) ? Uri.decode(uri.substring(eq + 1, semi)) : "";
                if (uri.startsWith("action=", i)) {
                    intent.setAction(value);
                } else if (uri.startsWith("category=", i)) {
                    intent.addCategory(value);
                } else if (uri.startsWith("type=", i)) {
                    intent.mType = value;
                } else if (uri.startsWith("launchFlags=", i)) {
                    intent.mFlags = Integer.decode(value);
                } else if (uri.startsWith("package=", i)) {
                    intent.mPackage = value;
                } else if (uri.startsWith("component=", i)) {
                    intent.mComponent = ComponentName.unflattenFromString(value);
                } else if (uri.startsWith("scheme=", i)) {
                    scheme = value;
                } else if (uri.startsWith("sourceBounds=", i)) {
                    intent.mSourceBounds = Rect.unflattenFromString(value);
                } else if (semi == i + 3 && uri.startsWith("SEL", i)) {
                    intent = new Intent();
                } else {
                    String key = Uri.decode(uri.substring(i + 2, eq));
                    if (intent.mExtras == null) {
                        intent.mExtras = new Bundle();
                    }
                    Bundle b = intent.mExtras;
                    if (uri.startsWith("S.", i)) {
                        b.putString(key, value);
                    } else if (uri.startsWith("B.", i)) {
                        b.putBoolean(key, Boolean.parseBoolean(value));
                    } else if (uri.startsWith("b.", i)) {
                        b.putByte(key, Byte.parseByte(value));
                    } else if (uri.startsWith("c.", i)) {
                        b.putChar(key, value.charAt(0));
                    } else if (uri.startsWith("d.", i)) {
                        b.putDouble(key, Double.parseDouble(value));
                    } else if (uri.startsWith("f.", i)) {
                        b.putFloat(key, Float.parseFloat(value));
                    } else if (uri.startsWith("i.", i)) {
                        b.putInt(key, Integer.parseInt(value));
                    } else if (uri.startsWith("l.", i)) {
                        b.putLong(key, Long.parseLong(value));
                    } else if (uri.startsWith("s.", i)) {
                        b.putShort(key, Short.parseShort(value));
                    } else {
                        throw new URISyntaxException(uri, "unknown EXTRA type", i);
                    }
                }
                i = semi + 1;
            }
            if (intent != baseIntent) {
                baseIntent.setSelector(intent);
                intent = baseIntent;
            }
            if (data != null) {
                if (data.startsWith("intent:")) {
                    data = data.substring(7);
                    if (scheme != null) {
                        data = scheme + ':' + data;
                    }
                }
                if (data.length() > 0) {
                    try {
                        intent.mData = Uri.parse(data);
                    }
                    catch (IllegalArgumentException e) {
                        throw new URISyntaxException(uri, e.getMessage());
                    }
                }
            }
            return intent;
        }
        catch (IndexOutOfBoundsException e) {
            throw new URISyntaxException(uri, "illegal Intent URI format", i);
        }
    }

    private static final Intent $$robo$$android_content_Intent$getIntentOld(String uri) throws URISyntaxException {
        Intent intent;
        int i = uri.lastIndexOf(35);
        if (i >= 0) {
            int sep;
            int j;
            String action = null;
            int intentFragmentStart = i++;
            boolean isIntentFragment = false;
            if (uri.regionMatches(i, "action(", 0, 7)) {
                isIntentFragment = true;
                j = uri.indexOf(41, i += 7);
                action = uri.substring(i, j);
                i = j + 1;
            }
            intent = new Intent(action);
            if (uri.regionMatches(i, "categories(", 0, 11)) {
                isIntentFragment = true;
                j = uri.indexOf(41, i += 11);
                while (i < j) {
                    sep = uri.indexOf(33, i);
                    if (sep < 0 || sep > j) {
                        sep = j;
                    }
                    if (i < sep) {
                        intent.addCategory(uri.substring(i, sep));
                    }
                    i = sep + 1;
                }
                i = j + 1;
            }
            if (uri.regionMatches(i, "type(", 0, 5)) {
                isIntentFragment = true;
                j = uri.indexOf(41, i += 5);
                intent.mType = uri.substring(i, j);
                i = j + 1;
            }
            if (uri.regionMatches(i, "launchFlags(", 0, 12)) {
                isIntentFragment = true;
                j = uri.indexOf(41, i += 12);
                intent.mFlags = Integer.decode(uri.substring(i, j));
                i = j + 1;
            }
            if (uri.regionMatches(i, "component(", 0, 10)) {
                isIntentFragment = true;
                j = uri.indexOf(41, i += 10);
                sep = uri.indexOf(33, i);
                if (sep >= 0 && sep < j) {
                    String pkg = uri.substring(i, sep);
                    String cls = uri.substring(sep + 1, j);
                    intent.mComponent = new ComponentName(pkg, cls);
                }
                i = j + 1;
            }
            if (uri.regionMatches(i, "extras(", 0, 7)) {
                isIntentFragment = true;
                int closeParen = uri.indexOf(41, i += 7);
                if (closeParen == -1) {
                    throw new URISyntaxException(uri, "EXTRA missing trailing ')'", i);
                }
                while (i < closeParen) {
                    int j2 = uri.indexOf(61, i);
                    if (j2 <= i + 1 || i >= closeParen) {
                        throw new URISyntaxException(uri, "EXTRA missing '='", i);
                    }
                    char type = uri.charAt(i);
                    String key = uri.substring(++i, j2);
                    i = j2 + 1;
                    if ((j2 = uri.indexOf(33, i)) == -1 || j2 >= closeParen) {
                        j2 = closeParen;
                    }
                    if (i >= j2) {
                        throw new URISyntaxException(uri, "EXTRA missing '!'", i);
                    }
                    String value = uri.substring(i, j2);
                    i = j2;
                    if (intent.mExtras == null) {
                        intent.mExtras = new Bundle();
                    }
                    try {
                        switch (type) {
                            case 'S': {
                                intent.mExtras.putString(key, Uri.decode(value));
                                break;
                            }
                            case 'B': {
                                intent.mExtras.putBoolean(key, Boolean.parseBoolean(value));
                                break;
                            }
                            case 'b': {
                                intent.mExtras.putByte(key, Byte.parseByte(value));
                                break;
                            }
                            case 'c': {
                                intent.mExtras.putChar(key, Uri.decode(value).charAt(0));
                                break;
                            }
                            case 'd': {
                                intent.mExtras.putDouble(key, Double.parseDouble(value));
                                break;
                            }
                            case 'f': {
                                intent.mExtras.putFloat(key, Float.parseFloat(value));
                                break;
                            }
                            case 'i': {
                                intent.mExtras.putInt(key, Integer.parseInt(value));
                                break;
                            }
                            case 'l': {
                                intent.mExtras.putLong(key, Long.parseLong(value));
                                break;
                            }
                            case 's': {
                                intent.mExtras.putShort(key, Short.parseShort(value));
                                break;
                            }
                            default: {
                                throw new URISyntaxException(uri, "EXTRA has unknown type", i);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new URISyntaxException(uri, "EXTRA value can't be parsed", i);
                    }
                    char ch = uri.charAt(i);
                    if (ch == ')') break;
                    if (ch != '!') {
                        throw new URISyntaxException(uri, "EXTRA missing '!'", i);
                    }
                    ++i;
                }
            }
            intent.mData = isIntentFragment ? Uri.parse(uri.substring(0, intentFragmentStart)) : Uri.parse(uri);
            if (intent.mAction == null) {
                intent.mAction = "android.intent.action.VIEW";
            }
        } else {
            intent = new Intent("android.intent.action.VIEW", Uri.parse(uri));
        }
        return intent;
    }

    private final String $$robo$$android_content_Intent$getAction() {
        return this.mAction;
    }

    private final Uri $$robo$$android_content_Intent$getData() {
        return this.mData;
    }

    private final String $$robo$$android_content_Intent$getDataString() {
        return this.mData != null ? this.mData.toString() : null;
    }

    private final String $$robo$$android_content_Intent$getScheme() {
        return this.mData != null ? this.mData.getScheme() : null;
    }

    private final String $$robo$$android_content_Intent$getType() {
        return this.mType;
    }

    private final String $$robo$$android_content_Intent$resolveType(Context context) {
        return this.resolveType(context.getContentResolver());
    }

    private final String $$robo$$android_content_Intent$resolveType(ContentResolver resolver) {
        if (this.mType != null) {
            return this.mType;
        }
        if (this.mData != null && "content".equals(this.mData.getScheme())) {
            return resolver.getType(this.mData);
        }
        return null;
    }

    private final String $$robo$$android_content_Intent$resolveTypeIfNeeded(ContentResolver resolver) {
        if (this.mComponent != null) {
            return this.mType;
        }
        return this.resolveType(resolver);
    }

    private final boolean $$robo$$android_content_Intent$hasCategory(String category) {
        return this.mCategories != null && this.mCategories.contains(category);
    }

    private final Set<String> $$robo$$android_content_Intent$getCategories() {
        return this.mCategories;
    }

    private final Intent $$robo$$android_content_Intent$getSelector() {
        return this.mSelector;
    }

    private final ClipData $$robo$$android_content_Intent$getClipData() {
        return this.mClipData;
    }

    private final int $$robo$$android_content_Intent$getContentUserHint() {
        return this.mContentUserHint;
    }

    private final void $$robo$$android_content_Intent$setExtrasClassLoader(ClassLoader loader) {
        if (this.mExtras != null) {
            this.mExtras.setClassLoader(loader);
        }
    }

    private final boolean $$robo$$android_content_Intent$hasExtra(String name) {
        return this.mExtras != null && this.mExtras.containsKey(name);
    }

    private final boolean $$robo$$android_content_Intent$hasFileDescriptors() {
        return this.mExtras != null && this.mExtras.hasFileDescriptors();
    }

    private final void $$robo$$android_content_Intent$setAllowFds(boolean allowFds) {
        if (this.mExtras != null) {
            this.mExtras.setAllowFds(allowFds);
        }
    }

    @Deprecated
    private final Object $$robo$$android_content_Intent$getExtra(String name) {
        return this.getExtra(name, null);
    }

    private final boolean $$robo$$android_content_Intent$getBooleanExtra(String name, boolean defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getBoolean(name, defaultValue);
    }

    private final byte $$robo$$android_content_Intent$getByteExtra(String name, byte defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getByte(name, defaultValue);
    }

    private final short $$robo$$android_content_Intent$getShortExtra(String name, short defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getShort(name, defaultValue);
    }

    private final char $$robo$$android_content_Intent$getCharExtra(String name, char defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getChar(name, defaultValue);
    }

    private final int $$robo$$android_content_Intent$getIntExtra(String name, int defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getInt(name, defaultValue);
    }

    private final long $$robo$$android_content_Intent$getLongExtra(String name, long defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getLong(name, defaultValue);
    }

    private final float $$robo$$android_content_Intent$getFloatExtra(String name, float defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getFloat(name, defaultValue);
    }

    private final double $$robo$$android_content_Intent$getDoubleExtra(String name, double defaultValue) {
        return this.mExtras == null ? defaultValue : this.mExtras.getDouble(name, defaultValue);
    }

    private final String $$robo$$android_content_Intent$getStringExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getString(name);
    }

    private final CharSequence $$robo$$android_content_Intent$getCharSequenceExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getCharSequence(name);
    }

    private final <T extends Parcelable> T $$robo$$android_content_Intent$getParcelableExtra(String name) {
        return this.mExtras == null ? null : (T)this.mExtras.getParcelable(name);
    }

    private final Parcelable[] $$robo$$android_content_Intent$getParcelableArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getParcelableArray(name);
    }

    private final <T extends Parcelable> ArrayList<T> $$robo$$android_content_Intent$getParcelableArrayListExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getParcelableArrayList(name);
    }

    private final Serializable $$robo$$android_content_Intent$getSerializableExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getSerializable(name);
    }

    private final ArrayList<Integer> $$robo$$android_content_Intent$getIntegerArrayListExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getIntegerArrayList(name);
    }

    private final ArrayList<String> $$robo$$android_content_Intent$getStringArrayListExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getStringArrayList(name);
    }

    private final ArrayList<CharSequence> $$robo$$android_content_Intent$getCharSequenceArrayListExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getCharSequenceArrayList(name);
    }

    private final boolean[] $$robo$$android_content_Intent$getBooleanArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getBooleanArray(name);
    }

    private final byte[] $$robo$$android_content_Intent$getByteArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getByteArray(name);
    }

    private final short[] $$robo$$android_content_Intent$getShortArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getShortArray(name);
    }

    private final char[] $$robo$$android_content_Intent$getCharArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getCharArray(name);
    }

    private final int[] $$robo$$android_content_Intent$getIntArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getIntArray(name);
    }

    private final long[] $$robo$$android_content_Intent$getLongArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getLongArray(name);
    }

    private final float[] $$robo$$android_content_Intent$getFloatArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getFloatArray(name);
    }

    private final double[] $$robo$$android_content_Intent$getDoubleArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getDoubleArray(name);
    }

    private final String[] $$robo$$android_content_Intent$getStringArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getStringArray(name);
    }

    private final CharSequence[] $$robo$$android_content_Intent$getCharSequenceArrayExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getCharSequenceArray(name);
    }

    private final Bundle $$robo$$android_content_Intent$getBundleExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getBundle(name);
    }

    @Deprecated
    private final IBinder $$robo$$android_content_Intent$getIBinderExtra(String name) {
        return this.mExtras == null ? null : this.mExtras.getIBinder(name);
    }

    @Deprecated
    private final Object $$robo$$android_content_Intent$getExtra(String name, Object defaultValue) {
        Object result2;
        Object result = defaultValue;
        if (this.mExtras != null && (result2 = this.mExtras.get(name)) != null) {
            result = result2;
        }
        return result;
    }

    private final Bundle $$robo$$android_content_Intent$getExtras() {
        return this.mExtras != null ? new Bundle(this.mExtras) : null;
    }

    private final int $$robo$$android_content_Intent$getFlags() {
        return this.mFlags;
    }

    private final boolean $$robo$$android_content_Intent$isExcludingStopped() {
        return (this.mFlags & 0x30) == 16;
    }

    private final String $$robo$$android_content_Intent$getPackage() {
        return this.mPackage;
    }

    private final ComponentName $$robo$$android_content_Intent$getComponent() {
        return this.mComponent;
    }

    private final Rect $$robo$$android_content_Intent$getSourceBounds() {
        return this.mSourceBounds;
    }

    private final ComponentName $$robo$$android_content_Intent$resolveActivity(PackageManager pm) {
        if (this.mComponent != null) {
            return this.mComponent;
        }
        ResolveInfo info = pm.resolveActivity(this, 65536);
        if (info != null) {
            return new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name);
        }
        return null;
    }

    private final ActivityInfo $$robo$$android_content_Intent$resolveActivityInfo(PackageManager pm, int flags) {
        ActivityInfo ai = null;
        if (this.mComponent != null) {
            try {
                ai = pm.getActivityInfo(this.mComponent, flags);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        } else {
            ResolveInfo info = pm.resolveActivity(this, 0x10000 | flags);
            if (info != null) {
                ai = info.activityInfo;
            }
        }
        return ai;
    }

    private final ComponentName $$robo$$android_content_Intent$resolveSystemService(PackageManager pm, int flags) {
        if (this.mComponent != null) {
            return this.mComponent;
        }
        List<ResolveInfo> results = pm.queryIntentServices(this, flags);
        if (results == null) {
            return null;
        }
        ComponentName comp = null;
        for (int i = 0; i < results.size(); ++i) {
            ResolveInfo ri = results.get(i);
            if ((ri.serviceInfo.applicationInfo.flags & 1) == 0) continue;
            ComponentName foundComp = new ComponentName(ri.serviceInfo.applicationInfo.packageName, ri.serviceInfo.name);
            if (comp != null) {
                throw new IllegalStateException("Multiple system services handle " + this + ": " + comp + ", " + foundComp);
            }
            comp = foundComp;
        }
        return comp;
    }

    private final Intent $$robo$$android_content_Intent$setAction(String action) {
        this.mAction = action != null ? action.intern() : null;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setData(Uri data) {
        this.mData = data;
        this.mType = null;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setDataAndNormalize(Uri data) {
        return this.setData(data.normalizeScheme());
    }

    private final Intent $$robo$$android_content_Intent$setType(String type) {
        this.mData = null;
        this.mType = type;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setTypeAndNormalize(String type) {
        return this.setType(Intent.normalizeMimeType(type));
    }

    private final Intent $$robo$$android_content_Intent$setDataAndType(Uri data, String type) {
        this.mData = data;
        this.mType = type;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setDataAndTypeAndNormalize(Uri data, String type) {
        return this.setDataAndType(data.normalizeScheme(), Intent.normalizeMimeType(type));
    }

    private final Intent $$robo$$android_content_Intent$addCategory(String category) {
        if (this.mCategories == null) {
            this.mCategories = new ArraySet();
        }
        this.mCategories.add(category.intern());
        return this;
    }

    private final void $$robo$$android_content_Intent$removeCategory(String category) {
        if (this.mCategories != null) {
            this.mCategories.remove(category);
            if (this.mCategories.size() == 0) {
                this.mCategories = null;
            }
        }
    }

    private final void $$robo$$android_content_Intent$setSelector(Intent selector) {
        if (selector == this) {
            throw new IllegalArgumentException("Intent being set as a selector of itself");
        }
        if (selector != null && this.mPackage != null) {
            throw new IllegalArgumentException("Can't set selector when package name is already set");
        }
        this.mSelector = selector;
    }

    private final void $$robo$$android_content_Intent$setClipData(ClipData clip) {
        this.mClipData = clip;
    }

    private final void $$robo$$android_content_Intent$setContentUserHint(int contentUserHint) {
        this.mContentUserHint = contentUserHint;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, boolean value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putBoolean(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, byte value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putByte(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, char value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putChar(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, short value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putShort(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, int value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putInt(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, long value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putLong(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, float value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putFloat(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, double value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putDouble(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, String value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putString(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, CharSequence value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putCharSequence(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, Parcelable value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putParcelable(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, Parcelable[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putParcelableArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putParcelableArrayListExtra(String name, ArrayList<? extends Parcelable> value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putParcelableArrayList(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putIntegerArrayListExtra(String name, ArrayList<Integer> value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putIntegerArrayList(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putStringArrayListExtra(String name, ArrayList<String> value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putStringArrayList(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putCharSequenceArrayListExtra(String name, ArrayList<CharSequence> value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putCharSequenceArrayList(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, Serializable value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putSerializable(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, boolean[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putBooleanArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, byte[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putByteArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, short[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putShortArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, char[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putCharArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, int[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putIntArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, long[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putLongArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, float[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putFloatArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, double[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putDoubleArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, String[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putStringArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, CharSequence[] value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putCharSequenceArray(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtra(String name, Bundle value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putBundle(name, value);
        return this;
    }

    @Deprecated
    private final Intent $$robo$$android_content_Intent$putExtra(String name, IBinder value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putIBinder(name, value);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtras(Intent src) {
        if (src.mExtras != null) {
            if (this.mExtras == null) {
                this.mExtras = new Bundle(src.mExtras);
            } else {
                this.mExtras.putAll(src.mExtras);
            }
        }
        return this;
    }

    private final Intent $$robo$$android_content_Intent$putExtras(Bundle extras) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putAll(extras);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$replaceExtras(Intent src) {
        this.mExtras = src.mExtras != null ? new Bundle(src.mExtras) : null;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$replaceExtras(Bundle extras) {
        this.mExtras = extras != null ? new Bundle(extras) : null;
        return this;
    }

    private final void $$robo$$android_content_Intent$removeExtra(String name) {
        if (this.mExtras != null) {
            this.mExtras.remove(name);
            if (this.mExtras.size() == 0) {
                this.mExtras = null;
            }
        }
    }

    private final Intent $$robo$$android_content_Intent$setFlags(int flags) {
        this.mFlags = flags;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$addFlags(int flags) {
        this.mFlags |= flags;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setPackage(String packageName) {
        if (packageName != null && this.mSelector != null) {
            throw new IllegalArgumentException("Can't set package name when selector is already set");
        }
        this.mPackage = packageName;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setComponent(ComponentName component) {
        this.mComponent = component;
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setClassName(Context packageContext, String className) {
        this.mComponent = new ComponentName(packageContext, className);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setClassName(String packageName, String className) {
        this.mComponent = new ComponentName(packageName, className);
        return this;
    }

    private final Intent $$robo$$android_content_Intent$setClass(Context packageContext, Class<?> cls) {
        this.mComponent = new ComponentName(packageContext, cls);
        return this;
    }

    private final void $$robo$$android_content_Intent$setSourceBounds(Rect r) {
        this.mSourceBounds = r != null ? new Rect(r) : null;
    }

    private final int $$robo$$android_content_Intent$fillIn(Intent other, int flags) {
        int changes = 0;
        boolean mayHaveCopiedUris = false;
        if (other.mAction != null && (this.mAction == null || (flags & 1) != 0)) {
            this.mAction = other.mAction;
            changes |= 1;
        }
        if ((other.mData != null || other.mType != null) && (this.mData == null && this.mType == null || (flags & 2) != 0)) {
            this.mData = other.mData;
            this.mType = other.mType;
            changes |= 2;
            mayHaveCopiedUris = true;
        }
        if (other.mCategories != null && (this.mCategories == null || (flags & 4) != 0)) {
            if (other.mCategories != null) {
                this.mCategories = new ArraySet(other.mCategories);
            }
            changes |= 4;
        }
        if (other.mPackage != null && (this.mPackage == null || (flags & 0x10) != 0) && this.mSelector == null) {
            this.mPackage = other.mPackage;
            changes |= 0x10;
        }
        if (other.mSelector != null && (flags & 0x40) != 0 && this.mPackage == null) {
            this.mSelector = new Intent(other.mSelector);
            this.mPackage = null;
            changes |= 0x40;
        }
        if (other.mClipData != null && (this.mClipData == null || (flags & 0x80) != 0)) {
            this.mClipData = other.mClipData;
            changes |= 0x80;
            mayHaveCopiedUris = true;
        }
        if (other.mComponent != null && (flags & 8) != 0) {
            this.mComponent = other.mComponent;
            changes |= 8;
        }
        this.mFlags |= other.mFlags;
        if (other.mSourceBounds != null && (this.mSourceBounds == null || (flags & 0x20) != 0)) {
            this.mSourceBounds = new Rect(other.mSourceBounds);
            changes |= 0x20;
        }
        if (this.mExtras == null) {
            if (other.mExtras != null) {
                this.mExtras = new Bundle(other.mExtras);
                mayHaveCopiedUris = true;
            }
        } else if (other.mExtras != null) {
            try {
                Bundle newb = new Bundle(other.mExtras);
                newb.putAll(this.mExtras);
                this.mExtras = newb;
                mayHaveCopiedUris = true;
            }
            catch (RuntimeException e) {
                Log.w("Intent", "Failure filling in extras", e);
            }
        }
        if (mayHaveCopiedUris && this.mContentUserHint == -2 && other.mContentUserHint != -2) {
            this.mContentUserHint = other.mContentUserHint;
        }
        return changes;
    }

    private final boolean $$robo$$android_content_Intent$filterEquals(Intent other) {
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.mAction, other.mAction)) {
            return false;
        }
        if (!Objects.equals(this.mData, other.mData)) {
            return false;
        }
        if (!Objects.equals(this.mType, other.mType)) {
            return false;
        }
        if (!Objects.equals(this.mPackage, other.mPackage)) {
            return false;
        }
        if (!Objects.equals(this.mComponent, other.mComponent)) {
            return false;
        }
        return Objects.equals(this.mCategories, other.mCategories);
    }

    private final int $$robo$$android_content_Intent$filterHashCode() {
        int code = 0;
        if (this.mAction != null) {
            code += this.mAction.hashCode();
        }
        if (this.mData != null) {
            code += this.mData.hashCode();
        }
        if (this.mType != null) {
            code += this.mType.hashCode();
        }
        if (this.mPackage != null) {
            code += this.mPackage.hashCode();
        }
        if (this.mComponent != null) {
            code += this.mComponent.hashCode();
        }
        if (this.mCategories != null) {
            code += this.mCategories.hashCode();
        }
        return code;
    }

    private final String $$robo$$android_content_Intent$toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("Intent { ");
        this.toShortString(b, true, true, true, false);
        b.append(" }");
        return b.toString();
    }

    private final String $$robo$$android_content_Intent$toInsecureString() {
        StringBuilder b = new StringBuilder(128);
        b.append("Intent { ");
        this.toShortString(b, false, true, true, false);
        b.append(" }");
        return b.toString();
    }

    private final String $$robo$$android_content_Intent$toInsecureStringWithClip() {
        StringBuilder b = new StringBuilder(128);
        b.append("Intent { ");
        this.toShortString(b, false, true, true, true);
        b.append(" }");
        return b.toString();
    }

    private final String $$robo$$android_content_Intent$toShortString(boolean secure, boolean comp, boolean extras, boolean clip) {
        StringBuilder b = new StringBuilder(128);
        this.toShortString(b, secure, comp, extras, clip);
        return b.toString();
    }

    private final void $$robo$$android_content_Intent$toShortString(StringBuilder b, boolean secure, boolean comp, boolean extras, boolean clip) {
        boolean first = true;
        if (this.mAction != null) {
            b.append("act=").append(this.mAction);
            first = false;
        }
        if (this.mCategories != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("cat=[");
            for (int i = 0; i < this.mCategories.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.mCategories.valueAt(i));
            }
            b.append("]");
        }
        if (this.mData != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("dat=");
            if (secure) {
                b.append(this.mData.toSafeString());
            } else {
                b.append(this.mData);
            }
        }
        if (this.mType != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("typ=").append(this.mType);
        }
        if (this.mFlags != 0) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("flg=0x").append(Integer.toHexString(this.mFlags));
        }
        if (this.mPackage != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("pkg=").append(this.mPackage);
        }
        if (comp && this.mComponent != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("cmp=").append(this.mComponent.flattenToShortString());
        }
        if (this.mSourceBounds != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("bnds=").append(this.mSourceBounds.toShortString());
        }
        if (this.mClipData != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            if (clip) {
                b.append("clip={");
                this.mClipData.toShortString(b);
                b.append('}');
            } else {
                b.append("(has clip)");
            }
        }
        if (extras && this.mExtras != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("(has extras)");
        }
        if (this.mContentUserHint != -2) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("u=").append(this.mContentUserHint);
        }
        if (this.mSelector != null) {
            b.append(" sel=");
            this.mSelector.toShortString(b, secure, comp, extras, clip);
            b.append("}");
        }
    }

    @Deprecated
    private final String $$robo$$android_content_Intent$toURI() {
        return this.toUri(0);
    }

    private final String $$robo$$android_content_Intent$toUri(int flags) {
        StringBuilder uri = new StringBuilder(128);
        String scheme = null;
        if (this.mData != null) {
            String data = this.mData.toString();
            if ((flags & 1) != 0) {
                int N = data.length();
                for (int i = 0; i < N; ++i) {
                    char c = data.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '-') continue;
                    if (c != ':' || i <= 0) break;
                    scheme = data.substring(0, i);
                    uri.append("intent:");
                    data = data.substring(i + 1);
                    break;
                }
            }
            uri.append(data);
        } else if ((flags & 1) != 0) {
            uri.append("intent:");
        }
        uri.append("#Intent;");
        this.toUriInner(uri, scheme, flags);
        if (this.mSelector != null) {
            uri.append("SEL;");
            this.mSelector.toUriInner(uri, null, flags);
        }
        uri.append("end");
        return uri.toString();
    }

    private final void $$robo$$android_content_Intent$toUriInner(StringBuilder uri, String scheme, int flags) {
        if (scheme != null) {
            uri.append("scheme=").append(scheme).append(';');
        }
        if (this.mAction != null) {
            uri.append("action=").append(Uri.encode(this.mAction)).append(';');
        }
        if (this.mCategories != null) {
            for (int i = 0; i < this.mCategories.size(); ++i) {
                uri.append("category=").append(Uri.encode(this.mCategories.valueAt(i))).append(';');
            }
        }
        if (this.mType != null) {
            uri.append("type=").append(Uri.encode(this.mType, "/")).append(';');
        }
        if (this.mFlags != 0) {
            uri.append("launchFlags=0x").append(Integer.toHexString(this.mFlags)).append(';');
        }
        if (this.mPackage != null) {
            uri.append("package=").append(Uri.encode(this.mPackage)).append(';');
        }
        if (this.mComponent != null) {
            uri.append("component=").append(Uri.encode(this.mComponent.flattenToShortString(), "/")).append(';');
        }
        if (this.mSourceBounds != null) {
            uri.append("sourceBounds=").append(Uri.encode(this.mSourceBounds.flattenToString())).append(';');
        }
        if (this.mExtras != null) {
            for (String key : this.mExtras.keySet()) {
                Object value = this.mExtras.get(key);
                int entryType = value instanceof String ? 83 : (value instanceof Boolean ? 66 : (value instanceof Byte ? 98 : (value instanceof Character ? 99 : (value instanceof Double ? 100 : (value instanceof Float ? 102 : (value instanceof Integer ? 105 : (value instanceof Long ? 108 : (value instanceof Short ? 115 : 0))))))));
                if (entryType == 0) continue;
                uri.append((char)entryType);
                uri.append('.');
                uri.append(Uri.encode(key));
                uri.append('=');
                uri.append(Uri.encode(value.toString()));
                uri.append(';');
            }
        }
    }

    private final int $$robo$$android_content_Intent$describeContents() {
        return this.mExtras != null ? this.mExtras.describeContents() : 0;
    }

    private final void $$robo$$android_content_Intent$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAction);
        Uri.writeToParcel(out, this.mData);
        out.writeString(this.mType);
        out.writeInt(this.mFlags);
        out.writeString(this.mPackage);
        ComponentName.writeToParcel(this.mComponent, out);
        if (this.mSourceBounds != null) {
            out.writeInt(1);
            this.mSourceBounds.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
        if (this.mCategories != null) {
            int N = this.mCategories.size();
            out.writeInt(N);
            for (int i = 0; i < N; ++i) {
                out.writeString(this.mCategories.valueAt(i));
            }
        } else {
            out.writeInt(0);
        }
        if (this.mSelector != null) {
            out.writeInt(1);
            this.mSelector.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
        if (this.mClipData != null) {
            out.writeInt(1);
            this.mClipData.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.mContentUserHint);
        out.writeBundle(this.mExtras);
    }

    private void $$robo$$android_content_Intent$__constructor__(Parcel in) {
        this.mContentUserHint = -2;
        this.readFromParcel(in);
    }

    private final void $$robo$$android_content_Intent$readFromParcel(Parcel in) {
        int N;
        this.setAction(in.readString());
        this.mData = Uri.CREATOR.createFromParcel(in);
        this.mType = in.readString();
        this.mFlags = in.readInt();
        this.mPackage = in.readString();
        this.mComponent = ComponentName.readFromParcel(in);
        if (in.readInt() != 0) {
            this.mSourceBounds = Rect.CREATOR.createFromParcel(in);
        }
        if ((N = in.readInt()) > 0) {
            this.mCategories = new ArraySet();
            for (int i = 0; i < N; ++i) {
                this.mCategories.add(in.readString().intern());
            }
        } else {
            this.mCategories = null;
        }
        if (in.readInt() != 0) {
            this.mSelector = new Intent(in);
        }
        if (in.readInt() != 0) {
            this.mClipData = new ClipData(in);
        }
        this.mContentUserHint = in.readInt();
        this.mExtras = in.readBundle();
    }

    private static final Intent $$robo$$android_content_Intent$parseIntent(Resources resources, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        Intent intent = new Intent();
        TypedArray sa = resources.obtainAttributes(attrs, R.styleable.Intent);
        intent.setAction(sa.getString(2));
        String data = sa.getString(3);
        String mimeType = sa.getString(1);
        intent.setDataAndType(data != null ? Uri.parse(data) : null, mimeType);
        String packageName = sa.getString(0);
        String className = sa.getString(4);
        if (packageName != null && className != null) {
            intent.setComponent(new ComponentName(packageName, className));
        }
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("categories")) {
                sa = resources.obtainAttributes(attrs, R.styleable.IntentCategory);
                String cat = sa.getString(0);
                sa.recycle();
                if (cat != null) {
                    intent.addCategory(cat);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (nodeName.equals("extra")) {
                if (intent.mExtras == null) {
                    intent.mExtras = new Bundle();
                }
                resources.parseBundleExtra("extra", attrs, intent.mExtras);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return intent;
    }

    private final void $$robo$$android_content_Intent$saveToXml(XmlSerializer out) throws IOException {
        if (this.mAction != null) {
            out.attribute(null, "action", this.mAction);
        }
        if (this.mData != null) {
            out.attribute(null, "data", this.mData.toString());
        }
        if (this.mType != null) {
            out.attribute(null, "type", this.mType);
        }
        if (this.mComponent != null) {
            out.attribute(null, "component", this.mComponent.flattenToShortString());
        }
        out.attribute(null, "flags", Integer.toHexString(this.getFlags()));
        if (this.mCategories != null) {
            out.startTag(null, "categories");
            for (int categoryNdx = this.mCategories.size() - 1; categoryNdx >= 0; --categoryNdx) {
                out.attribute(null, "category", this.mCategories.valueAt(categoryNdx));
            }
            out.endTag(null, "categories");
        }
    }

    private static final Intent $$robo$$android_content_Intent$restoreFromXml(XmlPullParser in) throws IOException, XmlPullParserException {
        int event;
        Intent intent = new Intent();
        int outerDepth = in.getDepth();
        int attrCount = in.getAttributeCount();
        for (int attrNdx = attrCount - 1; attrNdx >= 0; --attrNdx) {
            String attrName = in.getAttributeName(attrNdx);
            String attrValue = in.getAttributeValue(attrNdx);
            if ("action".equals(attrName)) {
                intent.setAction(attrValue);
                continue;
            }
            if ("data".equals(attrName)) {
                intent.setData(Uri.parse(attrValue));
                continue;
            }
            if ("type".equals(attrName)) {
                intent.setType(attrValue);
                continue;
            }
            if ("component".equals(attrName)) {
                intent.setComponent(ComponentName.unflattenFromString(attrValue));
                continue;
            }
            if ("flags".equals(attrName)) {
                intent.setFlags(Integer.valueOf(attrValue, 16));
                continue;
            }
            Log.e("Intent", "restoreFromXml: unknown attribute=" + attrName);
        }
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() < outerDepth)) {
            if (event != 2) continue;
            String name = in.getName();
            if ("categories".equals(name)) {
                attrCount = in.getAttributeCount();
                for (int attrNdx = attrCount - 1; attrNdx >= 0; --attrNdx) {
                    intent.addCategory(in.getAttributeValue(attrNdx));
                }
                continue;
            }
            Log.w("Intent", "restoreFromXml: unknown name=" + name);
            XmlUtils.skipCurrentTag(in);
        }
        return intent;
    }

    private static final String $$robo$$android_content_Intent$normalizeMimeType(String type) {
        if (type == null) {
            return null;
        }
        int semicolonIndex = (type = type.trim().toLowerCase(Locale.ROOT)).indexOf(59);
        if (semicolonIndex != -1) {
            type = type.substring(0, semicolonIndex);
        }
        return type;
    }

    private final void $$robo$$android_content_Intent$prepareToLeaveProcess() {
        this.setAllowFds(false);
        if (this.mSelector != null) {
            this.mSelector.prepareToLeaveProcess();
        }
        if (this.mClipData != null) {
            this.mClipData.prepareToLeaveProcess();
        }
        if (this.mData != null && StrictMode.vmFileUriExposureEnabled() && ("android.intent.action.VIEW".equals(this.mAction) || "android.intent.action.EDIT".equals(this.mAction) || "android.intent.action.ATTACH_DATA".equals(this.mAction))) {
            this.mData.checkFileUriExposed("Intent.getData()");
        }
    }

    private final void $$robo$$android_content_Intent$prepareToEnterProcess() {
        if (this.mContentUserHint != -2) {
            this.fixUris(this.mContentUserHint);
            this.mContentUserHint = -2;
        }
    }

    private final void $$robo$$android_content_Intent$fixUris(int contentUserHint) {
        Uri output;
        String action;
        Uri data = this.getData();
        if (data != null) {
            this.mData = ContentProvider.maybeAddUserId(data, contentUserHint);
        }
        if (this.mClipData != null) {
            this.mClipData.fixUris(contentUserHint);
        }
        if ("android.intent.action.SEND".equals(action = this.getAction())) {
            Uri stream = (Uri)this.getParcelableExtra("android.intent.extra.STREAM");
            if (stream != null) {
                this.putExtra("android.intent.extra.STREAM", ContentProvider.maybeAddUserId(stream, contentUserHint));
            }
        } else if ("android.intent.action.SEND_MULTIPLE".equals(action)) {
            ArrayList streams = this.getParcelableArrayListExtra("android.intent.extra.STREAM");
            if (streams != null) {
                ArrayList<Uri> newStreams = new ArrayList<Uri>();
                for (int i = 0; i < streams.size(); ++i) {
                    newStreams.add(ContentProvider.maybeAddUserId((Uri)streams.get(i), contentUserHint));
                }
                this.putParcelableArrayListExtra("android.intent.extra.STREAM", newStreams);
            }
        } else if (("android.media.action.IMAGE_CAPTURE".equals(action) || "android.media.action.IMAGE_CAPTURE_SECURE".equals(action) || "android.media.action.VIDEO_CAPTURE".equals(action)) && (output = (Uri)this.getParcelableExtra("output")) != null) {
            this.putExtra("output", ContentProvider.maybeAddUserId(output, contentUserHint));
        }
    }

    private final boolean $$robo$$android_content_Intent$migrateExtraStreamToClipData() {
        if (this.mExtras != null && this.mExtras.isParcelled()) {
            return false;
        }
        if (this.getClipData() != null) {
            return false;
        }
        String action = this.getAction();
        if ("android.intent.action.CHOOSER".equals(action)) {
            boolean migrated = false;
            try {
                Intent intent = (Intent)this.getParcelableExtra("android.intent.extra.INTENT");
                if (intent != null) {
                    migrated |= intent.migrateExtraStreamToClipData();
                }
            }
            catch (ClassCastException intent) {
                // empty catch block
            }
            try {
                Parcelable[] intents = this.getParcelableArrayExtra("android.intent.extra.INITIAL_INTENTS");
                if (intents != null) {
                    for (int i = 0; i < intents.length; ++i) {
                        Intent intent = (Intent)intents[i];
                        if (intent == null) continue;
                        migrated |= intent.migrateExtraStreamToClipData();
                    }
                }
            }
            catch (ClassCastException intents) {
                // empty catch block
            }
            return migrated;
        }
        if ("android.intent.action.SEND".equals(action)) {
            try {
                Uri stream = (Uri)this.getParcelableExtra("android.intent.extra.STREAM");
                CharSequence text = this.getCharSequenceExtra("android.intent.extra.TEXT");
                String htmlText = this.getStringExtra("android.intent.extra.HTML_TEXT");
                if (stream != null || text != null || htmlText != null) {
                    ClipData clipData = new ClipData(null, new String[]{this.getType()}, new ClipData.Item(text, htmlText, null, stream));
                    this.setClipData(clipData);
                    this.addFlags(1);
                    return true;
                }
            }
            catch (ClassCastException stream) {}
        } else if ("android.intent.action.SEND_MULTIPLE".equals(action)) {
            try {
                ArrayList<Uri> streams = this.getParcelableArrayListExtra("android.intent.extra.STREAM");
                ArrayList<CharSequence> texts = this.getCharSequenceArrayListExtra("android.intent.extra.TEXT");
                ArrayList<String> htmlTexts = this.getStringArrayListExtra("android.intent.extra.HTML_TEXT");
                int num = -1;
                if (streams != null) {
                    num = streams.size();
                }
                if (texts != null) {
                    if (num >= 0 && num != texts.size()) {
                        return false;
                    }
                    num = texts.size();
                }
                if (htmlTexts != null) {
                    if (num >= 0 && num != htmlTexts.size()) {
                        return false;
                    }
                    num = htmlTexts.size();
                }
                if (num > 0) {
                    ClipData clipData = new ClipData(null, new String[]{this.getType()}, Intent.makeClipItem(streams, texts, htmlTexts, 0));
                    for (int i = 1; i < num; ++i) {
                        clipData.addItem(Intent.makeClipItem(streams, texts, htmlTexts, i));
                    }
                    this.setClipData(clipData);
                    this.addFlags(1);
                    return true;
                }
            }
            catch (ClassCastException streams) {}
        } else if ("android.media.action.IMAGE_CAPTURE".equals(action) || "android.media.action.IMAGE_CAPTURE_SECURE".equals(action) || "android.media.action.VIDEO_CAPTURE".equals(action)) {
            Uri output;
            try {
                output = (Uri)this.getParcelableExtra("output");
            }
            catch (ClassCastException e) {
                return false;
            }
            if (output != null) {
                this.setClipData(ClipData.newRawUri("", output));
                this.addFlags(3);
                return true;
            }
        }
        return false;
    }

    private static final ClipData.Item $$robo$$android_content_Intent$makeClipItem(ArrayList<Uri> streams, ArrayList<CharSequence> texts, ArrayList<String> htmlTexts, int which) {
        Uri uri = streams != null ? streams.get(which) : null;
        CharSequence text = texts != null ? texts.get(which) : null;
        String htmlText = htmlTexts != null ? htmlTexts.get(which) : null;
        return new ClipData.Item(text, htmlText, null, uri);
    }

    private final boolean $$robo$$android_content_Intent$isDocument() {
        return (this.mFlags & 0x80000) == 524288;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Intent>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_Intent_1$__constructor__() {
            }

            private final Intent $$robo$$android_content_Intent_1$createFromParcel(Parcel in) {
                return new Intent(in);
            }

            private final Intent[] $$robo$$android_content_Intent_1$newArray(int size) {
                return new Intent[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_Intent_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent_1$__constructor__(), 0, this);
            }

            @Override
            public Intent createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_Intent_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Intent[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_Intent_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static Intent createChooser(Intent intent, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("createChooser", $$robo$$android_content_Intent$createChooser(android.content.Intent java.lang.CharSequence ), 0, (Intent)intent, (CharSequence)charSequence);
    }

    public static boolean isAccessUriMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAccessUriMode", $$robo$$android_content_Intent$isAccessUriMode(int ), 0, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_content_Intent$__constructor__();
    }

    public Intent() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(), 0, this);
    }

    private void __constructor__(Intent intent) {
        this.$$robo$$android_content_Intent$__constructor__(intent);
    }

    public Intent(Intent intent) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(android.content.Intent ), 0, this, intent);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_content_Intent$clone(), 0, this);
    }

    private void __constructor__(Intent intent, boolean bl) {
        this.$$robo$$android_content_Intent$__constructor__(intent, bl);
    }

    private Intent(Intent intent, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(android.content.Intent boolean ), 0, this, intent, bl);
    }

    public Intent cloneFilter() {
        return InvokeDynamicSupport.bootstrap("cloneFilter", $$robo$$android_content_Intent$cloneFilter(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_content_Intent$__constructor__(string2);
    }

    public Intent(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, Uri uri) {
        this.$$robo$$android_content_Intent$__constructor__(string2, uri);
    }

    public Intent(String string2, Uri uri) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(java.lang.String android.net.Uri ), 0, this, string2, uri);
    }

    private void __constructor__(Context context, Class<?> clazz) {
        this.$$robo$$android_content_Intent$__constructor__(context, clazz);
    }

    public Intent(Context context, Class<?> clazz) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(android.content.Context java.lang.Class<?> ), 0, this, context, clazz);
    }

    private void __constructor__(String string2, Uri uri, Context context, Class<?> clazz) {
        this.$$robo$$android_content_Intent$__constructor__(string2, uri, context, clazz);
    }

    public Intent(String string2, Uri uri, Context context, Class<?> clazz) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(java.lang.String android.net.Uri android.content.Context java.lang.Class<?> ), 0, this, string2, uri, context, clazz);
    }

    public static Intent makeMainActivity(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("makeMainActivity", $$robo$$android_content_Intent$makeMainActivity(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    public static Intent makeMainSelectorActivity(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("makeMainSelectorActivity", $$robo$$android_content_Intent$makeMainSelectorActivity(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Intent makeRestartActivityTask(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("makeRestartActivityTask", $$robo$$android_content_Intent$makeRestartActivityTask(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    @Deprecated
    public static Intent getIntent(String string2) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrapStatic("getIntent", $$robo$$android_content_Intent$getIntent(java.lang.String ), 0, (String)string2);
    }

    public static Intent parseUri(String string2, int n) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrapStatic("parseUri", $$robo$$android_content_Intent$parseUri(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static Intent getIntentOld(String string2) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrapStatic("getIntentOld", $$robo$$android_content_Intent$getIntentOld(java.lang.String ), 0, (String)string2);
    }

    public String getAction() {
        return InvokeDynamicSupport.bootstrap("getAction", $$robo$$android_content_Intent$getAction(), 0, this);
    }

    public Uri getData() {
        return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_content_Intent$getData(), 0, this);
    }

    public String getDataString() {
        return InvokeDynamicSupport.bootstrap("getDataString", $$robo$$android_content_Intent$getDataString(), 0, this);
    }

    public String getScheme() {
        return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_content_Intent$getScheme(), 0, this);
    }

    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_Intent$getType(), 0, this);
    }

    public String resolveType(Context context) {
        return InvokeDynamicSupport.bootstrap("resolveType", $$robo$$android_content_Intent$resolveType(android.content.Context ), 0, this, context);
    }

    public String resolveType(ContentResolver contentResolver) {
        return InvokeDynamicSupport.bootstrap("resolveType", $$robo$$android_content_Intent$resolveType(android.content.ContentResolver ), 0, this, contentResolver);
    }

    public String resolveTypeIfNeeded(ContentResolver contentResolver) {
        return InvokeDynamicSupport.bootstrap("resolveTypeIfNeeded", $$robo$$android_content_Intent$resolveTypeIfNeeded(android.content.ContentResolver ), 0, this, contentResolver);
    }

    public boolean hasCategory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCategory", $$robo$$android_content_Intent$hasCategory(java.lang.String ), 0, this, string2);
    }

    public Set<String> getCategories() {
        return InvokeDynamicSupport.bootstrap("getCategories", $$robo$$android_content_Intent$getCategories(), 0, this);
    }

    public Intent getSelector() {
        return InvokeDynamicSupport.bootstrap("getSelector", $$robo$$android_content_Intent$getSelector(), 0, this);
    }

    public ClipData getClipData() {
        return InvokeDynamicSupport.bootstrap("getClipData", $$robo$$android_content_Intent$getClipData(), 0, this);
    }

    public int getContentUserHint() {
        return (int)InvokeDynamicSupport.bootstrap("getContentUserHint", $$robo$$android_content_Intent$getContentUserHint(), 0, this);
    }

    public void setExtrasClassLoader(ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("setExtrasClassLoader", $$robo$$android_content_Intent$setExtrasClassLoader(java.lang.ClassLoader ), 0, this, classLoader);
    }

    public boolean hasExtra(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasExtra", $$robo$$android_content_Intent$hasExtra(java.lang.String ), 0, this, string2);
    }

    public boolean hasFileDescriptors() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFileDescriptors", $$robo$$android_content_Intent$hasFileDescriptors(), 0, this);
    }

    public void setAllowFds(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowFds", $$robo$$android_content_Intent$setAllowFds(boolean ), 0, this, bl);
    }

    @Deprecated
    public Object getExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getExtra", $$robo$$android_content_Intent$getExtra(java.lang.String ), 0, this, string2);
    }

    public boolean getBooleanExtra(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBooleanExtra", $$robo$$android_content_Intent$getBooleanExtra(java.lang.String boolean ), 0, this, string2, bl);
    }

    public byte getByteExtra(String string2, byte by) {
        return (byte)InvokeDynamicSupport.bootstrap("getByteExtra", $$robo$$android_content_Intent$getByteExtra(java.lang.String byte ), 0, this, string2, by);
    }

    public short getShortExtra(String string2, short s) {
        return (short)InvokeDynamicSupport.bootstrap("getShortExtra", $$robo$$android_content_Intent$getShortExtra(java.lang.String short ), 0, this, string2, s);
    }

    public char getCharExtra(String string2, char c) {
        return (char)InvokeDynamicSupport.bootstrap("getCharExtra", $$robo$$android_content_Intent$getCharExtra(java.lang.String char ), 0, this, string2, c);
    }

    public int getIntExtra(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIntExtra", $$robo$$android_content_Intent$getIntExtra(java.lang.String int ), 0, this, string2, n);
    }

    public long getLongExtra(String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getLongExtra", $$robo$$android_content_Intent$getLongExtra(java.lang.String long ), 0, this, string2, l);
    }

    public float getFloatExtra(String string2, float f) {
        return (float)InvokeDynamicSupport.bootstrap("getFloatExtra", $$robo$$android_content_Intent$getFloatExtra(java.lang.String float ), 0, this, string2, f);
    }

    public double getDoubleExtra(String string2, double d) {
        return (double)InvokeDynamicSupport.bootstrap("getDoubleExtra", $$robo$$android_content_Intent$getDoubleExtra(java.lang.String double ), 0, this, string2, d);
    }

    public String getStringExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getStringExtra", $$robo$$android_content_Intent$getStringExtra(java.lang.String ), 0, this, string2);
    }

    public CharSequence getCharSequenceExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getCharSequenceExtra", $$robo$$android_content_Intent$getCharSequenceExtra(java.lang.String ), 0, this, string2);
    }

    public <T extends Parcelable> T getParcelableExtra(String string2) {
        return (T)InvokeDynamicSupport.bootstrap("getParcelableExtra", $$robo$$android_content_Intent$getParcelableExtra(java.lang.String ), 0, this, string2);
    }

    public Parcelable[] getParcelableArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getParcelableArrayExtra", $$robo$$android_content_Intent$getParcelableArrayExtra(java.lang.String ), 0, this, string2);
    }

    public <T extends Parcelable> ArrayList<T> getParcelableArrayListExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getParcelableArrayListExtra", $$robo$$android_content_Intent$getParcelableArrayListExtra(java.lang.String ), 0, this, string2);
    }

    public Serializable getSerializableExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getSerializableExtra", $$robo$$android_content_Intent$getSerializableExtra(java.lang.String ), 0, this, string2);
    }

    public ArrayList<Integer> getIntegerArrayListExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getIntegerArrayListExtra", $$robo$$android_content_Intent$getIntegerArrayListExtra(java.lang.String ), 0, this, string2);
    }

    public ArrayList<String> getStringArrayListExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getStringArrayListExtra", $$robo$$android_content_Intent$getStringArrayListExtra(java.lang.String ), 0, this, string2);
    }

    public ArrayList<CharSequence> getCharSequenceArrayListExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getCharSequenceArrayListExtra", $$robo$$android_content_Intent$getCharSequenceArrayListExtra(java.lang.String ), 0, this, string2);
    }

    public boolean[] getBooleanArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getBooleanArrayExtra", $$robo$$android_content_Intent$getBooleanArrayExtra(java.lang.String ), 0, this, string2);
    }

    public byte[] getByteArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getByteArrayExtra", $$robo$$android_content_Intent$getByteArrayExtra(java.lang.String ), 0, this, string2);
    }

    public short[] getShortArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getShortArrayExtra", $$robo$$android_content_Intent$getShortArrayExtra(java.lang.String ), 0, this, string2);
    }

    public char[] getCharArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getCharArrayExtra", $$robo$$android_content_Intent$getCharArrayExtra(java.lang.String ), 0, this, string2);
    }

    public int[] getIntArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getIntArrayExtra", $$robo$$android_content_Intent$getIntArrayExtra(java.lang.String ), 0, this, string2);
    }

    public long[] getLongArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getLongArrayExtra", $$robo$$android_content_Intent$getLongArrayExtra(java.lang.String ), 0, this, string2);
    }

    public float[] getFloatArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getFloatArrayExtra", $$robo$$android_content_Intent$getFloatArrayExtra(java.lang.String ), 0, this, string2);
    }

    public double[] getDoubleArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getDoubleArrayExtra", $$robo$$android_content_Intent$getDoubleArrayExtra(java.lang.String ), 0, this, string2);
    }

    public String[] getStringArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getStringArrayExtra", $$robo$$android_content_Intent$getStringArrayExtra(java.lang.String ), 0, this, string2);
    }

    public CharSequence[] getCharSequenceArrayExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getCharSequenceArrayExtra", $$robo$$android_content_Intent$getCharSequenceArrayExtra(java.lang.String ), 0, this, string2);
    }

    public Bundle getBundleExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getBundleExtra", $$robo$$android_content_Intent$getBundleExtra(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public IBinder getIBinderExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getIBinderExtra", $$robo$$android_content_Intent$getIBinderExtra(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public Object getExtra(String string2, Object object) {
        return InvokeDynamicSupport.bootstrap("getExtra", $$robo$$android_content_Intent$getExtra(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_Intent$getExtras(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_content_Intent$getFlags(), 0, this);
    }

    public boolean isExcludingStopped() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExcludingStopped", $$robo$$android_content_Intent$isExcludingStopped(), 0, this);
    }

    public String getPackage() {
        return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$android_content_Intent$getPackage(), 0, this);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_content_Intent$getComponent(), 0, this);
    }

    public Rect getSourceBounds() {
        return InvokeDynamicSupport.bootstrap("getSourceBounds", $$robo$$android_content_Intent$getSourceBounds(), 0, this);
    }

    public ComponentName resolveActivity(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("resolveActivity", $$robo$$android_content_Intent$resolveActivity(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public ActivityInfo resolveActivityInfo(PackageManager packageManager, int n) {
        return InvokeDynamicSupport.bootstrap("resolveActivityInfo", $$robo$$android_content_Intent$resolveActivityInfo(android.content.pm.PackageManager int ), 0, this, packageManager, n);
    }

    public ComponentName resolveSystemService(PackageManager packageManager, int n) {
        return InvokeDynamicSupport.bootstrap("resolveSystemService", $$robo$$android_content_Intent$resolveSystemService(android.content.pm.PackageManager int ), 0, this, packageManager, n);
    }

    public Intent setAction(String string2) {
        return InvokeDynamicSupport.bootstrap("setAction", $$robo$$android_content_Intent$setAction(java.lang.String ), 0, this, string2);
    }

    public Intent setData(Uri uri) {
        return InvokeDynamicSupport.bootstrap("setData", $$robo$$android_content_Intent$setData(android.net.Uri ), 0, this, uri);
    }

    public Intent setDataAndNormalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("setDataAndNormalize", $$robo$$android_content_Intent$setDataAndNormalize(android.net.Uri ), 0, this, uri);
    }

    public Intent setType(String string2) {
        return InvokeDynamicSupport.bootstrap("setType", $$robo$$android_content_Intent$setType(java.lang.String ), 0, this, string2);
    }

    public Intent setTypeAndNormalize(String string2) {
        return InvokeDynamicSupport.bootstrap("setTypeAndNormalize", $$robo$$android_content_Intent$setTypeAndNormalize(java.lang.String ), 0, this, string2);
    }

    public Intent setDataAndType(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrap("setDataAndType", $$robo$$android_content_Intent$setDataAndType(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public Intent setDataAndTypeAndNormalize(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrap("setDataAndTypeAndNormalize", $$robo$$android_content_Intent$setDataAndTypeAndNormalize(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public Intent addCategory(String string2) {
        return InvokeDynamicSupport.bootstrap("addCategory", $$robo$$android_content_Intent$addCategory(java.lang.String ), 0, this, string2);
    }

    public void removeCategory(String string2) {
        InvokeDynamicSupport.bootstrap("removeCategory", $$robo$$android_content_Intent$removeCategory(java.lang.String ), 0, this, string2);
    }

    public void setSelector(Intent intent) {
        InvokeDynamicSupport.bootstrap("setSelector", $$robo$$android_content_Intent$setSelector(android.content.Intent ), 0, this, intent);
    }

    public void setClipData(ClipData clipData) {
        InvokeDynamicSupport.bootstrap("setClipData", $$robo$$android_content_Intent$setClipData(android.content.ClipData ), 0, this, clipData);
    }

    public void setContentUserHint(int n) {
        InvokeDynamicSupport.bootstrap("setContentUserHint", $$robo$$android_content_Intent$setContentUserHint(int ), 0, this, n);
    }

    public Intent putExtra(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String boolean ), 0, this, string2, bl);
    }

    public Intent putExtra(String string2, byte by) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String byte ), 0, this, string2, by);
    }

    public Intent putExtra(String string2, char c) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String char ), 0, this, string2, c);
    }

    public Intent putExtra(String string2, short s) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String short ), 0, this, string2, s);
    }

    public Intent putExtra(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String int ), 0, this, string2, n);
    }

    public Intent putExtra(String string2, long l) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String long ), 0, this, string2, l);
    }

    public Intent putExtra(String string2, float f) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String float ), 0, this, string2, f);
    }

    public Intent putExtra(String string2, double d) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String double ), 0, this, string2, d);
    }

    public Intent putExtra(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public Intent putExtra(String string2, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String java.lang.CharSequence ), 0, this, string2, charSequence);
    }

    public Intent putExtra(String string2, Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String android.os.Parcelable ), 0, this, string2, parcelable);
    }

    public Intent putExtra(String string2, Parcelable[] parcelableArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String android.os.Parcelable[] ), 0, this, string2, parcelableArray);
    }

    public Intent putParcelableArrayListExtra(String string2, ArrayList<? extends Parcelable> arrayList) {
        return InvokeDynamicSupport.bootstrap("putParcelableArrayListExtra", $$robo$$android_content_Intent$putParcelableArrayListExtra(java.lang.String java.util.ArrayList<? extends android.os.Parcelable> ), 0, this, string2, arrayList);
    }

    public Intent putIntegerArrayListExtra(String string2, ArrayList<Integer> arrayList) {
        return InvokeDynamicSupport.bootstrap("putIntegerArrayListExtra", $$robo$$android_content_Intent$putIntegerArrayListExtra(java.lang.String java.util.ArrayList<java.lang.Integer> ), 0, this, string2, arrayList);
    }

    public Intent putStringArrayListExtra(String string2, ArrayList<String> arrayList) {
        return InvokeDynamicSupport.bootstrap("putStringArrayListExtra", $$robo$$android_content_Intent$putStringArrayListExtra(java.lang.String java.util.ArrayList<java.lang.String> ), 0, this, string2, arrayList);
    }

    public Intent putCharSequenceArrayListExtra(String string2, ArrayList<CharSequence> arrayList) {
        return InvokeDynamicSupport.bootstrap("putCharSequenceArrayListExtra", $$robo$$android_content_Intent$putCharSequenceArrayListExtra(java.lang.String java.util.ArrayList<java.lang.CharSequence> ), 0, this, string2, arrayList);
    }

    public Intent putExtra(String string2, Serializable serializable) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String java.io.Serializable ), 0, this, string2, serializable);
    }

    public Intent putExtra(String string2, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String boolean[] ), 0, this, string2, blArray);
    }

    public Intent putExtra(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String byte[] ), 0, this, string2, byArray);
    }

    public Intent putExtra(String string2, short[] sArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String short[] ), 0, this, string2, sArray);
    }

    public Intent putExtra(String string2, char[] cArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String char[] ), 0, this, string2, cArray);
    }

    public Intent putExtra(String string2, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String int[] ), 0, this, string2, nArray);
    }

    public Intent putExtra(String string2, long[] lArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String long[] ), 0, this, string2, lArray);
    }

    public Intent putExtra(String string2, float[] fArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String float[] ), 0, this, string2, fArray);
    }

    public Intent putExtra(String string2, double[] dArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String double[] ), 0, this, string2, dArray);
    }

    public Intent putExtra(String string2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    public Intent putExtra(String string2, CharSequence[] charSequenceArray) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String java.lang.CharSequence[] ), 0, this, string2, charSequenceArray);
    }

    public Intent putExtra(String string2, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Deprecated
    public Intent putExtra(String string2, IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_content_Intent$putExtra(java.lang.String android.os.IBinder ), 0, this, string2, iBinder);
    }

    public Intent putExtras(Intent intent) {
        return InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_content_Intent$putExtras(android.content.Intent ), 0, this, intent);
    }

    public Intent putExtras(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_content_Intent$putExtras(android.os.Bundle ), 0, this, bundle);
    }

    public Intent replaceExtras(Intent intent) {
        return InvokeDynamicSupport.bootstrap("replaceExtras", $$robo$$android_content_Intent$replaceExtras(android.content.Intent ), 0, this, intent);
    }

    public Intent replaceExtras(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("replaceExtras", $$robo$$android_content_Intent$replaceExtras(android.os.Bundle ), 0, this, bundle);
    }

    public void removeExtra(String string2) {
        InvokeDynamicSupport.bootstrap("removeExtra", $$robo$$android_content_Intent$removeExtra(java.lang.String ), 0, this, string2);
    }

    public Intent setFlags(int n) {
        return InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_content_Intent$setFlags(int ), 0, this, n);
    }

    public Intent addFlags(int n) {
        return InvokeDynamicSupport.bootstrap("addFlags", $$robo$$android_content_Intent$addFlags(int ), 0, this, n);
    }

    public Intent setPackage(String string2) {
        return InvokeDynamicSupport.bootstrap("setPackage", $$robo$$android_content_Intent$setPackage(java.lang.String ), 0, this, string2);
    }

    public Intent setComponent(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("setComponent", $$robo$$android_content_Intent$setComponent(android.content.ComponentName ), 0, this, componentName);
    }

    public Intent setClassName(Context context, String string2) {
        return InvokeDynamicSupport.bootstrap("setClassName", $$robo$$android_content_Intent$setClassName(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    public Intent setClassName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("setClassName", $$robo$$android_content_Intent$setClassName(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public Intent setClass(Context context, Class<?> clazz) {
        return InvokeDynamicSupport.bootstrap("setClass", $$robo$$android_content_Intent$setClass(android.content.Context java.lang.Class<?> ), 0, this, context, clazz);
    }

    public void setSourceBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("setSourceBounds", $$robo$$android_content_Intent$setSourceBounds(android.graphics.Rect ), 0, this, rect);
    }

    public int fillIn(Intent intent, int n) {
        return (int)InvokeDynamicSupport.bootstrap("fillIn", $$robo$$android_content_Intent$fillIn(android.content.Intent int ), 0, this, intent, n);
    }

    public boolean filterEquals(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterEquals", $$robo$$android_content_Intent$filterEquals(android.content.Intent ), 0, this, intent);
    }

    public int filterHashCode() {
        return (int)InvokeDynamicSupport.bootstrap("filterHashCode", $$robo$$android_content_Intent$filterHashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_Intent$toString(), 0, this);
    }

    public String toInsecureString() {
        return InvokeDynamicSupport.bootstrap("toInsecureString", $$robo$$android_content_Intent$toInsecureString(), 0, this);
    }

    public String toInsecureStringWithClip() {
        return InvokeDynamicSupport.bootstrap("toInsecureStringWithClip", $$robo$$android_content_Intent$toInsecureStringWithClip(), 0, this);
    }

    public String toShortString(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_content_Intent$toShortString(boolean boolean boolean boolean ), 0, this, bl, bl2, bl3, bl4);
    }

    public void toShortString(StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_content_Intent$toShortString(java.lang.StringBuilder boolean boolean boolean boolean ), 0, this, stringBuilder, bl, bl2, bl3, bl4);
    }

    @Deprecated
    public String toURI() {
        return InvokeDynamicSupport.bootstrap("toURI", $$robo$$android_content_Intent$toURI(), 0, this);
    }

    public String toUri(int n) {
        return InvokeDynamicSupport.bootstrap("toUri", $$robo$$android_content_Intent$toUri(int ), 0, this, n);
    }

    private void toUriInner(StringBuilder stringBuilder, String string2, int n) {
        InvokeDynamicSupport.bootstrap("toUriInner", $$robo$$android_content_Intent$toUriInner(java.lang.StringBuilder java.lang.String int ), 0, this, stringBuilder, string2, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_Intent$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_Intent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_Intent$__constructor__(parcel);
    }

    protected Intent(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_content_Intent$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public static Intent parseIntent(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseIntent", $$robo$$android_content_Intent$parseIntent(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet);
    }

    public void saveToXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("saveToXml", $$robo$$android_content_Intent$saveToXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    public static Intent restoreFromXml(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("restoreFromXml", $$robo$$android_content_Intent$restoreFromXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public static String normalizeMimeType(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("normalizeMimeType", $$robo$$android_content_Intent$normalizeMimeType(java.lang.String ), 0, (String)string2);
    }

    public void prepareToLeaveProcess() {
        InvokeDynamicSupport.bootstrap("prepareToLeaveProcess", $$robo$$android_content_Intent$prepareToLeaveProcess(), 0, this);
    }

    public void prepareToEnterProcess() {
        InvokeDynamicSupport.bootstrap("prepareToEnterProcess", $$robo$$android_content_Intent$prepareToEnterProcess(), 0, this);
    }

    public void fixUris(int n) {
        InvokeDynamicSupport.bootstrap("fixUris", $$robo$$android_content_Intent$fixUris(int ), 0, this, n);
    }

    public boolean migrateExtraStreamToClipData() {
        return (boolean)InvokeDynamicSupport.bootstrap("migrateExtraStreamToClipData", $$robo$$android_content_Intent$migrateExtraStreamToClipData(), 0, this);
    }

    private static ClipData.Item makeClipItem(ArrayList<Uri> arrayList, ArrayList<CharSequence> arrayList2, ArrayList<String> arrayList3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("makeClipItem", $$robo$$android_content_Intent$makeClipItem(java.util.ArrayList<android.net.Uri> java.util.ArrayList<java.lang.CharSequence> java.util.ArrayList<java.lang.String> int ), 0, arrayList, arrayList2, arrayList3, (int)n);
    }

    public boolean isDocument() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDocument", $$robo$$android_content_Intent$isDocument(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Intent.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Intent)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FilterComparison
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Intent mIntent;
        private int mHashCode;

        private void $$robo$$android_content_Intent_FilterComparison$__constructor__(Intent intent) {
            this.mIntent = intent;
            this.mHashCode = intent.filterHashCode();
        }

        private final Intent $$robo$$android_content_Intent_FilterComparison$getIntent() {
            return this.mIntent;
        }

        private final boolean $$robo$$android_content_Intent_FilterComparison$equals(Object obj) {
            if (obj instanceof FilterComparison) {
                Intent other = ((FilterComparison)obj).mIntent;
                return this.mIntent.filterEquals(other);
            }
            return false;
        }

        private final int $$robo$$android_content_Intent_FilterComparison$hashCode() {
            return this.mHashCode;
        }

        private void __constructor__(Intent intent) {
            this.$$robo$$android_content_Intent_FilterComparison$__constructor__(intent);
        }

        public FilterComparison(Intent intent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent_FilterComparison$__constructor__(android.content.Intent ), 0, this, intent);
        }

        public Intent getIntent() {
            return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_content_Intent_FilterComparison$getIntent(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_Intent_FilterComparison$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_Intent_FilterComparison$hashCode(), 0, this);
        }

        public /* synthetic */ FilterComparison() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterComparison)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ShortcutIconResource
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public String resourceName;
        public static Parcelable.Creator<ShortcutIconResource> CREATOR;

        private void $$robo$$android_content_Intent_ShortcutIconResource$__constructor__() {
        }

        private static final ShortcutIconResource $$robo$$android_content_Intent_ShortcutIconResource$fromContext(Context context, int resourceId) {
            ShortcutIconResource icon = new ShortcutIconResource();
            icon.packageName = context.getPackageName();
            icon.resourceName = context.getResources().getResourceName(resourceId);
            return icon;
        }

        private final int $$robo$$android_content_Intent_ShortcutIconResource$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_Intent_ShortcutIconResource$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.packageName);
            dest.writeString(this.resourceName);
        }

        private final String $$robo$$android_content_Intent_ShortcutIconResource$toString() {
            return this.resourceName;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ShortcutIconResource>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_Intent_ShortcutIconResource_1$__constructor__() {
                }

                private final ShortcutIconResource $$robo$$android_content_Intent_ShortcutIconResource_1$createFromParcel(Parcel source) {
                    ShortcutIconResource icon = new ShortcutIconResource();
                    icon.packageName = source.readString();
                    icon.resourceName = source.readString();
                    return icon;
                }

                private final ShortcutIconResource[] $$robo$$android_content_Intent_ShortcutIconResource_1$newArray(int size) {
                    return new ShortcutIconResource[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_Intent_ShortcutIconResource_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent_ShortcutIconResource_1$__constructor__(), 0, this);
                }

                @Override
                public ShortcutIconResource createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_Intent_ShortcutIconResource_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ShortcutIconResource[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_Intent_ShortcutIconResource_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_content_Intent_ShortcutIconResource$__constructor__();
        }

        public ShortcutIconResource() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_Intent_ShortcutIconResource$__constructor__(), 0, this);
        }

        public static ShortcutIconResource fromContext(Context context, int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromContext", $$robo$$android_content_Intent_ShortcutIconResource$fromContext(android.content.Context int ), 0, (Context)context, (int)n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_Intent_ShortcutIconResource$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_Intent_ShortcutIconResource$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_Intent_ShortcutIconResource$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ShortcutIconResource.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShortcutIconResource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

