/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.AndroidException;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class IntentFilter
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String SGLOB_STR = "sglob";
    private static String PREFIX_STR = "prefix";
    private static String LITERAL_STR = "literal";
    private static String PATH_STR = "path";
    private static String PORT_STR = "port";
    private static String HOST_STR = "host";
    private static String AUTH_STR = "auth";
    private static String SSP_STR = "ssp";
    private static String SCHEME_STR = "scheme";
    private static String TYPE_STR = "type";
    private static String CAT_STR = "cat";
    private static String NAME_STR = "name";
    private static String ACTION_STR = "action";
    public static int SYSTEM_HIGH_PRIORITY = 1000;
    public static int SYSTEM_LOW_PRIORITY = -1000;
    public static int MATCH_CATEGORY_MASK = 0xFFF0000;
    public static int MATCH_ADJUSTMENT_MASK = 65535;
    public static int MATCH_ADJUSTMENT_NORMAL = 32768;
    public static int MATCH_CATEGORY_EMPTY = 0x100000;
    public static int MATCH_CATEGORY_SCHEME = 0x200000;
    public static int MATCH_CATEGORY_HOST = 0x300000;
    public static int MATCH_CATEGORY_PORT = 0x400000;
    public static int MATCH_CATEGORY_PATH = 0x500000;
    public static int MATCH_CATEGORY_SCHEME_SPECIFIC_PART = 0x580000;
    public static int MATCH_CATEGORY_TYPE = 0x600000;
    public static int NO_MATCH_TYPE = -1;
    public static int NO_MATCH_DATA = -2;
    public static int NO_MATCH_ACTION = -3;
    public static int NO_MATCH_CATEGORY = -4;
    private int mPriority;
    private ArrayList<String> mActions;
    private ArrayList<String> mCategories;
    private ArrayList<String> mDataSchemes;
    private ArrayList<PatternMatcher> mDataSchemeSpecificParts;
    private ArrayList<AuthorityEntry> mDataAuthorities;
    private ArrayList<PatternMatcher> mDataPaths;
    private ArrayList<String> mDataTypes;
    private boolean mHasPartialTypes;
    public static Parcelable.Creator<IntentFilter> CREATOR;

    private static final int $$robo$$android_content_IntentFilter$findStringInSet(String[] set, String string2, int[] lengths, int lenPos) {
        if (set == null) {
            return -1;
        }
        int N = lengths[lenPos];
        for (int i = 0; i < N; ++i) {
            if (!set[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static final String[] $$robo$$android_content_IntentFilter$addStringToSet(String[] set, String string2, int[] lengths, int lenPos) {
        if (IntentFilter.findStringInSet(set, string2, lengths, lenPos) >= 0) {
            return set;
        }
        if (set == null) {
            set = new String[2];
            set[0] = string2;
            lengths[lenPos] = 1;
            return set;
        }
        int N = lengths[lenPos];
        if (N < set.length) {
            set[N] = string2;
            lengths[lenPos] = N + 1;
            return set;
        }
        String[] newSet = new String[N * 3 / 2 + 2];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)set, (int)0, (Object)newSet, (int)0, (int)N);
        set = newSet;
        set[N] = string2;
        lengths[lenPos] = N + 1;
        return set;
    }

    private static final String[] $$robo$$android_content_IntentFilter$removeStringFromSet(String[] set, String string2, int[] lengths, int lenPos) {
        int pos = IntentFilter.findStringInSet(set, string2, lengths, lenPos);
        if (pos < 0) {
            return set;
        }
        int N = lengths[lenPos];
        if (N > set.length / 4) {
            int copyLen = N - (pos + 1);
            if (copyLen > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)set, (int)(pos + 1), (Object)set, (int)pos, (int)copyLen);
            }
            set[N - 1] = null;
            lengths[lenPos] = N - 1;
            return set;
        }
        String[] newSet = new String[set.length / 3];
        if (pos > 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)set, (int)0, (Object)newSet, (int)0, (int)pos);
        }
        if (pos + 1 < N) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)set, (int)(pos + 1), (Object)newSet, (int)pos, (int)(N - (pos + 1)));
        }
        return newSet;
    }

    private static final IntentFilter $$robo$$android_content_IntentFilter$create(String action, String dataType) {
        try {
            return new IntentFilter(action, dataType);
        }
        catch (MalformedMimeTypeException e) {
            throw new RuntimeException("Bad MIME type", e);
        }
    }

    private void $$robo$$android_content_IntentFilter$__constructor__() {
        this.mCategories = null;
        this.mDataSchemes = null;
        this.mDataSchemeSpecificParts = null;
        this.mDataAuthorities = null;
        this.mDataPaths = null;
        this.mDataTypes = null;
        this.mHasPartialTypes = false;
        this.mPriority = 0;
        this.mActions = new ArrayList();
    }

    private void $$robo$$android_content_IntentFilter$__constructor__(String action) {
        this.mCategories = null;
        this.mDataSchemes = null;
        this.mDataSchemeSpecificParts = null;
        this.mDataAuthorities = null;
        this.mDataPaths = null;
        this.mDataTypes = null;
        this.mHasPartialTypes = false;
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(action);
    }

    private void $$robo$$android_content_IntentFilter$__constructor__(String action, String dataType) throws MalformedMimeTypeException {
        this.mCategories = null;
        this.mDataSchemes = null;
        this.mDataSchemeSpecificParts = null;
        this.mDataAuthorities = null;
        this.mDataPaths = null;
        this.mDataTypes = null;
        this.mHasPartialTypes = false;
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(action);
        this.addDataType(dataType);
    }

    private void $$robo$$android_content_IntentFilter$__constructor__(IntentFilter o) {
        this.mCategories = null;
        this.mDataSchemes = null;
        this.mDataSchemeSpecificParts = null;
        this.mDataAuthorities = null;
        this.mDataPaths = null;
        this.mDataTypes = null;
        this.mHasPartialTypes = false;
        this.mPriority = o.mPriority;
        this.mActions = new ArrayList<String>(o.mActions);
        if (o.mCategories != null) {
            this.mCategories = new ArrayList<String>(o.mCategories);
        }
        if (o.mDataTypes != null) {
            this.mDataTypes = new ArrayList<String>(o.mDataTypes);
        }
        if (o.mDataSchemes != null) {
            this.mDataSchemes = new ArrayList<String>(o.mDataSchemes);
        }
        if (o.mDataSchemeSpecificParts != null) {
            this.mDataSchemeSpecificParts = new ArrayList<PatternMatcher>(o.mDataSchemeSpecificParts);
        }
        if (o.mDataAuthorities != null) {
            this.mDataAuthorities = new ArrayList<AuthorityEntry>(o.mDataAuthorities);
        }
        if (o.mDataPaths != null) {
            this.mDataPaths = new ArrayList<PatternMatcher>(o.mDataPaths);
        }
        this.mHasPartialTypes = o.mHasPartialTypes;
    }

    private final void $$robo$$android_content_IntentFilter$setPriority(int priority) {
        this.mPriority = priority;
    }

    private final int $$robo$$android_content_IntentFilter$getPriority() {
        return this.mPriority;
    }

    private final void $$robo$$android_content_IntentFilter$addAction(String action) {
        if (!this.mActions.contains(action)) {
            this.mActions.add(action.intern());
        }
    }

    private final int $$robo$$android_content_IntentFilter$countActions() {
        return this.mActions.size();
    }

    private final String $$robo$$android_content_IntentFilter$getAction(int index) {
        return this.mActions.get(index);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasAction(String action) {
        return action != null && this.mActions.contains(action);
    }

    private final boolean $$robo$$android_content_IntentFilter$matchAction(String action) {
        return this.hasAction(action);
    }

    private final Iterator<String> $$robo$$android_content_IntentFilter$actionsIterator() {
        return this.mActions != null ? this.mActions.iterator() : null;
    }

    private final void $$robo$$android_content_IntentFilter$addDataType(String type) throws MalformedMimeTypeException {
        int slashpos = type.indexOf(47);
        int typelen = type.length();
        if (slashpos > 0 && typelen >= slashpos + 2) {
            if (this.mDataTypes == null) {
                this.mDataTypes = new ArrayList();
            }
            if (typelen == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                String str = type.substring(0, slashpos);
                if (!this.mDataTypes.contains(str)) {
                    this.mDataTypes.add(str.intern());
                }
                this.mHasPartialTypes = true;
            } else if (!this.mDataTypes.contains(type)) {
                this.mDataTypes.add(type.intern());
            }
            return;
        }
        throw new MalformedMimeTypeException(type);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataType(String type) {
        return this.mDataTypes != null && this.findMimeType(type);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasExactDataType(String type) {
        return this.mDataTypes != null && this.mDataTypes.contains(type);
    }

    private final int $$robo$$android_content_IntentFilter$countDataTypes() {
        return this.mDataTypes != null ? this.mDataTypes.size() : 0;
    }

    private final String $$robo$$android_content_IntentFilter$getDataType(int index) {
        return this.mDataTypes.get(index);
    }

    private final Iterator<String> $$robo$$android_content_IntentFilter$typesIterator() {
        return this.mDataTypes != null ? this.mDataTypes.iterator() : null;
    }

    private final void $$robo$$android_content_IntentFilter$addDataScheme(String scheme) {
        if (this.mDataSchemes == null) {
            this.mDataSchemes = new ArrayList();
        }
        if (!this.mDataSchemes.contains(scheme)) {
            this.mDataSchemes.add(scheme.intern());
        }
    }

    private final int $$robo$$android_content_IntentFilter$countDataSchemes() {
        return this.mDataSchemes != null ? this.mDataSchemes.size() : 0;
    }

    private final String $$robo$$android_content_IntentFilter$getDataScheme(int index) {
        return this.mDataSchemes.get(index);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataScheme(String scheme) {
        return this.mDataSchemes != null && this.mDataSchemes.contains(scheme);
    }

    private final Iterator<String> $$robo$$android_content_IntentFilter$schemesIterator() {
        return this.mDataSchemes != null ? this.mDataSchemes.iterator() : null;
    }

    private final void $$robo$$android_content_IntentFilter$addDataSchemeSpecificPart(String ssp, int type) {
        this.addDataSchemeSpecificPart(new PatternMatcher(ssp, type));
    }

    private final void $$robo$$android_content_IntentFilter$addDataSchemeSpecificPart(PatternMatcher ssp) {
        if (this.mDataSchemeSpecificParts == null) {
            this.mDataSchemeSpecificParts = new ArrayList();
        }
        this.mDataSchemeSpecificParts.add(ssp);
    }

    private final int $$robo$$android_content_IntentFilter$countDataSchemeSpecificParts() {
        return this.mDataSchemeSpecificParts != null ? this.mDataSchemeSpecificParts.size() : 0;
    }

    private final PatternMatcher $$robo$$android_content_IntentFilter$getDataSchemeSpecificPart(int index) {
        return this.mDataSchemeSpecificParts.get(index);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataSchemeSpecificPart(String data) {
        if (this.mDataSchemeSpecificParts == null) {
            return false;
        }
        int numDataSchemeSpecificParts = this.mDataSchemeSpecificParts.size();
        for (int i = 0; i < numDataSchemeSpecificParts; ++i) {
            PatternMatcher pe = this.mDataSchemeSpecificParts.get(i);
            if (!pe.match(data)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataSchemeSpecificPart(PatternMatcher ssp) {
        if (this.mDataSchemeSpecificParts == null) {
            return false;
        }
        int numDataSchemeSpecificParts = this.mDataSchemeSpecificParts.size();
        for (int i = 0; i < numDataSchemeSpecificParts; ++i) {
            PatternMatcher pe = this.mDataSchemeSpecificParts.get(i);
            if (pe.getType() != ssp.getType() || !pe.getPath().equals(ssp.getPath())) continue;
            return true;
        }
        return false;
    }

    private final Iterator<PatternMatcher> $$robo$$android_content_IntentFilter$schemeSpecificPartsIterator() {
        return this.mDataSchemeSpecificParts != null ? this.mDataSchemeSpecificParts.iterator() : null;
    }

    private final void $$robo$$android_content_IntentFilter$addDataAuthority(String host, String port) {
        if (port != null) {
            port = port.intern();
        }
        this.addDataAuthority(new AuthorityEntry(host.intern(), port));
    }

    private final void $$robo$$android_content_IntentFilter$addDataAuthority(AuthorityEntry ent) {
        if (this.mDataAuthorities == null) {
            this.mDataAuthorities = new ArrayList();
        }
        this.mDataAuthorities.add(ent);
    }

    private final int $$robo$$android_content_IntentFilter$countDataAuthorities() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.size() : 0;
    }

    private final AuthorityEntry $$robo$$android_content_IntentFilter$getDataAuthority(int index) {
        return this.mDataAuthorities.get(index);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataAuthority(Uri data) {
        return this.matchDataAuthority(data) >= 0;
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataAuthority(AuthorityEntry auth) {
        if (this.mDataAuthorities == null) {
            return false;
        }
        int numDataAuthorities = this.mDataAuthorities.size();
        for (int i = 0; i < numDataAuthorities; ++i) {
            if (!this.mDataAuthorities.get(i).match(auth)) continue;
            return true;
        }
        return false;
    }

    private final Iterator<AuthorityEntry> $$robo$$android_content_IntentFilter$authoritiesIterator() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.iterator() : null;
    }

    private final void $$robo$$android_content_IntentFilter$addDataPath(String path, int type) {
        this.addDataPath(new PatternMatcher(path.intern(), type));
    }

    private final void $$robo$$android_content_IntentFilter$addDataPath(PatternMatcher path) {
        if (this.mDataPaths == null) {
            this.mDataPaths = new ArrayList();
        }
        this.mDataPaths.add(path);
    }

    private final int $$robo$$android_content_IntentFilter$countDataPaths() {
        return this.mDataPaths != null ? this.mDataPaths.size() : 0;
    }

    private final PatternMatcher $$robo$$android_content_IntentFilter$getDataPath(int index) {
        return this.mDataPaths.get(index);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataPath(String data) {
        if (this.mDataPaths == null) {
            return false;
        }
        int numDataPaths = this.mDataPaths.size();
        for (int i = 0; i < numDataPaths; ++i) {
            PatternMatcher pe = this.mDataPaths.get(i);
            if (!pe.match(data)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_content_IntentFilter$hasDataPath(PatternMatcher path) {
        if (this.mDataPaths == null) {
            return false;
        }
        int numDataPaths = this.mDataPaths.size();
        for (int i = 0; i < numDataPaths; ++i) {
            PatternMatcher pe = this.mDataPaths.get(i);
            if (pe.getType() != path.getType() || !pe.getPath().equals(path.getPath())) continue;
            return true;
        }
        return false;
    }

    private final Iterator<PatternMatcher> $$robo$$android_content_IntentFilter$pathsIterator() {
        return this.mDataPaths != null ? this.mDataPaths.iterator() : null;
    }

    private final int $$robo$$android_content_IntentFilter$matchDataAuthority(Uri data) {
        if (this.mDataAuthorities == null) {
            return -2;
        }
        int numDataAuthorities = this.mDataAuthorities.size();
        for (int i = 0; i < numDataAuthorities; ++i) {
            AuthorityEntry ae = this.mDataAuthorities.get(i);
            int match = ae.match(data);
            if (match < 0) continue;
            return match;
        }
        return -2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int $$robo$$android_content_IntentFilter$matchData(String type, String scheme, Uri data) {
        ArrayList<String> types = this.mDataTypes;
        ArrayList<String> schemes = this.mDataSchemes;
        int match = 0x100000;
        if (types == null && schemes == null) {
            if (type != null) return -2;
            if (data != null) return -2;
            return 0x108000;
        }
        if (schemes != null) {
            ArrayList<AuthorityEntry> authorities;
            if (!schemes.contains(scheme != null ? scheme : "")) return -2;
            match = 0x200000;
            ArrayList<PatternMatcher> schemeSpecificParts = this.mDataSchemeSpecificParts;
            if (schemeSpecificParts != null) {
                int n = match = this.hasDataSchemeSpecificPart(data.getSchemeSpecificPart()) ? 0x580000 : -2;
            }
            if (match != 0x580000 && (authorities = this.mDataAuthorities) != null) {
                int authMatch = this.matchDataAuthority(data);
                if (authMatch < 0) return -2;
                ArrayList<PatternMatcher> paths = this.mDataPaths;
                if (paths == null) {
                    match = authMatch;
                } else {
                    if (!this.hasDataPath(data.getPath())) return -2;
                    match = 0x500000;
                }
            }
            if (match == -2) {
                return -2;
            }
        } else if (!(scheme == null || "".equals(scheme) || "content".equals(scheme) || "file".equals(scheme))) {
            return -2;
        }
        if (types != null) {
            if (!this.findMimeType(type)) return -1;
            return 0x608000;
        }
        if (type == null) return match + 32768;
        return -1;
    }

    private final void $$robo$$android_content_IntentFilter$addCategory(String category) {
        if (this.mCategories == null) {
            this.mCategories = new ArrayList();
        }
        if (!this.mCategories.contains(category)) {
            this.mCategories.add(category.intern());
        }
    }

    private final int $$robo$$android_content_IntentFilter$countCategories() {
        return this.mCategories != null ? this.mCategories.size() : 0;
    }

    private final String $$robo$$android_content_IntentFilter$getCategory(int index) {
        return this.mCategories.get(index);
    }

    private final boolean $$robo$$android_content_IntentFilter$hasCategory(String category) {
        return this.mCategories != null && this.mCategories.contains(category);
    }

    private final Iterator<String> $$robo$$android_content_IntentFilter$categoriesIterator() {
        return this.mCategories != null ? this.mCategories.iterator() : null;
    }

    private final String $$robo$$android_content_IntentFilter$matchCategories(Set<String> categories) {
        if (categories == null) {
            return null;
        }
        Iterator<String> it = categories.iterator();
        if (this.mCategories == null) {
            return it.hasNext() ? it.next() : null;
        }
        while (it.hasNext()) {
            String category = it.next();
            if (this.mCategories.contains(category)) continue;
            return category;
        }
        return null;
    }

    private final int $$robo$$android_content_IntentFilter$match(ContentResolver resolver, Intent intent, boolean resolve, String logTag) {
        String type = resolve ? intent.resolveType(resolver) : intent.getType();
        return this.match(intent.getAction(), type, intent.getScheme(), intent.getData(), intent.getCategories(), logTag);
    }

    private final int $$robo$$android_content_IntentFilter$match(String action, String type, String scheme, Uri data, Set<String> categories, String logTag) {
        if (action != null && !this.matchAction(action)) {
            return -3;
        }
        int dataMatch = this.matchData(type, scheme, data);
        if (dataMatch < 0) {
            return dataMatch;
        }
        String categoryMismatch = this.matchCategories(categories);
        if (categoryMismatch != null) {
            return -4;
        }
        return dataMatch;
    }

    private final void $$robo$$android_content_IntentFilter$writeToXml(XmlSerializer serializer) throws IOException {
        PatternMatcher pe;
        int i;
        int N = this.countActions();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "action");
            serializer.attribute(null, "name", this.mActions.get(i));
            serializer.endTag(null, "action");
        }
        N = this.countCategories();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "cat");
            serializer.attribute(null, "name", this.mCategories.get(i));
            serializer.endTag(null, "cat");
        }
        N = this.countDataTypes();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "type");
            String type = this.mDataTypes.get(i);
            if (type.indexOf(47) < 0) {
                type = type + "/*";
            }
            serializer.attribute(null, "name", type);
            serializer.endTag(null, "type");
        }
        N = this.countDataSchemes();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "scheme");
            serializer.attribute(null, "name", this.mDataSchemes.get(i));
            serializer.endTag(null, "scheme");
        }
        N = this.countDataSchemeSpecificParts();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "ssp");
            pe = this.mDataSchemeSpecificParts.get(i);
            switch (pe.getType()) {
                case 0: {
                    serializer.attribute(null, "literal", pe.getPath());
                    break;
                }
                case 1: {
                    serializer.attribute(null, "prefix", pe.getPath());
                    break;
                }
                case 2: {
                    serializer.attribute(null, "sglob", pe.getPath());
                }
            }
            serializer.endTag(null, "ssp");
        }
        N = this.countDataAuthorities();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "auth");
            AuthorityEntry ae = this.mDataAuthorities.get(i);
            serializer.attribute(null, "host", ae.getHost());
            if (ae.getPort() >= 0) {
                serializer.attribute(null, "port", Integer.toString(ae.getPort()));
            }
            serializer.endTag(null, "auth");
        }
        N = this.countDataPaths();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, "path");
            pe = this.mDataPaths.get(i);
            switch (pe.getType()) {
                case 0: {
                    serializer.attribute(null, "literal", pe.getPath());
                    break;
                }
                case 1: {
                    serializer.attribute(null, "prefix", pe.getPath());
                    break;
                }
                case 2: {
                    serializer.attribute(null, "sglob", pe.getPath());
                }
            }
            serializer.endTag(null, "path");
        }
    }

    private final void $$robo$$android_content_IntentFilter$readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("action")) {
                name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    this.addAction(name);
                }
            } else if (tagName.equals("cat")) {
                name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    this.addCategory(name);
                }
            } else if (tagName.equals("type")) {
                name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    try {
                        this.addDataType(name);
                    }
                    catch (MalformedMimeTypeException malformedMimeTypeException) {}
                }
            } else if (tagName.equals("scheme")) {
                name = parser.getAttributeValue(null, "name");
                if (name != null) {
                    this.addDataScheme(name);
                }
            } else if (tagName.equals("ssp")) {
                String ssp = parser.getAttributeValue(null, "literal");
                if (ssp != null) {
                    this.addDataSchemeSpecificPart(ssp, 0);
                } else {
                    ssp = parser.getAttributeValue(null, "prefix");
                    if (ssp != null) {
                        this.addDataSchemeSpecificPart(ssp, 1);
                    } else {
                        ssp = parser.getAttributeValue(null, "sglob");
                        if (ssp != null) {
                            this.addDataSchemeSpecificPart(ssp, 2);
                        }
                    }
                }
            } else if (tagName.equals("auth")) {
                String host = parser.getAttributeValue(null, "host");
                String port = parser.getAttributeValue(null, "port");
                if (host != null) {
                    this.addDataAuthority(host, port);
                }
            } else if (tagName.equals("path")) {
                String path = parser.getAttributeValue(null, "literal");
                if (path != null) {
                    this.addDataPath(path, 0);
                } else {
                    path = parser.getAttributeValue(null, "prefix");
                    if (path != null) {
                        this.addDataPath(path, 1);
                    } else {
                        path = parser.getAttributeValue(null, "sglob");
                        if (path != null) {
                            this.addDataPath(path, 2);
                        }
                    }
                }
            } else {
                Log.w("IntentFilter", "Unknown tag parsing IntentFilter: " + tagName);
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private final void $$robo$$android_content_IntentFilter$dump(Printer du, String prefix) {
        Iterator<Object> it;
        StringBuilder sb = new StringBuilder(256);
        if (this.mActions.size() > 0) {
            it = this.mActions.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Action: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mCategories != null) {
            it = this.mCategories.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Category: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataSchemes != null) {
            it = this.mDataSchemes.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Scheme: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataSchemeSpecificParts != null) {
            for (PatternMatcher pe : this.mDataSchemeSpecificParts) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Ssp: \"");
                sb.append(pe);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataAuthorities != null) {
            for (AuthorityEntry ae : this.mDataAuthorities) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Authority: \"");
                sb.append(ae.mHost);
                sb.append("\": ");
                sb.append(ae.mPort);
                if (ae.mWild) {
                    sb.append(" WILD");
                }
                du.println(sb.toString());
            }
        }
        if (this.mDataPaths != null) {
            for (PatternMatcher pe : this.mDataPaths) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Path: \"");
                sb.append(pe);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataTypes != null) {
            it = this.mDataTypes.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Type: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mPriority != 0 || this.mHasPartialTypes) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPriority=");
            sb.append(this.mPriority);
            sb.append(", mHasPartialTypes=");
            sb.append(this.mHasPartialTypes);
            du.println(sb.toString());
        }
    }

    private final int $$robo$$android_content_IntentFilter$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_IntentFilter$writeToParcel(Parcel dest, int flags) {
        int i;
        int N;
        dest.writeStringList(this.mActions);
        if (this.mCategories != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mCategories);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataSchemes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mDataSchemes);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataTypes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mDataTypes);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataSchemeSpecificParts != null) {
            N = this.mDataSchemeSpecificParts.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataSchemeSpecificParts.get(i).writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.mDataAuthorities != null) {
            N = this.mDataAuthorities.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataAuthorities.get(i).writeToParcel(dest);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.mDataPaths != null) {
            N = this.mDataPaths.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataPaths.get(i).writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mPriority);
        dest.writeInt(this.mHasPartialTypes ? 1 : 0);
    }

    private final boolean $$robo$$android_content_IntentFilter$debugCheck() {
        return true;
    }

    private void $$robo$$android_content_IntentFilter$__constructor__(Parcel source) {
        int i;
        int N;
        this.mCategories = null;
        this.mDataSchemes = null;
        this.mDataSchemeSpecificParts = null;
        this.mDataAuthorities = null;
        this.mDataPaths = null;
        this.mDataTypes = null;
        this.mHasPartialTypes = false;
        this.mActions = new ArrayList();
        source.readStringList(this.mActions);
        if (source.readInt() != 0) {
            this.mCategories = new ArrayList();
            source.readStringList(this.mCategories);
        }
        if (source.readInt() != 0) {
            this.mDataSchemes = new ArrayList();
            source.readStringList(this.mDataSchemes);
        }
        if (source.readInt() != 0) {
            this.mDataTypes = new ArrayList();
            source.readStringList(this.mDataTypes);
        }
        if ((N = source.readInt()) > 0) {
            this.mDataSchemeSpecificParts = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataSchemeSpecificParts.add(new PatternMatcher(source));
            }
        }
        if ((N = source.readInt()) > 0) {
            this.mDataAuthorities = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataAuthorities.add(new AuthorityEntry(source));
            }
        }
        if ((N = source.readInt()) > 0) {
            this.mDataPaths = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataPaths.add(new PatternMatcher(source));
            }
        }
        this.mPriority = source.readInt();
        this.mHasPartialTypes = source.readInt() > 0;
    }

    private final boolean $$robo$$android_content_IntentFilter$findMimeType(String type) {
        ArrayList<String> t = this.mDataTypes;
        if (type == null) {
            return false;
        }
        if (t.contains(type)) {
            return true;
        }
        int typeLength = type.length();
        if (typeLength == 3 && type.equals("*/*")) {
            return !t.isEmpty();
        }
        if (this.mHasPartialTypes && t.contains("*")) {
            return true;
        }
        int slashpos = type.indexOf(47);
        if (slashpos > 0) {
            if (this.mHasPartialTypes && t.contains(type.substring(0, slashpos))) {
                return true;
            }
            if (typeLength == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                int numTypes = t.size();
                for (int i = 0; i < numTypes; ++i) {
                    String v = t.get(i);
                    if (!type.regionMatches(0, v, 0, slashpos + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private /* synthetic */ void $$robo$$android_content_IntentFilter$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<IntentFilter>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_IntentFilter_1$__constructor__() {
            }

            private final IntentFilter $$robo$$android_content_IntentFilter_1$createFromParcel(Parcel source) {
                return new IntentFilter(source);
            }

            private final IntentFilter[] $$robo$$android_content_IntentFilter_1$newArray(int size) {
                return new IntentFilter[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_IntentFilter_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter_1$__constructor__(), 0, this);
            }

            @Override
            public IntentFilter createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_IntentFilter_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public IntentFilter[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_IntentFilter_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private static int findStringInSet(String[] stringArray, String string2, int[] nArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findStringInSet", $$robo$$android_content_IntentFilter$findStringInSet(java.lang.String[] java.lang.String int[] int ), 0, (String[])stringArray, (String)string2, (int[])nArray, (int)n);
    }

    private static String[] addStringToSet(String[] stringArray, String string2, int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("addStringToSet", $$robo$$android_content_IntentFilter$addStringToSet(java.lang.String[] java.lang.String int[] int ), 0, (String[])stringArray, (String)string2, (int[])nArray, (int)n);
    }

    private static String[] removeStringFromSet(String[] stringArray, String string2, int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("removeStringFromSet", $$robo$$android_content_IntentFilter$removeStringFromSet(java.lang.String[] java.lang.String int[] int ), 0, (String[])stringArray, (String)string2, (int[])nArray, (int)n);
    }

    public static IntentFilter create(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_content_IntentFilter$create(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void __constructor__() {
        this.$$robo$$android_content_IntentFilter$__constructor__();
    }

    public IntentFilter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_content_IntentFilter$__constructor__(string2);
    }

    public IntentFilter(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, String string3) throws MalformedMimeTypeException {
        this.$$robo$$android_content_IntentFilter$__constructor__(string2, string3);
    }

    public IntentFilter(String string2, String string3) throws MalformedMimeTypeException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void __constructor__(IntentFilter intentFilter) {
        this.$$robo$$android_content_IntentFilter$__constructor__(intentFilter);
    }

    public IntentFilter(IntentFilter intentFilter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter$__constructor__(android.content.IntentFilter ), 0, this, intentFilter);
    }

    public void setPriority(int n) {
        InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_content_IntentFilter$setPriority(int ), 0, this, n);
    }

    public int getPriority() {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_content_IntentFilter$getPriority(), 0, this);
    }

    public void addAction(String string2) {
        InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_content_IntentFilter$addAction(java.lang.String ), 0, this, string2);
    }

    public int countActions() {
        return (int)InvokeDynamicSupport.bootstrap("countActions", $$robo$$android_content_IntentFilter$countActions(), 0, this);
    }

    public String getAction(int n) {
        return InvokeDynamicSupport.bootstrap("getAction", $$robo$$android_content_IntentFilter$getAction(int ), 0, this, n);
    }

    public boolean hasAction(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAction", $$robo$$android_content_IntentFilter$hasAction(java.lang.String ), 0, this, string2);
    }

    public boolean matchAction(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchAction", $$robo$$android_content_IntentFilter$matchAction(java.lang.String ), 0, this, string2);
    }

    public Iterator<String> actionsIterator() {
        return InvokeDynamicSupport.bootstrap("actionsIterator", $$robo$$android_content_IntentFilter$actionsIterator(), 0, this);
    }

    public void addDataType(String string2) throws MalformedMimeTypeException {
        InvokeDynamicSupport.bootstrap("addDataType", $$robo$$android_content_IntentFilter$addDataType(java.lang.String ), 0, this, string2);
    }

    public boolean hasDataType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataType", $$robo$$android_content_IntentFilter$hasDataType(java.lang.String ), 0, this, string2);
    }

    public boolean hasExactDataType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasExactDataType", $$robo$$android_content_IntentFilter$hasExactDataType(java.lang.String ), 0, this, string2);
    }

    public int countDataTypes() {
        return (int)InvokeDynamicSupport.bootstrap("countDataTypes", $$robo$$android_content_IntentFilter$countDataTypes(), 0, this);
    }

    public String getDataType(int n) {
        return InvokeDynamicSupport.bootstrap("getDataType", $$robo$$android_content_IntentFilter$getDataType(int ), 0, this, n);
    }

    public Iterator<String> typesIterator() {
        return InvokeDynamicSupport.bootstrap("typesIterator", $$robo$$android_content_IntentFilter$typesIterator(), 0, this);
    }

    public void addDataScheme(String string2) {
        InvokeDynamicSupport.bootstrap("addDataScheme", $$robo$$android_content_IntentFilter$addDataScheme(java.lang.String ), 0, this, string2);
    }

    public int countDataSchemes() {
        return (int)InvokeDynamicSupport.bootstrap("countDataSchemes", $$robo$$android_content_IntentFilter$countDataSchemes(), 0, this);
    }

    public String getDataScheme(int n) {
        return InvokeDynamicSupport.bootstrap("getDataScheme", $$robo$$android_content_IntentFilter$getDataScheme(int ), 0, this, n);
    }

    public boolean hasDataScheme(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataScheme", $$robo$$android_content_IntentFilter$hasDataScheme(java.lang.String ), 0, this, string2);
    }

    public Iterator<String> schemesIterator() {
        return InvokeDynamicSupport.bootstrap("schemesIterator", $$robo$$android_content_IntentFilter$schemesIterator(), 0, this);
    }

    public void addDataSchemeSpecificPart(String string2, int n) {
        InvokeDynamicSupport.bootstrap("addDataSchemeSpecificPart", $$robo$$android_content_IntentFilter$addDataSchemeSpecificPart(java.lang.String int ), 0, this, string2, n);
    }

    public void addDataSchemeSpecificPart(PatternMatcher patternMatcher) {
        InvokeDynamicSupport.bootstrap("addDataSchemeSpecificPart", $$robo$$android_content_IntentFilter$addDataSchemeSpecificPart(android.os.PatternMatcher ), 0, this, patternMatcher);
    }

    public int countDataSchemeSpecificParts() {
        return (int)InvokeDynamicSupport.bootstrap("countDataSchemeSpecificParts", $$robo$$android_content_IntentFilter$countDataSchemeSpecificParts(), 0, this);
    }

    public PatternMatcher getDataSchemeSpecificPart(int n) {
        return InvokeDynamicSupport.bootstrap("getDataSchemeSpecificPart", $$robo$$android_content_IntentFilter$getDataSchemeSpecificPart(int ), 0, this, n);
    }

    public boolean hasDataSchemeSpecificPart(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataSchemeSpecificPart", $$robo$$android_content_IntentFilter$hasDataSchemeSpecificPart(java.lang.String ), 0, this, string2);
    }

    public boolean hasDataSchemeSpecificPart(PatternMatcher patternMatcher) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataSchemeSpecificPart", $$robo$$android_content_IntentFilter$hasDataSchemeSpecificPart(android.os.PatternMatcher ), 0, this, patternMatcher);
    }

    public Iterator<PatternMatcher> schemeSpecificPartsIterator() {
        return InvokeDynamicSupport.bootstrap("schemeSpecificPartsIterator", $$robo$$android_content_IntentFilter$schemeSpecificPartsIterator(), 0, this);
    }

    public void addDataAuthority(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("addDataAuthority", $$robo$$android_content_IntentFilter$addDataAuthority(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void addDataAuthority(AuthorityEntry authorityEntry) {
        InvokeDynamicSupport.bootstrap("addDataAuthority", $$robo$$android_content_IntentFilter$addDataAuthority(android.content.IntentFilter$AuthorityEntry ), 0, this, authorityEntry);
    }

    public int countDataAuthorities() {
        return (int)InvokeDynamicSupport.bootstrap("countDataAuthorities", $$robo$$android_content_IntentFilter$countDataAuthorities(), 0, this);
    }

    public AuthorityEntry getDataAuthority(int n) {
        return InvokeDynamicSupport.bootstrap("getDataAuthority", $$robo$$android_content_IntentFilter$getDataAuthority(int ), 0, this, n);
    }

    public boolean hasDataAuthority(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataAuthority", $$robo$$android_content_IntentFilter$hasDataAuthority(android.net.Uri ), 0, this, uri);
    }

    public boolean hasDataAuthority(AuthorityEntry authorityEntry) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataAuthority", $$robo$$android_content_IntentFilter$hasDataAuthority(android.content.IntentFilter$AuthorityEntry ), 0, this, authorityEntry);
    }

    public Iterator<AuthorityEntry> authoritiesIterator() {
        return InvokeDynamicSupport.bootstrap("authoritiesIterator", $$robo$$android_content_IntentFilter$authoritiesIterator(), 0, this);
    }

    public void addDataPath(String string2, int n) {
        InvokeDynamicSupport.bootstrap("addDataPath", $$robo$$android_content_IntentFilter$addDataPath(java.lang.String int ), 0, this, string2, n);
    }

    public void addDataPath(PatternMatcher patternMatcher) {
        InvokeDynamicSupport.bootstrap("addDataPath", $$robo$$android_content_IntentFilter$addDataPath(android.os.PatternMatcher ), 0, this, patternMatcher);
    }

    public int countDataPaths() {
        return (int)InvokeDynamicSupport.bootstrap("countDataPaths", $$robo$$android_content_IntentFilter$countDataPaths(), 0, this);
    }

    public PatternMatcher getDataPath(int n) {
        return InvokeDynamicSupport.bootstrap("getDataPath", $$robo$$android_content_IntentFilter$getDataPath(int ), 0, this, n);
    }

    public boolean hasDataPath(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataPath", $$robo$$android_content_IntentFilter$hasDataPath(java.lang.String ), 0, this, string2);
    }

    public boolean hasDataPath(PatternMatcher patternMatcher) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDataPath", $$robo$$android_content_IntentFilter$hasDataPath(android.os.PatternMatcher ), 0, this, patternMatcher);
    }

    public Iterator<PatternMatcher> pathsIterator() {
        return InvokeDynamicSupport.bootstrap("pathsIterator", $$robo$$android_content_IntentFilter$pathsIterator(), 0, this);
    }

    public int matchDataAuthority(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("matchDataAuthority", $$robo$$android_content_IntentFilter$matchDataAuthority(android.net.Uri ), 0, this, uri);
    }

    public int matchData(String string2, String string3, Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("matchData", $$robo$$android_content_IntentFilter$matchData(java.lang.String java.lang.String android.net.Uri ), 0, this, string2, string3, uri);
    }

    public void addCategory(String string2) {
        InvokeDynamicSupport.bootstrap("addCategory", $$robo$$android_content_IntentFilter$addCategory(java.lang.String ), 0, this, string2);
    }

    public int countCategories() {
        return (int)InvokeDynamicSupport.bootstrap("countCategories", $$robo$$android_content_IntentFilter$countCategories(), 0, this);
    }

    public String getCategory(int n) {
        return InvokeDynamicSupport.bootstrap("getCategory", $$robo$$android_content_IntentFilter$getCategory(int ), 0, this, n);
    }

    public boolean hasCategory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCategory", $$robo$$android_content_IntentFilter$hasCategory(java.lang.String ), 0, this, string2);
    }

    public Iterator<String> categoriesIterator() {
        return InvokeDynamicSupport.bootstrap("categoriesIterator", $$robo$$android_content_IntentFilter$categoriesIterator(), 0, this);
    }

    public String matchCategories(Set<String> set) {
        return InvokeDynamicSupport.bootstrap("matchCategories", $$robo$$android_content_IntentFilter$matchCategories(java.util.Set<java.lang.String> ), 0, this, set);
    }

    public int match(ContentResolver contentResolver, Intent intent, boolean bl, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("match", $$robo$$android_content_IntentFilter$match(android.content.ContentResolver android.content.Intent boolean java.lang.String ), 0, this, contentResolver, intent, bl, string2);
    }

    public int match(String string2, String string3, String string4, Uri uri, Set<String> set, String string5) {
        return (int)InvokeDynamicSupport.bootstrap("match", $$robo$$android_content_IntentFilter$match(java.lang.String java.lang.String java.lang.String android.net.Uri java.util.Set<java.lang.String> java.lang.String ), 0, this, string2, string3, string4, uri, set, string5);
    }

    public void writeToXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeToXml", $$robo$$android_content_IntentFilter$writeToXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    public void readFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("readFromXml", $$robo$$android_content_IntentFilter$readFromXml(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_IntentFilter$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_IntentFilter$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_IntentFilter$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean debugCheck() {
        return (boolean)InvokeDynamicSupport.bootstrap("debugCheck", $$robo$$android_content_IntentFilter$debugCheck(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_IntentFilter$__constructor__(parcel);
    }

    private IntentFilter(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private boolean findMimeType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("findMimeType", $$robo$$android_content_IntentFilter$findMimeType(java.lang.String ), 0, this, string2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_IntentFilter$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(IntentFilter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AuthorityEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mOrigHost;
        private String mHost;
        private boolean mWild;
        private int mPort;

        private void $$robo$$android_content_IntentFilter_AuthorityEntry$__constructor__(String host, String port) {
            this.mOrigHost = host;
            this.mWild = host.length() > 0 && host.charAt(0) == '*';
            this.mHost = this.mWild ? host.substring(1).intern() : host;
            this.mPort = port != null ? Integer.parseInt(port) : -1;
        }

        private void $$robo$$android_content_IntentFilter_AuthorityEntry$__constructor__(Parcel src) {
            this.mOrigHost = src.readString();
            this.mHost = src.readString();
            this.mWild = src.readInt() != 0;
            this.mPort = src.readInt();
        }

        private final void $$robo$$android_content_IntentFilter_AuthorityEntry$writeToParcel(Parcel dest) {
            dest.writeString(this.mOrigHost);
            dest.writeString(this.mHost);
            dest.writeInt(this.mWild ? 1 : 0);
            dest.writeInt(this.mPort);
        }

        private final String $$robo$$android_content_IntentFilter_AuthorityEntry$getHost() {
            return this.mOrigHost;
        }

        private final int $$robo$$android_content_IntentFilter_AuthorityEntry$getPort() {
            return this.mPort;
        }

        private final boolean $$robo$$android_content_IntentFilter_AuthorityEntry$match(AuthorityEntry other) {
            if (this.mWild != other.mWild) {
                return false;
            }
            if (!this.mHost.equals(other.mHost)) {
                return false;
            }
            return this.mPort == other.mPort;
        }

        private final int $$robo$$android_content_IntentFilter_AuthorityEntry$match(Uri data) {
            String host = data.getHost();
            if (host == null) {
                return -2;
            }
            if (this.mWild) {
                if (host.length() < this.mHost.length()) {
                    return -2;
                }
                host = host.substring(host.length() - this.mHost.length());
            }
            if (host.compareToIgnoreCase(this.mHost) != 0) {
                return -2;
            }
            if (this.mPort >= 0) {
                if (this.mPort != data.getPort()) {
                    return -2;
                }
                return 0x400000;
            }
            return 0x300000;
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_content_IntentFilter_AuthorityEntry$__constructor__(string2, string3);
        }

        public AuthorityEntry(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter_AuthorityEntry$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_IntentFilter_AuthorityEntry$__constructor__(parcel);
        }

        AuthorityEntry(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter_AuthorityEntry$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_IntentFilter_AuthorityEntry$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        public String getHost() {
            return InvokeDynamicSupport.bootstrap("getHost", $$robo$$android_content_IntentFilter_AuthorityEntry$getHost(), 0, this);
        }

        public int getPort() {
            return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_content_IntentFilter_AuthorityEntry$getPort(), 0, this);
        }

        public boolean match(AuthorityEntry authorityEntry) {
            return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$android_content_IntentFilter_AuthorityEntry$match(android.content.IntentFilter$AuthorityEntry ), 0, this, authorityEntry);
        }

        public int match(Uri uri) {
            return (int)InvokeDynamicSupport.bootstrap("match", $$robo$$android_content_IntentFilter_AuthorityEntry$match(android.net.Uri ), 0, this, uri);
        }

        public /* synthetic */ AuthorityEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthorityEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MalformedMimeTypeException
    extends AndroidException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_IntentFilter_MalformedMimeTypeException$__constructor__() {
        }

        private void $$robo$$android_content_IntentFilter_MalformedMimeTypeException$__constructor__(String name) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_IntentFilter_MalformedMimeTypeException$__constructor__();
        }

        public MalformedMimeTypeException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter_MalformedMimeTypeException$__constructor__(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_IntentFilter_MalformedMimeTypeException$__constructor__(string2);
        }

        public MalformedMimeTypeException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_IntentFilter_MalformedMimeTypeException$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MalformedMimeTypeException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

