/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LauncherApps
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "LauncherApps";
    static boolean DEBUG = false;
    private Context mContext;
    private ILauncherApps mService;
    private PackageManager mPm;
    private List<CallbackMessageHandler> mCallbacks;
    private IOnAppsChangedListener.Stub mAppsChangedListener;

    private void $$robo$$android_content_pm_LauncherApps$__constructor__(Context context, ILauncherApps service) {
        this.mCallbacks = new ArrayList<CallbackMessageHandler>();
        this.mAppsChangedListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ LauncherApps this$0;

            private void $$robo$$android_content_pm_LauncherApps_1$__constructor__(LauncherApps launcherApps) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackageRemoved(packageName, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackageChanged(UserHandle user, String packageName) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackageChanged(packageName, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackageAdded(UserHandle user, String packageName) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackageAdded(packageName, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackagesAvailable(packageNames, user, replacing);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackagesUnavailable(packageNames, user, replacing);
                    }
                }
            }

            private void __constructor__(LauncherApps launcherApps) {
                this.$$robo$$android_content_pm_LauncherApps_1$__constructor__(launcherApps);
            }
            {
                this.this$0 = launcherApps;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_1$__constructor__(android.content.pm.LauncherApps ), 0, this, launcherApps);
            }

            @Override
            public void onPackageRemoved(UserHandle userHandle, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackageRemoved", $$robo$$android_content_pm_LauncherApps_1$onPackageRemoved(android.os.UserHandle java.lang.String ), 0, this, userHandle, string2);
            }

            @Override
            public void onPackageChanged(UserHandle userHandle, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackageChanged", $$robo$$android_content_pm_LauncherApps_1$onPackageChanged(android.os.UserHandle java.lang.String ), 0, this, userHandle, string2);
            }

            @Override
            public void onPackageAdded(UserHandle userHandle, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackageAdded", $$robo$$android_content_pm_LauncherApps_1$onPackageAdded(android.os.UserHandle java.lang.String ), 0, this, userHandle, string2);
            }

            @Override
            public void onPackagesAvailable(UserHandle userHandle, String[] stringArray, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackagesAvailable", $$robo$$android_content_pm_LauncherApps_1$onPackagesAvailable(android.os.UserHandle java.lang.String[] boolean ), 0, this, userHandle, stringArray, bl);
            }

            @Override
            public void onPackagesUnavailable(UserHandle userHandle, String[] stringArray, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackagesUnavailable", $$robo$$android_content_pm_LauncherApps_1$onPackagesUnavailable(android.os.UserHandle java.lang.String[] boolean ), 0, this, userHandle, stringArray, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mService = service;
        this.mPm = context.getPackageManager();
    }

    private final List<LauncherActivityInfo> $$robo$$android_content_pm_LauncherApps$getActivityList(String packageName, UserHandle user) {
        List<ResolveInfo> activities = null;
        try {
            activities = this.mService.getLauncherActivities(packageName, user);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (activities == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LauncherActivityInfo> lais = new ArrayList<LauncherActivityInfo>();
        int count = activities.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo ri = activities.get(i);
            long firstInstallTime = 0L;
            try {
                firstInstallTime = this.mPm.getPackageInfo((String)ri.activityInfo.packageName, (int)8192).firstInstallTime;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            LauncherActivityInfo lai = new LauncherActivityInfo(this.mContext, ri, user, firstInstallTime);
            lais.add(lai);
        }
        return lais;
    }

    private static final ComponentName $$robo$$android_content_pm_LauncherApps$getComponentName(ResolveInfo ri) {
        return new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
    }

    private final LauncherActivityInfo $$robo$$android_content_pm_LauncherApps$resolveActivity(Intent intent, UserHandle user) {
        block4: {
            try {
                ResolveInfo ri = this.mService.resolveActivity(intent, user);
                if (ri == null) break block4;
                long firstInstallTime = 0L;
                try {
                    firstInstallTime = this.mPm.getPackageInfo((String)ri.activityInfo.packageName, (int)8192).firstInstallTime;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                LauncherActivityInfo info = new LauncherActivityInfo(this.mContext, ri, user, firstInstallTime);
                return info;
            }
            catch (RemoteException re) {
                throw new RuntimeException("Failed to call LauncherAppsService");
            }
        }
        return null;
    }

    private final void $$robo$$android_content_pm_LauncherApps$startMainActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        try {
            this.mService.startActivityAsUser(component, sourceBounds, opts, user);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$startAppDetailsActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        try {
            this.mService.showAppDetailsAsUser(component, sourceBounds, opts, user);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_content_pm_LauncherApps$isPackageEnabled(String packageName, UserHandle user) {
        try {
            return this.mService.isPackageEnabled(packageName, user);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
    }

    private final boolean $$robo$$android_content_pm_LauncherApps$isActivityEnabled(ComponentName component, UserHandle user) {
        try {
            return this.mService.isActivityEnabled(component, user);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_LauncherApps$registerCallback(Callback callback, Handler handler) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            if (callback != null && !this.mCallbacks.contains(callback)) {
                boolean addedFirstCallback = this.mCallbacks.size() == 0;
                this.addCallbackLocked(callback, handler);
                if (addedFirstCallback) {
                    try {
                        this.mService.addOnAppsChangedListener(this.mAppsChangedListener);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_LauncherApps$unregisterCallback(Callback callback) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            this.removeCallbackLocked(callback);
            if (this.mCallbacks.size() == 0) {
                try {
                    this.mService.removeOnAppsChangedListener(this.mAppsChangedListener);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$removeCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        int size = this.mCallbacks.size();
        for (int i = 0; i < size; ++i) {
            if (this.mCallbacks.get(i).mCallback != callback) continue;
            this.mCallbacks.remove(i);
            return;
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$addCallbackLocked(Callback callback, Handler handler) {
        this.removeCallbackLocked(callback);
        if (handler == null) {
            handler = new Handler();
        }
        CallbackMessageHandler toAdd = new CallbackMessageHandler(handler.getLooper(), callback);
        this.mCallbacks.add(toAdd);
    }

    private final void $$robo$$android_content_pm_LauncherApps$addCallback(Callback callback) {
        this.registerCallback(callback);
    }

    private final void $$robo$$android_content_pm_LauncherApps$removeCallback(Callback callback) {
        this.unregisterCallback(callback);
    }

    private void __constructor__(Context context, ILauncherApps iLauncherApps) {
        this.$$robo$$android_content_pm_LauncherApps$__constructor__(context, iLauncherApps);
    }

    public LauncherApps(Context context, ILauncherApps iLauncherApps) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps$__constructor__(android.content.Context android.content.pm.ILauncherApps ), 0, this, context, iLauncherApps);
    }

    public List<LauncherActivityInfo> getActivityList(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getActivityList", $$robo$$android_content_pm_LauncherApps$getActivityList(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    static ComponentName getComponentName(ResolveInfo resolveInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getComponentName", $$robo$$android_content_pm_LauncherApps$getComponentName(android.content.pm.ResolveInfo ), 0, (ResolveInfo)resolveInfo);
    }

    public LauncherActivityInfo resolveActivity(Intent intent, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("resolveActivity", $$robo$$android_content_pm_LauncherApps$resolveActivity(android.content.Intent android.os.UserHandle ), 0, this, intent, userHandle);
    }

    public void startMainActivity(ComponentName componentName, UserHandle userHandle, Rect rect, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startMainActivity", $$robo$$android_content_pm_LauncherApps$startMainActivity(android.content.ComponentName android.os.UserHandle android.graphics.Rect android.os.Bundle ), 0, this, componentName, userHandle, rect, bundle);
    }

    public void startAppDetailsActivity(ComponentName componentName, UserHandle userHandle, Rect rect, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startAppDetailsActivity", $$robo$$android_content_pm_LauncherApps$startAppDetailsActivity(android.content.ComponentName android.os.UserHandle android.graphics.Rect android.os.Bundle ), 0, this, componentName, userHandle, rect, bundle);
    }

    public boolean isPackageEnabled(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageEnabled", $$robo$$android_content_pm_LauncherApps$isPackageEnabled(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public boolean isActivityEnabled(ComponentName componentName, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivityEnabled", $$robo$$android_content_pm_LauncherApps$isActivityEnabled(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_content_pm_LauncherApps$registerCallback(android.content.pm.LauncherApps$Callback ), 0, this, callback);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_content_pm_LauncherApps$registerCallback(android.content.pm.LauncherApps$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_content_pm_LauncherApps$unregisterCallback(android.content.pm.LauncherApps$Callback ), 0, this, callback);
    }

    private void removeCallbackLocked(Callback callback) {
        InvokeDynamicSupport.bootstrap("removeCallbackLocked", $$robo$$android_content_pm_LauncherApps$removeCallbackLocked(android.content.pm.LauncherApps$Callback ), 0, this, callback);
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("addCallbackLocked", $$robo$$android_content_pm_LauncherApps$addCallbackLocked(android.content.pm.LauncherApps$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void addCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("addCallback", $$robo$$android_content_pm_LauncherApps$addCallback(android.content.pm.LauncherApps$Callback ), 0, this, callback);
    }

    public void removeCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_content_pm_LauncherApps$removeCallback(android.content.pm.LauncherApps$Callback ), 0, this, callback);
    }

    public /* synthetic */ LauncherApps() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LauncherApps)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CallbackMessageHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_ADDED = 1;
        private static int MSG_REMOVED = 2;
        private static int MSG_CHANGED = 3;
        private static int MSG_AVAILABLE = 4;
        private static int MSG_UNAVAILABLE = 5;
        private Callback mCallback;

        private void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$__constructor__(Looper looper, Callback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$handleMessage(Message msg) {
            if (this.mCallback == null || !(msg.obj instanceof CallbackInfo)) {
                return;
            }
            CallbackInfo info = (CallbackInfo)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onPackageAdded(info.packageName, info.user);
                    break;
                }
                case 2: {
                    this.mCallback.onPackageRemoved(info.packageName, info.user);
                    break;
                }
                case 3: {
                    this.mCallback.onPackageChanged(info.packageName, info.user);
                    break;
                }
                case 4: {
                    this.mCallback.onPackagesAvailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 5: {
                    this.mCallback.onPackagesUnavailable(info.packageNames, info.user, info.replacing);
                }
            }
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageAdded(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(1, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageRemoved(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(2, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageChanged(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(3, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(4, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(5, info).sendToTarget();
        }

        private void __constructor__(Looper looper, Callback callback) {
            this.$$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$__constructor__(looper, callback);
        }

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$__constructor__(android.os.Looper android.content.pm.LauncherApps$Callback ), 0, this, looper, callback);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public void postOnPackageAdded(String string2, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackageAdded", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageAdded(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
        }

        public void postOnPackageRemoved(String string2, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackageRemoved", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageRemoved(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
        }

        public void postOnPackageChanged(String string2, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackageChanged", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageChanged(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
        }

        public void postOnPackagesAvailable(String[] stringArray, UserHandle userHandle, boolean bl) {
            InvokeDynamicSupport.bootstrap("postOnPackagesAvailable", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesAvailable(java.lang.String[] android.os.UserHandle boolean ), 0, this, stringArray, userHandle, bl);
        }

        public void postOnPackagesUnavailable(String[] stringArray, UserHandle userHandle, boolean bl) {
            InvokeDynamicSupport.bootstrap("postOnPackagesUnavailable", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesUnavailable(java.lang.String[] android.os.UserHandle boolean ), 0, this, stringArray, userHandle, bl);
        }

        public /* synthetic */ CallbackMessageHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackMessageHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class CallbackInfo
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            String[] packageNames;
            String packageName;
            boolean replacing;
            UserHandle user;

            private void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__() {
            }

            private /* synthetic */ void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__();
            }

            private CallbackInfo() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(), 0, this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackInfo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_LauncherApps_Callback$__constructor__() {
        }

        public abstract void onPackageRemoved(String var1, UserHandle var2);

        public abstract void onPackageAdded(String var1, UserHandle var2);

        public abstract void onPackageChanged(String var1, UserHandle var2);

        public abstract void onPackagesAvailable(String[] var1, UserHandle var2, boolean var3);

        public abstract void onPackagesUnavailable(String[] var1, UserHandle var2, boolean var3);

        private void __constructor__() {
            this.$$robo$$android_content_pm_LauncherApps_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_Callback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

