/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageUserState;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.VerifierInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_JAR = false;
    private static boolean DEBUG_PARSER = false;
    private static boolean DEBUG_BACKUP = false;
    private static String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    public static NewPermissionInfo[] NEW_PERMISSIONS;
    public static SplitPermissionInfo[] SPLIT_PERMISSIONS;
    @Deprecated
    private String mArchiveSourcePath;
    private String[] mSeparateProcesses;
    private boolean mOnlyCoreApps;
    private DisplayMetrics mMetrics;
    private static int SDK_VERSION;
    private static String[] SDK_CODENAMES;
    private int mParseError;
    private static boolean sCompatibilityModeEnabled;
    private static int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private ParseComponentArgs mParseActivityArgs;
    private ParseComponentArgs mParseActivityAliasArgs;
    private ParseComponentArgs mParseServiceArgs;
    private ParseComponentArgs mParseProviderArgs;
    private static boolean RIGID_PARSER = false;
    private static String TAG = "PackageParser";
    public static int PARSE_IS_SYSTEM = 1;
    public static int PARSE_CHATTY = 2;
    public static int PARSE_MUST_BE_APK = 4;
    public static int PARSE_IGNORE_PROCESSES = 8;
    public static int PARSE_FORWARD_LOCK = 16;
    public static int PARSE_ON_SDCARD = 32;
    public static int PARSE_IS_SYSTEM_DIR = 64;
    public static int PARSE_IS_PRIVILEGED = 128;
    public static int PARSE_COLLECT_CERTIFICATES = 256;
    public static int PARSE_TRUSTED_OVERLAY = 512;
    private static Comparator<String> sSplitNameComparator;
    private static String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";
    private static AtomicReference<byte[]> sBuffer;

    private void $$robo$$android_content_pm_PackageParser$__constructor__() {
        this.mParseError = 1;
        this.mMetrics = new DisplayMetrics();
        this.mMetrics.setToDefaults();
    }

    private final void $$robo$$android_content_pm_PackageParser$setSeparateProcesses(String[] procs) {
        this.mSeparateProcesses = procs;
    }

    private final void $$robo$$android_content_pm_PackageParser$setOnlyCoreApps(boolean onlyCoreApps) {
        this.mOnlyCoreApps = onlyCoreApps;
    }

    private final void $$robo$$android_content_pm_PackageParser$setDisplayMetrics(DisplayMetrics metrics) {
        this.mMetrics = metrics;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isApkFile(File file) {
        return PackageParser.isApkPath(file.getName());
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isApkPath(String path) {
        return path.endsWith(".apk");
    }

    private static final PackageInfo $$robo$$android_content_pm_PackageParser$generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, HashSet<String> grantedPermissions, PackageUserState state) {
        return PackageParser.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, UserHandle.getCallingUserId());
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$checkUseInstalledOrHidden(int flags, PackageUserState state) {
        return state.installed && !state.hidden || (flags & 0x2000) != 0;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isAvailable(PackageUserState state) {
        return PackageParser.checkUseInstalledOrHidden(0, state);
    }

    private static final PackageInfo $$robo$$android_content_pm_PackageParser$generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, HashSet<String> grantedPermissions, PackageUserState state, int userId) {
        Activity activity;
        int i;
        int j;
        int i2;
        int num;
        int N;
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        PackageInfo pi = new PackageInfo();
        pi.packageName = p.packageName;
        pi.splitNames = p.splitNames;
        pi.versionCode = p.mVersionCode;
        pi.versionName = p.mVersionName;
        pi.sharedUserId = p.mSharedUserId;
        pi.sharedUserLabel = p.mSharedUserLabel;
        pi.applicationInfo = PackageParser.generateApplicationInfo(p, flags, state, userId);
        pi.installLocation = p.installLocation;
        pi.coreApp = p.coreApp;
        if ((pi.applicationInfo.flags & 1) != 0 || (pi.applicationInfo.flags & 0x80) != 0) {
            pi.requiredForAllUsers = p.mRequiredForAllUsers;
        }
        pi.restrictedAccountType = p.mRestrictedAccountType;
        pi.requiredAccountType = p.mRequiredAccountType;
        pi.overlayTarget = p.mOverlayTarget;
        pi.firstInstallTime = firstInstallTime;
        pi.lastUpdateTime = lastUpdateTime;
        if ((flags & 0x100) != 0) {
            pi.gids = gids;
        }
        if ((flags & 0x4000) != 0) {
            int n = N = p.configPreferences != null ? p.configPreferences.size() : 0;
            if (N > 0) {
                pi.configPreferences = new ConfigurationInfo[N];
                p.configPreferences.toArray(pi.configPreferences);
            }
            int n2 = N = p.reqFeatures != null ? p.reqFeatures.size() : 0;
            if (N > 0) {
                pi.reqFeatures = new FeatureInfo[N];
                p.reqFeatures.toArray(pi.reqFeatures);
            }
            int n3 = N = p.featureGroups != null ? p.featureGroups.size() : 0;
            if (N > 0) {
                pi.featureGroups = new FeatureGroupInfo[N];
                p.featureGroups.toArray(pi.featureGroups);
            }
        }
        if ((flags & 1) != 0 && (N = p.activities.size()) > 0) {
            if ((flags & 0x200) != 0) {
                pi.activities = new ActivityInfo[N];
            } else {
                num = 0;
                for (i2 = 0; i2 < N; ++i2) {
                    if (!p.activities.get((int)i2).info.enabled) continue;
                    ++num;
                }
                pi.activities = new ActivityInfo[num];
            }
            j = 0;
            for (i = 0; i < N; ++i) {
                activity = p.activities.get(i);
                if (!activity.info.enabled && (flags & 0x200) == 0) continue;
                pi.activities[j++] = PackageParser.generateActivityInfo(p.activities.get(i), flags, state, userId);
            }
        }
        if ((flags & 2) != 0 && (N = p.receivers.size()) > 0) {
            if ((flags & 0x200) != 0) {
                pi.receivers = new ActivityInfo[N];
            } else {
                num = 0;
                for (i2 = 0; i2 < N; ++i2) {
                    if (!p.receivers.get((int)i2).info.enabled) continue;
                    ++num;
                }
                pi.receivers = new ActivityInfo[num];
            }
            j = 0;
            for (i = 0; i < N; ++i) {
                activity = p.receivers.get(i);
                if (!activity.info.enabled && (flags & 0x200) == 0) continue;
                pi.receivers[j++] = PackageParser.generateActivityInfo(p.receivers.get(i), flags, state, userId);
            }
        }
        if ((flags & 4) != 0 && (N = p.services.size()) > 0) {
            if ((flags & 0x200) != 0) {
                pi.services = new ServiceInfo[N];
            } else {
                num = 0;
                for (i2 = 0; i2 < N; ++i2) {
                    if (!p.services.get((int)i2).info.enabled) continue;
                    ++num;
                }
                pi.services = new ServiceInfo[num];
            }
            j = 0;
            for (i = 0; i < N; ++i) {
                Service service = p.services.get(i);
                if (!service.info.enabled && (flags & 0x200) == 0) continue;
                pi.services[j++] = PackageParser.generateServiceInfo(p.services.get(i), flags, state, userId);
            }
        }
        if ((flags & 8) != 0 && (N = p.providers.size()) > 0) {
            if ((flags & 0x200) != 0) {
                pi.providers = new ProviderInfo[N];
            } else {
                num = 0;
                for (i2 = 0; i2 < N; ++i2) {
                    if (!p.providers.get((int)i2).info.enabled) continue;
                    ++num;
                }
                pi.providers = new ProviderInfo[num];
            }
            j = 0;
            for (i = 0; i < N; ++i) {
                Provider provider = p.providers.get(i);
                if (!provider.info.enabled && (flags & 0x200) == 0) continue;
                pi.providers[j++] = PackageParser.generateProviderInfo(p.providers.get(i), flags, state, userId);
            }
        }
        if ((flags & 0x10) != 0 && (N = p.instrumentation.size()) > 0) {
            pi.instrumentation = new InstrumentationInfo[N];
            for (i = 0; i < N; ++i) {
                pi.instrumentation[i] = PackageParser.generateInstrumentationInfo(p.instrumentation.get(i), flags);
            }
        }
        if ((flags & 0x1000) != 0) {
            N = p.permissions.size();
            if (N > 0) {
                pi.permissions = new PermissionInfo[N];
                for (i = 0; i < N; ++i) {
                    pi.permissions[i] = PackageParser.generatePermissionInfo(p.permissions.get(i), flags);
                }
            }
            if ((N = p.requestedPermissions.size()) > 0) {
                pi.requestedPermissions = new String[N];
                pi.requestedPermissionsFlags = new int[N];
                for (i = 0; i < N; ++i) {
                    String perm;
                    pi.requestedPermissions[i] = perm = p.requestedPermissions.get(i);
                    if (p.requestedPermissionsRequired.get(i).booleanValue()) {
                        int n = i;
                        pi.requestedPermissionsFlags[n] = pi.requestedPermissionsFlags[n] | 1;
                    }
                    if (grantedPermissions == null || !grantedPermissions.contains(perm)) continue;
                    int n = i;
                    pi.requestedPermissionsFlags[n] = pi.requestedPermissionsFlags[n] | 2;
                }
            }
        }
        if ((flags & 0x40) != 0) {
            int n = N = p.mSignatures != null ? p.mSignatures.length : 0;
            if (N > 0) {
                pi.signatures = new Signature[N];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)p.mSignatures, (int)0, (Object)pi.signatures, (int)0, (int)N);
            }
        }
        return pi;
    }

    private static final Certificate[][] $$robo$$android_content_pm_PackageParser$loadCertificates(Object jarFile, ZipEntry entry) throws PackageParserException {
        InputStream is = null;
        try {
            is = jarFile.getInputStream(entry);
            PackageParser.readFullyIgnoringContents(is);
            Certificate[][] certificateArray = jarFile.getCertificateChains(entry);
            return certificateArray;
        }
        catch (IOException | RuntimeException e) {
            throw new PackageParserException(-102, "Failed reading " + entry.getName() + " in " + jarFile, e);
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parsePackageLite(File packageFile, int flags) throws PackageParserException {
        if (packageFile.isDirectory()) {
            return PackageParser.parseClusterPackageLite(packageFile, flags);
        }
        return PackageParser.parseMonolithicPackageLite(packageFile, flags);
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parseMonolithicPackageLite(File packageFile, int flags) throws PackageParserException {
        ApkLite baseApk = PackageParser.parseApkLite(packageFile, flags);
        String packagePath = packageFile.getAbsolutePath();
        return new PackageLite(packagePath, baseApk, null, null);
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parseClusterPackageLite(File packageDir, int flags) throws PackageParserException {
        File[] files = packageDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            throw new PackageParserException(-100, "No packages found in split");
        }
        String packageName = null;
        int versionCode = 0;
        ArrayMap<String, ApkLite> apks = new ArrayMap<String, ApkLite>();
        for (File file : files) {
            if (!PackageParser.isApkFile(file)) continue;
            ApkLite lite = PackageParser.parseApkLite(file, flags);
            if (packageName == null) {
                packageName = lite.packageName;
                versionCode = lite.versionCode;
            } else {
                if (!packageName.equals(lite.packageName)) {
                    throw new PackageParserException(-101, "Inconsistent package " + lite.packageName + " in " + file + "; expected " + packageName);
                }
                if (versionCode != lite.versionCode) {
                    throw new PackageParserException(-101, "Inconsistent version " + lite.versionCode + " in " + file + "; expected " + versionCode);
                }
            }
            if (apks.put(lite.splitName, lite) == null) continue;
            throw new PackageParserException(-101, "Split name " + lite.splitName + " defined more than once; most recent was " + file);
        }
        ApkLite baseApk = (ApkLite)apks.remove(null);
        if (baseApk == null) {
            throw new PackageParserException(-101, "Missing base APK in " + packageDir);
        }
        int size = apks.size();
        String[] splitNames = null;
        String[] splitCodePaths = null;
        if (size > 0) {
            splitNames = new String[size];
            splitCodePaths = new String[size];
            splitNames = apks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                splitCodePaths[i] = ((ApkLite)apks.get((Object)splitNames[i])).codePath;
            }
        }
        String codePath = packageDir.getAbsolutePath();
        return new PackageLite(codePath, baseApk, splitNames, splitCodePaths);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parsePackage(File packageFile, int flags) throws PackageParserException {
        if (packageFile.isDirectory()) {
            return this.parseClusterPackage(packageFile, flags);
        }
        return this.parseMonolithicPackage(packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Package $$robo$$android_content_pm_PackageParser$parseClusterPackage(File packageDir, int flags) throws PackageParserException {
        PackageLite lite = PackageParser.parseClusterPackageLite(packageDir, 0);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + packageDir);
        }
        AssetManager assets = new AssetManager();
        try {
            File baseApk;
            Package pkg;
            PackageParser.loadApkIntoAssetManager(assets, lite.baseCodePath, flags);
            if (!ArrayUtils.isEmpty(lite.splitCodePaths)) {
                for (String path : lite.splitCodePaths) {
                    PackageParser.loadApkIntoAssetManager(assets, path, flags);
                }
            }
            if ((pkg = this.parseBaseApk(baseApk = new File(lite.baseCodePath), assets, flags)) == null) {
                throw new PackageParserException(-100, "Failed to parse base APK: " + baseApk);
            }
            if (!ArrayUtils.isEmpty(lite.splitNames)) {
                int num = lite.splitNames.length;
                pkg.splitNames = lite.splitNames;
                pkg.splitCodePaths = lite.splitCodePaths;
                pkg.splitFlags = new int[num];
                for (int i = 0; i < num; ++i) {
                    this.parseSplitApk(pkg, i, assets, flags);
                }
            }
            pkg.codePath = packageDir.getAbsolutePath();
            Package package_ = pkg;
            return package_;
        }
        finally {
            IoUtils.closeQuietly(assets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final Package $$robo$$android_content_pm_PackageParser$parseMonolithicPackage(File apkFile, int flags) throws PackageParserException {
        if (this.mOnlyCoreApps) {
            PackageLite lite = PackageParser.parseMonolithicPackageLite(apkFile, flags);
            if (!lite.coreApp) {
                throw new PackageParserException(-108, "Not a coreApp: " + apkFile);
            }
        }
        AssetManager assets = new AssetManager();
        try {
            Package pkg = this.parseBaseApk(apkFile, assets, flags);
            pkg.codePath = apkFile.getAbsolutePath();
            Package package_ = pkg;
            return package_;
        }
        finally {
            IoUtils.closeQuietly(assets);
        }
    }

    private static final int $$robo$$android_content_pm_PackageParser$loadApkIntoAssetManager(AssetManager assets, String apkPath, int flags) throws PackageParserException {
        if ((flags & 4) != 0 && !PackageParser.isApkPath(apkPath)) {
            throw new PackageParserException(-100, "Invalid package file: " + apkPath);
        }
        int cookie = assets.addAssetPath(apkPath);
        if (cookie == 0) {
            throw new PackageParserException(-101, "Failed adding asset path: " + apkPath);
        }
        return cookie;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApk(File apkFile, AssetManager assets, int flags) throws PackageParserException {
        Package package_;
        String apkPath = apkFile.getAbsolutePath();
        this.mParseError = 1;
        this.mArchiveSourcePath = apkFile.getAbsolutePath();
        int cookie = PackageParser.loadApkIntoAssetManager(assets, apkPath, flags);
        Resources res = null;
        XmlResourceParser parser = null;
        try {
            res = new Resources(assets, this.mMetrics, null);
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            String[] outError = new String[1];
            Package pkg = this.parseBaseApk(res, parser, flags, outError);
            if (pkg == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
            pkg.baseCodePath = apkPath;
            pkg.mSignatures = null;
            package_ = pkg;
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        return package_;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$android_content_pm_PackageParser$parseSplitApk(Package pkg, int splitIndex, AssetManager assets, int flags) throws PackageParserException {
        String apkPath = pkg.splitCodePaths[splitIndex];
        File apkFile = new File(apkPath);
        this.mParseError = 1;
        this.mArchiveSourcePath = apkPath;
        int cookie = PackageParser.loadApkIntoAssetManager(assets, apkPath, flags);
        Resources res = null;
        XmlResourceParser parser = null;
        try {
            res = new Resources(assets, this.mMetrics, null);
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            String[] outError = new String[1];
            pkg = this.parseSplitApk(pkg, res, parser, flags, splitIndex, outError);
            if (pkg == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseSplitApk(Package pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException, PackageParserException {
        int type;
        XmlResourceParser attrs = parser;
        PackageParser.parsePackageSplitNames(parser, attrs, flags);
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        boolean foundApp = false;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("application")) {
                if (foundApp) {
                    Slog.w("PackageParser", "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseSplitApplication(pkg, res, parser, attrs, flags, splitIndex, outError)) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp) {
            outError[0] = "<manifest> does not contain an <application>";
            this.mParseError = -109;
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_PackageParser$collectManifestDigest(Package pkg) throws PackageParserException {
        pkg.manifestDigest = null;
        try (Object jarFile = new Object(pkg.baseCodePath);){
            ZipEntry je = jarFile.findEntry("AndroidManifest.xml");
            if (je != null) {
                pkg.manifestDigest = ManifestDigest.fromInputStream(jarFile.getInputStream(je));
            }
        }
        catch (IOException | RuntimeException e) {
            throw new PackageParserException(-108, "Failed to collect manifest digest");
        }
    }

    private final void $$robo$$android_content_pm_PackageParser$collectCertificates(Package pkg, int flags) throws PackageParserException {
        pkg.mCertificates = null;
        pkg.mSignatures = null;
        pkg.mSigningKeys = null;
        PackageParser.collectCertificates(pkg, new File(pkg.baseCodePath), flags);
        if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
            for (String splitCodePath : pkg.splitCodePaths) {
                PackageParser.collectCertificates(pkg, new File(splitCodePath), flags);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void $$robo$$android_content_pm_PackageParser$collectCertificates(Package pkg, File apkFile, int flags) throws PackageParserException {
        String apkPath = apkFile.getAbsolutePath();
        Object jarFile = null;
        try {
            jarFile = new Object(apkPath);
            ZipEntry manifestEntry = jarFile.findEntry("AndroidManifest.xml");
            if (manifestEntry == null) {
                throw new PackageParserException(-101, "Package " + apkPath + " has no manifest");
            }
            ArrayList<ZipEntry> toVerify = new ArrayList<ZipEntry>();
            toVerify.add(manifestEntry);
            if ((flags & 1) == 0) {
                Iterator i = jarFile.iterator();
                while (i.hasNext()) {
                    ZipEntry entry = (ZipEntry)i.next();
                    if (entry.isDirectory() || entry.getName().startsWith("META-INF/") || entry.getName().equals("AndroidManifest.xml")) continue;
                    toVerify.add(entry);
                }
            }
            for (ZipEntry entry : toVerify) {
                Certificate[][] entryCerts = PackageParser.loadCertificates(jarFile, entry);
                if (ArrayUtils.isEmpty(entryCerts)) {
                    throw new PackageParserException(-103, "Package " + apkPath + " has no certificates at entry " + entry.getName());
                }
                Signature[] entrySignatures = PackageParser.convertToSignatures(entryCerts);
                if (pkg.mCertificates == null) {
                    pkg.mCertificates = entryCerts;
                    pkg.mSignatures = entrySignatures;
                    pkg.mSigningKeys = new ArraySet();
                    for (int i = 0; i < entryCerts.length; ++i) {
                        pkg.mSigningKeys.add(entryCerts[i][0].getPublicKey());
                    }
                    continue;
                }
                if (Signature.areExactMatch(pkg.mSignatures, entrySignatures)) continue;
                throw new PackageParserException(-104, "Package " + apkPath + " has mismatched certificates at entry " + entry.getName());
            }
        }
        catch (GeneralSecurityException e) {
            try {
                throw new PackageParserException(-105, "Failed to collect certificates from " + apkPath, e);
                catch (IOException | RuntimeException e2) {
                    throw new PackageParserException(-103, "Failed to collect certificates from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                PackageParser.closeQuietly(jarFile);
                throw throwable;
            }
        }
        PackageParser.closeQuietly(jarFile);
    }

    private static final Signature[] $$robo$$android_content_pm_PackageParser$convertToSignatures(Certificate[][] certs) throws CertificateEncodingException {
        Signature[] res = new Signature[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            res[i] = new Signature(certs[i]);
        }
        return res;
    }

    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(File apkFile, int flags) throws PackageParserException {
        ApkLite apkLite;
        String apkPath = apkFile.getAbsolutePath();
        AssetManager assets = null;
        XmlResourceParser parser = null;
        try {
            Signature[] signatures;
            assets = new AssetManager();
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            int cookie = assets.addAssetPath(apkPath);
            if (cookie == 0) {
                throw new PackageParserException(-100, "Failed to parse " + apkPath);
            }
            DisplayMetrics metrics = new DisplayMetrics();
            metrics.setToDefaults();
            Resources res = new Resources(assets, metrics, null);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            if ((flags & 0x100) != 0) {
                Package tempPkg = new Package(null);
                PackageParser.collectCertificates(tempPkg, apkFile, 0);
                signatures = tempPkg.mSignatures;
            } else {
                signatures = null;
            }
            XmlResourceParser attrs = parser;
            apkLite = PackageParser.parseApkLite(apkPath, res, parser, attrs, flags, signatures);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                throw new PackageParserException(-102, "Failed to parse " + apkPath, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                IoUtils.closeQuietly(assets);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        IoUtils.closeQuietly(assets);
        return apkLite;
    }

    private static final String $$robo$$android_content_pm_PackageParser$validateName(String name, boolean requiresSeparator) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "bad character '" + c + "'";
        }
        return hasSep || !requiresSeparator ? null : "must have at least one '.' separator";
    }

    private static final Pair<String, String> $$robo$$android_content_pm_PackageParser$parsePackageSplitNames(XmlPullParser parser, AttributeSet attrs, int flags) throws IOException, XmlPullParserException, PackageParserException {
        String error;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new PackageParserException(-108, "No start tag found");
        }
        if (!parser.getName().equals("manifest")) {
            throw new PackageParserException(-108, "No <manifest> tag");
        }
        String packageName = attrs.getAttributeValue(null, "package");
        if (!"android".equals(packageName) && (error = PackageParser.validateName(packageName, true)) != null) {
            throw new PackageParserException(-106, "Invalid manifest package: " + error);
        }
        String splitName = attrs.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                String error2 = PackageParser.validateName(splitName, false);
                if (error2 != null) {
                    throw new PackageParserException(-106, "Invalid manifest split: " + error2);
                }
            }
        }
        return Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName);
    }

    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(String codePath, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, Signature[] signatures) throws IOException, XmlPullParserException, PackageParserException {
        int type;
        Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, attrs, flags);
        int installLocation = -1;
        int versionCode = 0;
        boolean coreApp = false;
        boolean multiArch = false;
        int numFound = 0;
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            String attr2 = attrs.getAttributeName(i);
            if (attr2.equals("installLocation")) {
                installLocation = attrs.getAttributeIntValue(i, -1);
                ++numFound;
            } else if (attr2.equals("versionCode")) {
                versionCode = attrs.getAttributeIntValue(i, 0);
                ++numFound;
            } else if (attr2.equals("coreApp")) {
                coreApp = attrs.getAttributeBooleanValue(i, false);
                ++numFound;
            }
            if (numFound >= 3) break;
        }
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        block1: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            VerifierInfo verifier;
            if (type == 3 || type == 4) continue;
            if (parser.getDepth() == searchDepth && "package-verifier".equals(parser.getName()) && (verifier = PackageParser.parseVerifier(res, parser, attrs, flags)) != null) {
                verifiers.add(verifier);
            }
            if (parser.getDepth() != searchDepth || !"application".equals(parser.getName())) continue;
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                String attr3 = attrs.getAttributeName(i);
                if (!"multiArch".equals(attr3)) continue;
                multiArch = attrs.getAttributeBooleanValue(i, false);
                continue block1;
            }
        }
        return new ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, versionCode, installLocation, verifiers, signatures, coreApp, multiArch);
    }

    private static final Signature $$robo$$android_content_pm_PackageParser$stringToSignature(String str) {
        int N = str.length();
        byte[] sig = new byte[N];
        for (int i = 0; i < N; ++i) {
            sig[i] = (byte)str.charAt(i);
        }
        return new Signature(sig);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApk(Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String str;
        String splitName;
        String pkgName;
        boolean trustedOverlay = (flags & 0x200) != 0;
        XmlResourceParser attrs = parser;
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        try {
            Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, attrs, flags);
            pkgName = (String)packageSplit.first;
            splitName = (String)packageSplit.second;
        }
        catch (PackageParserException e) {
            this.mParseError = -106;
            return null;
        }
        if (!TextUtils.isEmpty(splitName)) {
            outError[0] = "Expected base APK, but found split " + splitName;
            this.mParseError = -106;
            return null;
        }
        Package pkg = new Package(pkgName);
        boolean foundApp = false;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifest);
        pkg.mVersionCode = pkg.applicationInfo.versionCode = sa.getInteger(1, 0);
        pkg.mVersionName = sa.getNonConfigurationString(2, 0);
        if (pkg.mVersionName != null) {
            pkg.mVersionName = pkg.mVersionName.intern();
        }
        if ((str = sa.getNonConfigurationString(0, 0)) != null && str.length() > 0) {
            String nameError = PackageParser.validateName(str, true);
            if (nameError != null && !"android".equals(pkgName)) {
                outError[0] = "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameError;
                this.mParseError = -107;
                return null;
            }
            pkg.mSharedUserId = str.intern();
            pkg.mSharedUserLabel = sa.getResourceId(3, 0);
        }
        pkg.applicationInfo.installLocation = pkg.installLocation = sa.getInteger(4, -1);
        pkg.coreApp = attrs.getAttributeBooleanValue(null, "coreApp", false);
        sa.recycle();
        if ((flags & 0x10) != 0) {
            pkg.applicationInfo.flags |= 0x20000000;
        }
        if ((flags & 0x20) != 0) {
            pkg.applicationInfo.flags |= 0x40000;
        }
        int supportsSmallScreens = 1;
        int supportsNormalScreens = 1;
        int supportsLargeScreens = 1;
        int supportsXLargeScreens = 1;
        int resizeable = 1;
        int anyDensity = 1;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("application")) {
                if (foundApp) {
                    Slog.w("PackageParser", "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseBaseApplication(pkg, res, parser, attrs, flags, outError)) continue;
                return null;
            }
            if (tagName.equals("overlay")) {
                pkg.mTrustedOverlay = trustedOverlay;
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestResourceOverlay);
                pkg.mOverlayTarget = sa.getString(1);
                pkg.mOverlayPriority = sa.getInt(0, -1);
                sa.recycle();
                if (pkg.mOverlayTarget == null) {
                    outError[0] = "<overlay> does not specify a target package";
                    this.mParseError = -108;
                    return null;
                }
                if (pkg.mOverlayPriority < 0 || pkg.mOverlayPriority > 9999) {
                    outError[0] = "<overlay> priority must be between 0 and 9999";
                    this.mParseError = -108;
                    return null;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("key-sets")) {
                if (this.parseKeySets(pkg, res, parser, attrs, outError)) continue;
                return null;
            }
            if (tagName.equals("permission-group")) {
                if (this.parsePermissionGroup(pkg, flags, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("permission")) {
                if (this.parsePermission(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("permission-tree")) {
                if (this.parsePermissionTree(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("uses-permission")) {
                if (this.parseUsesPermission(pkg, res, parser, attrs, outError)) continue;
                return null;
            }
            if (tagName.equals("uses-configuration")) {
                ConfigurationInfo cPref = new ConfigurationInfo();
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesConfiguration);
                cPref.reqTouchScreen = sa.getInt(0, 0);
                cPref.reqKeyboardType = sa.getInt(1, 0);
                if (sa.getBoolean(2, false)) {
                    cPref.reqInputFeatures |= 1;
                }
                cPref.reqNavigation = sa.getInt(3, 0);
                if (sa.getBoolean(4, false)) {
                    cPref.reqInputFeatures |= 2;
                }
                sa.recycle();
                pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-feature")) {
                FeatureInfo fi = this.parseUsesFeature(res, attrs);
                pkg.reqFeatures = ArrayUtils.add(pkg.reqFeatures, fi);
                if (fi.name == null) {
                    ConfigurationInfo cPref = new ConfigurationInfo();
                    cPref.reqGlEsVersion = fi.reqGlEsVersion;
                    pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("feature-group")) {
                FeatureGroupInfo group = new FeatureGroupInfo();
                ArrayList<FeatureInfo> features = null;
                int innerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String innerTagName = parser.getName();
                    if (innerTagName.equals("uses-feature")) {
                        FeatureInfo featureInfo = this.parseUsesFeature(res, attrs);
                        featureInfo.flags |= 1;
                        features = ArrayUtils.add(features, featureInfo);
                    } else {
                        Slog.w("PackageParser", "Unknown element under <feature-group>: " + innerTagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    }
                    XmlUtils.skipCurrentTag(parser);
                }
                if (features != null) {
                    group.features = new FeatureInfo[features.size()];
                    group.features = features.toArray(group.features);
                }
                pkg.featureGroups = ArrayUtils.add(pkg.featureGroups, group);
                continue;
            }
            if (tagName.equals("uses-sdk")) {
                if (SDK_VERSION > 0) {
                    boolean allowedCodename;
                    sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesSdk);
                    int minVers = 0;
                    String minCode = null;
                    int targetVers = 0;
                    String targetCode = null;
                    TypedValue val = sa.peekValue(0);
                    if (val != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = minCode = val.string.toString();
                        } else {
                            targetVers = minVers = val.data;
                        }
                    }
                    if ((val = sa.peekValue(1)) != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = minCode = val.string.toString();
                        } else {
                            targetVers = val.data;
                        }
                    }
                    sa.recycle();
                    if (minCode != null) {
                        allowedCodename = false;
                        for (String codename : SDK_CODENAMES) {
                            if (!minCode.equals(codename)) continue;
                            allowedCodename = true;
                            break;
                        }
                        if (!allowedCodename) {
                            outError[0] = SDK_CODENAMES.length > 0 ? "Requires development platform " + minCode + " (current platform is any of " + Arrays.toString(SDK_CODENAMES) + ")" : "Requires development platform " + minCode + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                    } else if (minVers > SDK_VERSION) {
                        outError[0] = "Requires newer sdk version #" + minVers + " (current version is #" + SDK_VERSION + ")";
                        this.mParseError = -12;
                        return null;
                    }
                    if (targetCode != null) {
                        allowedCodename = false;
                        for (String codename : SDK_CODENAMES) {
                            if (!targetCode.equals(codename)) continue;
                            allowedCodename = true;
                            break;
                        }
                        if (!allowedCodename) {
                            outError[0] = SDK_CODENAMES.length > 0 ? "Requires development platform " + targetCode + " (current platform is any of " + Arrays.toString(SDK_CODENAMES) + ")" : "Requires development platform " + targetCode + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                        pkg.applicationInfo.targetSdkVersion = 10000;
                    } else {
                        pkg.applicationInfo.targetSdkVersion = targetVers;
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-screens")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestSupportsScreens);
                pkg.applicationInfo.requiresSmallestWidthDp = sa.getInteger(6, 0);
                pkg.applicationInfo.compatibleWidthLimitDp = sa.getInteger(7, 0);
                pkg.applicationInfo.largestWidthLimitDp = sa.getInteger(8, 0);
                supportsSmallScreens = sa.getInteger(1, supportsSmallScreens);
                supportsNormalScreens = sa.getInteger(2, supportsNormalScreens);
                supportsLargeScreens = sa.getInteger(3, supportsLargeScreens);
                supportsXLargeScreens = sa.getInteger(5, supportsXLargeScreens);
                resizeable = sa.getInteger(4, resizeable);
                anyDensity = sa.getInteger(0, anyDensity);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("protected-broadcast")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestProtectedBroadcast);
                String name = sa.getNonResourceString(0);
                sa.recycle();
                if (name != null && (flags & 1) != 0) {
                    if (pkg.protectedBroadcasts == null) {
                        pkg.protectedBroadcasts = new ArrayList();
                    }
                    if (!pkg.protectedBroadcasts.contains(name)) {
                        pkg.protectedBroadcasts.add(name.intern());
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("instrumentation")) {
                if (this.parseInstrumentation(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("original-package")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestOriginalPackage);
                String orig = sa.getNonConfigurationString(0, 0);
                if (!pkg.packageName.equals(orig)) {
                    if (pkg.mOriginalPackages == null) {
                        pkg.mOriginalPackages = new ArrayList();
                        pkg.mRealPackage = pkg.packageName;
                    }
                    pkg.mOriginalPackages.add(orig);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("adopt-permissions")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestOriginalPackage);
                String name = sa.getNonConfigurationString(0, 0);
                sa.recycle();
                if (name != null) {
                    if (pkg.mAdoptPermissions == null) {
                        pkg.mAdoptPermissions = new ArrayList();
                    }
                    pkg.mAdoptPermissions.add(name);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-gl-texture")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("compatible-screens")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-input")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("eat-comment")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp && pkg.instrumentation.size() == 0) {
            outError[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = -109;
        }
        int NP = NEW_PERMISSIONS.length;
        StringBuilder implicitPerms = null;
        for (int ip = 0; ip < NP; ++ip) {
            NewPermissionInfo npi = NEW_PERMISSIONS[ip];
            if (pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) break;
            if (pkg.requestedPermissions.contains(npi.name)) continue;
            if (implicitPerms == null) {
                implicitPerms = new StringBuilder(128);
                implicitPerms.append(pkg.packageName);
                implicitPerms.append(": compat added ");
            } else {
                implicitPerms.append(' ');
            }
            implicitPerms.append(npi.name);
            pkg.requestedPermissions.add(npi.name);
            pkg.requestedPermissionsRequired.add(Boolean.TRUE);
        }
        if (implicitPerms != null) {
            Slog.i("PackageParser", implicitPerms.toString());
        }
        for (SplitPermissionInfo spi : SPLIT_PERMISSIONS) {
            if (pkg.applicationInfo.targetSdkVersion >= spi.targetSdk || !pkg.requestedPermissions.contains(spi.rootPerm)) continue;
            for (int in = 0; in < spi.newPerms.length; ++in) {
                String perm = spi.newPerms[in];
                if (pkg.requestedPermissions.contains(perm)) continue;
                pkg.requestedPermissions.add(perm);
                pkg.requestedPermissionsRequired.add(Boolean.TRUE);
            }
        }
        if (supportsSmallScreens < 0 || supportsSmallScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x200;
        }
        if (supportsNormalScreens != 0) {
            pkg.applicationInfo.flags |= 0x400;
        }
        if (supportsLargeScreens < 0 || supportsLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x800;
        }
        if (supportsXLargeScreens < 0 || supportsXLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 9) {
            pkg.applicationInfo.flags |= 0x80000;
        }
        if (resizeable < 0 || resizeable > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x1000;
        }
        if (anyDensity < 0 || anyDensity > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x2000;
        }
        if (pkg.applicationInfo.targetSdkVersion < 18) {
            for (int i = 0; i < pkg.requestedPermissionsRequired.size(); ++i) {
                pkg.requestedPermissionsRequired.set(i, Boolean.TRUE);
            }
        }
        return pkg;
    }

    private final FeatureInfo $$robo$$android_content_pm_PackageParser$parseUsesFeature(Resources res, AttributeSet attrs) throws XmlPullParserException, IOException {
        FeatureInfo fi = new FeatureInfo();
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
        fi.name = sa.getNonResourceString(0);
        if (fi.name == null) {
            fi.reqGlEsVersion = sa.getInt(1, 0);
        }
        if (sa.getBoolean(2, true)) {
            fi.flags |= 1;
        }
        sa.recycle();
        return fi;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseUsesPermission(Package pkg, Resources res, XmlResourceParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesPermission);
        String name = sa.getNonResourceString(0);
        boolean required = true;
        int maxSdkVersion = 0;
        TypedValue val = sa.peekValue(1);
        if (val != null && val.type >= 16 && val.type <= 31) {
            maxSdkVersion = val.data;
        }
        sa.recycle();
        if ((maxSdkVersion == 0 || maxSdkVersion >= Build.VERSION.RESOURCES_SDK_INT) && name != null) {
            int index = pkg.requestedPermissions.indexOf(name);
            if (index == -1) {
                pkg.requestedPermissions.add(name.intern());
                pkg.requestedPermissionsRequired.add(required ? Boolean.TRUE : Boolean.FALSE);
            } else if (pkg.requestedPermissionsRequired.get(index) != required) {
                outError[0] = "conflicting <uses-permission> entries";
                this.mParseError = -108;
                return false;
            }
        }
        XmlUtils.skipCurrentTag(parser);
        return true;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildClassName(String pkg, CharSequence clsSeq, String[] outError) {
        if (clsSeq == null || clsSeq.length() <= 0) {
            outError[0] = "Empty class name in package " + pkg;
            return null;
        }
        String cls = clsSeq.toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return (pkg + cls).intern();
        }
        if (cls.indexOf(46) < 0) {
            StringBuilder b = new StringBuilder(pkg);
            b.append('.');
            b.append(cls);
            return b.toString().intern();
        }
        if (c >= 'a' && c <= 'z') {
            return cls.intern();
        }
        outError[0] = "Bad class name " + cls + " in package " + pkg;
        return null;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildCompoundName(String pkg, CharSequence procSeq, String type, String[] outError) {
        String proc = procSeq.toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                outError[0] = "Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters";
                return null;
            }
            String subName = proc.substring(1);
            String nameError = PackageParser.validateName(subName, false);
            if (nameError != null) {
                outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
                return null;
            }
            return (pkg + proc).intern();
        }
        String nameError = PackageParser.validateName(proc, true);
        if (nameError != null && !"system".equals(proc)) {
            outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
            return null;
        }
        return proc.intern();
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildProcessName(String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, String[] outError) {
        if ((flags & 8) != 0 && !"system".equals(procSeq)) {
            return defProc != null ? defProc : pkg;
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.equals(procSeq)) continue;
                return pkg;
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return defProc;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "process", outError);
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, String[] outError) {
        if (procSeq == null) {
            return defProc;
        }
        if (procSeq.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "taskAffinity", outError);
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseKeySets(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        int currentKeySetDepth = -1;
        String currentKeySet = null;
        ArrayMap<String, PublicKey> publicKeys = new ArrayMap<String, PublicKey>();
        ArraySet<String> upgradeKeySets = new ArraySet<String>();
        ArrayMap definedKeySets = new ArrayMap();
        ArraySet<String> improperKeySets = new ArraySet<String>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            TypedArray sa;
            if (type == 3) {
                if (parser.getDepth() != currentKeySetDepth) continue;
                currentKeySet = null;
                currentKeySetDepth = -1;
                continue;
            }
            String tagName = parser.getName();
            if (tagName.equals("key-set")) {
                if (currentKeySet != null) {
                    Slog.w("PackageParser", "Improperly nested 'key-set' tag at " + parser.getPositionDescription());
                    return false;
                }
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestKeySet);
                String keysetName = sa.getNonResourceString(0);
                definedKeySets.put(keysetName, new ArraySet());
                currentKeySet = keysetName;
                currentKeySetDepth = parser.getDepth();
                sa.recycle();
                continue;
            }
            if (tagName.equals("public-key")) {
                if (currentKeySet == null) {
                    Slog.w("PackageParser", "Improperly nested 'public-key' tag at " + parser.getPositionDescription());
                    return false;
                }
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPublicKey);
                String publicKeyName = sa.getNonResourceString(0);
                String encodedKey = sa.getNonResourceString(1);
                if (encodedKey == null && publicKeys.get(publicKeyName) == null) {
                    Slog.w("PackageParser", "'public-key' " + publicKeyName + " must define a public-key value" + " on first use at " + parser.getPositionDescription());
                    sa.recycle();
                    return false;
                }
                if (encodedKey != null) {
                    PublicKey currentKey = PackageParser.parsePublicKey(encodedKey);
                    if (currentKey == null) {
                        Slog.w("PackageParser", "No recognized valid key in 'public-key' tag at " + parser.getPositionDescription() + " key-set " + currentKeySet + " will not be added to the package's defined key-sets.");
                        sa.recycle();
                        improperKeySets.add(currentKeySet);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (publicKeys.get(publicKeyName) == null || ((PublicKey)publicKeys.get(publicKeyName)).equals(currentKey)) {
                        publicKeys.put(publicKeyName, currentKey);
                    } else {
                        Slog.w("PackageParser", "Value of 'public-key' " + publicKeyName + " conflicts with previously defined value at " + parser.getPositionDescription());
                        sa.recycle();
                        return false;
                    }
                }
                ((ArraySet)definedKeySets.get(currentKeySet)).add(publicKeyName);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("upgrade-key-set")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUpgradeKeySet);
                String name = sa.getNonResourceString(0);
                upgradeKeySets.add(name);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <key-sets>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        Set publicKeyNames = publicKeys.keySet();
        if (publicKeyNames.removeAll(definedKeySets.keySet())) {
            Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml " + "'key-set' and 'public-key' names must be distinct.");
            return false;
        }
        owner.mKeySetMapping = new ArrayMap();
        for (Map.Entry e : definedKeySets.entrySet()) {
            String keySetName = (String)e.getKey();
            if (((ArraySet)e.getValue()).size() == 0) {
                Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml " + "'key-set' " + keySetName + " has no valid associated 'public-key'." + " Not including in package's defined key-sets.");
                continue;
            }
            if (improperKeySets.contains(keySetName)) {
                Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml " + "'key-set' " + keySetName + " contained improper 'public-key'" + " tags. Not including in package's defined key-sets.");
                continue;
            }
            owner.mKeySetMapping.put(keySetName, new ArraySet());
            for (String s : (ArraySet)e.getValue()) {
                owner.mKeySetMapping.get(keySetName).add((PublicKey)publicKeys.get(s));
            }
        }
        if (!owner.mKeySetMapping.keySet().containsAll(upgradeKeySets)) {
            Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml " + "does not define all 'upgrade-key-set's .");
            return false;
        }
        owner.mUpgradeKeySets = upgradeKeySets;
        return true;
    }

    private final PermissionGroup $$robo$$android_content_pm_PackageParser$parsePermissionGroup(Package owner, int flags, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        PermissionGroup perm = new PermissionGroup(owner);
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPermissionGroup);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission-group>", sa, 2, 0, 1, 5, 7)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        perm.info.descriptionRes = sa.getResourceId(4, 0);
        perm.info.flags = sa.getInt(6, 0);
        perm.info.priority = sa.getInt(3, 0);
        if (perm.info.priority > 0 && (flags & 1) == 0) {
            perm.info.priority = 0;
        }
        sa.recycle();
        if (!this.parseAllMetaData(res, parser, attrs, "<permission-group>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissionGroups.add(perm);
        return perm;
    }

    private final Permission $$robo$$android_content_pm_PackageParser$parsePermission(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPermission);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission>", sa, 2, 0, 1, 6, 8)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        perm.info.group = sa.getNonResourceString(4);
        if (perm.info.group != null) {
            perm.info.group = perm.info.group.intern();
        }
        perm.info.descriptionRes = sa.getResourceId(5, 0);
        perm.info.protectionLevel = sa.getInt(3, 0);
        perm.info.flags = sa.getInt(7, 0);
        sa.recycle();
        if (perm.info.protectionLevel == -1) {
            outError[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return null;
        }
        perm.info.protectionLevel = PermissionInfo.fixProtectionLevel(perm.info.protectionLevel);
        if ((perm.info.protectionLevel & 0xF0) != 0 && (perm.info.protectionLevel & 0xF) != 2) {
            outError[0] = "<permission>  protectionLevel specifies a flag but is not based on signature type";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, attrs, "<permission>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissions.add(perm);
        return perm;
    }

    private final Permission $$robo$$android_content_pm_PackageParser$parsePermissionTree(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPermissionTree);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission-tree>", sa, 2, 0, 1, 3, 4)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        sa.recycle();
        int index = perm.info.name.indexOf(46);
        if (index > 0) {
            index = perm.info.name.indexOf(46, index + 1);
        }
        if (index < 0) {
            outError[0] = "<permission-tree> name has less than three segments: " + perm.info.name;
            this.mParseError = -108;
            return null;
        }
        perm.info.descriptionRes = 0;
        perm.info.protectionLevel = 0;
        perm.tree = true;
        if (!this.parseAllMetaData(res, parser, attrs, "<permission-tree>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissions.add(perm);
        return perm;
    }

    private final Instrumentation $$robo$$android_content_pm_PackageParser$parseInstrumentation(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(owner, outError, 2, 0, 1, 6, 7);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = sa;
        Instrumentation a = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (outError[0] != null) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        String str = sa.getNonResourceString(3);
        a.info.targetPackage = str != null ? str.intern() : null;
        a.info.handleProfiling = sa.getBoolean(4, false);
        a.info.functionalTest = sa.getBoolean(5, false);
        sa.recycle();
        if (a.info.targetPackage == null) {
            outError[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, attrs, "<instrumentation>", a, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.instrumentation.add(a);
        return a;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseBaseApplication(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String str;
        String requiredAccountType;
        String restrictedAccountType;
        TypedValue v;
        boolean allowBackup;
        String manageSpaceActivity;
        ApplicationInfo ai = owner.applicationInfo;
        String pkgName = owner.applicationInfo.packageName;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestApplication);
        String name = sa.getNonConfigurationString(3, 0);
        if (name != null) {
            ai.className = PackageParser.buildClassName(pkgName, name, outError);
            if (ai.className == null) {
                sa.recycle();
                this.mParseError = -108;
                return false;
            }
        }
        if ((manageSpaceActivity = sa.getNonConfigurationString(4, 1024)) != null) {
            ai.manageSpaceActivityName = PackageParser.buildClassName(pkgName, manageSpaceActivity, outError);
        }
        if (allowBackup = sa.getBoolean(17, true)) {
            ai.flags |= 0x8000;
            String backupAgent = sa.getNonConfigurationString(16, 1024);
            if (backupAgent != null) {
                ai.backupAgentName = PackageParser.buildClassName(pkgName, backupAgent, outError);
                if (sa.getBoolean(18, true)) {
                    ai.flags |= 0x10000;
                }
                if (sa.getBoolean(21, false)) {
                    ai.flags |= 0x20000;
                }
                if (sa.getBoolean(32, false)) {
                    ai.flags |= 0x4000000;
                }
            }
        }
        if ((v = sa.peekValue(1)) != null && (ai.labelRes = v.resourceId) == 0) {
            ai.nonLocalizedLabel = v.coerceToString();
        }
        ai.icon = sa.getResourceId(2, 0);
        ai.logo = sa.getResourceId(22, 0);
        ai.banner = sa.getResourceId(30, 0);
        ai.theme = sa.getResourceId(0, 0);
        ai.descriptionRes = sa.getResourceId(13, 0);
        if ((flags & 1) != 0 && sa.getBoolean(8, false)) {
            ai.flags |= 8;
        }
        if (sa.getBoolean(27, false)) {
            owner.mRequiredForAllUsers = true;
        }
        if ((restrictedAccountType = sa.getString(28)) != null && restrictedAccountType.length() > 0) {
            owner.mRestrictedAccountType = restrictedAccountType;
        }
        if ((requiredAccountType = sa.getString(29)) != null && requiredAccountType.length() > 0) {
            owner.mRequiredAccountType = requiredAccountType;
        }
        if (sa.getBoolean(10, false)) {
            ai.flags |= 2;
        }
        if (sa.getBoolean(20, false)) {
            ai.flags |= 0x4000;
        }
        owner.baseHardwareAccelerated = sa.getBoolean(23, owner.applicationInfo.targetSdkVersion >= 14);
        if (sa.getBoolean(7, true)) {
            ai.flags |= 4;
        }
        if (sa.getBoolean(14, false)) {
            ai.flags |= 0x20;
        }
        if (sa.getBoolean(5, true)) {
            ai.flags |= 0x40;
        }
        if (sa.getBoolean(15, false)) {
            ai.flags |= 0x100;
        }
        if (sa.getBoolean(24, false)) {
            ai.flags |= 0x100000;
        }
        if (sa.getBoolean(26, false)) {
            ai.flags |= 0x400000;
        }
        if (sa.getBoolean(33, false)) {
            ai.flags |= Integer.MIN_VALUE;
        }
        ai.permission = (str = sa.getNonConfigurationString(6, 0)) != null && str.length() > 0 ? str.intern() : null;
        str = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(12, 1024) : sa.getNonResourceString(12);
        ai.taskAffinity = PackageParser.buildTaskAffinityName(ai.packageName, ai.packageName, str, outError);
        if (outError[0] == null) {
            String pname = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(11, 1024) : sa.getNonResourceString(11);
            ai.processName = PackageParser.buildProcessName(ai.packageName, null, pname, flags, this.mSeparateProcesses, outError);
            ai.enabled = sa.getBoolean(9, true);
            if (sa.getBoolean(31, false)) {
                ai.flags |= 0x2000000;
            }
        }
        ai.uiOptions = sa.getInt(25, 0);
        sa.recycle();
        if (outError[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            String lname;
            Activity a;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, attrs, flags, outError, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, attrs, flags, outError, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, attrs, flags, outError);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, attrs, flags, outError);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, attrs, flags, outError);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, attrs, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("library")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestLibrary);
                lname = sa.getNonResourceString(0);
                sa.recycle();
                if (lname != null && !ArrayUtils.contains(owner.libraryNames, lname = lname.intern())) {
                    owner.libraryNames = ArrayUtils.add(owner.libraryNames, lname);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesLibrary);
                lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                    } else {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseSplitApplication(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException {
        int type;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestApplication);
        if (sa.getBoolean(7, true)) {
            int n = splitIndex;
            owner.splitFlags[n] = owner.splitFlags[n] | 4;
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            Activity a;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, attrs, flags, outError, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, attrs, flags, outError, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, attrs, flags, outError);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, attrs, flags, outError);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, attrs, flags, outError);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, attrs, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesLibrary);
                String lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                        owner.usesOptionalLibraries = ArrayUtils.remove(owner.usesOptionalLibraries, lname);
                    } else if (!ArrayUtils.contains(owner.usesLibraries, lname)) {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parsePackageItemInfo(Package owner, PackageItemInfo outInfo, String[] outError, String tag, TypedArray sa, int nameRes, int labelRes, int iconRes, int logoRes, int bannerRes) {
        TypedValue v;
        int bannerVal;
        int logoVal;
        String name = sa.getNonConfigurationString(nameRes, 0);
        if (name == null) {
            outError[0] = tag + " does not specify android:name";
            return false;
        }
        outInfo.name = PackageParser.buildClassName(owner.applicationInfo.packageName, name, outError);
        if (outInfo.name == null) {
            return false;
        }
        int iconVal = sa.getResourceId(iconRes, 0);
        if (iconVal != 0) {
            outInfo.icon = iconVal;
            outInfo.nonLocalizedLabel = null;
        }
        if ((logoVal = sa.getResourceId(logoRes, 0)) != 0) {
            outInfo.logo = logoVal;
        }
        if ((bannerVal = sa.getResourceId(bannerRes, 0)) != 0) {
            outInfo.banner = bannerVal;
        }
        if ((v = sa.peekValue(labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.packageName = owner.packageName;
        return true;
    }

    private final Activity $$robo$$android_content_pm_PackageParser$parseActivity(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError, boolean receiver, boolean hardwareAccelerated) throws XmlPullParserException, IOException {
        int type;
        String str;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestActivity);
        if (this.mParseActivityArgs == null) {
            this.mParseActivityArgs = new ParseComponentArgs(owner, outError, 3, 1, 2, 23, 30, this.mSeparateProcesses, 7, 17, 5);
        }
        this.mParseActivityArgs.tag = receiver ? "<receiver>" : "<activity>";
        this.mParseActivityArgs.sa = sa;
        this.mParseActivityArgs.flags = flags;
        Activity a = new Activity(this.mParseActivityArgs, new ActivityInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(6);
        if (setExported) {
            a.info.exported = sa.getBoolean(6, false);
        }
        a.info.theme = sa.getResourceId(0, 0);
        a.info.uiOptions = sa.getInt(26, a.info.applicationInfo.uiOptions);
        String parentName = sa.getNonConfigurationString(27, 1024);
        if (parentName != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e("PackageParser", "Activity " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        a.info.permission = (str = sa.getNonConfigurationString(4, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(8, 1024);
        a.info.taskAffinity = PackageParser.buildTaskAffinityName(owner.applicationInfo.packageName, owner.applicationInfo.taskAffinity, str, outError);
        a.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            a.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            a.info.flags |= 2;
        }
        if (sa.getBoolean(11, false)) {
            a.info.flags |= 4;
        }
        if (sa.getBoolean(21, false)) {
            a.info.flags |= 0x80;
        }
        if (sa.getBoolean(18, false)) {
            a.info.flags |= 8;
        }
        if (sa.getBoolean(12, false)) {
            a.info.flags |= 0x10;
        }
        if (sa.getBoolean(13, false)) {
            a.info.flags |= 0x20;
        }
        if (sa.getBoolean(19, (owner.applicationInfo.flags & 0x20) != 0)) {
            a.info.flags |= 0x40;
        }
        if (sa.getBoolean(22, false)) {
            a.info.flags |= 0x100;
        }
        if (sa.getBoolean(29, false)) {
            a.info.flags |= 0x400;
        }
        if (sa.getBoolean(24, false)) {
            a.info.flags |= 0x800;
        }
        if (!receiver) {
            if (sa.getBoolean(25, hardwareAccelerated)) {
                a.info.flags |= 0x200;
            }
            a.info.launchMode = sa.getInt(14, 0);
            a.info.documentLaunchMode = sa.getInt(33, 0);
            a.info.maxRecents = sa.getInt(34, ActivityManager.getDefaultAppRecentsLimitStatic());
            a.info.screenOrientation = sa.getInt(15, -1);
            a.info.configChanges = sa.getInt(16, 0);
            a.info.softInputMode = sa.getInt(20, 0);
            a.info.persistableMode = sa.getInteger(32, 0);
            if (sa.getBoolean(31, false)) {
                a.info.flags |= Integer.MIN_VALUE;
            }
            if (sa.getBoolean(35, false)) {
                a.info.flags |= 0x2000;
            }
            if (sa.getBoolean(36, false)) {
                a.info.flags |= 0x1000;
            }
            if (sa.getBoolean(37, false)) {
                a.info.flags |= 0x4000;
            }
        } else {
            a.info.launchMode = 0;
            a.info.configChanges = 0;
        }
        if (receiver) {
            if (sa.getBoolean(28, false)) {
                a.info.flags |= 0x40000000;
                if (a.info.exported && (flags & 0x80) == 0) {
                    Slog.w("PackageParser", "Activity exported request ignored due to singleUser: " + a.className + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    a.info.exported = false;
                    setExported = true;
                }
            }
            if (sa.getBoolean(38, false)) {
                a.info.flags |= 0x20000000;
            }
        }
        sa.recycle();
        if (receiver && (owner.applicationInfo.flags & 0x10000000) != 0 && a.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            ActivityIntentInfo intent;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, attrs, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    continue;
                }
                a.intents.add(intent);
                continue;
            }
            if (!receiver && parser.getName().equals("preferred")) {
                intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, attrs, false, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in preferred at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    continue;
                }
                if (owner.preferredActivityFilters == null) {
                    owner.preferredActivityFilters = new ArrayList();
                }
                owner.preferredActivityFilters.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, attrs, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Problem in package " + this.mArchiveSourcePath + ":");
            if (receiver) {
                Slog.w("PackageParser", "Unknown element under <receiver>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            } else {
                Slog.w("PackageParser", "Unknown element under <activity>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private final Activity $$robo$$android_content_pm_PackageParser$parseActivityAlias(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String parentName;
        String str;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestActivityAlias);
        String targetActivity = sa.getNonConfigurationString(7, 1024);
        if (targetActivity == null) {
            outError[0] = "<activity-alias> does not specify android:targetActivity";
            sa.recycle();
            return null;
        }
        if ((targetActivity = PackageParser.buildClassName(owner.applicationInfo.packageName, targetActivity, outError)) == null) {
            sa.recycle();
            return null;
        }
        if (this.mParseActivityAliasArgs == null) {
            this.mParseActivityAliasArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 8, 10, this.mSeparateProcesses, 0, 6, 4);
            this.mParseActivityAliasArgs.tag = "<activity-alias>";
        }
        this.mParseActivityAliasArgs.sa = sa;
        this.mParseActivityAliasArgs.flags = flags;
        Activity target = null;
        int NA = owner.activities.size();
        for (int i = 0; i < NA; ++i) {
            Activity t = owner.activities.get(i);
            if (!targetActivity.equals(t.info.name)) continue;
            target = t;
            break;
        }
        if (target == null) {
            outError[0] = "<activity-alias> target activity " + targetActivity + " not found in manifest";
            sa.recycle();
            return null;
        }
        ActivityInfo info = new ActivityInfo();
        info.targetActivity = targetActivity;
        info.configChanges = target.info.configChanges;
        info.flags = target.info.flags;
        info.icon = target.info.icon;
        info.logo = target.info.logo;
        info.banner = target.info.banner;
        info.labelRes = target.info.labelRes;
        info.nonLocalizedLabel = target.info.nonLocalizedLabel;
        info.launchMode = target.info.launchMode;
        info.processName = target.info.processName;
        if (info.descriptionRes == 0) {
            info.descriptionRes = target.info.descriptionRes;
        }
        info.screenOrientation = target.info.screenOrientation;
        info.taskAffinity = target.info.taskAffinity;
        info.theme = target.info.theme;
        info.softInputMode = target.info.softInputMode;
        info.uiOptions = target.info.uiOptions;
        info.parentActivityName = target.info.parentActivityName;
        info.maxRecents = target.info.maxRecents;
        Activity a = new Activity(this.mParseActivityAliasArgs, info);
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            a.info.exported = sa.getBoolean(5, false);
        }
        if ((str = sa.getNonConfigurationString(3, 0)) != null) {
            String string2 = a.info.permission = str.length() > 0 ? str.toString().intern() : null;
        }
        if ((parentName = sa.getNonConfigurationString(9, 1024)) != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e("PackageParser", "Activity alias " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        sa.recycle();
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, attrs, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    continue;
                }
                a.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, attrs, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <activity-alias>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private final Provider $$robo$$android_content_pm_PackageParser$parseProvider(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestProvider);
        if (this.mParseProviderArgs == null) {
            this.mParseProviderArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 15, 17, this.mSeparateProcesses, 8, 14, 6);
            this.mParseProviderArgs.tag = "<provider>";
        }
        this.mParseProviderArgs.sa = sa;
        this.mParseProviderArgs.flags = flags;
        Provider p = new Provider(this.mParseProviderArgs, new ProviderInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean providerExportedDefault = false;
        if (owner.applicationInfo.targetSdkVersion < 17) {
            providerExportedDefault = true;
        }
        p.info.exported = sa.getBoolean(7, providerExportedDefault);
        String cpname = sa.getNonConfigurationString(10, 0);
        p.info.isSyncable = sa.getBoolean(11, false);
        String permission2 = sa.getNonConfigurationString(3, 0);
        String str = sa.getNonConfigurationString(4, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.readPermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(5, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.writePermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        p.info.grantUriPermissions = sa.getBoolean(13, false);
        p.info.multiprocess = sa.getBoolean(9, false);
        p.info.initOrder = sa.getInt(12, 0);
        p.info.flags = 0;
        if (sa.getBoolean(16, false)) {
            p.info.flags |= 0x40000000;
            if (p.info.exported && (flags & 0x80) == 0) {
                Slog.w("PackageParser", "Provider exported request ignored due to singleUser: " + p.className + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                p.info.exported = false;
            }
        }
        sa.recycle();
        if ((owner.applicationInfo.flags & 0x10000000) != 0 && p.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (cpname == null) {
            outError[0] = "<provider> does not include authorities attribute";
            return null;
        }
        p.info.authority = cpname.intern();
        if (!this.parseProviderTags(res, parser, attrs, p, outError)) {
            return null;
        }
        return p;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseProviderTags(Resources res, XmlPullParser parser, AttributeSet attrs, Provider outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            PatternMatcher pa;
            TypedArray sa;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ProviderIntentInfo intent = new ProviderIntentInfo(outInfo);
                if (!this.parseIntent(res, parser, attrs, true, intent, outError)) {
                    return false;
                }
                outInfo.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, attrs, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            if (parser.getName().equals("grant-uri-permission")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestGrantUriPermission);
                pa = null;
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    pa = new PatternMatcher(str, 0);
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    pa = new PatternMatcher(str, 1);
                }
                if ((str = sa.getNonConfigurationString(2, 0)) != null) {
                    pa = new PatternMatcher(str, 2);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.uriPermissionPatterns == null) {
                        outInfo.info.uriPermissionPatterns = new PatternMatcher[1];
                        outInfo.info.uriPermissionPatterns[0] = pa;
                    } else {
                        int N = outInfo.info.uriPermissionPatterns.length;
                        PatternMatcher[] newp = new PatternMatcher[N + 1];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)outInfo.info.uriPermissionPatterns, (int)0, (Object)newp, (int)0, (int)N);
                        newp[N] = pa;
                        outInfo.info.uriPermissionPatterns = newp;
                    }
                } else {
                    Slog.w("PackageParser", "Unknown element under <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                outInfo.info.grantUriPermissions = true;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals("path-permission")) {
                String writePermission;
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPathPermission);
                pa = null;
                String permission2 = sa.getNonConfigurationString(0, 0);
                String readPermission = sa.getNonConfigurationString(1, 0);
                if (readPermission == null) {
                    readPermission = permission2;
                }
                if ((writePermission = sa.getNonConfigurationString(2, 0)) == null) {
                    writePermission = permission2;
                }
                boolean havePerm = false;
                if (readPermission != null) {
                    readPermission = readPermission.intern();
                    havePerm = true;
                }
                if (writePermission != null) {
                    writePermission = writePermission.intern();
                    havePerm = true;
                }
                if (!havePerm) {
                    Slog.w("PackageParser", "No readPermission or writePermssion for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String path = sa.getNonConfigurationString(3, 0);
                if (path != null) {
                    pa = new PathPermission(path, 0, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(4, 0)) != null) {
                    pa = new PathPermission(path, 1, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(5, 0)) != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.pathPermissions == null) {
                        outInfo.info.pathPermissions = new PathPermission[1];
                        outInfo.info.pathPermissions[0] = pa;
                    } else {
                        int N = outInfo.info.pathPermissions.length;
                        PathPermission[] newp = new PathPermission[N + 1];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)outInfo.info.pathPermissions, (int)0, (Object)newp, (int)0, (int)N);
                        newp[N] = pa;
                        outInfo.info.pathPermissions = newp;
                    }
                } else {
                    Slog.w("PackageParser", "No path, pathPrefix, or pathPattern for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <provider>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final Service $$robo$$android_content_pm_PackageParser$parseService(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String str;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestService);
        if (this.mParseServiceArgs == null) {
            this.mParseServiceArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 8, 12, this.mSeparateProcesses, 6, 7, 4);
            this.mParseServiceArgs.tag = "<service>";
        }
        this.mParseServiceArgs.sa = sa;
        this.mParseServiceArgs.flags = flags;
        Service s = new Service(this.mParseServiceArgs, new ServiceInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            s.info.exported = sa.getBoolean(5, false);
        }
        s.info.permission = (str = sa.getNonConfigurationString(3, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        s.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            s.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            s.info.flags |= 2;
        }
        if (sa.getBoolean(11, false)) {
            s.info.flags |= 0x40000000;
            if (s.info.exported && (flags & 0x80) == 0) {
                Slog.w("PackageParser", "Service exported request ignored due to singleUser: " + s.className + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                s.info.exported = false;
                setExported = true;
            }
        }
        sa.recycle();
        if ((owner.applicationInfo.flags & 0x10000000) != 0 && s.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ServiceIntentInfo intent = new ServiceIntentInfo(s);
                if (!this.parseIntent(res, parser, attrs, true, intent, outError)) {
                    return null;
                }
                s.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                s.metaData = this.parseMetaData(res, parser, attrs, s.metaData, outError);
                if (s.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <service>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            s.info.exported = s.intents.size() > 0;
        }
        return s;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseAllMetaData(Resources res, XmlPullParser parser, AttributeSet attrs, String tag, Component outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, attrs, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            Slog.w("PackageParser", "Unknown element under " + tag + ": " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final Bundle $$robo$$android_content_pm_PackageParser$parseMetaData(Resources res, XmlPullParser parser, AttributeSet attrs, Bundle data, String[] outError) throws XmlPullParserException, IOException {
        String name;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestMetaData);
        if (data == null) {
            data = new Bundle();
        }
        if ((name = sa.getNonConfigurationString(0, 0)) == null) {
            outError[0] = "<meta-data> requires an android:name attribute";
            sa.recycle();
            return null;
        }
        name = name.intern();
        TypedValue v = sa.peekValue(2);
        if (v != null && v.resourceId != 0) {
            data.putInt(name, v.resourceId);
        } else {
            v = sa.peekValue(1);
            if (v != null) {
                if (v.type == 3) {
                    CharSequence cs = v.coerceToString();
                    data.putString(name, cs != null ? cs.toString().intern() : null);
                } else if (v.type == 18) {
                    data.putBoolean(name, v.data != 0);
                } else if (v.type >= 16 && v.type <= 31) {
                    data.putInt(name, v.data);
                } else if (v.type == 4) {
                    data.putFloat(name, v.getFloat());
                } else {
                    Slog.w("PackageParser", "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                }
            } else {
                outError[0] = "<meta-data> requires an android:value or android:resource attribute";
                data = null;
            }
        }
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        return data;
    }

    private static final VerifierInfo $$robo$$android_content_pm_PackageParser$parseVerifier(Resources res, XmlPullParser parser, AttributeSet attrs, int flags) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPackageVerifier);
        String packageName = sa.getNonResourceString(0);
        String encodedPublicKey = sa.getNonResourceString(1);
        sa.recycle();
        if (packageName == null || packageName.length() == 0) {
            Slog.i("PackageParser", "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i("PackageParser", "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }

    private static final PublicKey $$robo$$android_content_pm_PackageParser$parsePublicKey(String encodedPublicKey) {
        X509EncodedKeySpec keySpec;
        if (encodedPublicKey == null) {
            Slog.i("PackageParser", "Could not parse null public key");
            return null;
        }
        try {
            byte[] encoded = Base64.decode(encodedPublicKey, 0);
            keySpec = new X509EncodedKeySpec(encoded);
        }
        catch (IllegalArgumentException e) {
            Slog.i("PackageParser", "Could not parse verifier public key; invalid Base64");
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf("PackageParser", "Could not parse public key because RSA isn't included in build");
            return null;
        }
        catch (InvalidKeySpecException e) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e2) {
                Log.wtf("PackageParser", "Could not parse public key because DSA isn't included in build");
                return null;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                return null;
            }
        }
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseIntent(Resources res, XmlPullParser parser, AttributeSet attrs, boolean allowGlobs, IntentInfo outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestIntentFilter);
        int priority = sa.getInt(2, 0);
        outInfo.setPriority(priority);
        TypedValue v = sa.peekValue(0);
        if (v != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.icon = sa.getResourceId(1, 0);
        outInfo.logo = sa.getResourceId(3, 0);
        outInfo.banner = sa.getResourceId(4, 0);
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String value;
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("action")) {
                value = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addAction(value);
                continue;
            }
            if (nodeName.equals("category")) {
                value = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addCategory(value);
                continue;
            }
            if (nodeName.equals("data")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestData);
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    try {
                        outInfo.addDataType(str);
                    }
                    catch (IntentFilter.MalformedMimeTypeException e) {
                        outError[0] = e.toString();
                        sa.recycle();
                        return false;
                    }
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    outInfo.addDataScheme(str);
                }
                if ((str = sa.getNonConfigurationString(7, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 0);
                }
                if ((str = sa.getNonConfigurationString(8, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 1);
                }
                if ((str = sa.getNonConfigurationString(9, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "sspPattern not allowed here; ssp must be literal";
                        return false;
                    }
                    outInfo.addDataSchemeSpecificPart(str, 2);
                }
                String host = sa.getNonConfigurationString(2, 0);
                String port = sa.getNonConfigurationString(3, 0);
                if (host != null) {
                    outInfo.addDataAuthority(host, port);
                }
                if ((str = sa.getNonConfigurationString(4, 0)) != null) {
                    outInfo.addDataPath(str, 0);
                }
                if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                    outInfo.addDataPath(str, 1);
                }
                if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "pathPattern not allowed here; path must be literal";
                        return false;
                    }
                    outInfo.addDataPath(str, 2);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <intent-filter>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        outInfo.hasDefault = outInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$copyNeeded(int flags, Package p, PackageUserState state, Bundle metaData, int userId) {
        if (userId != 0) {
            return true;
        }
        if (state.enabled != 0) {
            boolean enabled;
            boolean bl = enabled = state.enabled == 1;
            if (p.applicationInfo.enabled != enabled) {
                return true;
            }
        }
        if (!state.installed || state.hidden) {
            return true;
        }
        if (state.stopped) {
            return true;
        }
        if ((flags & 0x80) != 0 && (metaData != null || p.mAppMetaData != null)) {
            return true;
        }
        return (flags & 0x400) != 0 && p.usesLibraryFiles != null;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(Package p, int flags, PackageUserState state) {
        return PackageParser.generateApplicationInfo(p, flags, state, UserHandle.getCallingUserId());
    }

    private static final void $$robo$$android_content_pm_PackageParser$updateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state) {
        if (!sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        ai.flags = state.installed ? (ai.flags |= 0x800000) : (ai.flags &= 0xFF7FFFFF);
        ai.flags = state.hidden ? (ai.flags |= 0x8000000) : (ai.flags &= 0xF7FFFFFF);
        if (state.enabled == 1) {
            ai.enabled = true;
        } else if (state.enabled == 4) {
            ai.enabled = (flags & 0x8000) != 0;
        } else if (state.enabled == 2 || state.enabled == 3) {
            ai.enabled = false;
        }
        ai.enabledSetting = state.enabled;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(Package p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p, state, null, userId) || (flags & 0x8000) != 0 && state.enabled == 4)) {
            PackageParser.updateApplicationInfo(p.applicationInfo, flags, state);
            return p.applicationInfo;
        }
        ApplicationInfo ai = new ApplicationInfo(p.applicationInfo);
        if (userId != 0) {
            ai.uid = UserHandle.getUid(userId, ai.uid);
            ai.dataDir = PackageManager.getDataDirForUser(userId, ai.packageName);
        }
        if ((flags & 0x80) != 0) {
            ai.metaData = p.mAppMetaData;
        }
        if ((flags & 0x400) != 0) {
            ai.sharedLibraryFiles = p.usesLibraryFiles;
        }
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        ai = new ApplicationInfo(ai);
        if (userId != 0) {
            ai.uid = UserHandle.getUid(userId, ai.uid);
            ai.dataDir = PackageManager.getDataDirForUser(userId, ai.packageName);
        }
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    private static final PermissionInfo $$robo$$android_content_pm_PackageParser$generatePermissionInfo(Permission p, int flags) {
        if (p == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return p.info;
        }
        PermissionInfo pi = new PermissionInfo(p.info);
        pi.metaData = p.metaData;
        return pi;
    }

    private static final PermissionGroupInfo $$robo$$android_content_pm_PackageParser$generatePermissionGroupInfo(PermissionGroup pg, int flags) {
        if (pg == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return pg.info;
        }
        PermissionGroupInfo pgi = new PermissionGroupInfo(pg.info);
        pgi.metaData = pg.metaData;
        return pgi;
    }

    private static final ActivityInfo $$robo$$android_content_pm_PackageParser$generateActivityInfo(Activity a, int flags, PackageUserState state, int userId) {
        if (a == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, a.owner, state, a.metaData, userId)) {
            return a.info;
        }
        ActivityInfo ai = new ActivityInfo(a.info);
        ai.metaData = a.metaData;
        ai.applicationInfo = PackageParser.generateApplicationInfo(a.owner, flags, state, userId);
        return ai;
    }

    private static final ActivityInfo $$robo$$android_content_pm_PackageParser$generateActivityInfo(ActivityInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        ai = new ActivityInfo(ai);
        ai.applicationInfo = PackageParser.generateApplicationInfo(ai.applicationInfo, flags, state, userId);
        return ai;
    }

    private static final ServiceInfo $$robo$$android_content_pm_PackageParser$generateServiceInfo(Service s, int flags, PackageUserState state, int userId) {
        if (s == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, s.owner, state, s.metaData, userId)) {
            return s.info;
        }
        ServiceInfo si = new ServiceInfo(s.info);
        si.metaData = s.metaData;
        si.applicationInfo = PackageParser.generateApplicationInfo(s.owner, flags, state, userId);
        return si;
    }

    private static final ProviderInfo $$robo$$android_content_pm_PackageParser$generateProviderInfo(Provider p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p.owner, state, p.metaData, userId) || (flags & 0x800) == 0 && p.info.uriPermissionPatterns != null)) {
            return p.info;
        }
        ProviderInfo pi = new ProviderInfo(p.info);
        pi.metaData = p.metaData;
        if ((flags & 0x800) == 0) {
            pi.uriPermissionPatterns = null;
        }
        pi.applicationInfo = PackageParser.generateApplicationInfo(p.owner, flags, state, userId);
        return pi;
    }

    private static final InstrumentationInfo $$robo$$android_content_pm_PackageParser$generateInstrumentationInfo(Instrumentation i, int flags) {
        if (i == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return i.info;
        }
        InstrumentationInfo ii = new InstrumentationInfo(i.info);
        ii.metaData = i.metaData;
        return ii;
    }

    private static final void $$robo$$android_content_pm_PackageParser$setCompatibilityModeEnabled(boolean compatibilityModeEnabled) {
        sCompatibilityModeEnabled = compatibilityModeEnabled;
    }

    private static final long $$robo$$android_content_pm_PackageParser$readFullyIgnoringContents(InputStream in) throws IOException {
        byte[] buffer = sBuffer.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[4096];
        }
        int n = 0;
        int count = 0;
        while ((n = in.read(buffer, 0, buffer.length)) != -1) {
            count += n;
        }
        sBuffer.set(buffer);
        return count;
    }

    private static final void $$robo$$android_content_pm_PackageParser$closeQuietly(Object jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void __staticInitializer__() {
        NEW_PERMISSIONS = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
        SPLIT_PERMISSIONS = new SplitPermissionInfo[]{new SplitPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 10001), new SplitPermissionInfo("android.permission.READ_CONTACTS", new String[]{"android.permission.READ_CALL_LOG"}, 16), new SplitPermissionInfo("android.permission.WRITE_CONTACTS", new String[]{"android.permission.WRITE_CALL_LOG"}, 16)};
        SDK_VERSION = Build.VERSION.SDK_INT;
        SDK_CODENAMES = Build.VERSION.ACTIVE_CODENAMES;
        sCompatibilityModeEnabled = true;
        sSplitNameComparator = new SplitNameComparator();
        sBuffer = new AtomicReference();
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_PackageParser$__constructor__();
    }

    public PackageParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser$__constructor__(), 0, this);
    }

    public void setSeparateProcesses(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSeparateProcesses", $$robo$$android_content_pm_PackageParser$setSeparateProcesses(java.lang.String[] ), 0, this, stringArray);
    }

    public void setOnlyCoreApps(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOnlyCoreApps", $$robo$$android_content_pm_PackageParser$setOnlyCoreApps(boolean ), 0, this, bl);
    }

    public void setDisplayMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setDisplayMetrics", $$robo$$android_content_pm_PackageParser$setDisplayMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public static boolean isApkFile(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApkFile", $$robo$$android_content_pm_PackageParser$isApkFile(java.io.File ), 0, (File)file);
    }

    private static boolean isApkPath(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApkPath", $$robo$$android_content_pm_PackageParser$isApkPath(java.lang.String ), 0, (String)string2);
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, HashSet<String> hashSet, PackageUserState packageUserState) {
        return InvokeDynamicSupport.bootstrapStatic("generatePackageInfo", $$robo$$android_content_pm_PackageParser$generatePackageInfo(android.content.pm.PackageParser$Package int[] int long long java.util.HashSet<java.lang.String> android.content.pm.PackageUserState ), 0, (Package)package_, (int[])nArray, (int)n, (long)l, (long)l2, hashSet, (PackageUserState)packageUserState);
    }

    private static boolean checkUseInstalledOrHidden(int n, PackageUserState packageUserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkUseInstalledOrHidden", $$robo$$android_content_pm_PackageParser$checkUseInstalledOrHidden(int android.content.pm.PackageUserState ), 0, (int)n, (PackageUserState)packageUserState);
    }

    public static boolean isAvailable(PackageUserState packageUserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_content_pm_PackageParser$isAvailable(android.content.pm.PackageUserState ), 0, (PackageUserState)packageUserState);
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, HashSet<String> hashSet, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generatePackageInfo", $$robo$$android_content_pm_PackageParser$generatePackageInfo(android.content.pm.PackageParser$Package int[] int long long java.util.HashSet<java.lang.String> android.content.pm.PackageUserState int ), 0, (Package)package_, (int[])nArray, (int)n, (long)l, (long)l2, hashSet, (PackageUserState)packageUserState, (int)n2);
    }

    private static Certificate[][] loadCertificates(Object object, ZipEntry zipEntry) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("loadCertificates", $$robo$$android_content_pm_PackageParser$loadCertificates(java.lang.Object java.util.zip.ZipEntry ), 0, (Object)object, (ZipEntry)zipEntry);
    }

    public static PackageLite parsePackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parsePackageLite", $$robo$$android_content_pm_PackageParser$parsePackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static PackageLite parseMonolithicPackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseMonolithicPackageLite", $$robo$$android_content_pm_PackageParser$parseMonolithicPackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static PackageLite parseClusterPackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseClusterPackageLite", $$robo$$android_content_pm_PackageParser$parseClusterPackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    public Package parsePackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parsePackage", $$robo$$android_content_pm_PackageParser$parsePackage(java.io.File int ), 0, this, file, n);
    }

    private Package parseClusterPackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseClusterPackage", $$robo$$android_content_pm_PackageParser$parseClusterPackage(java.io.File int ), 0, this, file, n);
    }

    @Deprecated
    public Package parseMonolithicPackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseMonolithicPackage", $$robo$$android_content_pm_PackageParser$parseMonolithicPackage(java.io.File int ), 0, this, file, n);
    }

    private static int loadApkIntoAssetManager(AssetManager assetManager, String string2, int n) throws PackageParserException {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadApkIntoAssetManager", $$robo$$android_content_pm_PackageParser$loadApkIntoAssetManager(android.content.res.AssetManager java.lang.String int ), 0, (AssetManager)assetManager, (String)string2, (int)n);
    }

    private Package parseBaseApk(File file, AssetManager assetManager, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseBaseApk", $$robo$$android_content_pm_PackageParser$parseBaseApk(java.io.File android.content.res.AssetManager int ), 0, this, file, assetManager, n);
    }

    private void parseSplitApk(Package package_, int n, AssetManager assetManager, int n2) throws PackageParserException {
        InvokeDynamicSupport.bootstrap("parseSplitApk", $$robo$$android_content_pm_PackageParser$parseSplitApk(android.content.pm.PackageParser$Package int android.content.res.AssetManager int ), 0, this, package_, n, assetManager, n2);
    }

    private Package parseSplitApk(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException, PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseSplitApk", $$robo$$android_content_pm_PackageParser$parseSplitApk(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, n2, stringArray);
    }

    public void collectManifestDigest(Package package_) throws PackageParserException {
        InvokeDynamicSupport.bootstrap("collectManifestDigest", $$robo$$android_content_pm_PackageParser$collectManifestDigest(android.content.pm.PackageParser$Package ), 0, this, package_);
    }

    public void collectCertificates(Package package_, int n) throws PackageParserException {
        InvokeDynamicSupport.bootstrap("collectCertificates", $$robo$$android_content_pm_PackageParser$collectCertificates(android.content.pm.PackageParser$Package int ), 0, this, package_, n);
    }

    private static void collectCertificates(Package package_, File file, int n) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificates", $$robo$$android_content_pm_PackageParser$collectCertificates(android.content.pm.PackageParser$Package java.io.File int ), 0, (Package)package_, (File)file, (int)n);
    }

    private static Signature[] convertToSignatures(Certificate[][] certificateArray) throws CertificateEncodingException {
        return InvokeDynamicSupport.bootstrapStatic("convertToSignatures", $$robo$$android_content_pm_PackageParser$convertToSignatures(java.security.cert.Certificate[][] ), 0, (Certificate[][])certificateArray);
    }

    public static ApkLite parseApkLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static String validateName(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("validateName", $$robo$$android_content_pm_PackageParser$validateName(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static Pair<String, String> parsePackageSplitNames(XmlPullParser xmlPullParser, AttributeSet attributeSet, int n) throws IOException, XmlPullParserException, PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parsePackageSplitNames", $$robo$$android_content_pm_PackageParser$parsePackageSplitNames(org.xmlpull.v1.XmlPullParser android.util.AttributeSet int ), 0, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (int)n);
    }

    private static ApkLite parseApkLite(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, Signature[] signatureArray) throws IOException, XmlPullParserException, PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.lang.String android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int android.content.pm.Signature[] ), 0, (String)string2, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (int)n, (Signature[])signatureArray);
    }

    public static Signature stringToSignature(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stringToSignature", $$robo$$android_content_pm_PackageParser$stringToSignature(java.lang.String ), 0, (String)string2);
    }

    private Package parseBaseApk(Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseBaseApk", $$robo$$android_content_pm_PackageParser$parseBaseApk(android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, resources, xmlResourceParser, n, stringArray);
    }

    private FeatureInfo parseUsesFeature(Resources resources, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseUsesFeature", $$robo$$android_content_pm_PackageParser$parseUsesFeature(android.content.res.Resources android.util.AttributeSet ), 0, this, resources, attributeSet);
    }

    private boolean parseUsesPermission(Package package_, Resources resources, XmlResourceParser xmlResourceParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseUsesPermission", $$robo$$android_content_pm_PackageParser$parseUsesPermission(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser android.util.AttributeSet java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, attributeSet, stringArray);
    }

    private static String buildClassName(String string2, CharSequence charSequence, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildClassName", $$robo$$android_content_pm_PackageParser$buildClassName(java.lang.String java.lang.CharSequence java.lang.String[] ), 0, (String)string2, (CharSequence)charSequence, (String[])stringArray);
    }

    private static String buildCompoundName(String string2, CharSequence charSequence, String string3, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildCompoundName", $$robo$$android_content_pm_PackageParser$buildCompoundName(java.lang.String java.lang.CharSequence java.lang.String java.lang.String[] ), 0, (String)string2, (CharSequence)charSequence, (String)string3, (String[])stringArray);
    }

    private static String buildProcessName(String string2, String string3, CharSequence charSequence, int n, String[] stringArray, String[] stringArray2) {
        return InvokeDynamicSupport.bootstrapStatic("buildProcessName", $$robo$$android_content_pm_PackageParser$buildProcessName(java.lang.String java.lang.String java.lang.CharSequence int java.lang.String[] java.lang.String[] ), 0, (String)string2, (String)string3, (CharSequence)charSequence, (int)n, (String[])stringArray, (String[])stringArray2);
    }

    private static String buildTaskAffinityName(String string2, String string3, CharSequence charSequence, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildTaskAffinityName", $$robo$$android_content_pm_PackageParser$buildTaskAffinityName(java.lang.String java.lang.String java.lang.CharSequence java.lang.String[] ), 0, (String)string2, (String)string3, (CharSequence)charSequence, (String[])stringArray);
    }

    private boolean parseKeySets(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseKeySets", $$robo$$android_content_pm_PackageParser$parseKeySets(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, stringArray);
    }

    private PermissionGroup parsePermissionGroup(Package package_, int n, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parsePermissionGroup", $$robo$$android_content_pm_PackageParser$parsePermissionGroup(android.content.pm.PackageParser$Package int android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet java.lang.String[] ), 0, this, package_, n, resources, xmlPullParser, attributeSet, stringArray);
    }

    private Permission parsePermission(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parsePermission", $$robo$$android_content_pm_PackageParser$parsePermission(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, stringArray);
    }

    private Permission parsePermissionTree(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parsePermissionTree", $$robo$$android_content_pm_PackageParser$parsePermissionTree(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, stringArray);
    }

    private Instrumentation parseInstrumentation(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseInstrumentation", $$robo$$android_content_pm_PackageParser$parseInstrumentation(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, stringArray);
    }

    private boolean parseBaseApplication(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseBaseApplication", $$robo$$android_content_pm_PackageParser$parseBaseApplication(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, n, stringArray);
    }

    private boolean parseSplitApplication(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseSplitApplication", $$robo$$android_content_pm_PackageParser$parseSplitApplication(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int int java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, n, n2, stringArray);
    }

    private boolean parsePackageItemInfo(Package package_, PackageItemInfo packageItemInfo, String[] stringArray, String string2, TypedArray typedArray, int n, int n2, int n3, int n4, int n5) {
        return (boolean)InvokeDynamicSupport.bootstrap("parsePackageItemInfo", $$robo$$android_content_pm_PackageParser$parsePackageItemInfo(android.content.pm.PackageParser$Package android.content.pm.PackageItemInfo java.lang.String[] java.lang.String android.content.res.TypedArray int int int int int ), 0, this, package_, packageItemInfo, stringArray, string2, typedArray, n, n2, n3, n4, n5);
    }

    private Activity parseActivity(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray, boolean bl, boolean bl2) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseActivity", $$robo$$android_content_pm_PackageParser$parseActivity(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int java.lang.String[] boolean boolean ), 0, this, package_, resources, xmlPullParser, attributeSet, n, stringArray, bl, bl2);
    }

    private Activity parseActivityAlias(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseActivityAlias", $$robo$$android_content_pm_PackageParser$parseActivityAlias(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, n, stringArray);
    }

    private Provider parseProvider(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseProvider", $$robo$$android_content_pm_PackageParser$parseProvider(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, n, stringArray);
    }

    private boolean parseProviderTags(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Provider provider, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseProviderTags", $$robo$$android_content_pm_PackageParser$parseProviderTags(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.pm.PackageParser$Provider java.lang.String[] ), 0, this, resources, xmlPullParser, attributeSet, provider, stringArray);
    }

    private Service parseService(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseService", $$robo$$android_content_pm_PackageParser$parseService(android.content.pm.PackageParser$Package android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int java.lang.String[] ), 0, this, package_, resources, xmlPullParser, attributeSet, n, stringArray);
    }

    private boolean parseAllMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String string2, Component component, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseAllMetaData", $$robo$$android_content_pm_PackageParser$parseAllMetaData(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet java.lang.String android.content.pm.PackageParser$Component java.lang.String[] ), 0, this, resources, xmlPullParser, attributeSet, string2, component, stringArray);
    }

    private Bundle parseMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseMetaData", $$robo$$android_content_pm_PackageParser$parseMetaData(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.os.Bundle java.lang.String[] ), 0, this, resources, xmlPullParser, attributeSet, bundle, stringArray);
    }

    private static VerifierInfo parseVerifier(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseVerifier", $$robo$$android_content_pm_PackageParser$parseVerifier(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (int)n);
    }

    public static PublicKey parsePublicKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parsePublicKey", $$robo$$android_content_pm_PackageParser$parsePublicKey(java.lang.String ), 0, (String)string2);
    }

    private boolean parseIntent(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, boolean bl, IntentInfo intentInfo, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseIntent", $$robo$$android_content_pm_PackageParser$parseIntent(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet boolean android.content.pm.PackageParser$IntentInfo java.lang.String[] ), 0, this, resources, xmlPullParser, attributeSet, bl, intentInfo, stringArray);
    }

    private static boolean copyNeeded(int n, Package package_, PackageUserState packageUserState, Bundle bundle, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("copyNeeded", $$robo$$android_content_pm_PackageParser$copyNeeded(int android.content.pm.PackageParser$Package android.content.pm.PackageUserState android.os.Bundle int ), 0, (int)n, (Package)package_, (PackageUserState)packageUserState, (Bundle)bundle, (int)n2);
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.PackageParser$Package int android.content.pm.PackageUserState ), 0, (Package)package_, (int)n, (PackageUserState)packageUserState);
    }

    private static void updateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState) {
        InvokeDynamicSupport.bootstrapStatic("updateApplicationInfo", $$robo$$android_content_pm_PackageParser$updateApplicationInfo(android.content.pm.ApplicationInfo int android.content.pm.PackageUserState ), 0, (ApplicationInfo)applicationInfo, (int)n, (PackageUserState)packageUserState);
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.PackageParser$Package int android.content.pm.PackageUserState int ), 0, (Package)package_, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ApplicationInfo generateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.ApplicationInfo int android.content.pm.PackageUserState int ), 0, (ApplicationInfo)applicationInfo, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static PermissionInfo generatePermissionInfo(Permission permission2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generatePermissionInfo", $$robo$$android_content_pm_PackageParser$generatePermissionInfo(android.content.pm.PackageParser$Permission int ), 0, (Permission)permission2, (int)n);
    }

    public static PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup permissionGroup, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generatePermissionGroupInfo", $$robo$$android_content_pm_PackageParser$generatePermissionGroupInfo(android.content.pm.PackageParser$PermissionGroup int ), 0, (PermissionGroup)permissionGroup, (int)n);
    }

    public static ActivityInfo generateActivityInfo(Activity activity, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateActivityInfo", $$robo$$android_content_pm_PackageParser$generateActivityInfo(android.content.pm.PackageParser$Activity int android.content.pm.PackageUserState int ), 0, (Activity)activity, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ActivityInfo generateActivityInfo(ActivityInfo activityInfo, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateActivityInfo", $$robo$$android_content_pm_PackageParser$generateActivityInfo(android.content.pm.ActivityInfo int android.content.pm.PackageUserState int ), 0, (ActivityInfo)activityInfo, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ServiceInfo generateServiceInfo(Service service, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateServiceInfo", $$robo$$android_content_pm_PackageParser$generateServiceInfo(android.content.pm.PackageParser$Service int android.content.pm.PackageUserState int ), 0, (Service)service, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ProviderInfo generateProviderInfo(Provider provider, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateProviderInfo", $$robo$$android_content_pm_PackageParser$generateProviderInfo(android.content.pm.PackageParser$Provider int android.content.pm.PackageUserState int ), 0, (Provider)provider, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static InstrumentationInfo generateInstrumentationInfo(Instrumentation instrumentation, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generateInstrumentationInfo", $$robo$$android_content_pm_PackageParser$generateInstrumentationInfo(android.content.pm.PackageParser$Instrumentation int ), 0, (Instrumentation)instrumentation, (int)n);
    }

    public static void setCompatibilityModeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setCompatibilityModeEnabled", $$robo$$android_content_pm_PackageParser$setCompatibilityModeEnabled(boolean ), 0, (boolean)bl);
    }

    public static long readFullyIgnoringContents(InputStream inputStream) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("readFullyIgnoringContents", $$robo$$android_content_pm_PackageParser$readFullyIgnoringContents(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static void closeQuietly(Object object) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$android_content_pm_PackageParser$closeQuietly(java.lang.Object ), 0, (Object)object);
    }

    static {
        RobolectricInternals.classInitializing(PackageParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PackageParserException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int error;

        private void $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int error, String detailMessage) {
            this.error = error;
        }

        private void $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int error, String detailMessage, Throwable throwable) {
            this.error = error;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(n, string2);
        }

        public PackageParserException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        private void __constructor__(int n, String string2, Throwable throwable) {
            this.$$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(n, string2, throwable);
        }

        public PackageParserException(int n, String string2, Throwable throwable) {
            super(string2, throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int java.lang.String java.lang.Throwable ), 0, this, n, string2, throwable);
        }

        public /* synthetic */ PackageParserException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageParserException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProviderIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Provider provider;

        private void $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(Provider provider) {
            this.provider = provider;
        }

        private final String $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ProviderIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.provider.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(Provider provider) {
            this.$$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(provider);
        }

        public ProviderIntentInfo(Provider provider) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(android.content.pm.PackageParser$Provider ), 0, this, provider);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$toString(), 0, this);
        }

        public /* synthetic */ ProviderIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProviderIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ServiceIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Service service;

        private void $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(Service _service) {
            this.service = _service;
        }

        private final String $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ServiceIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.service.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(Service service) {
            this.$$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(service);
        }

        public ServiceIntentInfo(Service service) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(android.content.pm.PackageParser$Service ), 0, this, service);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$toString(), 0, this);
        }

        public /* synthetic */ ServiceIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ActivityIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Activity activity;

        private void $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(Activity _activity) {
            this.activity = _activity;
        }

        private final String $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ActivityIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.activity.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(Activity activity) {
            this.$$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(activity);
        }

        public ActivityIntentInfo(Activity activity) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(android.content.pm.PackageParser$Activity ), 0, this, activity);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$toString(), 0, this);
        }

        public /* synthetic */ ActivityIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IntentInfo
    extends IntentFilter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean hasDefault;
        public int labelRes;
        public CharSequence nonLocalizedLabel;
        public int icon;
        public int logo;
        public int banner;
        public int preferred;

        private void $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__();
        }

        public IntentInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Instrumentation
    extends Component
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public InstrumentationInfo info;

        private void $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(ParsePackageItemArgs args, InstrumentationInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_Instrumentation$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Instrumentation$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Instrumentation{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            this.$$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(parsePackageItemArgs, instrumentationInfo);
        }

        public Instrumentation(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            super(parsePackageItemArgs, instrumentationInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(android.content.pm.PackageParser$ParsePackageItemArgs android.content.pm.InstrumentationInfo ), 0, this, parsePackageItemArgs, instrumentationInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Instrumentation$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Instrumentation$toString(), 0, this);
        }

        public /* synthetic */ Instrumentation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instrumentation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Provider
    extends Component<ProviderIntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ProviderInfo info;
        public boolean syncable;

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(ParseComponentArgs args, ProviderInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
            this.syncable = false;
        }

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(Provider existingProvider) {
            this.info = existingProvider.info;
            this.syncable = existingProvider.syncable;
        }

        private final void $$robo$$android_content_pm_PackageParser_Provider$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Provider$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Provider{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(parseComponentArgs, providerInfo);
        }

        public Provider(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            super(parseComponentArgs, providerInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ProviderInfo ), 0, this, parseComponentArgs, providerInfo);
        }

        private void __constructor__(Provider provider) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(provider);
        }

        public Provider(Provider provider) {
            super(provider);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.content.pm.PackageParser$Provider ), 0, this, provider);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Provider$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Provider$toString(), 0, this);
        }

        public /* synthetic */ Provider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Provider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Service
    extends Component<ServiceIntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ServiceInfo info;

        private void $$robo$$android_content_pm_PackageParser_Service$__constructor__(ParseComponentArgs args, ServiceInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        private final void $$robo$$android_content_pm_PackageParser_Service$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Service$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Service{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            this.$$robo$$android_content_pm_PackageParser_Service$__constructor__(parseComponentArgs, serviceInfo);
        }

        public Service(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            super(parseComponentArgs, serviceInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Service$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ServiceInfo ), 0, this, parseComponentArgs, serviceInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Service$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Service$toString(), 0, this);
        }

        public /* synthetic */ Service() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Service)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Activity
    extends Component<ActivityIntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ActivityInfo info;

        private void $$robo$$android_content_pm_PackageParser_Activity$__constructor__(ParseComponentArgs args, ActivityInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        private final void $$robo$$android_content_pm_PackageParser_Activity$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Activity$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Activity{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            this.$$robo$$android_content_pm_PackageParser_Activity$__constructor__(parseComponentArgs, activityInfo);
        }

        public Activity(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            super(parseComponentArgs, activityInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Activity$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ActivityInfo ), 0, this, parseComponentArgs, activityInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Activity$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Activity$toString(), 0, this);
        }

        public /* synthetic */ Activity() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Activity)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PermissionGroup
    extends Component<IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public PermissionGroupInfo info;

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Package _owner) {
            this.info = new PermissionGroupInfo();
        }

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Package _owner, PermissionGroupInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_PermissionGroup$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_PermissionGroup$toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(package_);
        }

        public PermissionGroup(Package package_) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(Package package_, PermissionGroupInfo permissionGroupInfo) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(package_, permissionGroupInfo);
        }

        public PermissionGroup(Package package_, PermissionGroupInfo permissionGroupInfo) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.content.pm.PackageParser$Package android.content.pm.PermissionGroupInfo ), 0, this, package_, permissionGroupInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_PermissionGroup$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_PermissionGroup$toString(), 0, this);
        }

        public /* synthetic */ PermissionGroup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionGroup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Permission
    extends Component<IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public PermissionInfo info;
        public boolean tree;
        public PermissionGroup group;

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Package _owner) {
            this.info = new PermissionInfo();
        }

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Package _owner, PermissionInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_Permission$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Permission$toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(package_);
        }

        public Permission(Package package_) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(Package package_, PermissionInfo permissionInfo) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(package_, permissionInfo);
        }

        public Permission(Package package_, PermissionInfo permissionInfo) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.content.pm.PackageParser$Package android.content.pm.PermissionInfo ), 0, this, package_, permissionInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Permission$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Permission$toString(), 0, this);
        }

        public /* synthetic */ Permission() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Permission)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Component<II extends IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public Package owner;
        public ArrayList<II> intents;
        public String className;
        public Bundle metaData;
        ComponentName componentName;
        String componentShortName;

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Package _owner) {
            this.owner = _owner;
            this.intents = null;
            this.className = null;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(ParsePackageItemArgs args, PackageItemInfo outInfo) {
            TypedValue v;
            int bannerVal;
            int logoVal;
            this.owner = args.owner;
            this.intents = new ArrayList(0);
            String name = args.sa.getNonConfigurationString(args.nameRes, 0);
            if (name == null) {
                this.className = null;
                args.outError[0] = args.tag + " does not specify android:name";
                return;
            }
            outInfo.name = PackageParser.buildClassName(this.owner.applicationInfo.packageName, name, args.outError);
            if (outInfo.name == null) {
                this.className = null;
                args.outError[0] = args.tag + " does not have valid android:name";
                return;
            }
            this.className = outInfo.name;
            int iconVal = args.sa.getResourceId(args.iconRes, 0);
            if (iconVal != 0) {
                outInfo.icon = iconVal;
                outInfo.nonLocalizedLabel = null;
            }
            if ((logoVal = args.sa.getResourceId(args.logoRes, 0)) != 0) {
                outInfo.logo = logoVal;
            }
            if ((bannerVal = args.sa.getResourceId(args.bannerRes, 0)) != 0) {
                outInfo.banner = bannerVal;
            }
            if ((v = args.sa.peekValue(args.labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
                outInfo.nonLocalizedLabel = v.coerceToString();
            }
            outInfo.packageName = this.owner.packageName;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(ParseComponentArgs args, ComponentInfo outInfo) {
            if (args.outError[0] != null) {
                return;
            }
            if (args.processRes != 0) {
                String pname = this.owner.applicationInfo.targetSdkVersion >= 8 ? args.sa.getNonConfigurationString(args.processRes, 1024) : args.sa.getNonResourceString(args.processRes);
                outInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, pname, args.flags, args.sepProcesses, args.outError);
            }
            if (args.descriptionRes != 0) {
                outInfo.descriptionRes = args.sa.getResourceId(args.descriptionRes, 0);
            }
            outInfo.enabled = args.sa.getBoolean(args.enabledRes, true);
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Component<II> clone) {
            this.owner = clone.owner;
            this.intents = clone.intents;
            this.className = clone.className;
            this.componentName = clone.componentName;
            this.componentShortName = clone.componentShortName;
        }

        private final ComponentName $$robo$$android_content_pm_PackageParser_Component$getComponentName() {
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className != null) {
                this.componentName = new ComponentName(this.owner.applicationInfo.packageName, this.className);
            }
            return this.componentName;
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$appendComponentShortName(StringBuilder sb) {
            ComponentName.appendShortString(sb, this.owner.applicationInfo.packageName, this.className);
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$printComponentShortName(PrintWriter pw) {
            ComponentName.printShortString(pw, this.owner.applicationInfo.packageName, this.className);
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$setPackageName(String packageName) {
            this.componentName = null;
            this.componentShortName = null;
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(package_);
        }

        public Component(Package package_) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parsePackageItemArgs, packageItemInfo);
        }

        public Component(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$ParsePackageItemArgs android.content.pm.PackageItemInfo ), 0, this, parsePackageItemArgs, packageItemInfo);
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parseComponentArgs, componentInfo);
        }

        public Component(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this((ParsePackageItemArgs)parseComponentArgs, (PackageItemInfo)componentInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ComponentInfo ), 0, this, parseComponentArgs, componentInfo);
        }

        private void __constructor__(Component<II> component) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(component);
        }

        public Component(Component<II> component) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$Component<II> ), 0, this, component);
        }

        public ComponentName getComponentName() {
            return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$android_content_pm_PackageParser_Component$getComponentName(), 0, this);
        }

        public void appendComponentShortName(StringBuilder stringBuilder) {
            InvokeDynamicSupport.bootstrap("appendComponentShortName", $$robo$$android_content_pm_PackageParser_Component$appendComponentShortName(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        public void printComponentShortName(PrintWriter printWriter) {
            InvokeDynamicSupport.bootstrap("printComponentShortName", $$robo$$android_content_pm_PackageParser_Component$printComponentShortName(java.io.PrintWriter ), 0, this, printWriter);
        }

        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Component$setPackageName(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Component() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Component)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Package
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public String[] splitNames;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public int[] splitFlags;
        public boolean baseHardwareAccelerated;
        public ApplicationInfo applicationInfo;
        public ArrayList<Permission> permissions;
        public ArrayList<PermissionGroup> permissionGroups;
        public ArrayList<Activity> activities;
        public ArrayList<Activity> receivers;
        public ArrayList<Provider> providers;
        public ArrayList<Service> services;
        public ArrayList<Instrumentation> instrumentation;
        public ArrayList<String> requestedPermissions;
        public ArrayList<Boolean> requestedPermissionsRequired;
        public ArrayList<String> protectedBroadcasts;
        public ArrayList<String> libraryNames;
        public ArrayList<String> usesLibraries;
        public ArrayList<String> usesOptionalLibraries;
        public String[] usesLibraryFiles;
        public ArrayList<ActivityIntentInfo> preferredActivityFilters;
        public ArrayList<String> mOriginalPackages;
        public String mRealPackage;
        public ArrayList<String> mAdoptPermissions;
        public Bundle mAppMetaData;
        public int mVersionCode;
        public String mVersionName;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public Signature[] mSignatures;
        public Certificate[][] mCertificates;
        public int mPreferredOrder;
        public ArraySet<String> mDexOptPerformed;
        public long mLastPackageUsageTimeInMills;
        public Object mExtras;
        public boolean mOperationPending;
        public ArrayList<ConfigurationInfo> configPreferences;
        public ArrayList<FeatureInfo> reqFeatures;
        public ArrayList<FeatureGroupInfo> featureGroups;
        public int installLocation;
        public boolean coreApp;
        public boolean mRequiredForAllUsers;
        public String mRestrictedAccountType;
        public String mRequiredAccountType;
        public ManifestDigest manifestDigest;
        public String mOverlayTarget;
        public int mOverlayPriority;
        public boolean mTrustedOverlay;
        public ArraySet<PublicKey> mSigningKeys;
        public ArraySet<String> mUpgradeKeySets;
        public ArrayMap<String, ArraySet<PublicKey>> mKeySetMapping;
        public String cpuAbiOverride;

        private void $$robo$$android_content_pm_PackageParser_Package$__constructor__(String packageName) {
            this.applicationInfo = new ApplicationInfo();
            this.permissions = new ArrayList(0);
            this.permissionGroups = new ArrayList(0);
            this.activities = new ArrayList(0);
            this.receivers = new ArrayList(0);
            this.providers = new ArrayList(0);
            this.services = new ArrayList(0);
            this.instrumentation = new ArrayList(0);
            this.requestedPermissions = new ArrayList();
            this.requestedPermissionsRequired = new ArrayList();
            this.libraryNames = null;
            this.usesLibraries = null;
            this.usesOptionalLibraries = null;
            this.usesLibraryFiles = null;
            this.preferredActivityFilters = null;
            this.mOriginalPackages = null;
            this.mRealPackage = null;
            this.mAdoptPermissions = null;
            this.mAppMetaData = null;
            this.mPreferredOrder = 0;
            this.mDexOptPerformed = new ArraySet(4);
            this.configPreferences = null;
            this.reqFeatures = null;
            this.featureGroups = null;
            this.packageName = packageName;
            this.applicationInfo.packageName = packageName;
            this.applicationInfo.uid = -1;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getAllCodePathsExcludingResourceOnly() {
            ArrayList<String> paths = new ArrayList<String>();
            if ((this.applicationInfo.flags & 4) != 0) {
                paths.add(this.baseCodePath);
            }
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                for (int i = 0; i < this.splitCodePaths.length; ++i) {
                    if ((this.splitFlags[i] & 4) == 0) continue;
                    paths.add(this.splitCodePaths[i]);
                }
            }
            return paths;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setPackageName(String newName) {
            int i;
            this.packageName = newName;
            this.applicationInfo.packageName = newName;
            for (i = this.permissions.size() - 1; i >= 0; --i) {
                this.permissions.get(i).setPackageName(newName);
            }
            for (i = this.permissionGroups.size() - 1; i >= 0; --i) {
                this.permissionGroups.get(i).setPackageName(newName);
            }
            for (i = this.activities.size() - 1; i >= 0; --i) {
                this.activities.get(i).setPackageName(newName);
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                this.receivers.get(i).setPackageName(newName);
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                this.providers.get(i).setPackageName(newName);
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                this.services.get(i).setPackageName(newName);
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                this.instrumentation.get(i).setPackageName(newName);
            }
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$hasComponentClassName(String name) {
            int i;
            for (i = this.activities.size() - 1; i >= 0; --i) {
                if (!name.equals(this.activities.get((int)i).className)) continue;
                return true;
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.receivers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.providers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                if (!name.equals(this.services.get((int)i).className)) continue;
                return true;
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                if (!name.equals(this.instrumentation.get((int)i).className)) continue;
                return true;
            }
            return false;
        }

        private final String $$robo$$android_content_pm_PackageParser_Package$toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_pm_PackageParser_Package$__constructor__(string2);
        }

        public Package(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Package$__constructor__(java.lang.String ), 0, this, string2);
        }

        public List<String> getAllCodePaths() {
            return InvokeDynamicSupport.bootstrap("getAllCodePaths", $$robo$$android_content_pm_PackageParser_Package$getAllCodePaths(), 0, this);
        }

        public List<String> getAllCodePathsExcludingResourceOnly() {
            return InvokeDynamicSupport.bootstrap("getAllCodePathsExcludingResourceOnly", $$robo$$android_content_pm_PackageParser_Package$getAllCodePathsExcludingResourceOnly(), 0, this);
        }

        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Package$setPackageName(java.lang.String ), 0, this, string2);
        }

        public boolean hasComponentClassName(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasComponentClassName", $$robo$$android_content_pm_PackageParser_Package$hasComponentClassName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Package$toString(), 0, this);
        }

        public /* synthetic */ Package() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Package)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__() {
        }

        private final int $$robo$$android_content_pm_PackageParser_SplitNameComparator$compare(String lhs, String rhs) {
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__();
        }

        private SplitNameComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(), 0, this);
        }

        @Override
        public int compare(String string2, String string3) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_content_pm_PackageParser_SplitNameComparator$compare(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitNameComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ApkLite
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String codePath;
        public String packageName;
        public String splitName;
        public int versionCode;
        public int installLocation;
        public VerifierInfo[] verifiers;
        public Signature[] signatures;
        public boolean coreApp;
        public boolean multiArch;

        private void $$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(String codePath, String packageName, String splitName, int versionCode, int installLocation, List<VerifierInfo> verifiers, Signature[] signatures, boolean coreApp, boolean multiArch) {
            this.codePath = codePath;
            this.packageName = packageName;
            this.splitName = splitName;
            this.versionCode = versionCode;
            this.installLocation = installLocation;
            this.verifiers = verifiers.toArray(new VerifierInfo[verifiers.size()]);
            this.signatures = signatures;
            this.coreApp = coreApp;
            this.multiArch = multiArch;
        }

        private void __constructor__(String string2, String string3, String string4, int n, int n2, List<VerifierInfo> list, Signature[] signatureArray, boolean bl, boolean bl2) {
            this.$$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(string2, string3, string4, n, n2, list, signatureArray, bl, bl2);
        }

        public ApkLite(String string2, String string3, String string4, int n, int n2, List<VerifierInfo> list, Signature[] signatureArray, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(java.lang.String java.lang.String java.lang.String int int java.util.List<android.content.pm.VerifierInfo> android.content.pm.Signature[] boolean boolean ), 0, this, string2, string3, string4, n, n2, list, signatureArray, bl, bl2);
        }

        public /* synthetic */ ApkLite() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkLite)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PackageLite
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public int versionCode;
        public int installLocation;
        public VerifierInfo[] verifiers;
        public String[] splitNames;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public boolean coreApp;
        public boolean multiArch;

        private void $$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(String codePath, ApkLite baseApk, String[] splitNames, String[] splitCodePaths) {
            this.packageName = baseApk.packageName;
            this.versionCode = baseApk.versionCode;
            this.installLocation = baseApk.installLocation;
            this.verifiers = baseApk.verifiers;
            this.splitNames = splitNames;
            this.codePath = codePath;
            this.baseCodePath = baseApk.codePath;
            this.splitCodePaths = splitCodePaths;
            this.coreApp = baseApk.coreApp;
            this.multiArch = baseApk.multiArch;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_PackageLite$getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        private void __constructor__(String string2, ApkLite apkLite, String[] stringArray, String[] stringArray2) {
            this.$$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(string2, apkLite, stringArray, stringArray2);
        }

        public PackageLite(String string2, ApkLite apkLite, String[] stringArray, String[] stringArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(java.lang.String android.content.pm.PackageParser$ApkLite java.lang.String[] java.lang.String[] ), 0, this, string2, apkLite, stringArray, stringArray2);
        }

        public List<String> getAllCodePaths() {
            return InvokeDynamicSupport.bootstrap("getAllCodePaths", $$robo$$android_content_pm_PackageParser_PackageLite$getAllCodePaths(), 0, this);
        }

        public /* synthetic */ PackageLite() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageLite)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParseComponentArgs
    extends ParsePackageItemArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String[] sepProcesses;
        int processRes;
        int descriptionRes;
        int enabledRes;
        int flags;

        private void $$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _logoRes, int _bannerRes, String[] _sepProcesses, int _processRes, int _descriptionRes, int _enabledRes) {
            this.sepProcesses = _sepProcesses;
            this.processRes = _processRes;
            this.descriptionRes = _descriptionRes;
            this.enabledRes = _enabledRes;
        }

        private void __constructor__(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, String[] stringArray2, int n6, int n7, int n8) {
            this.$$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(package_, stringArray, n, n2, n3, n4, n5, stringArray2, n6, n7, n8);
        }

        ParseComponentArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, String[] stringArray2, int n6, int n7, int n8) {
            super(package_, stringArray, n, n2, n3, n4, n5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(android.content.pm.PackageParser$Package java.lang.String[] int int int int int java.lang.String[] int int int ), 0, this, package_, stringArray, n, n2, n3, n4, n5, stringArray2, n6, n7, n8);
        }

        public /* synthetic */ ParseComponentArgs() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseComponentArgs)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParsePackageItemArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Package owner;
        String[] outError;
        int nameRes;
        int labelRes;
        int iconRes;
        int logoRes;
        int bannerRes;
        String tag;
        TypedArray sa;

        private void $$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _logoRes, int _bannerRes) {
            this.owner = _owner;
            this.outError = _outError;
            this.nameRes = _nameRes;
            this.labelRes = _labelRes;
            this.iconRes = _iconRes;
            this.logoRes = _logoRes;
            this.bannerRes = _bannerRes;
        }

        private void __constructor__(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(package_, stringArray, n, n2, n3, n4, n5);
        }

        ParsePackageItemArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(android.content.pm.PackageParser$Package java.lang.String[] int int int int int ), 0, this, package_, stringArray, n, n2, n3, n4, n5);
        }

        public /* synthetic */ ParsePackageItemArgs() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParsePackageItemArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SplitPermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String rootPerm;
        public String[] newPerms;
        public int targetSdk;

        private void $$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(String rootPerm, String[] newPerms, int targetSdk) {
            this.rootPerm = rootPerm;
            this.newPerms = newPerms;
            this.targetSdk = targetSdk;
        }

        private void __constructor__(String string2, String[] stringArray, int n) {
            this.$$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(string2, stringArray, n);
        }

        public SplitPermissionInfo(String string2, String[] stringArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(java.lang.String java.lang.String[] int ), 0, this, string2, stringArray, n);
        }

        public /* synthetic */ SplitPermissionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitPermissionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NewPermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String name;
        public int sdkVersion;
        public int fileVersion;

        private void $$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(String name, int sdkVersion, int fileVersion) {
            this.name = name;
            this.sdkVersion = sdkVersion;
            this.fileVersion = fileVersion;
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(string2, n, n2);
        }

        public NewPermissionInfo(String string2, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public /* synthetic */ NewPermissionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NewPermissionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

