/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RegisteredServicesCache<V> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PackageManager";
    private static boolean DEBUG = false;
    public Context mContext;
    private String mInterfaceName;
    private String mMetaDataName;
    private String mAttributesName;
    private XmlSerializerAndParser<V> mSerializerAndParser;
    private Object mServicesLock;
    @GuardedBy(value="mServicesLock")
    private boolean mPersistentServicesFileDidNotExist;
    @GuardedBy(value="mServicesLock")
    private SparseArray<UserServices<V>> mUserServices;
    private AtomicFile mPersistentServicesFile;
    private RegisteredServicesCacheListener<V> mListener;
    private Handler mHandler;
    private BroadcastReceiver mPackageReceiver;
    private BroadcastReceiver mExternalReceiver;

    private final UserServices<V> $$robo$$android_content_pm_RegisteredServicesCache$findOrCreateUserLocked(int userId) {
        UserServices<V> services = this.mUserServices.get(userId);
        if (services == null) {
            services = new UserServices();
            this.mUserServices.put(userId, services);
        }
        return services;
    }

    private void $$robo$$android_content_pm_RegisteredServicesCache$__constructor__(Context context, String interfaceName, String metaDataName, String attributeName, XmlSerializerAndParser<V> serializerAndParser) {
        this.mServicesLock = new Object();
        this.mUserServices = new SparseArray(2);
        this.mPackageReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_1$__constructor__(RegisteredServicesCache registeredServicesCache) {
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_1$onReceive(Context context, Intent intent) {
                int uid = intent.getIntExtra("android.intent.extra.UID", -1);
                if (uid != -1) {
                    this.this$0.handlePackageEvent(intent, UserHandle.getUserId(uid));
                }
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_1$__constructor__(registeredServicesCache);
            }
            {
                this.this$0 = registeredServicesCache;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_1$__constructor__(android.content.pm.RegisteredServicesCache ), 0, this, registeredServicesCache);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_content_pm_RegisteredServicesCache_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mExternalReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_2$__constructor__(RegisteredServicesCache registeredServicesCache) {
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_2$onReceive(Context context, Intent intent) {
                this.this$0.handlePackageEvent(intent, 0);
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_2$__constructor__(registeredServicesCache);
            }
            {
                this.this$0 = registeredServicesCache;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_2$__constructor__(android.content.pm.RegisteredServicesCache ), 0, this, registeredServicesCache);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_content_pm_RegisteredServicesCache_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mInterfaceName = interfaceName;
        this.mMetaDataName = metaDataName;
        this.mAttributesName = attributeName;
        this.mSerializerAndParser = serializerAndParser;
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File syncDir = new File(systemDir, "registered_services");
        this.mPersistentServicesFile = new AtomicFile(new File(syncDir, interfaceName + ".xml"));
        this.readPersistentServicesLocked();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mPackageReceiver, UserHandle.ALL, intentFilter, null, null);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mExternalReceiver, sdFilter);
    }

    private final void $$robo$$android_content_pm_RegisteredServicesCache$handlePackageEvent(Intent intent, int userId) {
        String action = intent.getAction();
        boolean isRemoval = "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action);
        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
        if (!isRemoval || !replacing) {
            this.generateServicesMap(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$invalidateCache(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            user.services = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$dump(FileDescriptor fd, PrintWriter fout, String[] args, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services != null) {
                fout.println("RegisteredServicesCache: " + user.services.size() + " services");
                for (ServiceInfo info : user.services.values()) {
                    fout.println("  " + info);
                }
            } else {
                fout.println("RegisteredServicesCache: services not loaded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RegisteredServicesCacheListener<V> $$robo$$android_content_pm_RegisteredServicesCache$getListener() {
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$setListener(RegisteredServicesCacheListener<V> listener, Handler handler) {
        if (handler == null) {
            handler = new Handler(this.mContext.getMainLooper());
        }
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            this.mHandler = handler;
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$notifyListener(V type, int userId, boolean removed) {
        Handler handler;
        RegisteredServicesCacheListener<V> listener;
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            listener = this.mListener;
            handler = this.mHandler;
        }
        if (listener == null) {
            return;
        }
        RegisteredServicesCacheListener<V> listener2 = listener;
        handler.post(new Runnable(this, listener2, type, userId, removed){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCacheListener val$listener2;
            /* synthetic */ Object val$type;
            /* synthetic */ int val$userId;
            /* synthetic */ boolean val$removed;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_3$__constructor__(RegisteredServicesCache registeredServicesCache, RegisteredServicesCacheListener registeredServicesCacheListener, Object object, int n, boolean bl) {
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_3$run() {
                this.val$listener2.onServiceChanged(this.val$type, this.val$userId, this.val$removed);
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache, RegisteredServicesCacheListener registeredServicesCacheListener, Object object, int n, boolean bl) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_3$__constructor__(registeredServicesCache, registeredServicesCacheListener, object, n, bl);
            }
            {
                this.this$0 = registeredServicesCache;
                this.val$listener2 = registeredServicesCacheListener;
                this.val$type = object;
                this.val$userId = n;
                this.val$removed = bl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_3$__constructor__(android.content.pm.RegisteredServicesCache android.content.pm.RegisteredServicesCacheListener java.lang.Object int boolean ), 0, this, registeredServicesCache, registeredServicesCacheListener, object, n, bl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_content_pm_RegisteredServicesCache_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceInfo<V> $$robo$$android_content_pm_RegisteredServicesCache$getServiceInfo(V type, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(userId);
            }
            return user.services.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<ServiceInfo<V>> $$robo$$android_content_pm_RegisteredServicesCache$getAllServices(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(userId);
            }
            return Collections.unmodifiableCollection(new ArrayList(user.services.values()));
        }
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$inSystemImage(int callerUid) {
        String[] packages;
        for (String name : packages = this.mContext.getPackageManager().getPackagesForUid(callerUid)) {
            try {
                PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(name, 0);
                if ((packageInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$generateServicesMap(int userId) {
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList<ServiceInfo<V>> serviceInfos = new ArrayList<ServiceInfo<V>>();
        List<ResolveInfo> resolveInfos = pm.queryIntentServicesAsUser(new Intent(this.mInterfaceName), 128, userId);
        for (ResolveInfo resolveInfo : resolveInfos) {
            try {
                ServiceInfo<V> info = this.parseServiceInfo(resolveInfo);
                if (info == null) {
                    Log.w("PackageManager", "Unable to load service info " + resolveInfo.toString());
                    continue;
                }
                serviceInfos.add(info);
            }
            catch (XmlPullParserException e) {
                Log.w("PackageManager", "Unable to load service info " + resolveInfo.toString(), e);
            }
            catch (IOException e) {
                Log.w("PackageManager", "Unable to load service info " + resolveInfo.toString(), e);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            boolean firstScan;
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            boolean bl = firstScan = user.services == null;
            if (firstScan) {
                user.services = Maps.newHashMap();
            } else {
                user.services.clear();
            }
            StringBuilder changes = new StringBuilder();
            boolean changed = false;
            for (ServiceInfo serviceInfo : serviceInfos) {
                Integer previousUid = user.persistentServices.get(serviceInfo.type);
                if (previousUid == null) {
                    changed = true;
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (this.mPersistentServicesFileDidNotExist && firstScan) continue;
                    this.notifyListener(serviceInfo.type, userId, false);
                    continue;
                }
                if (previousUid == serviceInfo.uid) {
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (!this.inSystemImage(serviceInfo.uid) && this.containsTypeAndUid(serviceInfos, serviceInfo.type, previousUid)) continue;
                changed = true;
                user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                this.notifyListener(serviceInfo.type, userId, false);
            }
            ArrayList toBeRemoved = Lists.newArrayList();
            for (Object v1 : user.persistentServices.keySet()) {
                if (this.containsType(serviceInfos, v1)) continue;
                toBeRemoved.add(v1);
            }
            for (Object v1 : toBeRemoved) {
                changed = true;
                user.persistentServices.remove(v1);
                this.notifyListener(v1, userId, true);
            }
            if (changed) {
                this.writePersistentServicesLocked();
            }
        }
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$containsType(ArrayList<ServiceInfo<V>> serviceInfos, V type) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            if (!serviceInfos.get((int)i).type.equals(type)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$containsTypeAndUid(ArrayList<ServiceInfo<V>> serviceInfos, V type, int uid) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo<V> serviceInfo = serviceInfos.get(i);
            if (!serviceInfo.type.equals(type) || serviceInfo.uid != uid) continue;
            return true;
        }
        return false;
    }

    private final ServiceInfo<V> $$robo$$android_content_pm_RegisteredServicesCache$parseServiceInfo(ResolveInfo service) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo si = service.serviceInfo;
        ComponentName componentName = new ComponentName(si.packageName, si.name);
        PackageManager pm = this.mContext.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, this.mMetaDataName);
            if (parser == null) {
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!this.mAttributesName.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(pm.getResourcesForApplication(si.applicationInfo), si.packageName, attrs);
            if (v == null) {
                ServiceInfo<V> serviceInfo = null;
                return serviceInfo;
            }
            android.content.pm.ServiceInfo serviceInfo = service.serviceInfo;
            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
            int uid = applicationInfo.uid;
            ServiceInfo<V> serviceInfo2 = new ServiceInfo<V>(v, componentName, uid);
            return serviceInfo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$readPersistentServicesLocked() {
        block20: {
            this.mUserServices.clear();
            if (this.mSerializerAndParser == null) {
                return;
            }
            FileInputStream fis = null;
            try {
                boolean bl = this.mPersistentServicesFileDidNotExist = !this.mPersistentServicesFile.getBaseFile().exists();
                if (this.mPersistentServicesFileDidNotExist) {
                    return;
                }
                fis = this.mPersistentServicesFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, null);
                int eventType = parser.getEventType();
                while (eventType != 2 && eventType != 1) {
                    eventType = parser.next();
                }
                String tagName = parser.getName();
                if (!"services".equals(tagName)) break block20;
                eventType = parser.next();
                do {
                    if (eventType != 2 || parser.getDepth() != 2 || !"service".equals(tagName = parser.getName())) continue;
                    V service = this.mSerializerAndParser.createFromXml(parser);
                    if (service == null) {
                        break;
                    }
                    String uidString = parser.getAttributeValue(null, "uid");
                    int uid = Integer.parseInt(uidString);
                    int userId = UserHandle.getUserId(uid);
                    UserServices<V> user = this.findOrCreateUserLocked(userId);
                    user.persistentServices.put((Integer)service, uid);
                } while ((eventType = parser.next()) != 1);
            }
            catch (Exception e) {
                Log.w("PackageManager", "Error reading persistent services, starting from scratch", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private final void $$robo$$android_content_pm_RegisteredServicesCache$writePersistentServicesLocked() {
        block5: {
            if (this.mSerializerAndParser == null) {
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = this.mPersistentServicesFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "services");
                for (int i = 0; i < this.mUserServices.size(); ++i) {
                    UserServices<V> user = this.mUserServices.valueAt(i);
                    for (Map.Entry service : user.persistentServices.entrySet()) {
                        out.startTag(null, "service");
                        out.attribute(null, "uid", Integer.toString(service.getValue()));
                        this.mSerializerAndParser.writeAsXml(service.getKey(), out);
                        out.endTag(null, "service");
                    }
                }
                out.endTag(null, "services");
                out.endDocument();
                this.mPersistentServicesFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w("PackageManager", "Error writing accounts", e1);
                if (fos == null) break block5;
                this.mPersistentServicesFile.failWrite(fos);
            }
        }
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    private UserServices<V> findOrCreateUserLocked(int n) {
        return InvokeDynamicSupport.bootstrap("findOrCreateUserLocked", $$robo$$android_content_pm_RegisteredServicesCache$findOrCreateUserLocked(int ), 0, this, n);
    }

    private void __constructor__(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        this.$$robo$$android_content_pm_RegisteredServicesCache$__constructor__(context, string2, string3, string4, xmlSerializerAndParser);
    }

    public RegisteredServicesCache(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache$__constructor__(android.content.Context java.lang.String java.lang.String java.lang.String android.content.pm.XmlSerializerAndParser<V> ), 0, this, context, string2, string3, string4, xmlSerializerAndParser);
    }

    private void handlePackageEvent(Intent intent, int n) {
        InvokeDynamicSupport.bootstrap("handlePackageEvent", $$robo$$android_content_pm_RegisteredServicesCache$handlePackageEvent(android.content.Intent int ), 0, this, intent, n);
    }

    public void invalidateCache(int n) {
        InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$android_content_pm_RegisteredServicesCache$invalidateCache(int ), 0, this, n);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray, int n) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_pm_RegisteredServicesCache$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] int ), 0, this, fileDescriptor, printWriter, stringArray, n);
    }

    public RegisteredServicesCacheListener<V> getListener() {
        return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_content_pm_RegisteredServicesCache$getListener(), 0, this);
    }

    public void setListener(RegisteredServicesCacheListener<V> registeredServicesCacheListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_content_pm_RegisteredServicesCache$setListener(android.content.pm.RegisteredServicesCacheListener<V> android.os.Handler ), 0, this, registeredServicesCacheListener, handler);
    }

    private void notifyListener(V v, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyListener", $$robo$$android_content_pm_RegisteredServicesCache$notifyListener(V int boolean ), 0, this, v, n, bl);
    }

    public ServiceInfo<V> getServiceInfo(V v, int n) {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_content_pm_RegisteredServicesCache$getServiceInfo(V int ), 0, this, v, n);
    }

    public Collection<ServiceInfo<V>> getAllServices(int n) {
        return InvokeDynamicSupport.bootstrap("getAllServices", $$robo$$android_content_pm_RegisteredServicesCache$getAllServices(int ), 0, this, n);
    }

    private boolean inSystemImage(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("inSystemImage", $$robo$$android_content_pm_RegisteredServicesCache$inSystemImage(int ), 0, this, n);
    }

    private void generateServicesMap(int n) {
        InvokeDynamicSupport.bootstrap("generateServicesMap", $$robo$$android_content_pm_RegisteredServicesCache$generateServicesMap(int ), 0, this, n);
    }

    private boolean containsType(ArrayList<ServiceInfo<V>> arrayList, V v) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsType", $$robo$$android_content_pm_RegisteredServicesCache$containsType(java.util.ArrayList<android.content.pm.RegisteredServicesCache$ServiceInfo<V>> V ), 0, this, arrayList, v);
    }

    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> arrayList, V v, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsTypeAndUid", $$robo$$android_content_pm_RegisteredServicesCache$containsTypeAndUid(java.util.ArrayList<android.content.pm.RegisteredServicesCache$ServiceInfo<V>> V int ), 0, this, arrayList, v, n);
    }

    private ServiceInfo<V> parseServiceInfo(ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseServiceInfo", $$robo$$android_content_pm_RegisteredServicesCache$parseServiceInfo(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    private void readPersistentServicesLocked() {
        InvokeDynamicSupport.bootstrap("readPersistentServicesLocked", $$robo$$android_content_pm_RegisteredServicesCache$readPersistentServicesLocked(), 0, this);
    }

    private void writePersistentServicesLocked() {
        InvokeDynamicSupport.bootstrap("writePersistentServicesLocked", $$robo$$android_content_pm_RegisteredServicesCache$writePersistentServicesLocked(), 0, this);
    }

    public /* synthetic */ RegisteredServicesCache() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegisteredServicesCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ServiceInfo<V> {
        public transient /* synthetic */ Object __robo_data__;
        public V type;
        public ComponentName componentName;
        public int uid;

        private void $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$__constructor__(V type, ComponentName componentName, int uid) {
            this.type = type;
            this.componentName = componentName;
            this.uid = uid;
        }

        private final String $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }

        private void __constructor__(V v, ComponentName componentName, int n) {
            this.$$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$__constructor__(v, componentName, n);
        }

        public ServiceInfo(V v, ComponentName componentName, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$__constructor__(V android.content.ComponentName int ), 0, this, v, componentName, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$toString(), 0, this);
        }

        public /* synthetic */ ServiceInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class UserServices<V> {
        public transient /* synthetic */ Object __robo_data__;
        @GuardedBy(value="mServicesLock")
        public Map<V, Integer> persistentServices;
        @GuardedBy(value="mServicesLock")
        public Map<V, ServiceInfo<V>> services;

        private void $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__() {
            this.persistentServices = Maps.newHashMap();
            this.services = null;
        }

        private /* synthetic */ void $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__();
        }

        private UserServices() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserServices)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

