/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.util.SparseArray;
import android.util.StateSet;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorStateList
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int[][] mStateSpecs;
    private int[] mColors;
    private int mDefaultColor;
    private static int[][] EMPTY;
    private static SparseArray<WeakReference<ColorStateList>> sCache;
    public static Parcelable.Creator<ColorStateList> CREATOR;

    private void $$robo$$android_content_res_ColorStateList$__constructor__() {
        this.mDefaultColor = -65536;
    }

    private void $$robo$$android_content_res_ColorStateList$__constructor__(int[][] states, int[] colors) {
        this.mDefaultColor = -65536;
        this.mStateSpecs = states;
        this.mColors = colors;
        if (states.length > 0) {
            this.mDefaultColor = colors[0];
            for (int i = 0; i < states.length; ++i) {
                if (states[i].length != 0) continue;
                this.mDefaultColor = colors[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ColorStateList $$robo$$android_content_res_ColorStateList$valueOf(int color2) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            ColorStateList csl;
            WeakReference<ColorStateList> ref = sCache.get(color2);
            ColorStateList colorStateList = csl = ref != null ? (ColorStateList)ref.get() : null;
            if (csl != null) {
                return csl;
            }
            csl = new ColorStateList(EMPTY, new int[]{color2});
            sCache.put(color2, new WeakReference<ColorStateList>(csl));
            return csl;
        }
    }

    private static final ColorStateList $$robo$$android_content_res_ColorStateList$createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return ColorStateList.createFromXmlInner(r, parser, attrs);
    }

    private static final ColorStateList $$robo$$android_content_res_ColorStateList$createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        String name = parser.getName();
        if (!name.equals("selector")) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid drawable tag " + name);
        }
        ColorStateList colorStateList = new ColorStateList();
        colorStateList.inflate(r, parser, attrs);
        return colorStateList;
    }

    private final ColorStateList $$robo$$android_content_res_ColorStateList$withAlpha(int alpha) {
        int[] colors = new int[this.mColors.length];
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            colors[i] = this.mColors[i] & 0xFFFFFF | alpha << 24;
        }
        return new ColorStateList(this.mStateSpecs, colors);
    }

    private final void $$robo$$android_content_res_ColorStateList$inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        int[][] stateSpecList = ArrayUtils.newUnpaddedArray(int[].class, 20);
        int[] colorList = new int[stateSpecList.length];
        int listSize = 0;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            int stateResId;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int alphaRes = 0;
            float alpha = 1.0f;
            int colorRes = 0;
            int color2 = -65536;
            boolean haveColor = false;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] stateSpec = new int[numAttrs];
            for (int i = 0; i < numAttrs && (stateResId = attrs.getAttributeNameResource(i)) != 0; ++i) {
                if (stateResId == 16843551) {
                    alphaRes = attrs.getAttributeResourceValue(i, 0);
                    if (alphaRes != 0) continue;
                    alpha = attrs.getAttributeFloatValue(i, 1.0f);
                    continue;
                }
                if (stateResId == 16843173) {
                    colorRes = attrs.getAttributeResourceValue(i, 0);
                    if (colorRes != 0) continue;
                    color2 = attrs.getAttributeIntValue(i, color2);
                    haveColor = true;
                    continue;
                }
                stateSpec[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
            }
            stateSpec = StateSet.trimStateSet(stateSpec, j);
            if (colorRes != 0) {
                color2 = r.getColor(colorRes);
            } else if (!haveColor) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'android:color' attribute.");
            }
            if (alphaRes != 0) {
                alpha = r.getFloat(alphaRes);
            }
            int alphaMod = MathUtils.constrain((int)((float)Color.alpha(color2) * alpha), 0, 255);
            color2 = color2 & 0xFFFFFF | alphaMod << 24;
            if (listSize == 0 || stateSpec.length == 0) {
                this.mDefaultColor = color2;
            }
            colorList = GrowingArrayUtils.append(colorList, listSize, color2);
            stateSpecList = GrowingArrayUtils.append(stateSpecList, listSize, stateSpec);
            ++listSize;
        }
        this.mColors = new int[listSize];
        this.mStateSpecs = new int[listSize][];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])colorList, (int)0, (int[])this.mColors, (int)0, (int)listSize);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)stateSpecList, (int)0, (Object)this.mStateSpecs, (int)0, (int)listSize);
    }

    private final boolean $$robo$$android_content_res_ColorStateList$isStateful() {
        return this.mStateSpecs.length > 1;
    }

    private final boolean $$robo$$android_content_res_ColorStateList$isOpaque() {
        int n = this.mColors.length;
        for (int i = 0; i < n; ++i) {
            if (Color.alpha(this.mColors[i]) == 255) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$android_content_res_ColorStateList$getColorForState(int[] stateSet, int defaultColor) {
        int setLength = this.mStateSpecs.length;
        for (int i = 0; i < setLength; ++i) {
            int[] stateSpec = this.mStateSpecs[i];
            if (!StateSet.stateSetMatches(stateSpec, stateSet)) continue;
            return this.mColors[i];
        }
        return defaultColor;
    }

    private final int $$robo$$android_content_res_ColorStateList$getDefaultColor() {
        return this.mDefaultColor;
    }

    private final int[][] $$robo$$android_content_res_ColorStateList$getStates() {
        return this.mStateSpecs;
    }

    private final int[] $$robo$$android_content_res_ColorStateList$getColors() {
        return this.mColors;
    }

    private static final ColorStateList $$robo$$android_content_res_ColorStateList$addFirstIfMissing(ColorStateList colorStateList, int state, int color2) {
        int[][] inputStates = colorStateList.getStates();
        for (int i = 0; i < inputStates.length; ++i) {
            int[] inputState = inputStates[i];
            for (int j = 0; j < inputState.length; ++j) {
                if (inputState[i] != state) continue;
                return colorStateList;
            }
        }
        int[][] outputStates = new int[inputStates.length + 1][];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)inputStates, (int)0, (Object)outputStates, (int)1, (int)inputStates.length);
        outputStates[0] = new int[]{state};
        int[] inputColors = colorStateList.getColors();
        int[] outputColors = new int[inputColors.length + 1];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])inputColors, (int)0, (int[])outputColors, (int)1, (int)inputColors.length);
        outputColors[0] = color2;
        return new ColorStateList(outputStates, outputColors);
    }

    private final String $$robo$$android_content_res_ColorStateList$toString() {
        return "ColorStateList{mStateSpecs=" + Arrays.deepToString((Object[])this.mStateSpecs) + "mColors=" + Arrays.toString(this.mColors) + "mDefaultColor=" + this.mDefaultColor + '}';
    }

    private final int $$robo$$android_content_res_ColorStateList$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_res_ColorStateList$writeToParcel(Parcel dest, int flags) {
        int N = this.mStateSpecs.length;
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            dest.writeIntArray(this.mStateSpecs[i]);
        }
        dest.writeIntArray(this.mColors);
    }

    static void __staticInitializer__() {
        EMPTY = new int[][]{new int[0]};
        sCache = new SparseArray();
        CREATOR = new Parcelable.Creator<ColorStateList>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_res_ColorStateList_1$__constructor__() {
            }

            private final ColorStateList[] $$robo$$android_content_res_ColorStateList_1$newArray(int size) {
                return new ColorStateList[size];
            }

            private final ColorStateList $$robo$$android_content_res_ColorStateList_1$createFromParcel(Parcel source) {
                int N = source.readInt();
                int[][] stateSpecs = new int[N][];
                for (int i = 0; i < N; ++i) {
                    stateSpecs[i] = source.createIntArray();
                }
                int[] colors = source.createIntArray();
                return new ColorStateList(stateSpecs, colors);
            }

            private void __constructor__() {
                this.$$robo$$android_content_res_ColorStateList_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList_1$__constructor__(), 0, this);
            }

            public ColorStateList[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_res_ColorStateList_1$newArray(int ), 0, this, n);
            }

            @Override
            public ColorStateList createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_res_ColorStateList_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_ColorStateList$__constructor__();
    }

    private ColorStateList() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList$__constructor__(), 0, this);
    }

    private void __constructor__(int[][] nArray, int[] nArray2) {
        this.$$robo$$android_content_res_ColorStateList$__constructor__(nArray, nArray2);
    }

    public ColorStateList(int[][] nArray, int[] nArray2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ColorStateList$__constructor__(int[][] int[] ), 0, this, nArray, nArray2);
    }

    public static ColorStateList valueOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_content_res_ColorStateList$valueOf(int ), 0, (int)n);
    }

    public static ColorStateList createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_content_res_ColorStateList$createFromXml(android.content.res.Resources org.xmlpull.v1.XmlPullParser ), 0, (Resources)resources, (XmlPullParser)xmlPullParser);
    }

    private static ColorStateList createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXmlInner", $$robo$$android_content_res_ColorStateList$createFromXmlInner(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet);
    }

    public ColorStateList withAlpha(int n) {
        return InvokeDynamicSupport.bootstrap("withAlpha", $$robo$$android_content_res_ColorStateList$withAlpha(int ), 0, this, n);
    }

    private void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_content_res_ColorStateList$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, this, resources, xmlPullParser, attributeSet);
    }

    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_content_res_ColorStateList$isStateful(), 0, this);
    }

    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_content_res_ColorStateList$isOpaque(), 0, this);
    }

    public int getColorForState(int[] nArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getColorForState", $$robo$$android_content_res_ColorStateList$getColorForState(int[] int ), 0, this, nArray, n);
    }

    public int getDefaultColor() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultColor", $$robo$$android_content_res_ColorStateList$getDefaultColor(), 0, this);
    }

    public int[][] getStates() {
        return InvokeDynamicSupport.bootstrap("getStates", $$robo$$android_content_res_ColorStateList$getStates(), 0, this);
    }

    public int[] getColors() {
        return InvokeDynamicSupport.bootstrap("getColors", $$robo$$android_content_res_ColorStateList$getColors(), 0, this);
    }

    public static ColorStateList addFirstIfMissing(ColorStateList colorStateList, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("addFirstIfMissing", $$robo$$android_content_res_ColorStateList$addFirstIfMissing(android.content.res.ColorStateList int int ), 0, (ColorStateList)colorStateList, (int)n, (int)n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_ColorStateList$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_res_ColorStateList$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_res_ColorStateList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(ColorStateList.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorStateList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

