/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Configuration
implements Parcelable,
Comparable<Configuration> {
    public transient /* synthetic */ Object __robo_data__;
    public static Configuration EMPTY;
    public float fontScale;
    public int mcc;
    public int mnc;
    public static int MNC_ZERO = 65535;
    public Locale locale;
    public boolean userSetLocale;
    public static int SCREENLAYOUT_SIZE_MASK = 15;
    public static int SCREENLAYOUT_SIZE_UNDEFINED = 0;
    public static int SCREENLAYOUT_SIZE_SMALL = 1;
    public static int SCREENLAYOUT_SIZE_NORMAL = 2;
    public static int SCREENLAYOUT_SIZE_LARGE = 3;
    public static int SCREENLAYOUT_SIZE_XLARGE = 4;
    public static int SCREENLAYOUT_LONG_MASK = 48;
    public static int SCREENLAYOUT_LONG_UNDEFINED = 0;
    public static int SCREENLAYOUT_LONG_NO = 16;
    public static int SCREENLAYOUT_LONG_YES = 32;
    public static int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
    public static int SCREENLAYOUT_LAYOUTDIR_SHIFT = 6;
    public static int SCREENLAYOUT_LAYOUTDIR_UNDEFINED = 0;
    public static int SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    public static int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    public static int SCREENLAYOUT_UNDEFINED = 0;
    public static int SCREENLAYOUT_COMPAT_NEEDED = 0x10000000;
    public int screenLayout;
    public static int TOUCHSCREEN_UNDEFINED = 0;
    public static int TOUCHSCREEN_NOTOUCH = 1;
    @Deprecated
    public static int TOUCHSCREEN_STYLUS = 2;
    public static int TOUCHSCREEN_FINGER = 3;
    public int touchscreen;
    public static int KEYBOARD_UNDEFINED = 0;
    public static int KEYBOARD_NOKEYS = 1;
    public static int KEYBOARD_QWERTY = 2;
    public static int KEYBOARD_12KEY = 3;
    public int keyboard;
    public static int KEYBOARDHIDDEN_UNDEFINED = 0;
    public static int KEYBOARDHIDDEN_NO = 1;
    public static int KEYBOARDHIDDEN_YES = 2;
    public static int KEYBOARDHIDDEN_SOFT = 3;
    public int keyboardHidden;
    public static int HARDKEYBOARDHIDDEN_UNDEFINED = 0;
    public static int HARDKEYBOARDHIDDEN_NO = 1;
    public static int HARDKEYBOARDHIDDEN_YES = 2;
    public int hardKeyboardHidden;
    public static int NAVIGATION_UNDEFINED = 0;
    public static int NAVIGATION_NONAV = 1;
    public static int NAVIGATION_DPAD = 2;
    public static int NAVIGATION_TRACKBALL = 3;
    public static int NAVIGATION_WHEEL = 4;
    public int navigation;
    public static int NAVIGATIONHIDDEN_UNDEFINED = 0;
    public static int NAVIGATIONHIDDEN_NO = 1;
    public static int NAVIGATIONHIDDEN_YES = 2;
    public int navigationHidden;
    public static int ORIENTATION_UNDEFINED = 0;
    public static int ORIENTATION_PORTRAIT = 1;
    public static int ORIENTATION_LANDSCAPE = 2;
    @Deprecated
    public static int ORIENTATION_SQUARE = 3;
    public int orientation;
    public static int UI_MODE_TYPE_MASK = 15;
    public static int UI_MODE_TYPE_UNDEFINED = 0;
    public static int UI_MODE_TYPE_NORMAL = 1;
    public static int UI_MODE_TYPE_DESK = 2;
    public static int UI_MODE_TYPE_CAR = 3;
    public static int UI_MODE_TYPE_TELEVISION = 4;
    public static int UI_MODE_TYPE_APPLIANCE = 5;
    public static int UI_MODE_TYPE_WATCH = 6;
    public static int UI_MODE_NIGHT_MASK = 48;
    public static int UI_MODE_NIGHT_UNDEFINED = 0;
    public static int UI_MODE_NIGHT_NO = 16;
    public static int UI_MODE_NIGHT_YES = 32;
    public int uiMode;
    public static int SCREEN_WIDTH_DP_UNDEFINED = 0;
    public int screenWidthDp;
    public static int SCREEN_HEIGHT_DP_UNDEFINED = 0;
    public int screenHeightDp;
    public static int SMALLEST_SCREEN_WIDTH_DP_UNDEFINED = 0;
    public int smallestScreenWidthDp;
    public static int DENSITY_DPI_UNDEFINED = 0;
    public static int DENSITY_DPI_ANY = 65534;
    public static int DENSITY_DPI_NONE = 65535;
    public int densityDpi;
    public int compatScreenWidthDp;
    public int compatScreenHeightDp;
    public int compatSmallestScreenWidthDp;
    public int seq;
    public static int NATIVE_CONFIG_MCC = 1;
    public static int NATIVE_CONFIG_MNC = 2;
    public static int NATIVE_CONFIG_LOCALE = 4;
    public static int NATIVE_CONFIG_TOUCHSCREEN = 8;
    public static int NATIVE_CONFIG_KEYBOARD = 16;
    public static int NATIVE_CONFIG_KEYBOARD_HIDDEN = 32;
    public static int NATIVE_CONFIG_NAVIGATION = 64;
    public static int NATIVE_CONFIG_ORIENTATION = 128;
    public static int NATIVE_CONFIG_DENSITY = 256;
    public static int NATIVE_CONFIG_SCREEN_SIZE = 512;
    public static int NATIVE_CONFIG_VERSION = 1024;
    public static int NATIVE_CONFIG_SCREEN_LAYOUT = 2048;
    public static int NATIVE_CONFIG_UI_MODE = 4096;
    public static int NATIVE_CONFIG_SMALLEST_SCREEN_SIZE = 8192;
    public static int NATIVE_CONFIG_LAYOUTDIR = 16384;
    public static Parcelable.Creator<Configuration> CREATOR;
    private static String XML_ATTR_FONT_SCALE = "fs";
    private static String XML_ATTR_MCC = "mcc";
    private static String XML_ATTR_MNC = "mnc";
    private static String XML_ATTR_LOCALE = "locale";
    private static String XML_ATTR_TOUCHSCREEN = "touch";
    private static String XML_ATTR_KEYBOARD = "key";
    private static String XML_ATTR_KEYBOARD_HIDDEN = "keyHid";
    private static String XML_ATTR_HARD_KEYBOARD_HIDDEN = "hardKeyHid";
    private static String XML_ATTR_NAVIGATION = "nav";
    private static String XML_ATTR_NAVIGATION_HIDDEN = "navHid";
    private static String XML_ATTR_ORIENTATION = "ori";
    private static String XML_ATTR_SCREEN_LAYOUT = "scrLay";
    private static String XML_ATTR_UI_MODE = "ui";
    private static String XML_ATTR_SCREEN_WIDTH = "width";
    private static String XML_ATTR_SCREEN_HEIGHT = "height";
    private static String XML_ATTR_SMALLEST_WIDTH = "sw";
    private static String XML_ATTR_DENSITY = "density";

    private static final int $$robo$$android_content_res_Configuration$resetScreenLayout(int curLayout) {
        return curLayout & 0xEFFFFFC0 | 0x24;
    }

    private static final int $$robo$$android_content_res_Configuration$reduceScreenLayout(int curLayout, int longSizeDp, int shortSizeDp) {
        int curSize;
        boolean screenLayoutCompatNeeded;
        boolean screenLayoutLong;
        int screenLayoutSize;
        if (longSizeDp < 470) {
            screenLayoutSize = 1;
            screenLayoutLong = false;
            screenLayoutCompatNeeded = false;
        } else {
            screenLayoutSize = longSizeDp >= 960 && shortSizeDp >= 720 ? 4 : (longSizeDp >= 640 && shortSizeDp >= 480 ? 3 : 2);
            screenLayoutCompatNeeded = shortSizeDp > 321 || longSizeDp > 570;
            screenLayoutLong = longSizeDp * 3 / 5 >= shortSizeDp - 1;
        }
        if (!screenLayoutLong) {
            curLayout = curLayout & 0xFFFFFFCF | 0x10;
        }
        if (screenLayoutCompatNeeded) {
            curLayout |= 0x10000000;
        }
        if (screenLayoutSize < (curSize = curLayout & 0xF)) {
            curLayout = curLayout & 0xFFFFFFF0 | screenLayoutSize;
        }
        return curLayout;
    }

    private final boolean $$robo$$android_content_res_Configuration$isLayoutSizeAtLeast(int size) {
        int cur = this.screenLayout & 0xF;
        if (cur == 0) {
            return false;
        }
        return cur >= size;
    }

    private void $$robo$$android_content_res_Configuration$__constructor__() {
        this.setToDefaults();
    }

    private void $$robo$$android_content_res_Configuration$__constructor__(Configuration o) {
        this.setTo(o);
    }

    private final void $$robo$$android_content_res_Configuration$setTo(Configuration o) {
        this.fontScale = o.fontScale;
        this.mcc = o.mcc;
        this.mnc = o.mnc;
        if (o.locale != null) {
            this.locale = (Locale)o.locale.clone();
        }
        this.userSetLocale = o.userSetLocale;
        this.touchscreen = o.touchscreen;
        this.keyboard = o.keyboard;
        this.keyboardHidden = o.keyboardHidden;
        this.hardKeyboardHidden = o.hardKeyboardHidden;
        this.navigation = o.navigation;
        this.navigationHidden = o.navigationHidden;
        this.orientation = o.orientation;
        this.screenLayout = o.screenLayout;
        this.uiMode = o.uiMode;
        this.screenWidthDp = o.screenWidthDp;
        this.screenHeightDp = o.screenHeightDp;
        this.smallestScreenWidthDp = o.smallestScreenWidthDp;
        this.densityDpi = o.densityDpi;
        this.compatScreenWidthDp = o.compatScreenWidthDp;
        this.compatScreenHeightDp = o.compatScreenHeightDp;
        this.compatSmallestScreenWidthDp = o.compatSmallestScreenWidthDp;
        this.seq = o.seq;
    }

    private final String $$robo$$android_content_res_Configuration$toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        sb.append(this.fontScale);
        sb.append(" ");
        if (this.mcc != 0) {
            sb.append(this.mcc);
            sb.append("mcc");
        } else {
            sb.append("?mcc");
        }
        if (this.mnc != 0) {
            sb.append(this.mnc);
            sb.append("mnc");
        } else {
            sb.append("?mnc");
        }
        if (this.locale != null) {
            sb.append(" ");
            sb.append(this.locale);
        } else {
            sb.append(" ?locale");
        }
        int layoutDir = this.screenLayout & 0xC0;
        switch (layoutDir) {
            case 0: {
                sb.append(" ?layoutDir");
                break;
            }
            case 64: {
                sb.append(" ldltr");
                break;
            }
            case 128: {
                sb.append(" ldrtl");
                break;
            }
            default: {
                sb.append(" layoutDir=");
                sb.append(layoutDir >> 6);
            }
        }
        if (this.smallestScreenWidthDp != 0) {
            sb.append(" sw");
            sb.append(this.smallestScreenWidthDp);
            sb.append("dp");
        } else {
            sb.append(" ?swdp");
        }
        if (this.screenWidthDp != 0) {
            sb.append(" w");
            sb.append(this.screenWidthDp);
            sb.append("dp");
        } else {
            sb.append(" ?wdp");
        }
        if (this.screenHeightDp != 0) {
            sb.append(" h");
            sb.append(this.screenHeightDp);
            sb.append("dp");
        } else {
            sb.append(" ?hdp");
        }
        if (this.densityDpi != 0) {
            sb.append(" ");
            sb.append(this.densityDpi);
            sb.append("dpi");
        } else {
            sb.append(" ?density");
        }
        switch (this.screenLayout & 0xF) {
            case 0: {
                sb.append(" ?lsize");
                break;
            }
            case 1: {
                sb.append(" smll");
                break;
            }
            case 2: {
                sb.append(" nrml");
                break;
            }
            case 3: {
                sb.append(" lrg");
                break;
            }
            case 4: {
                sb.append(" xlrg");
                break;
            }
            default: {
                sb.append(" layoutSize=");
                sb.append(this.screenLayout & 0xF);
            }
        }
        switch (this.screenLayout & 0x30) {
            case 0: {
                sb.append(" ?long");
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                sb.append(" long");
                break;
            }
            default: {
                sb.append(" layoutLong=");
                sb.append(this.screenLayout & 0x30);
            }
        }
        switch (this.orientation) {
            case 0: {
                sb.append(" ?orien");
                break;
            }
            case 2: {
                sb.append(" land");
                break;
            }
            case 1: {
                sb.append(" port");
                break;
            }
            default: {
                sb.append(" orien=");
                sb.append(this.orientation);
            }
        }
        switch (this.uiMode & 0xF) {
            case 0: {
                sb.append(" ?uimode");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                sb.append(" desk");
                break;
            }
            case 3: {
                sb.append(" car");
                break;
            }
            case 4: {
                sb.append(" television");
                break;
            }
            case 5: {
                sb.append(" appliance");
                break;
            }
            case 6: {
                sb.append(" watch");
                break;
            }
            default: {
                sb.append(" uimode=");
                sb.append(this.uiMode & 0xF);
            }
        }
        switch (this.uiMode & 0x30) {
            case 0: {
                sb.append(" ?night");
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                sb.append(" night");
                break;
            }
            default: {
                sb.append(" night=");
                sb.append(this.uiMode & 0x30);
            }
        }
        switch (this.touchscreen) {
            case 0: {
                sb.append(" ?touch");
                break;
            }
            case 1: {
                sb.append(" -touch");
                break;
            }
            case 2: {
                sb.append(" stylus");
                break;
            }
            case 3: {
                sb.append(" finger");
                break;
            }
            default: {
                sb.append(" touch=");
                sb.append(this.touchscreen);
            }
        }
        switch (this.keyboard) {
            case 0: {
                sb.append(" ?keyb");
                break;
            }
            case 1: {
                sb.append(" -keyb");
                break;
            }
            case 2: {
                sb.append(" qwerty");
                break;
            }
            case 3: {
                sb.append(" 12key");
                break;
            }
            default: {
                sb.append(" keys=");
                sb.append(this.keyboard);
            }
        }
        switch (this.keyboardHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            case 3: {
                sb.append("/s");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.keyboardHidden);
            }
        }
        switch (this.hardKeyboardHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.hardKeyboardHidden);
            }
        }
        switch (this.navigation) {
            case 0: {
                sb.append(" ?nav");
                break;
            }
            case 1: {
                sb.append(" -nav");
                break;
            }
            case 2: {
                sb.append(" dpad");
                break;
            }
            case 3: {
                sb.append(" tball");
                break;
            }
            case 4: {
                sb.append(" wheel");
                break;
            }
            default: {
                sb.append(" nav=");
                sb.append(this.navigation);
            }
        }
        switch (this.navigationHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.navigationHidden);
            }
        }
        if (this.seq != 0) {
            sb.append(" s.");
            sb.append(this.seq);
        }
        sb.append('}');
        return sb.toString();
    }

    private final void $$robo$$android_content_res_Configuration$setToDefaults() {
        this.fontScale = 1.0f;
        this.mnc = 0;
        this.mcc = 0;
        this.locale = null;
        this.userSetLocale = false;
        this.touchscreen = 0;
        this.keyboard = 0;
        this.keyboardHidden = 0;
        this.hardKeyboardHidden = 0;
        this.navigation = 0;
        this.navigationHidden = 0;
        this.orientation = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.compatScreenWidthDp = 0;
        this.screenWidthDp = 0;
        this.compatScreenHeightDp = 0;
        this.screenHeightDp = 0;
        this.compatSmallestScreenWidthDp = 0;
        this.smallestScreenWidthDp = 0;
        this.densityDpi = 0;
        this.seq = 0;
    }

    @Deprecated
    private final void $$robo$$android_content_res_Configuration$makeDefault() {
        this.setToDefaults();
    }

    private final int $$robo$$android_content_res_Configuration$updateFrom(Configuration delta) {
        int deltaScreenLayoutDir;
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
            this.fontScale = delta.fontScale;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
            this.mcc = delta.mcc;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
            this.mnc = delta.mnc;
        }
        if (!(delta.locale == null || this.locale != null && this.locale.equals(delta.locale))) {
            changed |= 4;
            this.locale = delta.locale != null ? (Locale)delta.locale.clone() : null;
            changed |= 0x2000;
            this.setLayoutDirection(this.locale);
        }
        if ((deltaScreenLayoutDir = delta.screenLayout & 0xC0) != 0 && deltaScreenLayoutDir != (this.screenLayout & 0xC0)) {
            this.screenLayout = this.screenLayout & 0xFFFFFF3F | deltaScreenLayoutDir;
            changed |= 0x2000;
        }
        if (delta.userSetLocale && (!this.userSetLocale || (changed & 4) != 0)) {
            changed |= 4;
            this.userSetLocale = true;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
            this.touchscreen = delta.touchscreen;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
            this.keyboard = delta.keyboard;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
            this.keyboardHidden = delta.keyboardHidden;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
            this.hardKeyboardHidden = delta.hardKeyboardHidden;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
            this.navigation = delta.navigation;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
            this.navigationHidden = delta.navigationHidden;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
            this.orientation = delta.orientation;
        }
        if (Configuration.getScreenLayoutNoDirection(delta.screenLayout) != 0 && Configuration.getScreenLayoutNoDirection(this.screenLayout) != Configuration.getScreenLayoutNoDirection(delta.screenLayout)) {
            changed |= 0x100;
            this.screenLayout = (delta.screenLayout & 0xC0) == 0 ? this.screenLayout & 0xC0 | delta.screenLayout : delta.screenLayout;
        }
        if (delta.uiMode != 0 && this.uiMode != delta.uiMode) {
            changed |= 0x200;
            if ((delta.uiMode & 0xF) != 0) {
                this.uiMode = this.uiMode & 0xFFFFFFF0 | delta.uiMode & 0xF;
            }
            if ((delta.uiMode & 0x30) != 0) {
                this.uiMode = this.uiMode & 0xFFFFFFCF | delta.uiMode & 0x30;
            }
        }
        if (delta.screenWidthDp != 0 && this.screenWidthDp != delta.screenWidthDp) {
            changed |= 0x400;
            this.screenWidthDp = delta.screenWidthDp;
        }
        if (delta.screenHeightDp != 0 && this.screenHeightDp != delta.screenHeightDp) {
            changed |= 0x400;
            this.screenHeightDp = delta.screenHeightDp;
        }
        if (delta.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp != delta.smallestScreenWidthDp) {
            changed |= 0x800;
            this.smallestScreenWidthDp = delta.smallestScreenWidthDp;
        }
        if (delta.densityDpi != 0 && this.densityDpi != delta.densityDpi) {
            changed |= 0x1000;
            this.densityDpi = delta.densityDpi;
        }
        if (delta.compatScreenWidthDp != 0) {
            this.compatScreenWidthDp = delta.compatScreenWidthDp;
        }
        if (delta.compatScreenHeightDp != 0) {
            this.compatScreenHeightDp = delta.compatScreenHeightDp;
        }
        if (delta.compatSmallestScreenWidthDp != 0) {
            this.compatSmallestScreenWidthDp = delta.compatSmallestScreenWidthDp;
        }
        if (delta.seq != 0) {
            this.seq = delta.seq;
        }
        return changed;
    }

    private final int $$robo$$android_content_res_Configuration$diff(Configuration delta) {
        int deltaScreenLayoutDir;
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
        }
        if (!(delta.locale == null || this.locale != null && this.locale.equals(delta.locale))) {
            changed |= 4;
            changed |= 0x2000;
        }
        if ((deltaScreenLayoutDir = delta.screenLayout & 0xC0) != 0 && deltaScreenLayoutDir != (this.screenLayout & 0xC0)) {
            changed |= 0x2000;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
        }
        if (Configuration.getScreenLayoutNoDirection(delta.screenLayout) != 0 && Configuration.getScreenLayoutNoDirection(this.screenLayout) != Configuration.getScreenLayoutNoDirection(delta.screenLayout)) {
            changed |= 0x100;
        }
        if (delta.uiMode != 0 && this.uiMode != delta.uiMode) {
            changed |= 0x200;
        }
        if (delta.screenWidthDp != 0 && this.screenWidthDp != delta.screenWidthDp) {
            changed |= 0x400;
        }
        if (delta.screenHeightDp != 0 && this.screenHeightDp != delta.screenHeightDp) {
            changed |= 0x400;
        }
        if (delta.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp != delta.smallestScreenWidthDp) {
            changed |= 0x800;
        }
        if (delta.densityDpi != 0 && this.densityDpi != delta.densityDpi) {
            changed |= 0x1000;
        }
        return changed;
    }

    private static final boolean $$robo$$android_content_res_Configuration$needNewResources(int configChanges, int interestingChanges) {
        return (configChanges & (interestingChanges | 0x40000000)) != 0;
    }

    private final boolean $$robo$$android_content_res_Configuration$isOtherSeqNewer(Configuration other) {
        if (other == null) {
            return false;
        }
        if (other.seq == 0) {
            return true;
        }
        if (this.seq == 0) {
            return true;
        }
        int diff = other.seq - this.seq;
        if (diff > 65536) {
            return false;
        }
        return diff > 0;
    }

    private final int $$robo$$android_content_res_Configuration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_res_Configuration$writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.fontScale);
        dest.writeInt(this.mcc);
        dest.writeInt(this.mnc);
        if (this.locale == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(this.locale.getLanguage());
            dest.writeString(this.locale.getCountry());
            dest.writeString(this.locale.getVariant());
        }
        if (this.userSetLocale) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.touchscreen);
        dest.writeInt(this.keyboard);
        dest.writeInt(this.keyboardHidden);
        dest.writeInt(this.hardKeyboardHidden);
        dest.writeInt(this.navigation);
        dest.writeInt(this.navigationHidden);
        dest.writeInt(this.orientation);
        dest.writeInt(this.screenLayout);
        dest.writeInt(this.uiMode);
        dest.writeInt(this.screenWidthDp);
        dest.writeInt(this.screenHeightDp);
        dest.writeInt(this.smallestScreenWidthDp);
        dest.writeInt(this.densityDpi);
        dest.writeInt(this.compatScreenWidthDp);
        dest.writeInt(this.compatScreenHeightDp);
        dest.writeInt(this.compatSmallestScreenWidthDp);
        dest.writeInt(this.seq);
    }

    private final void $$robo$$android_content_res_Configuration$readFromParcel(Parcel source) {
        this.fontScale = source.readFloat();
        this.mcc = source.readInt();
        this.mnc = source.readInt();
        if (source.readInt() != 0) {
            this.locale = new Locale(source.readString(), source.readString(), source.readString());
        }
        this.userSetLocale = source.readInt() == 1;
        this.touchscreen = source.readInt();
        this.keyboard = source.readInt();
        this.keyboardHidden = source.readInt();
        this.hardKeyboardHidden = source.readInt();
        this.navigation = source.readInt();
        this.navigationHidden = source.readInt();
        this.orientation = source.readInt();
        this.screenLayout = source.readInt();
        this.uiMode = source.readInt();
        this.screenWidthDp = source.readInt();
        this.screenHeightDp = source.readInt();
        this.smallestScreenWidthDp = source.readInt();
        this.densityDpi = source.readInt();
        this.compatScreenWidthDp = source.readInt();
        this.compatScreenHeightDp = source.readInt();
        this.compatSmallestScreenWidthDp = source.readInt();
        this.seq = source.readInt();
    }

    private void $$robo$$android_content_res_Configuration$__constructor__(Parcel source) {
        this.readFromParcel(source);
    }

    private final int $$robo$$android_content_res_Configuration$compareTo(Configuration that) {
        float a = this.fontScale;
        float b = that.fontScale;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int n = this.mcc - that.mcc;
        if (n != 0) {
            return n;
        }
        n = this.mnc - that.mnc;
        if (n != 0) {
            return n;
        }
        if (this.locale == null) {
            if (that.locale != null) {
                return 1;
            }
        } else {
            if (that.locale == null) {
                return -1;
            }
            n = this.locale.getLanguage().compareTo(that.locale.getLanguage());
            if (n != 0) {
                return n;
            }
            n = this.locale.getCountry().compareTo(that.locale.getCountry());
            if (n != 0) {
                return n;
            }
            n = this.locale.getVariant().compareTo(that.locale.getVariant());
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.touchscreen - that.touchscreen) != 0) {
            return n;
        }
        n = this.keyboard - that.keyboard;
        if (n != 0) {
            return n;
        }
        n = this.keyboardHidden - that.keyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.hardKeyboardHidden - that.hardKeyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.navigation - that.navigation;
        if (n != 0) {
            return n;
        }
        n = this.navigationHidden - that.navigationHidden;
        if (n != 0) {
            return n;
        }
        n = this.orientation - that.orientation;
        if (n != 0) {
            return n;
        }
        n = this.screenLayout - that.screenLayout;
        if (n != 0) {
            return n;
        }
        n = this.uiMode - that.uiMode;
        if (n != 0) {
            return n;
        }
        n = this.screenWidthDp - that.screenWidthDp;
        if (n != 0) {
            return n;
        }
        n = this.screenHeightDp - that.screenHeightDp;
        if (n != 0) {
            return n;
        }
        n = this.smallestScreenWidthDp - that.smallestScreenWidthDp;
        if (n != 0) {
            return n;
        }
        n = this.densityDpi - that.densityDpi;
        return n;
    }

    private final boolean $$robo$$android_content_res_Configuration$equals(Configuration that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this.compareTo(that) == 0;
    }

    private final boolean $$robo$$android_content_res_Configuration$equals(Object that) {
        try {
            return this.equals((Configuration)that);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private final int $$robo$$android_content_res_Configuration$hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToIntBits(this.fontScale);
        result = 31 * result + this.mcc;
        result = 31 * result + this.mnc;
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + this.touchscreen;
        result = 31 * result + this.keyboard;
        result = 31 * result + this.keyboardHidden;
        result = 31 * result + this.hardKeyboardHidden;
        result = 31 * result + this.navigation;
        result = 31 * result + this.navigationHidden;
        result = 31 * result + this.orientation;
        result = 31 * result + this.screenLayout;
        result = 31 * result + this.uiMode;
        result = 31 * result + this.screenWidthDp;
        result = 31 * result + this.screenHeightDp;
        result = 31 * result + this.smallestScreenWidthDp;
        result = 31 * result + this.densityDpi;
        return result;
    }

    private final void $$robo$$android_content_res_Configuration$setLocale(Locale loc) {
        this.locale = loc;
        this.userSetLocale = true;
        this.setLayoutDirection(this.locale);
    }

    private final int $$robo$$android_content_res_Configuration$getLayoutDirection() {
        return (this.screenLayout & 0xC0) == 128 ? 1 : 0;
    }

    private final void $$robo$$android_content_res_Configuration$setLayoutDirection(Locale locale) {
        int layoutDirection = 1 + TextUtils.getLayoutDirectionFromLocale(locale);
        this.screenLayout = this.screenLayout & 0xFFFFFF3F | layoutDirection << 6;
    }

    private static final int $$robo$$android_content_res_Configuration$getScreenLayoutNoDirection(int screenLayout) {
        return screenLayout & 0xFFFFFF3F;
    }

    private static final String $$robo$$android_content_res_Configuration$localeToResourceQualifier(Locale locale) {
        boolean v;
        StringBuilder sb = new StringBuilder();
        boolean l = locale.getLanguage().length() != 0;
        boolean c = locale.getCountry().length() != 0;
        boolean s = locale.getScript().length() != 0;
        boolean bl = v = locale.getVariant().length() != 0;
        if (l) {
            sb.append(locale.getLanguage());
            if (c) {
                sb.append("-r").append(locale.getCountry());
                if (s) {
                    sb.append("-s").append(locale.getScript());
                    if (v) {
                        sb.append("-v").append(locale.getVariant());
                    }
                }
            }
        }
        return sb.toString();
    }

    private static final String $$robo$$android_content_res_Configuration$resourceQualifierString(Configuration config) {
        ArrayList<String> parts = new ArrayList<String>();
        if (config.mcc != 0) {
            parts.add(config.mcc + "mcc");
            if (config.mnc != 0) {
                parts.add(config.mnc + "mnc");
            }
        }
        if (!config.locale.getLanguage().isEmpty()) {
            parts.add(Configuration.localeToResourceQualifier(config.locale));
        }
        switch (config.screenLayout & 0xC0) {
            case 64: {
                parts.add("ldltr");
                break;
            }
            case 128: {
                parts.add("ldrtl");
                break;
            }
        }
        if (config.smallestScreenWidthDp != 0) {
            parts.add("sw" + config.smallestScreenWidthDp + "dp");
        }
        if (config.screenWidthDp != 0) {
            parts.add("w" + config.screenWidthDp + "dp");
        }
        if (config.screenHeightDp != 0) {
            parts.add("h" + config.screenHeightDp + "dp");
        }
        switch (config.screenLayout & 0xF) {
            case 1: {
                parts.add("small");
                break;
            }
            case 2: {
                parts.add("normal");
                break;
            }
            case 3: {
                parts.add("large");
                break;
            }
            case 4: {
                parts.add("xlarge");
                break;
            }
        }
        switch (config.screenLayout & 0x30) {
            case 32: {
                parts.add("long");
                break;
            }
            case 16: {
                parts.add("notlong");
                break;
            }
        }
        switch (config.orientation) {
            case 2: {
                parts.add("land");
                break;
            }
            case 1: {
                parts.add("port");
                break;
            }
        }
        switch (config.uiMode & 0xF) {
            case 5: {
                parts.add("appliance");
                break;
            }
            case 2: {
                parts.add("desk");
                break;
            }
            case 4: {
                parts.add("television");
                break;
            }
            case 3: {
                parts.add("car");
                break;
            }
            case 6: {
                parts.add("watch");
                break;
            }
        }
        switch (config.uiMode & 0x30) {
            case 32: {
                parts.add("night");
                break;
            }
            case 16: {
                parts.add("notnight");
                break;
            }
        }
        switch (config.densityDpi) {
            case 0: {
                break;
            }
            case 120: {
                parts.add("ldpi");
                break;
            }
            case 160: {
                parts.add("mdpi");
                break;
            }
            case 213: {
                parts.add("tvdpi");
                break;
            }
            case 240: {
                parts.add("hdpi");
                break;
            }
            case 320: {
                parts.add("xhdpi");
                break;
            }
            case 480: {
                parts.add("xxhdpi");
                break;
            }
            case 640: {
                parts.add("xxxhdpi");
                break;
            }
            case 65534: {
                parts.add("anydpi");
                break;
            }
            case 65535: {
                parts.add("nodpi");
            }
            default: {
                parts.add(config.densityDpi + "dpi");
            }
        }
        switch (config.touchscreen) {
            case 1: {
                parts.add("notouch");
                break;
            }
            case 3: {
                parts.add("finger");
                break;
            }
        }
        switch (config.keyboardHidden) {
            case 1: {
                parts.add("keysexposed");
                break;
            }
            case 2: {
                parts.add("keyshidden");
                break;
            }
            case 3: {
                parts.add("keyssoft");
                break;
            }
        }
        switch (config.keyboard) {
            case 1: {
                parts.add("nokeys");
                break;
            }
            case 2: {
                parts.add("qwerty");
                break;
            }
            case 3: {
                parts.add("12key");
                break;
            }
        }
        switch (config.navigationHidden) {
            case 1: {
                parts.add("navexposed");
                break;
            }
            case 2: {
                parts.add("navhidden");
                break;
            }
        }
        switch (config.navigation) {
            case 1: {
                parts.add("nonav");
                break;
            }
            case 2: {
                parts.add("dpad");
                break;
            }
            case 3: {
                parts.add("trackball");
                break;
            }
            case 4: {
                parts.add("wheel");
                break;
            }
        }
        parts.add("v" + Build.VERSION.RESOURCES_SDK_INT);
        return TextUtils.join((CharSequence)"-", parts);
    }

    private static final Configuration $$robo$$android_content_res_Configuration$generateDelta(Configuration base, Configuration change) {
        Configuration delta = new Configuration();
        if (base.fontScale != change.fontScale) {
            delta.fontScale = change.fontScale;
        }
        if (base.mcc != change.mcc) {
            delta.mcc = change.mcc;
        }
        if (base.mnc != change.mnc) {
            delta.mnc = change.mnc;
        }
        if (base.locale == null && change.locale != null || base.locale != null && !base.locale.equals(change.locale)) {
            delta.locale = change.locale;
        }
        if (base.touchscreen != change.touchscreen) {
            delta.touchscreen = change.touchscreen;
        }
        if (base.keyboard != change.keyboard) {
            delta.keyboard = change.keyboard;
        }
        if (base.keyboardHidden != change.keyboardHidden) {
            delta.keyboardHidden = change.keyboardHidden;
        }
        if (base.navigation != change.navigation) {
            delta.navigation = change.navigation;
        }
        if (base.navigationHidden != change.navigationHidden) {
            delta.navigationHidden = change.navigationHidden;
        }
        if (base.orientation != change.orientation) {
            delta.orientation = change.orientation;
        }
        if ((base.screenLayout & 0xF) != (change.screenLayout & 0xF)) {
            delta.screenLayout |= change.screenLayout & 0xF;
        }
        if ((base.screenLayout & 0xC0) != (change.screenLayout & 0xC0)) {
            delta.screenLayout |= change.screenLayout & 0xC0;
        }
        if ((base.screenLayout & 0x30) != (change.screenLayout & 0x30)) {
            delta.screenLayout |= change.screenLayout & 0x30;
        }
        if ((base.uiMode & 0xF) != (change.uiMode & 0xF)) {
            delta.uiMode |= change.uiMode & 0xF;
        }
        if ((base.uiMode & 0x30) != (change.uiMode & 0x30)) {
            delta.uiMode |= change.uiMode & 0x30;
        }
        if (base.screenWidthDp != change.screenWidthDp) {
            delta.screenWidthDp = change.screenWidthDp;
        }
        if (base.screenHeightDp != change.screenHeightDp) {
            delta.screenHeightDp = change.screenHeightDp;
        }
        if (base.smallestScreenWidthDp != change.smallestScreenWidthDp) {
            delta.smallestScreenWidthDp = change.smallestScreenWidthDp;
        }
        if (base.densityDpi != change.densityDpi) {
            delta.densityDpi = change.densityDpi;
        }
        return delta;
    }

    private static final void $$robo$$android_content_res_Configuration$readXmlAttrs(XmlPullParser parser, Configuration configOut) throws XmlPullParserException, IOException {
        configOut.fontScale = Float.intBitsToFloat(XmlUtils.readIntAttribute(parser, "fs", 0));
        configOut.mcc = XmlUtils.readIntAttribute(parser, "mcc", 0);
        configOut.mnc = XmlUtils.readIntAttribute(parser, "mnc", 0);
        String localeStr = XmlUtils.readStringAttribute(parser, "locale");
        if (localeStr != null) {
            configOut.locale = Locale.forLanguageTag(localeStr);
        }
        configOut.touchscreen = XmlUtils.readIntAttribute(parser, "touch", 0);
        configOut.keyboard = XmlUtils.readIntAttribute(parser, "key", 0);
        configOut.keyboardHidden = XmlUtils.readIntAttribute(parser, "keyHid", 0);
        configOut.hardKeyboardHidden = XmlUtils.readIntAttribute(parser, "hardKeyHid", 0);
        configOut.navigation = XmlUtils.readIntAttribute(parser, "nav", 0);
        configOut.navigationHidden = XmlUtils.readIntAttribute(parser, "navHid", 0);
        configOut.orientation = XmlUtils.readIntAttribute(parser, "ori", 0);
        configOut.screenLayout = XmlUtils.readIntAttribute(parser, "scrLay", 0);
        configOut.uiMode = XmlUtils.readIntAttribute(parser, "ui", 0);
        configOut.screenWidthDp = XmlUtils.readIntAttribute(parser, "width", 0);
        configOut.screenHeightDp = XmlUtils.readIntAttribute(parser, "height", 0);
        configOut.smallestScreenWidthDp = XmlUtils.readIntAttribute(parser, "sw", 0);
        configOut.densityDpi = XmlUtils.readIntAttribute(parser, "density", 0);
    }

    private static final void $$robo$$android_content_res_Configuration$writeXmlAttrs(XmlSerializer xml2, Configuration config) throws IOException {
        XmlUtils.writeIntAttribute(xml2, "fs", Float.floatToIntBits(config.fontScale));
        if (config.mcc != 0) {
            XmlUtils.writeIntAttribute(xml2, "mcc", config.mcc);
        }
        if (config.mnc != 0) {
            XmlUtils.writeIntAttribute(xml2, "mnc", config.mnc);
        }
        if (config.locale != null) {
            XmlUtils.writeStringAttribute(xml2, "locale", config.locale.toLanguageTag());
        }
        if (config.touchscreen != 0) {
            XmlUtils.writeIntAttribute(xml2, "touch", config.touchscreen);
        }
        if (config.keyboard != 0) {
            XmlUtils.writeIntAttribute(xml2, "key", config.keyboard);
        }
        if (config.keyboardHidden != 0) {
            XmlUtils.writeIntAttribute(xml2, "keyHid", config.keyboardHidden);
        }
        if (config.hardKeyboardHidden != 0) {
            XmlUtils.writeIntAttribute(xml2, "hardKeyHid", config.hardKeyboardHidden);
        }
        if (config.navigation != 0) {
            XmlUtils.writeIntAttribute(xml2, "nav", config.navigation);
        }
        if (config.navigationHidden != 0) {
            XmlUtils.writeIntAttribute(xml2, "navHid", config.navigationHidden);
        }
        if (config.orientation != 0) {
            XmlUtils.writeIntAttribute(xml2, "ori", config.orientation);
        }
        if (config.screenLayout != 0) {
            XmlUtils.writeIntAttribute(xml2, "scrLay", config.screenLayout);
        }
        if (config.uiMode != 0) {
            XmlUtils.writeIntAttribute(xml2, "ui", config.uiMode);
        }
        if (config.screenWidthDp != 0) {
            XmlUtils.writeIntAttribute(xml2, "width", config.screenWidthDp);
        }
        if (config.screenHeightDp != 0) {
            XmlUtils.writeIntAttribute(xml2, "height", config.screenHeightDp);
        }
        if (config.smallestScreenWidthDp != 0) {
            XmlUtils.writeIntAttribute(xml2, "sw", config.smallestScreenWidthDp);
        }
        if (config.densityDpi != 0) {
            XmlUtils.writeIntAttribute(xml2, "density", config.densityDpi);
        }
    }

    private /* synthetic */ void $$robo$$android_content_res_Configuration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        EMPTY = new Configuration();
        CREATOR = new Parcelable.Creator<Configuration>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_res_Configuration_1$__constructor__() {
            }

            private final Configuration $$robo$$android_content_res_Configuration_1$createFromParcel(Parcel source) {
                return new Configuration(source);
            }

            private final Configuration[] $$robo$$android_content_res_Configuration_1$newArray(int size) {
                return new Configuration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_res_Configuration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Configuration_1$__constructor__(), 0, this);
            }

            @Override
            public Configuration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_res_Configuration_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Configuration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_res_Configuration_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static int resetScreenLayout(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resetScreenLayout", $$robo$$android_content_res_Configuration$resetScreenLayout(int ), 0, (int)n);
    }

    public static int reduceScreenLayout(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("reduceScreenLayout", $$robo$$android_content_res_Configuration$reduceScreenLayout(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public boolean isLayoutSizeAtLeast(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutSizeAtLeast", $$robo$$android_content_res_Configuration$isLayoutSizeAtLeast(int ), 0, this, n);
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_Configuration$__constructor__();
    }

    public Configuration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Configuration$__constructor__(), 0, this);
    }

    private void __constructor__(Configuration configuration) {
        this.$$robo$$android_content_res_Configuration$__constructor__(configuration);
    }

    public Configuration(Configuration configuration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Configuration$__constructor__(android.content.res.Configuration ), 0, this, configuration);
    }

    public void setTo(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_content_res_Configuration$setTo(android.content.res.Configuration ), 0, this, configuration);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_Configuration$toString(), 0, this);
    }

    public void setToDefaults() {
        InvokeDynamicSupport.bootstrap("setToDefaults", $$robo$$android_content_res_Configuration$setToDefaults(), 0, this);
    }

    @Deprecated
    public void makeDefault() {
        InvokeDynamicSupport.bootstrap("makeDefault", $$robo$$android_content_res_Configuration$makeDefault(), 0, this);
    }

    public int updateFrom(Configuration configuration) {
        return (int)InvokeDynamicSupport.bootstrap("updateFrom", $$robo$$android_content_res_Configuration$updateFrom(android.content.res.Configuration ), 0, this, configuration);
    }

    public int diff(Configuration configuration) {
        return (int)InvokeDynamicSupport.bootstrap("diff", $$robo$$android_content_res_Configuration$diff(android.content.res.Configuration ), 0, this, configuration);
    }

    public static boolean needNewResources(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("needNewResources", $$robo$$android_content_res_Configuration$needNewResources(int int ), 0, (int)n, (int)n2);
    }

    public boolean isOtherSeqNewer(Configuration configuration) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOtherSeqNewer", $$robo$$android_content_res_Configuration$isOtherSeqNewer(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_res_Configuration$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_res_Configuration$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_content_res_Configuration$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_res_Configuration$__constructor__(parcel);
    }

    private Configuration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Configuration$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public int compareTo(Configuration configuration) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_content_res_Configuration$compareTo(android.content.res.Configuration ), 0, this, configuration);
    }

    public boolean equals(Configuration configuration) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_res_Configuration$equals(android.content.res.Configuration ), 0, this, configuration);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_res_Configuration$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_res_Configuration$hashCode(), 0, this);
    }

    public void setLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_content_res_Configuration$setLocale(java.util.Locale ), 0, this, locale);
    }

    public int getLayoutDirection() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutDirection", $$robo$$android_content_res_Configuration$getLayoutDirection(), 0, this);
    }

    public void setLayoutDirection(Locale locale) {
        InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_content_res_Configuration$setLayoutDirection(java.util.Locale ), 0, this, locale);
    }

    private static int getScreenLayoutNoDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getScreenLayoutNoDirection", $$robo$$android_content_res_Configuration$getScreenLayoutNoDirection(int ), 0, (int)n);
    }

    public static String localeToResourceQualifier(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("localeToResourceQualifier", $$robo$$android_content_res_Configuration$localeToResourceQualifier(java.util.Locale ), 0, (Locale)locale);
    }

    public static String resourceQualifierString(Configuration configuration) {
        return InvokeDynamicSupport.bootstrapStatic("resourceQualifierString", $$robo$$android_content_res_Configuration$resourceQualifierString(android.content.res.Configuration ), 0, (Configuration)configuration);
    }

    public static Configuration generateDelta(Configuration configuration, Configuration configuration2) {
        return InvokeDynamicSupport.bootstrapStatic("generateDelta", $$robo$$android_content_res_Configuration$generateDelta(android.content.res.Configuration android.content.res.Configuration ), 0, (Configuration)configuration, (Configuration)configuration2);
    }

    public static void readXmlAttrs(XmlPullParser xmlPullParser, Configuration configuration) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("readXmlAttrs", $$robo$$android_content_res_Configuration$readXmlAttrs(org.xmlpull.v1.XmlPullParser android.content.res.Configuration ), 0, (XmlPullParser)xmlPullParser, (Configuration)configuration);
    }

    public static void writeXmlAttrs(XmlSerializer xmlSerializer, Configuration configuration) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeXmlAttrs", $$robo$$android_content_res_Configuration$writeXmlAttrs(org.xmlpull.v1.XmlSerializer android.content.res.Configuration ), 0, (XmlSerializer)xmlSerializer, (Configuration)configuration);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_res_Configuration$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(Configuration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Configuration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

