/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ActivityInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pools;
import android.util.TypedValue;
import android.view.ViewDebug;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Locale;
import libcore.icu.NativePluralRules;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class Resources
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "Resources";
    private static boolean DEBUG_LOAD = false;
    private static boolean DEBUG_CONFIG = false;
    private static boolean TRACE_FOR_PRELOAD = false;
    private static boolean TRACE_FOR_MISS_PRELOAD = false;
    private static int LAYOUT_DIR_CONFIG;
    private static int ID_OTHER = 0x1000004;
    private static Object sSync;
    private static LongSparseArray<Drawable.ConstantState>[] sPreloadedDrawables;
    private static LongSparseArray<Drawable.ConstantState> sPreloadedColorDrawables;
    private static LongSparseArray<ColorStateList> sPreloadedColorStateLists;
    Pools.SynchronizedPool<TypedArray> mTypedArrayPool;
    static Resources mSystem;
    private static boolean sPreloaded;
    private static int sPreloadedDensity;
    private Object mAccessLock;
    private Configuration mTmpConfig;
    private ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> mDrawableCache;
    private ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> mColorDrawableCache;
    private LongSparseArray<WeakReference<ColorStateList>> mColorStateListCache;
    private TypedValue mTmpValue;
    private boolean mPreloading;
    private TypedArray mCachedStyledAttributes;
    private int mLastCachedXmlBlockIndex;
    private int[] mCachedXmlBlockIds;
    private XmlBlock[] mCachedXmlBlocks;
    AssetManager mAssets;
    DisplayMetrics mMetrics;
    private Configuration mConfiguration;
    private NativePluralRules mPluralRule;
    private CompatibilityInfo mCompatibilityInfo;
    private WeakReference<IBinder> mToken;

    private static final int $$robo$$android_content_res_Resources$selectDefaultTheme(int curTheme, int targetSdkVersion) {
        return Resources.selectSystemTheme(curTheme, targetSdkVersion, 16973829, 16973931, 16974120, 16974143);
    }

    private static final int $$robo$$android_content_res_Resources$selectSystemTheme(int curTheme, int targetSdkVersion, int orig, int holo, int dark, int deviceDefault) {
        if (curTheme != 0) {
            return curTheme;
        }
        if (targetSdkVersion < 11) {
            return orig;
        }
        if (targetSdkVersion < 14) {
            return holo;
        }
        if (targetSdkVersion < 10000) {
            return dark;
        }
        return deviceDefault;
    }

    private void $$robo$$android_content_res_Resources$__constructor__(AssetManager assets, DisplayMetrics metrics, Configuration config) {
    }

    private void $$robo$$android_content_res_Resources$__constructor__(AssetManager assets, DisplayMetrics metrics, Configuration config, CompatibilityInfo compatInfo, IBinder token) {
        this.mTypedArrayPool = new Pools.SynchronizedPool(5);
        this.mAccessLock = new Object();
        this.mTmpConfig = new Configuration();
        this.mDrawableCache = new ArrayMap();
        this.mColorDrawableCache = new ArrayMap();
        this.mColorStateListCache = new LongSparseArray();
        this.mTmpValue = new TypedValue();
        this.mCachedStyledAttributes = null;
        this.mLastCachedXmlBlockIndex = -1;
        this.mCachedXmlBlockIds = new int[]{0, 0, 0, 0};
        this.mCachedXmlBlocks = new XmlBlock[4];
        this.mMetrics = new DisplayMetrics();
        this.mConfiguration = new Configuration();
        this.mCompatibilityInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        this.mAssets = assets;
        this.mMetrics.setToDefaults();
        if (compatInfo != null) {
            this.mCompatibilityInfo = compatInfo;
        }
        this.mToken = new WeakReference<IBinder>(token);
        this.updateConfiguration(config, metrics);
        assets.ensureStringBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Resources $$robo$$android_content_res_Resources$getSystem() {
        Object object = sSync;
        synchronized (object) {
            Resources ret = mSystem;
            if (ret == null) {
                mSystem = ret = new Resources();
            }
            return ret;
        }
    }

    private final CharSequence $$robo$$android_content_res_Resources$getText(int id2) throws NotFoundException {
        CharSequence res = this.mAssets.getResourceText(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    private final CharSequence $$robo$$android_content_res_Resources$getQuantityText(int id2, int quantity) throws NotFoundException {
        NativePluralRules rule = this.getPluralRule();
        CharSequence res = this.mAssets.getResourceBagText(id2, Resources.attrForQuantityCode(rule.quantityForInt(quantity)));
        if (res != null) {
            return res;
        }
        res = this.mAssets.getResourceBagText(id2, 0x1000004);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Plural resource ID #0x" + Integer.toHexString(id2) + " quantity=" + quantity + " item=" + Resources.stringForQuantityCode(rule.quantityForInt(quantity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NativePluralRules $$robo$$android_content_res_Resources$getPluralRule() {
        Object object = sSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                this.mPluralRule = NativePluralRules.forLocale(this.mConfiguration.locale);
            }
            return this.mPluralRule;
        }
    }

    private static final int $$robo$$android_content_res_Resources$attrForQuantityCode(int quantityCode) {
        switch (quantityCode) {
            case 0: {
                return 0x1000005;
            }
            case 1: {
                return 0x1000006;
            }
            case 2: {
                return 0x1000007;
            }
            case 3: {
                return 0x1000008;
            }
            case 4: {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    private static final String $$robo$$android_content_res_Resources$stringForQuantityCode(int quantityCode) {
        switch (quantityCode) {
            case 0: {
                return "zero";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "few";
            }
            case 4: {
                return "many";
            }
        }
        return "other";
    }

    private final String $$robo$$android_content_res_Resources$getString(int id2) throws NotFoundException {
        CharSequence res = this.getText(id2);
        if (res != null) {
            return res.toString();
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    private final String $$robo$$android_content_res_Resources$getString(int id2, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getString(id2);
        return String.format(this.mConfiguration.locale, raw2, formatArgs);
    }

    private final String $$robo$$android_content_res_Resources$getQuantityString(int id2, int quantity, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getQuantityText(id2, quantity).toString();
        return String.format(this.mConfiguration.locale, raw2, formatArgs);
    }

    private final String $$robo$$android_content_res_Resources$getQuantityString(int id2, int quantity) throws NotFoundException {
        return this.getQuantityText(id2, quantity).toString();
    }

    private final CharSequence $$robo$$android_content_res_Resources$getText(int id2, CharSequence def) {
        CharSequence res = id2 != 0 ? this.mAssets.getResourceText(id2) : null;
        return res != null ? res : def;
    }

    private final CharSequence[] $$robo$$android_content_res_Resources$getTextArray(int id2) throws NotFoundException {
        CharSequence[] res = this.mAssets.getResourceTextArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(id2));
    }

    private final String[] $$robo$$android_content_res_Resources$getStringArray(int id2) throws NotFoundException {
        String[] res = this.mAssets.getResourceStringArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(id2));
    }

    private final int[] $$robo$$android_content_res_Resources$getIntArray(int id2) throws NotFoundException {
        int[] res = this.mAssets.getArrayIntResource(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(id2));
    }

    private final TypedArray $$robo$$android_content_res_Resources$obtainTypedArray(int id2) throws NotFoundException {
        int len = this.mAssets.getArraySize(id2);
        if (len < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        TypedArray array2 = TypedArray.obtain(this, len);
        array2.mLength = this.mAssets.retrieveArray(id2, array2.mData);
        array2.mIndices[0] = 0;
        return array2;
    }

    private final float $$robo$$android_content_res_Resources$getDimension(int id2) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimension(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final int $$robo$$android_content_res_Resources$getDimensionPixelOffset(int id2) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimensionPixelOffset(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final int $$robo$$android_content_res_Resources$getDimensionPixelSize(int id2) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimensionPixelSize(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final float $$robo$$android_content_res_Resources$getFraction(int id2, int base, int pbase) {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type == 6) {
                return TypedValue.complexToFraction(value.data, base, pbase);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final Drawable $$robo$$android_content_res_Resources$getDrawable(int id2) throws NotFoundException {
        Drawable d = this.getDrawable(id2, null);
        if (d.canApplyTheme()) {
            Log.w("Resources", "Drawable " + this.getResourceName(id2) + " has unresolved theme " + "attributes! Consider using Resources.getDrawable(int, Theme) or " + "Context.getDrawable(int).", new RuntimeException());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_content_res_Resources$getDrawable(int id2, Theme theme) throws NotFoundException {
        TypedValue value;
        Object object = this.mAccessLock;
        synchronized (object) {
            value = this.mTmpValue;
            if (value == null) {
                value = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValue(id2, value, true);
        }
        Drawable res = this.loadDrawable(value, id2, theme);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
        return res;
    }

    private final Drawable $$robo$$android_content_res_Resources$getDrawableForDensity(int id2, int density) throws NotFoundException {
        return this.getDrawableForDensity(id2, density, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_content_res_Resources$getDrawableForDensity(int id2, int density, Theme theme) {
        TypedValue value;
        Object object = this.mAccessLock;
        synchronized (object) {
            value = this.mTmpValue;
            if (value == null) {
                value = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValueForDensity(id2, density, value, true);
            if (value.density > 0 && value.density != 65535) {
                value.density = value.density == density ? this.mMetrics.densityDpi : value.density * this.mMetrics.densityDpi / density;
            }
        }
        Drawable res = this.loadDrawable(value, id2, theme);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
        return res;
    }

    private final Movie $$robo$$android_content_res_Resources$getMovie(int id2) throws NotFoundException {
        InputStream is = this.openRawResource(id2);
        Movie movie = Movie.decodeStream(is);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return movie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_Resources$getColor(int id2) throws NotFoundException {
        TypedValue value;
        Object object = this.mAccessLock;
        synchronized (object) {
            value = this.mTmpValue;
            if (value == null) {
                value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                this.mTmpValue = value;
                return value.data;
            }
            if (value.type != 3) {
                throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
            }
            this.mTmpValue = null;
        }
        ColorStateList csl = this.loadColorStateList(value, id2);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
        return csl.getDefaultColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ColorStateList $$robo$$android_content_res_Resources$getColorStateList(int id2) throws NotFoundException {
        TypedValue value;
        Object object = this.mAccessLock;
        synchronized (object) {
            value = this.mTmpValue;
            if (value == null) {
                value = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValue(id2, value, true);
        }
        ColorStateList res = this.loadColorStateList(value, id2);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
        return res;
    }

    private final boolean $$robo$$android_content_res_Resources$getBoolean(int id2) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data != 0;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final int $$robo$$android_content_res_Resources$getInteger(int id2) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final float $$robo$$android_content_res_Resources$getFloat(int id2) {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type == 4) {
                return value.getFloat();
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$getLayout(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "layout");
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$getAnimation(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "anim");
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$getXml(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_content_res_Resources$openRawResource(int id2) throws NotFoundException {
        TypedValue value;
        Object object = this.mAccessLock;
        synchronized (object) {
            value = this.mTmpValue;
            if (value == null) {
                value = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
        }
        InputStream res = this.openRawResource(id2, value);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
        return res;
    }

    private final InputStream $$robo$$android_content_res_Resources$openRawResource(int id2, TypedValue value) throws NotFoundException {
        this.getValue(id2, value, true);
        try {
            return this.mAssets.openNonAsset(value.assetCookie, value.string.toString(), 2);
        }
        catch (Exception e) {
            NotFoundException rnf = new NotFoundException("File " + value.string.toString() + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AssetFileDescriptor $$robo$$android_content_res_Resources$openRawResourceFd(int id2) throws NotFoundException {
        TypedValue value;
        Object object = this.mAccessLock;
        synchronized (object) {
            value = this.mTmpValue;
            if (value == null) {
                value = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValue(id2, value, true);
        }
        try {
            object = this.mAssets.openNonAssetFd(value.assetCookie, value.string.toString());
            return object;
        }
        catch (Exception e) {
            NotFoundException rnf = new NotFoundException("File " + value.string.toString() + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
        finally {
            Object object2 = this.mAccessLock;
            synchronized (object2) {
                if (this.mTmpValue == null) {
                    this.mTmpValue = value;
                }
            }
        }
    }

    private final void $$robo$$android_content_res_Resources$getValue(int id2, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, 0, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    private final void $$robo$$android_content_res_Resources$getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, density, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    private final void $$robo$$android_content_res_Resources$getValue(String name, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        int id2 = this.getIdentifier(name, "string", null);
        if (id2 != 0) {
            this.getValue(id2, outValue, resolveRefs);
            return;
        }
        throw new NotFoundException("String resource name " + name);
    }

    private final Theme $$robo$$android_content_res_Resources$newTheme() {
        return new Theme(this);
    }

    private final TypedArray $$robo$$android_content_res_Resources$obtainAttributes(AttributeSet set, int[] attrs) {
        int len = attrs.length;
        TypedArray array2 = TypedArray.obtain(this, len);
        XmlBlock.Parser parser = (XmlBlock.Parser)set;
        this.mAssets.retrieveAttributes(parser.mParseState, attrs, array2.mData, array2.mIndices);
        array2.mXml = parser;
        return array2;
    }

    private final void $$robo$$android_content_res_Resources$updateConfiguration(Configuration config, DisplayMetrics metrics) {
        this.updateConfiguration(config, metrics, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Object object = this.mAccessLock;
        synchronized (object) {
            int height;
            int width;
            if (compat != null) {
                this.mCompatibilityInfo = compat;
            }
            if (metrics != null) {
                this.mMetrics.setTo(metrics);
            }
            this.mCompatibilityInfo.applyToDisplayMetrics(this.mMetrics);
            int configChanges = 0xFFFFFFF;
            if (config != null) {
                this.mTmpConfig.setTo(config);
                int density = config.densityDpi;
                if (density == 0) {
                    density = this.mMetrics.noncompatDensityDpi;
                }
                this.mCompatibilityInfo.applyToConfiguration(density, this.mTmpConfig);
                if (this.mTmpConfig.locale == null) {
                    this.mTmpConfig.locale = Locale.getDefault();
                    this.mTmpConfig.setLayoutDirection(this.mTmpConfig.locale);
                }
                configChanges = this.mConfiguration.updateFrom(this.mTmpConfig);
                configChanges = ActivityInfo.activityInfoConfigToNative(configChanges);
            }
            if (this.mConfiguration.locale == null) {
                this.mConfiguration.locale = Locale.getDefault();
                this.mConfiguration.setLayoutDirection(this.mConfiguration.locale);
            }
            if (this.mConfiguration.densityDpi != 0) {
                this.mMetrics.densityDpi = this.mConfiguration.densityDpi;
                this.mMetrics.density = (float)this.mConfiguration.densityDpi * 0.00625f;
            }
            this.mMetrics.scaledDensity = this.mMetrics.density * this.mConfiguration.fontScale;
            String locale = null;
            if (this.mConfiguration.locale != null) {
                locale = Resources.adjustLanguageTag(this.mConfiguration.locale.toLanguageTag());
            }
            if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                width = this.mMetrics.widthPixels;
                height = this.mMetrics.heightPixels;
            } else {
                width = this.mMetrics.heightPixels;
                height = this.mMetrics.widthPixels;
            }
            int keyboardHidden = this.mConfiguration.keyboardHidden;
            if (keyboardHidden == 1 && this.mConfiguration.hardKeyboardHidden == 2) {
                keyboardHidden = 3;
            }
            this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, locale, this.mConfiguration.orientation, this.mConfiguration.touchscreen, this.mConfiguration.densityDpi, this.mConfiguration.keyboard, keyboardHidden, this.mConfiguration.navigation, width, height, this.mConfiguration.smallestScreenWidthDp, this.mConfiguration.screenWidthDp, this.mConfiguration.screenHeightDp, this.mConfiguration.screenLayout, this.mConfiguration.uiMode, Build.VERSION.RESOURCES_SDK_INT);
            this.clearDrawableCachesLocked(this.mDrawableCache, configChanges);
            this.clearDrawableCachesLocked(this.mColorDrawableCache, configChanges);
            this.mColorStateListCache.clear();
            this.flushLayoutCache();
        }
        object = sSync;
        synchronized (object) {
            if (this.mPluralRule != null) {
                this.mPluralRule = NativePluralRules.forLocale(config.locale);
            }
        }
    }

    private final void $$robo$$android_content_res_Resources$clearDrawableCachesLocked(ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> caches, int configChanges) {
        int N = caches.size();
        for (int i = 0; i < N; ++i) {
            this.clearDrawableCacheLocked(caches.valueAt(i), configChanges);
        }
    }

    private final void $$robo$$android_content_res_Resources$clearDrawableCacheLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> cache, int configChanges) {
        int N = cache.size();
        for (int i = 0; i < N; ++i) {
            Drawable.ConstantState cs;
            WeakReference<Drawable.ConstantState> ref = cache.valueAt(i);
            if (ref == null || (cs = (Drawable.ConstantState)ref.get()) == null || !Configuration.needNewResources(configChanges, cs.getChangingConfigurations())) continue;
            cache.setValueAt(i, null);
        }
    }

    private static final String $$robo$$android_content_res_Resources$adjustLanguageTag(String languageTag) {
        String remainder;
        String language;
        int separator = languageTag.indexOf(45);
        if (separator == -1) {
            language = languageTag;
            remainder = "";
        } else {
            language = languageTag.substring(0, separator);
            remainder = languageTag.substring(separator);
        }
        return (String)((Object)InvokeDynamicSupport.bootstrapIntrinsic("adjustLanguageCode", "java.util.Locale", (String)language)) + remainder;
    }

    private static final void $$robo$$android_content_res_Resources$updateSystemConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        if (mSystem != null) {
            mSystem.updateConfiguration(config, metrics, compat);
        }
    }

    private final DisplayMetrics $$robo$$android_content_res_Resources$getDisplayMetrics() {
        return this.mMetrics;
    }

    private final Configuration $$robo$$android_content_res_Resources$getConfiguration() {
        return this.mConfiguration;
    }

    private final CompatibilityInfo $$robo$$android_content_res_Resources$getCompatibilityInfo() {
        return this.mCompatibilityInfo;
    }

    private final void $$robo$$android_content_res_Resources$setCompatibilityInfo(CompatibilityInfo ci) {
        if (ci != null) {
            this.mCompatibilityInfo = ci;
            this.updateConfiguration(this.mConfiguration, this.mMetrics);
        }
    }

    private final int $$robo$$android_content_res_Resources$getIdentifier(String name, String defType, String defPackage) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        try {
            return Integer.parseInt(name);
        }
        catch (Exception exception) {
            return this.mAssets.getResourceIdentifier(name, defType, defPackage);
        }
    }

    private static final boolean $$robo$$android_content_res_Resources$resourceHasPackage(int resid) {
        return resid >>> 24 != 0;
    }

    private final String $$robo$$android_content_res_Resources$getResourceName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final String $$robo$$android_content_res_Resources$getResourcePackageName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourcePackageName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final String $$robo$$android_content_res_Resources$getResourceTypeName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceTypeName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final String $$robo$$android_content_res_Resources$getResourceEntryName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceEntryName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final void $$robo$$android_content_res_Resources$parseBundleExtras(XmlResourceParser parser, Bundle outBundle) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("extra")) {
                this.parseBundleExtra("extra", parser, outBundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void $$robo$$android_content_res_Resources$parseBundleExtra(String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = this.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:value or android:resource attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs = v.coerceToString();
            outBundle.putCharSequence(name, cs);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    private final AssetManager $$robo$$android_content_res_Resources$getAssets() {
        return this.mAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$flushLayoutCache() {
        int[] nArray = this.mCachedXmlBlockIds;
        synchronized (this.mCachedXmlBlockIds) {
            int num = this.mCachedXmlBlockIds.length;
            for (int i = 0; i < num; ++i) {
                this.mCachedXmlBlockIds[i] = 0;
                XmlBlock oldBlock = this.mCachedXmlBlocks[i];
                if (oldBlock != null) {
                    oldBlock.close();
                }
                this.mCachedXmlBlocks[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$startPreloading() {
        Object object = sSync;
        synchronized (object) {
            if (sPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            sPreloaded = true;
            this.mPreloading = true;
            this.mConfiguration.densityDpi = sPreloadedDensity = DisplayMetrics.DENSITY_DEVICE;
            this.updateConfiguration(null, null);
        }
    }

    private final void $$robo$$android_content_res_Resources$finishPreloading() {
        if (this.mPreloading) {
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    private final LongSparseArray<Drawable.ConstantState> $$robo$$android_content_res_Resources$getPreloadedDrawables() {
        return sPreloadedDrawables[0];
    }

    private final boolean $$robo$$android_content_res_Resources$verifyPreloadConfig(int changingConfigurations, int allowVarying, int resourceId, String name) {
        if ((changingConfigurations & 0xBFFFEFFF & ~allowVarying) != 0) {
            String resName;
            try {
                resName = this.getResourceName(resourceId);
            }
            catch (NotFoundException e) {
                resName = "?";
            }
            Log.w("Resources", "Preloaded " + name + " resource #0x" + Integer.toHexString(resourceId) + " (" + resName + ") that varies with configuration!!");
            return false;
        }
        return true;
    }

    private final Drawable $$robo$$android_content_res_Resources$loadDrawable(TypedValue value, int id2, Theme theme) throws NotFoundException {
        Drawable cachedDrawable;
        long key;
        ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> caches;
        boolean isColorDrawable;
        if (value.type >= 28 && value.type <= 31) {
            isColorDrawable = true;
            caches = this.mColorDrawableCache;
            key = value.data;
        } else {
            isColorDrawable = false;
            caches = this.mDrawableCache;
            key = (long)value.assetCookie << 32 | (long)value.data;
        }
        if (!this.mPreloading && (cachedDrawable = this.getCachedDrawable(caches, key, theme)) != null) {
            return cachedDrawable;
        }
        Drawable.ConstantState cs = isColorDrawable ? sPreloadedColorDrawables.get(key) : sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].get(key);
        Drawable dr = cs != null ? cs.newDrawable(this, theme) : (isColorDrawable ? new ColorDrawable(value.data) : this.loadDrawableForCookie(value, id2, theme));
        if (dr != null) {
            dr.setChangingConfigurations(value.changingConfigurations);
            this.cacheDrawable(value, theme, isColorDrawable, caches, key, dr);
        }
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$cacheDrawable(TypedValue value, Theme theme, boolean isColorDrawable, ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> caches, long key, Drawable dr) {
        Drawable.ConstantState cs = dr.getConstantState();
        if (cs == null) {
            return;
        }
        if (this.mPreloading) {
            int changingConfigs = cs.getChangingConfigurations();
            if (isColorDrawable) {
                if (this.verifyPreloadConfig(changingConfigs, 0, value.resourceId, "drawable")) {
                    sPreloadedColorDrawables.put(key, cs);
                }
            } else if (this.verifyPreloadConfig(changingConfigs, LAYOUT_DIR_CONFIG, value.resourceId, "drawable")) {
                if ((changingConfigs & LAYOUT_DIR_CONFIG) == 0) {
                    sPreloadedDrawables[0].put(key, cs);
                    sPreloadedDrawables[1].put(key, cs);
                } else {
                    sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].put(key, cs);
                }
            }
        } else {
            Object object = this.mAccessLock;
            synchronized (object) {
                String themeKey = theme == null ? "" : theme.mKey;
                LongSparseArray<WeakReference<Drawable.ConstantState>> themedCache = caches.get(themeKey);
                if (themedCache == null) {
                    themedCache = new LongSparseArray(1);
                    caches.put(themeKey, themedCache);
                }
                themedCache.put(key, new WeakReference<Drawable.ConstantState>(cs));
            }
        }
    }

    private final Drawable $$robo$$android_content_res_Resources$loadDrawableForCookie(TypedValue value, int id2, Theme theme) {
        Drawable dr;
        if (value.string == null) {
            throw new NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ")  is not a Drawable (color or path): " + value);
        }
        String file = value.string.toString();
        Trace.traceBegin(8192L, file);
        try {
            if (file.endsWith(".xml")) {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "drawable");
                dr = Drawable.createFromXml(this, rp, theme);
                rp.close();
            } else {
                InputStream is = this.mAssets.openNonAsset(value.assetCookie, file, 2);
                dr = Drawable.createFromResourceStream(this, value, is, file, null);
                is.close();
            }
        }
        catch (Exception e) {
            Trace.traceEnd(8192L);
            NotFoundException rnf = new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
        Trace.traceEnd(8192L);
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_content_res_Resources$getCachedDrawable(ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> caches, long key, Theme theme) {
        Object object = this.mAccessLock;
        synchronized (object) {
            Drawable themedDrawable;
            String themeKey = theme != null ? theme.mKey : "";
            LongSparseArray<WeakReference<Drawable.ConstantState>> themedCache = caches.get(themeKey);
            if (themedCache != null && (themedDrawable = this.getCachedDrawableLocked(themedCache, key)) != null) {
                return themedDrawable;
            }
            return null;
        }
    }

    private final Drawable.ConstantState $$robo$$android_content_res_Resources$getConstantStateLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> drawableCache, long key) {
        WeakReference<Drawable.ConstantState> wr = drawableCache.get(key);
        if (wr != null) {
            Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
            if (entry != null) {
                return entry;
            }
            drawableCache.delete(key);
        }
        return null;
    }

    private final Drawable $$robo$$android_content_res_Resources$getCachedDrawableLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> drawableCache, long key) {
        Drawable.ConstantState entry = this.getConstantStateLocked(drawableCache, key);
        if (entry != null) {
            return entry.newDrawable(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ColorStateList $$robo$$android_content_res_Resources$loadColorStateList(TypedValue value, int id2) throws NotFoundException {
        long key = (long)value.assetCookie << 32 | (long)value.data;
        if (value.type >= 28 && value.type <= 31) {
            ColorStateList csl = sPreloadedColorStateLists.get(key);
            if (csl != null) {
                return csl;
            }
            csl = ColorStateList.valueOf(value.data);
            if (this.mPreloading && this.verifyPreloadConfig(value.changingConfigurations, 0, value.resourceId, "color")) {
                sPreloadedColorStateLists.put(key, csl);
            }
            return csl;
        }
        ColorStateList csl = this.getCachedColorStateList(key);
        if (csl != null) {
            return csl;
        }
        csl = sPreloadedColorStateLists.get(key);
        if (csl != null) {
            return csl;
        }
        if (value.string == null) {
            throw new NotFoundException("Resource is not a ColorStateList (color or path): " + value);
        }
        String file = value.string.toString();
        if (file.endsWith(".xml")) {
            Trace.traceBegin(8192L, file);
            try {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "colorstatelist");
                csl = ColorStateList.createFromXml(this, rp);
                rp.close();
            }
            catch (Exception e) {
                Trace.traceEnd(8192L);
                NotFoundException rnf = new NotFoundException("File " + file + " from color state list resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            throw new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        Trace.traceEnd(8192L);
        if (csl != null) {
            if (this.mPreloading) {
                if (this.verifyPreloadConfig(value.changingConfigurations, 0, value.resourceId, "color")) {
                    sPreloadedColorStateLists.put(key, csl);
                }
            } else {
                Object object = this.mAccessLock;
                synchronized (object) {
                    this.mColorStateListCache.put(key, new WeakReference<ColorStateList>(csl));
                }
            }
        }
        return csl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ColorStateList $$robo$$android_content_res_Resources$getCachedColorStateList(long key) {
        Object object = this.mAccessLock;
        synchronized (object) {
            WeakReference<ColorStateList> wr = this.mColorStateListCache.get(key);
            if (wr != null) {
                ColorStateList entry = (ColorStateList)wr.get();
                if (entry != null) {
                    return entry;
                }
                this.mColorStateListCache.delete(key);
            }
        }
        return null;
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$loadXmlResourceParser(int id2, String type) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue value = this.mTmpValue;
            if (value == null) {
                this.mTmpValue = value = new TypedValue();
            }
            this.getValue(id2, value, true);
            if (value.type == 3) {
                return this.loadXmlResourceParser(value.string.toString(), id2, value.assetCookie, type);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XmlResourceParser $$robo$$android_content_res_Resources$loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws NotFoundException {
        if (id2 != 0) {
            try {
                int[] nArray = this.mCachedXmlBlockIds;
                synchronized (this.mCachedXmlBlockIds) {
                    int num = this.mCachedXmlBlockIds.length;
                    for (int i = 0; i < num; ++i) {
                        if (this.mCachedXmlBlockIds[i] != id2) continue;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return this.mCachedXmlBlocks[i].newParser();
                    }
                    XmlBlock block = this.mAssets.openXmlBlockAsset(assetCookie, file);
                    if (block != null) {
                        int pos = this.mLastCachedXmlBlockIndex + 1;
                        if (pos >= num) {
                            pos = 0;
                        }
                        this.mLastCachedXmlBlockIndex = pos;
                        XmlBlock oldBlock = this.mCachedXmlBlocks[pos];
                        if (oldBlock != null) {
                            oldBlock.close();
                        }
                        this.mCachedXmlBlockIds[pos] = id2;
                        this.mCachedXmlBlocks[pos] = block;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return block.newParser();
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
        {
            throw new NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$recycleCachedStyledAttributes(TypedArray attrs) {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedArray cached = this.mCachedStyledAttributes;
            if (cached == null || cached.mData.length < attrs.mData.length) {
                this.mCachedStyledAttributes = attrs;
            }
        }
    }

    private void $$robo$$android_content_res_Resources$__constructor__() {
        this.mTypedArrayPool = new Pools.SynchronizedPool(5);
        this.mAccessLock = new Object();
        this.mTmpConfig = new Configuration();
        this.mDrawableCache = new ArrayMap();
        this.mColorDrawableCache = new ArrayMap();
        this.mColorStateListCache = new LongSparseArray();
        this.mTmpValue = new TypedValue();
        this.mCachedStyledAttributes = null;
        this.mLastCachedXmlBlockIndex = -1;
        this.mCachedXmlBlockIds = new int[]{0, 0, 0, 0};
        this.mCachedXmlBlocks = new XmlBlock[4];
        this.mMetrics = new DisplayMetrics();
        this.mConfiguration = new Configuration();
        this.mCompatibilityInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        this.mAssets = AssetManager.getSystem();
        this.mConfiguration.setToDefaults();
        this.mMetrics.setToDefaults();
        this.updateConfiguration(null, null);
        this.mAssets.ensureStringBlocks();
    }

    static void __staticInitializer__() {
        LAYOUT_DIR_CONFIG = ActivityInfo.activityInfoConfigToNative(8192);
        sSync = new Object();
        sPreloadedColorDrawables = new LongSparseArray();
        sPreloadedColorStateLists = new LongSparseArray();
        mSystem = null;
        sPreloadedDrawables = new LongSparseArray[2];
        Resources.sPreloadedDrawables[0] = new LongSparseArray();
        Resources.sPreloadedDrawables[1] = new LongSparseArray();
    }

    public static int selectDefaultTheme(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("selectDefaultTheme", $$robo$$android_content_res_Resources$selectDefaultTheme(int int ), 0, (int)n, (int)n2);
    }

    public static int selectSystemTheme(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrapStatic("selectSystemTheme", $$robo$$android_content_res_Resources$selectSystemTheme(int int int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    private void __constructor__(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration) {
        this.$$robo$$android_content_res_Resources$__constructor__(assetManager, displayMetrics, configuration);
    }

    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration) {
        this(assetManager, displayMetrics, configuration, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources$__constructor__(android.content.res.AssetManager android.util.DisplayMetrics android.content.res.Configuration ), 0, this, assetManager, displayMetrics, configuration);
    }

    private void __constructor__(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration, CompatibilityInfo compatibilityInfo, IBinder iBinder) {
        this.$$robo$$android_content_res_Resources$__constructor__(assetManager, displayMetrics, configuration, compatibilityInfo, iBinder);
    }

    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration, CompatibilityInfo compatibilityInfo, IBinder iBinder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources$__constructor__(android.content.res.AssetManager android.util.DisplayMetrics android.content.res.Configuration android.content.res.CompatibilityInfo android.os.IBinder ), 0, this, assetManager, displayMetrics, configuration, compatibilityInfo, iBinder);
    }

    public static Resources getSystem() {
        return InvokeDynamicSupport.bootstrapStatic("getSystem", $$robo$$android_content_res_Resources$getSystem(), 0);
    }

    public CharSequence getText(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_res_Resources$getText(int ), 0, this, n);
    }

    public CharSequence getQuantityText(int n, int n2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityText", $$robo$$android_content_res_Resources$getQuantityText(int int ), 0, this, n, n2);
    }

    private NativePluralRules getPluralRule() {
        return InvokeDynamicSupport.bootstrap("getPluralRule", $$robo$$android_content_res_Resources$getPluralRule(), 0, this);
    }

    private static int attrForQuantityCode(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("attrForQuantityCode", $$robo$$android_content_res_Resources$attrForQuantityCode(int ), 0, (int)n);
    }

    private static String stringForQuantityCode(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stringForQuantityCode", $$robo$$android_content_res_Resources$stringForQuantityCode(int ), 0, (int)n);
    }

    public String getString(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_content_res_Resources$getString(int ), 0, this, n);
    }

    public String getString(int n, Object ... objectArray) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_content_res_Resources$getString(int java.lang.Object[] ), 0, this, n, objectArray);
    }

    public String getQuantityString(int n, int n2, Object ... objectArray) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityString", $$robo$$android_content_res_Resources$getQuantityString(int int java.lang.Object[] ), 0, this, n, n2, objectArray);
    }

    public String getQuantityString(int n, int n2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityString", $$robo$$android_content_res_Resources$getQuantityString(int int ), 0, this, n, n2);
    }

    public CharSequence getText(int n, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_res_Resources$getText(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public CharSequence[] getTextArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getTextArray", $$robo$$android_content_res_Resources$getTextArray(int ), 0, this, n);
    }

    public String[] getStringArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getStringArray", $$robo$$android_content_res_Resources$getStringArray(int ), 0, this, n);
    }

    public int[] getIntArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getIntArray", $$robo$$android_content_res_Resources$getIntArray(int ), 0, this, n);
    }

    public TypedArray obtainTypedArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("obtainTypedArray", $$robo$$android_content_res_Resources$obtainTypedArray(int ), 0, this, n);
    }

    public float getDimension(int n) throws NotFoundException {
        return (float)InvokeDynamicSupport.bootstrap("getDimension", $$robo$$android_content_res_Resources$getDimension(int ), 0, this, n);
    }

    public int getDimensionPixelOffset(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionPixelOffset", $$robo$$android_content_res_Resources$getDimensionPixelOffset(int ), 0, this, n);
    }

    public int getDimensionPixelSize(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionPixelSize", $$robo$$android_content_res_Resources$getDimensionPixelSize(int ), 0, this, n);
    }

    public float getFraction(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("getFraction", $$robo$$android_content_res_Resources$getFraction(int int int ), 0, this, n, n2, n3);
    }

    public Drawable getDrawable(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_Resources$getDrawable(int ), 0, this, n);
    }

    public Drawable getDrawable(int n, Theme theme) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_Resources$getDrawable(int android.content.res.Resources$Theme ), 0, this, n, theme);
    }

    public Drawable getDrawableForDensity(int n, int n2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getDrawableForDensity", $$robo$$android_content_res_Resources$getDrawableForDensity(int int ), 0, this, n, n2);
    }

    public Drawable getDrawableForDensity(int n, int n2, Theme theme) {
        return InvokeDynamicSupport.bootstrap("getDrawableForDensity", $$robo$$android_content_res_Resources$getDrawableForDensity(int int android.content.res.Resources$Theme ), 0, this, n, n2, theme);
    }

    public Movie getMovie(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getMovie", $$robo$$android_content_res_Resources$getMovie(int ), 0, this, n);
    }

    public int getColor(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_content_res_Resources$getColor(int ), 0, this, n);
    }

    public ColorStateList getColorStateList(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getColorStateList", $$robo$$android_content_res_Resources$getColorStateList(int ), 0, this, n);
    }

    public boolean getBoolean(int n) throws NotFoundException {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$android_content_res_Resources$getBoolean(int ), 0, this, n);
    }

    public int getInteger(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getInteger", $$robo$$android_content_res_Resources$getInteger(int ), 0, this, n);
    }

    public float getFloat(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_content_res_Resources$getFloat(int ), 0, this, n);
    }

    public XmlResourceParser getLayout(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getLayout", $$robo$$android_content_res_Resources$getLayout(int ), 0, this, n);
    }

    public XmlResourceParser getAnimation(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getAnimation", $$robo$$android_content_res_Resources$getAnimation(int ), 0, this, n);
    }

    public XmlResourceParser getXml(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getXml", $$robo$$android_content_res_Resources$getXml(int ), 0, this, n);
    }

    public InputStream openRawResource(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResource", $$robo$$android_content_res_Resources$openRawResource(int ), 0, this, n);
    }

    public InputStream openRawResource(int n, TypedValue typedValue) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResource", $$robo$$android_content_res_Resources$openRawResource(int android.util.TypedValue ), 0, this, n, typedValue);
    }

    public AssetFileDescriptor openRawResourceFd(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResourceFd", $$robo$$android_content_res_Resources$openRawResourceFd(int ), 0, this, n);
    }

    public void getValue(int n, TypedValue typedValue, boolean bl) throws NotFoundException {
        InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_Resources$getValue(int android.util.TypedValue boolean ), 0, this, n, typedValue, bl);
    }

    public void getValueForDensity(int n, int n2, TypedValue typedValue, boolean bl) throws NotFoundException {
        InvokeDynamicSupport.bootstrap("getValueForDensity", $$robo$$android_content_res_Resources$getValueForDensity(int int android.util.TypedValue boolean ), 0, this, n, n2, typedValue, bl);
    }

    public void getValue(String string2, TypedValue typedValue, boolean bl) throws NotFoundException {
        InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_Resources$getValue(java.lang.String android.util.TypedValue boolean ), 0, this, string2, typedValue, bl);
    }

    public Theme newTheme() {
        return InvokeDynamicSupport.bootstrap("newTheme", $$robo$$android_content_res_Resources$newTheme(), 0, this);
    }

    public TypedArray obtainAttributes(AttributeSet attributeSet, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("obtainAttributes", $$robo$$android_content_res_Resources$obtainAttributes(android.util.AttributeSet int[] ), 0, this, attributeSet, nArray);
    }

    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("updateConfiguration", $$robo$$android_content_res_Resources$updateConfiguration(android.content.res.Configuration android.util.DisplayMetrics ), 0, this, configuration, displayMetrics);
    }

    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrap("updateConfiguration", $$robo$$android_content_res_Resources$updateConfiguration(android.content.res.Configuration android.util.DisplayMetrics android.content.res.CompatibilityInfo ), 0, this, configuration, displayMetrics, compatibilityInfo);
    }

    private void clearDrawableCachesLocked(ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap, int n) {
        InvokeDynamicSupport.bootstrap("clearDrawableCachesLocked", $$robo$$android_content_res_Resources$clearDrawableCachesLocked(android.util.ArrayMap<java.lang.String, android.util.LongSparseArray<java.lang.ref.WeakReference<android.graphics.drawable.Drawable$ConstantState>>> int ), 0, this, arrayMap, n);
    }

    private void clearDrawableCacheLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray, int n) {
        InvokeDynamicSupport.bootstrap("clearDrawableCacheLocked", $$robo$$android_content_res_Resources$clearDrawableCacheLocked(android.util.LongSparseArray<java.lang.ref.WeakReference<android.graphics.drawable.Drawable$ConstantState>> int ), 0, this, longSparseArray, n);
    }

    private static String adjustLanguageTag(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("adjustLanguageTag", $$robo$$android_content_res_Resources$adjustLanguageTag(java.lang.String ), 0, (String)string2);
    }

    public static void updateSystemConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrapStatic("updateSystemConfiguration", $$robo$$android_content_res_Resources$updateSystemConfiguration(android.content.res.Configuration android.util.DisplayMetrics android.content.res.CompatibilityInfo ), 0, (Configuration)configuration, (DisplayMetrics)displayMetrics, (CompatibilityInfo)compatibilityInfo);
    }

    public DisplayMetrics getDisplayMetrics() {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_content_res_Resources$getDisplayMetrics(), 0, this);
    }

    public Configuration getConfiguration() {
        return InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_content_res_Resources$getConfiguration(), 0, this);
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return InvokeDynamicSupport.bootstrap("getCompatibilityInfo", $$robo$$android_content_res_Resources$getCompatibilityInfo(), 0, this);
    }

    public void setCompatibilityInfo(CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrap("setCompatibilityInfo", $$robo$$android_content_res_Resources$setCompatibilityInfo(android.content.res.CompatibilityInfo ), 0, this, compatibilityInfo);
    }

    public int getIdentifier(String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("getIdentifier", $$robo$$android_content_res_Resources$getIdentifier(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public static boolean resourceHasPackage(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resourceHasPackage", $$robo$$android_content_res_Resources$resourceHasPackage(int ), 0, (int)n);
    }

    public String getResourceName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceName", $$robo$$android_content_res_Resources$getResourceName(int ), 0, this, n);
    }

    public String getResourcePackageName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcePackageName", $$robo$$android_content_res_Resources$getResourcePackageName(int ), 0, this, n);
    }

    public String getResourceTypeName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceTypeName", $$robo$$android_content_res_Resources$getResourceTypeName(int ), 0, this, n);
    }

    public String getResourceEntryName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceEntryName", $$robo$$android_content_res_Resources$getResourceEntryName(int ), 0, this, n);
    }

    public void parseBundleExtras(XmlResourceParser xmlResourceParser, Bundle bundle) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("parseBundleExtras", $$robo$$android_content_res_Resources$parseBundleExtras(android.content.res.XmlResourceParser android.os.Bundle ), 0, this, xmlResourceParser, bundle);
    }

    public void parseBundleExtra(String string2, AttributeSet attributeSet, Bundle bundle) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("parseBundleExtra", $$robo$$android_content_res_Resources$parseBundleExtra(java.lang.String android.util.AttributeSet android.os.Bundle ), 0, this, string2, attributeSet, bundle);
    }

    public AssetManager getAssets() {
        return InvokeDynamicSupport.bootstrap("getAssets", $$robo$$android_content_res_Resources$getAssets(), 0, this);
    }

    public void flushLayoutCache() {
        InvokeDynamicSupport.bootstrap("flushLayoutCache", $$robo$$android_content_res_Resources$flushLayoutCache(), 0, this);
    }

    public void startPreloading() {
        InvokeDynamicSupport.bootstrap("startPreloading", $$robo$$android_content_res_Resources$startPreloading(), 0, this);
    }

    public void finishPreloading() {
        InvokeDynamicSupport.bootstrap("finishPreloading", $$robo$$android_content_res_Resources$finishPreloading(), 0, this);
    }

    public LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return InvokeDynamicSupport.bootstrap("getPreloadedDrawables", $$robo$$android_content_res_Resources$getPreloadedDrawables(), 0, this);
    }

    private boolean verifyPreloadConfig(int n, int n2, int n3, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyPreloadConfig", $$robo$$android_content_res_Resources$verifyPreloadConfig(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    Drawable loadDrawable(TypedValue typedValue, int n, Theme theme) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadDrawable", $$robo$$android_content_res_Resources$loadDrawable(android.util.TypedValue int android.content.res.Resources$Theme ), 0, this, typedValue, n, theme);
    }

    private void cacheDrawable(TypedValue typedValue, Theme theme, boolean bl, ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap, long l, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("cacheDrawable", $$robo$$android_content_res_Resources$cacheDrawable(android.util.TypedValue android.content.res.Resources$Theme boolean android.util.ArrayMap<java.lang.String, android.util.LongSparseArray<java.lang.ref.WeakReference<android.graphics.drawable.Drawable$ConstantState>>> long android.graphics.drawable.Drawable ), 0, this, typedValue, theme, bl, arrayMap, l, drawable2);
    }

    private Drawable loadDrawableForCookie(TypedValue typedValue, int n, Theme theme) {
        return InvokeDynamicSupport.bootstrap("loadDrawableForCookie", $$robo$$android_content_res_Resources$loadDrawableForCookie(android.util.TypedValue int android.content.res.Resources$Theme ), 0, this, typedValue, n, theme);
    }

    private Drawable getCachedDrawable(ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap, long l, Theme theme) {
        return InvokeDynamicSupport.bootstrap("getCachedDrawable", $$robo$$android_content_res_Resources$getCachedDrawable(android.util.ArrayMap<java.lang.String, android.util.LongSparseArray<java.lang.ref.WeakReference<android.graphics.drawable.Drawable$ConstantState>>> long android.content.res.Resources$Theme ), 0, this, arrayMap, l, theme);
    }

    private Drawable.ConstantState getConstantStateLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray, long l) {
        return InvokeDynamicSupport.bootstrap("getConstantStateLocked", $$robo$$android_content_res_Resources$getConstantStateLocked(android.util.LongSparseArray<java.lang.ref.WeakReference<android.graphics.drawable.Drawable$ConstantState>> long ), 0, this, longSparseArray, l);
    }

    private Drawable getCachedDrawableLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray, long l) {
        return InvokeDynamicSupport.bootstrap("getCachedDrawableLocked", $$robo$$android_content_res_Resources$getCachedDrawableLocked(android.util.LongSparseArray<java.lang.ref.WeakReference<android.graphics.drawable.Drawable$ConstantState>> long ), 0, this, longSparseArray, l);
    }

    ColorStateList loadColorStateList(TypedValue typedValue, int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadColorStateList", $$robo$$android_content_res_Resources$loadColorStateList(android.util.TypedValue int ), 0, this, typedValue, n);
    }

    private ColorStateList getCachedColorStateList(long l) {
        return InvokeDynamicSupport.bootstrap("getCachedColorStateList", $$robo$$android_content_res_Resources$getCachedColorStateList(long ), 0, this, l);
    }

    XmlResourceParser loadXmlResourceParser(int n, String string2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadXmlResourceParser", $$robo$$android_content_res_Resources$loadXmlResourceParser(int java.lang.String ), 0, this, n, string2);
    }

    XmlResourceParser loadXmlResourceParser(String string2, int n, int n2, String string3) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadXmlResourceParser", $$robo$$android_content_res_Resources$loadXmlResourceParser(java.lang.String int int java.lang.String ), 0, this, string2, n, n2, string3);
    }

    void recycleCachedStyledAttributes(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("recycleCachedStyledAttributes", $$robo$$android_content_res_Resources$recycleCachedStyledAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_Resources$__constructor__();
    }

    private Resources() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Resources.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Resources)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Theme
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AssetManager mAssets;
        private long mTheme;
        private int mThemeResId;
        private String mKey;
        /* synthetic */ Resources this$0;

        private final void $$robo$$android_content_res_Resources_Theme$applyStyle(int resId, boolean force) {
            AssetManager.applyThemeStyle(this.mTheme, resId, force);
            this.mThemeResId = resId;
            this.mKey = this.mKey + Integer.toHexString(resId) + (force ? "! " : " ");
        }

        private final void $$robo$$android_content_res_Resources_Theme$setTo(Theme other) {
            AssetManager.copyTheme(this.mTheme, other.mTheme);
            this.mThemeResId = other.mThemeResId;
            this.mKey = other.mKey;
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int[] attrs) {
            int len = attrs.length;
            TypedArray array2 = TypedArray.obtain(this.this$0, len);
            array2.mTheme = this;
            AssetManager.applyStyle(this.mTheme, 0, 0, 0L, attrs, array2.mData, array2.mIndices);
            return array2;
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int resid, int[] attrs) throws NotFoundException {
            int len = attrs.length;
            TypedArray array2 = TypedArray.obtain(this.this$0, len);
            array2.mTheme = this;
            AssetManager.applyStyle(this.mTheme, 0, resid, 0L, attrs, array2.mData, array2.mIndices);
            return array2;
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            int len = attrs.length;
            TypedArray array2 = TypedArray.obtain(this.this$0, len);
            XmlBlock.Parser parser = (XmlBlock.Parser)set;
            AssetManager.applyStyle(this.mTheme, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, attrs, array2.mData, array2.mIndices);
            array2.mTheme = this;
            array2.mXml = parser;
            return array2;
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$resolveAttributes(int[] values, int[] attrs) {
            int len = attrs.length;
            if (values != null && len != values.length) {
                throw new IllegalArgumentException("Base attribute values must be null or the same length as attrs");
            }
            TypedArray array2 = TypedArray.obtain(this.this$0, len);
            AssetManager.resolveAttrs(this.mTheme, 0, 0, values, attrs, array2.mData, array2.mIndices);
            array2.mTheme = this;
            array2.mXml = null;
            return array2;
        }

        private final boolean $$robo$$android_content_res_Resources_Theme$resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            boolean got = this.mAssets.getThemeValue(this.mTheme, resid, outValue, resolveRefs);
            return got;
        }

        private final int[] $$robo$$android_content_res_Resources_Theme$getAllAttributes() {
            return this.mAssets.getStyleAttributes(this.getAppliedStyleResId());
        }

        private final Resources $$robo$$android_content_res_Resources_Theme$getResources() {
            return this.this$0;
        }

        private final Drawable $$robo$$android_content_res_Resources_Theme$getDrawable(int id2) throws NotFoundException {
            return this.this$0.getDrawable(id2, this);
        }

        private final void $$robo$$android_content_res_Resources_Theme$dump(int priority, String tag, String prefix) {
            AssetManager.dumpTheme(this.mTheme, priority, tag, prefix);
        }

        private final void $$robo$$android_content_res_Resources_Theme$finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        private void $$robo$$android_content_res_Resources_Theme$__constructor__(Resources resources) {
            this.mThemeResId = 0;
            this.mKey = "";
            this.mAssets = resources.mAssets;
            this.mTheme = this.mAssets.createTheme();
        }

        private final long $$robo$$android_content_res_Resources_Theme$getNativeTheme() {
            return this.mTheme;
        }

        private final int $$robo$$android_content_res_Resources_Theme$getAppliedStyleResId() {
            return this.mThemeResId;
        }

        private final String $$robo$$android_content_res_Resources_Theme$getKey() {
            return this.mKey;
        }

        private final String $$robo$$android_content_res_Resources_Theme$getResourceNameFromHexString(String hexString) {
            return this.this$0.getResourceName(Integer.parseInt(hexString, 16));
        }

        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        private final String[] $$robo$$android_content_res_Resources_Theme$getTheme() {
            String[] themeData = this.mKey.split(" ");
            String[] themes = new String[themeData.length * 2];
            int i = 0;
            int j = themeData.length - 1;
            while (i < themes.length) {
                String theme = themeData[j];
                boolean forced = theme.endsWith("!");
                themes[i] = forced ? this.getResourceNameFromHexString(theme.substring(0, theme.length() - 1)) : this.getResourceNameFromHexString(theme);
                themes[i + 1] = forced ? "forced" : "not forced";
                i += 2;
                --j;
            }
            return themes;
        }

        public void applyStyle(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("applyStyle", $$robo$$android_content_res_Resources_Theme$applyStyle(int boolean ), 0, this, n, bl);
        }

        public void setTo(Theme theme) {
            InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_content_res_Resources_Theme$setTo(android.content.res.Resources$Theme ), 0, this, theme);
        }

        public TypedArray obtainStyledAttributes(int[] nArray) {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int[] ), 0, this, nArray);
        }

        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int int[] ), 0, this, n, nArray);
        }

        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(android.util.AttributeSet int[] int int ), 0, this, attributeSet, nArray, n, n2);
        }

        public TypedArray resolveAttributes(int[] nArray, int[] nArray2) {
            return InvokeDynamicSupport.bootstrap("resolveAttributes", $$robo$$android_content_res_Resources_Theme$resolveAttributes(int[] int[] ), 0, this, nArray, nArray2);
        }

        public boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("resolveAttribute", $$robo$$android_content_res_Resources_Theme$resolveAttribute(int android.util.TypedValue boolean ), 0, this, n, typedValue, bl);
        }

        public int[] getAllAttributes() {
            return InvokeDynamicSupport.bootstrap("getAllAttributes", $$robo$$android_content_res_Resources_Theme$getAllAttributes(), 0, this);
        }

        public Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_content_res_Resources_Theme$getResources(), 0, this);
        }

        public Drawable getDrawable(int n) throws NotFoundException {
            return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_Resources_Theme$getDrawable(int ), 0, this, n);
        }

        public void dump(int n, String string2, String string3) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_res_Resources_Theme$dump(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_Resources_Theme$finalize(), 0, this);
        }

        private void __constructor__(Resources resources) {
            this.$$robo$$android_content_res_Resources_Theme$__constructor__(resources);
        }

        Theme(Resources resources) {
            this.this$0 = resources;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_Theme$__constructor__(android.content.res.Resources ), 0, this, resources);
        }

        long getNativeTheme() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeTheme", $$robo$$android_content_res_Resources_Theme$getNativeTheme(), 0, this);
        }

        int getAppliedStyleResId() {
            return (int)InvokeDynamicSupport.bootstrap("getAppliedStyleResId", $$robo$$android_content_res_Resources_Theme$getAppliedStyleResId(), 0, this);
        }

        String getKey() {
            return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_content_res_Resources_Theme$getKey(), 0, this);
        }

        private String getResourceNameFromHexString(String string2) {
            return InvokeDynamicSupport.bootstrap("getResourceNameFromHexString", $$robo$$android_content_res_Resources_Theme$getResourceNameFromHexString(java.lang.String ), 0, this, string2);
        }

        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        public String[] getTheme() {
            return InvokeDynamicSupport.bootstrap("getTheme", $$robo$$android_content_res_Resources_Theme$getTheme(), 0, this);
        }

        public /* synthetic */ Theme() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Theme)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NotFoundException
    extends RuntimeException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_res_Resources_NotFoundException$__constructor__() {
        }

        private void $$robo$$android_content_res_Resources_NotFoundException$__constructor__(String name) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_res_Resources_NotFoundException$__constructor__();
        }

        public NotFoundException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_NotFoundException$__constructor__(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_res_Resources_NotFoundException$__constructor__(string2);
        }

        public NotFoundException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_NotFoundException$__constructor__(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotFoundException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

