/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.BulkCursorDescriptor;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.database.StaleDataException;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BulkCursor";
    private AbstractCursor.SelfContentObserver mObserverBridge;
    private IBulkCursor mBulkCursor;
    private String[] mColumns;
    private boolean mWantsAllOnMoveCalls;
    private int mCount;

    private void $$robo$$android_database_BulkCursorToCursorAdaptor$__constructor__() {
        this.mObserverBridge = new AbstractCursor.SelfContentObserver(this);
    }

    private final void $$robo$$android_database_BulkCursorToCursorAdaptor$initialize(BulkCursorDescriptor d) {
        this.mBulkCursor = d.cursor;
        this.mColumns = d.columnNames;
        this.mRowIdColumnIndex = DatabaseUtils.findRowIdColumnIndex(this.mColumns);
        this.mWantsAllOnMoveCalls = d.wantsAllOnMoveCalls;
        this.mCount = d.count;
        if (d.window != null) {
            this.setWindow(d.window);
        }
    }

    private final IContentObserver $$robo$$android_database_BulkCursorToCursorAdaptor$getObserver() {
        return this.mObserverBridge.getContentObserver();
    }

    private final void $$robo$$android_database_BulkCursorToCursorAdaptor$throwIfCursorIsClosed() {
        if (this.mBulkCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    private final int $$robo$$android_database_BulkCursorToCursorAdaptor$getCount() {
        this.throwIfCursorIsClosed();
        return this.mCount;
    }

    private final boolean $$robo$$android_database_BulkCursorToCursorAdaptor$onMove(int oldPosition, int newPosition) {
        this.throwIfCursorIsClosed();
        try {
            if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                this.setWindow(this.mBulkCursor.getWindow(newPosition));
            } else if (this.mWantsAllOnMoveCalls) {
                this.mBulkCursor.onMove(newPosition);
            }
        }
        catch (RemoteException ex) {
            Log.e("BulkCursor", "Unable to get window because the remote process is dead");
            return false;
        }
        return this.mWindow != null;
    }

    private final void $$robo$$android_database_BulkCursorToCursorAdaptor$deactivate() {
        super.deactivate();
        if (this.mBulkCursor != null) {
            try {
                this.mBulkCursor.deactivate();
            }
            catch (RemoteException ex) {
                Log.w("BulkCursor", "Remote process exception when deactivating");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_BulkCursorToCursorAdaptor$close() {
        super.close();
        if (this.mBulkCursor != null) {
            try {
                this.mBulkCursor.close();
            }
            catch (RemoteException ex) {
                Log.w("BulkCursor", "Remote process exception when closing");
            }
            finally {
                this.mBulkCursor = null;
            }
        }
    }

    private final boolean $$robo$$android_database_BulkCursorToCursorAdaptor$requery() {
        this.throwIfCursorIsClosed();
        try {
            this.mCount = this.mBulkCursor.requery(this.getObserver());
            if (this.mCount != -1) {
                this.mPos = -1;
                this.closeWindow();
                super.requery();
                return true;
            }
            this.deactivate();
            return false;
        }
        catch (Exception ex) {
            Log.e("BulkCursor", "Unable to requery because the remote process exception " + ex.getMessage());
            this.deactivate();
            return false;
        }
    }

    private final String[] $$robo$$android_database_BulkCursorToCursorAdaptor$getColumnNames() {
        this.throwIfCursorIsClosed();
        return this.mColumns;
    }

    private final Bundle $$robo$$android_database_BulkCursorToCursorAdaptor$getExtras() {
        this.throwIfCursorIsClosed();
        try {
            return this.mBulkCursor.getExtras();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private final Bundle $$robo$$android_database_BulkCursorToCursorAdaptor$respond(Bundle extras) {
        this.throwIfCursorIsClosed();
        try {
            return this.mBulkCursor.respond(extras);
        }
        catch (RemoteException e) {
            Log.w("BulkCursor", "respond() threw RemoteException, returning an empty bundle.", e);
            return Bundle.EMPTY;
        }
    }

    private void __constructor__() {
        this.$$robo$$android_database_BulkCursorToCursorAdaptor$__constructor__();
    }

    public BulkCursorToCursorAdaptor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_BulkCursorToCursorAdaptor$__constructor__(), 0, this);
    }

    public void initialize(BulkCursorDescriptor bulkCursorDescriptor) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_database_BulkCursorToCursorAdaptor$initialize(android.database.BulkCursorDescriptor ), 0, this, bulkCursorDescriptor);
    }

    public IContentObserver getObserver() {
        return InvokeDynamicSupport.bootstrap("getObserver", $$robo$$android_database_BulkCursorToCursorAdaptor$getObserver(), 0, this);
    }

    private void throwIfCursorIsClosed() {
        InvokeDynamicSupport.bootstrap("throwIfCursorIsClosed", $$robo$$android_database_BulkCursorToCursorAdaptor$throwIfCursorIsClosed(), 0, this);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_database_BulkCursorToCursorAdaptor$getCount(), 0, this);
    }

    @Override
    public boolean onMove(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMove", $$robo$$android_database_BulkCursorToCursorAdaptor$onMove(int int ), 0, this, n, n2);
    }

    @Override
    public void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_database_BulkCursorToCursorAdaptor$deactivate(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_BulkCursorToCursorAdaptor$close(), 0, this);
    }

    @Override
    public boolean requery() {
        return (boolean)InvokeDynamicSupport.bootstrap("requery", $$robo$$android_database_BulkCursorToCursorAdaptor$requery(), 0, this);
    }

    @Override
    public String[] getColumnNames() {
        return InvokeDynamicSupport.bootstrap("getColumnNames", $$robo$$android_database_BulkCursorToCursorAdaptor$getColumnNames(), 0, this);
    }

    @Override
    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_database_BulkCursorToCursorAdaptor$getExtras(), 0, this);
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("respond", $$robo$$android_database_BulkCursorToCursorAdaptor$respond(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BulkCursorToCursorAdaptor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

