/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.SQLException;
import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.os.OperationCanceledException;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DatabaseUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DatabaseUtils";
    private static boolean DEBUG = false;
    public static int STATEMENT_SELECT = 1;
    public static int STATEMENT_UPDATE = 2;
    public static int STATEMENT_ATTACH = 3;
    public static int STATEMENT_BEGIN = 4;
    public static int STATEMENT_COMMIT = 5;
    public static int STATEMENT_ABORT = 6;
    public static int STATEMENT_PRAGMA = 7;
    public static int STATEMENT_DDL = 8;
    public static int STATEMENT_UNPREPARED = 9;
    public static int STATEMENT_OTHER = 99;
    private static Collator mColl;

    private void $$robo$$android_database_DatabaseUtils$__constructor__() {
    }

    private static final void $$robo$$android_database_DatabaseUtils$writeExceptionToParcel(Parcel reply, Exception e) {
        int code = 0;
        boolean logException = true;
        if (e instanceof FileNotFoundException) {
            code = 1;
            logException = false;
        } else if (e instanceof IllegalArgumentException) {
            code = 2;
        } else if (e instanceof UnsupportedOperationException) {
            code = 3;
        } else if (e instanceof SQLiteAbortException) {
            code = 4;
        } else if (e instanceof SQLiteConstraintException) {
            code = 5;
        } else if (e instanceof SQLiteDatabaseCorruptException) {
            code = 6;
        } else if (e instanceof SQLiteFullException) {
            code = 7;
        } else if (e instanceof SQLiteDiskIOException) {
            code = 8;
        } else if (e instanceof SQLiteException) {
            code = 9;
        } else if (e instanceof OperationApplicationException) {
            code = 10;
        } else if (e instanceof OperationCanceledException) {
            code = 11;
            logException = false;
        } else {
            reply.writeException(e);
            Log.e("DatabaseUtils", "Writing exception to parcel", e);
            return;
        }
        reply.writeInt(code);
        reply.writeString(e.getMessage());
        if (logException) {
            Log.e("DatabaseUtils", "Writing exception to parcel", e);
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$readExceptionFromParcel(Parcel reply) {
        int code = reply.readExceptionCode();
        if (code == 0) {
            return;
        }
        String msg = reply.readString();
        DatabaseUtils.readExceptionFromParcel(reply, msg, code);
    }

    private static final void $$robo$$android_database_DatabaseUtils$readExceptionWithFileNotFoundExceptionFromParcel(Parcel reply) throws FileNotFoundException {
        int code = reply.readExceptionCode();
        if (code == 0) {
            return;
        }
        String msg = reply.readString();
        if (code == 1) {
            throw new FileNotFoundException(msg);
        }
        DatabaseUtils.readExceptionFromParcel(reply, msg, code);
    }

    private static final void $$robo$$android_database_DatabaseUtils$readExceptionWithOperationApplicationExceptionFromParcel(Parcel reply) throws OperationApplicationException {
        int code = reply.readExceptionCode();
        if (code == 0) {
            return;
        }
        String msg = reply.readString();
        if (code == 10) {
            throw new OperationApplicationException(msg);
        }
        DatabaseUtils.readExceptionFromParcel(reply, msg, code);
    }

    private static final void $$robo$$android_database_DatabaseUtils$readExceptionFromParcel(Parcel reply, String msg, int code) {
        switch (code) {
            case 2: {
                throw new IllegalArgumentException(msg);
            }
            case 3: {
                throw new UnsupportedOperationException(msg);
            }
            case 4: {
                throw new SQLiteAbortException(msg);
            }
            case 5: {
                throw new SQLiteConstraintException(msg);
            }
            case 6: {
                throw new SQLiteDatabaseCorruptException(msg);
            }
            case 7: {
                throw new SQLiteFullException(msg);
            }
            case 8: {
                throw new SQLiteDiskIOException(msg);
            }
            case 9: {
                throw new SQLiteException(msg);
            }
            case 11: {
                throw new OperationCanceledException(msg);
            }
        }
        reply.readException(code, msg);
    }

    private static final void $$robo$$android_database_DatabaseUtils$bindObjectToProgram(SQLiteProgram prog, int index, Object value) {
        if (value == null) {
            prog.bindNull(index);
        } else if (value instanceof Double || value instanceof Float) {
            prog.bindDouble(index, ((Number)value).doubleValue());
        } else if (value instanceof Number) {
            prog.bindLong(index, ((Number)value).longValue());
        } else if (value instanceof Boolean) {
            Boolean bool2 = (Boolean)value;
            if (bool2.booleanValue()) {
                prog.bindLong(index, 1L);
            } else {
                prog.bindLong(index, 0L);
            }
        } else if (value instanceof byte[]) {
            prog.bindBlob(index, (byte[])value);
        } else {
            prog.bindString(index, value.toString());
        }
    }

    private static final int $$robo$$android_database_DatabaseUtils$getTypeOfObject(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof byte[]) {
            return 4;
        }
        if (obj instanceof Float || obj instanceof Double) {
            return 2;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return 1;
        }
        return 3;
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorFillWindow(Cursor cursor, int position, CursorWindow window) {
        if (position < 0 || position >= cursor.getCount()) {
            return;
        }
        int oldPos = cursor.getPosition();
        int numColumns = cursor.getColumnCount();
        window.clear();
        window.setStartPosition(position);
        window.setNumColumns(numColumns);
        if (cursor.moveToPosition(position)) {
            while (window.allocRow()) {
                for (int i = 0; i < numColumns; ++i) {
                    boolean success;
                    int type = cursor.getType(i);
                    switch (type) {
                        case 0: {
                            success = window.putNull(position, i);
                            break;
                        }
                        case 1: {
                            success = window.putLong(cursor.getLong(i), position, i);
                            break;
                        }
                        case 2: {
                            success = window.putDouble(cursor.getDouble(i), position, i);
                            break;
                        }
                        case 4: {
                            Object value = cursor.getBlob(i);
                            success = value != null ? window.putBlob((byte[])value, position, i) : window.putNull(position, i);
                            break;
                        }
                        default: {
                            Object value = cursor.getString(i);
                            success = value != null ? window.putString((String)value, position, i) : window.putNull(position, i);
                            break;
                        }
                    }
                    if (success) continue;
                    window.freeLastRow();
                    break;
                }
                ++position;
                if (cursor.moveToNext()) continue;
            }
        }
        cursor.moveToPosition(oldPos);
    }

    private static final void $$robo$$android_database_DatabaseUtils$appendEscapedSQLString(StringBuilder sb, String sqlString) {
        sb.append('\'');
        if (sqlString.indexOf(39) != -1) {
            int length = sqlString.length();
            for (int i = 0; i < length; ++i) {
                char c = sqlString.charAt(i);
                if (c == '\'') {
                    sb.append('\'');
                }
                sb.append(c);
            }
        } else {
            sb.append(sqlString);
        }
        sb.append('\'');
    }

    private static final String $$robo$$android_database_DatabaseUtils$sqlEscapeString(String value) {
        StringBuilder escaper = new StringBuilder();
        DatabaseUtils.appendEscapedSQLString(escaper, value);
        return escaper.toString();
    }

    private static final void $$robo$$android_database_DatabaseUtils$appendValueToSql(StringBuilder sql, Object value) {
        if (value == null) {
            sql.append("NULL");
        } else if (value instanceof Boolean) {
            Boolean bool2 = (Boolean)value;
            if (bool2.booleanValue()) {
                sql.append('1');
            } else {
                sql.append('0');
            }
        } else {
            DatabaseUtils.appendEscapedSQLString(sql, value.toString());
        }
    }

    private static final String $$robo$$android_database_DatabaseUtils$concatenateWhere(String a, String b) {
        if (TextUtils.isEmpty(a)) {
            return b;
        }
        if (TextUtils.isEmpty(b)) {
            return a;
        }
        return "(" + a + ") AND (" + b + ")";
    }

    private static final String $$robo$$android_database_DatabaseUtils$getCollationKey(String name) {
        byte[] arr = DatabaseUtils.getCollationKeyInBytes(name);
        try {
            return new String(arr, 0, DatabaseUtils.getKeyLen(arr), "ISO8859_1");
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static final String $$robo$$android_database_DatabaseUtils$getHexCollationKey(String name) {
        byte[] arr = DatabaseUtils.getCollationKeyInBytes(name);
        char[] keys = Hex.encodeHex(arr);
        return new String(keys, 0, DatabaseUtils.getKeyLen(arr) * 2);
    }

    private static final int $$robo$$android_database_DatabaseUtils$getKeyLen(byte[] arr) {
        if (arr[arr.length - 1] != 0) {
            return arr.length;
        }
        return arr.length - 1;
    }

    private static final byte[] $$robo$$android_database_DatabaseUtils$getCollationKeyInBytes(String name) {
        if (mColl == null) {
            mColl = Collator.getInstance();
            mColl.setStrength(0);
        }
        return mColl.getCollationKey(name).toByteArray();
    }

    private static final void $$robo$$android_database_DatabaseUtils$dumpCursor(Cursor cursor) {
        DatabaseUtils.dumpCursor(cursor, System.out);
    }

    private static final void $$robo$$android_database_DatabaseUtils$dumpCursor(Cursor cursor, PrintStream stream) {
        stream.println(">>>>> Dumping cursor " + cursor);
        if (cursor != null) {
            int startPos = cursor.getPosition();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, stream);
            }
            cursor.moveToPosition(startPos);
        }
        stream.println("<<<<<");
    }

    private static final void $$robo$$android_database_DatabaseUtils$dumpCursor(Cursor cursor, StringBuilder sb) {
        sb.append(">>>>> Dumping cursor " + cursor + "\n");
        if (cursor != null) {
            int startPos = cursor.getPosition();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, sb);
            }
            cursor.moveToPosition(startPos);
        }
        sb.append("<<<<<\n");
    }

    private static final String $$robo$$android_database_DatabaseUtils$dumpCursorToString(Cursor cursor) {
        StringBuilder sb = new StringBuilder();
        DatabaseUtils.dumpCursor(cursor, sb);
        return sb.toString();
    }

    private static final void $$robo$$android_database_DatabaseUtils$dumpCurrentRow(Cursor cursor) {
        DatabaseUtils.dumpCurrentRow(cursor, System.out);
    }

    private static final void $$robo$$android_database_DatabaseUtils$dumpCurrentRow(Cursor cursor, PrintStream stream) {
        String[] cols = cursor.getColumnNames();
        stream.println("" + cursor.getPosition() + " {");
        int length = cols.length;
        for (int i = 0; i < length; ++i) {
            String value;
            try {
                value = cursor.getString(i);
            }
            catch (SQLiteException e) {
                value = "<unprintable>";
            }
            stream.println("   " + cols[i] + '=' + value);
        }
        stream.println("}");
    }

    private static final void $$robo$$android_database_DatabaseUtils$dumpCurrentRow(Cursor cursor, StringBuilder sb) {
        String[] cols = cursor.getColumnNames();
        sb.append("" + cursor.getPosition() + " {\n");
        int length = cols.length;
        for (int i = 0; i < length; ++i) {
            String value;
            try {
                value = cursor.getString(i);
            }
            catch (SQLiteException e) {
                value = "<unprintable>";
            }
            sb.append("   " + cols[i] + '=' + value + "\n");
        }
        sb.append("}\n");
    }

    private static final String $$robo$$android_database_DatabaseUtils$dumpCurrentRowToString(Cursor cursor) {
        StringBuilder sb = new StringBuilder();
        DatabaseUtils.dumpCurrentRow(cursor, sb);
        return sb.toString();
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorStringToContentValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorStringToContentValues(cursor, field, values, field);
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorStringToInsertHelper(Cursor cursor, String field, InsertHelper inserter, int index) {
        inserter.bind(index, cursor.getString(cursor.getColumnIndexOrThrow(field)));
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorStringToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        values.put(key, cursor.getString(cursor.getColumnIndexOrThrow(field)));
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorIntToContentValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorIntToContentValues(cursor, field, values, field);
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorIntToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        int colIndex = cursor.getColumnIndex(field);
        if (!cursor.isNull(colIndex)) {
            values.put(key, cursor.getInt(colIndex));
        } else {
            values.put(key, (Integer)null);
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorLongToContentValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorLongToContentValues(cursor, field, values, field);
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorLongToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        int colIndex = cursor.getColumnIndex(field);
        if (!cursor.isNull(colIndex)) {
            Long value = cursor.getLong(colIndex);
            values.put(key, value);
        } else {
            values.put(key, (Long)null);
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorDoubleToCursorValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorDoubleToContentValues(cursor, field, values, field);
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorDoubleToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        int colIndex = cursor.getColumnIndex(field);
        if (!cursor.isNull(colIndex)) {
            values.put(key, cursor.getDouble(colIndex));
        } else {
            values.put(key, (Double)null);
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorRowToContentValues(Cursor cursor, ContentValues values) {
        AbstractWindowedCursor awc = cursor instanceof AbstractWindowedCursor ? (AbstractWindowedCursor)cursor : null;
        String[] columns = cursor.getColumnNames();
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            if (awc != null && awc.isBlob(i)) {
                values.put(columns[i], cursor.getBlob(i));
                continue;
            }
            values.put(columns[i], cursor.getString(i));
        }
    }

    private static final int $$robo$$android_database_DatabaseUtils$cursorPickFillWindowStartPosition(int cursorPosition, int cursorWindowCapacity) {
        return Math.max(cursorPosition - cursorWindowCapacity / 3, 0);
    }

    private static final long $$robo$$android_database_DatabaseUtils$queryNumEntries(SQLiteDatabase db, String table) {
        return DatabaseUtils.queryNumEntries(db, table, null, null);
    }

    private static final long $$robo$$android_database_DatabaseUtils$queryNumEntries(SQLiteDatabase db, String table, String selection) {
        return DatabaseUtils.queryNumEntries(db, table, selection, null);
    }

    private static final long $$robo$$android_database_DatabaseUtils$queryNumEntries(SQLiteDatabase db, String table, String selection, String[] selectionArgs) {
        String s = !TextUtils.isEmpty(selection) ? " where " + selection : "";
        return DatabaseUtils.longForQuery(db, "select count(*) from " + table + s, selectionArgs);
    }

    private static final boolean $$robo$$android_database_DatabaseUtils$queryIsEmpty(SQLiteDatabase db, String table) {
        long isEmpty = DatabaseUtils.longForQuery(db, "select exists(select 1 from " + table + ")", null);
        return isEmpty == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$android_database_DatabaseUtils$longForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try (SQLiteStatement prog = db.compileStatement(query);){
            long l = DatabaseUtils.longForQuery(prog, selectionArgs);
            return l;
        }
    }

    private static final long $$robo$$android_database_DatabaseUtils$longForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_database_DatabaseUtils$stringForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try (SQLiteStatement prog = db.compileStatement(query);){
            String string2 = DatabaseUtils.stringForQuery(prog, selectionArgs);
            return string2;
        }
    }

    private static final String $$robo$$android_database_DatabaseUtils$stringForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ParcelFileDescriptor $$robo$$android_database_DatabaseUtils$blobFileDescriptorForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try (SQLiteStatement prog = db.compileStatement(query);){
            ParcelFileDescriptor parcelFileDescriptor = DatabaseUtils.blobFileDescriptorForQuery(prog, selectionArgs);
            return parcelFileDescriptor;
        }
    }

    private static final ParcelFileDescriptor $$robo$$android_database_DatabaseUtils$blobFileDescriptorForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForBlobFileDescriptor();
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorStringToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getString(index));
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorLongToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getLong(index));
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorShortToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getShort(index));
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorIntToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getInt(index));
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorFloatToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, Float.valueOf(cursor.getFloat(index)));
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$cursorDoubleToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getDouble(index));
        }
    }

    private static final void $$robo$$android_database_DatabaseUtils$createDbFromSqlStatements(Context context, String dbName, int dbVersion, String sqlStatements) {
        String[] statements;
        SQLiteDatabase db = context.openOrCreateDatabase(dbName, 0, null);
        for (String statement : statements = TextUtils.split(sqlStatements, ";\n")) {
            if (TextUtils.isEmpty(statement)) continue;
            db.execSQL(statement);
        }
        db.setVersion(dbVersion);
        db.close();
    }

    private static final int $$robo$$android_database_DatabaseUtils$getSqlStatementType(String sql) {
        if ((sql = sql.trim()).length() < 3) {
            return 99;
        }
        String prefixSql = sql.substring(0, 3).toUpperCase(Locale.ROOT);
        if (prefixSql.equals("SEL")) {
            return 1;
        }
        if (prefixSql.equals("INS") || prefixSql.equals("UPD") || prefixSql.equals("REP") || prefixSql.equals("DEL")) {
            return 2;
        }
        if (prefixSql.equals("ATT")) {
            return 3;
        }
        if (prefixSql.equals("COM")) {
            return 5;
        }
        if (prefixSql.equals("END")) {
            return 5;
        }
        if (prefixSql.equals("ROL")) {
            return 6;
        }
        if (prefixSql.equals("BEG")) {
            return 4;
        }
        if (prefixSql.equals("PRA")) {
            return 7;
        }
        if (prefixSql.equals("CRE") || prefixSql.equals("DRO") || prefixSql.equals("ALT")) {
            return 8;
        }
        if (prefixSql.equals("ANA") || prefixSql.equals("DET")) {
            return 9;
        }
        return 99;
    }

    private static final String[] $$robo$$android_database_DatabaseUtils$appendSelectionArgs(String[] originalValues, String[] newValues) {
        if (originalValues == null || originalValues.length == 0) {
            return newValues;
        }
        String[] result = new String[originalValues.length + newValues.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)originalValues, (int)0, (Object)result, (int)0, (int)originalValues.length);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)newValues, (int)0, (Object)result, (int)originalValues.length, (int)newValues.length);
        return result;
    }

    private static final int $$robo$$android_database_DatabaseUtils$findRowIdColumnIndex(String[] columnNames) {
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    static void __staticInitializer__() {
        mColl = null;
    }

    private void __constructor__() {
        this.$$robo$$android_database_DatabaseUtils$__constructor__();
    }

    public DatabaseUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_DatabaseUtils$__constructor__(), 0, this);
    }

    public static void writeExceptionToParcel(Parcel parcel, Exception exception) {
        InvokeDynamicSupport.bootstrapStatic("writeExceptionToParcel", $$robo$$android_database_DatabaseUtils$writeExceptionToParcel(android.os.Parcel java.lang.Exception ), 0, (Parcel)parcel, (Exception)exception);
    }

    public static void readExceptionFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("readExceptionFromParcel", $$robo$$android_database_DatabaseUtils$readExceptionFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    public static void readExceptionWithFileNotFoundExceptionFromParcel(Parcel parcel) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrapStatic("readExceptionWithFileNotFoundExceptionFromParcel", $$robo$$android_database_DatabaseUtils$readExceptionWithFileNotFoundExceptionFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    public static void readExceptionWithOperationApplicationExceptionFromParcel(Parcel parcel) throws OperationApplicationException {
        InvokeDynamicSupport.bootstrapStatic("readExceptionWithOperationApplicationExceptionFromParcel", $$robo$$android_database_DatabaseUtils$readExceptionWithOperationApplicationExceptionFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    private static void readExceptionFromParcel(Parcel parcel, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("readExceptionFromParcel", $$robo$$android_database_DatabaseUtils$readExceptionFromParcel(android.os.Parcel java.lang.String int ), 0, (Parcel)parcel, (String)string2, (int)n);
    }

    public static void bindObjectToProgram(SQLiteProgram sQLiteProgram, int n, Object object) {
        InvokeDynamicSupport.bootstrapStatic("bindObjectToProgram", $$robo$$android_database_DatabaseUtils$bindObjectToProgram(android.database.sqlite.SQLiteProgram int java.lang.Object ), 0, (SQLiteProgram)sQLiteProgram, (int)n, (Object)object);
    }

    public static int getTypeOfObject(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTypeOfObject", $$robo$$android_database_DatabaseUtils$getTypeOfObject(java.lang.Object ), 0, (Object)object);
    }

    public static void cursorFillWindow(Cursor cursor, int n, CursorWindow cursorWindow) {
        InvokeDynamicSupport.bootstrapStatic("cursorFillWindow", $$robo$$android_database_DatabaseUtils$cursorFillWindow(android.database.Cursor int android.database.CursorWindow ), 0, (Cursor)cursor, (int)n, (CursorWindow)cursorWindow);
    }

    public static void appendEscapedSQLString(StringBuilder stringBuilder, String string2) {
        InvokeDynamicSupport.bootstrapStatic("appendEscapedSQLString", $$robo$$android_database_DatabaseUtils$appendEscapedSQLString(java.lang.StringBuilder java.lang.String ), 0, (StringBuilder)stringBuilder, (String)string2);
    }

    public static String sqlEscapeString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("sqlEscapeString", $$robo$$android_database_DatabaseUtils$sqlEscapeString(java.lang.String ), 0, (String)string2);
    }

    public static void appendValueToSql(StringBuilder stringBuilder, Object object) {
        InvokeDynamicSupport.bootstrapStatic("appendValueToSql", $$robo$$android_database_DatabaseUtils$appendValueToSql(java.lang.StringBuilder java.lang.Object ), 0, (StringBuilder)stringBuilder, (Object)object);
    }

    public static String concatenateWhere(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("concatenateWhere", $$robo$$android_database_DatabaseUtils$concatenateWhere(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getCollationKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCollationKey", $$robo$$android_database_DatabaseUtils$getCollationKey(java.lang.String ), 0, (String)string2);
    }

    public static String getHexCollationKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getHexCollationKey", $$robo$$android_database_DatabaseUtils$getHexCollationKey(java.lang.String ), 0, (String)string2);
    }

    private static int getKeyLen(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getKeyLen", $$robo$$android_database_DatabaseUtils$getKeyLen(byte[] ), 0, (byte[])byArray);
    }

    private static byte[] getCollationKeyInBytes(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCollationKeyInBytes", $$robo$$android_database_DatabaseUtils$getCollationKeyInBytes(java.lang.String ), 0, (String)string2);
    }

    public static void dumpCursor(Cursor cursor) {
        InvokeDynamicSupport.bootstrapStatic("dumpCursor", $$robo$$android_database_DatabaseUtils$dumpCursor(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public static void dumpCursor(Cursor cursor, PrintStream printStream) {
        InvokeDynamicSupport.bootstrapStatic("dumpCursor", $$robo$$android_database_DatabaseUtils$dumpCursor(android.database.Cursor java.io.PrintStream ), 0, (Cursor)cursor, (PrintStream)printStream);
    }

    public static void dumpCursor(Cursor cursor, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("dumpCursor", $$robo$$android_database_DatabaseUtils$dumpCursor(android.database.Cursor java.lang.StringBuilder ), 0, (Cursor)cursor, (StringBuilder)stringBuilder);
    }

    public static String dumpCursorToString(Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("dumpCursorToString", $$robo$$android_database_DatabaseUtils$dumpCursorToString(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public static void dumpCurrentRow(Cursor cursor) {
        InvokeDynamicSupport.bootstrapStatic("dumpCurrentRow", $$robo$$android_database_DatabaseUtils$dumpCurrentRow(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public static void dumpCurrentRow(Cursor cursor, PrintStream printStream) {
        InvokeDynamicSupport.bootstrapStatic("dumpCurrentRow", $$robo$$android_database_DatabaseUtils$dumpCurrentRow(android.database.Cursor java.io.PrintStream ), 0, (Cursor)cursor, (PrintStream)printStream);
    }

    public static void dumpCurrentRow(Cursor cursor, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("dumpCurrentRow", $$robo$$android_database_DatabaseUtils$dumpCurrentRow(android.database.Cursor java.lang.StringBuilder ), 0, (Cursor)cursor, (StringBuilder)stringBuilder);
    }

    public static String dumpCurrentRowToString(Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("dumpCurrentRowToString", $$robo$$android_database_DatabaseUtils$dumpCurrentRowToString(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public static void cursorStringToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        InvokeDynamicSupport.bootstrapStatic("cursorStringToContentValues", $$robo$$android_database_DatabaseUtils$cursorStringToContentValues(android.database.Cursor java.lang.String android.content.ContentValues ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues);
    }

    public static void cursorStringToInsertHelper(Cursor cursor, String string2, InsertHelper insertHelper, int n) {
        InvokeDynamicSupport.bootstrapStatic("cursorStringToInsertHelper", $$robo$$android_database_DatabaseUtils$cursorStringToInsertHelper(android.database.Cursor java.lang.String android.database.DatabaseUtils$InsertHelper int ), 0, (Cursor)cursor, (String)string2, (InsertHelper)insertHelper, (int)n);
    }

    public static void cursorStringToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        InvokeDynamicSupport.bootstrapStatic("cursorStringToContentValues", $$robo$$android_database_DatabaseUtils$cursorStringToContentValues(android.database.Cursor java.lang.String android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues, (String)string3);
    }

    public static void cursorIntToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        InvokeDynamicSupport.bootstrapStatic("cursorIntToContentValues", $$robo$$android_database_DatabaseUtils$cursorIntToContentValues(android.database.Cursor java.lang.String android.content.ContentValues ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues);
    }

    public static void cursorIntToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        InvokeDynamicSupport.bootstrapStatic("cursorIntToContentValues", $$robo$$android_database_DatabaseUtils$cursorIntToContentValues(android.database.Cursor java.lang.String android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues, (String)string3);
    }

    public static void cursorLongToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        InvokeDynamicSupport.bootstrapStatic("cursorLongToContentValues", $$robo$$android_database_DatabaseUtils$cursorLongToContentValues(android.database.Cursor java.lang.String android.content.ContentValues ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues);
    }

    public static void cursorLongToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        InvokeDynamicSupport.bootstrapStatic("cursorLongToContentValues", $$robo$$android_database_DatabaseUtils$cursorLongToContentValues(android.database.Cursor java.lang.String android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues, (String)string3);
    }

    public static void cursorDoubleToCursorValues(Cursor cursor, String string2, ContentValues contentValues) {
        InvokeDynamicSupport.bootstrapStatic("cursorDoubleToCursorValues", $$robo$$android_database_DatabaseUtils$cursorDoubleToCursorValues(android.database.Cursor java.lang.String android.content.ContentValues ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues);
    }

    public static void cursorDoubleToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        InvokeDynamicSupport.bootstrapStatic("cursorDoubleToContentValues", $$robo$$android_database_DatabaseUtils$cursorDoubleToContentValues(android.database.Cursor java.lang.String android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (String)string2, (ContentValues)contentValues, (String)string3);
    }

    public static void cursorRowToContentValues(Cursor cursor, ContentValues contentValues) {
        InvokeDynamicSupport.bootstrapStatic("cursorRowToContentValues", $$robo$$android_database_DatabaseUtils$cursorRowToContentValues(android.database.Cursor android.content.ContentValues ), 0, (Cursor)cursor, (ContentValues)contentValues);
    }

    public static int cursorPickFillWindowStartPosition(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("cursorPickFillWindowStartPosition", $$robo$$android_database_DatabaseUtils$cursorPickFillWindowStartPosition(int int ), 0, (int)n, (int)n2);
    }

    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("queryNumEntries", $$robo$$android_database_DatabaseUtils$queryNumEntries(android.database.sqlite.SQLiteDatabase java.lang.String ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2);
    }

    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2, String string3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("queryNumEntries", $$robo$$android_database_DatabaseUtils$queryNumEntries(android.database.sqlite.SQLiteDatabase java.lang.String java.lang.String ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2, (String)string3);
    }

    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2, String string3, String[] stringArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("queryNumEntries", $$robo$$android_database_DatabaseUtils$queryNumEntries(android.database.sqlite.SQLiteDatabase java.lang.String java.lang.String java.lang.String[] ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2, (String)string3, (String[])stringArray);
    }

    public static boolean queryIsEmpty(SQLiteDatabase sQLiteDatabase, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("queryIsEmpty", $$robo$$android_database_DatabaseUtils$queryIsEmpty(android.database.sqlite.SQLiteDatabase java.lang.String ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2);
    }

    public static long longForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("longForQuery", $$robo$$android_database_DatabaseUtils$longForQuery(android.database.sqlite.SQLiteDatabase java.lang.String java.lang.String[] ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2, (String[])stringArray);
    }

    public static long longForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("longForQuery", $$robo$$android_database_DatabaseUtils$longForQuery(android.database.sqlite.SQLiteStatement java.lang.String[] ), 0, (SQLiteStatement)sQLiteStatement, (String[])stringArray);
    }

    public static String stringForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("stringForQuery", $$robo$$android_database_DatabaseUtils$stringForQuery(android.database.sqlite.SQLiteDatabase java.lang.String java.lang.String[] ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2, (String[])stringArray);
    }

    public static String stringForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("stringForQuery", $$robo$$android_database_DatabaseUtils$stringForQuery(android.database.sqlite.SQLiteStatement java.lang.String[] ), 0, (SQLiteStatement)sQLiteStatement, (String[])stringArray);
    }

    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("blobFileDescriptorForQuery", $$robo$$android_database_DatabaseUtils$blobFileDescriptorForQuery(android.database.sqlite.SQLiteDatabase java.lang.String java.lang.String[] ), 0, (SQLiteDatabase)sQLiteDatabase, (String)string2, (String[])stringArray);
    }

    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("blobFileDescriptorForQuery", $$robo$$android_database_DatabaseUtils$blobFileDescriptorForQuery(android.database.sqlite.SQLiteStatement java.lang.String[] ), 0, (SQLiteStatement)sQLiteStatement, (String[])stringArray);
    }

    public static void cursorStringToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cursorStringToContentValuesIfPresent", $$robo$$android_database_DatabaseUtils$cursorStringToContentValuesIfPresent(android.database.Cursor android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (ContentValues)contentValues, (String)string2);
    }

    public static void cursorLongToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cursorLongToContentValuesIfPresent", $$robo$$android_database_DatabaseUtils$cursorLongToContentValuesIfPresent(android.database.Cursor android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (ContentValues)contentValues, (String)string2);
    }

    public static void cursorShortToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cursorShortToContentValuesIfPresent", $$robo$$android_database_DatabaseUtils$cursorShortToContentValuesIfPresent(android.database.Cursor android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (ContentValues)contentValues, (String)string2);
    }

    public static void cursorIntToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cursorIntToContentValuesIfPresent", $$robo$$android_database_DatabaseUtils$cursorIntToContentValuesIfPresent(android.database.Cursor android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (ContentValues)contentValues, (String)string2);
    }

    public static void cursorFloatToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cursorFloatToContentValuesIfPresent", $$robo$$android_database_DatabaseUtils$cursorFloatToContentValuesIfPresent(android.database.Cursor android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (ContentValues)contentValues, (String)string2);
    }

    public static void cursorDoubleToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cursorDoubleToContentValuesIfPresent", $$robo$$android_database_DatabaseUtils$cursorDoubleToContentValuesIfPresent(android.database.Cursor android.content.ContentValues java.lang.String ), 0, (Cursor)cursor, (ContentValues)contentValues, (String)string2);
    }

    public static void createDbFromSqlStatements(Context context, String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrapStatic("createDbFromSqlStatements", $$robo$$android_database_DatabaseUtils$createDbFromSqlStatements(android.content.Context java.lang.String int java.lang.String ), 0, (Context)context, (String)string2, (int)n, (String)string3);
    }

    public static int getSqlStatementType(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSqlStatementType", $$robo$$android_database_DatabaseUtils$getSqlStatementType(java.lang.String ), 0, (String)string2);
    }

    public static String[] appendSelectionArgs(String[] stringArray, String[] stringArray2) {
        return InvokeDynamicSupport.bootstrapStatic("appendSelectionArgs", $$robo$$android_database_DatabaseUtils$appendSelectionArgs(java.lang.String[] java.lang.String[] ), 0, (String[])stringArray, (String[])stringArray2);
    }

    public static int findRowIdColumnIndex(String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findRowIdColumnIndex", $$robo$$android_database_DatabaseUtils$findRowIdColumnIndex(java.lang.String[] ), 0, (String[])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(DatabaseUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatabaseUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static class InsertHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SQLiteDatabase mDb;
        private String mTableName;
        private HashMap<String, Integer> mColumns;
        private String mInsertSQL;
        private SQLiteStatement mInsertStatement;
        private SQLiteStatement mReplaceStatement;
        private SQLiteStatement mPreparedStatement;
        public static int TABLE_INFO_PRAGMA_COLUMNNAME_INDEX = 1;
        public static int TABLE_INFO_PRAGMA_DEFAULT_INDEX = 4;

        private void $$robo$$android_database_DatabaseUtils_InsertHelper$__constructor__(SQLiteDatabase db, String tableName) {
            this.mInsertSQL = null;
            this.mInsertStatement = null;
            this.mReplaceStatement = null;
            this.mPreparedStatement = null;
            this.mDb = db;
            this.mTableName = tableName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$buildSQL() throws SQLException {
            StringBuilder sb = new StringBuilder(128);
            sb.append("INSERT INTO ");
            sb.append(this.mTableName);
            sb.append(" (");
            StringBuilder sbv = new StringBuilder(128);
            sbv.append("VALUES (");
            int i = 1;
            try (Cursor cur = null;){
                cur = this.mDb.rawQuery("PRAGMA table_info(" + this.mTableName + ")", null);
                this.mColumns = new HashMap(cur.getCount());
                while (cur.moveToNext()) {
                    String columnName = cur.getString(1);
                    String defaultValue = cur.getString(4);
                    this.mColumns.put(columnName, i);
                    sb.append("'");
                    sb.append(columnName);
                    sb.append("'");
                    if (defaultValue == null) {
                        sbv.append("?");
                    } else {
                        sbv.append("COALESCE(?, ");
                        sbv.append(defaultValue);
                        sbv.append(")");
                    }
                    sb.append(i == cur.getCount() ? ") " : ", ");
                    sbv.append(i == cur.getCount() ? ");" : ", ");
                    ++i;
                }
            }
            sb.append((CharSequence)sbv);
            this.mInsertSQL = sb.toString();
        }

        private final SQLiteStatement $$robo$$android_database_DatabaseUtils_InsertHelper$getStatement(boolean allowReplace) throws SQLException {
            if (allowReplace) {
                if (this.mReplaceStatement == null) {
                    if (this.mInsertSQL == null) {
                        this.buildSQL();
                    }
                    String replaceSQL = "INSERT OR REPLACE" + this.mInsertSQL.substring(6);
                    this.mReplaceStatement = this.mDb.compileStatement(replaceSQL);
                }
                return this.mReplaceStatement;
            }
            if (this.mInsertStatement == null) {
                if (this.mInsertSQL == null) {
                    this.buildSQL();
                }
                this.mInsertStatement = this.mDb.compileStatement(this.mInsertSQL);
            }
            return this.mInsertStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long $$robo$$android_database_DatabaseUtils_InsertHelper$insertInternal(ContentValues values, boolean allowReplace) {
            this.mDb.beginTransactionNonExclusive();
            try {
                SQLiteStatement stmt = this.getStatement(allowReplace);
                stmt.clearBindings();
                for (Map.Entry<String, Object> e : values.valueSet()) {
                    String key = e.getKey();
                    int i = this.getColumnIndex(key);
                    DatabaseUtils.bindObjectToProgram(stmt, i, e.getValue());
                }
                long result = stmt.executeInsert();
                this.mDb.setTransactionSuccessful();
                long l = result;
                return l;
            }
            catch (SQLException e) {
                Log.e("DatabaseUtils", "Error inserting " + values + " into table  " + this.mTableName, e);
                long l = -1L;
                return l;
            }
            finally {
                this.mDb.endTransaction();
            }
        }

        private final int $$robo$$android_database_DatabaseUtils_InsertHelper$getColumnIndex(String key) {
            this.getStatement(false);
            Integer index = this.mColumns.get(key);
            if (index == null) {
                throw new IllegalArgumentException("column '" + key + "' is invalid");
            }
            return index;
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, double value) {
            this.mPreparedStatement.bindDouble(index, value);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, float value) {
            this.mPreparedStatement.bindDouble(index, value);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, long value) {
            this.mPreparedStatement.bindLong(index, value);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, int value) {
            this.mPreparedStatement.bindLong(index, value);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, boolean value) {
            this.mPreparedStatement.bindLong(index, value ? 1L : 0L);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bindNull(int index) {
            this.mPreparedStatement.bindNull(index);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, byte[] value) {
            if (value == null) {
                this.mPreparedStatement.bindNull(index);
            } else {
                this.mPreparedStatement.bindBlob(index, value);
            }
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int index, String value) {
            if (value == null) {
                this.mPreparedStatement.bindNull(index);
            } else {
                this.mPreparedStatement.bindString(index, value);
            }
        }

        private final long $$robo$$android_database_DatabaseUtils_InsertHelper$insert(ContentValues values) {
            return this.insertInternal(values, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long $$robo$$android_database_DatabaseUtils_InsertHelper$execute() {
            if (this.mPreparedStatement == null) {
                throw new IllegalStateException("you must prepare this inserter before calling execute");
            }
            try {
                long l = this.mPreparedStatement.executeInsert();
                return l;
            }
            catch (SQLException e) {
                Log.e("DatabaseUtils", "Error executing InsertHelper with table " + this.mTableName, e);
                long l = -1L;
                return l;
            }
            finally {
                this.mPreparedStatement = null;
            }
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$prepareForInsert() {
            this.mPreparedStatement = this.getStatement(false);
            this.mPreparedStatement.clearBindings();
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$prepareForReplace() {
            this.mPreparedStatement = this.getStatement(true);
            this.mPreparedStatement.clearBindings();
        }

        private final long $$robo$$android_database_DatabaseUtils_InsertHelper$replace(ContentValues values) {
            return this.insertInternal(values, true);
        }

        private final void $$robo$$android_database_DatabaseUtils_InsertHelper$close() {
            if (this.mInsertStatement != null) {
                this.mInsertStatement.close();
                this.mInsertStatement = null;
            }
            if (this.mReplaceStatement != null) {
                this.mReplaceStatement.close();
                this.mReplaceStatement = null;
            }
            this.mInsertSQL = null;
            this.mColumns = null;
        }

        private void __constructor__(SQLiteDatabase sQLiteDatabase, String string2) {
            this.$$robo$$android_database_DatabaseUtils_InsertHelper$__constructor__(sQLiteDatabase, string2);
        }

        public InsertHelper(SQLiteDatabase sQLiteDatabase, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_DatabaseUtils_InsertHelper$__constructor__(android.database.sqlite.SQLiteDatabase java.lang.String ), 0, this, sQLiteDatabase, string2);
        }

        private void buildSQL() throws SQLException {
            InvokeDynamicSupport.bootstrap("buildSQL", $$robo$$android_database_DatabaseUtils_InsertHelper$buildSQL(), 0, this);
        }

        private SQLiteStatement getStatement(boolean bl) throws SQLException {
            return InvokeDynamicSupport.bootstrap("getStatement", $$robo$$android_database_DatabaseUtils_InsertHelper$getStatement(boolean ), 0, this, bl);
        }

        private long insertInternal(ContentValues contentValues, boolean bl) {
            return (long)InvokeDynamicSupport.bootstrap("insertInternal", $$robo$$android_database_DatabaseUtils_InsertHelper$insertInternal(android.content.ContentValues boolean ), 0, this, contentValues, bl);
        }

        public int getColumnIndex(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getColumnIndex", $$robo$$android_database_DatabaseUtils_InsertHelper$getColumnIndex(java.lang.String ), 0, this, string2);
        }

        public void bind(int n, double d) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int double ), 0, this, n, d);
        }

        public void bind(int n, float f) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int float ), 0, this, n, f);
        }

        public void bind(int n, long l) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int long ), 0, this, n, l);
        }

        public void bind(int n, int n2) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int int ), 0, this, n, n2);
        }

        public void bind(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int boolean ), 0, this, n, bl);
        }

        public void bindNull(int n) {
            InvokeDynamicSupport.bootstrap("bindNull", $$robo$$android_database_DatabaseUtils_InsertHelper$bindNull(int ), 0, this, n);
        }

        public void bind(int n, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int byte[] ), 0, this, n, byArray);
        }

        public void bind(int n, String string2) {
            InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_DatabaseUtils_InsertHelper$bind(int java.lang.String ), 0, this, n, string2);
        }

        public long insert(ContentValues contentValues) {
            return (long)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_database_DatabaseUtils_InsertHelper$insert(android.content.ContentValues ), 0, this, contentValues);
        }

        public long execute() {
            return (long)InvokeDynamicSupport.bootstrap("execute", $$robo$$android_database_DatabaseUtils_InsertHelper$execute(), 0, this);
        }

        public void prepareForInsert() {
            InvokeDynamicSupport.bootstrap("prepareForInsert", $$robo$$android_database_DatabaseUtils_InsertHelper$prepareForInsert(), 0, this);
        }

        public void prepareForReplace() {
            InvokeDynamicSupport.bootstrap("prepareForReplace", $$robo$$android_database_DatabaseUtils_InsertHelper$prepareForReplace(), 0, this);
        }

        public long replace(ContentValues contentValues) {
            return (long)InvokeDynamicSupport.bootstrap("replace", $$robo$$android_database_DatabaseUtils_InsertHelper$replace(android.content.ContentValues ), 0, this, contentValues);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_DatabaseUtils_InsertHelper$close(), 0, this);
        }

        public /* synthetic */ InsertHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsertHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

