/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.DatabaseUtils;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MatrixCursor
extends AbstractCursor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String[] columnNames;
    private Object[] data;
    private int rowCount;
    private int columnCount;

    private void $$robo$$android_database_MatrixCursor$__constructor__(String[] columnNames, int initialCapacity) {
        this.rowCount = 0;
        this.columnNames = columnNames;
        this.columnCount = columnNames.length;
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.data = new Object[this.columnCount * initialCapacity];
    }

    private void $$robo$$android_database_MatrixCursor$__constructor__(String[] columnNames) {
    }

    private final Object $$robo$$android_database_MatrixCursor$get(int column) {
        if (column < 0 || column >= this.columnCount) {
            throw new CursorIndexOutOfBoundsException("Requested column: " + column + ", # of columns: " + this.columnCount);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.mPos >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        return this.data[this.mPos * this.columnCount + column];
    }

    private final RowBuilder $$robo$$android_database_MatrixCursor$newRow() {
        int row = this.rowCount++;
        int endIndex = this.rowCount * this.columnCount;
        this.ensureCapacity(endIndex);
        return new RowBuilder(this, row);
    }

    private final void $$robo$$android_database_MatrixCursor$addRow(Object[] columnValues) {
        if (columnValues.length != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.length = " + columnValues.length);
        }
        int start = this.rowCount++ * this.columnCount;
        this.ensureCapacity(start + this.columnCount);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)columnValues, (int)0, (Object)this.data, (int)start, (int)this.columnCount);
    }

    private final void $$robo$$android_database_MatrixCursor$addRow(Iterable<?> columnValues) {
        int start = this.rowCount * this.columnCount;
        int end = start + this.columnCount;
        this.ensureCapacity(end);
        if (columnValues instanceof ArrayList) {
            this.addRow((ArrayList)columnValues, start);
            return;
        }
        int current = start;
        Object[] localData = this.data;
        for (Object columnValue : columnValues) {
            if (current == end) {
                throw new IllegalArgumentException("columnValues.size() > columnNames.length");
            }
            localData[current++] = columnValue;
        }
        if (current != end) {
            throw new IllegalArgumentException("columnValues.size() < columnNames.length");
        }
        ++this.rowCount;
    }

    private final void $$robo$$android_database_MatrixCursor$addRow(ArrayList<?> columnValues, int start) {
        int size = columnValues.size();
        if (size != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.size() = " + size);
        }
        ++this.rowCount;
        Object[] localData = this.data;
        for (int i = 0; i < size; ++i) {
            localData[start + i] = columnValues.get(i);
        }
    }

    private final void $$robo$$android_database_MatrixCursor$ensureCapacity(int size) {
        if (size > this.data.length) {
            Object[] oldData = this.data;
            int newSize = this.data.length * 2;
            if (newSize < size) {
                newSize = size;
            }
            this.data = new Object[newSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldData, (int)0, (Object)this.data, (int)0, (int)oldData.length);
        }
    }

    private final int $$robo$$android_database_MatrixCursor$getCount() {
        return this.rowCount;
    }

    private final String[] $$robo$$android_database_MatrixCursor$getColumnNames() {
        return this.columnNames;
    }

    private final String $$robo$$android_database_MatrixCursor$getString(int column) {
        Object value = this.get(column);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private final short $$robo$$android_database_MatrixCursor$getShort(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return Short.parseShort(value.toString());
    }

    private final int $$robo$$android_database_MatrixCursor$getInt(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private final long $$robo$$android_database_MatrixCursor$getLong(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private final float $$robo$$android_database_MatrixCursor$getFloat(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return Float.parseFloat(value.toString());
    }

    private final double $$robo$$android_database_MatrixCursor$getDouble(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    private final byte[] $$robo$$android_database_MatrixCursor$getBlob(int column) {
        Object value = this.get(column);
        return (byte[])value;
    }

    private final int $$robo$$android_database_MatrixCursor$getType(int column) {
        return DatabaseUtils.getTypeOfObject(this.get(column));
    }

    private final boolean $$robo$$android_database_MatrixCursor$isNull(int column) {
        return this.get(column) == null;
    }

    private void __constructor__(String[] stringArray, int n) {
        this.$$robo$$android_database_MatrixCursor$__constructor__(stringArray, n);
    }

    public MatrixCursor(String[] stringArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_MatrixCursor$__constructor__(java.lang.String[] int ), 0, this, stringArray, n);
    }

    private void __constructor__(String[] stringArray) {
        this.$$robo$$android_database_MatrixCursor$__constructor__(stringArray);
    }

    public MatrixCursor(String[] stringArray) {
        this(stringArray, 16);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_MatrixCursor$__constructor__(java.lang.String[] ), 0, this, stringArray);
    }

    private Object get(int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_database_MatrixCursor$get(int ), 0, this, n);
    }

    public RowBuilder newRow() {
        return InvokeDynamicSupport.bootstrap("newRow", $$robo$$android_database_MatrixCursor$newRow(), 0, this);
    }

    public void addRow(Object[] objectArray) {
        InvokeDynamicSupport.bootstrap("addRow", $$robo$$android_database_MatrixCursor$addRow(java.lang.Object[] ), 0, this, objectArray);
    }

    public void addRow(Iterable<?> iterable) {
        InvokeDynamicSupport.bootstrap("addRow", $$robo$$android_database_MatrixCursor$addRow(java.lang.Iterable<?> ), 0, this, iterable);
    }

    private void addRow(ArrayList<?> arrayList, int n) {
        InvokeDynamicSupport.bootstrap("addRow", $$robo$$android_database_MatrixCursor$addRow(java.util.ArrayList<?> int ), 0, this, arrayList, n);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_database_MatrixCursor$ensureCapacity(int ), 0, this, n);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_database_MatrixCursor$getCount(), 0, this);
    }

    @Override
    public String[] getColumnNames() {
        return InvokeDynamicSupport.bootstrap("getColumnNames", $$robo$$android_database_MatrixCursor$getColumnNames(), 0, this);
    }

    @Override
    public String getString(int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_database_MatrixCursor$getString(int ), 0, this, n);
    }

    @Override
    public short getShort(int n) {
        return (short)InvokeDynamicSupport.bootstrap("getShort", $$robo$$android_database_MatrixCursor$getShort(int ), 0, this, n);
    }

    @Override
    public int getInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_database_MatrixCursor$getInt(int ), 0, this, n);
    }

    @Override
    public long getLong(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_database_MatrixCursor$getLong(int ), 0, this, n);
    }

    @Override
    public float getFloat(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_database_MatrixCursor$getFloat(int ), 0, this, n);
    }

    @Override
    public double getDouble(int n) {
        return (double)InvokeDynamicSupport.bootstrap("getDouble", $$robo$$android_database_MatrixCursor$getDouble(int ), 0, this, n);
    }

    @Override
    public byte[] getBlob(int n) {
        return InvokeDynamicSupport.bootstrap("getBlob", $$robo$$android_database_MatrixCursor$getBlob(int ), 0, this, n);
    }

    @Override
    public int getType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_database_MatrixCursor$getType(int ), 0, this, n);
    }

    @Override
    public boolean isNull(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNull", $$robo$$android_database_MatrixCursor$isNull(int ), 0, this, n);
    }

    public /* synthetic */ MatrixCursor() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MatrixCursor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class RowBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int row;
        private int endIndex;
        private int index;
        /* synthetic */ MatrixCursor this$0;

        private void $$robo$$android_database_MatrixCursor_RowBuilder$__constructor__(MatrixCursor matrixCursor, int row) {
            this.row = row;
            this.index = row * matrixCursor.columnCount;
            this.endIndex = this.index + matrixCursor.columnCount;
        }

        private final RowBuilder $$robo$$android_database_MatrixCursor_RowBuilder$add(Object columnValue) {
            if (this.index == this.endIndex) {
                throw new CursorIndexOutOfBoundsException("No more columns left.");
            }
            ((MatrixCursor)this.this$0).data[this.index++] = columnValue;
            return this;
        }

        private final RowBuilder $$robo$$android_database_MatrixCursor_RowBuilder$add(String columnName, Object value) {
            for (int i = 0; i < this.this$0.columnNames.length; ++i) {
                if (!columnName.equals(this.this$0.columnNames[i])) continue;
                ((MatrixCursor)this.this$0).data[this.row * ((MatrixCursor)this.this$0).columnCount + i] = value;
            }
            return this;
        }

        private void __constructor__(MatrixCursor matrixCursor, int n) {
            this.$$robo$$android_database_MatrixCursor_RowBuilder$__constructor__(matrixCursor, n);
        }

        RowBuilder(MatrixCursor matrixCursor, int n) {
            this.this$0 = matrixCursor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_MatrixCursor_RowBuilder$__constructor__(android.database.MatrixCursor int ), 0, this, matrixCursor, n);
        }

        public RowBuilder add(Object object) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_database_MatrixCursor_RowBuilder$add(java.lang.Object ), 0, this, object);
        }

        public RowBuilder add(String string2, Object object) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_database_MatrixCursor_RowBuilder$add(java.lang.String java.lang.Object ), 0, this, string2, object);
        }

        public /* synthetic */ RowBuilder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RowBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

